

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSClientPropTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSClientPropTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSClientPropTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSClientPropTableChange]
  delete from GXDBVersions where name = 'APP_CCSClientPropTableChange' and type = 6
END
GO

	CREATE TRIGGER APP_CCSClientPropTableChange
	ON APP_ClientProp
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON

		-- IF Temp Table exist then it is a CCM Operation and CCS should do nothing
		-- with the CCM Data being inserted into the Commserv Database
		IF OBJECT_ID('tempdb..#CCM_IMPORT_IS_RUNNING') IS NOT NULL
		BEGIN
			RETURN;
		END

		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 2		-- APP_ClientProp Table Type

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
			SELECT
					i.componentNameId, @TableType, 0, @currentTime, i.id
				FROM
					INSERTED i
				WHERE
					i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
			UNION
			SELECT
					i.componentNameId, @TableType, 1, @currentTime, i.id
				FROM
					INSERTED i
				WHERE
					i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
			UNION
			SELECT
					d.componentNameId, @TableType, 2, @currentTime, d.id
				FROM
					DELETED d
				WHERE
					d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted

	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSClientPropTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSClientPropTableChange' AND revision = '1.5.54.1')

  insert into GXDBVersions values(6, 'APP_CCSClientPropTableChange',  '1.5.54.1', 'APP_CCSClientPropTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

