

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSClientGroupAssocTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSClientGroupAssocTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSClientGroupAssocTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSClientGroupAssocTableChange]
  delete from GXDBVersions where name = 'APP_CCSClientGroupAssocTableChange' and type = 6
END
GO

GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TRIGGER APP_CCSClientGroupAssocTableChange
ON APP_ClientGroupAssoc
AFTER INSERT,UPDATE,DELETE
AS
BEGIN
	SET NOCOUNT ON
	-- IF Temp Table exist then it is a CCM Operation and CCS should do nothing
	-- with the CCM Data being inserted into the Commserv Database
	IF OBJECT_ID('tempdb..#CCM_IMPORT_IS_RUNNING') IS NOT NULL
	BEGIN
		RETURN;
	END
	DECLARE	@currentTime	INT = DATEDIFF(second, '01/01/1970', GETUTCDATE())
	DECLARE @TableType		INT = 26		-- APP_ClientGroupAssoc Table Type
	-- Update the CCS Trigger Table with changes to be forwarded to CCS Clients
	INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1, rowId2)
		SELECT
				i.clientId, @TableType, 0, @currentTime, i.clientGroupId, i.clientId
			FROM
				INSERTED i
				LEFT OUTER JOIN DELETED d
					ON i.clientId = d.clientId
						AND i.clientGroupId = d.clientGroupId
			WHERE
				d.clientId IS NULL	-- new rows inserted
		UNION
		SELECT
				i.clientId, @TableType, 1, @currentTime, i.clientGroupId, i.clientId
			FROM
				INSERTED i
				INNER JOIN DELETED d
					ON i.clientId = d.clientId
						AND i.clientGroupId = d.clientGroupId	-- updated rows
		UNION
		SELECT
				d.clientId, @TableType, 2, @currentTime, d.clientGroupId, d.clientId
			FROM
				DELETED d
				LEFT OUTER JOIN INSERTED i
					ON d.clientId = i.clientId
						AND d.clientGroupId = i.clientGroupId
			WHERE
				i.clientId IS NULL	-- existing rows deleted
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSClientGroupAssocTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSClientGroupAssocTableChange' AND revision = '1.1.48.7')

  insert into GXDBVersions values(6, 'APP_CCSClientGroupAssocTableChange',  '1.1.48.7', 'APP_CCSClientGroupAssocTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

