

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSBSFilterFileTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSBSFilterFileTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSBSFilterFileTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSBSFilterFileTableChange]
  delete from GXDBVersions where name = 'APP_CCSBSFilterFileTableChange' and type = 6
END
GO

GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TRIGGER APP_CCSBSFilterFileTableChange
ON APP_BackupSetFilterFile
AFTER INSERT,UPDATE,DELETE
AS
BEGIN
	SET NOCOUNT ON
	-- IF Temp Table exist then it is a CCM Operation and CCS should do nothing
	-- with the CCM Data being inserted into the Commserv Database
	IF OBJECT_ID('tempdb..#CCM_IMPORT_IS_RUNNING') IS NOT NULL
	BEGIN
		RETURN;
	END
	DECLARE	@currentTime INT = DATEDIFF(second, '01/01/1970', GETUTCDATE())
	DECLARE @TableType INT = 15		-- APP_BackupSetFilterFile Table Type
	INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
		SELECT
				a.clientId, @TableType, 0, @currentTime, i.componentNameId
			FROM
				INSERTED i
				INNER JOIN APP_Application a  WITH (READUNCOMMITTED)
					ON a.backupSet = i.componentNameId
			WHERE
				i.componentNameId NOT IN (SELECT d.componentNameId FROM DELETED d)	-- new rows inserted
		UNION
		SELECT
				a.clientId, @TableType, 1, @currentTime, i.componentNameId
			FROM
				INSERTED i
				INNER JOIN APP_Application a  WITH (READUNCOMMITTED)
					ON a.backupSet = i.componentNameId
			WHERE
				i.componentNameId IN (SELECT d.componentNameId FROM DELETED d)		-- updated rows
		UNION
		SELECT
				aa.clientId, @TableType, 2, @currentTime, d.componentNameId
			FROM
				DELETED d
				-- Use the Deletion Audit Application Table instead will have a row whereas the APP_Application Table may not.
				--INNER JOIN APP_Application a  WITH (READUNCOMMITTED)
				--	ON a.backupSet = d.componentNameId
				INNER JOIN APP_CCSApplicationDelAudit aa  WITH (READUNCOMMITTED)
					ON aa.backupSetId = d.componentNameId
			WHERE
				d.componentNameId NOT IN (SELECT i.componentNameId FROM INSERTED i)	-- existing rows deleted
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSBSFilterFileTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSBSFilterFileTableChange' AND revision = '1.3.52.2')

  insert into GXDBVersions values(6, 'APP_CCSBSFilterFileTableChange',  '1.3.52.2', 'APP_CCSBSFilterFileTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

