

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSApplicationTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSApplicationTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSApplicationTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSApplicationTableChange]
  delete from GXDBVersions where name = 'APP_CCSApplicationTableChange' and type = 6
END
GO

GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TRIGGER APP_CCSApplicationTableChange
ON APP_Application
AFTER INSERT,UPDATE,DELETE
AS
BEGIN
	SET NOCOUNT ON
	-- IF Temp Table exist then it is a CCM Operation and CCS should do nothing
	-- with the CCM Data being inserted into the Commserv Database
	IF OBJECT_ID('tempdb..#CCM_IMPORT_IS_RUNNING') IS NOT NULL
	BEGIN
		RETURN;
	END
	DECLARE	@currentTime INT = DATEDIFF(second, '01/01/1970', GETUTCDATE())
	DECLARE @TableType INT = 4		-- APP_Application Table Type
	INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1)
		SELECT
				i.clientId, @TableType, 0, @currentTime, i.id
			FROM
				INSERTED i
			WHERE
				i.id NOT IN (SELECT d.id FROM DELETED d)	-- new rows inserted
		UNION
		SELECT
				i.clientId, @TableType, 1, @currentTime, i.id
			FROM
				INSERTED i
			WHERE
				i.id IN (SELECT d.id FROM DELETED d)		-- updated rows
		UNION
		SELECT
				d.clientId, @TableType, 2, @currentTime, d.id
			FROM
				DELETED d
			WHERE
				d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted
	-- Captured all Application Object Ids for the deleted row
	INSERT INTO APP_CCSApplicationDelAudit (deleted, clientId, appTypeId, instanceId, backupSetId, subClientId)
		SELECT
			@currentTime, d.clientId, d.appTypeId, d.instance, d.backupSet, d.id
		FROM
			DELETED d
		WHERE
			d.id NOT IN (SELECT i.id FROM INSERTED i)	-- existing rows deleted
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSApplicationTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSApplicationTableChange' AND revision = '1.5.54.2')

  insert into GXDBVersions values(6, 'APP_CCSApplicationTableChange',  '1.5.54.2', 'APP_CCSApplicationTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

