

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSAppTypeGroupTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSAppTypeGroupTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSAppTypeGroupTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSAppTypeGroupTableChange]
  delete from GXDBVersions where name = 'APP_CCSAppTypeGroupTableChange' and type = 6
END
GO

	GO
	SET QUOTED_IDENTIFIER ON
	GO
	CREATE TRIGGER APP_CCSAppTypeGroupTableChange
	ON APP_AppTypeGroup
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON

		-- IF Temp Table exist then it is a CCM Operation and CCS should do nothing
		-- with the CCM Data being inserted into the Commserv Database
		IF OBJECT_ID('tempdb..#CCM_IMPORT_IS_RUNNING') IS NOT NULL
		BEGIN
			RETURN;
		END

		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 23		-- APP_AppTypeGroup Table Type
		DECLARE @AllClients INT = -1

		DECLARE @apps TABLE (appTypeId	INT PRIMARY KEY)
		INSERT INTO @apps (appTypeId)
			SELECT DISTINCT
				f.value('@value', 'INT') appTypeId
			FROM APP_CCSXMLMapping m WITH(NOLOCK)
				CROSS APPLY m.filters.nodes('/Filters/Column/Filter') d(f)
			WHERE m.id = 24		-- APP_AppTypeGroupAssoc Type
				AND f.value('../@name', 'NVARCHAR(128)') = N'appTypeId'
				AND f.value('../@opType', 'NVARCHAR(128)') = N'INCLUDE'

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowId1, rowId2)
			SELECT
					@AllClients, @TableType, 0, @currentTime, i.typeOfGroup, i.appTypeGroupId
				FROM
					INSERTED i
					INNER JOIN APP_AppTypeGroupAssoc ag WITH(NOLOCK) ON
						ag.appTypeId IN (SELECT appTypeId FROM @apps)
						AND i.appTypeGroupId = ag.appGroupId
					LEFT OUTER JOIN DELETED d
						ON i.typeOfGroup = d.typeOfGroup
							AND i.appTypeGroupId = d.appTypeGroupId
				WHERE
					d.typeOfGroup IS NULL	-- new rows inserted
			UNION
			SELECT
					@AllClients, @TableType, 1, @currentTime, i.typeOfGroup, i.appTypeGroupId
				FROM
					INSERTED i
					INNER JOIN APP_AppTypeGroupAssoc ag WITH(NOLOCK) ON
						ag.appTypeId IN (SELECT appTypeId FROM @apps)
						AND i.appTypeGroupId = ag.appGroupId
					INNER JOIN DELETED d
						ON i.typeOfGroup = d.typeOfGroup
							AND i.appTypeGroupId = d.appTypeGroupId	-- updated rows
			UNION
			SELECT
					@AllClients, @TableType, 2, @currentTime, d.typeOfGroup, d.appTypeGroupId
				FROM
					DELETED d
					INNER JOIN APP_AppTypeGroupAssoc ag WITH(NOLOCK) ON
						ag.appTypeId IN (SELECT appTypeId FROM @apps)
						AND d.appTypeGroupId = ag.appGroupId
					LEFT OUTER JOIN INSERTED i
						ON d.typeOfGroup = i.typeOfGroup
							AND d.appTypeGroupId = i.appTypeGroupId
				WHERE
					i.typeOfGroup IS NULL	-- existing rows deleted

	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSAppTypeGroupTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSAppTypeGroupTableChange' AND revision = '1.1.48.2')

  insert into GXDBVersions values(6, 'APP_CCSAppTypeGroupTableChange',  '1.1.48.2', 'APP_CCSAppTypeGroupTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

