

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_CCSAppTypeGroupAssocTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_CCSAppTypeGroupAssocTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_CCSAppTypeGroupAssocTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_CCSAppTypeGroupAssocTableChange]
  delete from GXDBVersions where name = 'APP_CCSAppTypeGroupAssocTableChange' and type = 6
END
GO

	GO
	SET QUOTED_IDENTIFIER ON
	GO
	CREATE TRIGGER APP_CCSAppTypeGroupAssocTableChange
	ON APP_AppTypeGroupAssoc
	AFTER INSERT,UPDATE,DELETE
	AS
	BEGIN
		SET NOCOUNT ON

		-- IF Temp Table exist then it is a CCM Operation and CCS should do nothing
		-- with the CCM Data being inserted into the Commserv Database
		IF OBJECT_ID('tempdb..#CCM_IMPORT_IS_RUNNING') IS NOT NULL
		BEGIN
			RETURN;
		END

		DECLARE	@currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @TableType INT = 24		-- APP_AppTypeGroupAssoc Table Type
		DECLARE @AllClients INT = -1

		DECLARE @apps TABLE (appTypeId	INT PRIMARY KEY)
		INSERT INTO @apps (appTypeId)
			SELECT DISTINCT
				f.value('@value', 'INT') appTypeId
			FROM APP_CCSXMLMapping m WITH(NOLOCK)
				CROSS APPLY m.filters.nodes('/Filters/Column/Filter') d(f)
			WHERE m.id = @TableType
				AND f.value('../@name', 'NVARCHAR(128)') = N'appTypeId'
				AND f.value('../@opType', 'NVARCHAR(128)') = N'INCLUDE'

		INSERT INTO APP_CCSTriggerRows (clientId, tableType, opCode, modified, rowXmlKeys)
			SELECT
					@AllClients, @TableType, 0, @currentTime,
					(SELECT
						'typeOfGroup' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.typeOfGroup AS 'tableKeys/@columnValue',
						NULL,
						'appGroupId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.appGroupId AS 'tableKeys/@columnValue',
						NULL,
						'appTypeId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.appTypeId AS 'tableKeys/@columnValue',
						NULL
					FOR XML PATH('Keys'))
				FROM
					INSERTED i
					INNER JOIN @apps a ON
						a.appTypeId = i.appTypeId
					LEFT OUTER JOIN DELETED d
						ON i.typeOfGroup = d.typeOfGroup
							AND i.appGroupId = d.appGroupId
							AND i.appTypeId = d.appTypeId
				WHERE
					d.typeOfGroup IS NULL	-- new rows inserted
			UNION
			SELECT
					@AllClients, @TableType, 1, @currentTime,
					(SELECT
						'typeOfGroup' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.typeOfGroup AS 'tableKeys/@columnValue',
						NULL,
						'appGroupId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.appGroupId AS 'tableKeys/@columnValue',
						NULL,
						'appTypeId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						i.appTypeId AS 'tableKeys/@columnValue',
						NULL
					FOR XML PATH('Keys'))
				FROM
					INSERTED i
					INNER JOIN @apps a ON
						a.appTypeId = i.appTypeId
					INNER JOIN DELETED d
						ON i.typeOfGroup = d.typeOfGroup
							AND i.appGroupId = d.appGroupId	-- updated rows
							AND i.appTypeId = d.appTypeId
			UNION
			SELECT
					@AllClients, @TableType, 2, @currentTime,
					(SELECT
						'typeOfGroup' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						d.typeOfGroup AS 'tableKeys/@columnValue',
						NULL,
						'appGroupId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						d.appGroupId AS 'tableKeys/@columnValue',
						NULL,
						'appTypeId' AS 'tableKeys/@columnName',
						1 AS 'tableKeys/@columnType',
						d.appTypeId AS 'tableKeys/@columnValue',
						NULL
					FOR XML PATH('Keys'))
				FROM
					DELETED d
					INNER JOIN @apps a ON
						a.appTypeId = d.appTypeId
					LEFT OUTER JOIN INSERTED i
						ON d.typeOfGroup = i.typeOfGroup
							AND d.appGroupId = i.appGroupId
							AND d.appTypeId = i.appTypeId
				WHERE
					i.typeOfGroup IS NULL	-- existing rows deleted

	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_CCSAppTypeGroupAssocTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_CCSAppTypeGroupAssocTableChange' AND revision = '1.1.48.2')

  insert into GXDBVersions values(6, 'APP_CCSAppTypeGroupAssocTableChange',  '1.1.48.2', 'APP_CCSAppTypeGroupAssocTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

