

--  ------------  Generated from [../../../Source/CommServer/Db/Trigger/APP_BackupSetPropTableChange.trigger] ---------- 


SET NOCOUNT ON


print '... Creating Trigger: APP_BackupSetPropTableChange'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[APP_BackupSetPropTableChange]') and OBJECTPROPERTY(id, N'IsTrigger') = 1)
BEGIN
  drop trigger [dbo].[APP_BackupSetPropTableChange]
  delete from GXDBVersions where name = 'APP_BackupSetPropTableChange' and type = 6
END
GO

	CREATE TRIGGER [dbo].[APP_BackupSetPropTableChange]
	ON [dbo].[APP_BackupSetProp]
	AFTER INSERT, UPDATE
	AS
	BEGIN
		SET NOCOUNT ON;
        --Convert password to v5 if any password properties values are updated
	    --skip conversion if value is 1,  CSRecoveryAssistant staging mode sets all passwords to dummy vlaue 1.
		DECLARE @BackupSetPropTableId INT = 51 -- APP_BackupSetProp table id
		IF EXISTS(SELECT 1 FROM INSERTED INS JOIN APP_CredProps ACP WITH(NOLOCK)
							ON ACP.tableId = @BackupSetPropTableId AND ACP.attrPwdName = INS.attrName AND ACP.cs_attrPwdName = CHECKSUM(INS.attrName))
		BEGIN
			UPDATE ABP SET attrVal = dbo.pswConvertV3ToV5(ABP.attrVal) FROM APP_BackupSetProp ABP JOIN INSERTED INS
				ON ABP.id = INS.id
			JOIN APP_CredProps ACP WITH (NOLOCK)
				ON ACP.tableId = @BackupSetPropTableId AND ACP.attrPwdName = INS.attrName AND ACP.cs_attrPwdName = CHECKSUM(INS.attrName)
		END
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Trigger [APP_BackupSetPropTableChange]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 6 AND name = 'APP_BackupSetPropTableChange' AND revision = '1.1.2.6')

  insert into GXDBVersions values(6, 'APP_BackupSetPropTableChange',  '1.1.2.6', 'APP_BackupSetPropTableChange', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF

