

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_getCommcellForUser.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='wr_getCommcellForUser')
BEGIN
	print '>>> Drop Stored Procedure: wr_getCommcellForUser <<<'
	drop procedure wr_getCommcellForUser
END
IF EXISTS (select * from GxQscripts where name='wr_getCommcellForUser')
	delete from GxQscripts where name = 'wr_getCommcellForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_getCommcellForUser')
	delete from GXDBVersions where aliasname = 'wr_getCommcellForUser'
GO
print '... Creating Procedure: wr_getCommcellForUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_getCommcellForUser
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @request XML
AS
  DECLARE @response xml
/*
Message CloudMetricsUserReq
{
       -- id of the user initiated report
       UserEntity                 user
}
Message CloudCompany
{
	UserGroupEntity company
	ClientGroupEntity commcellGroup	--Hidden Default Client Group
	int noOfCommCells
	list<CommCellEntity> commcells
	int flags
	int status
	string details
}
Message CloudMetricsUserResp
{
       -- id of the user initiated report
       UserEntity                        user
       list<CommCellEntity> commcells
       list<ClientGroupEntity> commcellGroups
	   list<CloudCompany> companies
       int	surveycapability
	   int	noOfCompanies
	   int	noOfCommcells
	   int	noOfCommcellGroups
}
*/
	DECLARE @userId INT =-1
	DECLARE @user   XML
	IF ((SELECT @request.exist('/WebReport_CloudMetricsUserReq/user/@userId')) = 1)
	BEGIN
		SET @userId     = ISNULL(@request.value('(/WebReport_CloudMetricsUserReq/user/@userId)[1]', 'integer'), 0)
		SET @user     =   @request.query('/WebReport_CloudMetricsUserReq/user')
	END
	DECLARE @noOfCommcells INT
	DECLARE @commcells xml
    DECLARE @noCommcellGroups INT
	DECLARE @commCellGroups xml
	DECLARE @noOfCompanies INT
	DECLARE @customerCompanies xml
	IF object_id('tempdb.dbo.#companies') IS NOT NULL DROP TABLE #companies
	CREATE TABLE #companies(userGroupId INT)
	DECLARE @SERVEY_CAPABILITY INT = 4
	DECLARE @CloudCapabilities INT = 0
	SET @CloudCapabilities = ISNULL((SELECT attrVal FROM UMUsersProp WITH (NOLOCK) WHERE componentNameId = @userId and modified = 0 and attrName='Cloud Capabilities'),0)
	SELECT @CloudCapabilities = (@CloudCapabilities |attrval) FROM UMUserGroup UG WITH (NOLOCK)
	INNER JOIN [UMGroupsProp] UGP WITH (NOLOCK) ON UG.groupId=UGP.componentNameId AND modified = 0  AND attrName='Cloud Capabilities'
	WHERE UG.userId=@userId
    IF object_id('tempdb.dbo.#tempLaptopSecurityObjects') IS NOT NULL DROP TABLE #tempLaptopSecurityObjects
    CREATE TABLE  #tempLaptopSecurityObjects ( [capabilities]  BIGINT   NOT NULL, [flag]          INT NOT NULL DEFAULT 0, [commCellId]    INT   NOT NULL, [clientGroupId] INT   NOT NULL, [clientId]      INT   NOT NULL, [appTypeId]     INT   NOT NULL, [instanceId]    INT NOT NULL, [backupsetId]   INT NOT NULL, [subClientId]   INT   NOT NULL, [mediaAgentId]  INT   NOT NULL, [libraryId]     INT   NOT NULL, [archGroupId]   INT   NOT NULL, [vtContainerId] INT   NOT NULL, [vtPolicyId]    INT   NOT NULL, [vtShelfId]     INT   NOT NULL, [reviewSetId]   INT   NOT NULL DEFAULT 0, [querySetId]      INT   NOT NULL DEFAULT 0, [downloadSetId] INT NOT NULL DEFAULT 0, [ermId]       INT   NOT NULL DEFAULT 0, [legalHoldId]   INT NOT NULL DEFAULT 0, [tagId]       INT   NOT NULL DEFAULT 0, [cdPolicyId]    INT NOT NULL DEFAULT 0, [complianceReportId]   INT  NOT NULL DEFAULT 0, [taskId]        INT NOT NULL DEFAULT 0, [workflowId]    INT NOT NULL DEFAULT 0, [logMonitoringPolicyId] INT NOT NULL DEFAULT 0, [arrayId]       INT NOT NULL DEFAULT 0, [cloudId]       INT NOT NULL DEFAULT 0, [userGroupId]   INT NOT NULL DEFAULT 0, [providerId]    INT NOT NULL DEFAULT 0, [entityId1]     INT NOT NULL DEFAULT 0, [entityId2]     INT NOT NULL DEFAULT 0, [entityId3]     INT NOT NULL DEFAULT 0, [entityId4]     INT NOT NULL DEFAULT 0, [entityId5]     INT NOT NULL DEFAULT 0, [entityId6]     INT NOT NULL DEFAULT 0, [entityId7]     INT NOT NULL DEFAULT 0, [entityId8]     INT NOT NULL DEFAULT 0, [entityId9]     INT NOT NULL DEFAULT 0  )
	DECLARE @surveycapability INT =0
	IF (@CloudCapabilities & POWER(2, @SERVEY_CAPABILITY - 1) <> 0)
		SET @surveycapability = 1
	ELSE  --IF ( @surveycapability <> 1)
	BEGIN
		DECLARE @userCapsAtCommcell 	bigint = 0
		EXEC sec_getUserObjects @userId, 2018, 0, '#tempLaptopSecurityObjects'
		SELECT @userCapsAtCommcell = @userCapsAtCommcell | sec.capabilities
			FROM #tempLaptopSecurityObjects sec
			WHERE		commCellId =2
						AND clientGroupId = 0 AND clientId = 0 AND appTypeId = 0
						AND instanceId = 0 AND backupsetId = 0 AND subClientId = 0
						AND mediaAgentId = 0 AND libraryId = 0 AND archGroupId = 0
						AND vtPolicyId = 0 AND vtcontainerId = 0 AND vtShelfId = 0
						AND reviewSetId = 0 AND querySetId = 0 AND downloadSetId = 0
						AND tagId = 0 AND legalHoldId = 0 AND ermId = 0
						AND cdPolicyId = 0 AND complianceReportId = 0 AND taskId = 0
						AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0
						AND cloudId=0 AND userGroupId=0 AND providerId=0 AND entityId1=0
						AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0
						AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0
		IF (@userCapsAtCommcell & CAST(POWER(2.0, 15 - 1) AS bigint) <> 0)
			SET @surveycapability =1
	END
	IF OBJECT_ID('tempdb..#groupTbl') IS NOT NULL
		DROP TABLE #groupTbl
	CREATE TABLE #groupTbl (clientGroupId INT)
	IF OBJECT_ID('tempdb..#ccTbl') IS NOT NULL
		DROP TABLE #ccTbl
	CREATE TABLE #ccTbl (clientId INT)
	DECLARE @isUserAdmin int
	EXECUTE sec_isUserAdmin @i_userid = @userId, @o_isUserAdmin = @isUserAdmin OUTPUT
	IF (@isUserAdmin = 1 OR @surveycapability = 1)
	BEGIN
		INSERT INTO #companies(userGroupId)
		SELECT G.id
		FROM UMGroups G WITH(NOLOCK)
			INNER JOIN UMGroupsProp GP WITH(NOLOCK)
			ON G.id = GP.componentNameId AND GP.modified = 0
AND GP.attrName IN ('Customer User Group', 'customer subuser groups')
WHERE ((GP.attrName = 'Customer User Group' AND CAST(attrVal AS BIGINT) > 1)
OR (GP.attrName = 'customer subuser groups' AND CAST(attrVal AS BIGINT) > 0))
		INSERT INTO #groupTbl
		SELECT g.id AS "@clientGroupId" FROM APP_ClientGroup g WITH (NOLOCK)
		WHERE (g.flag & 0x40000 = 0x40000) --Commcell Group
			AND g.status = 0 --Manually created
	END
	ELSE --IF (@isUserAdmin = 0)
	BEGIN
		INSERT INTO #companies(userGroupId)
		SELECT G.id
		FROM UMGroups G WITH(NOLOCK)
			INNER JOIN UMUserGroup UG WITH(NOLOCK)
				ON G.id = UG.groupId
				AND UG.userId = @userId
			INNER JOIN UMGroupsProp GP WITH(NOLOCK)
				ON G.id = GP.componentNameId AND GP.modified = 0
AND GP.attrName IN ('Customer User Group', 'customer subuser groups')
WHERE ((GP.attrName = 'Customer User Group' AND CAST(attrVal AS BIGINT) > 1)
OR (GP.attrName = 'customer subuser groups' AND CAST(attrVal AS BIGINT) > 0))
		DELETE FROM #tempLaptopSecurityObjects
		EXEC sec_getUserObjects @userId, 2009, 0, '#tempLaptopSecurityObjects'
		--Get All user to group associations
		INSERT INTO #groupTbl
		SELECT DISTINCT sec.clientGroupId
		FROM #tempLaptopSecurityObjects sec
			INNER JOIN APP_ClientGroup g WITH (NOLOCK)
				ON g.id = sec.clientGroupId
					AND (g.flag & 0x40000 = 0x40000) --Commcell Group
					AND g.status = 0 --Manually created
			WHERE sec.commCellId =2
				AND sec.clientGroupId <> 0 AND sec.clientId = 0 AND sec.appTypeId = 0
				AND sec.instanceId = 0 AND sec.backupsetId = 0 AND sec.subClientId = 0
				AND sec.mediaAgentId = 0 AND sec.libraryId = 0 AND sec.archGroupId = 0
				AND sec.vtPolicyId = 0 AND sec.vtcontainerId = 0 AND sec.vtShelfId = 0
				AND sec.reviewSetId = 0 AND sec.querySetId = 0 AND sec.downloadSetId = 0
				AND sec.tagId = 0 AND sec.legalHoldId = 0 AND sec.ermId = 0
				AND sec.cdPolicyId = 0 AND sec.complianceReportId = 0 AND sec.taskId = 0
				AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0
				AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0
				AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0
				AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
				AND (sec.capabilities & CONVERT(bigint, (POWER(2.0, 15.0-1)))) <> 0 --Report Management Capability is enabled
		--Get All user to client associations
		INSERT INTO #ccTbl
		SELECT DISTINCT sec.clientId
		FROM #tempLaptopSecurityObjects sec
			WHERE sec.commCellId =2
				AND sec.clientGroupId = 0 AND sec.clientId <> 0 AND sec.appTypeId = 0
				AND sec.instanceId = 0 AND sec.backupsetId = 0 AND sec.subClientId = 0
				AND sec.mediaAgentId = 0 AND sec.libraryId = 0 AND sec.archGroupId = 0
				AND sec.vtPolicyId = 0 AND sec.vtcontainerId = 0 AND sec.vtShelfId = 0
				AND sec.reviewSetId = 0 AND sec.querySetId = 0 AND sec.downloadSetId = 0
				AND sec.tagId = 0 AND sec.legalHoldId = 0 AND sec.ermId = 0
				AND sec.cdPolicyId = 0 AND sec.complianceReportId = 0 AND sec.taskId = 0
				AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0
				AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0
				AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0
				AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
				AND (sec.capabilities & CONVERT(bigint, (POWER(2.0, 15.0-1)))) <> 0 --Report Management Capability is enabled
		UNION
		SELECT DISTINCT cl.id
			FROM #groupTbl gc
				INNER JOIN APP_ClientGroupAssoc gca WITH (NOLOCK)
					ON gc.clientGroupId = gca.clientGroupId
				INNER JOIN APP_CommCell cc WITH (NOLOCK)
					ON cc.clientId = gca.clientId
				INNER JOIN APP_Client cl WITH (NOLOCK)
					ON cc.clientId = cl.id
	END
	IF (@isUserAdmin = 1 OR @surveycapability = 1)
		SELECT @noOfCommcells = COUNT(*) FROM APP_CommCell WITH (NOLOCK)
	ELSE --(@surveycapability <> 1)
	BEGIN
		SELECT @noOfCommcells = COUNT(cc.id)
			FROM #ccTbl c
				INNER JOIN APP_CommCell cc WITH (NOLOCK)
					ON cc.clientId = c.clientId
				INNER JOIN APP_Client cl WITH (NOLOCK)
					ON cc.clientId = cl.id
		SET	@commcells =(
			SELECT cc.number AS '@commCellId', cc.csGUID AS '@csGUID', cl.name AS '@commCellName'
				FROM #ccTbl c
					INNER JOIN APP_CommCell cc WITH (NOLOCK)
						ON cc.clientId = c.clientId
					INNER JOIN APP_Client cl WITH (NOLOCK)
						ON cc.clientId = cl.id
			FOR XML PATH ('commcells'))
	END
	SELECT @noCommcellGroups = COUNT(c.clientGroupId) FROM #groupTbl c
	IF @surveycapability <> 1 OR @noCommcellGroups = 1
		SET @commCellGroups = (SELECT c.clientGroupId AS '@clientGroupId' FROM #groupTbl c FOR XML PATH ('commcellGroups'))
	SELECT @noOfCompanies = COUNT(c.userGroupId) FROM #companies c
	IF @surveycapability = 0 OR @noOfCompanies = 1
		SELECT @customerCompanies = (SELECT c.userGroupId AS 'company/@userGroupId' FROM #companies c FOR XML PATH ('companies'), TYPE)
	SET @response=( SELECT @surveycapability AS '@surveycapability', @noOfCommcells AS '@noOfCommcells', @noOfCompanies AS '@noOfCompanies', @noCommcellGroups AS '@noOfCommcellGroups', 0 AS '@status',
                        @user,
                        @commcells,
                        @commCellGroups,
						@customerCompanies
	FOR XML PATH ('WebReport_CloudMetricsUserResp'))
	IF object_id('tempdb.dbo.#companies') IS NOT NULL DROP TABLE #companies
	IF OBJECT_ID('tempdb..#groupTbl') IS NOT NULL
		DROP TABLE #groupTbl
	IF OBJECT_ID('tempdb..#ccTbl') IS NOT NULL
		DROP TABLE #ccTbl
	SELECT @response
GO

IF EXISTS (select * from GxQscripts where name = 'wr_getCommcellForUser')
	delete from GxQscripts where name = 'wr_getCommcellForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_getCommcellForUser')
	delete from GXDBVersions where aliasname = 'wr_getCommcellForUser'
GO

insert into GXDBVersions values(2, 'wr_getCommcellForUser',  '00010009000200070000', 'wr_getCommcellForUser', '00010009000200070000')
GO

