

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_UserPreferences.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/wr_UserPreferences.sp,v $ $Id: wr_UserPreferences.sp,v 1.6 2012/03/07 22:03:25 junlu Exp $";
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Eugene Volohov
-- Create date: 09/11/2010
-- Description:	returns /updates/ deletes webconsole user preferences
-- Parameters :
-- -----------------------------------------------------------------------------------------------------------
-- ----------------------------------------------------------
-- $Log: wr_UserPreferences.sp,v $
-- Revision 1.5  2012/03/02 23:33:49  junlu
-- Update Form:82145
-- Update Form: 82145
-- Integration chages for web reports using Json.
-- Original branch changes by: junlu (Jun Lu)
--
-- Revision 1.4  2011/09/23 21:26:37  evolohov
-- Fix in output message generation
--
-- Revision 1.3  2011/08/04 21:34:09  evolohov
-- changes in xml response
--
--
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_UserPreferences <<<'

IF EXISTS (select * from sysobjects where name='wr_UserPreferences')
	drop procedure wr_UserPreferences
IF EXISTS (select * from GxQscripts where name='wr_UserPreferences')
	delete from GxQscripts where name = 'wr_UserPreferences'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_UserPreferences')
	delete from GXDBVersions where aliasname = 'wr_UserPreferences'
GO
print '... Creating Procedure: wr_UserPreferences'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_UserPreferences
  @reqXml XML,
  @userId INT
AS
  DECLARE @o_UserPreferences NVARCHAR(MAX);
DECLARE @requestType	INT = 0
DECLARE @userPrefs		NVARCHAR(MAX) = NULL;
SET		@requestType	= @reqXml.value('/Common_UserPreferencesReq[1]/@requestType', 'int')
SET		@userPrefs		= CAST(@reqXml.query('/Common_UserPreferencesReq[1]/userPreferences') as NVARCHAR(MAX))
    -- SET NOCOUNT ON added to prevent extra result sets from
    -- interfering with SELECT statements.
    SET NOCOUNT ON
    IF @requestType = 0 BEGIN
        SELECT @userPrefs = value FROM UMUserWebPrefs WHERE userId = @userId
    END ELSE IF @requestType = 1 BEGIN
        IF EXISTS(SELECT * FROM UMUserWebPrefs WHERE userId = @userId) BEGIN
            UPDATE UMUserWebPrefs SET value = @userPrefs WHERE userId = @userId
        END ELSE  BEGIN
            INSERT INTO UMUserWebPrefs VALUES (@userId, @userPrefs)
        END
    END ELSE BEGIN
        DELETE FROM UMUserWebPrefs WHERE userId = @userId
        SET @userPrefs = NULL
    END
    SELECT  '<?xml version="1.0" ?><Common_UserPreferencesResp>' + @userPrefs + '</Common_UserPreferencesResp>'
GO

IF EXISTS (select * from GxQscripts where name = 'wr_UserPreferences')
	delete from GxQscripts where name = 'wr_UserPreferences'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_UserPreferences')
	delete from GXDBVersions where aliasname = 'wr_UserPreferences'
GO

insert into GXDBVersions values(2, 'wr_UserPreferences',  '00010006000000000000', 'wr_UserPreferences', '00010006000000000000')
GO

