

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_UserCellSelection.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/wr_UserCellSelection.sp,v $ $Id: wr_UserCellSelection.sp,v 1.12.2.9 2020/06/26 08:45:21 junlu Exp $";
-- -----------------------------------------------------------------------------------------------------------
-- Author:      Eugene Volohov
-- Create date: 02/14/2011
-- Description: returns list of entities id (down to subclient level) which are falling in conditions specified by
--              filterXML for specified user
-- Parameters :
--              userId                  [input] [int]      : id of the user. Only items available for user
--                                                           will be returned.
--              outputTableName         [input] [sysname]  : name of already existing table that will hold
--                                                           selected entities. If name is NULL or empty then
--                                                           uses SELECT statement to return rows.
--                                                           For use from C/C++ code
--              skipUserSelectionFilter [input] [int]      : when > 0 skips processing filterXML and just returns
--                                                           all available entities visible by user
--              includeDeletedSubclients[input] [int]      : flag that dictates inclusion of log deleted subclient
--              includeDeletedClients   [input] [int]      : flag that dictates inclusion of deleted clients
--              filterXML               [input] [ntext]    : set of rules that will defined which entities
-- -----------------------------------------------------------------------------------------------------------
-- ----------------------------------------------------------
-- $Log: wr_UserCellSelection.sp,v $
-- Revision 1.8  2012/08/06 11:17:05  kbora
-- Update form : 1000418
-- Missing included files
-- Local  redefinition of constants in pydb.py going to be removed
-- So adding corresponding included files
--
-- Revision 1.7  2012/04/24 13:37:27  csunderland
-- update to change manually defining temp table to pass into sec_getUserObjects to use macro
--
-- Update Form: 90085
-- Original branch changes by: csunderland (Christopher Sunderland)
--
-- Revision 1.6  2011/12/06 19:23:12  stelagamsetti
-- Update Form: 66213
-- MR 72679: webreports: Delected sub clients job not included.
-- Original branch changes by: stelagamsetti (Sunil TelagamSetti)
--
-- Revision 1.5  2011/12/05 19:15:58  junlu
-- Update Form:66148
-- MR 72753 -- Bookmarking of Job Summary web report with few clients not working.
-- Original branch changes by: junlu (Jun Lu)
--
-- Revision 1.4  2011/12/01 23:24:32  rpolimera
-- security issues in webreports
-- update form: 66073
-- Original branch changes by: rpolimera (Rajesh Polimera)
--
-- Revision 1.3  2011/05/26 21:37:17  evolohov
-- New parameter @rootNode
--
-- Revision 1.2  2011/04/21 16:58:44  sbonilla
-- Added taskId column to sec_getUserObjects
--
-- Revision 1.1  2011/02/14 22:04:59  evolohov
-- stored procedure tha returns list of selected subclients based on userId and user selection. initial commit
--
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='wr_UserCellSelection')
BEGIN
	print '>>> Drop Stored Procedure: wr_UserCellSelection <<<'
	drop procedure wr_UserCellSelection
END
IF EXISTS (select * from GxQscripts where name='wr_UserCellSelection')
	delete from GxQscripts where name = 'wr_UserCellSelection'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_UserCellSelection')
	delete from GXDBVersions where aliasname = 'wr_UserCellSelection'
GO
print '... Creating Procedure: wr_UserCellSelection'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure wr_UserCellSelection
  @userId INT,
  @outTempTable NVARCHAR(128),
  @skipUserSelectionFilter INT = 0,
  @includeDeletedSubclients INT = 1,
  @includeDeletedClients INT = 1,
  @rootNode NVARCHAR(128), 
  @filterXML NTEXT
AS
  DECLARE @o_commcellId INT
  DECLARE @o_groupId INT    
  DECLARE @o_clientId INT
  DECLARE @o_appTypeId INT
  DECLARE @o_instanceId INT
  DECLARE @o_backupSetId INT
  DECLARE @o_subclientId INT
  DECLARE @o_clientDeleted INT
  DECLARE @o_subclientDeleted INT
    SET NOCOUNT ON
    IF RIGHT(@rootNode, 1) <> '/' BEGIN
        SET @rootNode = @rootNode + '/'
    END
    SET @rootNode = @rootNode + 'subclientFilterList'
    IF OBJECT_ID('tempdb.dbo.#EntitiesSelection__tmp_UserSelection')    IS NOT NULL DROP TABLE #EntitiesSelection__tmp_UserSelection
    IF OBJECT_ID('tempdb.dbo.#EntitiesSelection__tmp_EntityId')         IS NOT null DROP TABLE #EntitiesSelection__tmp_EntityId
    IF OBJECT_ID('tempdb.dbo.#EntitiesSelection__tmp_EntitySelection')  IS NOT null DROP TABLE #EntitiesSelection__tmp_EntitySelection
    IF OBJECT_ID('tempdb.dbo.#EntitiesSelection__temp_UserObjects')     IS NOT null DROP TABLE #EntitiesSelection__temp_UserObjects
    IF OBJECT_ID('tempdb.dbo.#EntitiesSelection__temp_UserGroups')      IS NOT null DROP TABLE #EntitiesSelection__temp_UserGroups
    DECLARE @debug          INT = 0
    DECLARE @stats          INT = 0
    DECLARE @statsTempTime  DATETIME
DECLARE @APPTYPE_VSA	INT = 106
    IF @stats <> 0 BEGIN
        IF OBJECT_ID('tempdb.dbo.#EntitiesSelection__temp_Stats')  IS NOT null DROP TABLE #EntitiesSelection__temp_Stats
        CREATE TABLE #EntitiesSelection__temp_Stats(type VARCHAR(50), timeSpentMili INT)
    END
    CREATE TABLE #EntitiesSelection__tmp_UserSelection
    (
        commcellId          INT,
        groupId             INT,
        clientId            INT,
        appTypeId           INT,
        instanceId          INT,
        backupSetId         INT,
        subclientId         INT
    )
    CREATE TABLE #EntitiesSelection__tmp_EntityId
    (
        commcellId          INT,
        groupId             INT,
        clientId            INT,
        appTypeId           INT,
        instanceId          INT,
        backupSetId         INT,
        subclientId         INT,
        clientDeleted       BIT,
        subclientDeleted    BIT
    )
    CREATE TABLE #EntitiesSelection__tmp_EntitySelection
    (
        commcellId          INT,
        groupId             INT,
        clientId            INT,
        appTypeId           INT,
        instanceId          INT,
        backupSetId         INT,
        subclientId         INT,
        clientDeleted       BIT,
        subclientDeleted    BIT
    )
--    CREATE TABLE #EntitiesSelection__temp_UserObjects
--    (
--        [capabilities]       BIGINT NOT null,
--        [flag]               INT    NOT null DEFAULT 0,
--        [commCellId]         INT    NOT null,
--        [clientGroupId]      INT    NOT null,
--        [clientId]           INT    NOT null,
--        [appTypeId]          INT    NOT null,
--        [instanceId]         INT    NOT null,
--        [backupsetId]        INT    NOT null,
--        [subClientId]        INT    NOT null,
--        [mediaAgentId]       INT    NOT null,
--        [libraryId]          INT    NOT null,
--        [archGroupId]        INT    NOT null,
--        [vtContainerId]      INT    NOT null,
--        [vtPolicyId]         INT    NOT null,
--        [vtShelfId]          INT    NOT null,
--        [reviewSetId]        INT    NOT null DEFAULT 0,
--        [querySetId]         INT    NOT null DEFAULT 0,
--        [downloadSetId]      INT    NOT null DEFAULT 0,
--        [ermId]              INT    NOT null DEFAULT 0,
--        [legalHoldId]        INT    NOT null DEFAULT 0,
--        [tagId]              INT    NOT null DEFAULT 0,
--        [cdPolicyId]         INT    NOT null DEFAULT 0,
--        [complianceReportId] INT    NOT null DEFAULT 0,
--        [taskId]             INT    NOT null DEFAULT 0
--    )
create table  #EntitiesSelection__temp_UserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
--    CREATE TABLE #EntitiesSelection__temp_UserGroups
--    (
--        [capabilities]       BIGINT NOT null,
--        [flag]               INT    NOT null DEFAULT 0,
--        [commCellId]         INT    NOT null,
--        [clientGroupId]      INT    NOT null,
--        [clientId]           INT    NOT null,
--        [appTypeId]          INT    NOT null,
--        [instanceId]         INT    NOT null,
--        [backupsetId]        INT    NOT null,
--        [subClientId]        INT    NOT null,
--        [mediaAgentId]       INT    NOT null,
--        [libraryId]          INT    NOT null,
--        [archGroupId]        INT    NOT null,
--        [vtContainerId]      INT    NOT null,
--        [vtPolicyId]         INT    NOT null,
--        [vtShelfId]          INT    NOT null,
--        [reviewSetId]        INT    NOT null DEFAULT 0,
--        [querySetId]         INT    NOT null DEFAULT 0,
--        [downloadSetId]      INT    NOT null DEFAULT 0,
--        [ermId]              INT    NOT null DEFAULT 0,
--        [legalHoldId]        INT    NOT null DEFAULT 0,
--        [tagId]              INT    NOT null DEFAULT 0,
--        [cdPolicyId]         INT    NOT null DEFAULT 0,
--        [complianceReportId] INT    NOT null DEFAULT 0,
--        [taskId]             INT    NOT null DEFAULT 0
--    )
create table  #EntitiesSelection__temp_UserGroups ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
    IF @stats <> 0 SET @statsTempTime = GetDate()
    IF @skipUserSelectionFilter = 0 BEGIN
        -- get list of entities user had selected
        DECLARE @handle INT
        EXEC sp_xml_preparedocument @handle OUTPUT, @filterXML
        INSERT INTO #EntitiesSelection__tmp_UserSelection
            SELECT ISNULL(commcellId, 0)    AS commcellId,
                   ISNULL(clientGroupId, 0) AS clientGroupId,
                   ISNULL(clientId, 0)      AS clientId,
                   ISNULL(applicationId, 0) AS applicationId,
                   ISNULL(instanceId, 0)    AS instanceId,
                   ISNULL(backupsetId, 0)   AS backupsetId,
                   ISNULL(subclientId, 0)   AS subclientId
            FROM OPENXML (@handle, @rootNode, 1)
            WITH ( commCellId      INT     '@commCellId',
                   clientGroupId   INT     '@clientGroupId',
                   clientId        INT     '@clientId',
                   applicationId   INT     '@applicationId',
                   instanceId      INT     '@instanceId',
                   backupsetId     INT     '@backupsetId',
                   subclientId     INT     '@subclientId'
                 )
        EXEC sp_xml_removedocument @handle
    END ELSE BEGIN
        -- assume that user had selected everything
        INSERT INTO #EntitiesSelection__tmp_UserSelection VALUES(0, 0, 0, 0, 0, 0, 0)
    END
    IF @stats <> 0 INSERT INTO #EntitiesSelection__temp_Stats VALUES ('User selection', datediff(millisecond, @statsTempTime, GetDate()))
    IF @debug > 0 SELECT 'User selection', * FROM #EntitiesSelection__tmp_UserSelection
    -- get list of items which use allowed to see
    IF @userId > 0 BEGIN
        IF @stats <> 0 SET @statsTempTime = GetDate()
        EXEC sec_getUserObjects @userId, 2013, 0, '#EntitiesSelection__temp_UserObjects'
        INSERT INTO #EntitiesSelection__temp_UserGroups
            SELECT  * FROM #EntitiesSelection__temp_UserObjects
        DELETE  #EntitiesSelection__temp_UserObjects
        WHERE   clientGroupId <> 0 OR mediaAgentId <> 0 OR libraryID <> 0  OR archGroupID <> 0 OR vtContainerId <> 0 OR vtPolicyId <> 0 OR
                vtShelfId <> 0 OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR ermId <> 0  OR legalHoldId <> 0 OR tagId <> 0 OR
                cdPolicyId <> 0 OR complianceReportId <> 0 OR taskId <> 0 or commcellID <> 2
        DELETE #EntitiesSelection__temp_UserGroups
        WHERE   clientId <> 0 OR appTypeId <> 0 OR InstanceId <> 0 OR backupsetId <> 0 OR subClientId <> 0 OR mediaAgentId <> 0 OR
                libraryID <> 0  OR archGroupID <> 0 OR vtContainerId <> 0 OR vtPolicyId <> 0 OR vtShelfId <> 0 OR reviewSetId <> 0 OR
                querySetId <> 0 OR downloadSetId <> 0 OR ermId <> 0  OR legalHoldId <> 0  OR tagId <> 0 OR cdPolicyId <> 0 OR
                complianceReportId <> 0 OR taskId <> 0 or commcellID <> 2
		CREATE INDEX temp_UserObjects_idx ON #EntitiesSelection__temp_UserObjects (clientId, appTypeId, instanceId, backupsetId, subClientId)
        IF @stats <> 0 INSERT INTO #EntitiesSelection__temp_Stats VALUES ('user objects', datediff(millisecond, @statsTempTime, GetDate()))
        IF @debug > 0 SELECT 'user objects', * FROM #EntitiesSelection__temp_UserObjects
        IF @debug > 0 SELECT 'user groups', * FROM #EntitiesSelection__temp_UserGroups
    END
    -- get list of enities
    IF @stats <> 0 SET @statsTempTime = GetDate()
	IF @userId = 0
		INSERT INTO #EntitiesSelection__tmp_EntityId
		SELECT  DISTINCT APP.origCCId, 0, APP.clientId, APP.appTypeId, APP.instance, APP.backupSet, APP.id,
				(CASE WHEN (CL.[status] & 0x2) = 0 THEN 0 ELSE 1 END),
				(CASE WHEN (APP.subclientStatus & 0x2) = 0 THEN 0 ELSE 1 END)
		FROM    App_Application APP WITH (NOLOCK)
				INNER JOIN APP_Client CL WITH (NOLOCK) ON CL.id = APP.clientId
	ELSE
		INSERT INTO #EntitiesSelection__tmp_EntityId
		SELECT  APP.origCCId, 0, APP.clientId, APP.appTypeId, APP.instance, APP.backupSet, APP.id,
				(CASE WHEN (CL.[status] & 0x2) = 0 THEN 0 ELSE 1 END),
				(CASE WHEN (APP.subclientStatus & 0x2) = 0 THEN 0 ELSE 1 END)
		FROM    App_Application APP WITH (NOLOCK)
				INNER JOIN APP_Client CL WITH (NOLOCK) ON CL.id = APP.clientId
				INNER JOIN #EntitiesSelection__temp_UserObjects UO
					ON  UO.clientId    IN (0, APP.clientId)
					AND UO.appTypeId   IN (0, APP.appTypeId)
					AND UO.instanceId  IN (0, APP.instance)
					AND UO.backupsetId IN (0, APP.backupSet)
					AND UO.subClientId IN (0, APP.id)
	INSERT INTO #EntitiesSelection__tmp_EntityId
	SELECT  DISTINCT CL.origCCId, 0, CL.id, @APPTYPE_VSA, 0, 0, CAST(CP.attrVal AS INT), 0, 0
	FROM    APP_Client CL WITH (NOLOCK)
			INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON CL.id = CP.componentNameId
				AND CP.attrName = 'VSA Discover Subclient ID' AND CP.modified = 0
			INNER JOIN #EntitiesSelection__temp_UserObjects O  ON CL.id = O.clientId
			LEFT OUTER JOIN #EntitiesSelection__tmp_EntityId E ON CL.id = E.clientId AND E.appTypeId = @APPTYPE_VSA
			LEFT OUTER JOIN (
				SELECT	DISTINCT componentNameId
				FROM	APP_ClientProp WITH (NOLOCK)
				WHERE	attrName = 'Virtual Machine Deletion Time' AND ISNULL(attrVal, '0') <> '0' AND modified = 0
			) T ON CL.id = T.componentNameId
	WHERE	E.clientId IS NULL AND T.componentNameId IS NULL
	CREATE INDEX #EntitiesSelection__tmp_EntityId_idx ON #EntitiesSelection__tmp_EntityId (clientId)
-- list of groups
	IF @userId = 0
		INSERT INTO #EntitiesSelection__tmp_EntityId
		SELECT  APP.commcellId, CGA.clientGroupId, APP.clientId, APP.appTypeId, APP.instanceId, APP.backupSetId, APP.subclientId,
				APP.clientDeleted, APP.subclientDeleted
		FROM    APP_ClientGroupAssoc CGA WITH (NOLOCK)
				INNER JOIN APP_Client C WITH (NOLOCK) ON C.id = CGA.clientId
				INNER JOIN #EntitiesSelection__tmp_EntityId APP ON APP.clientId = C.ID
	ELSE
		INSERT INTO #EntitiesSelection__tmp_EntityId
		SELECT  APP.commcellId, CGA.clientGroupId, APP.clientId, APP.appTypeId, APP.instanceId, APP.backupSetId, APP.subclientId,
				APP.clientDeleted, APP.subclientDeleted
		FROM    APP_ClientGroupAssoc CGA WITH (NOLOCK)
				INNER JOIN #EntitiesSelection__temp_UserGroups UG ON UG.clientGroupId IN (0, CGA.clientGroupId)
				INNER JOIN APP_Client C WITH (NOLOCK) ON C.id = CGA.clientId
				INNER JOIN #EntitiesSelection__tmp_EntityId APP ON APP.clientId = C.ID
    DELETE  #EntitiesSelection__tmp_EntityId
    FROM    #EntitiesSelection__tmp_EntityId E INNER JOIN APP_InstanceName I WITH (NOLOCK) ON I.id = E.instanceId
    WHERE   ((I.[status] & 16) > 0 OR (I.[status] & 32) > 0)
    -- filter out deleted subclients
    DELETE  #EntitiesSelection__tmp_EntityId
    WHERE   (@includeDeletedSubclients = 0) AND (subclientDeleted = 1)
	update E
	set E.clientDeleted = 0
	from #EntitiesSelection__tmp_EntityId E
	INNER JOIN APP_ClientProp Cprop WITH (NOLOCK) ON Cprop.componentNameId = E.clientId
	and Cprop.attrName ='IndexingV2_VSA' and Cprop.modified = 0 and Cprop.attrval = 1
    -- filter out deleted clients
    DELETE  #EntitiesSelection__tmp_EntityId
    WHERE   (@includeDeletedClients = 0) AND (clientDeleted = 1)
    IF @stats <> 0 INSERT INTO #EntitiesSelection__temp_Stats VALUES ('full entities list', datediff(millisecond, @statsTempTime, GetDate()))
    IF @debug > 0 SELECT 'Full entities list', * FROM #EntitiesSelection__tmp_EntityId
    -- filter out by request
    IF @stats <> 0 SET @statsTempTime = GetDate()
    INSERT INTO #EntitiesSelection__tmp_EntitySelection
        SELECT E.*
        FROM   #EntitiesSelection__tmp_EntityId E INNER JOIN #EntitiesSelection__tmp_UserSelection S ON
                                                                    S.commcellId  IN (0, E.commcellId)
                                                               AND  S.groupId     IN (0, E.groupId)
                                                               AND  S.clientId    IN (0, E.clientId)
                                                               AND  S.appTypeId   IN (0, E.appTypeId)
															   AND  S.instanceId  IN (0, E.instanceId)
                                                               AND  S.backupSetId IN (0, E.backupSetId)
                                                               AND  S.subclientId IN (0, E.subclientId)
    IF @stats <> 0 INSERT INTO #EntitiesSelection__temp_Stats VALUES ('user selection filter', datediff(millisecond, @statsTempTime, GetDate()))
    IF @debug > 0 SELECT 'Filtered entities list', * FROM #EntitiesSelection__tmp_EntitySelection
	-- get VMs with jobs in VSA subclients
	IF EXISTS (SELECT * FROM #EntitiesSelection__tmp_EntitySelection WHERE appTypeId = @APPTYPE_VSA)
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#VM') IS NOT null DROP TABLE #VM
		CREATE TABLE #VM (commCellId INT, clientId INT)
		INSERT	INTO #VM
		SELECT	E.commCellId, CP.componentNameId
		FROM	#EntitiesSelection__tmp_EntitySelection E
				INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON CP.attrName = 'VSA Discover Subclient ID'
					AND CAST(E.subClientId AS NVARCHAR(12)) = CP.attrVal AND CP.modified = 0
		GROUP BY E.commCellId, CP.componentNameId
		DELETE	V
		FROM	#VM V
				INNER JOIN (SELECT DISTINCT clientId FROM #EntitiesSelection__tmp_EntitySelection) C ON V.clientId = C.clientId
		INSERT	INTO #EntitiesSelection__tmp_EntitySelection
		SELECT	V.commCellId, 0, V.clientId, @APPTYPE_VSA, 0, 0, 0, 0, 0
		FROM	#VM V
				INNER JOIN APP_Client CL WITH (NOLOCK) ON V.clientId = CL.id
	END
    -- copy data to output table
    IF @outTempTable IS NOT NULL AND LEN(@outTempTable) > 0 BEGIN
        IF @stats <> 0 SET @statsTempTime = GetDate()
        EXEC (	'INSERT INTO ' + @outTempTable + ' SELECT DISTINCT * FROM #EntitiesSelection__tmp_EntitySelection' )
        IF @stats <> 0 INSERT INTO #EntitiesSelection__temp_Stats VALUES ('output table', datediff(millisecond, @statsTempTime, GetDate()))
    END ELSE BEGIN
        SELECT DISTINCT * FROM #EntitiesSelection__tmp_EntitySelection
    END
    -- delete temporary tables from memory
    IF @stats <> 0 BEGIN
        SELECT * FROM #EntitiesSelection__temp_Stats
        IF OBJECT_ID('tempdb.dbo.#EntitiesSelection__temp_Stats')  IS NOT null DROP TABLE #EntitiesSelection__temp_Stats
    END
    IF OBJECT_ID('tempdb.dbo.#EntitiesSelection__tmp_EntitySelection')  IS NOT null DROP TABLE #EntitiesSelection__tmp_EntitySelection
    IF OBJECT_ID('tempdb.dbo.#EntitiesSelection__tmp_EntityId')         IS NOT null DROP TABLE #EntitiesSelection__tmp_EntityId
    IF OBJECT_ID('tempdb.dbo.#CommCellTree__temp_UserObjects')          IS NOT null DROP TABLE #CommCellTree__temp_UserObjects
    IF OBJECT_ID('tempdb.dbo.#CommCellTree__temp_UserGroups')           IS NOT null DROP TABLE #CommCellTree__temp_UserGroups
    IF OBJECT_ID('tempdb.dbo.#EntitiesSelection__tmp_UserSelection')    IS NOT NULL DROP TABLE #EntitiesSelection__tmp_UserSelection
GO

IF EXISTS (select * from GxQscripts where name = 'wr_UserCellSelection')
	delete from GxQscripts where name = 'wr_UserCellSelection'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_UserCellSelection')
	delete from GXDBVersions where aliasname = 'wr_UserCellSelection'
GO

insert into GXDBVersions values(2, 'wr_UserCellSelection',  '00010012000200090000', 'wr_UserCellSelection', '00010012000200090000')
GO

