

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_SetExcludeReportInfo.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_SetExcludeReportInfo <<<'

IF EXISTS (select * from sysobjects where name='wr_SetExcludeReportInfo')
	drop procedure wr_SetExcludeReportInfo
IF EXISTS (select * from GxQscripts where name='wr_SetExcludeReportInfo')
	delete from GxQscripts where name = 'wr_SetExcludeReportInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_SetExcludeReportInfo')
	delete from GXDBVersions where aliasname = 'wr_SetExcludeReportInfo'
GO
print '... Creating Procedure: wr_SetExcludeReportInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_SetExcludeReportInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @request XML
AS
  DECLARE @response xml
/*
Message ExcludeReportInfo
{
	list<Report>    customReports
    list<Report>    metricReports
}
Message SetExcludeReportInfoReq
{
     ExcludeReportInfo		exclude
}
Message SetExcludeReportInfoResp
{
     GenericResp          msg
}
*/
DECLARE @ExcludeReportInfo VARCHAR(256) ='ExcludeReportInfo'
DECLARE @errorString NVARCHAR(MAX) =''
DECLARE @errorCode INT  =0
DECLARE @excludereports NVARCHAR(MAX) =''
SET  @excludereports =(SELECT CAST ( req.exclude.query('.') AS  NVARCHAR(MAX))from     @request.nodes('/WebReport_SetExcludeReportInfoReq/exclude') req(exclude) )
BEGIN TRY
IF @excludereports IS  NULL
BEGIN
	SET @errorCode =1
	SET @errorString ='Invalid ExcludeReportInfo'
END
ELSE
BEGIN
	IF EXISTS (select value from GXGlobalParam (NOLOCK) where name = @ExcludeReportInfo  and modified =0)
	BEGIN
		UPDATE GXGlobalParam SET VALUE = @excludereports WHERE NAME =@ExcludeReportInfo
	END
	ELSE
	BEGIN
		INSERT INTO GXGlobalParam values(@ExcludeReportInfo,@excludereports ,dbo.GetUnixTimeBig(GetUTCDate()), 0)
	END
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
BEGIN
    SELECT @errorCode = 1
    SELECT @errorString = 'Exception  - failed with error :: ' + ERROR_MESSAGE()
END
END CATCH
SET @response= (SELECT @errorCode as '@errorCode' , @errorString as '@errorMessage' FOR XML PATH('msg')    )
SET @response= ( SELECT
                    @response
            FOR XML PATH ('WebReport_SetExcludeReportInfoResp')
            )
 SELECT @response
GO

IF EXISTS (select * from GxQscripts where name = 'wr_SetExcludeReportInfo')
	delete from GxQscripts where name = 'wr_SetExcludeReportInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_SetExcludeReportInfo')
	delete from GXDBVersions where aliasname = 'wr_SetExcludeReportInfo'
GO

insert into GXDBVersions values(2, 'wr_SetExcludeReportInfo',  '00010001000200030000', 'wr_SetExcludeReportInfo', '00010001000200030000')
GO

