

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_ManageProfileTaskInfoHistory.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_ManageProfileTaskInfoHistory <<<'

IF EXISTS (select * from sysobjects where name='wr_ManageProfileTaskInfoHistory')
	drop procedure wr_ManageProfileTaskInfoHistory
IF EXISTS (select * from GxQscripts where name='wr_ManageProfileTaskInfoHistory')
	delete from GxQscripts where name = 'wr_ManageProfileTaskInfoHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_ManageProfileTaskInfoHistory')
	delete from GXDBVersions where aliasname = 'wr_ManageProfileTaskInfoHistory'
GO
print '... Creating Procedure: wr_ManageProfileTaskInfoHistory'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_ManageProfileTaskInfoHistory
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_taskId INT = 0,
  @request XML ,
  @errorCode INTEGER OUTPUT,
  @errorString NVARCHAR(MAX) OUTPUT
AS
/*
This sp will be single point to update the given task history
*/
DECLARE @ProcessTran INT
SET @ProcessTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessTran
		SET @ProcessTran = 1
	END
	DECLARE @taskOperation INT =0
	DECLARE  @dueDate BIGINT = 0
	DECLARE @taskurl NVARCHAR(MAX) = '',  @taskSummary NVARCHAR(MAX) = '', @taskDescription NVARCHAR(MAX) = '', @tasknotes NVARCHAR(MAX) = ''
	DECLARE @lastModifiedBy  INT =0 ,@status INT= 0 , @assignedTo INT  = 0, @opId INT= 1,@taskType INT = 0
	DECLARE @internalTask INT =0
	DECLARE @startDate  BIGINT = 0, @statusChangedReason NVARCHAR(MAX) = '',@dueDateChangedReason NVARCHAR(MAX) = ''
	SELECT
		@taskSummary		  =	  ISNULL(taskInfo.value('(@summary)[1]', 'nvarchar(max)'), ''),
		@taskDescription	  =	  ISNULL(taskInfo.value('(@description)[1]', 'nvarchar(max)'), ''),
		@tasknotes			  =   ISNULL(taskInfo.value('(@notes)[1]', 'nvarchar(max)'), ''),
		@taskurl			  =   ISNULL(taskInfo.value('(@url)[1]', 'nvarchar(max)'), ''),
		@dueDate		      =	  ISNULL(taskInfo.value('(@dueDate)[1]', 'BIGINT'), 0),
		@status			      =	  ISNULL(taskInfo.value('(@status)[1]', 'integer'), 0),
		@lastModifiedBy		  =   ISNULL(taskInfo.value('(user/@userId)[1]', 'integer'), 0),
		@assignedTo	    	  =   ISNULL(taskInfo.value('(assignedTo/@userId)[1]', 'integer'), @lastModifiedBy),
		@internalTask		  =	  ISNULL(taskInfo.value('(@internalTask)[1]', 'integer'), 0),
		@startDate			  =	  ISNULL(taskInfo.value('(@startDate)[1]', 'BIGINT'), 0),
		@statusChangedReason  =   ISNULL(taskInfo.value('(@statusChangeReason)[1]', 'nvarchar(max)'), ''),
		@dueDateChangedReason =   ISNULL(taskInfo.value('(@dueDateChangeReason)[1]', 'nvarchar(max)'), ''),
		@taskType			  =   ISNULL(taskInfo.value('(@taskType)[1]', 'integer'), 0)
	From @request.nodes('WebReport_ProfileReq/taskInfo') taskInfo(taskInfo)
SELECT
	@taskOperation = ISNULL(@request.value('(/WebReport_ProfileReq/@operation)[1]', 'integer'), 0)
	-- New task or existing task which is not yet available for history
	IF NOT EXISTS(SELECT * FROM ProfileTaskInfoHistory t WHERE taskId = @i_taskId )
	BEGIN
		INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId, @opId,'taskSummary',1,taskSummary
		FROM ProfileTaskInfo(NOLOCK) t WHERE t.taskId = @i_taskId
		INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId, @opId,'taskDescription',1,taskDescription
		FROM ProfileTaskInfo(NOLOCK) t WHERE t.taskId = @i_taskId
		INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId, @opId,'tasknotes',1,tasknotes
		FROM ProfileTaskInfo(NOLOCK) t WHERE t.taskId = @i_taskId
		INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId, @opId,'taskurl',1,taskurl
		FROM ProfileTaskInfo(NOLOCK) t WHERE t.taskId = @i_taskId
		INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId, @opId,'dueDate',1,dueDate
		FROM ProfileTaskInfo(NOLOCK) t WHERE t.taskId = @i_taskId
		INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId, @opId,'status',7,status
		FROM ProfileTaskInfo(NOLOCK) t WHERE t.taskId = @i_taskId
		INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId, @opId,'assignedTo',7,assignedTo
		FROM ProfileTaskInfo(NOLOCK) t WHERE t.taskId = @i_taskId
		INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId, @opId,'lastModifiedBy',7,lastModifiedBy
		FROM ProfileTaskInfo(NOLOCK) t WHERE t.taskId = @i_taskId
		INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId, @opId,'taskType',7,taskType
		FROM ProfileTaskInfo(NOLOCK) t WHERE t.taskId = @i_taskId
		INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId, @opId,'startDate',1,dbo.GetDateTime(@startDate)
		IF(@internalTask>0)
		BEGIN
			INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId, @opId,'internalTask',7,@internalTask
		END
	END
	--EDIT operation lets record only modified
	IF (@taskOperation = 3 )
	BEGIN
		SET @opId =(SELECT isnull(MAX(opId),1) from ProfileTaskInfoHistory(NOLOCK)  where  taskId = @i_taskId )
		SET @opId = @opId + 1
		DECLARE  @bchanged INT = 0
		IF NOT EXISTS(SELECT * FROM ProfileTaskInfo t WHERE t.taskId = @i_taskId AND taskSummary = @taskSummary AND DATALENGTH(taskSummary) = DATALENGTH(@taskSummary) )
		BEGIN
			INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId,  @opId, 'taskSummary',1,@taskSummary
			SET @bchanged =  1
		END
		IF NOT EXISTS(SELECT * FROM ProfileTaskInfo t WHERE t.taskId = @i_taskId AND taskDescription = @taskDescription AND DATALENGTH(taskDescription) = DATALENGTH(@taskDescription)  )
		BEGIN
			INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId,  @opId ,'taskDescription',1,@taskDescription
			SET @bchanged =  1
		END
		IF NOT EXISTS(SELECT * FROM ProfileTaskInfo t WHERE t.taskId = @i_taskId AND tasknotes = @tasknotes AND DATALENGTH(tasknotes) = DATALENGTH(@tasknotes)  )
		BEGIN
			INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId,  @opId ,'tasknotes',1,@tasknotes
			SET @bchanged =  1
		END
		IF NOT EXISTS(SELECT * FROM ProfileTaskInfo t WHERE t.taskId = @i_taskId AND taskurl = @taskurl AND DATALENGTH(taskurl) = DATALENGTH(@taskurl) )
		BEGIN
			INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId,  @opId ,'taskurl',1,@taskurl
			SET @bchanged =  1
		END
		IF NOT EXISTS(SELECT * FROM ProfileTaskInfo t WHERE t.taskId = @i_taskId AND  Cast (dueDate as date)  = Cast(dbo.GetDateTime(@dueDate) as date))
		BEGIN
			INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId,  @opId ,'dueDate',1,dbo.GetDateTime(@dueDate)
			SET @bchanged =  1
		END
		IF NOT EXISTS(SELECT * FROM ProfileTaskInfo t WHERE t.taskId = @i_taskId AND status = @status )
		BEGIN
			INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId,  @opId ,'status',7,@status
			SET @bchanged =  1
		END
		IF NOT EXISTS(SELECT * FROM ProfileTaskInfo t WHERE t.taskId = @i_taskId AND assignedTo = @assignedTo )
		BEGIN
			INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId,  @opId ,'assignedTo',7,@assignedTo
			SET @bchanged =  1
		END
		IF NOT EXISTS(SELECT * FROM ProfileTaskInfo t WHERE t.taskId = @i_taskId AND taskType = @taskType  )
		BEGIN
			INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId,  @opId ,'taskType',7,@taskType
			SET @bchanged =  1
		END
		IF NOT EXISTS(SELECT * FROM ProfileTaskInfoHistory t WHERE t.taskId = @i_taskId AND attrName = 'startDate' AND  attrVal = CAST(dbo.GetDateTime(@startDate) AS NVARCHAR(255)))
		BEGIN
			INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId, @opId,'startDate',1,dbo.GetDateTime(@startDate)
			SET @bchanged =  1
		END
		IF NOT EXISTS(SELECT * FROM ProfileTaskInfoHistory t WHERE t.taskId = @i_taskId AND attrName = 'statusChangedReason' AND  attrVal = @statusChangedReason)
		BEGIN
			INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId, @opId,'statusChangedReason',1,@statusChangedReason
			SET @bchanged =  1
		END
		IF NOT EXISTS(SELECT * FROM ProfileTaskInfoHistory t WHERE t.taskId = @i_taskId AND attrName = 'dueDateChangedReason' AND  attrVal = @dueDateChangedReason)
		BEGIN
			INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId, @opId,'dueDateChangedReason',1,@dueDateChangedReason
			SET @bchanged =  1
		END
		--this is not default property for all task so check whether it is on for task or EXISTS
		IF (@internalTask!= ISNULL((SELECT attrVal FROM ProfileTaskProp WHERE taskId = @i_taskId and attrName ='internalTask'),0))
		BEGIN
			INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId, @opId,'internalTask',7,@internalTask
			SET @bchanged =  1
		END
		IF( @bchanged =  1)
		BEGIN
			INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId, @opId,'lastModifiedBy',7,@lastModifiedBy
		END
	END
	IF (@ProcessTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessTran
		SET @ProcessTran = 0
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
IF (XACT_STATE() <> 0 AND @ProcessTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessTran
	SET @ProcessTran = 0
	SELECT @errorCode = 1
	SELECT @errorString = 'Exception  - failed with error :: ' + ERROR_MESSAGE()
END
END CATCH
CX_ERROR_EXIT:
GO

IF EXISTS (select * from GxQscripts where name = 'wr_ManageProfileTaskInfoHistory')
	delete from GxQscripts where name = 'wr_ManageProfileTaskInfoHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_ManageProfileTaskInfoHistory')
	delete from GXDBVersions where aliasname = 'wr_ManageProfileTaskInfoHistory'
GO

insert into GXDBVersions values(2, 'wr_ManageProfileTaskInfoHistory',  '00010001000200060000', 'wr_ManageProfileTaskInfoHistory', '00010001000200060000')
GO

