

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_ManageProfilePath.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_ManageProfilePath <<<'

IF EXISTS (select * from sysobjects where name='wr_ManageProfilePath')
	drop procedure wr_ManageProfilePath
IF EXISTS (select * from GxQscripts where name='wr_ManageProfilePath')
	delete from GxQscripts where name = 'wr_ManageProfilePath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_ManageProfilePath')
	delete from GXDBVersions where aliasname = 'wr_ManageProfilePath'
GO
print '... Creating Procedure: wr_ManageProfilePath'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_ManageProfilePath
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @requestSubFolder XML ,
  @requestCustomerFolder XML ,
  @i_userId int,
  @i_CCGroupId int,
  @i_CCGroupName nvarchar(max) = '',
  @i_docShareFolderId int,
  @i_companyId INT = 0
AS
  DECLARE @response xml
DECLARE @errorString NVARCHAR(MAX) =''
DECLARE @errorCode INT  =0
DECLARE @ProcessTran INT
SET @ProcessTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessTran
		SET @ProcessTran = 1
	END
DECLARE @status INT =0
DECLARE @CustomerInfoId int =0
IF (@i_companyId > 0)
SELECT  @CustomerInfoId = customerId FROM ProfileCustomerInfo t WHERE reserve1  = @i_companyId
ELSE
IF (@i_CCGroupId > 0)
SELECT @CustomerInfoId =  customerId FROM ProfileCustomerInfo t WHERE ccGroupId = @i_CCGroupId
ELSE
RETURN
	 Declare @ProfilePaths table
	 (
		name				nvarchar(max),
		path				nvarchar(max),
		GUID				nvarchar(max),
		createdBy			INT,
		lastModifiedBy		INT,
		customerId			INT		DEFAULT 0
	)
	insert into @ProfilePaths(name,path,GUID,createdBy,lastModifiedBy,customerId)
	SELECT
			ISNULL(fileResource.value('(@name)[1]','nvarchar(max)'), ''),
		    ISNULL(fileResource.value('(@path)[1]','nvarchar(max)'), ''),
			ISNULL(fileResource.value('(@GUID)[1]','nvarchar(max)'), ''),
			@i_userId,@i_userId,@CustomerInfoId
	From @requestSubFolder.nodes('App_FileResourceResponse/fileResource') fileResource(fileResource)
	INSERT INTO ProfileFolderPath( foldeName ,folderDescription ,folderPath,  createdBy,lastModifiedBy,customerId)
	select name,path,GUID,createdBy,lastModifiedBy,customerId
	from @ProfilePaths S
	where GUID not in  (SELECT DISTINCT folderPath FROM ProfileFolderPath WHERE customerId=@CustomerInfoId )
	DECLARE @docCustPath NVARCHAR(MAX) = NULL
	SELECT
	@docCustPath = ISNULL(@requestCustomerFolder.value('(App_FileResourceResponse/fileResource/@GUID)[1]','nvarchar(max)'), '')
	update ProfileCustomerInfo
	set docShareFolderId = @i_docShareFolderId,
	docCustPath = @docCustPath
	where customerId = @CustomerInfoId
	IF (@ProcessTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessTran
		SET @ProcessTran = 0
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
IF (XACT_STATE() <> 0 AND @ProcessTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessTran
	SET @ProcessTran = 0
	SELECT @errorCode = 1
	SELECT @errorString = 'Exception  - failed with error :: ' + ERROR_MESSAGE()
END
END CATCH
CX_ERROR_EXIT:
	SET @response = (SELECT @errorCode as '@errorCode' , @errorString as '@errorMessage' FOR XML PATH('msg')    )
	SET @response = (select @response FOR XML PATH('WebReport_GenericResp')    )
IF (XACT_STATE() <> 0 AND @ProcessTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessTran
	SET @ProcessTran = 0
END
	SELECT @response
GO

IF EXISTS (select * from GxQscripts where name = 'wr_ManageProfilePath')
	delete from GxQscripts where name = 'wr_ManageProfilePath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_ManageProfilePath')
	delete from GXDBVersions where aliasname = 'wr_ManageProfilePath'
GO

insert into GXDBVersions values(2, 'wr_ManageProfilePath',  '00010002001200040000', 'wr_ManageProfilePath', '00010002001200040000')
GO

