

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_ManageProfileOps.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_ManageProfileOps <<<'

IF EXISTS (select * from sysobjects where name='wr_ManageProfileOps')
	drop procedure wr_ManageProfileOps
IF EXISTS (select * from GxQscripts where name='wr_ManageProfileOps')
	delete from GxQscripts where name = 'wr_ManageProfileOps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_ManageProfileOps')
	delete from GXDBVersions where aliasname = 'wr_ManageProfileOps'
GO
print '... Creating Procedure: wr_ManageProfileOps'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_ManageProfileOps
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @request XML
AS
  DECLARE @response xml
/*
--Profile messages start
enum ProfileEntity
{
     Task=1,
     CustomerInfo=2,
     CustomerTouch=3,
     Documents=4,
     StatusNote=5,--for Weekly Status
     StatusMail=6,
	 UpdateEntity=7 --this is to update the status of any entity
}
Message ProfileReq
{
     ProfileEntity entity
     OperationType operation
     ProfileTaskInfo taskInfo
     CustomerInfo custInfo
     CustomerTouch custTouch
     StatusNotes	weeklyNotes
     StatusMail weeklyMail
}
Message ProfileResp
{
     GenericResp msg
}
--Profile messages end
ProfileTaskAssociation
assocType for
1		TASK association with customer ,ccgroup,touch, etc.
2		Touch association customerId,ccGroupId,
3		Customer association with ccgroup
4
*/
DECLARE @profileEntity INT = 0,@taskOperation INT =0
DECLARE @errorString NVARCHAR(MAX) =''
DECLARE @errorCode INT  =0
DECLARE @taskresp XML = NULL
DECLARE @ProcessTran INT
SET @ProcessTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessTran
		SET @ProcessTran = 1
	END
SELECT
	@profileEntity = ISNULL(@request.value('(/WebReport_ProfileReq/@entity)[1]', 'integer'), 0),
	@taskOperation = ISNULL(@request.value('(/WebReport_ProfileReq/@operation)[1]', 'integer'), 0)
DECLARE @status INT =0
DECLARE @taskId INT = 0
DECLARE @ccgroupId  INT =0
DECLARE @CustomerInfoName NVARCHAR(max) = null
DECLARE @CustomerInfouser  INT =0
DECLARE @createDefaultprop INT = 0
DECLARE @companyId INT = 0
DECLARE @custId INT = 0
IF (@profileEntity =1) --task information
BEGIN
	DECLARE  @taskreportId INT = 0, @taskType INT= 0 ,@dueDate BIGINT = 0 ,@TaskcustomerInfoId INT =0
	DECLARE @taskurl NVARCHAR(MAX) = '',  @taskSummary NVARCHAR(MAX) = '', @taskDescription NVARCHAR(MAX) = '', @tasknotes NVARCHAR(MAX) = '', @emailTo NVARCHAR(MAX) = ''
	DECLARE @user  INT =0 ,@taskOwner INT= 0 , @taskAssignedTo INT  = 0
	DECLARE @internalTask INT =0
	DECLARE @startDate  BIGINT = 0, @statusChangedReason NVARCHAR(MAX) = '',@dueDateChangedReason NVARCHAR(MAX) = ''
	SELECT
		@taskId				=	ISNULL(taskInfo.value('(@taskId)[1]', 'integer'), 0),
		@taskSummary		=	ISNULL(taskInfo.value('(@summary)[1]', 'nvarchar(max)'), ''),
		@taskurl			=   ISNULL(taskInfo.value('(@url)[1]', 'nvarchar(max)'), ''),
		@taskDescription	=	ISNULL(taskInfo.value('(@description)[1]', 'nvarchar(max)'), ''),
		@status			    =	ISNULL(taskInfo.value('(@status)[1]', 'integer'), 0),
		@dueDate		    =	ISNULL(taskInfo.value('(@dueDate)[1]', 'BIGINT'), 0),
		@TaskcustomerInfoId	=	ISNULL(taskInfo.value('(@customerInfoId)[1]', 'integer'), 1),
		@taskType			=	ISNULL(taskInfo.value('(@taskType)[1]', 'integer'), 0),
		@emailTo			=   ISNULL(taskInfo.value('(@emails)[1]', 'nvarchar(max)'), 0),
		@user				=   ISNULL(taskInfo.value('(user/@userId)[1]', 'integer'), 0),
		@taskAssignedTo		=   ISNULL(taskInfo.value('(assignedTo/@userId)[1]', 'integer'), @user),
		@tasknotes			=   ISNULL(taskInfo.value('(@notes)[1]', 'nvarchar(max)'), ''),
		@internalTask		=	ISNULL(taskInfo.value('(@internalTask)[1]', 'integer'), 0),
		@startDate			  =	  ISNULL(taskInfo.value('(@startDate)[1]', 'BIGINT'), 0),
		@statusChangedReason  =   ISNULL(taskInfo.value('(@statusChangeReason)[1]', 'nvarchar(max)'), ''),
		@dueDateChangedReason =   ISNULL(taskInfo.value('(@dueDateChangeReason)[1]', 'nvarchar(max)'), '')
	From @request.nodes('WebReport_ProfileReq/taskInfo') taskInfo(taskInfo)
	select @companyId  = ISNULL(CommCellInfo.value('(company/@userGroupId)[1]','[int]'),0)
		from @request.nodes('WebReport_ProfileReq/taskInfo/commcells') CommCellInfo(CommCellInfo)
	select @custId = ISNULL(customerId,0) from ProfileCustomerInfo where ccGroupId = @ccgroupId AND reserve1 = @companyId
	IF (@taskOperation = 1 ) --add operation for new task check whether we have task by this user.
	BEGIN
		Declare @TaskCommcellTouchtable table
		(
			touchId			INT	,
			commcellId		BIGINT	,
			ccGroupId		INT,
			commUniqId		INT
		)
		insert into @TaskCommcellTouchtable
		select null,
			   CommCellInfo.value('(commcell/@commCellId)[1]','[INT]'),
			   	ISNULL(CommCellInfo.value('(ccGroup/@clientGroupId)[1]','[int]'),0),
			   CommCellInfo.value('@commUniqId','[int]')
		from @request.nodes('WebReport_ProfileReq/taskInfo/commcells') CommCellInfo(CommCellInfo)
		insert into @TaskCommcellTouchtable
		select TouchInfo.value('@val','[int]'),
			  null,null,null
		from  @request.nodes('WebReport_ProfileReq/taskInfo/touchIds') TouchInfo(TouchInfo)
		IF(@taskOwner<=0)
			set @taskOwner = @user
		INSERT INTO ProfileTaskInfo( 	taskSummary	,taskDescription , tasknotes ,taskurl,	taskreportId , taskType ,flags,	status, createdBy,  lastmodifiedby,assignedTo, taskownerId, dueDate,	emailTo,CustomerId)
		SELECT @taskSummary, @taskDescription, @tasknotes, @taskurl, @taskreportId, @taskType, 0 , @status,@user,@user,@taskAssignedTo,@taskOwner,dbo.getdatetime(@dueDate),@emailTo,@TaskcustomerInfoId
		set @taskId  = SCOPE_IDENTITY()
		INSERT INTO ProfileTaskAssociation(taskId, commcellId, ccGroupId,touchId,commUniqId,assocType,customerId)
		select @taskId,
		Case WHEN commcellId <1 THEN NULL
			 ELSE (select id from app_commcell where number = commcellId)
		END
,ccGroupId ,touchId,commUniqId, 1,@custId
		from @TaskCommcellTouchtable
		SET @taskresp =  (SELECT @taskId as '@taskId' , -1 as '@oldstatus',@status as '@newstatus' FOR XML PATH('taskresp')    )
		exec wr_ManageProfileTaskInfoHistory @taskId,@request,@errorCode OUTPUT, @errorString OUTPUT
			IF (@errorCode >0)
		BEGIN
				SET @errorCode = 3
				SET @errorString = 'Failed to update Profile task history Information '
				GOTO CX_ERROR_EXIT
		END
		INSERT INTO ProfileTaskProp (taskId,attrname,attrVal, attrType)
SELECT @taskId, 'startDate',dbo.getdatetime(@startDate), 1
	END
	ELSE IF (@taskOperation =3 ) --EDIT operation for new task check whether we have task by this user.
	BEGIN
		IF NOT EXISTS(SELECT * FROM ProfileTaskInfo t WHERE t.taskId = @taskId )
		BEGIN
			SET @errorCode = 2
			SET @errorString = 'Failed to find ProfileTask, '
			GOTO CX_ERROR_EXIT
		END
		IF EXISTS(SELECT * FROM ProfileTaskInfo WHERE taskId = @taskId )
		BEGIN
			exec wr_ManageProfileTaskInfoHistory @taskId,@request,@errorCode OUTPUT, @errorString OUTPUT
				IF (@errorCode >0)
			BEGIN
					SET @errorCode = 3
					SET @errorString = 'Failed to update Profile task history Information '
					GOTO CX_ERROR_EXIT
			END
			SET @taskresp =  (SELECT @taskId as '@taskId' ,
									 (select status from ProfileTaskInfo(nolock) WHERE taskId = @taskId  ) as '@oldstatus',
									 @status as '@newstatus'
							  FOR XML PATH('taskresp')    )
			UPDATE ProfileTaskInfo
			SET taskSummary =  @taskSummary,
			taskDescription =  @taskDescription,
			tasknotes		=  @tasknotes,
			taskurl			=  @taskurl,
			taskreportId	=  @taskreportId,
			status			=  @status,
			lastmodified	=  getUTCDate(),
			lastmodifiedby  =  @user,
			assignedTo		=  @taskAssignedTo,
			--taskownerId		=  @taskOwner,
			dueDate			=  dbo.getdatetime(@dueDate),
			emailTo			=  @emailTo,
			CustomerId		=  @TaskcustomerInfoId,
			taskType		=  @TaskType
			WHERE taskId = @taskId
		END
		IF EXISTS(SELECT * FROM ProfileTaskProp WHERE taskId = @taskId and attrName ='startDate' )
		BEGIN
			UPDATE prop
			SET prop.attrVal =dbo.getdatetime(@startDate),
			prop.modified = GETUTCDATE(),
prop.status = 1
			FROM ProfileTaskProp prop
			WHERE PROP.taskId =@taskId AND  attrName ='startDate'
		END
		ELSE
		BEGIN
			INSERT INTO ProfileTaskProp (taskId,attrname,attrVal, attrType)
SELECT @taskId, 'startDate',dbo.getdatetime(@startDate), 1
		END
		IF EXISTS(SELECT * FROM ProfileTaskProp WHERE taskId = @taskId and attrName ='statusChangedReason' )
		BEGIN
			UPDATE prop
			SET prop.attrVal =@statusChangedReason,
			prop.modified = GETUTCDATE(),
prop.status = 1
			FROM ProfileTaskProp prop
			WHERE PROP.taskId =@taskId AND  attrName ='statusChangedReason'
		END
		ELSE
		BEGIN
			INSERT INTO ProfileTaskProp (taskId,attrname,attrVal, attrType)
SELECT @taskId, 'statusChangedReason',@statusChangedReason, 1
		END
		IF EXISTS(SELECT * FROM ProfileTaskProp WHERE taskId = @taskId and attrName ='dueDateChangedReason' )
		BEGIN
			UPDATE prop
			SET prop.attrVal =@dueDateChangedReason,
			prop.modified = GETUTCDATE(),
prop.status = 1
			FROM ProfileTaskProp prop
			WHERE PROP.taskId =@taskId AND  attrName ='dueDateChangedReason'
		END
		ELSE
		BEGIN
			INSERT INTO ProfileTaskProp (taskId,attrname,attrVal, attrType)
SELECT @taskId, 'dueDateChangedReason',@dueDateChangedReason, 1
		END
	END
	IF EXISTS(SELECT * FROM ProfileTaskProp WHERE taskId = @taskId and attrName ='internalTask' )
	BEGIN
		UPDATE prop
		SET prop.attrVal =@internalTask,
		prop.modified = GETUTCDATE(),
prop.status = 0
		FROM ProfileTaskProp prop
		WHERE PROP.taskId =@taskId AND  attrName ='internalTask'
	END
	ELSE IF (@internalTask=1)
	BEGIN
		INSERT INTO ProfileTaskProp (taskId,attrname,attrVal, attrType)
SELECT @taskId, 'internalTask',@internalTask, 7
	END
END
ELSE IF (@profileEntity =2) --customer information
BEGIN
	DECLARE   @CustomerInfoAddress NVARCHAR(max)= null
	DECLARE @tamDate BIGINT =0 , @engDate	BIGINT =0
	DECLARE  @CustomerOverview NVARCHAR(max) = null, @CustomerEnvironmentInfo 	NVARCHAR(max) = null
	DECLARE  @CustomerIspaidAccount INT = 0
	DECLARE  @CustomercommcellId INT = 0, @CustomercommUniqId	 INT = 0
	DECLARE @CustomerInfoId int =0
	SELECT
		@CCgroupId					=   ISNULL(custInfo.value('(@customerInfoId)[1]', 'integer'), 0),
		@CustomerInfoName			=	ISNULL(custInfo.value('(@name)[1]','nvarchar(max)'), ''),
		@CustomerInfoAddress		=	ISNULL(custInfo.value('(@address)[1]', 'nvarchar(max)'), ''),
		@tamDate					=   ISNULL(custInfo.value('(@tamDate)[1]', 'BIGINT'), 0),
		@engDate					=   ISNULL(custInfo.value('(@engDate)[1]', 'BIGINT'), 0),
		@status						=	ISNULL(custInfo.value('(@status)[1]', 'integer'), 0),
		@CustomerOverview			=	ISNULL(custInfo.value('(@overview)[1]', 'nvarchar(max)'), ''),
		@CustomerEnvironmentInfo	=	ISNULL(custInfo.value('(@environmentInfo)[1]', 'nvarchar(max)'), ''),
		@CustomerIspaidAccount		=   ISNULL(custInfo.value('(@paidAccount)[1]', 'nvarchar(max)'), ''),
		@CustomercommcellId			=	ISNULL(custInfo.value('(@commcellId)[1]', 'nvarchar(max)'), ''),
		@CustomercommUniqId			=   ISNULL(custInfo.value('(@commUniqId)[1]', 'nvarchar(max)'), ''),
		@CustomerInfouser			=	ISNULL(custInfo.value('(user/@userId)[1]', 'integer'), 0),
		@companyId					=	ISNULL(custInfo.value('(@companyId)[1]', 'integer'), 0)
	From @request.nodes('WebReport_ProfileReq/custInfo') custInfo(custInfo)
	IF (@taskOperation = 1 ) --add operation for new customer info check whether we have that or not
	BEGIN
			INSERT INTO ProfileCustomerInfo( name ,address ,tamDate, engDate, overview, environmentInfo, paidAccount, commUniqId, createdBy,lastModifiedBy,commcellId,ccGroupId,status,reserve1)
			SELECT @CustomerInfoName, @CustomerInfoAddress,dbo.getdatetime(@tamDate) ,dbo.getdatetime(@engDate), @CustomerOverview,
			@CustomerEnvironmentInfo,@CustomerIspaidAccount,@CustomercommUniqId,@CustomerInfouser,@CustomerInfouser,
			Case WHEN @CustomercommcellId <1 THEN 1
					ELSE (select id from app_commcell where number = @CustomercommcellId)
			END, @CCgroupId ,@status,@companyId
			set @CustomerInfoId  = SCOPE_IDENTITY()
			INSERT INTO ProfileTaskAssociation(customerId, ccGroupId, assocType)
select @CustomerInfoId,@CCgroupId, 3
			SET @createDefaultprop = 1
	END
	ELSE IF (@taskOperation =3 ) --EDIT operation for new task check whether we have task by this user.
	BEGIN
		IF NOT EXISTS(SELECT * FROM ProfileCustomerInfo t WHERE ccGroupId = @CCgroupId AND reserve1 = @CompanyId)
		BEGIN
				INSERT INTO ProfileCustomerInfo( name ,address ,tamDate, engDate, overview, environmentInfo, paidAccount, commUniqId, createdBy,lastModifiedBy,commcellId,ccGroupId,status,reserve1)
				SELECT @CustomerInfoName, @CustomerInfoAddress,dbo.getdatetime(@tamDate) ,dbo.getdatetime(@engDate), @CustomerOverview,
				@CustomerEnvironmentInfo,@CustomerIspaidAccount,@CustomercommUniqId,@CustomerInfouser,@CustomerInfouser,
				Case WHEN @CustomercommcellId <1 THEN 1
					 ELSE (select id from app_commcell where number = @CustomercommcellId)
				END, @CCgroupId ,@status, @companyId
				set @CustomerInfoId  = SCOPE_IDENTITY()
				INSERT INTO ProfileTaskAssociation(customerId, ccGroupId, assocType)
select @CustomerInfoId,@CCgroupId,3
				SET @createDefaultprop = 1
		END
		ELSE
		BEGIN
			set @CustomerInfoId = (SELECT customerId FROM ProfileCustomerInfo WHERE ccGroupId = @CCgroupId  AND reserve1 = @CompanyId)
			UPDATE ProfileCustomerInfo
			SET name			=  @CustomerInfoName,
			address				=  @CustomerInfoAddress,
			tamDate				=  dbo.getdatetime(@tamDate),
			engDate				=  dbo.getdatetime(@engDate),
			status				=  @status,
			overview			=  @CustomerOverview,
			environmentInfo		=  @CustomerEnvironmentInfo,
			paidAccount			=  @CustomerIspaidAccount,
			commcellId			=  Case WHEN @CustomercommcellId <1 THEN 1
										ELSE (select id from app_commcell where number = @CustomercommcellId)
									END,
			commUniqId			=  @CustomercommUniqId,
			lastModifiedBy		=  @CustomerInfouser,
			lastModified		=  getUTCDate()
			WHERE customerId = @CustomerInfoId
		END
	END
END
ELSE IF (@profileEntity =3) --touch information
BEGIN
	DECLARE  @touchId INT = 0, @touchDate BIGINT = 0,  @touchcustomerInfoId BIGINT = 0
	DECLARE  @custSatisfaction INT = 0, @cvInfluence INT = 0, @notes NVARCHAR(MAX) =  null, @tamLocation  INT = 0
	DECLARE  @daysSpent FLOAT = 0
	DECLARE  @timePeriodStart INT = 0, @timePeriodEnd INT = 0
	Declare @taskTouchAssoc table
		(
			taskId	INT DEFAULT 0
		)
		insert into @taskTouchAssoc
		select ISNULL(taskIds.value('(@val)[1]','int'), '')
		from @request.nodes('WebReport_ProfileReq/custTouch/taskIds') taskIds(taskIds)
	SELECT
		@touchId				=   ISNULL(custTouch.value('(@touchId)[1]', 'integer'), 0),
		@touchDate				=   ISNULL(custTouch.value('(@touchDate)[1]', 'BIGINT'), 0),
		@CustomerInfouser		=	ISNULL(custTouch.value('(submittedBy/@userId)[1]', 'integer'), 0),
		@ccgroupId				=	ISNULL(custTouch.value('(@customerInfoId)[1]', 'BIGINT'), 0),
		@custSatisfaction		=	ISNULL(custTouch.value('(@custSatisfaction)[1]', 'integer'), 0),
		@cvInfluence		    =	ISNULL(custTouch.value('(@cvInfluence)[1]', 'integer'), 0),
		@notes					=	ISNULL(custTouch.value('(@notes)[1]', 'nvarchar(max)'), ''),
		@tamLocation			=   ISNULL(custTouch.value('(@tamLocation)[1]', 'integer'), 0),
		@daysSpent				=   ISNULL(custTouch.value('(@daysSpent)[1]', 'float'), 0),
		@timePeriodStart		=   ISNULL(custTouch.value('(timePeriodStart/@time)[1]','integer'), ''),
		@timePeriodEnd			=   ISNULL(custTouch.value('(timePeriodEnd/@time)[1]','integer'), ''),
		@companyId				=   ISNULL(custTouch.value('(@companyId)[1]', 'BIGINT'), 0)
	From @request.nodes('WebReport_ProfileReq/custTouch') custTouch(custTouch)
	set @touchcustomerInfoId = (SELECT customerId FROM ProfileCustomerInfo WHERE ccGroupId = @ccgroupId AND reserve1 = @companyId)
	IF (@touchcustomerInfoId IS NULL)
	BEGIN
			SET @errorCode = 3
			SET @errorString = 'Failed to find Profile Customer Information '
			GOTO CX_ERROR_EXIT
	END
	IF (@taskOperation = 1 ) --add touch information for commcell group check whether we have that or not
	BEGIN
		INSERT INTO ProfileCustomerTouch( touchDate ,submittedBy ,customerId, custSatisfaction , cvInfluence ,notes,	tamLocation, daysSpent,createdBy,lastModifiedBy)
		SELECT dbo.getdatetime(@touchDate), @CustomerInfouser, @touchcustomerInfoId,  @custSatisfaction, @cvInfluence, @notes, @tamLocation ,@daysSpent,@CustomerInfouser,@CustomerInfouser
		set @touchId  = SCOPE_IDENTITY()
					INSERT INTO ProfileTaskAssociation(TouchId,customerId, ccGroupId, assocType)
select @touchId,@touchcustomerInfoId,@ccgroupId, 2
		INSERT INTO ProfileTaskAssociation(taskId,TouchId,ccGroupId, assocType,customerId)
				select taskId,@touchId,@ccgroupId,1,@touchcustomerInfoId
				from @taskTouchAssoc
	END
	ELSE IF (@taskOperation =3 ) --EDIT operation for new touch check whether we have task by this user.
	BEGIN
		IF NOT EXISTS(SELECT * FROM ProfileCustomerTouch  WHERE touchId = @touchId )
		BEGIN
			SET @errorCode = 2
			SET @errorString = 'Failed to find CustomertouchInfo, '
			GOTO CX_ERROR_EXIT
		END
		IF EXISTS(SELECT * FROM ProfileCustomerTouch WHERE touchId = @touchId )
		BEGIN
			UPDATE ProfileCustomerTouch
			SET touchDate			=   dbo.getdatetime(@touchDate),
			submittedBy				=  @CustomerInfouser,
			customerId			=  @touchcustomerInfoId,
			custSatisfaction	=  @custSatisfaction,
			cvInfluence			=  @cvInfluence,
			notes			=  @notes,
			tamLocation				=  @tamLocation,
			daysSpent				=  @daysSpent,
			lastModifiedBy		=  @CustomerInfouser,
			lastModified		=  getUTCDate()
			WHERE touchId = @touchId
			UPDATE ProfileTaskAssociation
			set ccGroupId =@ccgroupId
			WHERE touchId = @touchId
and assocType =  2
		END
	END
	IF NOT EXISTS(SELECT * FROM ProfileCustomerTouchProp WHERE touchId = @touchId and attrName ='customertouchStartdate' )
	BEGIN
		IF @timePeriodStart IS NOT NULL AND @timePeriodStart>0
				INSERT INTO ProfileCustomerTouchProp (touchId,attrName	,attrVal, attrType)
SELECT @touchId ,'customertouchStartdate',dbo.getdatetime(@timePeriodStart),1
		IF @timePeriodEnd IS NOT NULL AND @timePeriodEnd>0
				INSERT INTO ProfileCustomerTouchProp (touchId,attrName	,attrVal, attrType)
SELECT @touchId ,'customertouchEnddate',dbo.getdatetime(@timePeriodEnd),1
	END
	ELSE
	BEGIN
			UPDATE prop
			SET prop.attrVal =dbo.getdatetime(@timePeriodStart),
			prop.modified = GETUTCDATE(),
prop.status = 0
			FROM ProfileCustomerTouchProp prop
			WHERE PROP.touchId =@touchId AND  attrName ='customertouchStartdate'
			UPDATE prop
			SET prop.attrVal =dbo.getdatetime(@timePeriodEnd),
			prop.modified = GETUTCDATE(),
prop.status = 0
			FROM ProfileCustomerTouchProp prop
			WHERE PROP.touchId =@touchId AND  attrName ='customertouchEnddate'
	END
END
ELSE IF (@profileEntity =5) --StatusUpdate information
BEGIN
	Declare @ProfileStatusNote table
	(
		statusId			 int ,
		CCgroupId			 int DEFAULT 0,
		submittedBy			 INT,
		submitteddate		  DATETIME DEFAULT GETUTCDATE(),
		currentState		 	nvarchar(max),
		currentStatus			nvarchar(max),
		nextStatus				nvarchar(max),
		status                  int 			DEFAULT 0,
		flags						INT			DEFAULT 0,
		reserve1				INT DEFAULT 0,
		reserve2				NVARCHAR(MAX) DEFAULT null
	)
	insert into @ProfileStatusNote(statusId,CCgroupId,submittedBy,submitteddate,currentState,currentStatus,nextStatus,reserve1)
	SELECT
			ISNULL(weeklyNotes.value('(@statusId)[1]','[int]'), 0),
		    ISNULL(weeklyNotes.value('(group/@clientGroupId)[1]','[int]'), 0),
			ISNULL(weeklyNotes.value('(submittedBy/@userId)[1]','[int]'), 0),
			GETUTCDATE(),
			ISNULL(weeklyNotes.value('(@currentState)[1]','nvarchar(max)'), 0),
		    ISNULL(weeklyNotes.value('(@currentStatus)[1]','nvarchar(max)'), 0),
			ISNULL(weeklyNotes.value('(@nextStatus)[1]','nvarchar(max)'), 0),
			ISNULL(weeklyNotes.value('(group/@companyId)[1]','[int]'), 0)
	From @request.nodes('WebReport_ProfileReq/weeklyNotes') weeklyNotes(weeklyNotes)
	INSERT INTO ProfileStatusNote (statusType,currentState,currentStatus,nextStatus,createdBy,created,lastModifiedBy, CCgroupId ,  customerId,status)
	select 0,currentState,currentStatus,nextStatus,submittedBy,submitteddate,submittedBy,CCgroupId , (SELECT customerId FROM ProfileCustomerInfo WHERE ccGroupId = S.CCgroupId AND reserve1 = S.reserve1), 0
	from @ProfileStatusNote S
	where statusId = 0
	UPDATE pStatus
	SET pStatus.currentStatus = cStatus.currentStatus,
	pStatus.nextStatus = cStatus.nextStatus,
	pStatus.currentState = cStatus.currentState,
	pStatus.lastModifiedBy = cStatus.submittedBy,
	pStatus.lastModified = cStatus.submitteddate
	FROM ProfileStatusNote pStatus INNER JOIN
	@ProfileStatusNote cStatus
	ON pStatus.statusId = cStatus.statusId
END
ELSE IF (@profileEntity =6) --WeeklyMail information
BEGIN
	Declare @ProfileMailInformation table
	(
		customers			XML,
		submittedBy			 INT,
		submitteddate		 DATETIME DEFAULT GETUTCDATE(),
		EmailTo				 nvarchar(max)
	)
	insert into @ProfileMailInformation
	SELECT
		   weeklyMail.query('customers') as 'customers1',
			ISNULL(weeklyMail.value('(submittedBy/@userId)[1]','[int]'), 0),
			GETUTCDATE(),
			ISNULL(weeklyMail.value('(@emailTo)[1]','nvarchar(max)'), '')
	From @request.nodes('WebReport_ProfileReq/weeklyMail') weeklyMail(weeklyMail)
	INSERT INTO ProfileMailingInfo (EmailTo,ccGroupInfo,createdBy,created,lastModifiedBy	)
	SELECT EmailTo,customers,submittedBy,submitteddate,submittedBy
	FROM @ProfileMailInformation W
END
IF (@profileEntity =7 AND @taskOperation =3 ) --this is to update the entities , Which should be used with EDIT operation for existing entity only
BEGIN
	DECLARE @updateCustomerInfoId int =0, @updateStatus int =0
	SELECT
		@ccgroupId			=   ISNULL(custInfo.value('(@customerInfoId)[1]', 'integer'), 0),
		@updateStatus	    =	ISNULL(custInfo.value('(@status)[1]', 'integer'), 0),
		@CustomerInfouser	=	ISNULL(custInfo.value('(user/@userId)[1]', 'integer'), 0),
		@CustomerInfoName	=	ISNULL(custInfo.value('(@name)[1]','nvarchar(max)'), ''),
		@companyId			=   ISNULL(custInfo.value('(@companyId)[1]', 'integer'), 0)
		From @request.nodes('WebReport_ProfileReq/custInfo') custInfo(custInfo)
	set @updateCustomerInfoId = ISNULL((SELECT customerId FROM ProfileCustomerInfo WHERE ccGroupId = @ccgroupId AND reserve1 = @companyId),0)
	IF (@updateCustomerInfoId>0)
	BEGIN
		UPDATE ProfileCustomerInfo
			SET
			status				=  @updateStatus,
			lastModifiedBy		=  @CustomerInfouser,
			lastModified		=  getUTCDate(),
			name				= @CustomerInfoName
			WHERE customerId = @updateCustomerInfoId
	END
	ELSE
	BEGIN
		INSERT INTO ProfileCustomerInfo( name ,address ,tamDate, engDate, overview, environmentInfo, paidAccount,
					 commUniqId, createdBy,lastModifiedBy,commcellId,ccGroupId ,status,reserve1)
						SELECT @CustomerInfoName, '',GETUTCDATE() ,GETUTCDATE(), '','',0,
						0,@CustomerInfouser,@CustomerInfouser,
									 1 ,@ccGroupId,@updateStatus, @companyId
					set @updateCustomerInfoId  = SCOPE_IDENTITY()
			INSERT INTO ProfileTaskAssociation(customerId, ccGroupId, assocType)
select @updateCustomerInfoId,@ccgroupId,  3
		SET @createDefaultprop = 1
	END
END
ELSE IF (@profileEntity =10) --customer CONTACT information
BEGIN
		EXEC wr_ManageProfileContactInfo @request,@errorCode OUTPUT, @errorString OUTPUT
END
DECLARE @xmlNotification XML = null
SELECT  @xmlnotification = req.notification.query('.') from     @request.nodes('/WebReport_ProfileReq/notification') req(notification)
IF (@xmlnotification IS NOT NULL OR @createDefaultprop = 1)
  EXEC wr_ManageProfileProp @taskId,@ccgroupId,@CustomerInfoName,@CustomerInfouser, @createDefaultprop,@request
	IF (@ProcessTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessTran
		SET @ProcessTran = 0
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
IF (XACT_STATE() <> 0 AND @ProcessTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessTran
	SET @ProcessTran = 0
	SELECT @errorCode = 1
	SELECT @errorString = 'Exception  - failed with error :: ' + ERROR_MESSAGE()
END
END CATCH
CX_ERROR_EXIT:
	SET @response = (SELECT @errorCode as '@errorCode' , @errorString as '@errorMessage' FOR XML PATH('msg')    )
	SET @response = (select @response,@taskresp FOR XML PATH('WebReport_ProfileResp')    )
IF (XACT_STATE() <> 0 AND @ProcessTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessTran
	SET @ProcessTran = 0
END
	SELECT @response
GO

IF EXISTS (select * from GxQscripts where name = 'wr_ManageProfileOps')
	delete from GxQscripts where name = 'wr_ManageProfileOps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_ManageProfileOps')
	delete from GXDBVersions where aliasname = 'wr_ManageProfileOps'
GO

insert into GXDBVersions values(2, 'wr_ManageProfileOps',  '00010005000200100000', 'wr_ManageProfileOps', '00010005000200100000')
GO

