

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_ManageProfileFeedbackOps.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_ManageProfileFeedbackOps <<<'

IF EXISTS (select * from sysobjects where name='wr_ManageProfileFeedbackOps')
	drop procedure wr_ManageProfileFeedbackOps
IF EXISTS (select * from GxQscripts where name='wr_ManageProfileFeedbackOps')
	delete from GxQscripts where name = 'wr_ManageProfileFeedbackOps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_ManageProfileFeedbackOps')
	delete from GXDBVersions where aliasname = 'wr_ManageProfileFeedbackOps'
GO
print '... Creating Procedure: wr_ManageProfileFeedbackOps'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_ManageProfileFeedbackOps
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @request XML
AS
  DECLARE @response xml
/*
Message ProfileFeedbackInfo{
     ClientGroupEntity group
     UserEntity      submittedBy
     list<CustomerContact> contacts
     boolean		includeAllContacts
     boolean         quarterly --email will send every 1st day of the quarter
     boolean         sendNow  --email will send immediately
}
Message ProfileFeedbackReq{
	list<ProfileFeedbackInfo> feedbackInfoList
}
*/
DECLARE @errorString NVARCHAR(MAX) =''
DECLARE @errorCode INT  =0
DECLARE @ProcessTran INT = 0
DECLARE @ImmediateFeedback XML = NULL
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessTran
		SET @ProcessTran = 1
	END
DECLARE @FIXEDTASK INT =2
DECLARE @OPENTASK INT =1
	DECLARE @FEEDBACKQURTERLY nVARCHAR(MAX)='feedbackQuarterly'
	DECLARE @FEEDBACKNOTIFYALLCONTACTS nVARCHAR(MAX)='feedbackNotifyAllContacts'
	DECLARE @FEEDBACKNOTIFYCONTACTS nVARCHAR(MAX)='feedbackNotifyContacts'
	Declare @ProfileFeedbackTask table
	(
		ccGroupId		INT	,
		ccGroupName		nvarchar(max)	,
		submittedBy		INT ,
		bAllContact		INT ,
		sendNow			INT ,
		quarterly		INT,
		Allcontacts		xml,
		customerId		INT
	)
	Declare @ProfileFeedbackCustomerContact table
	(
		ccGroupId		INT	,
		contactId		INT,
		userId			INT
	)
	Declare @ProfileFeedbackContactList table
	(
		customerId		INT	,
		ccGroupId		INT	,
		contactList		xml
	)
	insert into @ProfileFeedbackTask(ccGroupId, ccGroupName, submittedBy, bAllContact, sendNow,	quarterly, Allcontacts)
	select
			feedbackInfoList.value('(group/@clientGroupId)[1]','[INT]'),
			feedbackInfoList.value('(group/@clientGroupName)[1]','nvarchar(max)'),
			feedbackInfoList.value('(submittedBy /@userId)[1]','[INT]'),
			feedbackInfoList.value('@includeAllContacts','[int]'),
			feedbackInfoList.value('@sendNow','[int]'),
			feedbackInfoList.value('@quarterly','[int]'),
			feedbackInfoList.query('contacts') as Allcontacts
	from @request.nodes('WebReport_ProfileFeedbackReq')as ReqInfo(ReqInfo)
		CROSS apply ReqInfo.nodes('feedbackInfoList') AS feedbackInfoList(feedbackInfoList)
	insert into @ProfileFeedbackCustomerContact
	select task.ccGroupId,
	contacts.value('@contactId','[int]'),
	contacts.value('(name/@userId)[1]','[INT]')
	from @ProfileFeedbackTask task
	CROSS apply task.Allcontacts.nodes('contacts') AS contacts(contacts)
	--where quarterly =1
	-- All these client group must be having customer created no need to check/create here.
	update feedbacktask
	set customerId = ccInfo.customerId
	FROM @ProfileFeedbackTask feedbacktask
	inner join ProfileCustomerInfo ccInfo
	on ccInfo.ccGroupId = feedbacktask.ccGroupId
	INSERT INTO @ProfileFeedbackContactList
	select t.customerId,t.ccGroupId, (select contactId as'@contactId', userId as 'name/@userId'   from @ProfileFeedbackCustomerContact C
	where C.ccGroupId =t.ccGroupId
	--for xml path('contacts')) as data
	for xml path('contacts'),root('WebReport_FeedbackQuerterlyContactList')) as data
	from @ProfileFeedbackTask t
	group by t.customerId,t.ccGroupId
	--create dummy task for sending notification every Quarterly taskType SHOULD BE 2 ONLY
declare @taskType INT = 2
	INSERT INTO ProfileTaskInfo( 	taskSummary	,taskDescription , tasknotes ,taskurl,	taskreportId ,
									taskType ,flags,	status, createdBy,  lastmodifiedby,
									assignedTo, taskownerId, 	emailTo,CustomerId)
	SELECT 'Feedback Task Request', 'Feedback Task Request', 'Feedback Task Request', '' ,0,
			 @taskType, 0 , @OPENTASK,submittedBy,submittedBy,
			 submittedBy,submittedBy,'', feedbacktask.customerId
	FROM @ProfileFeedbackTask feedbacktask
	inner join @ProfileFeedbackContactList list
	on list.customerId = feedbacktask.customerId and feedbacktask.quarterly =1
	LEFT OUTER JOIN
	ProfileTaskInfo task ON
	task.customerId  =feedbacktask.customerId
	AND task.taskType = @taskType
	WHERE task.customerId IS NULL
	--update OLD feedback task status  type SHOULD BE 2 ONLY
	update task
	set lastmodifiedby = feedbacktask.submittedBy,
	status= CASE WHEN  feedbacktask.quarterly =0 THEN @FIXEDTASK ELSE @OPENTASK END
	FROM ProfileTaskInfo task
	inner join @ProfileFeedbackTask feedbacktask
	on
	task.customerId = feedbacktask.customerId
	AND task.taskType = @taskType
	--create association only once
	INSERT INTO ProfileTaskAssociation(taskId, commcellId, ccGroupId,touchId,commUniqId,assocType,customerId)
	select task.taskId,1,(SELECT ccGroupId FROM ProfileCustomerInfo WHERE  customerId = task.CustomerId),NULL,NULL,1,task.CustomerId
	FROM ProfileTaskInfo task
	inner join @ProfileFeedbackTask feedbacktask
	on
	task.customerId = feedbacktask.customerId
	and feedbacktask.quarterly =1 	AND task.taskType = @taskType
	LEFT OUTER JOIN
	ProfileTaskAssociation taskAssoc ON
	task.taskId  =taskAssoc.taskId
	WHERE taskAssoc.taskId IS NULL
	-- now create task properties to do feedback operation Quarterly for new feedback task
	INSERT INTO ProfileTaskProp (taskId,attrname,attrVal, attrType)
SELECT task.taskId, @FEEDBACKQURTERLY,'1',7
	FROM ProfileTaskInfo task
	inner join @ProfileFeedbackTask feedbacktask
	on
	task.customerId = feedbacktask.customerId  	AND task.status = @OPENTASK
	AND task.taskType = @taskType
	LEFT OUTER JOIN
	ProfileTaskProp prop ON
	task.taskId  =prop.taskId
	 AND prop.attrname = @FEEDBACKQURTERLY
	WHERE prop.taskId IS NULL
	-- turn ON/off feedback task WHICH ARE OPEN/FIXED
	UPDATE prop
	SET prop.attrVal =  CASE WHEN task.status= @FIXEDTASK THEN '0'ELSE '1' END ,
	prop.modified = GETUTCDATE(),
prop.status = CASE WHEN task.status= @FIXEDTASK THEN 1 ELSE 0 END
	FROM ProfileTaskProp  prop INNER JOIN ProfileTaskInfo task ON
	task.taskId  =prop.taskId AND task.taskType = @taskType
	inner join @ProfileFeedbackTask feedbacktask
	on
	task.customerId = feedbacktask.customerId
	AND  prop.attrname = @FEEDBACKQURTERLY
	-- now create task properties FOR feedback REQUIRED FOR ALL CONTACT OR NOT
	INSERT INTO ProfileTaskProp (taskId,attrname,attrVal, attrType)
SELECT task.taskId, @FEEDBACKNOTIFYALLCONTACTS,'1',7
	FROM ProfileTaskInfo task
	inner join @ProfileFeedbackTask feedbacktask
	on
	task.customerId = feedbacktask.customerId AND feedbacktask.bAllContact = 1 	AND task.status = @OPENTASK
	AND task.taskType = @taskType
	LEFT OUTER JOIN
	ProfileTaskProp prop ON
	task.taskId  =prop.taskId
	AND prop.attrname = @FEEDBACKNOTIFYALLCONTACTS
	WHERE prop.taskId IS NULL
	-- turn ON/off feedback task WHICH ARE OPEN/FIXED
	UPDATE prop
	SET prop.attrVal =  CASE WHEN feedbacktask.bAllContact = 1 THEN '1'ELSE '0' END ,
	prop.modified = GETUTCDATE(),
prop.status = CASE WHEN task.status= @FIXEDTASK THEN 1 ELSE 0 END
	FROM ProfileTaskProp  prop INNER JOIN ProfileTaskInfo task ON
	task.taskId  =prop.taskId AND task.taskType = @taskType
	inner join @ProfileFeedbackTask feedbacktask
	on
	task.customerId = feedbacktask.customerId
	AND   prop.attrname = @FEEDBACKNOTIFYALLCONTACTS
	-- now create task properties to have select contact list
	-- presently let's keep complete xml , later only contact id required.
	INSERT INTO ProfileTaskProp (taskId,attrname,attrVal, attrType)
SELECT task.taskId, @FEEDBACKNOTIFYCONTACTS,cast(cList.contactList as nvarchar(max)),1
	FROM ProfileTaskInfo task
	inner join @ProfileFeedbackContactList cList
	on
	task.customerId = cList.customerId and cList.contactList  IS NOT NULL
	AND task.status = @OPENTASK AND task.taskType = @taskType
	LEFT OUTER JOIN
	ProfileTaskProp prop ON
	task.taskId  =prop.taskId
	AND prop.attrname = @FEEDBACKNOTIFYCONTACTS
	WHERE prop.taskId IS NULL
	-- turn ON/off feedback contactList WHICH ARE OPEN/FIXED
	UPDATE prop
	SET prop.attrVal =  CASE WHEN task.status= @OPENTASK  THEN isnull(cast(cList.contactList as nvarchar(max)),'') ELSE '' END ,
	prop.modified = GETUTCDATE(),
prop.status = CASE WHEN task.status= @FIXEDTASK THEN 1 ELSE 0 END
	FROM ProfileTaskProp  prop INNER JOIN ProfileTaskInfo task ON
	task.taskId  =prop.taskId AND task.taskType = @taskType
	inner join @ProfileFeedbackContactList cList
	on
	task.customerId = cList.customerId
	AND   prop.attrname = @FEEDBACKNOTIFYCONTACTS
	set @ImmediateFeedback =(SELECT  task.customerId   AS '@customerId',
			task.ccGroupId    AS '@ccGroupId',
			task.bAllContact  AS '@bAllContact',
			--list.contactList.query('contacts')
			list.contactList.query('WebReport_FeedbackQuerterlyContactList/contacts')
	 FROM @ProfileFeedbackTask task
	INNER JOIN @ProfileFeedbackContactList list
	ON task.ccGroupId =list.ccGroupId
	and task.sendNow =1
	FOR XML PATH ('ImmediateFeedback'))
	IF (@ProcessTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessTran
		SET @ProcessTran = 0
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
IF (XACT_STATE() <> 0 AND @ProcessTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessTran
	SET @ProcessTran = 0
	SELECT @errorCode = 1
	SELECT @errorString = 'Exception  - failed with error :: ' + ERROR_MESSAGE()
END
END CATCH
CX_ERROR_EXIT:
	SET @response = (SELECT @errorCode as '@errorCode' , @errorString as '@errorMessage' FOR XML PATH('msg')    )
	SET @response = (select @response,@ImmediateFeedback FOR XML PATH('WebReport_ProfileFeedbackResp')    )
IF (XACT_STATE() <> 0 AND @ProcessTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessTran
	SET @ProcessTran = 0
END
	SELECT @response
GO

IF EXISTS (select * from GxQscripts where name = 'wr_ManageProfileFeedbackOps')
	delete from GxQscripts where name = 'wr_ManageProfileFeedbackOps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_ManageProfileFeedbackOps')
	delete from GXDBVersions where aliasname = 'wr_ManageProfileFeedbackOps'
GO

insert into GXDBVersions values(2, 'wr_ManageProfileFeedbackOps',  '00010003000200050000', 'wr_ManageProfileFeedbackOps', '00010003000200050000')
GO

