

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_ManageProfileContactInfo.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_ManageProfileContactInfo <<<'

IF EXISTS (select * from sysobjects where name='wr_ManageProfileContactInfo')
	drop procedure wr_ManageProfileContactInfo
IF EXISTS (select * from GxQscripts where name='wr_ManageProfileContactInfo')
	delete from GxQscripts where name = 'wr_ManageProfileContactInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_ManageProfileContactInfo')
	delete from GXDBVersions where aliasname = 'wr_ManageProfileContactInfo'
GO
print '... Creating Procedure: wr_ManageProfileContactInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_ManageProfileContactInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @request XML,
  @errorCode INTEGER OUTPUT,
  @errorString NVARCHAR(MAX) OUTPUT
AS
DECLARE @profileEntity INT = 0,@taskOperation INT =0
DECLARE @ProcessTran INT
SET @ProcessTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessTran
		SET @ProcessTran = 1
	END
SELECT
	@profileEntity = ISNULL(@request.value('(/WebReport_ProfileReq/@entity)[1]', 'integer'), 0),
	@taskOperation = ISNULL(@request.value('(/WebReport_ProfileReq/@operation)[1]', 'integer'), 0)
IF (@profileEntity =10) --CUSTOMER CONTACT information
BEGIN
	DECLARE @ccGroupId INT = 0
	DECLARE @ccuser INT = 0
	DECLARE @companyId INT = 0
	SELECT
		@ccGroupId	=	ISNULL(contactInfo.value('(cggroup/@clientGroupId)[1]','[int]'),0),
		@ccuser		=   contactInfo.value('(user/@userId)[1]', '[int]'),
		@companyId  =   ISNULL(contactInfo.value('(company/@userGroupId)[1]', '[int]'),0)
	From @request.nodes('WebReport_ProfileReq/contactInfo') contactInfo(contactInfo)
	DECLARE @CustomerId INT  = 0
	IF (@companyId > 0)
			SELECT  @CustomerId = customerId FROM ProfileCustomerInfo t WHERE reserve1  = @companyId
	ELSE
	IF (@ccGroupId > 0)
			SELECT @CustomerId =  customerId FROM ProfileCustomerInfo t WHERE ccGroupId = @ccgroupId
	ELSE
		RETURN
	-- UPDATE EXISTING PROFILE CUSTOMER CONTACT AS DELETED
	/*UPDATE  ProfileCustomerContact
	SET status = 1
	WHERE customerInfoId =   @CustomerId
	*/
	Declare @CustomerContact table
	(
		userId				int null,
		name				NVARCHAR(max) null,
		title				NVARCHAR(max) null,
		email				NVARCHAR(MAX) null,
		phone				NVARCHAR(max) null,
		isPrimaryContact	INT DEFAULT 0,
		contactgroup	INT DEFAULT 0,
		contactId	INT		DEFAULT 0,
		status		INT		DEFAULT 0
	)
	INSERT INTO @CustomerContact
	SELECT
			ISNULL(contacts.value('(name/@userId)[1]', 'integer'), 0),
			ISNULL(contacts.value('(name/@userName)[1]','nvarchar(max)'), ''),
			ISNULL(contacts.value('(@title)[1]','nvarchar(max)'), ''),
			ISNULL(contacts.value('(@email)[1]','nvarchar(max)'), ''),
			ISNULL(contacts.value('(@phone)[1]','nvarchar(max)'), ''),
			ISNULL(contacts.value('(@primaryContact)[1]','INT'), ''),
			ISNULL(contacts.value('(@group)[1]','INT'), 0),
			ISNULL(contacts.value('(@contactId)[1]','INT'), 0),
			ISNULL(contacts.value('(@status)[1]','INT'), 0)
	FROM @request.nodes('WebReport_ProfileReq/contactInfo/contacts') contacts(contacts)
	INSERT INTO ProfileCustomerContact(CustomerInfoId, contactName , contactTitle, contactEmail, contactPhone, isPrimaryContact,contactgroup,contactUserId)
	SELECT @CustomerId ,CASE WHEN userId>0 THEN '' ELSE name END , title, CASE WHEN userId>0 THEN '' ELSE email END , phone, isPrimaryContact,contactgroup,userId
	FROM @CustomerContact
	WHERE contactId=0
	UPDATE contacts
	SET
	contacts.contactTitle		= CC.title,
	contacts.contactPhone		= CC.phone,
	contacts.isPrimaryContact	= CC.isPrimaryContact,
	contacts.contactgroup		= CC.contactgroup,
	contacts.contactUserId		= CC.userId,
	contacts.status				= CC.status,
	contacts.contactName		=CASE WHEN CC.userId>0 THEN '' ELSE CC.name END,
	contacts.contactEmail		= CASE WHEN CC.userId>0 THEN '' ELSE CC.email END
	FROM ProfileCustomerContact contacts INNER JOIN
	@CustomerContact CC
	ON contacts.contactId = CC.contactId
	Declare @ContractDates table
	(
		contractId				int ,
		contractType			int DEFAULT 1,
		startDate				int,
		endDate		 		    int,
		submittedBy				INT,
		submitteddate		    DATETIME DEFAULT GETUTCDATE(),
		ccGroupId				INT		null,
		commcellId				INT		null,
		CustomerInfoId			INT,
		status                  int 		DEFAULT 0,
		flags					INT			DEFAULT 0,
		reserve1				INT DEFAULT 0,
		reserve2				NVARCHAR(MAX) DEFAULT null
	)
	insert into @ContractDates(contractId,contractType,startDate,endDate,submittedBy,submitteddate,ccGroupId,commcellId,CustomerInfoId,reserve1)
			select ISNULL(contractDates.value('(@contractId)[1]', 'integer'), 0),
					ISNULL(contractDates.value('(@contractType)[1]', 'integer'), 0),
					ISNULL(contractDates.value('(startDate/@time)[1]','integer'), ''),
					ISNULL(contractDates.value('(endDate/@time)[1]','integer'), ''),
					@ccuser,GETUTCDATE(),
					@ccGroupId,
					1,
					@CustomerId	,
					@companyId
			from @request.nodes('WebReport_ProfileReq/contactInfo/contractDates') contractDates(contractDates)
	-- UPDATE EXISTING PROFILE CUSTOMER CONTACT AS DELETED
	UPDATE  ProfileContractDates
	SET status = 1
	WHERE customerId =   @CustomerId
-- to insert new date
	INSERT INTO ProfileContractDates(contractType,startDate,endDate,createdBy,created,lastModifiedBy, CCgroupId , commcellId, customerId,status,reserve1)
	select contractType,dbo.getdatetime(startDate),dbo.getdatetime(endDate),submittedBy,submitteddate,submittedBy, CCgroupId , commcellId, CustomerInfoId,0,reserve1
	from @ContractDates
	where contractId = 0
	UPDATE cDates
	SET cDates.startDate = dbo.getdatetime(dates.startDate),
	cDates.endDate = dbo.getdatetime(dates.endDate),
	cDates.lastModifiedBy = dates.submittedBy,
	cDates.lastModified = dates.submitteddate,
	cDates.status = 0
	FROM ProfileContractDates cDates INNER JOIN
	@ContractDates dates
	ON dates.contractId = cDates.contractId
END
	IF (@ProcessTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessTran
		SET @ProcessTran = 0
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
IF (XACT_STATE() <> 0 AND @ProcessTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessTran
	SET @ProcessTran = 0
	SELECT @errorCode = 1
	SELECT @errorString = 'Exception  - failed with error :: ' + ERROR_MESSAGE()
END
END CATCH
CX_ERROR_EXIT:
	SELECT @errorCode = 0
	SELECT @errorString = ''
IF (XACT_STATE() <> 0 AND @ProcessTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessTran
	SET @ProcessTran = 0
END
GO

IF EXISTS (select * from GxQscripts where name = 'wr_ManageProfileContactInfo')
	delete from GxQscripts where name = 'wr_ManageProfileContactInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_ManageProfileContactInfo')
	delete from GXDBVersions where aliasname = 'wr_ManageProfileContactInfo'
GO

insert into GXDBVersions values(2, 'wr_ManageProfileContactInfo',  '00010001000200040000', 'wr_ManageProfileContactInfo', '00010001000200040000')
GO

