

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_ManageProfileContactHistory.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='wr_ManageProfileContactHistory')
BEGIN
	print '>>> Drop Stored Procedure: wr_ManageProfileContactHistory <<<'
	drop procedure wr_ManageProfileContactHistory
END
IF EXISTS (select * from GxQscripts where name='wr_ManageProfileContactHistory')
	delete from GxQscripts where name = 'wr_ManageProfileContactHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_ManageProfileContactHistory')
	delete from GXDBVersions where aliasname = 'wr_ManageProfileContactHistory'
GO
print '... Creating Procedure: wr_ManageProfileContactHistory'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_ManageProfileContactHistory
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_contactId INT,	
  @i_status INT ,
  @errorCode INTEGER OUTPUT,
  @errorString NVARCHAR(MAX) OUTPUT
AS
DECLARE @ProcessTran INT
SET @ProcessTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessTran
		SET @ProcessTran = 1
	END
	DECLARE @status INT = (SELECT status from ProfileCustomerContact (NOLOCK) where contactId = @i_contactId)
	IF @status = @i_status
		GOTO CX_ERROR_EXIT
	DECLARE @attrVal VARCHAR(128)
	SET @attrVal =  (SELECT CASE WHEN @i_status = 1 THEN 'Inactive' ELSE 'Active' END )
	UPDATE ProfileCustomerContact
	SET status = @i_status
	where contactId = @i_contactId
	UPDATE ProfileCustomerContactHistory
	SET modified = getUTCdate()
	where attrName = 'status'
	and attrType = 1
	and contactId = @i_contactId
	and modified IS NULL
	INSERT INTO ProfileCustomerContactHistory(contactId, attrName, AttrType,AttrVal)
	select @i_contactId,'status',1,@attrval
IF (@ProcessTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessTran
		SET @ProcessTran = 0
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
IF (XACT_STATE() <> 0 AND @ProcessTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessTran
	SET @ProcessTran = 0
	SELECT @errorCode = 1
	SELECT @errorString = 'Exception  - failed with error :: ' + ERROR_MESSAGE()
END
END CATCH
CX_ERROR_EXIT:
IF (XACT_STATE() <> 0 AND @ProcessTran = 1)
BEGIN
    ROLLBACK TRANSACTION ProcessTran
    SET @ProcessTran = 0
END
GO

IF EXISTS (select * from GxQscripts where name = 'wr_ManageProfileContactHistory')
	delete from GxQscripts where name = 'wr_ManageProfileContactHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_ManageProfileContactHistory')
	delete from GXDBVersions where aliasname = 'wr_ManageProfileContactHistory'
GO

insert into GXDBVersions values(2, 'wr_ManageProfileContactHistory',  '00010001000200010000', 'wr_ManageProfileContactHistory', '00010001000200010000')
GO

