

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_ManageCommCellProfileTaskInfoHistory.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_ManageCommCellProfileTaskInfoHistory <<<'

IF EXISTS (select * from sysobjects where name='wr_ManageCommCellProfileTaskInfoHistory')
	drop procedure wr_ManageCommCellProfileTaskInfoHistory
IF EXISTS (select * from GxQscripts where name='wr_ManageCommCellProfileTaskInfoHistory')
	delete from GxQscripts where name = 'wr_ManageCommCellProfileTaskInfoHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_ManageCommCellProfileTaskInfoHistory')
	delete from GXDBVersions where aliasname = 'wr_ManageCommCellProfileTaskInfoHistory'
GO
print '... Creating Procedure: wr_ManageCommCellProfileTaskInfoHistory'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_ManageCommCellProfileTaskInfoHistory
  @request XML ,
  @tableInfo NVARCHAR(MAX),
  @tableProp NVARCHAR(MAX),
  @errorCode INTEGER OUTPUT,
  @errorString NVARCHAR(MAX) OUTPUT
AS
/*
This sp will be single point to update the given task history
*/
DECLARE @i_taskId	 INT = 0
DECLARE @ProcessTran INT
SET @ProcessTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessTran
		SET @ProcessTran = 1
	END
	DECLARE @profileEntity INT = 0,@taskOperation INT =0
	DECLARE  @dueDate BIGINT = 0
	SELECT
		@profileEntity = ISNULL(@request.value('(/WebReport_CommcellProfileReq/@entity)[1]', 'integer'), 0),
		@taskOperation = ISNULL(@request.value('(/WebReport_CommcellProfileReq/@operation)[1]', 'integer'), 0)
	IF object_id('tempdb.dbo.#CSProfileTaskInfo') is null
	BEGIN
		SELECT @errorCode = 10553, @errorString = 'No task information input for history'
		GOTO CX_ERROR_EXIT;
	END
	 DECLARE @opId INT= 1
	IF (@profileEntity !=1)
	BEGIN
		SELECT @errorCode = 10553, @errorString = 'incorrect entity type for commcell profile history'
		GOTO CX_ERROR_EXIT;
	END
 IF ( CURSOR_STATUS('global', 'taskCur') >= 0  /* cursor is open */
        OR CURSOR_STATUS('local', 'taskCur') >= 0 )
    CLOSE taskCur
    IF ( CURSOR_STATUS('global','taskCur') = -1  /* cursor is closed */
        OR CURSOR_STATUS('local','taskCur') = -1 )
    DEALLOCATE taskCur
	DECLARE	taskCur CURSOR FOR
	SELECT	R.taskId
	FROM	#CSProfileTaskInfo AS R INNER JOIN ProfileTaskInfo(NOLOCK) F
		 ON F.taskId = R.taskId
	ORDER BY R.taskId ASC
OPEN taskCur
FETCH FROM taskCur INTO @i_taskId
WHILE @@FETCH_STATUS = 0
BEGIN
	-- New task or existing task which is not yet available for history
	IF NOT EXISTS(SELECT * FROM ProfileTaskInfoHistory t WHERE taskId = @i_taskId )
	BEGIN
		INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId, @opId,'taskSummary',1,taskSummary
		FROM ProfileTaskInfo(NOLOCK) t WHERE t.taskId = @i_taskId
		INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId, @opId,'taskDescription',1,taskDescription
		FROM ProfileTaskInfo(NOLOCK) t WHERE t.taskId = @i_taskId
		INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId, @opId,'taskurl',1,taskurl
		FROM ProfileTaskInfo(NOLOCK) t WHERE t.taskId = @i_taskId
		INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId, @opId,'taskType',7,taskType
		FROM ProfileTaskInfo(NOLOCK) t WHERE t.taskId = @i_taskId
		INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId, @opId,'status',7,status
		FROM ProfileTaskInfo(NOLOCK) t WHERE t.taskId = @i_taskId
		INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId, @opId,'dueDate',1,dueDate
		FROM ProfileTaskInfo(NOLOCK) t WHERE t.taskId = @i_taskId
		INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId, @opId,'assignedTo',7,assignedTo
		FROM ProfileTaskInfo(NOLOCK) t WHERE t.taskId = @i_taskId
		INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId, @opId,'lastModifiedBy',7,lastModifiedBy
		FROM ProfileTaskInfo(NOLOCK) t WHERE t.taskId = @i_taskId
		INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
		SELECT @i_taskId, @opId,prop.attrName,prop.attrType,prop.attrVal
		FROM ProfileTaskProp prop
			WHERE prop.taskId = @i_taskId
	END
	--EDIT operation lets record only modified
	IF (@taskOperation = 3 )
	BEGIN
		SET @opId =(SELECT isnull(MAX(opId),1) from ProfileTaskInfoHistory(NOLOCK)  where  taskId = @i_taskId )
		SET @opId = @opId + 1
		DECLARE  @bchanged INT = 0
		IF NOT EXISTS(SELECT * FROM ProfileTaskInfo (NOLOCK) t INNER JOIN #CSProfileTaskInfo I ON t.taskId = I.taskId AND t.taskId = @i_taskId  AND t.taskSummary = I.taskSummary AND DATALENGTH(T.taskSummary) = DATALENGTH(I.taskSummary) )
		BEGIN
			INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId,  @opId, 'taskSummary',1, I.taskSummary
			FROM #CSProfileTaskInfo I WHERE  I.taskId = @i_taskId
			SET @bchanged =  1
		END
		IF NOT EXISTS(SELECT * FROM ProfileTaskInfo (NOLOCK) t INNER JOIN #CSProfileTaskInfo I ON t.taskId = I.taskId AND t.taskId = @i_taskId  AND t.taskDescription = I.description AND DATALENGTH(T.taskDescription) = DATALENGTH(I.description) )
		BEGIN
			INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId,  @opId ,'taskDescription',1,I.description
			FROM #CSProfileTaskInfo I WHERE  I.taskId = @i_taskId
			SET @bchanged =  1
		END
		IF NOT EXISTS(SELECT * FROM ProfileTaskInfo (NOLOCK) t INNER JOIN #CSProfileTaskInfo I ON t.taskId = I.taskId AND t.taskId = @i_taskId  AND t.taskurl = I.url AND DATALENGTH(T.taskurl) = DATALENGTH(I.url) )
		BEGIN
			INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId,  @opId ,'taskurl',1, I.url
			FROM #CSProfileTaskInfo I WHERE  I.taskId = @i_taskId
			SET @bchanged =  1
		END
		IF NOT EXISTS(SELECT * FROM ProfileTaskInfo (NOLOCK) t INNER JOIN #CSProfileTaskInfo I ON t.taskId = I.taskId AND t.taskId = @i_taskId  AND t.dueDate =  Cast(dbo.GetDateTime(I.dueDate ) as date)  )
		BEGIN
			INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId,  @opId ,'dueDate',1,dbo.GetDateTime(I.dueDate)
			FROM #CSProfileTaskInfo I WHERE  I.taskId = @i_taskId
			SET @bchanged =  1
		END
		IF NOT EXISTS(SELECT * FROM ProfileTaskInfo (NOLOCK) t INNER JOIN #CSProfileTaskInfo I ON t.taskId = I.taskId AND t.taskId = @i_taskId  AND t.status = I.status )
		BEGIN
			INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId,  @opId ,'status',7,I.status
			FROM #CSProfileTaskInfo I WHERE  I.taskId = @i_taskId
			SET @bchanged =  1
		END
		IF NOT EXISTS(SELECT * FROM ProfileTaskInfo (NOLOCK) t INNER JOIN #CSProfileTaskInfo I ON t.taskId = I.taskId AND t.taskId = @i_taskId  AND t.assignedTo = I.taskAssignedTo )
		BEGIN
			INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId,  @opId ,'assignedTo',7,I.taskAssignedTo
			FROM #CSProfileTaskInfo I WHERE  I.taskId = @i_taskId
			SET @bchanged =  1
		END
		IF NOT EXISTS(SELECT * FROM ProfileTaskInfo (NOLOCK) t INNER JOIN #CSProfileTaskInfo I ON t.taskId = I.taskId AND t.taskId = @i_taskId  AND t.taskType = I.taskType )
		BEGIN
			INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId,  @opId ,'taskType',7,I.taskAssignedTo
			FROM #CSProfileTaskInfo I WHERE  I.taskId = @i_taskId
			SET @bchanged =  1
		END
		IF NOT EXISTS(SELECT * FROM ProfileTaskProp(NOLOCK) t INNER JOIN #CSProfileTaskInfo I ON t.taskId = I.taskId AND t.taskId = @i_taskId  AND t.attrName = 'startDate' AND  t.attrVal = CAST(dbo.getdatetime(I.startDate) AS NVARCHAR(255)))
		BEGIN
			INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId, @opId,'startDate',1,CAST(dbo.getdatetime(I.startDate) AS NVARCHAR(255))
			FROM #CSProfileTaskInfo I WHERE  I.taskId = @i_taskId
			SET @bchanged =  1
		END
		IF object_id('tempdb.dbo.#IdentityTable1') is not null DROP TABLE #IdentityTable1
		CREATE TABLE #IdentityTable1
		(
		  taskId				INT,
		  opId					INT,
		  attrName				nvarchar(max)
		 )
		INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
		OUTPUT Inserted.taskId, Inserted.opId,  Inserted.attrName INTO #IdentityTable1(taskId	,opId , attrName)
		SELECT @i_taskId, @opId,propNew.taskPropName,propNew.taskPropValType,propNew.taskPropVal
		FROM #CSProfileTasProp propNew
		LEFT OUTER JOIN ProfileTaskProp T
		ON t.taskId = propNew.taskId AND t.attrName = propNew.taskPropName AND t.attrVal = propNew.taskPropVal
		WHERE T.taskId IS NULL
		IF ((SELECT COUNT(*) FROM #IdentityTable1)>0)
			SET @bchanged =  1
		DROP TABLE #IdentityTable1
		--this is not default property for all task so check whether it is on for task or EXISTS
		IF( @bchanged =  1)
		BEGIN
			INSERT INTO ProfileTaskInfoHistory(	taskId	,opId , attrName ,attrType,	attrVal)
SELECT @i_taskId, @opId,'lastModifiedBy',7, I.taskOwner
			FROM #CSProfileTaskInfo I WHERE  I.taskId = @i_taskId
		END
FETCH FROM taskCur INTO @i_taskId
END
CLOSE taskCur
DEALLOCATE taskCur
	END
	IF (@ProcessTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessTran
		SET @ProcessTran = 0
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
IF (XACT_STATE() <> 0 AND @ProcessTran = 1)
BEGIN
 --Close cursor
    IF ( CURSOR_STATUS('global', 'taskCur') >= 0  /* cursor is open */
        OR CURSOR_STATUS('local', 'taskCur') >= 0 )
    CLOSE taskCur
    IF ( CURSOR_STATUS('global','taskCur') = -1  /* cursor is closed */
        OR CURSOR_STATUS('local','taskCur') = -1 )
    DEALLOCATE taskCur
	ROLLBACK TRANSACTION ProcessTran
	SET @ProcessTran = 0
	SELECT @errorCode = 1
	SELECT @errorString = 'Exception  - failed with error :: ' + ERROR_MESSAGE()
END
END CATCH
CX_ERROR_EXIT:
GO

IF EXISTS (select * from GxQscripts where name = 'wr_ManageCommCellProfileTaskInfoHistory')
	delete from GxQscripts where name = 'wr_ManageCommCellProfileTaskInfoHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_ManageCommCellProfileTaskInfoHistory')
	delete from GXDBVersions where aliasname = 'wr_ManageCommCellProfileTaskInfoHistory'
GO

insert into GXDBVersions values(2, 'wr_ManageCommCellProfileTaskInfoHistory',  '00010001000400030000', 'wr_ManageCommCellProfileTaskInfoHistory', '00010001000400030000')
GO

