

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_ManageCommCellProfileOps.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_ManageCommCellProfileOps <<<'

IF EXISTS (select * from sysobjects where name='wr_ManageCommCellProfileOps')
	drop procedure wr_ManageCommCellProfileOps
IF EXISTS (select * from GxQscripts where name='wr_ManageCommCellProfileOps')
	delete from GxQscripts where name = 'wr_ManageCommCellProfileOps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_ManageCommCellProfileOps')
	delete from GXDBVersions where aliasname = 'wr_ManageCommCellProfileOps'
GO
print '... Creating Procedure: wr_ManageCommCellProfileOps'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_ManageCommCellProfileOps
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @request XML
AS
  DECLARE @response xml
/*
--Profile messages start
Message ProfileTaskProp
{
     int		   taskId = 0
	 wstring       attrName
	 int           attrType
	 wstring       attrVal
	 int		   status = 0   --0 Add, 1 Deleted
}
Message CommcellProfileTask
{
     ProfileTaskInfo taskInfo
	 list<ProfileTaskProp>		taskProps
}
Message CommcellProfileReq
{
     ProfileEntity entity
     OperationType operation
	  list<CommcellProfileTask> tasks
}
Message GetCommcellProfileReq
{
     ProfileTaskProp prop
}
Message CommcellProfileResp
{
     GenericResp msg
    list<CommcellProfileTask> tasks
}
--Profile messages end
ProfileTaskAssociation
*/
DECLARE @LOG_ERROR INT =  1
DECLARE @profileEntity INT = 0,@taskOperation INT =0
DECLARE @errorString NVARCHAR(MAX) =''
DECLARE @errorCode INT  =0
DECLARE @taskresp XML = NULL
DECLARE @ProcessTran INT
DECLARE @CREATE INT = 221
DECLARE @EDIT INT = 222
DECLARE @VIEW INT = 223
DECLARE @DELETE INT = 224
SET @ProcessTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessTran
		SET @ProcessTran = 1
	END
SELECT
	@profileEntity = ISNULL(@request.value('(/WebReport_CommcellProfileReq/@entity)[1]', 'integer'), 0),
	@taskOperation = ISNULL(@request.value('(/WebReport_CommcellProfileReq/@operation)[1]', 'integer'), 0)
	IF object_id('tempdb.dbo.#CSProfileTaskInfo') is not null DROP TABLE #CSProfileTaskInfo
	CREATE TABLE #CSProfileTaskInfo
	(
		 taskId						INT,
		 taskSummary				NVARCHAR(MAX),
		 url  						NVARCHAR(MAX),
		 description				NVARCHAR(MAX),
		 status						INT,
		 dueDate					BIGINT,
		 startDate					BIGINT,
		 statusChangedReason		NVARCHAR(MAX),
		 dueDateChangeReason		NVARCHAR(MAX),
		 taskType					INT,
		 emails						NVARCHAR(MAX),
		 internalTask				INT,
		 taskAssignedTo				INT ,
		 taskOwner					INT
	)
	IF object_id('tempdb.dbo.#CSProfileTasProp') is not null DROP TABLE #CSProfileTasProp
	CREATE TABLE #CSProfileTasProp
	(
		 taskId						INT,
		 taskSummary				NVARCHAR(MAX),
		 taskOwner					INT,
		 status						INT,
		 taskPropName				NVARCHAR(MAX),
		 taskPropVal				NVARCHAR(MAX),
		 taskPropValType			INT,
		 taskPropstatus				INT,
	)
IF (@profileEntity !=1) --task information
GOTO CX_ERROR_EXIT
		INSERT INTO #CSProfileTaskInfo (taskId,taskSummary, Description , statusChangedReason, dueDate, url, taskType, internalTask, emails, dueDateChangeReason,	startDate, status,taskAssignedTo,taskOwner)
		SELECT DISTINCT
		ISNULL(tasks.n.value('(@taskId)', 'integer'), 0),
			   tasks.n.value('(@summary)', 'nvarchar(max)'),
		ISNULL(tasks.n.value('(@description)', 'nvarchar(max)'), ''),
		ISNULL(tasks.n.value('(@statusChangeReason)', 'nvarchar(max)'), ''),
		ISNULL(tasks.n.value('(@dueDate)', 'BIGINT'), 0),
		ISNULL(tasks.n.value('(@url)', 'nvarchar(max)'), ''),
		ISNULL(tasks.n.value('(@taskType)', 'integer'), 5),
		ISNULL(tasks.n.value('(@internalTask)', 'integer'), 0),
		ISNULL(tasks.n.value('(@emails)', 'nvarchar(max)'), ''),
		ISNULL(tasks.n.value('(@dueDateChangeReason)', 'nvarchar(max)'), ''),
		ISNULL(tasks.n.value('(@startDate)', 'BIGINT'), 0),
		ISNULL(tasks.n.value('(@status)', 'BIGINT'), 0),
		ISNULL(tasks.n.value('(assignedTo/@userId)[1]', 'BIGINT'), 0),
		ISNULL(tasks.n.value('(user/@userId)[1]', 'BIGINT'), 0)
	FROM
		@request .nodes('WebReport_CommcellProfileReq/tasks') AS taskInfo(n)
		CROSS APPLY taskInfo.n.nodes('taskInfo') AS tasks(n)
		INSERT INTO #CSProfileTasProp (taskId,taskSummary, taskOwner,status,taskPropName , taskPropVal, taskPropValType, taskPropstatus)
		SELECT DISTINCT
		ISNULL(tasks.n.value('(@taskId)', 'integer'), 0),
			   tasks.n.value('(@summary)', 'nvarchar(max)'),
		ISNULL(tasks.n.value('(user/@userId)[1]', 'BIGINT'), 0),
		ISNULL(tasks.n.value('(@status)', 'BIGINT'), 0),
		ISNULL(taskProps.n.value('(@attrName)', 'nvarchar(max)'), ''),
		ISNULL(taskProps.n.value('(@attrVal)', 'nvarchar(max)'), ''),
		ISNULL(taskProps.n.value('(@attrType)', 'integer'), 0),
		ISNULL(taskProps.n.value('(@status)', 'integer'), 0)
	FROM
		@request .nodes('WebReport_CommcellProfileReq/tasks') AS taskInfo(n)
		CROSS APPLY taskInfo.n.nodes('taskInfo') AS tasks(n)
		CROSS APPLY taskInfo.n.nodes('taskProps') AS taskProps(n)
	 DECLARE @opId INT= 1
	IF (@taskOperation = 1 ) --add operation for new task check whether we have task by this user.
	BEGIN
		-- Start: Anh's fix to check user info is valid before creating task
		-- Need to check all the user's input before creating any task
		DECLARE @countTest INT= (SELECT COUNT(DISTINCT taskOwner) FROM #CSProfileTaskInfo)
		IF (@countTest != 1)
		BEGIN
			SELECT @errorCode = 10551, @errorString = 'Only one task request allowed. Number of task input: ' + CONVERT(vARCHAR(10), @countTest)
			GOTO CX_ERROR_EXIT;
		END
		DECLARE @CreatorId INT = (SELECT TOP 1 taskOwner FROM #CSProfileTaskInfo)
		IF (@CreatorId <= 0 OR NOT EXISTS (SELECT id FROM UMUsers WITH (NOLOCK) WHERE id = @CreatorId))
		BEGIN
			SELECT @errorCode = 10551, @errorString = 'Input user information is not valid.' + CONVERT(vARCHAR(10), @CreatorId)
			GOTO CX_ERROR_EXIT;
		END
		-- End: Anh's fix to check user info is valid before creating task
		IF object_id('tempdb.dbo.#IdentityTable') is not null DROP TABLE #IdentityTable
		CREATE TABLE #IdentityTable
		(
		  taskSummary				NVARCHAR(MAX),
		  taskOwner					INT,
		  taskstatus				INT,
		  taskId					 INT
		 )
		INSERT INTO ProfileTaskInfo( taskSummary ,taskDescription,  taskurl, taskType ,flags,	status, createdBy,  lastmodifiedby,assignedTo, taskownerId, dueDate,	emailTo,CustomerId)
		OUTPUT Inserted.taskSummary, Inserted.taskOwnerId,  Inserted.status , inserted.taskId INTO #IdentityTable(taskSummary, taskOwner,taskstatus,taskId)
		SELECT taskSummary, Description,  url,  taskType, 0 , status,taskOwner,taskOwner,taskAssignedTo,taskOwner,dbo.getdatetime(dueDate),emails,0
		FROM #CSProfileTaskInfo
		UPDATE prop
		SET prop.taskId  = I.taskId
		FROM #CSProfileTasProp prop
		INNER JOIN #IdentityTable I ON I.taskSummary = prop.taskSummary AND I.taskOwner = prop.taskOwner AND I.taskstatus = prop.status
		UPDATE T
		SET T.taskId  = I.taskId
		FROM #CSProfileTaskInfo T
		INNER JOIN #IdentityTable I ON I.taskSummary = T.taskSummary AND I.taskOwner = T.taskOwner AND I.taskstatus = T.status
		INSERT INTO ProfileTaskProp (taskId,attrname,attrVal, attrType)
		SELECT prop.taskId,prop.taskPropName,prop.taskPropVal,prop.taskPropValType
		FROM #CSProfileTasProp prop
		INSERT INTO ProfileTaskProp (taskId,attrname,attrVal, attrType)
SELECT T.taskId, 'startDate',dbo.getdatetime(T.startDate), 1
		FROM #CSProfileTaskInfo  T WHERE T.startDate>0
		INSERT INTO ProfileTaskProp (taskId,attrname,attrVal, attrType)
SELECT T.taskId,  'internalTask',T.internalTask, 7
		FROM #CSProfileTaskInfo  T
		WHERE T.internalTask>0
		INSERT INTO ProfileTaskAssociation(taskId, commcellId, assocType)
		select I.taskId, 1 ,1
		from #IdentityTable I
		SET @taskresp = (
		SELECT
			T.taskId			AS 'taskInfo/@taskId',
			T.taskSummary		AS 'taskInfo/@summary',
			T.url			AS 'taskInfo/@url',
			T.description	AS 'taskInfo/@description',
			T.status			AS 'taskInfo/@status',
			T.dueDate			AS 'taskInfo/@dueDate',
			T.taskType		AS 'taskInfo/@taskType',
			T.emails			AS 'taskInfo/@emailTo',
			T.taskOwner		AS 'user/@userId',
			T.taskAssignedTo		AS 'assignedTo/@userId'
		FROM #CSProfileTaskInfo T
		FOR XML PATH('tasks')
		)
		-- Start: Anh's fix to create mapping entity for security
		DECLARE @testTaskId INT = (SELECT TOP 1 I.taskId FROM #IdentityTable I)
		exec sec_setCreatorForEntity @CreatorId,
				0,
				N'221,222,223,224,107', --CAT_EDISCOVERY_TASK_CREATE,CAT_EDISCOVERY_TASK_EDIT,CAT_EDISCOVERY_TASK_VIEW,CAT_EDISCOVERY_TASK_DELETE,CAT_USER_MANAGMENT_ASSOC_ON_ENTITY
				@errorCode output,
				@errorString output,
				9515, --EDISCOVERY_TASK_ENTITY)
				@testTaskId
		-- End: Anh's fix to create mapping entity for security
		IF (@errorCode >0)
		BEGIN
			SET @errorCode = 3
			SET @errorString = 'Failed to update Profile task history Information '
			GOTO CX_ERROR_EXIT
		END
		exec wr_ManageCommCellProfileTaskInfoHistory @request,'#CSProfileTaskInfo','#CSProfileTasProp',@errorCode OUTPUT, @errorString OUTPUT
		IF (@errorCode >0)
		BEGIN
			SET @errorCode = 3
			SET @errorString = 'Failed to update Profile task history Information '
			GOTO CX_ERROR_EXIT
		END
		IF object_id('tempdb.dbo.#IdentityTable') is not null DROP TABLE #IdentityTable
	END
	ELSE IF (@taskOperation =3 ) --EDIT operation for new task check whether we have task by this user.
	BEGIN
		exec wr_ManageCommCellProfileTaskInfoHistory @request,'#CSProfileTaskInfo','#CSProfileTasProp',@errorCode OUTPUT, @errorString OUTPUT
		IF (@errorCode >0)
		BEGIN
			SET @errorCode = 3
			SET @errorString = 'Failed to update Profile task history Information '
			GOTO CX_ERROR_EXIT
		END
		UPDATE T
			SET T.taskSummary =  R.taskSummary,
			T.taskDescription =  R.Description,
			T.taskurl			= R.url,
			T.status			=  R.status,
			T.lastmodified	=  getUTCDate(),
			T.lastmodifiedby  =  r.taskOwner,
			T.assignedTo		=  R.taskAssignedTo,
			--taskownerId		=  @taskOwner,
			T.dueDate			=  dbo.getdatetime(R.dueDate),
			T.emailTo			=  R.emails
		FROM ProfileTaskInfo T
		INNER JOIN  #CSProfileTaskInfo R
			ON T.taskId= R.taskId AND R.TASKID>0
		MERGE ProfileTaskProp T
			USING  #CSProfileTasProp prop
				ON T.taskId= prop.taskId AND prop.taskPropName = T.attrname AND prop.taskPropValType = T.attrType
			WHEN MATCHED THEN
				UPDATE SET T.attrVal = prop.taskPropVal
			WHEN NOT MATCHED  THEN
			INSERT  (taskId,attrname,attrVal, attrType)
			VALUES ( prop.taskId,prop.taskPropName,prop.taskPropVal,prop.taskPropValType);
		MERGE ProfileTaskProp prop
			USING  #CSProfileTaskInfo T
				ON T.taskId= prop.taskId AND prop.attrName ='startDate'
			WHEN MATCHED THEN
				UPDATE SET prop.attrVal = dbo.getdatetime(T.startDate)
			WHEN NOT MATCHED THEN
			INSERT (taskId,attrname,attrVal, attrType)
VALUES ( T.taskId,'startDate',dbo.getdatetime(T.startDate), 1);
		MERGE ProfileTaskProp prop
			USING  #CSProfileTaskInfo T
				ON T.taskId= prop.taskId AND prop.attrName ='statusChangedReason'
			WHEN MATCHED THEN
				UPDATE SET prop.attrVal = T.statusChangedReason
			WHEN NOT MATCHED THEN
			INSERT (taskId,attrname,attrVal, attrType)
VALUES ( T.taskId,'statusChangedReason',T.statusChangedReason,1);
		/*MERGE ProfileTaskProp prop
			USING  #CSProfileTaskInfo T
				ON T.taskId= prop.taskId AND prop.attrName ='dueDateChangedReason'
			WHEN MATCHED THEN
				UPDATE SET prop.attrVal = T.dueDateChangedReason
			WHEN NOT MATCHED THEN
			INSERT (taskId,attrname,attrVal, attrType)
VALUES ( T.taskId,'dueDateChangedReason',T.dueDateChangedReason,1);
							*/
		MERGE ProfileTaskProp prop
			USING  #CSProfileTaskInfo T
				ON T.taskId= prop.taskId AND prop.attrName ='internalTask'
			WHEN MATCHED THEN
				UPDATE SET prop.attrVal =  T.internalTask
			WHEN NOT MATCHED THEN
			INSERT (taskId,attrname,attrVal, attrType)
VALUES ( T.taskId,'internalTask',T.internalTask,7);
	END
	IF (@ProcessTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessTran
		SET @ProcessTran = 0
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
IF (XACT_STATE() <> 0 AND @ProcessTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessTran
	SET @ProcessTran = 0
	SELECT @errorCode = 1
	SELECT @errorString = 'Exception  - failed with error :: ' + ERROR_MESSAGE()
END
END CATCH
CX_ERROR_EXIT:
	SET @response = (SELECT @errorCode as '@errorCode' , @errorString as '@errorMessage' FOR XML PATH('msg')    )
	SET @response = (select @response,@taskresp FOR XML PATH('WebReport_CommcellProfileResp')    )
IF (XACT_STATE() <> 0 AND @ProcessTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessTran
	SET @ProcessTran = 0
END
	SELECT @response
GO

IF EXISTS (select * from GxQscripts where name = 'wr_ManageCommCellProfileOps')
	delete from GxQscripts where name = 'wr_ManageCommCellProfileOps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_ManageCommCellProfileOps')
	delete from GXDBVersions where aliasname = 'wr_ManageCommCellProfileOps'
GO

insert into GXDBVersions values(2, 'wr_ManageCommCellProfileOps',  '00010001000400050000', 'wr_ManageCommCellProfileOps', '00010001000400050000')
GO

