

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_ManageAssociateCloudUserCapabilityOperation.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='wr_ManageAssociateCloudUserCapabilityOperation')
BEGIN
	print '>>> Drop Stored Procedure: wr_ManageAssociateCloudUserCapabilityOperation <<<'
	drop procedure wr_ManageAssociateCloudUserCapabilityOperation
END
IF EXISTS (select * from GxQscripts where name='wr_ManageAssociateCloudUserCapabilityOperation')
	delete from GxQscripts where name = 'wr_ManageAssociateCloudUserCapabilityOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_ManageAssociateCloudUserCapabilityOperation')
	delete from GXDBVersions where aliasname = 'wr_ManageAssociateCloudUserCapabilityOperation'
GO
print '... Creating Procedure: wr_ManageAssociateCloudUserCapabilityOperation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_ManageAssociateCloudUserCapabilityOperation
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @request XML
AS
  DECLARE @response xml
BEGIN
SET NOCOUNT ON
DECLARE @errorString NVARCHAR(MAX) =''
DECLARE @errorCode INT  =0
DECLARE @roleId INT, @roleName nvarchar(255) = 'Metrics Management Admin_Role'
SET @roleId =( SELECT ID from UMRoles (NOLOCK) where name =@roleName and disabled =0 )
IF( @roleId<1 OR @roleId IS NULL)
BEGIN
SET @errorString = 'Expected Metrics Management Admin_Role not found!'
	SET @errorCode =4
GOTO ErrorMsg
END
BEGIN TRY
SET @response = (SELECT 13 AS 'userEntity/@_type_', r.n.value('(user/@userId)[1]','INT') AS 'userEntity/@userId',
	(SELECT CASE r.n.value('@operation','INT') WHEN 1 THEN 2 ELSE 3 END AS '@associationsOperationType',
		(SELECT (SELECT 15 AS '@_type_', c.n.value('@userGroupId[1]','INT') AS '@userGroupId' FROM r.n.nodes('company') c(n) FOR XML PATH('entity'), ROOT('entities') , TYPE),
				(SELECT 120 AS '@_type_', @roleId AS '@roleId', @roleName AS '@roleName' FOR XML PATH('role'), ROOT('properties'), TYPE)
		FOR XML PATH('associations'), TYPE)
		FOR XML PATH('securityAssociations'), TYPE)
FROM @request.nodes('WebReport_CloudUserCapabilityOperationReq/users') r(n)
FOR XML PATH('users'), ROOT('App_UpdateUserPropertiesRequest'))
END TRY
BEGIN CATCH
		SET @errorString = 'Exception while processing xml request !'
		SET @errorCode =1
		GOTO ErrorMsg
END CATCH
ErrorMsg:
SET NOCOUNT OFF
CX_ERROR_EXIT:
IF @errorCode > 0
	SET @response = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage' FOR XML PATH('App_GenericResp'))
SELECT @response
END
GO

IF EXISTS (select * from GxQscripts where name = 'wr_ManageAssociateCloudUserCapabilityOperation')
	delete from GxQscripts where name = 'wr_ManageAssociateCloudUserCapabilityOperation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_ManageAssociateCloudUserCapabilityOperation')
	delete from GXDBVersions where aliasname = 'wr_ManageAssociateCloudUserCapabilityOperation'
GO

insert into GXDBVersions values(2, 'wr_ManageAssociateCloudUserCapabilityOperation',  '00010001000200080000', 'wr_ManageAssociateCloudUserCapabilityOperation', '00010001000200080000')
GO

