

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_JobSummary.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/wr_JobSummary.sp,v $ $Id: wr_JobSummary.sp,v 1.95.2.62 2020/12/11 22:45:11 junlu Exp $";
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Eugene Volohov
-- Create date: 09/11/2010
-- Description:	generates job summary report
-- Parameters :
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='wr_JobSummary')
BEGIN
	print '>>> Drop Stored Procedure: wr_JobSummary <<<'
	drop procedure wr_JobSummary
END
IF EXISTS (select * from GxQscripts where name='wr_JobSummary')
	delete from GxQscripts where name = 'wr_JobSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_JobSummary')
	delete from GXDBVersions where aliasname = 'wr_JobSummary'
GO
print '... Creating Procedure: wr_JobSummary'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure wr_JobSummary
  @input xml,
  @userId int
AS
  DECLARE @o_JobSummary NVARCHAR(MAX);
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
DECLARE  @timeFrameType               INT
DECLARE  @frequency                   INT
DECLARE  @numberOfPeriods             INT
DECLARE  @reqStartTime                BIGINT
DECLARE  @reqEndTime                  BIGINT
DECLARE  @includeLogDeletedClients    INT
DECLARE  @includeLogDeletedSubclients INT
DECLARE  @includeDisabledSubClients   INT
DECLARE  @includeAgedJobs             INT
DECLARE  @includeMediaDeletedJobs     INT
DECLARE  @includeBackupCopyJobs       INT
DECLARE  @includeReferenceCopyJobs    INT
DECLARE  @lastJobOfEachSubclientOnly  INT
DECLARE  @groupBy                     INT
DECLARE  @backupJobs                  INT
DECLARE  @archiveJobs                 INT
DECLARE  @onlyVSAJobs                 INT = 0
DECLARE  @statusCompleted             INT
DECLARE  @statusCompletedErr          INT
DECLARE  @statusCompletedWrn          INT
DECLARE  @statusFailed                INT
DECLARE  @statusKilled                INT
DECLARE  @statusDelayed               INT
DECLARE  @statusActive                INT
DECLARE  @statusNoRun                 INT
DECLARE  @statusCommitted             INT
DECLARE  @backupFull                  INT
DECLARE  @backupIncremental           INT
DECLARE  @backupDifferential          INT
DECLARE  @backupSynthetic             INT
DECLARE  @backupTransactionLog        INT
DECLARE  @backupJobsSortColumn        INT
DECLARE  @backupJobsSortOrder         INT
DECLARE  @jobsPageSize                INT
DECLARE  @backupPageNo                INT
DECLARE  @jobsOnlyRequest             INT
DECLARE  @localeId                    INT
DECLARE	 @localeName             	  NVARCHAR(MAX)
DECLARE  @distribution                INT
DECLARE  @reportFilter                XML
DECLARE  @lastUpdateTime			  INT
DECLARE  @sendSummary				  INT =1
DECLARE	 @maxTimeStamp				  INT
DECLARE  @newUpdateTime				  INT = DATEDIFF(SS, '1970-01-01', GETDATE())
DECLARE  @sqlStr                      NVARCHAR(MAX)
DECLARE  @includeAllClientGroups      INT = 1
DECLARE  @clientGroupFilter           XML
DECLARE  @includeAllClients           INT = 1
DECLARE  @clientFilter                XML
DECLARE  @includeAllAgents            INT = 1
DECLARE  @agentFilter                 XML
DECLARE  @includeAllStoragePolicies   INT = 1
DECLARE  @storagePolicyFilter         XML
DECLARE  @includeAllMediaAgents       INT = 1
DECLARE  @mediaAgentFilter            XML
DECLARE  @tableFilterEnum             INT
DECLARE  @tableFilter                 XML
DECLARE  @filterHandle                INT
DECLARE  @IncludeRetention            INT
DECLARE @useAbsTimeRangeForJobSummaryRpt INTEGER
SET @timeFrameType = @input.value('/WebReport_JobReportReq[1]/@timeFrameType', 'int')
SET @frequency = @input.value('/WebReport_JobReportReq[1]/@frequency', 'int')
SET @numberOfPeriods = @input.value('/WebReport_JobReportReq[1]/@numberOfPeriods', 'int')
SET @reqStartTime = @input.value('/WebReport_JobReportReq[1]/@startTime', 'BIGINT')
SET @reqEndTime = @input.value('/WebReport_JobReportReq[1]/@endTime', 'BIGINT')
--SET @includeLogDeletedClients = ISNULL(@input.value('/WebReport_JobReportReq[1]/@includeLogDeletedClients', 'int'), 0)
SET @includeLogDeletedSubclients = ISNULL(@input.value('/WebReport_JobReportReq[1]/@includeLogDeletedSubclients', 'int'), 0)
SET @includeLogDeletedClients = @includeLogDeletedSubclients
SET @includeDisabledSubClients = ISNULL(@input.value('/WebReport_JobReportReq[1]/@includeDisabledSubClients', 'int'), 0)
SET @includeAgedJobs = ISNULL(@input.value('/WebReport_JobReportReq[1]/@includeAgedJobs', 'int'), 0)
SET @includeMediaDeletedJobs = ISNULL(@input.value('/WebReport_JobReportReq[1]/@includeMediaDeletedJobs', 'int'), 0)
SET @includeBackupCopyJobs = ISNULL(@input.value('/WebReport_JobReportReq[1]/@includeBackupCopyJobs', 'int'), 0)
SET @includeReferenceCopyJobs = ISNULL(@input.value('/WebReport_JobReportReq[1]/@includeReferenceCopyJobs', 'int'), 0)
SET @IncludeRetention = ISNULL(@input.value('/WebReport_JobReportReq[1]/@retentionType', 'int'), -1)
SET @lastJobOfEachSubclientOnly = ISNULL(@input.value('/WebReport_JobReportReq[1]/@lastJobOfEachSubclientOnly', 'int'), 0)
SET @groupBy = @input.value('/WebReport_JobReportReq[1]/@groupBy', 'int')
SET @backupJobs = @input.value('/WebReport_JobReportReq[1]/@backupJobs', 'int')
SET @archiveJobs = @input.value('/WebReport_JobReportReq[1]/@archiveJobs', 'int')
SET @statusCompleted = @input.value('/WebReport_JobReportReq[1]/@statusCompleted', 'int')
SET @statusCompletedErr = @input.value('/WebReport_JobReportReq[1]/@statusCompletedErr', 'int')
SET @statusCompletedWrn = @input.value('/WebReport_JobReportReq[1]/@statusCompletedWrn', 'int')
SET @statusFailed = @input.value('/WebReport_JobReportReq[1]/@statusFailed', 'int')
SET @statusKilled = @input.value('/WebReport_JobReportReq[1]/@statusKilled', 'int')
SET @statusDelayed = @input.value('/WebReport_JobReportReq[1]/@statusDelayed', 'int')
SET @statusActive = @input.value('/WebReport_JobReportReq[1]/@statusActive', 'int')
SET @statusNoRun = @input.value('/WebReport_JobReportReq[1]/@statusNoRun', 'int')
SET @statusCommitted = @input.value('/WebReport_JobReportReq[1]/@statusCommitted', 'int')
SET @backupFull = @input.value('/WebReport_JobReportReq[1]/@backupFull', 'int')
SET @backupIncremental = @input.value('/WebReport_JobReportReq[1]/@backupIncremental', 'int')
SET @backupDifferential = @input.value('/WebReport_JobReportReq[1]/@backupDifferential', 'int')
SET @backupIncremental = @input.value('/WebReport_JobReportReq[1]/@backupIncremental', 'int')
SET @backupSynthetic = @input.value('/WebReport_JobReportReq[1]/@backupSynthetic', 'int')
SET @backupTransactionLog = @input.value('/WebReport_JobReportReq[1]/@backupTransactionLog', 'int')
SET @jobsOnlyRequest = ISNULL(@input.value('/WebReport_JobReportReq[1]/@jobsOnlyRequest', 'int'),0)
SET @localeId = @input.value('/WebReport_JobReportReq[1]/localeId[1]/@localeId', 'int')
SET @localeName = @input.value('/WebReport_JobReportReq[1]/localeId[1]/@localeName', 'NVARCHAR(MAX)')
SET @distribution = @input.value('/WebReport_JobReportReq[1]/@distribution', 'int')
SET @reportFilter = @input.query('/WebReport_JobReportReq[1]/reportFilter')
SET @jobsPageSize = @input.value('/WebReport_JobReportReq[1]/@pageSize', 'int')
SET @backupJobsSortColumn = @input.value('/WebReport_JobReportReq[1]/backupJobDetails[1]/@jobsSortColumn', 'int')
SET @backupJobsSortOrder = @input.value('/WebReport_JobReportReq[1]/backupJobDetails[1]/@jobsSortOrder', 'int')
SET @backupPageNo = @input.value('/WebReport_JobReportReq[1]/backupJobDetails[1]/@pageNo', 'int')
SET @lastUpdateTime = @input.value('/WebReport_JobReportReq[1]/@lastUpdateTime', 'int')
SET @includeAllClientGroups = @input.value('/WebReport_JobReportReq[1]/clientGroupFilter[1]/@includeAll', 'INT')
SET @clientGroupFilter = @input.query('/WebReport_JobReportReq[1]/clientGroupFilter')
SET @includeAllClients = @input.value('/WebReport_JobReportReq[1]/clientFilter[1]/@includeAll', 'INT')
SET @clientFilter = @input.query('/WebReport_JobReportReq[1]/clientFilter')
SET @includeAllAgents = @input.value('/WebReport_JobReportReq[1]/agentFilter[1]/@includeAll', 'INT')
SET @agentFilter = @input.query('/WebReport_JobReportReq[1]/agentFilter')
SET @includeAllStoragePolicies = @input.value('/WebReport_JobReportReq[1]/storagePolicyFilter[1]/@includeAll', 'INT')
SET @storagePolicyFilter = @input.query('/WebReport_JobReportReq[1]/storagePolicyFilter')
SET @includeAllMediaAgents = @input.value('/WebReport_JobReportReq[1]/mediaAgentFilter[1]/@includeAll', 'INT')
SET @mediaAgentFilter = @input.query('/WebReport_JobReportReq[1]/mediaAgentFilter')
SET @tableFilterEnum =  @input.value('/WebReport_JobReportReq[1]/@tableFilter', 'INT')
SET @tableFilter = @input.query('/WebReport_JobReportReq[1]')
DECLARE @userPreferences xml = (SELECT TOP 1 value FROM UMUserWebPrefs WITH (NOLOCK) WHERE userId = @userId)
DECLARE @dateFormat int = 0
DECLARE @DSTFlag				INT = 0
DECLARE @Bias					INT = 0
DECLARE @csTimeZoneId			INT = 0
DECLARE @csTimeZone				NVARCHAR(1024) = ''
SELECT  @csTimeZoneId = attrVal FROM APP_ClientProp WITH (NOLOCK) WHERE attrName = 'Commcell timezone Id' AND modified = 0
IF @csTimeZoneId = 0
	SELECT  @csTimeZoneId = attrVal FROM APP_ClientProp WITH (NOLOCK) WHERE componentNameId = 2 AND attrName = 'timezone Id' AND modified = 0
SELECT	@csTimeZone = TimeZoneStdName, @DSTFlag = DSTFlag, @Bias = Bias FROM SchedTimeZone WITH (NOLOCK) WHERE TimeZoneID = @csTimeZoneId
IF @localeId IS NULL AND ISNULL(@localeName, '') <> ''
	SELECT @localeId = cvLocaleId FROM evLocales WITH (NOLOCK) WHERE locale = @localeName
IF @localeId IS NULL
	SELECT @localeId = 0, @localeName = 'en-us'
IF (@userPreferences IS NOT NULL)
BEGIN
	IF (@jobsPageSize IS NULL)
		SET @jobsPageSize = ISNULL(@userPreferences.value('/userPreferences[1]/general[1]/@rowsPerPage', 'int'), 20)
	SET @dateFormat = @userPreferences.value('/userPreferences[1]/general[1]/@dateFormat', 'int')
	IF(@dateFormat = 0)
		SET @localeName = 'en-us' --forcing MM/DD format
	ELSE IF (@dateFormat = 1)
		SET @localeName = 'en-gb' --forcing DD/MM format
	ELSE IF(@localeName IS NULL)
		SET @localeName = 'en-us' --defaule locale
END
IF ( ISNULL(@backupPageNo, 0) = 0 ) SET @backupPageNo =1
IF (@jobsPageSize IS NULL)
	SET @jobsPageSize = 20
ELSE
IF (@jobsPageSize < 0)
BEGIN
	SET	@jobsPageSize	= 0x7FFFFFFF
	SET @backupPageNo	= 1
END
DECLARE @BackupLevels INT = 0
IF	@backupFull > 0
	SET @BackupLevels = (@BackupLevels | 0x1 | 0x400 | 0x1000 | 0x8000)
IF	@backupSynthetic > 0
	SET @BackupLevels = (@BackupLevels | 0x40 | 0x80 | 0x4000)
IF	@backupIncremental > 0
	SET @BackupLevels = (@BackupLevels | 0x2 | 0x100)
IF	@backupDifferential > 0
	SET @BackupLevels = (@BackupLevels | 0x4)
IF	@backupTransactionLog > 0
	SET @BackupLevels = (@BackupLevels | 0x8)
DECLARE @JobStatusTbl TABLE (status INT)
IF	@statusCompleted > 0
	INSERT INTO @JobStatusTbl VALUES (1)
IF	@statusCompletedErr > 0
	INSERT INTO @JobStatusTbl VALUES (3)
IF	@statusCompletedWrn > 0
	INSERT INTO @JobStatusTbl VALUES (14)
IF	@statusFailed > 0
	INSERT INTO @JobStatusTbl VALUES (2), (15)
IF	@statusKilled > 0
	INSERT INTO @JobStatusTbl VALUES (4)
IF	@statusDelayed > 0
	INSERT INTO @JobStatusTbl VALUES (5), (6)
IF	@statusNoRun > 0
	INSERT INTO @JobStatusTbl VALUES (8), (9)
IF	@statusCommitted > 0
	INSERT INTO @JobStatusTbl VALUES (16)
IF	@statusActive > 0
	INSERT INTO @JobStatusTbl VALUES (10), (11), (12), (13)
DECLARE @JobStateTbl TABLE (state INT)
IF	@statusCompleted > 0
	INSERT INTO @JobStateTbl VALUES (4), (9)
IF	@statusCompletedErr > 0
	INSERT INTO @JobStateTbl VALUES (12)
IF	@statusCompletedWrn > 0
	INSERT INTO @JobStateTbl VALUES (19)
IF	@statusFailed > 0
	INSERT INTO @JobStateTbl VALUES (10), (18)
IF	@statusKilled > 0
	INSERT INTO @JobStateTbl VALUES (11)
IF	@statusDelayed > 0
	INSERT INTO @JobStateTbl VALUES (2), (3), (5), (14), (15), (16)
IF	@statusActive > 0
	INSERT INTO @JobStateTbl VALUES (1), (6), (7), (8), (13), (17)
DECLARE @ExcludedOpType TABLE (opType INT)
IF	@IncludeBackupCopyJobs = 0
	INSERT INTO @ExcludedOpType VALUES (60)
IF	@IncludeReferenceCopyJobs = 0
	INSERT INTO @ExcludedOpType VALUES (94)
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__UserObjects')   IS NOT null DROP TABLE #JobSummary_tmp__UserObjects
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__clientGroupId') IS NOT null DROP TABLE #JobSummary_tmp__clientGroupId
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__clientId')      IS NOT null DROP TABLE #JobSummary_tmp__clientId
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__appTypeId')     IS NOT null DROP TABLE #JobSummary_tmp__appTypeId
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__StoragePolicy') IS NOT null DROP TABLE #JobSummary_tmp__StoragePolicy
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__MediaAgent')    IS NOT null DROP TABLE #JobSummary_tmp__MediaAgent
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__appId')         IS NOT null DROP TABLE #JobSummary_tmp__appId
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__InstanceName')  IS NOT null DROP TABLE #JobSummary_tmp__InstanceName
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__TypeName')      IS NOT null DROP TABLE #JobSummary_tmp__TypeName
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__JobStatus')     IS NOT null DROP TABLE #JobSummary_tmp__JobStatus
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__EntityId')      IS NOT null DROP TABLE #JobSummary_tmp__EntityId
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__Entity')        IS NOT null DROP TABLE #JobSummary_tmp__Entity
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__FilterList')    IS NOT null DROP TABLE #JobSummary_tmp__FilterList
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__Jobs')          IS NOT null DROP TABLE #JobSummary_tmp__Jobs
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__JobList')       IS NOT null DROP TABLE #JobSummary_tmp__JobList
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__JobListAggr')   IS NOT null DROP TABLE #JobSummary_tmp__JobListAggr
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__Retention')     IS NOT null DROP TABLE #JobSummary_tmp__Retention
IF OBJECT_ID('tempdb.dbo.#maxJobRetention')               IS NOT null DROP TABLE #maxJobRetention
IF OBJECT_ID('tempdb.dbo.#VSA_AppIDs')                    IS NOT null DROP TABLE #VSA_AppIDs
DECLARE @securityFilterStatus INT = 0
DECLARE @statsTempTime  DATETIME
DECLARE @totalBackupJobs  INT = 0
-- get MiniBrandId for CommCell brand name
DECLARE	@l_MiniBrandId	INT
SELECT	@l_MiniBrandId = CAST(value AS INT) FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'MiniBrandId' AND modified = 0
IF @l_MiniBrandId IS NULL
	SET @l_MiniBrandId = (SELECT TOP 1 OemId FROM LicCsl WITH (NOLOCK) ORDER BY id DESC)
DECLARE @jobsPageSizeLocal  INT = @jobsPageSize
DECLARE @jobsPageStart      INT = 0
DECLARE @startTime                   BIGINT = 0
DECLARE @endTime                     BIGINT = DATEDIFF(SS, '1970-01-01', GETUTCDATE())
IF (@reqStartTime <> 0)
BEGIN
	SET @startTime = @reqStartTime
END
IF (@reqEndTime > 0)
BEGIN
	SET @endTime = @reqEndTime
END
DECLARE @MAXINT integer
SET @MAXINT = 0x7FFFFFFF
DECLARE @manualflagtmp int = 1073741824
DECLARE @defaultRetention BIGINT = DATEDIFF(SS, '1970-01-01', GetDate())
CREATE TABLE #JobSummary_tmp__clientGroupId (id INT, name NVARCHAR(256))
CREATE TABLE #JobSummary_tmp__clientId      (id INT, name NVARCHAR(256))
CREATE TABLE #JobSummary_tmp__appTypeId     (id INT, name NVARCHAR(256))
CREATE TABLE #JobSummary_tmp__StoragePolicy	(id INT, name NVARCHAR(256))
CREATE TABLE #JobSummary_tmp__MediaAgent    (id INT, name NVARCHAR(256), visible INT)
CREATE TABLE #JobSummary_tmp__appId         (clientId INT, appTypeId INT, appId INT)
CREATE TABLE #JobSummary_tmp__InstanceName  (appTypeId INT, instanceName NVARCHAR(1024), displayInstanceName NVARCHAR(1024))
CREATE TABLE #JobSummary_tmp__TypeName      (type INT, name NVARCHAR(64))
CREATE TABLE #JobSummary_tmp__JobStatus     (status INT, statusName NVARCHAR(256), messageId BIGINT)
CREATE TABLE #VSA_AppIDs                    (appId INT, isIndexingV2 INT, isBackupDisabled INT, isDeconfigured INT)
CREATE TABLE #JobSummary_tmp__FilterList
(
    filterOrder             INT,
    filterType              INT,
    filterValue             INT,
    filterName              NVARCHAR(255)
)
CREATE TABLE #JobSummary_tmp__JobListAggr
(
    entityId                INT             NOT NULL,
    entityName              NVARCHAR(1024)  NOT NULL,
    deleted                 BIT             NOT NULL,
    totalJobs               INT             NOT NULL,
    totalAppSize            BIGINT          NOT NULL,
    totalDataWritten        BIGINT          NOT NULL,
    totalProtectedObjects   BIGINT          NOT NULL,
    totalFailedObjects      BIGINT          NOT NULL,
    totalFailedFolders      BIGINT          NOT NULL
)
CREATE TABLE #JobSummary_tmp__EntityId
(
    clientId            INT,
    appTypeId           INT,
    instanceId          INT,
    backupsetId         INT,
    subclientId         INT
)
CREATE TABLE #JobSummary_tmp__Entity
(
    commCellId          INT,
    commCellName        NVARCHAR(1024),
    clientId            INT,
    clientName          NVARCHAR(1024),
    appTypeId           INT,
    appTypeName         NVARCHAR(1024),
    instanceId          INT,
    instanceName        NVARCHAR(1024),
    backupsetId         INT,
    backupsetName       NVARCHAR(1024),
    subclientId         INT,
    subclientName       NVARCHAR(1024),
    vmClientId          INT
)
CREATE TABLE #JobSummary_tmp__Jobs
(
    jobId                   INT,
    commCellId              INT,
    commCellName            NVARCHAR(1024),
    clientGroup             NVARCHAR(MAX),
    clientId                INT,
    clientName              NVARCHAR(1024),
    appTypeId               INT,
    appTypeName             NVARCHAR(1024),
    instanceId              INT,
    instanceName            NVARCHAR(1024),
    backupsetId             INT,
    backupsetName           NVARCHAR(1024),
    subclientId             INT,
    subclientName           NVARCHAR(1024),
    opType                  INT,
    operationName           NVARCHAR(128),
    backupLevel             INT,
    backupTypeName          NVARCHAR(128),
 	dataArchGrpId           INT,
	logArchGrpId            INT,
    storagePolicyName       NVARCHAR(1024),
    mediaAgent              NVARCHAR(MAX),
    startTime               BIGINT,
    startTimeDT             DATETIME,
    endTime                 BIGINT,
    endTimeDT               DATETIME,
    appSize                 BIGINT,
    mediaSize               BIGINT,
    nwTransBytes            BIGINT,
    dedupeSavings           DECIMAL(10,2),
    protectedObjects        BIGINT,
    failedObjects           BIGINT,
    failedFolders           INT,
    userName                NVARCHAR(512),
    jobStatus               INT,
    jobStatusName           NVARCHAR(128),
    failureReason           NVARCHAR(256),
    failureReasonMsg        NVARCHAR(1024),
    failureReasons          NVARCHAR(1024),
	vmClientName			NVARCHAR(1024) DEFAULT '',
	vmStatus				NVARCHAR(128) DEFAULT '',
	JobWriteTime					INT,
	JobThroughputinGBHour		FLOAT,
	isProtectVM			int default 0,
	ParentJobid			int default 0,
	virtualizationClient NVARCHAR(1024),
	retainedUntil       BIGINT,
	retainedBy          NVARCHAR(1024)
)
CREATE TABLE #JobSummary_tmp__JobList
(	id						INT IDENTITY(1,1),
    jobId                   INT,
    commCellId              INT,
    commCellName            NVARCHAR(1024),
    clientGroup             NVARCHAR(MAX),
    clientId                INT,
    clientName              NVARCHAR(1024),
    appTypeId               INT,
    appTypeName             NVARCHAR(1024),
    instanceId              INT,
    instanceName            NVARCHAR(1024),
    backupsetId             INT,
    backupsetName           NVARCHAR(1024),
    subclientId             INT,
    subclientName           NVARCHAR(1024),
    opType                  INT,
    operationName           NVARCHAR(128),
    backupLevel             INT,
    backupTypeName          NVARCHAR(128),
 	storagePolicyId         INT,
    storagePolicyName       NVARCHAR(1024),
    mediaAgent              NVARCHAR(MAX),
    startTime               BIGINT,
    endTime                 BIGINT,
    appSize                 BIGINT,
    mediaSize               BIGINT,
    nwTransBytes            BIGINT,
    dedupeSavings           DECIMAL(10,2),
    protectedObjects        BIGINT,
    failedObjects           BIGINT,
    failedFolders           INT,
    userName                NVARCHAR(512),
    jobStatus               INT,
    jobStatusName           NVARCHAR(128),
    failureReason           NVARCHAR(256),
    failureReasonMsg        NVARCHAR(1024),
    failureReasons          NVARCHAR(1024),
	vmClientName			NVARCHAR(1024),
	vmStatus				NVARCHAR(128),
	JobWriteTime					INT,
	JobThroughputinGBHour		FLOAT,
	isProtectVM			int default 0,
	ParentJobid			int default 0,
	virtualizationClient NVARCHAR(1024),
	retainedUntil       BIGINT,
	retainedBy          NVARCHAR(1024)
)
CREATE TABLE #JobSummary_tmp__Retention
(
	jobId INT,
	commCellId INT,
	archGrpCopyId INT,
	extRetentionFlags INT,
	extRetentionDays INT,
	pinRetentionDays INT
)
CREATE TABLE #maxJobRetention
(
	jobId INT,
	commCellId INT,
	extRetentionDays INT,
	pinRetentionDays INT
)
create table  #JobSummary_tmp__UserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
DECLARE @isUserAdmin INT = 0
EXEC sec_isUserAdmin @userId, @isUserAdmin OUTPUT
-- fill the Storage Policy and MediaAgent filters
IF	@includeAllStoragePolicies = 1 AND @userId > 0 AND @isUserAdmin = 0
BEGIN
	INSERT INTO #JobSummary_tmp__StoragePolicy
	SELECT  id, name
	FROM    archGroup AG WITH (NOLOCK)
	WHERE   id > 1 AND type IN (1,2,5,8) AND flags&64=0
	IF @userId > 0
	BEGIN
		EXEC sec_getUserObjects @userId, 2231, 0, '#JobSummary_tmp__UserObjects'
		IF NOT EXISTS(
			SELECT 1 FROM #JobSummary_tmp__UserObjects
			WHERE	commCellId=2 AND clientGroupId=0 AND clientId=0 AND appTypeId=0 AND instanceId=0 AND backupsetId=0 AND subClientId=0
				AND mediaAgentId=0 AND libraryId=0 AND archGroupId=0 AND vtContainerId=0 AND vtPolicyId=0 AND vtShelfId=0 AND reviewSetId=0
				AND querySetId=0 AND downloadSetId=0 AND ermId=0 AND legalHoldId=0 AND tagId=0 AND cdPolicyId=0 AND complianceReportId=0
				AND taskId=0 AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0 AND cloudId=0 AND userGroupId=0 AND providerId=0
				AND entityId1=0 AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0 AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0
			) --commcell level associations
		BEGIN
			DELETE	S FROM #JobSummary_tmp__StoragePolicy S LEFT OUTER JOIN #JobSummary_tmp__UserObjects U ON S.id = U.archGroupId
			WHERE	U.archGroupId IS NULL
		END
	END
END
IF	@includeAllMediaAgents = 1 AND @userId > 0 AND @isUserAdmin = 0
BEGIN
	INSERT INTO #JobSummary_tmp__MediaAgent
	SELECT  id, name, 0
	FROM    APP_Client CL WITH (NOLOCK) INNER JOIN MMHost H ON CL.id = H.ClientId
	IF @userId > 0
	BEGIN
		TRUNCATE TABLE #JobSummary_tmp__UserObjects
		EXEC sec_getUserObjects @userId, 2048, 0, '#JobSummary_tmp__UserObjects'
		IF EXISTS(
			SELECT 1 FROM #JobSummary_tmp__UserObjects
			WHERE	commCellId=2 AND clientGroupId=0 AND clientId=0 AND appTypeId=0 AND instanceId=0 AND backupsetId=0 AND subClientId=0
				AND mediaAgentId=0 AND libraryId=0 AND archGroupId=0 AND vtContainerId=0 AND vtPolicyId=0 AND vtShelfId=0 AND reviewSetId=0
				AND querySetId=0 AND downloadSetId=0 AND ermId=0 AND legalHoldId=0 AND tagId=0 AND cdPolicyId=0 AND complianceReportId=0
				AND taskId=0 AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0 AND cloudId=0 AND userGroupId=0 AND providerId=0
				AND entityId1=0 AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0 AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0
			) --commcell level associations
		BEGIN
			UPDATE	#JobSummary_tmp__MediaAgent SET visible = 1
		END
		ELSE
		BEGIN
			UPDATE	#JobSummary_tmp__MediaAgent SET visible = 1
			FROM	#JobSummary_tmp__MediaAgent S INNER JOIN #JobSummary_tmp__UserObjects U ON S.id = U.mediaAgentId
		END
		TRUNCATE TABLE #JobSummary_tmp__UserObjects
		EXEC sec_getUserObjects @userId, 2009, 0, '#JobSummary_tmp__UserObjects'
		IF EXISTS(
			SELECT 1 FROM #JobSummary_tmp__UserObjects
			WHERE	commCellId=2 AND clientGroupId=0 AND clientId=0 AND appTypeId=0 AND instanceId=0 AND backupsetId=0 AND subClientId=0
				AND mediaAgentId=0 AND libraryId=0 AND archGroupId=0 AND vtContainerId=0 AND vtPolicyId=0 AND vtShelfId=0 AND reviewSetId=0
				AND querySetId=0 AND downloadSetId=0 AND ermId=0 AND legalHoldId=0 AND tagId=0 AND cdPolicyId=0 AND complianceReportId=0
				AND taskId=0 AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0 AND cloudId=0 AND userGroupId=0 AND providerId=0
				AND entityId1=0 AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0 AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0
			) --commcell level associations
		BEGIN
			UPDATE	#JobSummary_tmp__MediaAgent SET visible = 1
		END
		ELSE
		BEGIN
			UPDATE	#JobSummary_tmp__MediaAgent SET visible = 1
			FROM	#JobSummary_tmp__MediaAgent S INNER JOIN #JobSummary_tmp__UserObjects U ON S.id = U.mediaAgentId
		END
		DELETE #JobSummary_tmp__MediaAgent WHERE visible = 0
	END
END
IF	@includeAllStoragePolicies = 0
BEGIN
	INSERT INTO #JobSummary_tmp__StoragePolicy
	SELECT
	0,x.value('(@entityName)[1]','NVARCHAR(255)') AS name
	FROM @storagePolicyFilter.nodes('/storagePolicyFilter/entities') as XMLtbl(x)
    INSERT  INTO #JobSummary_tmp__StoragePolicy
    SELECT  G.id, G.name
    FROM    #JobSummary_tmp__StoragePolicy T, archGroup G WITH (NOLOCK)
    WHERE   G.name = T.name
    DELETE  #JobSummary_tmp__StoragePolicy WHERE id = 0
END
IF	@includeAllMediaAgents = 0
BEGIN
	INSERT INTO #JobSummary_tmp__MediaAgent
	SELECT
	0,x.value('(@entityName)[1]','NVARCHAR(255)') AS name,1
	FROM @mediaAgentFilter.nodes('/mediaAgentFilter/entities') as XMLtbl(x)
    INSERT  INTO #JobSummary_tmp__MediaAgent
    SELECT  C.id, C.name, 1
    FROM    #JobSummary_tmp__MediaAgent T, APP_Client C WITH (NOLOCK)
    WHERE   C.name = T.name
    DELETE  #JobSummary_tmp__MediaAgent WHERE id = 0
END
DECLARE	@tblTableFilter TABLE (columnName NVARCHAR(128), filterValue NVARCHAR(1024), filterCondition NVARCHAR(16))
INSERT	INTO @tblTableFilter
SELECT
	x.value('(@columnName)[1]','NVARCHAR(128)') AS columnName,
	x.value('(@filterValue)[1]','NVARCHAR(1024)') AS filterValue,
	x.value('(@filterCondition)[1]','NVARCHAR(16)') AS filterCondition
	FROM @tableFilter.nodes('/WebReport_JobReportReq[1]/filters') as XMLtbl(x)
-- populate #JobSummary_tmp__subclient
IF	@includeAllClients = 0
BEGIN
	INSERT	INTO #JobSummary_tmp__clientId
	SELECT
	x.value('(@entityId)[1]','INT') AS id,
	x.value('(@entityName)[1]','NVARCHAR(255)') AS name
	FROM @clientFilter.nodes('/clientFilter/entities') as XMLtbl(x)
	UPDATE	#JobSummary_tmp__clientId
	SET		id = CL.id
	FROM	APP_Client CL WITH (NOLOCK)
	WHERE	CL.name = #JobSummary_tmp__clientId.name
	IF	@includeAllClientGroups = 0
	BEGIN
		INSERT	INTO #JobSummary_tmp__clientGroupId
		SELECT
		x.value('(@entityId)[1]','INT') AS id,
		x.value('(@entityName)[1]','NVARCHAR(255)') AS name
		FROM @clientGroupFilter.nodes('/clientGroupFilter/entities') as XMLtbl(x)
		UPDATE	#JobSummary_tmp__clientGroupId
		SET		id = CG.id
		FROM	APP_ClientGroup CG WITH (NOLOCK)
		WHERE	CG.name = #JobSummary_tmp__clientGroupId.name
		INSERT	INTO #JobSummary_tmp__clientId
		SELECT	DISTINCT CGA.clientId, N''
		FROM	#JobSummary_tmp__clientGroupId T, APP_ClientGroupAssoc CGA WITH (NOLOCK)
		WHERE	T.id = CGA.clientGroupId
			AND CGA.clientId NOT IN (SELECT id FROM #JobSummary_tmp__clientId)
	END
	ELSE
	BEGIN
		INSERT	INTO #JobSummary_tmp__clientId
		SELECT	DISTINCT clientId, N''
		FROM	APP_ClientGroupAssoc WITH (NOLOCK)
	END
END
IF	@includeAllAgents = 0
BEGIN
	INSERT	INTO #JobSummary_tmp__appTypeId
	SELECT
	0,
	x.value('(@entityName)[1]','NVARCHAR(255)') AS name
	FROM @agentFilter.nodes('/agentFilter/entities') as XMLtbl(x)
	INSERT	INTO #JobSummary_tmp__appTypeId
	SELECT	A.type, A.name
	FROM	#JobSummary_tmp__appTypeId T, APP_iDAType A WITH (NOLOCK)
	WHERE	A.name = T.name
	DELETE	#JobSummary_tmp__appTypeId WHERE id = 0
END
SET @useAbsTimeRangeForJobSummaryRpt = 0
IF EXISTS (
    SELECT 1
    FROM APP_AdvanceSettings WITH(NOLOCK)
    WHERE keyName = 'bUseAbsTimeRangeForJobSummaryRpt'
            AND type = 'BOOLEAN'
            AND relativePath = 'Reports'
            AND enabled = 1
            AND deleted = 0
            AND entityType = 3
            AND entityId = 2
            AND CONVERT(NVARCHAR(20), value) = N'true'
)
SET @useAbsTimeRangeForJobSummaryRpt = 1
IF @timeFrameType = 1
BEGIN
	IF @frequency = 1 BEGIN
SET @endTime 	= DATEDIFF(SS, '1970-01-01', GETUTCDATE())
SET	@startTime	= DATEDIFF(SS, '1970-01-01', DATEADD(DD, -@numberOfPeriods, GETUTCDATE()))
	END
	ELSE IF @frequency = 2 BEGIN
SET @endTime 	= DATEDIFF(SS, '1970-01-01', GETUTCDATE())
SET	@startTime	= DATEDIFF(SS, '1970-01-01', DATEADD(WK, -@numberOfPeriods, GETUTCDATE()))
	END
	ELSE IF @frequency = 3 BEGIN
		IF @useAbsTimeRangeForJobSummaryRpt = 1
		BEGIN
SET @endTime 	= DATEDIFF(SS, '1970-01-01', DATEADD(MONTH, DATEDIFF(MONTH, -1, GETUTCDATE())-1, -1))
SET	@startTime	= DATEDIFF(SS, '1970-01-01', DATEADD(MONTH, DATEDIFF(MONTH, 0, GETUTCDATE())-@numberOfPeriods, 0))
		END
		ELSE
		BEGIN
SET @endTime 	= DATEDIFF(SS, '1970-01-01', GETUTCDATE())
SET	@startTime	= DATEDIFF(SS, '1970-01-01', DATEADD(MM, -@numberOfPeriods, GETUTCDATE()))
		END
	END
	ELSE IF @frequency = 4 BEGIN
SET @endTime 	= DATEDIFF(SS, '1970-01-01', GetUTCDate())
SET	@startTime	= DATEDIFF(SS, '1970-01-01', DATEADD(HH, -@numberOfPeriods, GetUTCDate()))
	END
END
EXEC sec_getIdaObjectsForUser @UserId, 3, 0, 0, #JobSummary_tmp__EntityId
DELETE  E
FROM    #JobSummary_tmp__EntityId E
		LEFT OUTER JOIN APP_ClientProp CP WITH (NOLOCK) ON E.clientId = CP.componentNameId
			AND CP.attrName = 'Virtual Server Discovered Clients' AND CP.attrVal = '1'
WHERE	CP.componentNameId IS NULL
IF  @includeLogDeletedSubclients = 0
BEGIN
	DELETE  E
	FROM    #JobSummary_tmp__EntityId E
			INNER JOIN APP_ClientProp CP WITH (NOLOCK) ON E.clientId = CP.componentNameId
				AND CP.attrName = 'Virtual Machine Deletion Time' AND CP.attrVal <> '0'
END
EXEC sec_getIdaObjectsForUser @UserId, 7, 0, 0, #JobSummary_tmp__EntityId
IF  @includeLogDeletedSubclients = 0
BEGIN
	DELETE	E
	FROM	#JobSummary_tmp__EntityId E
			INNER JOIN App_Application A WITH (NOLOCK) ON E.subclientId = A.id
			INNER JOIN APP_Client CL WITH (NOLOCK) ON CL.id = A.clientId
	WHERE	CL.status&(2|4) > 0 OR A.subclientStatus&(2|4) > 0
END
IF	@includeAllClients = 0
BEGIN
	IF @includeAllClientGroups = 1
		INSERT	INTO #JobSummary_tmp__clientId
		SELECT	DISTINCT E.clientId, N''
		FROM	#JobSummary_tmp__EntityId E LEFT OUTER JOIN #JobSummary_tmp__clientId C ON E.clientId = C.id
		WHERE	C.id IS NULL
	INSERT	INTO #JobSummary_tmp__appId
	SELECT	DISTINCT C.id, B.appType, B.appId
	FROM	#JobSummary_tmp__clientId C
            INNER JOIN APP_VMProp VM  WITH (NOLOCK) ON VM.VMclientId = C.id AND VM.attrName = 'vmStatus'
			INNER JOIN JMBkpStats B   WITH (NOLOCK) ON B.jobId = VM.jobId AND B.commCellId = VM.commCellId
	UNION
	SELECT	DISTINCT clientId, appTypeId, subclientId
	FROM	#JobSummary_tmp__EntityId E INNER JOIN #JobSummary_tmp__clientId C ON E.clientId = C.id
	WHERE	subclientId > 0
	UNION
	SELECT	DISTINCT C.id,A.appTypeId, jLink.childAppid
	FROM	#JobSummary_tmp__clientId C
            INNER JOIN APP_Application A  WITH (NOLOCK) ON A.clientId = C.id
			INNER JOIN jmjobdatalink jLink   WITH (NOLOCK) ON jLink.childAppid = a.id AND jLink.commCellId = a.origCCId AND jLink.linkType = 7
END
ELSE
	INSERT	INTO #JobSummary_tmp__appId
	SELECT	DISTINCT C.clientId, B.appType, B.appId
	FROM	#JobSummary_tmp__EntityId C
            INNER JOIN APP_VMProp VM  WITH (NOLOCK) ON VM.VMclientId = C.clientId AND VM.attrName = 'vmStatus'
			INNER JOIN JMBkpStats B   WITH (NOLOCK) ON B.jobId = VM.jobId AND B.commCellId = VM.commCellId
	UNION
	SELECT	DISTINCT clientId, appTypeId, subclientId
	FROM	#JobSummary_tmp__EntityId
	WHERE	subclientId > 0
DROP TABLE  #JobSummary_tmp__EntityId
IF	EXISTS (SELECT id FROM #JobSummary_tmp__clientId)
	DELETE	#JobSummary_tmp__appId
	FROM	#JobSummary_tmp__appId E LEFT OUTER JOIN #JobSummary_tmp__clientId C
		ON	E.clientId = C.id
	WHERE	C.id IS NULL
IF	EXISTS (SELECT id FROM #JobSummary_tmp__appTypeId)
BEGIN
	DELETE	#JobSummary_tmp__appId
	FROM	#JobSummary_tmp__appId E LEFT OUTER JOIN #JobSummary_tmp__appTypeId A
		ON	E.appTypeId = A.id
	WHERE	A.id IS NULL
	IF	NOT EXISTS (SELECT id FROM #JobSummary_tmp__appTypeId WHERE id <> 106)
		SET @onlyVSAJobs = 1
END
INSERT	INTO #VSA_AppIDs (appId, isIndexingV2, isBackupDisabled, isDeconfigured)
SELECT	A.id, ISNULL(CP.attrVal, 0), 0, 0
FROM	APP_Application A WITH (NOLOCK)
		INNER JOIN APP_InstanceProp IP WITH (NOLOCK) ON IP.componentNameId = A.instance
			AND IP.attrName = 'Virtual Server Instance Type' AND IP.attrVal <> '' AND IP.modified = 0
		LEFT OUTER JOIN APP_ClientProp CP WITH (NOLOCK) ON CP.componentNameId = A.clientId
			AND CP.attrName = 'IndexingV2_VSA' AND CP.modified = 0 AND CP.attrVal = '1'
WHERE	A.appTypeId = 106 AND A.subclientStatus&0x00020 = 0
-- Not include IndexingV2_VSA subclients
INSERT	INTO #JobSummary_tmp__Entity
SELECT  CC.id, CC.aliasName,
        CL.id, dbo.NormalizeForXML(CL.name),
        IDA.type, IDA.name,
        I.id, I.name,
        BS.id,  CASE WHEN BS.name IN ('default', 'defaultBackupSet', 'defaultDummyBackupSet', 'defaultArchiveSet', 'Indexing BackupSet')
				THEN BS.name ELSE dbo.NormalizeForXML(BS.name) END,
        APP.id, CASE WHEN APP.subclientName IN ('default', '(command line)', '(Logcommand line)', 'ArchiveLog', 'IndexBackup', 'IndexingSubclient', 'DDBbackup', 'System State')
				THEN APP.subclientName ELSE dbo.NormalizeForXML(APP.subclientName) END,
        CASE WHEN A.clientId = CL.id THEN 0 ELSE A.clientId END
FROM    #JobSummary_tmp__appId       A
        INNER JOIN APP_Application   APP WITH (NOLOCK) ON APP.id = A.appId
		INNER JOIN APP_CommCell      CC  WITH (NOLOCK) ON CC.id = APP.origCCId
	    INNER JOIN APP_Client        CL  WITH (NOLOCK) ON CL.id = APP.clientId
        INNER JOIN APP_iDAType       IDA WITH (NOLOCK) ON IDA.[type] = APP.appTypeId
        INNER JOIN APP_InstanceName  I   WITH (NOLOCK) ON I.id = APP.instance
        INNER JOIN APP_BackupSetName BS  WITH (NOLOCK) ON BS.id = APP.backupset
		LEFT OUTER JOIN #VSA_AppIDs  VSA ON VSA.appId = APP.id AND VSA.isIndexingV2 = 1
WHERE	VSA.appId IS NULL
DROP TABLE  #JobSummary_tmp__appId
INSERT	INTO #JobSummary_tmp__InstanceName
SELECT	DISTINCT appTypeId, instanceName, ''
FROM	#JobSummary_tmp__Entity
WHERE	appTypeId IN (3, 4, 16, 6, 7, 5, 51, 52, 2, 22, 23, 80, 27, 31, 32, 37, 60, 59,
			62, 77, 70, 81, 104, 61, 79, 90, 103, 125, 128, 106, 58, 134, 135, 136)
UPDATE	#JobSummary_tmp__InstanceName SET displayInstanceName = dbo.GetInstanceName(instanceName, appTypeId)
UPDATE	J SET instanceName = displayInstanceName
FROM	#JobSummary_tmp__Entity J
		INNER JOIN #JobSummary_tmp__InstanceName T ON J.appTypeId = T.appTypeId AND J.instanceName = T.instanceName
IF @includeDisabledSubClients = 0
BEGIN
	DELETE	#JobSummary_tmp__Entity
	FROM	#JobSummary_tmp__Entity S INNER JOIN JMJobAction J WITH (NOLOCK)
		ON	J.opType IN (4, 76) AND J.action = 1
		AND J.clientId = S.ClientId AND J.appType IN (S.AppTypeId, 0)
	DELETE	#JobSummary_tmp__Entity
	FROM	#JobSummary_tmp__Entity S INNER JOIN JMJobAction J WITH (NOLOCK)
		ON	J.opType IN (4, 76) AND J.action = 1
		AND J.instanceId = S.instanceId AND J.instanceId > 1
	DELETE	#JobSummary_tmp__Entity
	FROM	#JobSummary_tmp__Entity S INNER JOIN JMJobAction J WITH (NOLOCK)
		ON	J.opType IN (4, 76) AND J.action = 1
		AND J.appId = S.subclientId AND S.subclientId > 0
	DELETE	#JobSummary_tmp__Entity
	FROM	#JobSummary_tmp__Entity S
			INNER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON S.clientId = CGA.clientId
			INNER JOIN JMJobAction J WITH (NOLOCK) ON CGA.clientGroupId = J.clientGroupId
				AND J.clientGroupId > 0 AND J.ClientId = 1 AND J.AppType = 0 AND J.AppId = 1
				AND J.opType IN (4, 76) AND J.action = 1
	-- Delete IndexingV2_VSA child subclient if parent subclient is disabled
	UPDATE	VSA SET isBackupDisabled = 1
	FROM	#VSA_AppIDs VSA
			INNER JOIN APP_Application A WITH (NOLOCK) ON VSA.appId = A.id
			INNER JOIN JMJobAction J WITH (NOLOCK) ON J.opType IN (4, 76) AND J.action = 1
				AND J.clientId = A.ClientId AND J.appType IN (A.AppTypeId, 0)
	UPDATE	VSA SET isBackupDisabled = 1
	FROM	#VSA_AppIDs VSA
			INNER JOIN JMJobAction J WITH (NOLOCK) ON J.opType IN (4, 76) AND J.action = 1
				AND J.appId = VSA.appId
	UPDATE	VSA SET isBackupDisabled = 1
	FROM	#VSA_AppIDs VSA
			INNER JOIN APP_Application A WITH (NOLOCK) ON VSA.appId = A.id
			INNER JOIN APP_ClientGroupAssoc CGA WITH (NOLOCK) ON A.clientId = CGA.clientId
			INNER JOIN JMJobAction J WITH (NOLOCK) ON CGA.clientGroupId = J.clientGroupId
				AND J.clientGroupId > 0 AND J.ClientId = 1 AND J.AppType = 0 AND J.AppId = 1
				AND J.opType IN (4, 76) AND J.action = 1
	DELETE	#JobSummary_tmp__Entity
	FROM	#JobSummary_tmp__Entity S
			INNER JOIN (
				SELECT	JL.childAppId, JL.parentAppId, ROW_NUMBER() OVER (PARTITION BY JL.childAppId ORDER BY JL.childJobId DESC) AS rowId
				FROM	JMJobDataLink JL WITH (NOLOCK)
						INNER JOIN #VSA_AppIDs VSA ON JL.parentAppId = VSA.appId AND VSA.isIndexingV2 = 1 AND VSA.isBackupDisabled = 1
AND JL.linkType = 7
				) J ON S.subclientId = J.childAppId
	WHERE	J.rowId = 1
END
IF  @includeLogDeletedSubclients = 0
BEGIN
	DELETE	#JobSummary_tmp__Entity
	FROM	#JobSummary_tmp__Entity S
			INNER JOIN (
				SELECT	JL.childAppId, JL.parentAppId, ROW_NUMBER() OVER (PARTITION BY JL.childAppId ORDER BY JL.childJobId DESC) AS rowId
				FROM	JMJobDataLink JL WITH (NOLOCK)
						INNER JOIN #VSA_AppIDs VSA ON JL.parentAppId = VSA.appId AND VSA.isIndexingV2 = 1 AND VSA.isDeconfigured = 1
AND JL.linkType = 7
				) J ON S.subclientId = J.childAppId
	WHERE	J.rowId = 1
END
IF @archiveJobs = 0
	DELETE	FROM #JobSummary_tmp__Entity
WHERE	AppTypeId IN (67, 137, 82)
ELSE
IF @backupJobs = 0
	DELETE	E FROM #JobSummary_tmp__Entity E
			LEFT OUTER JOIN APP_SubClientProp P WITH (NOLOCK)
		ON	E.subclientId = P.componentNameId AND P.attrName ='Is Turbo Subclient' and P.attrVal ='1' and P.modified=0
	WHERE	P.componentNameId IS NULL
AND E.AppTypeId NOT IN (67, 137, 82)
INSERT INTO #JobSummary_tmp__Jobs(
		jobId, commCellId, commCellName,
		clientGroup, clientId, clientName, appTypeId, appTypeName,
		instanceId, instanceName, backupsetId, backupsetName, subclientId, subclientName,
		opType, operationName, backupLevel, backupTypeName,
		dataArchGrpId, logArchGrpId, storagePolicyName, mediaAgent, startTime, startTimeDT, endTime, endTimeDT,
		appSize, mediaSize, nwTransBytes, dedupeSavings, protectedObjects, failedObjects, failedFolders,
		userName, jobStatus, jobStatusName, failureReason, failureReasonMsg, failureReasons, JobWriteTime, JobThroughputinGBHour,
		ParentJobid, isProtectVM, retainedUntil, retainedBy)
-- Get the data from the running tables first. Data in those tables is more accurate and gets updated more frequent.
-- To differentiate between <state>:[running job] and <status>:[finished job] we will adjust <state> to be <state> + 100
-- <status> will remain the same
-- -- backup jobs
-- -- -- finished backup jobs
SELECT  B.jobId, B.commCellId, A.commCellName,
		'', A.clientId, A.clientName, A.appTypeId, A.appTypeName,
		A.instanceId, A.instanceName, A.backupsetId, A.backupsetName, A.subclientId, A.subclientName,
		B.opType, N'', B.bkpLevel, N'',
		CASE WHEN B.dataBackedUp = 1 THEN B.dataArchGrpId ELSE 0 END,
		CASE WHEN B.LogsBackedUp = 1 THEN B.logArchGrpId ELSE 0 END, N'', N'',
		B.servStartDate, DATEADD(SS, B.servStartDate + @Bias, '1970-01-01'),
		B.servEndDate, DATEADD(SS, B.servEndDate + @Bias, '1970-01-01'),
		B.totalUncompBytes, 0, B.nwTransBytes,
		CASE WHEN B.opType = 60 OR B.status IN (2, 9, 4) THEN -1 ELSE 0 END,
		totalNumOfFiles, B.backupFileFailures, B.backupFolderFailures,
		B.username, CASE B.displayStatus WHEN 0 THEN B.status ELSE B.displayStatus END, N'', B.failureReason, N'', N'',
totalWriteTime,-1,case when bkpAttributesEx & 0x4000000 <> 0 then jLink.parentJobId else -1 end,
case when bkpAttributesEx & 0x4000000 <> 0 then 1 else 0 end,@defaultRetention, 'Basic Retention'
FROM    JMBkpStats B WITH (NOLOCK)
		INNER JOIN (SELECT DISTINCT commCellName, clientId, clientName, appTypeId, appTypeName,	instanceId, instanceName, backupsetId, backupsetName, subclientId, subclientName
					FROM #JobSummary_tmp__Entity) A ON B.appId = A.subclientId
LEFT JOIN JMJobDataLink jLink WITH(NOLOCK) ON (B.bkpAttributesEx & 0x4000000 <> 0) AND B.jobId = jLink.childJobId AND B.commcellId = jLink.commCellId AND jLink.linkType = 7
WHERE	( servEndDate >= @startTime AND servStartDate <= @endTime )
	AND (B.dataStatus NOT IN (1, 2) OR B.dataStatus = 1 AND @IncludeAgedJobs = 1 OR B.dataStatus = 2 AND @includeMediaDeletedJobs = 1 OR B.status IN (2, 4, 9))
	AND B.opType NOT IN (SELECT opType FROM @ExcludedOpType)
		-- filter out backup types
	AND (CASE WHEN B.bkpLevel = 2 THEN (CASE WHEN B.appType IN (4,5,16,70,81,125) THEN 8 ELSE 2 END) ELSE B.bkpLevel END)&@BackupLevels > 0
		-- filter out job statuses
	AND (CASE B.displayStatus WHEN 0 THEN B.status ELSE B.displayStatus END) IN (SELECT status FROM @JobStatusTbl)
IF(@onlyVSAJobs = 0)
-- Update parent job id for synth full jobs
UPDATE T
SET parentJobId = JM.parentjobid,isProtectVM = 1
FROM #JobSummary_tmp__Jobs T
INNER JOIN JMJobDataLink JM ON JM.childJobId = T.jobId AND JM.linkType = 7 AND T.commCellId = JM.commCellId
AND T.backupLevel = 64 AND T.opType = 14 /* SYNTHFULL */
-- Change jobStatus for GUI
UPDATE	#JobSummary_tmp__Jobs
	SET jobStatus = CASE jobStatus
		WHEN  1 THEN  1  -- JMSUCCESS                : COMPLETED
		WHEN  2 THEN  4  -- FAIL                     : FAILED
		WHEN  3 THEN  2  -- PARTIALSUCCESS           : COMPLETED_WITH_ERRORS
		WHEN  4 THEN  5  -- KILLED                   : KILLED
		WHEN  5 THEN  6  -- STSTOPPED                : DELAYED
		WHEN  6 THEN  6  -- STINTERRUPTED            : DELAYED
		WHEN  8 THEN  8  -- STSKIPPED                : NO RUN
		WHEN  9 THEN  8  -- DROPPED                  : NO RUN
		WHEN 10 THEN  4  -- INSYNC                   : RUNNING
		WHEN 11 THEN  4  -- OUTOFSYNC                : RUNNING
		WHEN 12 THEN  7  -- NOTATTEMPTED             : RUNNING
		WHEN 13 THEN  7  -- CVJOBSTATUS_STARTED      : RUNNING
		WHEN 14 THEN  3  -- JMSUCCESSWITHWARNINGS    : COMPLETED_WITH_WARNINGS
		WHEN 15 THEN  4  -- SYSTEMFAILED	         : FAILED
		WHEN 16 THEN  9  -- COMMITTED 	             : COMPLETED_WITH_WARNINGS
		ELSE -1 END
CREATE INDEX #JobSummary_tmp__Jobs_idx ON #JobSummary_tmp__Jobs (jobId, commCellId,ParentJobid)
CREATE INDEX #JobSummary_tmp__opType_appTypeId_idx ON #JobSummary_tmp__Jobs (opType, appTypeId)
-- -- -- runnig backup jobs
INSERT INTO #JobSummary_tmp__Jobs(
		jobId, commCellId, commCellName,
		clientGroup, clientId, clientName, appTypeId, appTypeName,
		instanceId, instanceName, backupsetId, backupsetName, subclientId, subclientName,
		opType, operationName, backupLevel, backupTypeName,
		dataArchGrpId, logArchGrpId, storagePolicyName, mediaAgent, startTime, startTimeDT, endTime, endTimeDT,
		appSize, mediaSize, nwTransBytes, dedupeSavings, protectedObjects, failedObjects, failedFolders,
		userName, jobStatus, jobStatusName, failureReason, failureReasonMsg, failureReasons, JobWriteTime,JobThroughputinGBHour,ParentJobid,isProtectVM)
SELECT  BI.jobId, BI.commCellId, A.commCellName,
		'', A.clientId, A.clientName, A.appTypeId, A.appTypeName,
		A.instanceId, A.instanceName, A.backupsetId, A.backupsetName, A.subclientId, A.subclientName,
		JI.opType, N'', BI.bkpLevel, N'',
		BI.dataPolicy, BI.logPolicy, N'', N'',
		JI.jobStartTime, DATEADD(SS, JI.jobStartTime + @Bias, '1970-01-01'),
		-1, NULL,
		BI.unCompBytes, 0, BI.nwTransBytes,
		CASE WHEN JI.opType = 60 THEN -1 ELSE 0 END,
	    BI.filesXfered, BI.backupFileFailures, BI.backupFolderFailures,
		U.[login], JI.[state], N'', JI.failureReason, N'', N'',
		isnull((select sum(writeTime) from JMBkpAttemptInfo WITH (READUNCOMMITTED) where JMBkpAttemptInfo.jobId=JI.jobId and writeTime>0), 0)+isnull((select max(writeTime) from JMJobStreams WITH (READUNCOMMITTED) where jobId=JI.jobId and writeTime>0), 0),-1,-1,0
FROM	JMJobInfo JI
		INNER JOIN JMBkpJobInfo BI WITH (NOLOCK) ON JI.commCellId = BI.commCellId AND JI.jobId = BI.jobId
		INNER JOIN (SELECT distinct clientId, clientName, commCellName, appTypeId, appTypeName, instanceId, instanceName, backupsetId, backupsetName, subclientId, subclientName
					FROM #JobSummary_tmp__Entity) A ON A.subclientId = BI.applicationId
		INNER JOIN USusers U WITH (NOLOCK) ON U.userId = JI.userId
		LEFT OUTER JOIN #JobSummary_tmp__Jobs J ON JI.commCellId = J.commCellId AND JI.jobId = J.jobId
WHERE	J.jobId IS NULL
	AND JI.jobStartTime <= @endTime
	AND JI.opType NOT IN (SELECT opType FROM @ExcludedOpType)
		-- filter out backup types
 	AND (CASE WHEN BI.bkpLevel = 2 THEN (CASE WHEN A.appTypeId IN (4,5,16,70,81,125) THEN 8 ELSE 2 END) ELSE BI.bkpLevel END)&@BackupLevels > 0
		-- filter out job states
	AND JI.state IN (SELECT state FROM @JobStateTbl)
IF @DSTFlag = 1
BEGIN
	UPDATE	J SET startTime = DATEDIFF(SS, '1970-01-01', DATEADD(SS, DSTBias, startTimeDT)),
				startTimeDT = DATEADD(SS, DSTBias, startTimeDT)
	FROM	#JobSummary_tmp__Jobs J
			INNER JOIN SchedTimeZoneDates D ON TimeZoneID = @csTimeZoneId AND J.startTimeDT BETWEEN DSTDate AND STDDate
	UPDATE	J SET endTime = DATEDIFF(SS, '1970-01-01', DATEADD(SS, DSTBias, endTimeDT)),
				endTimeDT = DATEADD(SS, DSTBias, endTimeDT)
	FROM	#JobSummary_tmp__Jobs J
			INNER JOIN SchedTimeZoneDates D ON TimeZoneID = @csTimeZoneId AND J.endTimeDT BETWEEN DSTDate AND STDDate
	WHERE	endTime > 0
END
UPDATE	#JobSummary_tmp__Jobs
	SET jobStatus = CASE jobStatus
		WHEN  1 THEN  7  -- RUNNING                  : RUNNING
		WHEN  2 THEN  6  -- PENDING                  : DELAYED
		WHEN  3 THEN  6  -- WAITING                  : DELAYED
		WHEN  4 THEN  1  -- COMPLETED                : COMPLETED
		WHEN  5 THEN  6  -- STOPPED                  : DELAYED
		WHEN  6 THEN  7  -- KILLPENDING              : RUNNING
		WHEN  7 THEN  7  -- STOPPENDING              : RUNNING
		WHEN  8 THEN  7  -- INTERRUPTPENDING         : RUNNING
		WHEN  9 THEN  1  -- COMPLETEDSUCCESS         : COMPLETED
		WHEN 10 THEN  4  -- COMPLETEDFAIL            : FAILED
		WHEN 11 THEN  5  -- STATEKILLED              : KILLED
		WHEN 12 THEN  2  -- COMPLETEDPARTIAL         : COMPLETED_WITH_ERRORS
		WHEN 13 THEN  7  -- SYSTEMKILLPENDING        : RUNNNING
		WHEN 14 THEN  6  -- DORMANT                  : DELAYED
		WHEN 15 THEN  6  -- QUEUED                   : DELAYED
		WHEN 16 THEN  6  -- DORMANTSCHEDWAIT         : DELAYED
		WHEN 17 THEN  7  -- RUNNING_UNVERIFIABLE     : RUNNING
		WHEN 18 THEN  4  -- DANGLINGJOBCLEANUP       : FAILED
		WHEN 19 THEN  3  -- COMPLETEDWITHWARNINGS    : COMPLETED_WITH_WARNINGS
		ELSE -1 END
WHERE	endTime = -1
-- Set Job Status string
INSERT	INTO #JobSummary_tmp__JobStatus
VALUES	(1, 'Completed', 1023410748), (2, 'Completed with errors', 1023410749), (3, 'Completed with warnings', 1023412930),
		(4, 'Failed', 1023410755),    (5, 'Killed', 1023410754),                (6, 'Delayed', 1023410746),
		(7, 'Running', 1023410740),   (8, 'No Run', 1023411223),                (9, 'Committed', 1023413512)
IF @localeId > 0
	UPDATE	S SET statusName = M.Message
	FROM	#JobSummary_tmp__JobStatus S
			INNER JOIN EvLocaleMsgs M WITH (NOLOCK) ON S.messageId = M.MessageID AND M.LocaleID = @localeId
DECLARE @CompletedStatus NVARCHAR(64) = (SELECT statusName FROM #JobSummary_tmp__JobStatus WHERE status = 1)
DECLARE @FailedStatus    NVARCHAR(64) = (SELECT statusName FROM #JobSummary_tmp__JobStatus WHERE status = 4)
DECLARE @CWEStatus       NVARCHAR(64) = (SELECT statusName FROM #JobSummary_tmp__JobStatus WHERE status = 2)
UPDATE	J SET jobStatusName = S.statusName
FROM	#JobSummary_tmp__Jobs J
		INNER JOIN #JobSummary_tmp__JobStatus S WITH (NOLOCK) ON J.jobStatus = S.status
DECLARE @TypeName NVARCHAR(64)
-- Set Job Operation string
IF @localeId = 0
BEGIN
	UPDATE	J SET operationName = O.opName
	FROM	#JobSummary_tmp__Jobs J
			INNER JOIN JMJobOperationNames O WITH (NOLOCK) ON J.opType = O.opType
	UPDATE	#JobSummary_tmp__Jobs SET operationName = (SELECT opName FROM JMJobOperationNames WITH (NOLOCK) WHERE opType = 4)
	WHERE	opType = 14 AND endTime = -1
END
ELSE
BEGIN
	INSERT	INTO #JobSummary_tmp__TypeName
	SELECT	O.opType, ISNULL(M.Message, O.opName)
	FROM	JMJobOperationNames O WITH (NOLOCK)
			INNER JOIN (SELECT DISTINCT opType FROM #JobSummary_tmp__Jobs) T ON O.opType = T.opType
			LEFT OUTER JOIN EvLocaleMsgs M WITH (NOLOCK) ON O.messageId = M.MessageID AND M.LocaleID = @localeId
	UPDATE	J SET operationName = T.name
	FROM	#JobSummary_tmp__Jobs J
			INNER JOIN #JobSummary_tmp__TypeName T ON J.opType = T.type
	SET @TypeName = (
			SELECT	TOP 1 ISNULL(M.Message, O.opName)
			FROM	JMJobOperationNames O WITH (NOLOCK)
					LEFT OUTER JOIN EvLocaleMsgs M WITH (NOLOCK) ON O.messageId = M.MessageID AND M.LocaleID = @localeId
			WHERE	O.opType = 4)
	UPDATE	#JobSummary_tmp__Jobs SET operationName = @TypeName
	WHERE	opType = 14 AND endTime = -1
	DELETE  FROM #JobSummary_tmp__TypeName
END
SET @TypeName = (SELECT TOP 1 Message FROM EvLocaleMsgs WITH (NOLOCK)
WHERE MessageID = (1618 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND LocaleID = @localeId)
IF ISNULL(@TypeName, '') <> ''
	UPDATE	#JobSummary_tmp__Jobs SET operationName = @TypeName
	WHERE	opType = 4 AND appTypeId = 67
SET @TypeName = (SELECT TOP 1 Message FROM EvLocaleMsgs WITH (NOLOCK)
WHERE MessageID = (2026 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND LocaleID = @localeId)
IF ISNULL(@TypeName, '') <> ''
	UPDATE	#JobSummary_tmp__Jobs SET operationName = @TypeName
	WHERE	opType = 18 AND endTime = -1
-- Set Backup Type string
DECLARE	@FullBackupName NVARCHAR(64) = N'Full'
IF @localeId = 0
BEGIN
	UPDATE	J SET backupTypeName = B.bkpLevelName
	FROM	#JobSummary_tmp__Jobs J
			INNER JOIN JMBackupLevelNames B WITH (NOLOCK) ON J.backupLevel = B.bkpLevel
END
ELSE
BEGIN
	INSERT	INTO #JobSummary_tmp__TypeName
	SELECT	B.bkpLevel, ISNULL(M.Message, B.bkpLevelName)
	FROM	JMBackupLevelNames B WITH (NOLOCK)
			INNER JOIN (SELECT DISTINCT backupLevel FROM #JobSummary_tmp__Jobs) T ON B.bkpLevel = T.backupLevel
			LEFT OUTER JOIN EvLocaleMsgs M WITH (NOLOCK) ON B.messageId = M.MessageID AND M.LocaleID = @localeId
	UPDATE	J SET backupTypeName = T.name
	FROM	#JobSummary_tmp__Jobs J
			INNER JOIN #JobSummary_tmp__TypeName T ON J.backupLevel = T.type
	SELECT	@FullBackupName = name FROM #JobSummary_tmp__TypeName WHERE type = 1
	DELETE  FROM #JobSummary_tmp__TypeName
END
SET @TypeName = (SELECT TOP 1 Message FROM EvLocaleMsgs WITH (NOLOCK) WHERE MessageID = (772 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND LocaleID = @localeId)
IF ISNULL(@TypeName, '') <> ''
	UPDATE	#JobSummary_tmp__Jobs SET backupTypeName = @TypeName
	WHERE	backupLevel = 1 AND appTypeId IN (45,56,57,58,67,73)
SET @TypeName = (SELECT TOP 1 Message FROM EvLocaleMsgs WITH (NOLOCK) WHERE MessageID = (774 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND LocaleID = @localeId)
IF ISNULL(@TypeName, '') <> ''
	UPDATE	#JobSummary_tmp__Jobs SET backupTypeName = @TypeName
	WHERE	backupLevel = 2 AND appTypeId IN (4,5,16,70,81)
SET @TypeName = (SELECT TOP 1 Message FROM EvLocaleMsgs WITH (NOLOCK) WHERE MessageID = (1707 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND LocaleID = @localeId)
IF ISNULL(@TypeName, '') <> ''
	UPDATE	#JobSummary_tmp__Jobs SET backupTypeName = @TypeName
	WHERE	backupLevel = 2 AND appTypeId = 125
SET @TypeName = (SELECT TOP 1 Message FROM EvLocaleMsgs WITH (NOLOCK) WHERE MessageID = (777 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND LocaleID = @localeId)
IF ISNULL(@TypeName, '') <> ''
	UPDATE	#JobSummary_tmp__Jobs SET backupTypeName = @TypeName
	WHERE	backupLevel = 4 AND appTypeId IN (37,62)
SET @TypeName = (SELECT TOP 1 Message FROM EvLocaleMsgs WITH (NOLOCK) WHERE MessageID = (775 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND LocaleID = @localeId)
IF ISNULL(@TypeName, '') <> ''
	UPDATE	#JobSummary_tmp__Jobs SET backupTypeName = @TypeName
	WHERE	backupLevel = 256 AND appTypeId = 104
--retentions
IF @IncludeRetention IN (0, 2, 3)
BEGIN
	INSERT INTO #JobSummary_tmp__Retention
	SELECT DISTINCT B.jobId,
					B.commCellId,
					B.archGrpCopyId,
					MAX(CASE WHEN B.retentionFlags & 64 <> 0 THEN 64 WHEN B.retentionFlags & 32 <> 0 THEN 32 WHEN B.retentionFlags & 16 <> 0 THEN 16 WHEN B.retentionFlags & 8 <> 0 THEN 8 WHEN B.retentionFlags & 4 <> 0 THEN 4 WHEN B.retentionFlags & 2 <> 0 THEN 2 END),
					0,
					MAX(CASE WHEN B.manualRetentionEndTime = -1 THEN @MAXINT ELSE (B.manualRetentionEndTime - J.startTime) END)
	FROM JMJobDataStats B WITH (NOLOCK)
	INNER JOIN #JobSummary_tmp__Jobs J ON B.commCellId = J.commCellId AND B.jobId = J.jobId
	WHERE B.status = 100 AND B.disabled&256 = 0 AND (@IncludeRetention IN (0, 2) AND B.retentionFlags > 0 OR @IncludeRetention IN (0, 3) AND B.manualRetentionEndTime <> 0)
	GROUP BY B.jobId, B.commCellId, B.archGrpCopyId
	IF @IncludeRetention IN (0, 2)
	UPDATE R
	SET extRetentionDays = (CASE WHEN E.retentionDays = -1 THEN @MAXINT ELSE E.retentionDays END)
	FROM #JobSummary_tmp__Retention R
	INNER JOIN archAgingRuleExtended E WITH (NOLOCK) ON R.archGrpCopyId = E.copyId AND R.extRetentionFlags = E.retentionRule
	INSERT INTO #maxJobRetention
	SELECT jobId, commCellId, MAX(extRetentionDays), MAX(pinRetentionDays)
	FROM #JobSummary_tmp__Retention
	GROUP BY jobId, commCellId
	UPDATE J
	SET retainedUntil = (CASE WHEN pinRetentionDays > extRetentionDays THEN (CASE WHEN pinRetentionDays = @MAXINT THEN @MAXINT ELSE J.startTime + pinRetentionDays END) ELSE (CASE WHEN extRetentionDays = @MAXINT THEN @MAXINT ELSE J.startTime + extRetentionDays END) END),
		retainedBy = (CASE WHEN pinRetentionDays > extRetentionDays THEN 'Manual Retention' ELSE 'Extended Retention' END)
	FROM #JobSummary_tmp__Jobs J
	INNER JOIN #maxJobRetention R ON J.jobId = R.jobId AND J.commCellId = R.commCellId AND J.ParentJobid = -1
	UPDATE J
	SET retainedUntil = (CASE WHEN pinRetentionDays > extRetentionDays THEN (CASE WHEN pinRetentionDays = @MAXINT THEN @MAXINT ELSE J.startTime + pinRetentionDays END) ELSE (CASE WHEN extRetentionDays = @MAXINT THEN @MAXINT ELSE J.startTime + extRetentionDays END) END),
		retainedBy = (CASE WHEN pinRetentionDays > extRetentionDays THEN 'Manual Retention' ELSE 'Extended Retention' END)
	FROM #JobSummary_tmp__Jobs J INNER JOIN #maxJobRetention R ON J.ParentJobid = R.jobId AND J.commCellId = R.commCellId AND J.ParentJobid <> -1
END
	IF @IncludeRetention = 1
	BEGIN
		DELETE FROM #JobSummary_tmp__Jobs WHERE retainedBy NOT LIKE 'Basic Retention'
	END
	ELSE IF @IncludeRetention = 2
	BEGIN
		DELETE FROM #JobSummary_tmp__Jobs WHERE retainedBy NOT LIKE 'Extended Retention'
	END
	ELSE IF @IncludeRetention = 3
	BEGIN
		DELETE FROM #JobSummary_tmp__Jobs WHERE retainedBy NOT LIKE 'Manual Retention'
	END
UPDATE  #JobSummary_tmp__Jobs
SET     mediaSize = T2.sizeOnMedia,
		dedupeSavings = CASE WHEN opType = 60 OR jobStatus NOT IN (1, 2, 3) THEN -1
								WHEN appSize > T2.sizeOnMedia THEN ROUND(100.0*(appSize - T2.sizeOnMedia)/appSize, 2)
								ELSE 0 END
FROM	(SELECT	T1.jobId, T1.commCellId, MAX(T1.sizeOnMedia) AS sizeOnMedia
		FROM	(SELECT	S.jobId, S.commCellId, S.archGrpCopyId, SUM(S.sizeOnMedia) AS sizeOnMedia
				FROM	#JobSummary_tmp__Jobs J, JMJobDataStats S WITH (NOLOCK)
				WHERE	J.commCellId = S.commCellId AND J.jobId = S.jobId AND S.AuxCopyJobId = 0
				GROUP BY S.jobId, S.commCellId, S.archGrpCopyId) AS T1
		GROUP BY T1.jobId, T1.commCellId) AS T2
WHERE   #JobSummary_tmp__Jobs.jobId = T2.jobId AND #JobSummary_tmp__Jobs.commCellId = T2.commCellId AND (#JobSummary_tmp__Jobs.appTypeId <> 106 OR (#JobSummary_tmp__Jobs.appTypeId = 106 AND #JobSummary_tmp__Jobs.backupLevel = 64))
UPDATE  #JobSummary_tmp__Jobs
SET     mediaSize = JO.attributeValueInt,
        dedupeSavings = CASE WHEN opType = 60 OR jobStatus NOT IN (1, 2, 3) THEN -1
                                WHEN appSize > JO.attributeValueInt THEN ROUND(100.0*(appSize - JO.attributeValueInt)/appSize, 2)
                                ELSE 0 END
	FROM    JMJobOptions JO
	WHERE JO.jobId = #JobSummary_tmp__Jobs.jobId AND JO.commCellId = #JobSummary_tmp__Jobs.commCellId AND JO.attributeId = 73 AND (#JobSummary_tmp__Jobs.appTypeId = 106 AND #JobSummary_tmp__Jobs.backupLevel<>64) AND appSize > 0
IF	@IncludeBackupCopyJobs = 1
BEGIN
	IF OBJECT_ID('tempdb.dbo.#BackupCopyJob') IS NOT null DROP TABLE #BackupCopyJob
	CREATE TABLE #BackupCopyJob (jobId INT, snapJobId INT, commCellId INT)
	INSERT	INTO #BackupCopyJob
	SELECT	B.jobId, B.jobIdActedOn, B.commCellId
	FROM	#JobSummary_tmp__Jobs J
			INNER JOIN JMBkpStats B WITH (NOLOCK) ON J.jobId = B.jobId AND J.commCellId = B.commCellId
	WHERE	B.opType = 60
	UPDATE	J
	SET		mediaSize = T.sizeOnMedia,
			dedupeSavings = CASE WHEN appSize > T.sizeOnMedia THEN ROUND(100.0*(appSize - T.sizeOnMedia)/appSize, 2) ELSE 0 END
	FROM	#JobSummary_tmp__Jobs J
			INNER JOIN (
				SELECT	BC.jobId, BC.commCellId, SUM(S.sizeOnMedia) AS sizeOnMedia
				FROM	JMJobDataStats S WITH (NOLOCK)
						INNER JOIN #BackupCopyJob BC ON S.commCellId = BC.commCellId and S.jobid = BC.snapJobId
						INNER JOIN archGroup AG WITH (NOLOCK) ON S.archGrpId = AG.id AND S.archGrpCopyId = AG.defaultCopy
				GROUP BY BC.jobId, BC.commCellId
			) T ON J.jobId = T.jobId AND J.commCellId = T.commCellId
END
-- running backup jobs
UPDATE  #JobSummary_tmp__Jobs
SET     mediaSize = T2.sizeOnMedia,
		dedupeSavings = CASE WHEN appSize > T2.sizeOnMedia THEN ROUND(100.0*(appSize - T2.sizeOnMedia)/appSize, 2) ELSE 0 END
FROM	(SELECT AF.jobId, AF.commCellId, SUM(ACM.dedupedSize) AS sizeOnMedia
		FROM #JobSummary_tmp__Jobs J
			INNER JOIN archFile AF WITH (NOLOCK) ON AF.jobId = J.jobId AND AF.commCellId = J.commCellId AND AF.isValid = 1 AND J.jobStatus IN (6, 7) AND J.mediaSize = 0
			INNER JOIN archGroup AG WITH (NOLOCK) ON AG.id = AF.archGroupId
			INNER JOIN archChunkMapping ACM WITH (NOLOCK) ON ACM.archFileId = AF.id AND ACM.commCellId = AF.commCellId AND ACM.archCopyId = AG.defaultCopy
		GROUP BY AF.jobId, AF.commCellId) AS T2
WHERE   #JobSummary_tmp__Jobs.jobId = T2.jobId AND #JobSummary_tmp__Jobs.commCellId = T2.commCellId
UPDATE  J SET storagePolicyName = AG.name
FROM	#JobSummary_tmp__Jobs J INNER JOIN archGroup AG WITH (NOLOCK) ON J.dataArchGrpId = AG.id AND J.dataArchGrpId > 0
UPDATE  J SET storagePolicyName = (CASE WHEN J.dataArchGrpId>0 THEN storagePolicyName+', ' ELSE '' END) + AG.name
FROM	#JobSummary_tmp__Jobs J INNER JOIN archGroup AG WITH (NOLOCK) ON J.logArchGrpId = AG.id WHERE J.dataArchGrpId != J.logArchGrpId and J.logArchGrpId > 0
UPDATE  B1 SET protectedObjects = V1.passedVMs, failedObjects = V1.failedVMs
FROM    #JobSummary_tmp__Jobs B1
		INNER JOIN (
			SELECT	sum(case when attrval in (0,3) then 1 else 0 end) AS passedVMs,
					sum(case when attrval = 1 then 1 else 0 end) AS failedVMs,
					jobId, commcellId
			FROM	APP_VMProp WITH (READUNCOMMITTED)
			WHERE	attrName = 'vmStatus'
			GROUP BY jobId, commcellId
		) AS V1 ON B1.jobId = V1.jobId AND B1.commCellId = V1.commcellId
UPDATE	#JobSummary_tmp__Jobs
SET		JobThroughputinGBHour = (appSize*1.0/JobWriteTime+1)*3600.0/(1024*1024*1024)
WHERE	appSize>0 AND JobWriteTime > 0
UPDATE	#JobSummary_tmp__Jobs
SET		failureReasonMsg = LEFT(dbo.NormalizeForXML(dbo.JMGetLocalizedMessageMaxFunc(@localeId, failureReason)), 1024)
WHERE	jobStatus <> 1 AND failureReason <> ''
-- filter out jobs based on passed filter
IF @reportFilter IS NOT NULL AND LEN( CAST(@reportFilter AS NVARCHAR(MAX)))> 0
BEGIN
    DECLARE @filterType  INT = NULL
    DECLARE @filterValue INT = NULL
    INSERT INTO #JobSummary_tmp__FilterList
       	SELECT
	x.value('(@order)[1]','INT') AS filterOrder,
	x.value('(@entityType)[1]','INT') AS filterType,
	x.value('(@entityId)[1]','INT') AS filterValue,
	x.value('(@entityName)[1]','NVARCHAR(255)') AS filterName
	FROM @reportFilter.nodes('/reportFilter/filters') as XMLtbl(x)
	CREATE CLUSTERED INDEX #JobSummary_tmp__FilterList_IDX_filterOrder ON #JobSummary_tmp__FilterList (filterOrder)
    DECLARE @filterOrder INT = (SELECT MIN(filterOrder) FROM #JobSummary_tmp__FilterList)
	-- For drilldown from pie chart
    WHILE @filterOrder IS NOT NULL AND @filterOrder <> -1
	BEGIN
        SELECT  @filterType = filterType, @filterValue = filterValue
        FROM    #JobSummary_tmp__FilterList
        WHERE   filterOrder = @filterOrder
        IF @filterValue <> - 1
		BEGIN
            IF @filterType = 0  -- CommCell
                DELETE  FROM #JobSummary_tmp__Jobs
                WHERE   commCellId <> @filterValue
            ELSE IF @filterType = 1  -- Client
                DELETE  FROM #JobSummary_tmp__Jobs
                WHERE   clientId <> @filterValue
            ELSE IF @filterType = 2  -- Agent
			BEGIN
                DELETE  FROM #JobSummary_tmp__Jobs
                WHERE   appTypeId <> @filterValue
				IF @filterValue = 106
					SET @onlyVSAJobs = 1
			END
            ELSE IF @filterType = 3  -- Storage
				BEGIN
					DELETE  FROM #JobSummary_tmp__Jobs
					WHERE   dataArchGrpId <> @filterValue AND logArchGrpId <> @filterValue
				END
            ELSE IF @filterType = 4  -- ClientGroup
				DELETE  FROM #JobSummary_tmp__Jobs
                WHERE   clientId NOT IN (SELECT  clientId
                                         FROM    APP_ClientGroupAssoc WITH (NOLOCK)
                                         WHERE   clientGroupId = @filterValue )
            ELSE IF @filterType = 5  -- JobStatus
                DELETE  FROM #JobSummary_tmp__Jobs
                WHERE   jobStatus <> @filterValue
        END
        -- next filter
        SELECT @filterOrder = MIN(filterOrder) FROM #JobSummary_tmp__FilterList WHERE filterOrder > @filterOrder
    END
END
SET @maxTimeStamp = NULL
SELECT @maxTimeStamp =  MAX(unpvt.dTime) FROM #JobSummary_tmp__Jobs unpivot (dTime FOR nTime in (startTime,endTime)) as unpvt;
IF ( @maxTimeStamp <> NULL AND @maxTimeStamp < @lastUpdateTime )
BEGIN
	SET @sendSummary = 0
END
-- Show Job Details per VM
IF @onlyVSAJobs = 1
BEGIN
	-- For IndexingV2 VSA child jobs
	UPDATE	J SET vmClientName = J.clientName, vmStatus = J.jobStatusName
	FROM	#JobSummary_tmp__Jobs J
			LEFT OUTER JOIN #VSA_AppIDs VSA ON J.subclientId = VSA.appId
	WHERE	J.appTypeId = 106 AND VSA.appId IS NULL
	CREATE	TABLE #VMJobs (jobId INT, commCellId INT, VMclientId INT, vmStatus INT, vmBkpLevel INT, jobMediaSize BIGINT,
			dataRead BIGINT, dataWritten BIGINT, dedupeSavings FLOAT, vmFailureReason NVARCHAR(1024))
	CREATE	TABLE #VMSize (jobId INT, commCellId INT, VMclientId INT, dataRead BIGINT)
	INSERT	#VMJobs
	SELECT	V.jobId, V.commCellId, V.VMclientId, CAST(V.attrVal AS INT), J.backupLevel, J.mediaSize, 0, 0, 0, ''
	FROM	APP_VMProp V WITH (NOLOCK)
			INNER JOIN #JobSummary_tmp__Jobs J ON V.jobId = J.jobId AND V.commCellId = J.commCellId AND V.attrName = 'vmStatus'
			INNER JOIN #VSA_AppIDs VSA ON J.subclientId = VSA.appId AND VSA.isIndexingV2 = 0
	UPDATE	J SET vmBkpLevel = 1
	FROM	#VMJobs J
			INNER JOIN APP_VMProp V WITH (NOLOCK)
				ON V.jobId = J.jobId AND V.commCellId = J.commCellId AND V.VMclientId = J.VMclientId AND J.vmBkpLevel > 1
				AND V.attrName = 'vmBkpLevel' AND V.attrVal = '1'
	INSERT	INTO #VMSize
	SELECT	P.jobId, P.commCellId, P.VMclientId,
			ISNULL([vmUsedSpace], [vmGuestSize]) AS dataRead
	FROM	(SELECT	J.jobId, J.commCellId, J.VMclientId, V.attrName, CAST(V.attrVal AS BIGINT) AS size
			FROM	APP_VMProp V WITH (NOLOCK)
					INNER JOIN #VMJobs J
						ON V.jobId = J.jobId AND V.commCellId = J.commCellId AND V.VMclientId = J.VMclientId
						AND V.attrName IN ('vmUsedSpace', 'vmGuestSize')) S
			PIVOT (MAX(size) FOR attrName IN ([vmUsedSpace], [vmGuestSize])) AS P
	UPDATE	#VMJobs
	SET		dataRead = S.dataRead,
			dataWritten = CASE WHEN T.dataRead > 0 THEN (1.0*S.dataRead/T.dataRead)*V.jobMediaSize ELSE 0 END,
			dedupeSavings = CASE WHEN S.dataRead > 0 AND T.dataRead > V.jobMediaSize THEN ROUND(100.0*(T.dataRead - V.jobMediaSize)/T.dataRead, 2) ELSE 0 END
	FROM	#VMJobs V
			INNER JOIN #VMSize S ON V.jobId = S.jobId AND V.commCellId = S.commCellId AND V.VMclientId = S.VMclientId
			INNER JOIN (SELECT	jobId, commCellId, SUM(dataRead) AS dataRead
						FROM	#VMSize
						GROUP BY jobId, commCellId) T ON T.jobId = S.jobId AND T.commCellId = S.commCellId
	UPDATE	#VMJobs
	SET		vmFailureReason = V.attrVal
	FROM	#VMJobs J
			INNER JOIN (SELECT jobId, commCellId, VMclientId FROM #VMJobs WHERE vmStatus <> 0) S
				ON J.jobId = S.jobId AND J.commCellId = S.commCellId AND J.VMclientId = S.VMclientId
			INNER JOIN APP_VMProp V WITH (NOLOCK)
				ON V.jobId = S.jobId AND V.commCellId = S.commCellId AND V.VMclientId = S.VMclientId AND V.attrName = 'vmFailureReason'
	INSERT INTO #JobSummary_tmp__Jobs(
			jobId, commCellId, commCellName,
			clientGroup, clientId, clientName, appTypeId, appTypeName,
			instanceId, instanceName, backupsetId, backupsetName, subclientId, subclientName,
			opType, operationName, backupLevel, backupTypeName,
			dataArchGrpId, logArchGrpId, storagePolicyName, mediaAgent, startTime, startTimeDT, endTime, endTimeDT,
			appSize, mediaSize, nwTransBytes, dedupeSavings, protectedObjects, failedObjects, failedFolders,
			userName, jobStatus, jobStatusName, failureReason, failureReasonMsg, failureReasons, vmClientName, vmStatus,JobWriteTime,JobThroughputinGBHour,isProtectVM,ParentJobid)
	SELECT	DISTINCT J.jobId, J.commCellId, J.commCellName,
			'', J.clientId, J.clientName, J.appTypeId, J.appTypeName,
			J.instanceId, J.instanceName, J.backupsetId, J.backupsetName, J.subclientId, J.subclientName,
			opType, operationName, V.vmBkpLevel, CASE WHEN V.vmBkpLevel = 1 THEN @FullBackupName ELSE J.backupTypeName END,
			J.dataArchGrpId, J.logArchGrpId, J.storagePolicyName, J.mediaAgent, J.startTime, J.startTimeDT, J.endTime, J.endTimeDT,
			V.dataRead, V.dataWritten, J.nwTransBytes, V.dedupeSavings,
			CASE WHEN V.vmStatus = 0 THEN 1 ELSE 0 END, CASE WHEN V.vmStatus = 0 THEN 0 ELSE 1 END, 0,
			J.userName, J.jobStatus, J.jobStatusName, '',
			CASE WHEN V.vmFailureReason = '' THEN J.failureReasonMsg ELSE V.vmFailureReason END, '', case when ISNULL(C.displayName, '') = '' then C.name else C.displayName end,
			CASE V.vmStatus WHEN 0 THEN @CompletedStatus WHEN 1 THEN @FailedStatus WHEN 3 THEN @CWEStatus
							ELSE (CASE WHEN J.jobStatus IN (1,2,3) THEN @FailedStatus ELSE J.jobStatusName END) END,
			0,J.JobThroughputinGBHour ,j.isProtectVM,j.ParentJobid
	FROM	#JobSummary_tmp__Jobs J
			INNER JOIN #VMJobs V ON J.jobId = V.jobId AND J.commCellId = V.commCellId  AND J.parentjobid<1
			INNER JOIN APP_Client C WITH (NOLOCK) ON C.id = V.VMClientId
	UNION
	SELECT	DISTINCT J.jobId, J.commCellId, J.commCellName,
			'', J.clientId, J.clientName, J.appTypeId, J.appTypeName,
			J.instanceId, J.instanceName, J.backupsetId, J.backupsetName, J.subclientId, J.subclientName,
			opType, operationName, V.vmBkpLevel, CASE WHEN V.vmBkpLevel = 1 THEN @FullBackupName ELSE J.backupTypeName END,
			J.dataArchGrpId, J.logArchGrpId, J.storagePolicyName, J.mediaAgent, J.startTime, J.startTimeDT, J.endTime, J.endTimeDT,
			V.dataRead, V.dataWritten, J.nwTransBytes, V.dedupeSavings,
			CASE WHEN V.vmStatus = 0 THEN 1 ELSE 0 END, CASE WHEN V.vmStatus = 0 THEN 0 ELSE 1 END, 0,
			J.userName, J.jobStatus, J.jobStatusName, '',
			CASE WHEN V.vmFailureReason = '' THEN J.failureReasonMsg ELSE V.vmFailureReason END, '', case when ISNULL(C.displayName, '') = '' then C.name else C.displayName end,
			CASE V.vmStatus WHEN 0 THEN @CompletedStatus WHEN 1 THEN @FailedStatus WHEN 3 THEN @CWEStatus
							ELSE (CASE WHEN J.jobStatus IN (1,2,3) THEN @FailedStatus ELSE J.jobStatusName END) END,
			0,J.JobThroughputinGBHour ,j.isProtectVM,j.ParentJobid
	FROM	#JobSummary_tmp__Jobs J
			INNER JOIN #VMJobs V ON V.jobId = J.ParentJobid and J.parentjobid>1 AND J.commCellId = V.commCellId  and v.VMclientId =  j.clientId
			INNER JOIN APP_Client C WITH (NOLOCK) ON C.id = V.VMClientId
			INNER JOIN APP_ClientProp Cprop WITH (NOLOCK) ON Cprop.componentNameId = V.VMclientId
					    and Cprop.attrName ='IndexingV2_VSA' and Cprop.modified = 0 and Cprop.attrval = 1
	UPDATE J
	    SET J.mediaSize = OJ.mediaSize, J.dedupeSavings = OJ.dedupeSavings
	    FROM #JobSummary_tmp__Jobs J
	    INNER JOIN #JobSummary_tmp__Jobs OJ ON OJ.jobId = J.jobId AND OJ.commCellId = J.commCellId
	    WHERE OJ.appTypeId = 106 AND OJ.vmClientName = ''
	DELETE	J
	FROM	#JobSummary_tmp__Jobs J
			INNER JOIN #VSA_AppIDs VSA ON J.subclientId = VSA.appId AND VSA.isIndexingV2 = 0
	WHERE	J.vmClientName = ''
	DROP TABLE #VMJobs
	DROP TABLE #VMSize
END
DELETE  T
FROM    #JobSummary_tmp__Jobs T
		INNER JOIN #JobSummary_tmp__Jobs X
		ON T.jobId = X.ParentJobid AND X.ParentJobid>0
IF OBJECT_ID('tempdb..#VSADiscoveredClient') IS NOT NULL DROP TABLE #VSADiscoveredClient
CREATE TABLE #VSADiscoveredClient (clientId INT, PRIMARY KEY(clientId))
INSERT INTO #VSADiscoveredClient
SELECT DISTINCT componentNameId
from   app_clientprop(nolock) C
where  C.attrName = 'VSA Discover Subclient ID' and attrVal <> N'0' and modified = 0
UPDATE T
SET    T.virtualizationClient = C.displayName,
		T.subclientName = A.subclientName,
		T.backupsetName = Bs.name
FROM   JMJobDataLink (nolock) J
		INNER JOIN  #JobSummary_tmp__Jobs T ON T.ParentJobid = J.ParentJobid
		INNER JOIN app_application(nolock) A ON  j.parentappid= a.id
		INNER JOIN App_BackupSetName BS WITH (NOLOCK)  ON A.backupSet = BS.Id
		INNER JOIN app_client(nolock) C ON a.clientid= c.id
WHERE T.ParentJobid>0
UPDATE T
SET    T.virtualizationClient = C1.displayName
FROM   #VSADiscoveredClient V
		INNER JOIN app_client(nolock) C1 ON V.clientid= c1.id
		INNER JOIN #JobSummary_tmp__Jobs T ON T.clientId= C1.id
		LEFT OUTER JOIN JMJobDataLink (nolock) J ON T.ParentJobid = J.ParentJobid
WHERE J.parentJobId IS NULL
IF OBJECT_ID('tempdb..#VSADiscoveredClient') IS NOT NULL DROP TABLE #VSADiscoveredClient
IF @archiveJobs = 0
BEGIN
	--Remove turbo jobs
    DELETE  T
	FROM    #JobSummary_tmp__Jobs T
			INNER JOIN JMBkpStats B ON T.jobId = B.jobId AND T.commCellId = B.commCellId
			INNER JOIN JMJobStats J ON B.jobId = J.jobId AND B.commCellId = J.commCellId
	WHERE	(B.appType IN (45,67,68,57,58,66,73,82,83,56,89,90) OR J.subOptype = 98 OR J.opType = 109)
			AND B.opType <> 60 AND (B.opType <> 59 OR J.subOpType <> 96)
	DELETE  T
	FROM    #JobSummary_tmp__Jobs T
			INNER JOIN APP_SubClientProp S
		 ON T.subclientId = S.componentNameId AND S.attrName = 'Is Turbo Subclient' AND S.attrVal = '1' AND S.modified = 0
	WHERE	T.appTypeId = 106
END
ELSE
IF @backupJobs = 0
BEGIN
	--Remove non-turbo jobs
	DELETE  T
	FROM    #JobSummary_tmp__Jobs T
			LEFT OUTER JOIN (
			SELECT	B.jobId, B.commCellId
			FROM	#JobSummary_tmp__Jobs X
					INNER JOIN JMBkpStats B ON X.jobId = B.jobId AND X.commCellId = B.commCellId
					INNER JOIN JMJobStats J ON B.jobId = J.jobId AND B.commCellId = J.commCellId
			WHERE	(B.appType IN (45,67,68,57,58,66,73,82,83,56,89,90) OR J.subOptype = 98 OR J.opType = 109)
					AND B.opType <> 60 AND (B.opType <> 59 OR J.subOpType <> 96)
			) S ON T.jobId = S.jobId AND T.commCellId = S.commCellId
	WHERE S.jobId IS NULL
	DELETE  T
	FROM    #JobSummary_tmp__Jobs T
			LEFT OUTER JOIN APP_SubClientProp S
		 ON T.subclientId = S.componentNameId AND S.attrName = 'Is Turbo Subclient' AND S.attrVal = '1' AND S.modified = 0
	WHERE	T.appTypeId = 106 AND S.componentNameId IS NULL
	UPDATE  #JobSummary_tmp__Jobs SET operationName = 'Archive'
END
ELSE
BEGIN
	UPDATE  T SET operationName = 'Archive'
	FROM    #JobSummary_tmp__Jobs T
			INNER JOIN JMBkpStats B ON T.jobId = B.jobId AND T.commCellId = B.commCellId
			INNER JOIN JMJobStats J ON B.jobId = J.jobId AND B.commCellId = J.commCellId
	WHERE	(B.appType IN (45,67,68,57,58,66,73,82,83,56,89,90) OR J.subOptype = 98 OR J.opType = 109)
			AND B.opType <> 60 AND (B.opType <> 59 OR J.subOpType <> 96)
	UPDATE  T SET operationName = 'Archive'
	FROM    #JobSummary_tmp__Jobs T
			INNER JOIN APP_SubClientProp S
		 ON T.subclientId = S.componentNameId AND S.attrName = 'Is Turbo Subclient' AND S.attrVal = '1' AND S.modified = 0
	WHERE	T.appTypeId = 106
END
-- Apply Storage Policy filter and MediaAgent filter
IF @includeAllStoragePolicies = 0
BEGIN
	DELETE	J FROM #JobSummary_tmp__Jobs J
			LEFT OUTER JOIN #JobSummary_tmp__StoragePolicy SP ON SP.id in (J.dataArchGrpId, J.logArchGrpId) AND (J.dataArchGrpId > 0 OR J.logArchGrpId > 0)
	WHERE   SP.id IS NULL
END
ELSE IF @userId > 0 AND @isUserAdmin = 0
BEGIN
	UPDATE	J SET storagePolicyName = 'Not_visible_by_user'
	FROM	#JobSummary_tmp__Jobs J
			LEFT OUTER JOIN #JobSummary_tmp__StoragePolicy SP ON SP.id in (J.dataArchGrpId, J.logArchGrpId)
	WHERE   (J.dataArchGrpId > 1 OR J.logArchGrpId > 1) AND SP.id IS NULL
END
-- Get mediaAgent
CREATE TABLE #JobMediaAgents (jobId INT, commCellId INT, mediaAgentId INT, mediaAgentName NVARCHAR(256))
INSERT	INTO #JobMediaAgents
SELECT	DISTINCT JR.jobId, JR.commCellId, JR.ClientId, CL.displayName
FROM	JMJobResourceHistory JR
		INNER JOIN #JobSummary_tmp__Jobs J ON JR.jobId = J.jobId AND JR.commCellId = J.commCellId
		INNER JOIN APP_Client CL ON JR.ClientId = CL.id
		INNER JOIN archGroup AG ON JR.copyId IN (AG.defaultCopy, AG.defaultSnapCopy)
ORDER BY JR.jobId, JR.commCellId, CL.displayName
INSERT	INTO #JobMediaAgents
SELECT	DISTINCT T.jobId, T.commCellId, CL.id, CL.displayName
FROM	(SELECT	J.jobId, J.commCellId, J.dataArchGrpId, J.logArchGrpId
		FROM	#JobSummary_tmp__Jobs J
				LEFT OUTER JOIN #JobMediaAgents M ON J.jobId = M.jobId AND J.commCellId = M.commCellId
		WHERE	M.jobId IS NULL
		) T
		INNER JOIN archGroup AG ON T.dataArchGrpId = AG.id OR T.logArchGrpId = AG.id
		INNER JOIN MMDataPath DP ON DP.CopyId IN (AG.defaultCopy, AG.defaultSnapCopy) AND DP.Flag&1 = 1
		INNER JOIN APP_Client CL ON DP.HostClientId = CL.id
ORDER BY T.jobId, T.commCellId, CL.displayName
IF  @includeAllMediaAgents = 1 AND @userId > 0 AND @isUserAdmin = 0
BEGIN
	UPDATE	J SET mediaAgentName = 'Not_visible_by_user'
	FROM	#JobMediaAgents J
			LEFT OUTER JOIN #JobSummary_tmp__MediaAgent MA ON J.mediaAgentId = MA.id
	WHERE   MA.id IS NULL
END
CREATE TABLE #JobMAList (jobId INT, commCellId INT, maList NVARCHAR(MAX))
INSERT	#JobMAList
SELECT	jobId, commCellId,
		STUFF((SELECT ','+[mediaAgentName] FROM #JobMediaAgents WHERE jobId = t.jobId FOR XML PATH('')), 1, 1, '')
FROM	(SELECT DISTINCT jobId, commCellId FROM #JobMediaAgents) t
CREATE INDEX #JobMAList_jobId_commCellId_idx ON #JobMAList (jobId, commCellId)
UPDATE J SET mediaAgent = MA.maList
FROM	#JobSummary_tmp__Jobs J
		INNER JOIN #JobMAList MA ON J.jobId = MA.jobId AND J.commCellId = MA.commCellId
DROP TABLE #JobMAList
IF  @includeAllMediaAgents = 0
BEGIN
	DELETE	J FROM #JobMediaAgents J
			LEFT OUTER JOIN #JobSummary_tmp__MediaAgent MA ON J.mediaAgentId = MA.id
	WHERE   MA.id IS NULL
	DELETE J FROM #JobSummary_tmp__Jobs J
			LEFT OUTER JOIN #JobMediaAgents MA ON J.jobId = MA.jobId AND J.commCellId = MA.commCellId
	WHERE   MA.jobId IS NULL
END
DROP TABLE #JobMediaAgents
IF	@lastJobOfEachSubclientOnly = 1
BEGIN
	IF OBJECT_ID('tempdb.dbo.#LastJob') IS NOT null DROP TABLE #LastJob
	CREATE TABLE #LastJob (subclientId INT, jobId INT)
	INSERT	INTO #LastJob
	SELECT	subclientId, MAX(jobId)
	FROM	#JobSummary_tmp__Jobs
	GROUP BY subclientId
	DELETE	J
	FROM	#JobSummary_tmp__Jobs J
			INNER JOIN #LastJob L ON J.subclientId = L.subclientId
	WHERE	J.jobId <> L.jobId
END
-- Make startTime and endTime as local time
UPDATE #JobSummary_tmp__Jobs
SET startTime = DATEDIFF(SS, '1970-01-01', startTimeDT), endTime = CASE WHEN endTimeDT IS NULL THEN -1 ELSE DATEDIFF(SS, '1970-01-01', endTimeDT) END
IF OBJECT_ID('tempdb.dbo.#ClientGroupsString') IS NOT null DROP TABLE #ClientGroupsString
CREATE TABLE #ClientGroupsString (clientId INT, clientGroups NVARCHAR(MAX))
INSERT	INTO #ClientGroupsString
SELECT	DISTINCT clientId, N''
FROM	#JobSummary_tmp__Jobs
CREATE INDEX #ClientGroupsString_clientId_idx ON #ClientGroupsString (clientId)
EXEC GetClientGroupsString
UPDATE	J SET clientGroup = CGS.clientGroups
FROM    #JobSummary_tmp__Jobs J
		INNER JOIN #ClientGroupsString CGS ON J.clientId = CGS.clientId
IF ( @jobsOnlyRequest = 0 AND @sendSummary = 1 )
BEGIN
    IF @groupBy = 0
	BEGIN -- aggregation by commcell
        INSERT	INTO #JobSummary_tmp__JobListAggr
        SELECT  J.commCellId, '', 0,
                -- totalJobs               INT             NOT NULL,
                COUNT(DISTINCT J.jobId),
                -- totalAppSize            BIGINT          NOT NULL,
                SUM(ISNULL(J.appSize, 0)),
                -- totalDataWritten        BIGINT          NOT NULL,
                SUM(ISNULL(J.mediaSize, 0)),
                -- totalProtectedObjects   BIGINT          NOT NULL,
                SUM(ISNULL(J.protectedObjects, 0)),
                -- totalFailedObjects      BIGINT          NOT NULL,
                SUM(ISNULL(J.failedObjects, 0)),
                -- totalFailedFolders      BIGINT          NOT NULL
                SUM(ISNULL(J.failedFolders, 0))
        FROM    #JobSummary_tmp__Jobs J
		WHERE   J.commCellId <> 0
        GROUP   BY J.commCellId
		UPDATE  #JobSummary_tmp__JobListAggr
        SET     entityName = ISNULL((SELECT aliasName FROM APP_CommCell WITH (NOLOCK) WHERE id = entityId), '')
    END
    ELSE
	IF @groupBy = 1
	BEGIN -- aggregation by client
        INSERT	INTO #JobSummary_tmp__JobListAggr
        SELECT  J.clientId, '', 0,
                -- totalJobs               INT             NOT NULL,
                COUNT(DISTINCT J.jobId),
                -- totalAppSize            BIGINT          NOT NULL,
                SUM(ISNULL(J.appSize, 0)),
                -- totalDataWritten        BIGINT          NOT NULL,
                SUM(ISNULL(J.mediaSize, 0)),
                -- totalProtectedObjects   BIGINT          NOT NULL,
                SUM(ISNULL(J.protectedObjects, 0)),
                -- totalFailedObjects      BIGINT          NOT NULL,
                SUM(ISNULL(J.failedObjects, 0)),
                -- totalFailedFolders      BIGINT          NOT NULL
                SUM(ISNULL(J.failedFolders, 0))
        FROM    #JobSummary_tmp__Jobs J
		WHERE   J.clientId <> 0
        GROUP   BY J.clientId
		UPDATE  #JobSummary_tmp__JobListAggr
        SET     entityName = ISNULL((SELECT name FROM APP_Client WITH (NOLOCK) WHERE id = entityId), ''),
                deleted =    ISNULL((SELECT CASE WHEN (status & 0x2) <> 0 OR (status & 0x4) <> 0 THEN 1 ELSE 0 END
                                     FROM   APP_Client
                                     WHERE  id = entityId), 1)
    END
    ELSE
	IF @groupBy = 2
	BEGIN -- aggregation by app type
        INSERT INTO #JobSummary_tmp__JobListAggr
        SELECT  J.appTypeId, '', 0,
                -- totalJobs               INT             NOT NULL,
                COUNT(DISTINCT J.JobId),
                -- totalAppSize            BIGINT          NOT NULL,
                SUM(ISNULL(J.appSize, 0)),
                -- totalDataWritten        BIGINT          NOT NULL,
                SUM(ISNULL(J.mediaSize, 0)),
                -- totalProtectedObjects   BIGINT          NOT NULL,
                SUM(ISNULL(J.protectedObjects, 0)),
                -- totalFailedObjects      BIGINT          NOT NULL,
                SUM(ISNULL(J.failedObjects, 0)),
                -- totalFailedFolders      BIGINT          NOT NULL
                SUM(ISNULL(J.failedFolders, 0))
        FROM    #JobSummary_tmp__Jobs J
		WHERE   J.appTypeId <> 0
        GROUP   BY J.appTypeId
		UPDATE  #JobSummary_tmp__JobListAggr
        SET     entityName = ISNULL((SELECT name FROM APP_iDAType WITH (NOLOCK) WHERE [type] = entityId), '')
    END
    ELSE IF @groupBy = 3
	BEGIN -- aggregation by Storage
        INSERT	INTO #JobSummary_tmp__JobListAggr
		SELECT DISTINCT StoragePolicy, '', 0, 0, 0, 0, 0, 0, 0 FROM (
			SELECT	DISTINCT dataArchGrpId AS StoragePolicy FROM #JobSummary_tmp__Jobs Where dataArchGrpId > 0
		UNION
			SELECT	DISTINCT logArchGrpId AS StoragePolicy FROM #JobSummary_tmp__Jobs Where logArchGrpId > 0
		) sub
        UPDATE  #JobSummary_tmp__JobListAggr
        SET     entityName				= ISNULL((SELECT name FROM archGroup WITH (NOLOCK) WHERE id = entityId), ''),
                -- totalJobs               INT             NOT NULL,
                totalJobs				= S.totalJobs,
                -- totalAppSize            BIGINT          NOT NULL,
                totalAppSize			= S.totalAppSize,
                -- totalDataWritten        BIGINT          NOT NULL,
                totalDataWritten		= S.totalDataWritten,
                -- totalProtectedObjects   BIGINT          NOT NULL,
                totalProtectedObjects	= S.totalProtectedObjects,
                -- totalFailedObjects      BIGINT          NOT NULL,
                totalFailedObjects		= S.totalFailedObjects,
                -- totalFailedFolders      BIGINT          NOT NULL
                totalFailedFolders		= S.totalFailedFolders
		FROM	(SELECT	dataArchGrpId,
						COUNT(DISTINCT jobId) AS totalJobs,
						SUM(appSize) AS totalAppSize,
						SUM(mediaSize) AS totalDataWritten,
						SUM(protectedObjects) AS totalProtectedObjects,
						SUM(failedObjects) AS totalFailedObjects,
						SUM(failedFolders ) AS totalFailedFolders
				FROM	#JobSummary_tmp__Jobs
				GROUP BY dataArchGrpId) S
		WHERE	#JobSummary_tmp__JobListAggr.entityId = S.dataArchGrpId
		UPDATE  #JobSummary_tmp__JobListAggr
        SET     entityName				= ISNULL((SELECT name FROM archGroup WITH (NOLOCK) WHERE id = entityId), ''),
                -- totalJobs               INT             NOT NULL,
                totalJobs				= S.totalJobs,
                -- totalAppSize            BIGINT          NOT NULL,
                totalAppSize			= S.totalAppSize,
                -- totalDataWritten        BIGINT          NOT NULL,
                totalDataWritten		= S.totalDataWritten,
                -- totalProtectedObjects   BIGINT          NOT NULL,
                totalProtectedObjects	= S.totalProtectedObjects,
                -- totalFailedObjects      BIGINT          NOT NULL,
                totalFailedObjects		= S.totalFailedObjects,
                -- totalFailedFolders      BIGINT          NOT NULL
                totalFailedFolders		= S.totalFailedFolders
		FROM	(SELECT	logArchGrpId,
						COUNT(DISTINCT jobId) AS totalJobs,
						SUM(appSize) AS totalAppSize,
						SUM(mediaSize) AS totalDataWritten,
						SUM(protectedObjects) AS totalProtectedObjects,
						SUM(failedObjects) AS totalFailedObjects,
						SUM(failedFolders ) AS totalFailedFolders
				FROM	#JobSummary_tmp__Jobs
				WHERE logArchGrpId != dataArchGrpId
				GROUP BY logArchGrpId) S
		WHERE	#JobSummary_tmp__JobListAggr.entityId = S.logArchGrpId
    END
    ELSE
	IF @groupBy = 4
	BEGIN -- aggregation by ClientGroup
        INSERT	INTO #JobSummary_tmp__JobListAggr
        SELECT  DISTINCT CG.clientGroupId, '', 0, 0, 0, 0, 0, 0, 0
        FROM    APP_ClientGroupAssoc CG WITH (NOLOCK)
		WHERE   CG.clientId IN (SELECT clientId FROM #JobSummary_tmp__Jobs J)
	    UPDATE	#JobSummary_tmp__JobListAggr
        SET     entityName = (SELECT name FROM APP_ClientGroup WHERE id = entityId),
                -- totalJobs               INT             NOT NULL,
                totalJobs  = (SELECT COUNT(DISTINCT J.jobId) FROM #JobSummary_tmp__Jobs J WHERE J.clientId IN (SELECT clientId FROM APP_ClientGroupAssoc WITH (NOLOCK) WHERE clientGroupId = entityId)),
                -- totalAppSize            BIGINT          NOT NULL,
                totalAppSize  =  ISNULL((SELECT SUM(ISNULL(J.appSize, 0)) FROM #JobSummary_tmp__Jobs J WHERE J.clientId IN (SELECT clientId FROM APP_ClientGroupAssoc WITH (NOLOCK) WHERE clientGroupId = entityId)), 0),
                -- totalDataWritten        BIGINT          NOT NULL,
                totalDataWritten =  ISNULL((SELECT SUM(ISNULL(J.mediaSize, 0)) FROM #JobSummary_tmp__Jobs J WHERE J.clientId IN (SELECT clientId FROM APP_ClientGroupAssoc WITH (NOLOCK) WHERE clientGroupId = entityId)), 0),
                -- totalProtectedObjects   BIGINT          NOT NULL,
                totalProtectedObjects = ISNULL((SELECT SUM(ISNULL(J.protectedObjects, 0)) FROM #JobSummary_tmp__Jobs J WHERE J.clientId IN (SELECT clientId FROM APP_ClientGroupAssoc WITH (NOLOCK) WHERE clientGroupId = entityId)), 0),
                -- totalFailedObjects      BIGINT          NOT NULL,
                totalFailedObjects = ISNULL((SELECT SUM(ISNULL(J.failedObjects, 0)) FROM #JobSummary_tmp__Jobs J WHERE J.clientId IN (SELECT clientId FROM APP_ClientGroupAssoc WITH (NOLOCK) WHERE clientGroupId = entityId)), 0),
                -- totalFailedFolders      BIGINT          NOT null
                totalFailedFolders = ISNULL((SELECT SUM(ISNULL(J.failedFolders, 0)) FROM #JobSummary_tmp__Jobs J WHERE J.clientId IN (SELECT clientId FROM APP_ClientGroupAssoc WITH (NOLOCK) WHERE clientGroupId = entityId)), 0)
		DELETE	#JobSummary_tmp__JobListAggr
		WHERE   totalJobs = 0
    END
    ELSE
	IF @groupBy = 5
	BEGIN -- aggregation by Job Status
        INSERT	INTO #JobSummary_tmp__JobListAggr
        SELECT  J.jobStatus, '', 0,
                -- totalJobs               INT             NOT NULL,
                COUNT(DISTINCT J.jobId),
                -- totalAppSize            BIGINT          NOT NULL,
                SUM(ISNULL(J.appSize, 0)),
                -- totalDataWritten        BIGINT          NOT NULL,
                SUM(ISNULL(J.mediaSize, 0)),
                -- totalProtectedObjects   BIGINT          NOT NULL,
                SUM(ISNULL(J.protectedObjects, 0)),
                -- totalFailedObjects      BIGINT          NOT NULL,
                SUM(ISNULL(J.failedObjects, 0)),
                -- totalFailedFolders      BIGINT          NOT NULL
                SUM(ISNULL(J.failedFolders, 0))
        FROM    #JobSummary_tmp__Jobs J
        GROUP   BY J.jobStatus
		UPDATE  A SET entityName = S.statusName
		FROM	#JobSummary_tmp__JobListAggr A
				INNER JOIN #JobSummary_tmp__JobStatus S ON A.entityId = S.status
    END
END
-- Apply filters on columns of Job Details tables
DECLARE	@l_columnName		NVARCHAR(128)
DECLARE	@l_filtervalue		NVARCHAR(1024)
DECLARE	@l_filterCondition	NVARCHAR(16)
DECLARE @l_likeStr			NVARCHAR(1024)
DECLARE @l_number			BIGINT = 0
DECLARE @l_upperLimit		BIGINT = 1
DECLARE @l_bytesOfUnit		BIGINT = 0
DECLARE @l_decimalSize		DECIMAL(20,2) = 0
DECLARE TableFilterCur CURSOR FOR
SELECT	columnName, REPLACE(filtervalue, '%', ''), filterCondition
FROM	@tblTableFilter
OPEN	TableFilterCur
FETCH	TableFilterCur INTO @l_columnName, @l_filtervalue, @l_filterCondition
WHILE   @@FETCH_STATUS = 0
BEGIN
	IF	@l_columnName IN ('appSize', 'mediaSize', 'networkSize') AND @l_filterCondition = 'LIKE'
	BEGIN
		IF	@l_filtervalue LIKE '%<=%'
			SET	@l_filterCondition = '<='
		ELSE
		IF	@l_filtervalue LIKE '%>=%'
			SET	@l_filterCondition = '>='
		ELSE
		IF	@l_filtervalue LIKE '%<%'
			SET	@l_filterCondition = '<'
		ELSE
		IF	@l_filtervalue LIKE '%>%'
			SET	@l_filterCondition = '>'
		ELSE
			SET	@l_filterCondition = '='
		SET @l_filtervalue = REPLACE(@l_filtervalue, @l_filterCondition, '')
		SET @l_filtervalue = LTRIM(@l_filtervalue)
		SET	@l_filtervalue = UPPER(@l_filtervalue)
		IF	@l_filtervalue LIKE '%TB%'
		BEGIN
			SET	@l_filtervalue	= RTRIM(REPLACE(@l_filtervalue, 'TB', ''))
			SET @l_bytesOfUnit	= CAST(1024 AS BIGINT)*1024*1024*1024
		END
		ELSE
		IF	@l_filtervalue LIKE '%GB%'
		BEGIN
			SET @l_filtervalue	= RTRIM(REPLACE(@l_filtervalue, 'GB', ''))
			SET @l_bytesOfUnit	= CAST(1024 AS BIGINT)*1024*1024
		END
		ELSE
		IF	@l_filtervalue LIKE '%MB%'
		BEGIN
			SET @l_filtervalue	= RTRIM(REPLACE(@l_filtervalue, 'MB', ''))
			SET @l_bytesOfUnit	= CAST(1024 AS BIGINT)*1024
		END
		ELSE
		IF	@l_filtervalue LIKE '%KB%'
		BEGIN
			SET @l_filtervalue	= RTRIM(REPLACE(@l_filtervalue, 'KB', ''))
			SET @l_bytesOfUnit	= CAST(1024 AS BIGINT)
		END
		ELSE
		BEGIN
			SET @l_filtervalue	= RTRIM(REPLACE(@l_filtervalue, 'BYTES', ''))
			SET @l_filtervalue	= RTRIM(REPLACE(@l_filtervalue, 'BYTE', ''))
			SET @l_bytesOfUnit	= 1
		END
		IF	ISNUMERIC(@l_filtervalue) <> 1
			SET @l_filterCondition = 'LIKE'
		ELSE
		IF	@l_bytesOfUnit = 1
			SET @l_number	= CAST(@l_filtervalue AS BIGINT)
		ELSE
		BEGIN
			SET @l_decimalSize	= CAST(@l_filtervalue AS DECIMAL(20,2))
			IF	@l_decimalSize	> 0
			BEGIN
				SET @l_number		= (@l_decimalSize - 0.01)*@l_bytesOfUnit + 1
				SET @l_upperLimit	= (@l_decimalSize + 0.01)*@l_bytesOfUnit
			END
		END
	END
	ELSE
	IF	@l_columnName = 'ParentJobid' AND UPPER(@l_filtervalue) = 'N/A'
		SET @l_filtervalue = '-1'
	ELSE
	IF	@l_columnName = 'isProtectVM'
	BEGIN
		IF	LOWER(@l_filtervalue) = 'yes'
			SET @l_filtervalue = '1'
		ELSE
			SET @l_filtervalue = '0'
	END
	SET	@l_likeStr = '%' + @l_filtervalue + '%'
	IF	@l_columnName = 'jobId'
	BEGIN
		IF @l_filterCondition = 'LIKE'
			DELETE	#JobSummary_tmp__Jobs WHERE CAST(jobId AS VARCHAR(10)) NOT LIKE @l_likeStr
		ELSE IF ISNUMERIC(@l_filtervalue) = 1
		BEGIN
			SET @l_number = CAST(@l_filtervalue AS BIGINT)
			IF @l_filterCondition = '='
				DELETE	#JobSummary_tmp__Jobs WHERE jobId <> @l_number
			ELSE IF @l_filterCondition = '>'
				DELETE	#JobSummary_tmp__Jobs WHERE jobId <= @l_number
			ELSE IF @l_filterCondition = '>='
				DELETE	#JobSummary_tmp__Jobs WHERE jobId <  @l_number
			ELSE IF @l_filterCondition = '<'
				DELETE	#JobSummary_tmp__Jobs WHERE jobId >= @l_number
			ELSE IF @l_filterCondition = '<='
				DELETE	#JobSummary_tmp__Jobs WHERE jobId >  @l_number
		END
	END
	ELSE IF	@l_columnName = 'commCellName'
		DELETE	#JobSummary_tmp__Jobs WHERE commCellName NOT LIKE @l_likeStr
	ELSE IF	@l_columnName = 'virtualizationClient'
		DELETE	#JobSummary_tmp__Jobs WHERE commCellName NOT LIKE @l_likeStr
	ELSE IF	@l_columnName = 'clientGroup'
		DELETE	#JobSummary_tmp__Jobs WHERE clientGroup NOT LIKE @l_likeStr
	ELSE IF	@l_columnName = 'clientName'
		DELETE	#JobSummary_tmp__Jobs WHERE clientName NOT LIKE @l_likeStr
	ELSE IF	@l_columnName = 'agentName'
		DELETE	#JobSummary_tmp__Jobs WHERE appTypeName NOT LIKE @l_likeStr
	ELSE IF	@l_columnName = 'instanceName'
		DELETE	#JobSummary_tmp__Jobs WHERE instanceName NOT LIKE @l_likeStr
	ELSE IF	@l_columnName = 'backupsetName'
		DELETE	#JobSummary_tmp__Jobs WHERE backupsetName NOT LIKE @l_likeStr
	ELSE IF	@l_columnName = 'subclientName'
		DELETE	#JobSummary_tmp__Jobs WHERE subclientName NOT LIKE @l_likeStr
	ELSE IF	@l_columnName = 'backupType'
		DELETE	#JobSummary_tmp__Jobs WHERE backupTypeName NOT LIKE @l_likeStr
	ELSE IF	@l_columnName = 'opType'
		DELETE	#JobSummary_tmp__Jobs WHERE operationName NOT LIKE @l_likeStr
	ELSE IF	@l_columnName = 'startTime'
	BEGIN
		IF ISDATE(@l_filtervalue) = 1
		BEGIN
SET @l_number = DATEDIFF(SS, '1970-01-01', @l_filtervalue)
			IF @l_filterCondition = '='
				DELETE	#JobSummary_tmp__Jobs WHERE startTime <> @l_number
			ELSE IF @l_filterCondition = '>'
				DELETE	#JobSummary_tmp__Jobs WHERE startTime <= @l_number
			ELSE IF @l_filterCondition = '>='
				DELETE	#JobSummary_tmp__Jobs WHERE startTime <  @l_number
			ELSE IF @l_filterCondition = '<'
				DELETE	#JobSummary_tmp__Jobs WHERE startTime >= @l_number
			ELSE IF @l_filterCondition = '<='
				DELETE	#JobSummary_tmp__Jobs WHERE startTime >  @l_number
		END
	END
	ELSE IF	@l_columnName = 'endTime'
	BEGIN
		IF ISDATE(@l_filtervalue) = 1
		BEGIN
SET @l_number = DATEDIFF(SS, '1970-01-01', @l_filtervalue)
			IF @l_filterCondition = '='
				DELETE	#JobSummary_tmp__Jobs WHERE endTime <> @l_number
			ELSE IF @l_filterCondition = '>'
				DELETE	#JobSummary_tmp__Jobs WHERE endTime <= @l_number
			ELSE IF @l_filterCondition = '>='
				DELETE	#JobSummary_tmp__Jobs WHERE endTime <  @l_number
			ELSE IF @l_filterCondition = '<'
				DELETE	#JobSummary_tmp__Jobs WHERE endTime >= @l_number
			ELSE IF @l_filterCondition = '<='
				DELETE	#JobSummary_tmp__Jobs WHERE endTime >  @l_number
		END
	END
	ELSE IF	@l_columnName = 'appSize'
	BEGIN
		IF @l_filterCondition = 'LIKE'
			DELETE	#JobSummary_tmp__Jobs WHERE (CASE appSize WHEN 0 THEN 'N/A' ELSE dbo.GetAutoSizeStr(appSize) END) NOT LIKE @l_likeStr
		ELSE IF ISNUMERIC(@l_filtervalue) = 1
		BEGIN
			IF @l_filterCondition = '='
				DELETE	#JobSummary_tmp__Jobs WHERE appSize < @l_number OR appSize >= @l_upperLimit
			ELSE IF @l_filterCondition = '>'
				DELETE	#JobSummary_tmp__Jobs WHERE appSize <= @l_upperLimit
			ELSE IF @l_filterCondition = '>='
				DELETE	#JobSummary_tmp__Jobs WHERE appSize <  @l_number
			ELSE IF @l_filterCondition = '<'
				DELETE	#JobSummary_tmp__Jobs WHERE appSize >= @l_number
			ELSE IF @l_filterCondition = '<='
				DELETE	#JobSummary_tmp__Jobs WHERE appSize >  @l_upperLimit
		END
	END
	ELSE IF	@l_columnName = 'mediaSize'
	BEGIN
		IF @l_filterCondition = 'LIKE'
			DELETE	#JobSummary_tmp__Jobs WHERE (CASE mediaSize WHEN 0 THEN 'N/A' ELSE dbo.GetAutoSizeStr(mediaSize) END) NOT LIKE @l_likeStr
		ELSE IF ISNUMERIC(@l_filtervalue) = 1
		BEGIN
			IF @l_filterCondition = '='
				DELETE	#JobSummary_tmp__Jobs WHERE mediaSize < @l_number OR mediaSize >= @l_upperLimit
			ELSE IF @l_filterCondition = '>'
				DELETE	#JobSummary_tmp__Jobs WHERE mediaSize <= @l_upperLimit
			ELSE IF @l_filterCondition = '>='
				DELETE	#JobSummary_tmp__Jobs WHERE mediaSize <  @l_number
			ELSE IF @l_filterCondition = '<'
				DELETE	#JobSummary_tmp__Jobs WHERE mediaSize >= @l_number
			ELSE IF @l_filterCondition = '<='
				DELETE	#JobSummary_tmp__Jobs WHERE mediaSize >  @l_upperLimit
		END
	END
	ELSE IF	@l_columnName = 'networkSize'
	BEGIN
		IF @l_filterCondition = 'LIKE'
			DELETE	#JobSummary_tmp__Jobs WHERE (CASE nwTransBytes WHEN 0 THEN 'N/A' ELSE dbo.GetAutoSizeStr(nwTransBytes) END) NOT LIKE @l_likeStr
		ELSE IF ISNUMERIC(@l_filtervalue) = 1
		BEGIN
			IF @l_filterCondition = '='
				DELETE	#JobSummary_tmp__Jobs WHERE nwTransBytes < @l_number OR nwTransBytes >= @l_upperLimit
			ELSE IF @l_filterCondition = '>'
				DELETE	#JobSummary_tmp__Jobs WHERE nwTransBytes <= @l_upperLimit
			ELSE IF @l_filterCondition = '>='
				DELETE	#JobSummary_tmp__Jobs WHERE nwTransBytes <  @l_number
			ELSE IF @l_filterCondition = '<'
				DELETE	#JobSummary_tmp__Jobs WHERE nwTransBytes >= @l_number
			ELSE IF @l_filterCondition = '<='
				DELETE	#JobSummary_tmp__Jobs WHERE nwTransBytes >  @l_upperLimit
		END
	END
	ELSE IF	@l_columnName = 'dedupeSavings'
	BEGIN
		IF @l_filterCondition = 'LIKE'
			DELETE	#JobSummary_tmp__Jobs WHERE (CASE dedupeSavings WHEN -1 THEN 'N/A' ELSE CAST(dedupeSavings AS VARCHAR(10)) END) NOT LIKE @l_likeStr
		ELSE IF ISNUMERIC(@l_filtervalue) = 1
		BEGIN
			IF @l_filterCondition = '='
				DELETE	#JobSummary_tmp__Jobs WHERE dedupeSavings <> CAST(@l_filtervalue AS FLOAT)
			ELSE IF @l_filterCondition = '>'
				DELETE	#JobSummary_tmp__Jobs WHERE dedupeSavings <= CAST(@l_filtervalue AS FLOAT)
			ELSE IF @l_filterCondition = '>='
				DELETE	#JobSummary_tmp__Jobs WHERE dedupeSavings <  CAST(@l_filtervalue AS FLOAT)
			ELSE IF @l_filterCondition = '<'
				DELETE	#JobSummary_tmp__Jobs WHERE dedupeSavings >= CAST(@l_filtervalue AS FLOAT) OR dedupeSavings < 0
			ELSE IF @l_filterCondition = '<='
				DELETE	#JobSummary_tmp__Jobs WHERE dedupeSavings >  CAST(@l_filtervalue AS FLOAT) OR dedupeSavings < 0
		END
	END
	ELSE IF	@l_columnName = 'JobThroughputinGBHour'
	BEGIN
		IF @l_filterCondition = 'LIKE'
			DELETE	#JobSummary_tmp__Jobs WHERE (CASE JobThroughputinGBHour WHEN -1 THEN 'N/A' ELSE CAST(JobThroughputinGBHour AS VARCHAR(10)) END) NOT LIKE @l_likeStr
		ELSE IF ISNUMERIC(@l_filtervalue) = 1
		BEGIN
			IF @l_filterCondition = '='
				DELETE	#JobSummary_tmp__Jobs WHERE JobThroughputinGBHour <> CAST(@l_filtervalue AS FLOAT)
			ELSE IF @l_filterCondition = '>'
				DELETE	#JobSummary_tmp__Jobs WHERE JobThroughputinGBHour <= CAST(@l_filtervalue AS FLOAT)
			ELSE IF @l_filterCondition = '>='
				DELETE	#JobSummary_tmp__Jobs WHERE JobThroughputinGBHour <  CAST(@l_filtervalue AS FLOAT)
			ELSE IF @l_filterCondition = '<'
				DELETE	#JobSummary_tmp__Jobs WHERE JobThroughputinGBHour >= CAST(@l_filtervalue AS FLOAT) OR JobThroughputinGBHour < 0
			ELSE IF @l_filterCondition = '<='
				DELETE	#JobSummary_tmp__Jobs WHERE JobThroughputinGBHour >  CAST(@l_filtervalue AS FLOAT) OR JobThroughputinGBHour < 0
		END
	END
	ELSE IF	@l_columnName = 'protectedObjects'
	BEGIN
		IF @l_filterCondition = 'LIKE'
			DELETE	#JobSummary_tmp__Jobs WHERE CAST(protectedObjects AS VARCHAR(20)) NOT LIKE @l_likeStr
		ELSE IF ISNUMERIC(@l_filtervalue) = 1
		BEGIN
			SET @l_number = CAST(@l_filtervalue AS INT)
			IF @l_filterCondition = '='
				DELETE	#JobSummary_tmp__Jobs WHERE protectedObjects <> @l_number
			ELSE IF @l_filterCondition = '>'
				DELETE	#JobSummary_tmp__Jobs WHERE protectedObjects <= @l_number
			ELSE IF @l_filterCondition = '>='
				DELETE	#JobSummary_tmp__Jobs WHERE protectedObjects <  @l_number
			ELSE IF @l_filterCondition = '<'
				DELETE	#JobSummary_tmp__Jobs WHERE protectedObjects >= @l_number
			ELSE IF @l_filterCondition = '<='
				DELETE	#JobSummary_tmp__Jobs WHERE protectedObjects >  @l_number
		END
	END
	ELSE IF	@l_columnName = 'failedObjects'
	BEGIN
		IF @l_filterCondition = 'LIKE'
			DELETE	#JobSummary_tmp__Jobs WHERE CAST(failedObjects AS VARCHAR(20)) NOT LIKE @l_likeStr
		ELSE IF ISNUMERIC(@l_filtervalue) = 1
		BEGIN
			SET @l_number = CAST(@l_filtervalue AS INT)
			IF @l_filterCondition = '='
				DELETE	#JobSummary_tmp__Jobs WHERE failedObjects <> @l_number
			ELSE IF @l_filterCondition = '>'
				DELETE	#JobSummary_tmp__Jobs WHERE failedObjects <= @l_number
			ELSE IF @l_filterCondition = '>='
				DELETE	#JobSummary_tmp__Jobs WHERE failedObjects <  @l_number
			ELSE IF @l_filterCondition = '<'
				DELETE	#JobSummary_tmp__Jobs WHERE failedObjects >= @l_number
			ELSE IF @l_filterCondition = '<='
				DELETE	#JobSummary_tmp__Jobs WHERE failedObjects >  @l_number
		END
	END
	ELSE IF	@l_columnName = 'failedFolders'
	BEGIN
		IF @l_filterCondition = 'LIKE'
			DELETE	#JobSummary_tmp__Jobs WHERE CAST(failedFolders AS VARCHAR(20)) NOT LIKE @l_likeStr
		ELSE IF ISNUMERIC(@l_filtervalue) = 1
		BEGIN
			SET @l_number = CAST(@l_filtervalue AS INT)
			IF @l_filterCondition = '='
				DELETE	#JobSummary_tmp__Jobs WHERE failedFolders <> @l_number
			ELSE IF @l_filterCondition = '>'
				DELETE	#JobSummary_tmp__Jobs WHERE failedFolders <= @l_number
			ELSE IF @l_filterCondition = '>='
				DELETE	#JobSummary_tmp__Jobs WHERE failedFolders <  @l_number
			ELSE IF @l_filterCondition = '<'
				DELETE	#JobSummary_tmp__Jobs WHERE failedFolders >= @l_number
			ELSE IF @l_filterCondition = '<='
				DELETE	#JobSummary_tmp__Jobs WHERE failedFolders >  @l_number
		END
	END
	ELSE IF	@l_columnName = 'storagePolicy'
		DELETE	#JobSummary_tmp__Jobs WHERE storagePolicyName NOT LIKE @l_likeStr
	ELSE IF	@l_columnName = 'mediaAgent'
		DELETE	#JobSummary_tmp__Jobs WHERE mediaAgent NOT LIKE @l_likeStr
	ELSE IF	@l_columnName = 'userName'
		DELETE	#JobSummary_tmp__Jobs WHERE userName NOT LIKE @l_likeStr
	ELSE IF	@l_columnName = 'status'
		DELETE	#JobSummary_tmp__Jobs WHERE jobStatusName NOT LIKE @l_likeStr
	ELSE IF	@l_columnName = 'failure'
		DELETE	#JobSummary_tmp__Jobs WHERE failureReasonMsg NOT LIKE @l_likeStr
	ELSE IF	@l_columnName = 'failureReasons'
		DELETE	#JobSummary_tmp__Jobs WHERE failureReasons NOT LIKE @l_likeStr
	ELSE IF	@l_columnName = 'vmClientName'
		DELETE	#JobSummary_tmp__Jobs WHERE vmClientName NOT LIKE @l_likeStr
	ELSE IF	@l_columnName = 'vmStatus'
		DELETE	#JobSummary_tmp__Jobs WHERE vmStatus NOT LIKE @l_likeStr
	ELSE IF	@l_columnName = 'isProtectVM'
		DELETE	#JobSummary_tmp__Jobs WHERE isProtectVM NOT LIKE @l_likeStr
	ELSE IF  @l_columnName = 'retainedBy'
		DELETE  #JobSummary_tmp__Jobs WHERE retainedBy NOT LIKE @l_likeStr
	ELSE IF	 @l_columnName = 'retainedUntil'
	BEGIN
		IF ISDATE(@l_filtervalue) = 1
		BEGIN
SET @l_number = DATEDIFF(SS, '1970-01-01', @l_filtervalue)
			IF @l_filterCondition = '='
				DELETE	#JobSummary_tmp__Jobs WHERE endTime <> @l_number
			ELSE IF @l_filterCondition = '>'
				DELETE	#JobSummary_tmp__Jobs WHERE endTime <= @l_number
			ELSE IF @l_filterCondition = '>='
				DELETE	#JobSummary_tmp__Jobs WHERE endTime <  @l_number
			ELSE IF @l_filterCondition = '<'
				DELETE	#JobSummary_tmp__Jobs WHERE endTime >= @l_number
			ELSE IF @l_filterCondition = '<='
				DELETE	#JobSummary_tmp__Jobs WHERE endTime >  @l_number
		END
	END
	ELSE IF	@l_columnName = 'ParentJobid'
	BEGIN
		IF @l_filterCondition = 'LIKE'
			DELETE	#JobSummary_tmp__Jobs WHERE CAST(ParentJobid AS VARCHAR(10)) NOT LIKE @l_likeStr
		ELSE IF ISNUMERIC(@l_filtervalue) = 1
		BEGIN
			SET @l_number = CAST(@l_filtervalue AS BIGINT)
			IF @l_filterCondition = '='
				DELETE	#JobSummary_tmp__Jobs WHERE ParentJobid <> @l_number
			ELSE IF @l_filterCondition = '>'
				DELETE	#JobSummary_tmp__Jobs WHERE ParentJobid <= @l_number
			ELSE IF @l_filterCondition = '>='
				DELETE	#JobSummary_tmp__Jobs WHERE ParentJobid <  @l_number
			ELSE IF @l_filterCondition = '<'
				DELETE	#JobSummary_tmp__Jobs WHERE ParentJobid >= @l_number
			ELSE IF @l_filterCondition = '<='
				DELETE	#JobSummary_tmp__Jobs WHERE ParentJobid >  @l_number
		END
	END
	FETCH	TableFilterCur INTO @l_columnName, @l_filtervalue, @l_filterCondition
END
CLOSE	TableFilterCur
DEALLOCATE TableFilterCur
SELECT	@totalBackupJobs = COUNT(*)
FROM	#JobSummary_tmp__Jobs
-- paging support
SET @jobsPageStart = (@backupPageNo-1) * @jobsPageSizeLocal
SET @sqlStr =
	'INSERT INTO #JobSummary_tmp__JobList SELECT
    jobId                   ,
    commCellId              ,
    commCellName            ,
    clientGroup             ,
    clientId                ,
    clientName              ,
    appTypeId               ,
    appTypeName             ,
    instanceId              ,
    instanceName            ,
    backupsetId             ,
    backupsetName           ,
    subclientId             ,
    subclientName           ,
    opType                  ,
    operationName           ,
    backupLevel             ,
    backupTypeName          ,
 	dataArchGrpId           ,
    storagePolicyName       ,
    mediaAgent              ,
    startTime               ,
    endTime                 ,
    appSize                 ,
    mediaSize               ,
    nwTransBytes            ,
    dedupeSavings           ,
    protectedObjects        ,
    failedObjects           ,
    failedFolders           ,
    userName                ,
    jobStatus               ,
    jobStatusName           ,
    failureReason           ,
    failureReasonMsg        ,
    failureReasons          ,
	vmClientName			,
	vmStatus				,
	JobWriteTime			,
	JobThroughputinGBHour	,
	isProtectVM			    ,
	ParentJobid			    ,
	virtualizationClient    ,
	retainedUntil           ,
	retainedBy FROM #JobSummary_tmp__Jobs ORDER BY '
	+ (CASE @backupJobsSortColumn
		WHEN  1 THEN 'jobId'
		WHEN  2 THEN 'commCellId'
		WHEN  3 THEN 'commCellName'
		WHEN  4 THEN 'clientId'
		WHEN  5 THEN 'clientName'
		WHEN  6 THEN 'appTypeId'
		WHEN  7 THEN 'appTypeName'
		WHEN  8 THEN 'instanceId'
		WHEN  9 THEN 'instanceName'
		WHEN 10 THEN 'backupsetId'
		WHEN 11 THEN 'backupsetName'
		WHEN 12 THEN 'subclientId'
		WHEN 13 THEN 'subclientName'
		WHEN 14 THEN 'backupTypeName'
		WHEN 15 THEN 'startTime'
		WHEN 16 THEN 'endTime'
		WHEN 17 THEN 'appSize'
		WHEN 18 THEN 'nwTransBytes'
		WHEN 19 THEN 'protectedObjects'
		WHEN 20 THEN 'failedObjects'
		WHEN 21 THEN 'failedFolders'
		WHEN 23 THEN 'userName'
		WHEN 24 THEN 'jobStatusName'
		WHEN 25 THEN 'failureReasonMsg'
		WHEN 27 THEN 'mediaSize'
		WHEN 28 THEN 'failureReasons'
		WHEN 29 THEN 'dedupeSavings'
		WHEN 30 THEN 'clientGroup'
		WHEN 31 THEN 'operationName'
		WHEN 32 THEN 'vmClientName'
		WHEN 33 THEN 'vmStatus'
		WHEN 34 THEN 'JobThroughputinGBHour'
		WHEN 35 THEN 'storagePolicyName'
		WHEN 36 THEN 'mediaAgent'
		WHEN 37 THEN 'isProtectVM'
		WHEN 38 THEN 'ParentJobid'
		WHEN 39 THEN 'virtualizationClient'
		WHEN 40 THEN 'retainedUntil'
		WHEN 41 THEN 'retainedBy'
		ELSE 'clientName'
		END)
	+ (CASE @backupJobsSortOrder  WHEN 0 THEN ' ASC' ELSE ' DESC' END)
	+ (CASE @backupJobsSortColumn WHEN 1 THEN ', vmClientName' ELSE ', jobId' END)
EXEC sp_executeSql @sqlStr
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__Jobs') IS NOT null DROP TABLE #JobSummary_tmp__Jobs
RETUEN_XML:
SELECT
	@newUpdatetime           AS '@lastUpdateTime',
    (SELECT aliasName					AS '@commCellName',
            REPLACE(LTRIM(REPLACE(SUBSTRING(master.sys.fn_varbintohexstr(CONVERT(VARBINARY(8), number)), 3, 8), '0', ' ')), ' ', '0')
										AS '@commCellID',
            ipAddress                   AS '@commServeIP',
            (SELECT name FROM SimMiniBrand WITH (NOLOCK) WHERE MiniBrandId = @l_MiniBrandId)
							            AS '@edition',
            CASE ccOpMode WHEN 1000 THEN 'Evaluation' WHEN 1002 THEN 'Production' WHEN 1004 THEN 'DR Production' ELSE 'Unknown' END
							            AS '@licenseMode',
            timeZone                    AS '@commServeTZ'
	 FROM	APP_CommCell WITH (NOLOCK)
	 WHERE	id = 2
     FOR    XML PATH('ccInfo'),TYPE),
    (SELECT
        @totalBackupJobs                     AS '@totalJobs',
        @jobsPageSizeLocal                   AS '@pageSize',
        (SELECT JB.jobId                                    AS '@jobId',
                JB.commCellId                               AS '@commCellId',
                JB.commCellName                             AS '@commCellName',
                JB.clientId                                 AS '@clientId',
                JB.clientName                               AS '@clientName',
                JB.appTypeId                                AS '@agentId',
                JB.appTypeName                              AS '@agentName',
                JB.instanceId                               AS '@instanceId',
                JB.instanceName                             AS '@instanceName',
                JB.backupsetId                              AS '@backupsetId',
                JB.backupsetName                            AS '@backupsetName',
                JB.subclientId                              AS '@subclientId',
                JB.subclientName                            AS '@subclientName',
                JB.operationName                            AS '@opType',
				JB.backupTypeName                           AS '@backupType',
                JB.startTime                             	AS '@startTime',
                JB.endTime                               	AS '@endTime',
                dbo.GetAutoSizeStr(JB.appSize)              AS '@appSize',
                dbo.GetAutoSizeStr(JB.mediaSize)            AS '@mediaSize',
                dbo.GetAutoSizeStr(JB.nwTransBytes)         AS '@networkSize',
                JB.protectedObjects                         AS '@protectedObjects',
                JB.failedObjects                            AS '@failedObjects',
                JB.failedFolders                            AS '@failedFolders',
                JB.userName                                 AS '@userName',
                JB.jobStatusName                            AS '@status',
                JB.failureReasonMsg                         AS '@failure',
				JB.dedupeSavings							AS '@dedupeSavings',
				JB.clientGroup								AS '@clientGroup',
				JB.storagePolicyId                          AS '@storagePolicyId',
				JB.storagePolicyName                        AS '@storagePolicy',
				JB.mediaAgent                               AS '@mediaAgent',
				JB.failureReasons                           AS '@failureReasons',
				JB.vmClientName								AS '@vmClientName',
				JB.vmStatus                                 AS '@vmStatus',
				CAST (JB.JobThroughputinGBHour AS DECIMAL(32,3)) AS '@JobThroughputinGBHour',
				CASE WHEN JB.isProtectVM =1
				THEN 'yes' else 'no'  end                      AS '@isProtectVM',
				CASE WHEN JB.ParentJobid =-1
				THEN 'N/A' else CAST (JB.ParentJobid AS VARCHAR(14))  END             AS '@ParentJobid',
				CASE WHEN JB.virtualizationClient IS NULL
				THEN 'N/A' else JB.virtualizationClient  END             AS '@virtualizationClient',
				CASE WHEN JB.retainedUntil IS NULL
				THEN JB.startTime else JB.retainedUntil END                    AS '@retainedUntil',
				CASE WHEN JB.retainedBy IS NULL
				THEN 'N/A' else JB.retainedBy END                    AS '@retainedBy'
         FROM   #JobSummary_tmp__JobList JB
         WHERE  JB.id > @jobsPageStart AND JB.id <= (@jobsPageStart + @jobsPageSizeLocal)
         ORDER  BY JB.id ASC
         FOR XML PATH('jobs'),TYPE)
	 FOR XML PATH('backupJobs'), TYPE
	),
    (SELECT
            (SELECT
                    (SELECT JDA.entityId                AS '@entityId',
                            JDA.entityName              AS '@entityName',
                            JDA.deleted                 AS '@deleted',
                            JDA.totalJobs               AS '@totalJobs',
                            JDA.totalAppSize            AS '@totalAppSize',
                            JDA.totalDataWritten        AS '@totalDataWritten',
                            JDA.totalProtectedObjects   AS '@totalProtectedObjects',
                            JDA.totalFailedObjects      AS '@totalFailedObjects',
                            JDA.totalFailedFolders      AS '@totalFailedFolders'
                     FROM   #JobSummary_tmp__JobListAggr JDA
                     ORDER  BY JDA.totalJobs DESC
                     FOR    XML PATH('entities'),TYPE)
             FOR XML PATH('aggregate'),TYPE)
     WHERE @jobsOnlyRequest = 0
     FOR XML PATH('viewDetails'),TYPE)
FOR XML PATH ('WebReport_JobReportResp')
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__UserObjectss')  IS NOT null DROP TABLE #JobSummary_tmp__UserObjects
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__StoragePolicy') IS NOT null DROP TABLE #JobSummary_tmp__StoragePolicy
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__MediaAgent')    IS NOT null DROP TABLE #JobSummary_tmp__MediaAgent
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__clientGroupId') IS NOT null DROP TABLE #JobSummary_tmp__clientGroupId
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__clientId')      IS NOT null DROP TABLE #JobSummary_tmp__clientId
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__appTypeId')     IS NOT null DROP TABLE #JobSummary_tmp__appTypeId
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__TypeName')      IS NOT null DROP TABLE #JobSummary_tmp__TypeName
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__JobStatus')     IS NOT null DROP TABLE #JobSummary_tmp__JobStatus
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__EntityId')      IS NOT null DROP TABLE #JobSummary_tmp__EntityId
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__Entity')        IS NOT null DROP TABLE #JobSummary_tmp__Entity
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__FilterList')    IS NOT null DROP TABLE #JobSummary_tmp__FilterList
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__JobList')       IS NOT null DROP TABLE #JobSummary_tmp__JobList
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__JobListAggr')   IS NOT null DROP TABLE #JobSummary_tmp__JobListAggr
IF OBJECT_ID('tempdb.dbo.#ClientGroupsString')            IS NOT null DROP TABLE #ClientGroupsString
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__Retention')     IS NOT null DROP TABLE #JobSummary_tmp__Retention
IF OBJECT_ID('tempdb.dbo.#maxJobRetention')               IS NOT null DROP TABLE #maxJobRetention
IF OBJECT_ID('tempdb.dbo.#VSA_AppIDs')                    IS NOT null DROP TABLE #VSA_AppIDs
GO

IF EXISTS (select * from GxQscripts where name = 'wr_JobSummary')
	delete from GxQscripts where name = 'wr_JobSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_JobSummary')
	delete from GXDBVersions where aliasname = 'wr_JobSummary'
GO

insert into GXDBVersions values(2, 'wr_JobSummary',  '00010095000200620000', 'wr_JobSummary', '00010095000200620000')
GO

