

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_JobActivity.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/wr_JobActivity.sp,v $ $Id: wr_JobActivity.sp,v 1.4 2011/03/21 12:45:28 smekala Exp $";
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Eugene Volohov
-- Create date: 03/11/2011
-- Description:	generates job activity report
-- Parameters :
-- -----------------------------------------------------------------------------------------------------------
-- ----------------------------------------------------------
-- $Log: wr_JobActivity.sp,v $
-- Revision 1.3  2011/03/18 20:25:39  g8builder
-- Developers fixes for B-33 - Build Team
-- MR:XXXXX
-- Original branch changes by: g8builder (Galaxy Builder)
--
-- Revision 1.2  2011/03/17 12:48:08  g8builder
-- Dont use  comments inside a comment it will cause DB_SQl code generation error
-- Original branch changes by: g8builder (Galaxy Builder)
--
-- Revision 1.1  2011/03/11 21:41:51  evolohov
-- Stored procedure that implements Job Activity report.
-- Initial commit
--
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_JobActivity <<<'

IF EXISTS (select * from sysobjects where name='wr_JobActivity')
	drop procedure wr_JobActivity
IF EXISTS (select * from GxQscripts where name='wr_JobActivity')
	delete from GxQscripts where name = 'wr_JobActivity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_JobActivity')
	delete from GXDBVersions where aliasname = 'wr_JobActivity'
GO
print '... Creating Procedure: wr_JobActivity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_JobActivity
  @timeFrameType INT,
  @frequency INT,
  @numberOfPeriods INT,
  @reqStartTime INT,
  @reqEndTime INT,
  @includeCurrentPeriod INT,
  @treatWeekend INT,
  @includeLogDeletedClients INT,
  @includeLogDeletedSubclients INT,
  @groupBy INT,
  @userId INT,
  @localeId INT,
  @drill INT,
  @includeAllEntities INT,
  @subclientFilterList NTEXT
AS
  DECLARE @o_JobActivity NVARCHAR(MAX);
--DECLARE @timeFrameType               INT = 1
--DECLARE @frequency                   INT = 1
--DECLARE @numberOfPeriods             INT = 10
--DECLARE @reqStartTime                INT = 0 --dbo.GetUnixTime(DATEADD(d, -6, GETDATE()))
--DECLARE @reqEndTime                  INT = 0 --dbo.GetUnixTime(DATEADD(d, 3, GETDATE()))
--DECLARE @includeCurrentPeriod        INT = 1
--DECLARE @treatWeekend                INT = 0
--DECLARE @includeLogDeletedClients    INT = 0
--DECLARE @includeLogDeletedSubclients INT = 0
--DECLARE @groupBy                     INT = 3
--DECLARE @userId                      INT = 0
--DECLARE @localeId                    INT = 0
--DECLARE @drill                       INT = 0
--DECLARE @includeAllEntities          INT = 1
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#JobActivity_tmp__Stats')                  IS NOT null DROP TABLE #JobActivity_tmp__Stats
IF OBJECT_ID('tempdb.dbo.#JobActivity_tmp__Periods')                IS NOT null DROP TABLE #JobActivity_tmp__Periods
IF OBJECT_ID('tempdb.dbo.#JobActivity_tmp__CommCellTimeRanges')     IS NOT null DROP TABLE #JobActivity_tmp__CommCellTimeRanges
IF OBJECT_ID('tempdb.dbo.#JobActivity_tmp__EntityId')               IS NOT null DROP TABLE #JobActivity_tmp__EntityId
IF OBJECT_ID('tempdb.dbo.#JobActivity_tmp__Entity')                 IS NOT null DROP TABLE #JobActivity_tmp__Entity
IF OBJECT_ID('tempdb.dbo.#JobActivity_tmp__Aggregate')              IS NOT null DROP TABLE #JobActivity_tmp__Aggregate
IF OBJECT_ID('tempdb.dbo.#JobActivity_tmp__Jobs')                   IS NOT null DROP TABLE #JobActivity_tmp__Jobs
DECLARE @debug			INT = 0
DECLARE @stats			INT = 0
DECLARE @statsTempTime  DATETIME
IF @stats <> 0 BEGIN
    CREATE TABLE #JobActivity_tmp__Stats (type VARCHAR(50), timeSpentMili INT)
	SET NOCOUNT OFF
	SET STATISTICS IO ON
	SET STATISTICS TIME ON
END
CREATE TABLE #JobActivity_tmp__Periods
(
	commCellId		            INT,
	dayNum		                INT,
	dayRefStart	                DATETIME,
	dayRefEnd	                DATETIME,
	dayStart	                DATETIME,
	dayEnd		                DATETIME,
	predicted	                INT,
	dayRefStartLocal	        DATETIME,
	dayRefEndLocal		        DATETIME,
	dayRefStartUnix	            INT,
	dayRefEndUnix	            INT,
	dayStartUnix	            INT,
	dayEndUnix                  INT,
	dayRefStartLocalUnix	    INT,
	dayRefEndLocalUnix          INT
)
CREATE TABLE #JobActivity_tmp__CommCellTimeRanges
(
    commCellId                  INT,
    startTime                   DATETIME,
    endTime                     DATETIME,
    startTimeUnix               INT,
    endTimeUnix                 INT
)
CREATE TABLE #JobActivity_tmp__Entity
(
    commCellId          INT,
    commCellName        NVARCHAR(1024),
    groupId             INT,
    groupName           NVARCHAR(1024),
    clientId            INT,
    clientName          NVARCHAR(1024),
    appTypeId           INT,
    appTypeName         NVARCHAR(1024),
    instanceId          INT,
    instanceName        NVARCHAR(1024),
    backupsetId         INT,
    backupsetName       NVARCHAR(1024),
    subclientId         INT,
    subclientName       NVARCHAR(1024),
    logDeletedClient    INT,
    logDeletedSubclient INT,
    dataArchGroupId     INT,
    logArchGroupId      INT
)
CREATE TABLE #JobActivity_tmp__EntityId
(
    commCellId                  INT,
    groupId                     INT,
    clientId                    INT,
    appTypeId                   INT,
    instanceId                  INT,
    backupsetId                 INT,
    subclientId                 INT,
    logDeletedClient            INT,
    logDeletedSubclient         INT
)
CREATE TABLE #JobActivity_tmp__Aggregate
(
    aggregateType               INT             NOT NULL,
	entityId                    INT             NULL,
	entityName		            NVARCHAR(2000)	NULL,
	commcellId                  INT             NULL,
	commcellName                NVARCHAR(512)   NULL,
	logDeleted		            INT             NULL,
    dayNo                       INT                 NULL,
    periodStartTime             INT             NOT NULL,
    periodEndTime               INT             NOT NULL,
	fullDataSizeMB		        BIGINT          NOT NULL,
	otherDataSizeMB		        BIGINT          NOT NULL,
	totalDataSizeMB		        BIGINT          NOT NULL,
	fullMediaSizeMB		        BIGINT          NULL,
	otherMediaSizeMB	        BIGINT          NULL,
	totalMediaSizeMB	        BIGINT          NULL,
	numCompleted		        INT 	        NOT NULL,
	numCompletedMulAttmpts      INT 	        NOT NULL,
    numFailed                   INT 	        NOT NULL,
    numKilled                   INT 	        NOT NULL,
	numTotal		            INT		        NOT NULL,
	numCompletedPer		        INT 	        NOT NULL,
	numCompletedMulAttmptsPer   INT 	        NOT NULL,
    numFailedPer                INT 	        NOT NULL,
    numKilledPer                INT 	        NOT NULL
)
CREATE TABLE #JobActivity_tmp__Jobs
(
	jobCategory			INT             NOT NULL,
    commCellId          INT             NOT NULL,
    jobId               INT             NOT NULL,
    appTypeId           INT             NOT NULL,
    opType              INT             NOT NULL,
    bkpLevel            INT             NOT NULL,
    clientId			INT             NOT NULL,
    attemptFailures     INT             NOT NULL,
    dataStorageId		INT	            NULL,
    logStorageId		INT	            NULL,
    subclientId			INT	            NULL,
    startTime           INT             NOT NULL,
    endTime             INT             NOT NULL,
    [status]            INT             NOT NULL,
    dataPhysicalSize    BIGINT          NULL,
    dataLogicalSize     BIGINT          NULL,
    logPhysicalSize     BIGINT          NULL,
    logLogicalSize      BIGINT          NULL,
    protectedObjects    INT             NOT NULL,
    failedObjects       INT             NOT NULL,
    failedFolders       INT             NOT null
)
CREATE INDEX #JobActivity_tmp__Jobs_idx1 ON #JobActivity_tmp__Jobs (commCellId ASC, startTime ASC, endTime ASC)
IF @stats <> 0 SET @statsTempTime = GetDate()
EXEC wr_UserCellSelection @userId, N'#JobActivity_tmp__EntityId', @includeAllEntities, @includeLogDeletedClients, @includeLogDeletedSubclients, @subclientFilterList
DELETE  #JobActivity_tmp__EntityId
WHERE       (groupId = 0 AND @groupBy = 4)
        OR  (groupId <> 0 AND @groupBy <> 4)
INSERT INTO #JobActivity_tmp__Entity
    SELECT  E.commCellId, CC.aliasName,
            E.groupId, ISNULL(CG.name, ''),
            E.clientId, CL.name,
            E.appTypeId, IDA.name,
            E.instanceId, I.name,
            E.backupsetId, BS.name,
            E.subclientId, APP.subclientName,
            E.logDeletedClient, E.logDeletedSubclient,
            APP.dataArchGrpID, APP.logArchGrpID
    FROM    #JobActivity_tmp__EntityId E INNER JOIN APP_CommCell         CC  ON CC.id = E.commCellId
                                         INNER JOIN APP_Client           CL  ON CL.id = E.clientId
                                         INNER JOIN APP_iDAType          IDA ON IDA.[type] = E.appTypeId
                                         INNER JOIN APP_InstanceName     I   ON I.id = E.instanceId
                                         INNER JOIN APP_BackupSetName    BS  ON BS.id = E.backupsetId
                                         INNER JOIN APP_Application      APP ON APP.id = E.subclientId
                                         LEFT  JOIN APP_ClientGroup      CG  ON CG.id = E.groupId
IF @stats <> 0 INSERT INTO #JobActivity_tmp__Stats VALUES('entities', datediff(millisecond, @statsTempTime, GetDate()))
IF @debug <> 0 SELECT 'entities', * FROM #JobActivity_tmp__Entity
-- create list of time periods for each commcell.
-- each commcell can have its own day-start/day-end definition. So we have to create periods list for
-- each commcell separately
-- we can use cursor here without any problem because table we are going to iterate through is already
-- temporary, in-memory table
IF @stats <> 0 SET @statsTempTime = GetDate()
DECLARE @selectedCC INT
DECLARE existingCCs CURSOR FOR SELECT DISTINCT CommCellId FROM #JobActivity_tmp__Entity
OPEN existingCCs
FETCH NEXT FROM existingCCs INTO @selectedCC
WHILE @@FETCH_STATUS = 0 BEGIN
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------activity or coverage---+
    --                                                                                                                                                                                     |
    EXEC dbo.wr_BuildDaysRange  @selectedCC, '#JobActivity_tmp__Periods', @timeFrameType, @numberOfPeriods, @frequency, @reqStartTime, @reqEndTime, @treatWeekend, 0, 1, 10, 0, @includeCurrentPeriod
    FETCH NEXT FROM existingCCs INTO @selectedCC
END
CLOSE existingCCs
DEALLOCATE existingCCs
IF @stats <> 0 INSERT INTO #JobActivity_tmp__Stats VALUES('periods', datediff(millisecond, @statsTempTime, GetDate()))
IF @debug <> 0 SELECT 'periods', * FROM #JobActivity_tmp__Periods
IF @stats <> 0 SET @statsTempTime = GetDate()
INSERT INTO #JobActivity_tmp__CommCellTimeRanges
    SELECT  commCellId, MIN(dayRefStart), MAX(dayRefStart), MIN(dayRefStartUnix), MAX(dayRefStartUnix)
    FROM    #JobActivity_tmp__Periods
    GROUP   BY  commCellId
IF @stats <> 0 INSERT INTO #JobActivity_tmp__Stats VALUES('cell ranges', datediff(millisecond, @statsTempTime, GetDate()))
IF @debug <> 0 SELECT 'cell ranges', * FROM #JobActivity_tmp__CommCellTimeRanges
IF @stats <> 0 SET @statsTempTime = GETDATE()
INSERT INTO #JobActivity_tmp__Jobs
    -- Get the data from the running tables first. Data in those tables is more accurate and gets updated more frequent.
    -- To differentiate between <state>:[running job] and <status>:[finished job] we will adjust <state> to be <state> + 100
    -- <status> will remain the same
	SELECT  1, BI.commCellId, BI.jobId, A.appTypeId, JI.opType, BI.bkpLevel, A.clientId, 0, BI.dataPolicy, BI.logPolicy, A.id, JI.jobStartTime, 0, 100 + JI.[state],
	        0, 0, 0, 0, ISNULL(BI.filesXfered, 0),
	        ISNULL(BI.backupFileFailures, 0), ISNULL(BI.backupFolderFailures, 0)
	FROM	JMJobInfo JI WITH (READUNCOMMITTED) INNER JOIN JMBkpJobInfo BI WITH (READUNCOMMITTED) ON JI.commCellId = BI.commCellId AND JI.jobId = BI.jobId
						 INNER JOIN APP_Application A ON A.origCCId = BI.commcellId AND A.id = BI.applicationId
						 INNER JOIN #JobActivity_tmp__CommCellTimeRanges PR ON PR.commCellId = JI.commCellId
	WHERE		JI.jobStartTime BETWEEN PR.startTimeUnix AND PR.endTimeUnix
			-- filter out job based on user
			AND (@userId = 0 OR dbo.isBkpJobVisible(@userId, BI.CommCellId,  A.clientId, A.appTypeId, A.instance, A.backupset, A.id) = 1)
			-- backup
			AND JI.opType = 4
    UNION
    SELECT  1, B.commCellId, B.jobId, B.appType, B.opType, B.bkpLevel, A.clientId, 0, B.dataArchGrpId, B.logArchGrpId, A.id, B.servStartDate, B.servEndDate,
            (CASE B.displayStatus WHEN 0 THEN B.[status] ELSE B.displayStatus END),
            0, 0, 0, 0, ISNULL(totalNumOfFolders, 0) + ISNULL(totalNumOfFiles, 0),
            ISNULL(backupFileFailures, 0), ISNULL(backupFolderFailures, 0)
    FROM    JMBkpStats B WITH (READUNCOMMITTED) INNER JOIN APP_Application A ON B.commCellId = A.origCCId AND B.appId = A.id
                                                INNER JOIN #JobActivity_tmp__CommCellTimeRanges PR ON PR.commCellId = B.commCellId
    WHERE		(B.servStartDate BETWEEN PR.startTimeUnix AND PR.endTimeUnix)
			-- filter out job based on user
			AND (@userId = 0 OR dbo.isBkpJobVisible(@userId, B.CommCellId,  A.clientId, A.appTypeId, A.instance, A.backupset, A.id) = 1)
            -- backup
            AND B.opType = 4
IF @stats <> 0 INSERT INTO #JobActivity_tmp__Stats VALUES('jobs', datediff(millisecond, @statsTempTime, GetDate()))
-- it happens that it is faster to select all entries from JMBkpStats and JMBkpJonbInfo and delete unwanted ones as a second step
-- than use just one query with JOIN or subqueries to filter out unwanted jobs
IF @stats <> 0 SET @statsTempTime = GETDATE()
DELETE  FROM #JobActivity_tmp__Jobs
WHERE   subclientId NOT IN (SELECT id FROM APP_Application S INNER JOIN #JobActivity_tmp__Entity C ON     S.origCCId = C.CommCellId
                                                                                                      AND S.clientId = C.ClientId )
IF @stats <> 0 INSERT INTO #JobActivity_tmp__Stats VALUES('jobs adjustment', datediff(millisecond, @statsTempTime, GetDate()))
-- update sizes in the table
IF @stats <> 0 SET @statsTempTime = GETDATE()
UPDATE  #JobActivity_tmp__Jobs
SET     dataPhysicalSize = ISNULL( (SELECT  SUM(physicalSize)
                                    FROM    archChunkMapping WITH (READUNCOMMITTED)
                                    WHERE   archFileId IN (SELECT id FROM archFile WITH (READUNCOMMITTED) WHERE jobId = #JobActivity_tmp__Jobs.jobId and archGroupId = #JobActivity_tmp__Jobs.dataStorageId)), 0),
        logPhysicalSize  = ISNULL( (SELECT  SUM(physicalSize)
                                    FROM    archChunkMapping WITH (READUNCOMMITTED)
                                    WHERE   archFileId IN (SELECT id FROM archFile WITH (READUNCOMMITTED) WHERE jobId = #JobActivity_tmp__Jobs.jobId and archGroupId = #JobActivity_tmp__Jobs.logStorageId)), 0),
        dataLogicalSize  = ISNULL( (SELECT  SUM(logicalSize)
                                    FROM    archChunkMapping WITH (READUNCOMMITTED)
                                    WHERE   archFileId IN (SELECT id FROM archFile WITH (READUNCOMMITTED) WHERE jobId = #JobActivity_tmp__Jobs.jobId and archGroupId = #JobActivity_tmp__Jobs.dataStorageId)), 0),
        logLogicalSize   = ISNULL( (SELECT  SUM(logicalSize)
                                    FROM    archChunkMapping WITH (READUNCOMMITTED)
                                    WHERE   archFileId IN (SELECT id FROM archFile WITH (READUNCOMMITTED) WHERE jobId = #JobActivity_tmp__Jobs.jobId and archGroupId = #JobActivity_tmp__Jobs.logStorageId)), 0)
IF @stats <> 0 INSERT INTO #JobActivity_tmp__Stats VALUES('media sizes selection', datediff(millisecond, @statsTempTime, GetDate()))
-- now get number of failed attempts for each job
IF @stats <> 0 SET @statsTempTime = GETDATE()
UPDATE #JobActivity_tmp__Jobs
SET    attemptFailures = ISNULL( (SELECT COUNT(*) FROM JMBkpAtmptStats BSA WHERE     BSA.commCellId = #JobActivity_tmp__Jobs.commCellId
                                                                                 AND BSA.jobId = #JobActivity_tmp__Jobs.jobId
                                                                                 -- CVJobStatus::PARTIALSUCCESS,  CVJobStatus::KILLED,  CVJobStatus::STSTOPPED,  CVJobStatus::STINTERRUPTED
                                                                                 AND BSA.[status] IN (2, 4, 5, 6)), 0)
                         +
                         ISNULL( (SELECT COUNT(*) FROM JMBkpAttemptInfo BAI WHERE    BAI.commCellId = #JobActivity_tmp__Jobs.commCellId
                                                                                 AND BAI.jobId = #JobActivity_tmp__Jobs.jobId
                                                                                 -- CVJobState::STOPPED = 5, CVJobState::KILLPENDING = 6, CVJobState::STOPPENDING = 7, CVJobState::INTERRUPTPENDING = 8,
                                                                                 -- CVJobState::COMPLETEDFAIL = 9, CVJobState::STATEKILLED = 10, CVJobState::SYSTEMKILLPENDING = 12
                                                                                 AND BAI.[status] IN (5, 6, 7, 8, 9, 10, 12)), 0)
IF @stats <> 0 INSERT INTO #JobActivity_tmp__Stats VALUES('jobs attempts selection', datediff(millisecond, @statsTempTime, GetDate()))
IF @debug <> 0 SELECT 'jobs', * FROM #JobActivity_tmp__Jobs
IF @groupBy = 1 BEGIN   -- client
    INSERT INTO #JobActivity_tmp__Aggregate
        SELECT  DISTINCT 0,
                CL.clientId, CL.clientName, CL.commCellId, CL.commCellName, CL.logDeletedClient,
                P.dayNum, P.dayRefStartUnix, P.dayRefEndUnix,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    -- groupBy specific. populated in next statement
                0, 0, 0, 0                          -- common: will be calculated later
        FROM    #JobActivity_tmp__Entity CL INNER JOIN #JobActivity_tmp__Periods P ON P.commCellId = CL.commCellId
    UPDATE #JobActivity_tmp__Aggregate SET
        fullDataSizeMB =  (SELECT CAST(ISNULL(SUM((ISNULL(J.dataLogicalSize, 0) + ISNULL(J.logLogicalSize, 0))* 1.0 / 1024) / 1024, 0) AS INT)
						   FROM   #JobActivity_tmp__Jobs J
						   WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                 AND (J.commCellId = #JobActivity_tmp__Aggregate.CommCellId AND J.clientId = #JobActivity_tmp__Aggregate.entityId)
                                 AND (dbo.IsBackupLevelFull(J.bkpLevel) = 1)
                                 -- CVJobStatus::JMSUCCESS(1), CVJobStatus::PARTIALSUCCESS(3), CVJobStatus::JMSUCCESSWITHWARNINGS(14)
                                 -- CVJobState::COMPLETED(4), CVJobState::COMPLETEDSUCCESS(9), CVJobState::COMPLETEDPARTIAL(12), CVJobState::COMPLETEDWITHWARNINGS(19)
                                 AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)),
	    otherDataSizeMB = (SELECT CAST(ISNULL(SUM((ISNULL(J.dataLogicalSize, 0) + ISNULL(J.logLogicalSize, 0))* 1.0 / 1024) / 1024, 0) AS INT)
						   FROM   #JobActivity_tmp__Jobs J
						   WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                 AND (J.commCellId = #JobActivity_tmp__Aggregate.CommCellId AND J.clientId = #JobActivity_tmp__Aggregate.entityId)
                                 AND (dbo.IsBackupLevelFull(J.bkpLevel) = 0)
                                 -- CVJobStatus::JMSUCCESS(1), CVJobStatus::PARTIALSUCCESS(3), CVJobStatus::JMSUCCESSWITHWARNINGS(14)
                                 -- CVJobState::COMPLETED(4), CVJobState::COMPLETEDSUCCESS(9), CVJobState::COMPLETEDPARTIAL(12), CVJobState::COMPLETEDWITHWARNINGS(19)
                                 AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)),
        fullMediaSizeMB = (SELECT CAST(ISNULL(SUM((ISNULL(J.dataPhysicalSize, 0) + ISNULL(J.logPhysicalSize, 0))* 1.0 / 1024) / 1024, 0) AS INT)
						   FROM   #JobActivity_tmp__Jobs J
						   WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                 AND (J.commCellId = #JobActivity_tmp__Aggregate.CommCellId AND J.clientId = #JobActivity_tmp__Aggregate.entityId)
                                 AND (dbo.IsBackupLevelFull(J.bkpLevel) = 1)
                                 -- CVJobStatus::JMSUCCESS(1), CVJobStatus::PARTIALSUCCESS(3), CVJobStatus::JMSUCCESSWITHWARNINGS(14)
                                 -- CVJobState::COMPLETED(4), CVJobState::COMPLETEDSUCCESS(9), CVJobState::COMPLETEDPARTIAL(12), CVJobState::COMPLETEDWITHWARNINGS(19)
                                 AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)),
        otherMediaSizeMB = (SELECT CAST(ISNULL(SUM((ISNULL(J.dataPhysicalSize, 0) + ISNULL(J.logPhysicalSize, 0))* 1.0 / 1024) / 1024, 0) AS INT)
						   FROM   #JobActivity_tmp__Jobs J
						   WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                 AND (J.commCellId = #JobActivity_tmp__Aggregate.CommCellId AND J.clientId = #JobActivity_tmp__Aggregate.entityId)
                                 AND (dbo.IsBackupLevelFull(J.bkpLevel) = 0)
                                 -- CVJobStatus::JMSUCCESS(1), CVJobStatus::PARTIALSUCCESS(3), CVJobStatus::JMSUCCESSWITHWARNINGS(14)
                                 -- CVJobState::COMPLETED(4), CVJobState::COMPLETEDSUCCESS(9), CVJobState::COMPLETEDPARTIAL(12), CVJobState::COMPLETEDWITHWARNINGS(19)
                                 AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)),
	    numCompleted    = (SELECT COUNT(*)
                           FROM   #JobActivity_tmp__Jobs J
                           WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                  AND (J.commCellId = #JobActivity_tmp__Aggregate.CommCellId AND J.clientId = #JobActivity_tmp__Aggregate.entityId)
                                 -- CVJobStatus::JMSUCCESS(1), CVJobStatus::PARTIALSUCCESS(3), CVJobStatus::JMSUCCESSWITHWARNINGS(14)
                                 -- CVJobState::COMPLETED(4), CVJobState::COMPLETEDSUCCESS(9), CVJobState::COMPLETEDPARTIAL(12), CVJobState::COMPLETEDWITHWARNINGS(19)
                                 AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)
                                 AND J.attemptFailures < 2),
        numCompletedMulAttmpts =
                          (SELECT COUNT(*)
                           FROM   #JobActivity_tmp__Jobs J
                           WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                  AND (J.commCellId = #JobActivity_tmp__Aggregate.CommCellId AND J.clientId = #JobActivity_tmp__Aggregate.entityId)
                                 -- CVJobStatus::JMSUCCESS(1), CVJobStatus::PARTIALSUCCESS(3), CVJobStatus::JMSUCCESSWITHWARNINGS(14)
                                 -- CVJobState::COMPLETED(4), CVJobState::COMPLETEDSUCCESS(9), CVJobState::COMPLETEDPARTIAL(12), CVJobState::COMPLETEDWITHWARNINGS(19)
                                 AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)
                                 AND J.attemptFailures > 1),
        numFailed       = (SELECT COUNT(*)
                           FROM   #JobActivity_tmp__Jobs J
                           WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                  AND (J.commCellId = #JobActivity_tmp__Aggregate.CommCellId AND J.clientId = #JobActivity_tmp__Aggregate.entityId)
                                  -- CVJobStatus::FAIL(2), CVJobStatus::DROPPED(9), CVJobStatus::SYSTEMFAILED(15)
                                  -- CVJobState::COMPLETEDFAIL(10)
                                  AND J.[status] IN (2, 9, 15, 110) ),
        numKilled       = (SELECT COUNT(*)
                           FROM   #JobActivity_tmp__Jobs J
                           WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                  AND (J.commCellId = #JobActivity_tmp__Aggregate.CommCellId AND J.clientId = #JobActivity_tmp__Aggregate.entityId)
                                  -- CVJobState::KILLPENDING(6), CVJobState::STATEKILLED(11), CVJobState::SYSTEMKILLPENDING(13)
                                  -- CVJobStatus::KILLED(4)
                                  AND J.[status] IN (4, 106, 111, 113) )
END ELSE IF @groupBy = 2 BEGIN   -- agent
    INSERT INTO #JobActivity_tmp__Aggregate
        SELECT  DISTINCT 0,
                CL.appTypeId, CL.appTypeName, NULL, NULL, NULL,
                P.dayNum, P.dayRefStartUnix, P.dayRefEndUnix,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    -- groupBy specific. populated in next statement
                0, 0, 0, 0                          -- common: will be calculated later
        FROM    #JobActivity_tmp__Entity CL INNER JOIN #JobActivity_tmp__Periods P ON P.commCellId = CL.commCellId
    UPDATE #JobActivity_tmp__Aggregate SET
        fullDataSizeMB =  (SELECT CAST(ISNULL(SUM((ISNULL(J.dataLogicalSize, 0) + ISNULL(J.logLogicalSize, 0))* 1.0 / 1024) / 1024, 0) AS INT)
						   FROM   #JobActivity_tmp__Jobs J
						   WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                 AND (J.appTypeId = #JobActivity_tmp__Aggregate.entityId)
                                 AND (dbo.IsBackupLevelFull(J.bkpLevel) = 1)
                                 -- CVJobStatus::JMSUCCESS(1), CVJobStatus::PARTIALSUCCESS(3), CVJobStatus::JMSUCCESSWITHWARNINGS(14)
                                 -- CVJobState::COMPLETED(4), CVJobState::COMPLETEDSUCCESS(9), CVJobState::COMPLETEDPARTIAL(12), CVJobState::COMPLETEDWITHWARNINGS(19)
                                 AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)),
	    otherDataSizeMB = (SELECT CAST(ISNULL(SUM((ISNULL(J.dataLogicalSize, 0) + ISNULL(J.logLogicalSize, 0))* 1.0 / 1024) / 1024, 0) AS INT)
						   FROM   #JobActivity_tmp__Jobs J
						   WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                 AND (J.appTypeId = #JobActivity_tmp__Aggregate.entityId)
                                 AND (dbo.IsBackupLevelFull(J.bkpLevel) = 0)
                                 -- CVJobStatus::JMSUCCESS(1), CVJobStatus::PARTIALSUCCESS(3), CVJobStatus::JMSUCCESSWITHWARNINGS(14)
                                 -- CVJobState::COMPLETED(4), CVJobState::COMPLETEDSUCCESS(9), CVJobState::COMPLETEDPARTIAL(12), CVJobState::COMPLETEDWITHWARNINGS(19)
                                 AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)),
        fullMediaSizeMB = (SELECT CAST(ISNULL(SUM((ISNULL(J.dataPhysicalSize, 0) + ISNULL(J.logPhysicalSize, 0))* 1.0 / 1024) / 1024, 0) AS INT)
						   FROM   #JobActivity_tmp__Jobs J
						   WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                 AND (J.appTypeId = #JobActivity_tmp__Aggregate.entityId)
                                 AND (dbo.IsBackupLevelFull(J.bkpLevel) = 1)
                                 -- CVJobStatus::JMSUCCESS(1), CVJobStatus::PARTIALSUCCESS(3), CVJobStatus::JMSUCCESSWITHWARNINGS(14)
                                 -- CVJobState::COMPLETED(4), CVJobState::COMPLETEDSUCCESS(9), CVJobState::COMPLETEDPARTIAL(12), CVJobState::COMPLETEDWITHWARNINGS(19)
                                 AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)),
        otherMediaSizeMB = (SELECT CAST(ISNULL(SUM((ISNULL(J.dataPhysicalSize, 0) + ISNULL(J.logPhysicalSize, 0))* 1.0 / 1024) / 1024, 0) AS INT)
						   FROM   #JobActivity_tmp__Jobs J
						   WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                 AND (J.appTypeId = #JobActivity_tmp__Aggregate.entityId)
                                 AND (dbo.IsBackupLevelFull(J.bkpLevel) = 0)
                                 -- CVJobStatus::JMSUCCESS(1), CVJobStatus::PARTIALSUCCESS(3), CVJobStatus::JMSUCCESSWITHWARNINGS(14)
                                 -- CVJobState::COMPLETED(4), CVJobState::COMPLETEDSUCCESS(9), CVJobState::COMPLETEDPARTIAL(12), CVJobState::COMPLETEDWITHWARNINGS(19)
                                 AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)),
	    numCompleted    = (SELECT COUNT(*)
                           FROM   #JobActivity_tmp__Jobs J
                           WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                  AND (J.appTypeId = #JobActivity_tmp__Aggregate.entityId)
                                 -- CVJobStatus::JMSUCCESS(1), CVJobStatus::PARTIALSUCCESS(3), CVJobStatus::JMSUCCESSWITHWARNINGS(14)
                                 -- CVJobState::COMPLETED(4), CVJobState::COMPLETEDSUCCESS(9), CVJobState::COMPLETEDPARTIAL(12), CVJobState::COMPLETEDWITHWARNINGS(19)
                                 AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)
                                 AND J.attemptFailures < 2),
        numCompletedMulAttmpts =
                          (SELECT COUNT(*)
                           FROM   #JobActivity_tmp__Jobs J
                           WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                  AND (J.appTypeId = #JobActivity_tmp__Aggregate.entityId)
                                  -- CVJobStatus::JMSUCCESS=1, CVJobStatus::PARTIALSUCCESS=3, CVJobState::COMPLETEDPARTIAL=14
                                  -- CVJobState::COMPLETED=4, CVJobState::COMPLETEDSUCCESS=9, CVJobState::COMPLETEDPARTIAL=12, CVJobState::COMPLETEDWITHWARNINGS = 19
                                  AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)
                                  AND J.attemptFailures > 1),
        numFailed       = (SELECT COUNT(*)
                           FROM   #JobActivity_tmp__Jobs J
                           WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                  AND (J.appTypeId = #JobActivity_tmp__Aggregate.entityId)
                                  -- CVJobStatus::FAIL(2), CVJobStatus::DROPPED(9), CVJobStatus::SYSTEMFAILED(15)
                                  -- CVJobState::COMPLETEDFAIL(10)
                                  AND J.[status] IN (2, 9, 15, 110) ),
        numKilled       = (SELECT COUNT(*)
                           FROM   #JobActivity_tmp__Jobs J
                           WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                  AND (J.appTypeId = #JobActivity_tmp__Aggregate.entityId)
                                  -- CVJobState::KILLPENDING(6), CVJobState::STATEKILLED(11), CVJobState::SYSTEMKILLPENDING(13)
                                  -- CVJobStatus::KILLED(4)
                                  AND J.[status] IN (4, 106, 111, 113) )
END ELSE IF @groupBy = 3 BEGIN   -- media
    INSERT INTO #JobActivity_tmp__Aggregate
        SELECT  DISTINCT 0,
                AG.id, AG.name, (CASE WHEN AG.origCCcommCellID = 0 THEN 2 ELSE AG.origCCcommCellID END),
                (SELECT aliasName FROM APP_CommCell WHERE id = (CASE WHEN AG.origCCcommCellID = 0 THEN 2 ELSE AG.origCCcommCellID END)), NULL,
                P.dayNum, P.dayRefStartUnix, P.dayRefEndUnix,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    -- groupBy specific. populated in next statement
                0, 0, 0, 0                          -- common: will be calculated later
        FROM    archGroup AG INNER JOIN #JobActivity_tmp__Periods P ON P.commCellId = (CASE WHEN AG.origCCcommCellID = 0 THEN 2 ELSE AG.origCCcommCellID END)
        WHERE   AG.id <> 1
    UPDATE #JobActivity_tmp__Aggregate SET
        fullDataSizeMB =  (SELECT CAST(ISNULL(SUM((ISNULL(J.dataLogicalSize, 0) + ISNULL(J.logLogicalSize, 0))* 1.0 / 1024) / 1024, 0) AS INT)
						   FROM   #JobActivity_tmp__Jobs J
						   WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                 AND (#JobActivity_tmp__Aggregate.entityId IN (J.logStorageId, J.dataStorageId) )
                                 AND (dbo.IsBackupLevelFull(J.bkpLevel) = 1)
                                 -- CVJobStatus::JMSUCCESS(1), CVJobStatus::PARTIALSUCCESS(3), CVJobStatus::JMSUCCESSWITHWARNINGS(14)
                                 -- CVJobState::COMPLETED(4), CVJobState::COMPLETEDSUCCESS(9), CVJobState::COMPLETEDPARTIAL(12), CVJobState::COMPLETEDWITHWARNINGS(19)
                                 AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)),
	    otherDataSizeMB = (SELECT CAST(ISNULL(SUM((ISNULL(J.dataLogicalSize, 0) + ISNULL(J.logLogicalSize, 0))* 1.0 / 1024) / 1024, 0) AS INT)
						   FROM   #JobActivity_tmp__Jobs J
						   WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                 AND (#JobActivity_tmp__Aggregate.entityId IN (J.logStorageId, J.dataStorageId) )
                                 AND (dbo.IsBackupLevelFull(J.bkpLevel) = 0)
                                 -- CVJobStatus::JMSUCCESS(1), CVJobStatus::PARTIALSUCCESS(3), CVJobStatus::JMSUCCESSWITHWARNINGS(14)
                                 -- CVJobState::COMPLETED(4), CVJobState::COMPLETEDSUCCESS(9), CVJobState::COMPLETEDPARTIAL(12), CVJobState::COMPLETEDWITHWARNINGS(19)
                                 AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)),
        fullMediaSizeMB = (SELECT CAST(ISNULL(SUM((ISNULL(J.dataPhysicalSize, 0) + ISNULL(J.logPhysicalSize, 0))* 1.0 / 1024) / 1024, 0) AS INT)
						   FROM   #JobActivity_tmp__Jobs J
						   WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                 AND (#JobActivity_tmp__Aggregate.entityId IN (J.logStorageId, J.dataStorageId) )
                                 AND (dbo.IsBackupLevelFull(J.bkpLevel) = 1)
                                 -- CVJobStatus::JMSUCCESS(1), CVJobStatus::PARTIALSUCCESS(3), CVJobStatus::JMSUCCESSWITHWARNINGS(14)
                                 -- CVJobState::COMPLETED(4), CVJobState::COMPLETEDSUCCESS(9), CVJobState::COMPLETEDPARTIAL(12), CVJobState::COMPLETEDWITHWARNINGS(19)
                                 AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)),
        otherMediaSizeMB =(SELECT CAST(ISNULL(SUM((ISNULL(J.dataPhysicalSize, 0) + ISNULL(J.logPhysicalSize, 0))* 1.0 / 1024) / 1024, 0) AS INT)
						   FROM   #JobActivity_tmp__Jobs J
						   WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                 AND (#JobActivity_tmp__Aggregate.entityId IN (J.logStorageId, J.dataStorageId) )
                                 AND (dbo.IsBackupLevelFull(J.bkpLevel) = 0)
                                 -- CVJobStatus::JMSUCCESS(1), CVJobStatus::PARTIALSUCCESS(3), CVJobStatus::JMSUCCESSWITHWARNINGS(14)
                                 -- CVJobState::COMPLETED(4), CVJobState::COMPLETEDSUCCESS(9), CVJobState::COMPLETEDPARTIAL(12), CVJobState::COMPLETEDWITHWARNINGS(19)
                                 AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)),
	    numCompleted    = (SELECT COUNT(*)
                           FROM   #JobActivity_tmp__Jobs J
                           WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                  AND (#JobActivity_tmp__Aggregate.entityId IN (J.logStorageId, J.dataStorageId) )
                                 -- CVJobStatus::JMSUCCESS(1), CVJobStatus::PARTIALSUCCESS(3), CVJobStatus::JMSUCCESSWITHWARNINGS(14)
                                 -- CVJobState::COMPLETED(4), CVJobState::COMPLETEDSUCCESS(9), CVJobState::COMPLETEDPARTIAL(12), CVJobState::COMPLETEDWITHWARNINGS(19)
                                 AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)
                                 AND J.attemptFailures < 2),
        numCompletedMulAttmpts =
                          (SELECT COUNT(*)
                           FROM   #JobActivity_tmp__Jobs J
                           WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                  AND (#JobActivity_tmp__Aggregate.entityId IN (J.logStorageId, J.dataStorageId) )
                                  -- CVJobStatus::JMSUCCESS=1, CVJobStatus::PARTIALSUCCESS=3, CVJobState::COMPLETEDPARTIAL=14
                                  -- CVJobState::COMPLETED=4, CVJobState::COMPLETEDSUCCESS=9, CVJobState::COMPLETEDPARTIAL=12, CVJobState::COMPLETEDWITHWARNINGS = 19
                                  AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)
                                  AND J.attemptFailures > 1),
        numFailed       = (SELECT COUNT(*)
                           FROM   #JobActivity_tmp__Jobs J
                           WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                  AND (#JobActivity_tmp__Aggregate.entityId IN (J.logStorageId, J.dataStorageId) )
                                  -- CVJobStatus::FAIL(2), CVJobStatus::DROPPED(9), CVJobStatus::SYSTEMFAILED(15)
                                  -- CVJobState::COMPLETEDFAIL(10)
                                  AND J.[status] IN (2, 9, 15, 110) ),
        numKilled       = (SELECT COUNT(*)
                           FROM   #JobActivity_tmp__Jobs J
                           WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                  AND (#JobActivity_tmp__Aggregate.entityId IN (J.logStorageId, J.dataStorageId) )
                                  -- CVJobState::KILLPENDING(6), CVJobState::STATEKILLED(11), CVJobState::SYSTEMKILLPENDING(13)
                                  -- CVJobStatus::KILLED(4)
                                  AND J.[status] IN (4, 106, 111, 113) )
END ELSE IF @groupBy = 4 BEGIN   -- group
    INSERT INTO #JobActivity_tmp__Aggregate
        SELECT  DISTINCT 0,
                CG.groupId, CG.groupName, CG.commCellId, CG.groupName, NULL,
                P.dayNum, P.dayRefStartUnix, P.dayRefEndUnix,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    -- groupBy specific. populated in next statement
                0, 0, 0, 0                          -- common: will be calculated later
        FROM    (SELECT DISTINCT  commCellId, commCellName,  groupId, groupName
	             FROM   #JobActivity_tmp__Entity
	             WHERE  groupId <> 0 ) CG INNER JOIN #JobActivity_tmp__Periods P ON P.commCellId = CG.commCellId
    UPDATE #JobActivity_tmp__Aggregate SET
        fullDataSizeMB =  (SELECT CAST(ISNULL(SUM((ISNULL(J.dataLogicalSize, 0) + ISNULL(J.logLogicalSize, 0))* 1.0 / 1024) / 1024, 0) AS INT)
						   FROM   #JobActivity_tmp__Jobs J
						   WHERE     (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
						         AND (J.clientId IN (SELECT clientId FROM APP_ClientGroupAssoc WHERE clientGroupId = #JobActivity_tmp__Aggregate.entityId))
                                 AND (dbo.IsBackupLevelFull(J.bkpLevel) = 1)
                                 -- CVJobStatus::JMSUCCESS(1), CVJobStatus::PARTIALSUCCESS(3), CVJobStatus::JMSUCCESSWITHWARNINGS(14)
                                 -- CVJobState::COMPLETED(4), CVJobState::COMPLETEDSUCCESS(9), CVJobState::COMPLETEDPARTIAL(12), CVJobState::COMPLETEDWITHWARNINGS(19)
                                 AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)),
	    otherDataSizeMB = (SELECT CAST(ISNULL(SUM((ISNULL(J.dataLogicalSize, 0) + ISNULL(J.logLogicalSize, 0))* 1.0 / 1024) / 1024, 0) AS INT)
						   FROM   #JobActivity_tmp__Jobs J
						   WHERE     (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
						         AND (J.clientId IN (SELECT clientId FROM APP_ClientGroupAssoc WHERE clientGroupId = #JobActivity_tmp__Aggregate.entityId))
                                 AND (dbo.IsBackupLevelFull(J.bkpLevel) = 0)
                                 -- CVJobStatus::JMSUCCESS(1), CVJobStatus::PARTIALSUCCESS(3), CVJobStatus::JMSUCCESSWITHWARNINGS(14)
                                 -- CVJobState::COMPLETED(4), CVJobState::COMPLETEDSUCCESS(9), CVJobState::COMPLETEDPARTIAL(12), CVJobState::COMPLETEDWITHWARNINGS(19)
                                 AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)),
        fullMediaSizeMB = (SELECT CAST(ISNULL(SUM((ISNULL(J.dataPhysicalSize, 0) + ISNULL(J.logPhysicalSize, 0))* 1.0 / 1024) / 1024, 0) AS INT)
						   FROM   #JobActivity_tmp__Jobs J
						   WHERE     (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
						         AND (J.clientId IN (SELECT clientId FROM APP_ClientGroupAssoc WHERE clientGroupId = #JobActivity_tmp__Aggregate.entityId))
                                 AND (dbo.IsBackupLevelFull(J.bkpLevel) = 1)
                                 -- CVJobStatus::JMSUCCESS(1), CVJobStatus::PARTIALSUCCESS(3), CVJobStatus::JMSUCCESSWITHWARNINGS(14)
                                 -- CVJobState::COMPLETED(4), CVJobState::COMPLETEDSUCCESS(9), CVJobState::COMPLETEDPARTIAL(12), CVJobState::COMPLETEDWITHWARNINGS(19)
                                 AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)),
        otherMediaSizeMB =(SELECT CAST(ISNULL(SUM((ISNULL(J.dataPhysicalSize, 0) + ISNULL(J.logPhysicalSize, 0))* 1.0 / 1024) / 1024, 0) AS INT)
						   FROM   #JobActivity_tmp__Jobs J
						   WHERE     (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
						         AND (J.clientId IN (SELECT clientId FROM APP_ClientGroupAssoc WHERE clientGroupId = #JobActivity_tmp__Aggregate.entityId))
                                 AND (dbo.IsBackupLevelFull(J.bkpLevel) = 0)
                                 -- CVJobStatus::JMSUCCESS(1), CVJobStatus::PARTIALSUCCESS(3), CVJobStatus::JMSUCCESSWITHWARNINGS(14)
                                 -- CVJobState::COMPLETED(4), CVJobState::COMPLETEDSUCCESS(9), CVJobState::COMPLETEDPARTIAL(12), CVJobState::COMPLETEDWITHWARNINGS(19)
                                 AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)),
	    numCompleted    = (SELECT COUNT(*)
                           FROM   #JobActivity_tmp__Jobs J
                           WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                  AND (J.clientId IN (SELECT clientId FROM APP_ClientGroupAssoc WHERE clientGroupId = #JobActivity_tmp__Aggregate.entityId))
                                 -- CVJobStatus::JMSUCCESS(1), CVJobStatus::PARTIALSUCCESS(3), CVJobStatus::JMSUCCESSWITHWARNINGS(14)
                                 -- CVJobState::COMPLETED(4), CVJobState::COMPLETEDSUCCESS(9), CVJobState::COMPLETEDPARTIAL(12), CVJobState::COMPLETEDWITHWARNINGS(19)
                                 AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)
                                 AND J.attemptFailures < 2),
        numCompletedMulAttmpts =
                          (SELECT COUNT(*)
                           FROM   #JobActivity_tmp__Jobs J
                           WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                  AND (J.clientId IN (SELECT clientId FROM APP_ClientGroupAssoc WHERE clientGroupId = #JobActivity_tmp__Aggregate.entityId))
                                  -- CVJobStatus::JMSUCCESS=1, CVJobStatus::PARTIALSUCCESS=3, CVJobState::COMPLETEDPARTIAL=14
                                  -- CVJobState::COMPLETED=4, CVJobState::COMPLETEDSUCCESS=9, CVJobState::COMPLETEDPARTIAL=12, CVJobState::COMPLETEDWITHWARNINGS = 19
                                  AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)
                                  AND J.attemptFailures > 1),
        numFailed       = (SELECT COUNT(*)
                           FROM   #JobActivity_tmp__Jobs J
                           WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                  AND (J.clientId IN (SELECT clientId FROM APP_ClientGroupAssoc WHERE clientGroupId = #JobActivity_tmp__Aggregate.entityId))
                                  -- CVJobStatus::FAIL(2), CVJobStatus::DROPPED(9), CVJobStatus::SYSTEMFAILED(15)
                                  -- CVJobState::COMPLETEDFAIL(10)
                                  AND J.[status] IN (2, 9, 15, 110) ),
        numKilled       = (SELECT COUNT(*)
                           FROM   #JobActivity_tmp__Jobs J
                           WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                  AND (J.clientId IN (SELECT clientId FROM APP_ClientGroupAssoc WHERE clientGroupId = #JobActivity_tmp__Aggregate.entityId))
                                  -- CVJobState::KILLPENDING(6), CVJobState::STATEKILLED(11), CVJobState::SYSTEMKILLPENDING(13)
                                  -- CVJobStatus::KILLED(4)
                                  AND J.[status] IN (4, 106, 111, 113) )
END ELSE BEGIN                  -- commcell
    INSERT INTO #JobActivity_tmp__Aggregate
        SELECT  DISTINCT 0,
                CL.commCellId, CL.commCellName, CL.commCellId, CL.commCellName, NULL,
                P.dayNum, P.dayRefStartUnix, P.dayRefEndUnix,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,    -- groupBy specific. populated in next statement
                0, 0, 0, 0                          -- common: will be calculated later
        FROM    #JobActivity_tmp__Entity CL INNER JOIN #JobActivity_tmp__Periods P ON P.commCellId = CL.commCellId
    UPDATE #JobActivity_tmp__Aggregate SET
        fullDataSizeMB =  (SELECT CAST(ISNULL(SUM((ISNULL(J.dataLogicalSize, 0) + ISNULL(J.logLogicalSize, 0))* 1.0 / 1024) / 1024, 0) AS INT)
						   FROM   #JobActivity_tmp__Jobs J
						   WHERE     (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
						         AND (J.commCellId = #JobActivity_tmp__Aggregate.commcellId)
                                 AND (dbo.IsBackupLevelFull(J.bkpLevel) = 1)
                                 -- CVJobStatus::JMSUCCESS(1), CVJobStatus::PARTIALSUCCESS(3), CVJobStatus::JMSUCCESSWITHWARNINGS(14)
                                 -- CVJobState::COMPLETED(4), CVJobState::COMPLETEDSUCCESS(9), CVJobState::COMPLETEDPARTIAL(12), CVJobState::COMPLETEDWITHWARNINGS(19)
                                 AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)),
	    otherDataSizeMB = (SELECT CAST(ISNULL(SUM((ISNULL(J.dataLogicalSize, 0) + ISNULL(J.logLogicalSize, 0))* 1.0 / 1024) / 1024, 0) AS INT)
						   FROM   #JobActivity_tmp__Jobs J
						   WHERE     (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
						         AND (J.commCellId = #JobActivity_tmp__Aggregate.commcellId)
                                 AND (dbo.IsBackupLevelFull(J.bkpLevel) = 0)
                                 -- CVJobStatus::JMSUCCESS(1), CVJobStatus::PARTIALSUCCESS(3), CVJobStatus::JMSUCCESSWITHWARNINGS(14)
                                 -- CVJobState::COMPLETED(4), CVJobState::COMPLETEDSUCCESS(9), CVJobState::COMPLETEDPARTIAL(12), CVJobState::COMPLETEDWITHWARNINGS(19)
                                 AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)),
        fullMediaSizeMB = (SELECT CAST(ISNULL(SUM((ISNULL(J.dataPhysicalSize, 0) + ISNULL(J.logPhysicalSize, 0))* 1.0 / 1024) / 1024, 0) AS INT)
						   FROM   #JobActivity_tmp__Jobs J
						   WHERE     (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
						         AND (J.commCellId = #JobActivity_tmp__Aggregate.commcellId)
                                 AND (dbo.IsBackupLevelFull(J.bkpLevel) = 1)
                                 -- CVJobStatus::JMSUCCESS(1), CVJobStatus::PARTIALSUCCESS(3), CVJobStatus::JMSUCCESSWITHWARNINGS(14)
                                 -- CVJobState::COMPLETED(4), CVJobState::COMPLETEDSUCCESS(9), CVJobState::COMPLETEDPARTIAL(12), CVJobState::COMPLETEDWITHWARNINGS(19)
                                 AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)),
        otherMediaSizeMB =(SELECT CAST(ISNULL(SUM((ISNULL(J.dataPhysicalSize, 0) + ISNULL(J.logPhysicalSize, 0))* 1.0 / 1024) / 1024, 0) AS INT)
						   FROM   #JobActivity_tmp__Jobs J
						   WHERE     (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
						         AND (J.commCellId = #JobActivity_tmp__Aggregate.commcellId)
                                 AND (dbo.IsBackupLevelFull(J.bkpLevel) = 0)
                                 -- CVJobStatus::JMSUCCESS(1), CVJobStatus::PARTIALSUCCESS(3), CVJobStatus::JMSUCCESSWITHWARNINGS(14)
                                 -- CVJobState::COMPLETED(4), CVJobState::COMPLETEDSUCCESS(9), CVJobState::COMPLETEDPARTIAL(12), CVJobState::COMPLETEDWITHWARNINGS(19)
                                 AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)),
	    numCompleted    = (SELECT COUNT(*)
                           FROM   #JobActivity_tmp__Jobs J
                           WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                  AND (J.commCellId = #JobActivity_tmp__Aggregate.commcellId)
                                  -- CVJobStatus::JMSUCCESS(1), CVJobStatus::PARTIALSUCCESS(3), CVJobStatus::JMSUCCESSWITHWARNINGS(14)
                                  -- CVJobState::COMPLETED(4), CVJobState::COMPLETEDSUCCESS(9), CVJobState::COMPLETEDPARTIAL(12), CVJobState::COMPLETEDWITHWARNINGS(19)
                                  AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)
                                  AND J.attemptFailures < 2),
        numCompletedMulAttmpts =
                          (SELECT COUNT(*)
                           FROM   #JobActivity_tmp__Jobs J
                           WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                  AND (J.commCellId = #JobActivity_tmp__Aggregate.commcellId)
                                  -- CVJobStatus::JMSUCCESS=1, CVJobStatus::PARTIALSUCCESS=3, CVJobState::COMPLETEDPARTIAL=14
                                  -- CVJobState::COMPLETED=4, CVJobState::COMPLETEDSUCCESS=9, CVJobState::COMPLETEDPARTIAL=12, CVJobState::COMPLETEDWITHWARNINGS = 19
                                  AND J.[status] IN (1, 3, 14, 104, 109, 112, 119)
                                  AND J.attemptFailures > 1),
        numFailed       = (SELECT COUNT(*)
                           FROM   #JobActivity_tmp__Jobs J
                           WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                  AND (J.commCellId = #JobActivity_tmp__Aggregate.commcellId)
                                  -- CVJobStatus::FAIL(2), CVJobStatus::DROPPED(9), CVJobStatus::SYSTEMFAILED(15)
                                  -- CVJobState::COMPLETEDFAIL(10)
                                  AND J.[status] IN (2, 9, 15, 110) ),
        numKilled       = (SELECT COUNT(*)
                           FROM   #JobActivity_tmp__Jobs J
                           WHERE      (J.startTime BETWEEN #JobActivity_tmp__Aggregate.periodStartTime AND #JobActivity_tmp__Aggregate.periodEndTime)
                                  AND (J.commCellId = #JobActivity_tmp__Aggregate.commcellId)
                                  -- CVJobState::KILLPENDING(6), CVJobState::STATEKILLED(11), CVJobState::SYSTEMKILLPENDING(13)
                                  -- CVJobStatus::KILLED(4)
                                  AND J.[status] IN (4, 106, 111, 113) )
END
-- update total jobs column
UPDATE #JobActivity_tmp__Aggregate SET
    numTotal = numCompleted + numCompletedMulAttmpts + numFailed + numKilled,
    totalDataSizeMB = fullDataSizeMB + otherDataSizeMB,
    totalMediaSizeMB = fullMediaSizeMB + otherMediaSizeMB
-- by entity aggregation
INSERT INTO #JobActivity_tmp__Aggregate
    SELECT  1, entityId, entityName, commcellId, commcellName, NULL, NULL,
            MIN(periodStartTime), MAX(periodEndTime),
            SUM(fullDataSizeMB), SUM(otherDataSizeMB), SUM(totalDataSizeMB), SUM(fullMediaSizeMB), SUM(otherMediaSizeMB), SUM(totalMediaSizeMB),
            SUM(numCompleted), SUM(numCompletedMulAttmpts), SUM(numFailed), SUM(numKilled), SUM(numTotal),
            0, 0, 0, 0
    FROM    #JobActivity_tmp__Aggregate
    WHERE   aggregateType = 0
    GROUP   BY entityId, entityName, commcellId, commcellName
-- overall aggregation by day
INSERT INTO #JobActivity_tmp__Aggregate
    SELECT  2, -1, N'All', NULL, NULL, NULL, NULL,
            periodStartTime, periodEndTime,
            SUM(fullDataSizeMB), SUM(otherDataSizeMB), SUM(totalDataSizeMB), SUM(fullMediaSizeMB), SUM(otherMediaSizeMB), SUM(totalMediaSizeMB),
            SUM(numCompleted), SUM(numCompletedMulAttmpts), SUM(numFailed), SUM(numKilled), SUM(numTotal),
            0, 0, 0, 0
    FROM    #JobActivity_tmp__Aggregate
    WHERE   aggregateType = 0
    GROUP   BY periodStartTime, periodEndTime
-- overall
INSERT INTO #JobActivity_tmp__Aggregate
    SELECT  3, -1, N'All', NULL, NULL, NULL, NULL,
            MIN(periodStartTime), MAX(periodEndTime),
            SUM(fullDataSizeMB), SUM(otherDataSizeMB), SUM(totalDataSizeMB), SUM(fullMediaSizeMB), SUM(otherMediaSizeMB), SUM(totalMediaSizeMB),
            SUM(numCompleted), SUM(numCompletedMulAttmpts), SUM(numFailed), SUM(numKilled), SUM(numTotal),
            0, 0, 0, 0
    FROM    #JobActivity_tmp__Aggregate
    WHERE   aggregateType = 2
-- calculate percentage values
UPDATE #JobActivity_tmp__Aggregate
SET     numCompletedPer           = (CASE WHEN numTotal = 0 THEN 0 ELSE dbo.RoundPercent(CAST(numCompleted * 10000.0 AS FLOAT)          / CAST(numTotal AS FLOAT), 3) END),
        numCompletedMulAttmptsPer = (CASE WHEN numTotal = 0 THEN 0 ELSE dbo.RoundPercent(CAST(numCompletedMulAttmpts * 10000.0 AS FLOAT)/ CAST(numTotal AS FLOAT), 3) END),
        numFailedPer              = (CASE WHEN numTotal = 0 THEN 0 ELSE dbo.RoundPercent(CAST(numFailed * 10000.0 AS FLOAT)             / CAST(numTotal AS FLOAT), 3) END),
        numKilledPer              = (CASE WHEN numTotal = 0 THEN 0 ELSE dbo.RoundPercent(CAST(numKilled * 10000.0 AS FLOAT)             / CAST(numTotal AS FLOAT), 3) END)
IF @debug <> 0 SELECT 'by entity by day',   * FROM #JobActivity_tmp__Aggregate WHERE aggregateType = 0 ORDER BY entityId, periodStartTime
IF @debug <> 0 SELECT 'by entity',          * FROM #JobActivity_tmp__Aggregate WHERE aggregateType = 1 ORDER BY entityId, periodStartTime
IF @debug <> 0 SELECT 'overall by day',     * FROM #JobActivity_tmp__Aggregate WHERE aggregateType = 2 ORDER BY entityId, periodStartTime
IF @debug <> 0 SELECT 'overall',            * FROM #JobActivity_tmp__Aggregate WHERE aggregateType = 3 ORDER BY entityId, periodStartTime
-----------------------------------------------------------------------------------------------------------------------
SELECT
    (SELECT @timeFrameType               AS '@timeFrameType',
            @frequency                   AS '@frequency',
            @numberOfPeriods             AS '@numberOfPeriods',
            @reqStartTime                AS '@reqStartTime',
            @reqEndTime                  AS '@reqEndTime',
            @includeCurrentPeriod        AS '@includeCurrentPeriod',
            @treatWeekend                AS '@treatWeekend',
            @includeLogDeletedClients    AS '@includeLogDeletedClients',
            @includeLogDeletedSubclients AS '@includeLogDeletedSubclients',
            @groupBy                     AS '@groupBy',
            @userId                      AS '@userId',
            @localeId                    AS '@localeId',
            @drill                       AS '@drill',
            @includeAllEntities          AS '@includeAllEntities'
     FOR XML PATH('request'),TYPE),
    (SELECT AOO.entityId                    AS '@entityId',
            AOO.entityName                  AS '@entityName',
            AOO.commcellId                  AS '@commcellId',
            AOO.commcellName                AS '@commcellName',
            (SELECT AOO.fullDataSizeMB              AS '@fullDataSizeMB',
                    AOO.otherDataSizeMB             AS '@otherDataSizeMB',
                    AOO.totalDataSizeMB             AS '@totalDataSizeMB',
                    AOO.fullMediaSizeMB             AS '@fullMediaSizeMB',
                    AOO.otherMediaSizeMB            AS '@otherMediaSizeMB',
                    AOO.totalMediaSizeMB            AS '@totalMediaSizeMB',
                    AOO.numCompleted                AS '@numCompleted',
                    AOO.numCompletedMulAttmpts      AS '@numCompletedMulAttmpts',
                    AOO.numFailed                   AS '@numFailed',
                    AOO.numKilled                   AS '@numKilled',
                    AOO.numTotal                    AS '@numTotal',
                    AOO.numCompletedPer             AS '@numCompletedPer',
                    AOO.numCompletedMulAttmptsPer   AS '@numCompletedMulAttmptsPer',
                    AOO.numFailedPer                AS '@numFailedPer',
                    AOO.numKilledPer                AS '@numKilledPer'
             FOR    XML PATH('aggregate'),TYPE),
            (SELECT AOP.dayNo               AS '@dayNo',
                    AOP.periodStartTime     AS '@periodStartTime',
                    AOP.periodEndTime       AS '@periodEndTime',
                    (SELECT AOP.fullDataSizeMB              AS '@fullDataSizeMB',
                            AOP.otherDataSizeMB             AS '@otherDataSizeMB',
                            AOP.totalDataSizeMB             AS '@totalDataSizeMB',
                            AOP.fullMediaSizeMB             AS '@fullMediaSizeMB',
                            AOP.otherMediaSizeMB            AS '@otherMediaSizeMB',
                            AOP.totalMediaSizeMB            AS '@totalMediaSizeMB',
                            AOP.numCompleted                AS '@numCompleted',
                            AOP.numCompletedMulAttmpts      AS '@numCompletedMulAttmpts',
                            AOP.numFailed                   AS '@numFailed',
                            AOP.numKilled                   AS '@numKilled',
                            AOP.numTotal                    AS '@numTotal',
                            AOP.numCompletedPer             AS '@numCompletedPer',
                            AOP.numCompletedMulAttmptsPer   AS '@numCompletedMulAttmptsPer',
                            AOP.numFailedPer                AS '@numFailedPer',
                            AOP.numKilledPer                AS '@numKilledPer'
                     FOR    XML PATH('stats'),TYPE)
             FROM   #JobActivity_tmp__Aggregate AOP
             WHERE  AOP.aggregateType = 2
             FOR    XML PATH('periods'),TYPE)
     FROM   #JobActivity_tmp__Aggregate AOO
     WHERE  AOO.aggregateType = 3
     FOR    XML PATH('overall'),TYPE),
    (SELECT AOE.entityId                    AS '@entityId',
            AOE.entityName                  AS '@entityName',
            AOE.commcellId                  AS '@commcellId',
            AOE.commcellName                AS '@commcellName',
            (SELECT AOE.fullDataSizeMB              AS '@fullDataSizeMB',
                    AOE.otherDataSizeMB             AS '@otherDataSizeMB',
                    AOE.totalDataSizeMB             AS '@totalDataSizeMB',
                    AOE.fullMediaSizeMB             AS '@fullMediaSizeMB',
                    AOE.otherMediaSizeMB            AS '@otherMediaSizeMB',
                    AOE.totalMediaSizeMB            AS '@totalMediaSizeMB',
                    AOE.numCompleted                AS '@numCompleted',
                    AOE.numCompletedMulAttmpts      AS '@numCompletedMulAttmpts',
                    AOE.numFailed                   AS '@numFailed',
                    AOE.numKilled                   AS '@numKilled',
                    AOE.numTotal                    AS '@numTotal',
                    AOE.numCompletedPer             AS '@numCompletedPer',
                    AOE.numCompletedMulAttmptsPer   AS '@numCompletedMulAttmptsPer',
                    AOE.numFailedPer                AS '@numFailedPer',
                    AOE.numKilledPer                AS '@numKilledPer'
             FOR    XML PATH('aggregate'),TYPE),
            (SELECT AOED.dayNo               AS '@dayNo',
                    AOED.periodStartTime     AS '@periodStartTime',
                    AOED.periodEndTime       AS '@periodEndTime',
                    (SELECT AOED.fullDataSizeMB              AS '@fullDataSizeMB',
                            AOED.otherDataSizeMB             AS '@otherDataSizeMB',
                            AOED.totalDataSizeMB             AS '@totalDataSizeMB',
                            AOED.fullMediaSizeMB             AS '@fullMediaSizeMB',
                            AOED.otherMediaSizeMB            AS '@otherMediaSizeMB',
                            AOED.totalMediaSizeMB            AS '@totalMediaSizeMB',
                            AOED.numCompleted                AS '@numCompleted',
                            AOED.numCompletedMulAttmpts      AS '@numCompletedMulAttmpts',
                            AOED.numFailed                   AS '@numFailed',
                            AOED.numKilled                   AS '@numKilled',
                            AOED.numTotal                    AS '@numTotal',
                            AOED.numCompletedPer             AS '@numCompletedPer',
                            AOED.numCompletedMulAttmptsPer   AS '@numCompletedMulAttmptsPer',
                            AOED.numFailedPer                AS '@numFailedPer',
                            AOED.numKilledPer                AS '@numKilledPer'
                    FOR    XML PATH('stats'),TYPE)
             FROM   #JobActivity_tmp__Aggregate AOED
             WHERE  AOED.aggregateType = 0 AND AOED.entityId = AOE.entityId
             FOR    XML PATH('periods'),TYPE)
     FROM   #JobActivity_tmp__Aggregate AOE
     WHERE  AOE.aggregateType = 1
     FOR    XML PATH('entity'),TYPE)
FOR XML PATH ('WebReport_ActivityReport')
IF @stats <> 0 AND @debug <> 0  BEGIN
    SELECT * FROM #JobActivity_tmp__Stats
END
IF OBJECT_ID('tempdb.dbo.#JobActivity_tmp__Periods')                IS NOT null DROP TABLE #JobActivity_tmp__Periods
IF OBJECT_ID('tempdb.dbo.#JobActivity_tmp__CommCellTimeRanges')     IS NOT null DROP TABLE #JobActivity_tmp__CommCellTimeRanges
IF OBJECT_ID('tempdb.dbo.#JobActivity_tmp__EntityId')               IS NOT null DROP TABLE #JobActivity_tmp__EntityId
IF OBJECT_ID('tempdb.dbo.#JobActivity_tmp__Entity')                 IS NOT null DROP TABLE #JobActivity_tmp__Entity
IF OBJECT_ID('tempdb.dbo.#JobActivity_tmp__Aggregate')              IS NOT null DROP TABLE #JobActivity_tmp__Aggregate
IF OBJECT_ID('tempdb.dbo.#JobActivity_tmp__Jobs')                   IS NOT null DROP TABLE #JobActivity_tmp__Jobs
IF OBJECT_ID('tempdb.dbo.#JobActivity_tmp__Stats')                  IS NOT null DROP TABLE #JobActivity_tmp__Stats
GO

IF EXISTS (select * from GxQscripts where name = 'wr_JobActivity')
	delete from GxQscripts where name = 'wr_JobActivity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_JobActivity')
	delete from GXDBVersions where aliasname = 'wr_JobActivity'
GO

insert into GXDBVersions values(2, 'wr_JobActivity',  '00010004000000000000', 'wr_JobActivity', '00010004000000000000')
GO

