

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_GetSearchServerInfo.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_GetSearchServerInfo <<<'

IF EXISTS (select * from sysobjects where name='wr_GetSearchServerInfo')
	drop procedure wr_GetSearchServerInfo
IF EXISTS (select * from GxQscripts where name='wr_GetSearchServerInfo')
	delete from GxQscripts where name = 'wr_GetSearchServerInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_GetSearchServerInfo')
	delete from GXDBVersions where aliasname = 'wr_GetSearchServerInfo'
GO
print '... Creating Procedure: wr_GetSearchServerInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_GetSearchServerInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @request XML
AS
  DECLARE @response xml
/*
Message GetSearchServerInfoReq
{
     boolean             includeAll
}
Message SearchServerInfo
{
	ClientEntity		client
	boolean             isSelected
}
Message GetSearchServerInfoResp
{
     list<SearchServerInfo>    searchServer
     GenericResp          msg
}
*/
	DECLARE @includeAllEntities INT =0
	SET @includeAllEntities = @request.value('/WebReport_GetSearchServerInfoReq[1]/@includeAll', 'INT')
	declare @selectedClientId int  =0
	SET @selectedClientId =(select value from GXGlobalParam (NOLOCK) where name like 'AdvanceReportSearchClient' and modified =0)
	IF OBJECT_ID('tempdb..#clientTBL') IS NOT NULL
		DROP TABLE #clientTBL
	CREATE TABLE #clientTBL (clientId INT ,  engineName NVARCHAR(256))
DECLARE @AllReviewSetEngines TABLE
(
    ServiceLink     NVARCHAR(512),
    ClientId        INT,
    name            VARCHAR(256),
    cloudId         INT,
    net_hostname        NVARCHAR(256),
    portNo        INT,
    roleTypeVersion         VARCHAR(64),
    engineName NVARCHAR(256),
    serverType INT,
	indexServerClientId INT,
	internalCloudName NVARCHAR(256)
)
INSERT INTO @AllReviewSetEngines(ServiceLink, ClientId, name, cloudId, net_hostname, portNo, roleTypeVersion, engineName, serverType, indexServerClientId, internalCloudName)
EXEC DM2GetAllAnalyticsEngine 'Data Analytics',1
	INSERT INTO #clientTBL (clientId ,engineName)
		SELECT DISTINCT DM2.clientId, DM2.engineName  FROM @AllReviewSetEngines DM2
	DECLARE @SearchServerInfo XML = NULL
	SET @SearchServerInfo = (SELECT
			CASE WHEN T.clientId = @selectedClientId
						THEN 1
						ELSE 0 END AS '@isSelected',
			T.clientId AS 'client/@clientId',
			T.engineName AS 'client/@clientName'
			FROM #clientTBL T
			INNER JOIN APP_CLIENT (NOLOCK) C ON C.ID= T.clientId
			WHERE @includeAllEntities =1 OR T.clientId = @selectedClientId
    FOR XML PATH ('searchServer'))
	SET @response=( SELECT @SearchServerInfo
	FOR XML PATH ('WebReport_GetSearchServerInfoResp'))
	IF OBJECT_ID('tempdb..#clientTBL') IS NOT NULL
		DROP TABLE #clientTBL
	SELECT @response
GO

IF EXISTS (select * from GxQscripts where name = 'wr_GetSearchServerInfo')
	delete from GxQscripts where name = 'wr_GetSearchServerInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_GetSearchServerInfo')
	delete from GXDBVersions where aliasname = 'wr_GetSearchServerInfo'
GO

insert into GXDBVersions values(2, 'wr_GetSearchServerInfo',  '00010001000200080000', 'wr_GetSearchServerInfo', '00010001000200080000')
GO

