

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_GetProxyClientsAssociation.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='wr_GetProxyClientsAssociation')
BEGIN
	print '>>> Drop Stored Procedure: wr_GetProxyClientsAssociation <<<'
	drop procedure wr_GetProxyClientsAssociation
END
IF EXISTS (select * from GxQscripts where name='wr_GetProxyClientsAssociation')
	delete from GxQscripts where name = 'wr_GetProxyClientsAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_GetProxyClientsAssociation')
	delete from GXDBVersions where aliasname = 'wr_GetProxyClientsAssociation'
GO
print '... Creating Procedure: wr_GetProxyClientsAssociation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_GetProxyClientsAssociation
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_UserId INT = 0
AS
  DECLARE @response xml
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @tProxyClientsAssociationResp XML = NULL
IF object_id('tempdb.dbo.#tmpClient') IS NOT NULL drop table #tmpClient
create table #tmpClient
(   ClientId        integer,
    subclientId     integer,
    INSTANCE        integer,
    appTypeId       integer
)
DECLARE @ProxyFeatures TABLE ( clientid INT, ClientName NVARCHAR(255), proxyClientId INT, proxyClientName NVARCHAR(255))
IF object_id('tempdb.dbo.#ClientList') IS NOT NULL drop table #ClientList
CREATE TABLE #ClientList (
       id INT, ClientName NVARCHAR(255), Deleted INT, Rights INT, cvdPort INT, evmgrcPort INT,
       ClientGuid VARCHAR(40), ClientHostName NVARCHAR(255), clusterType INT, DisplayName NVARCHAR(255)
)
INSERT INTO #ClientList
EXEC getClientNameList @i_UserId, 0, 0, 0, 0, 0,0
INSERT INTO #tmpClient
SELECT DISTINCT cc.id,0,0,0 FROM  #ClientList cc left outer join simInstalledPackages sim with (NOLOCK) on cc.id = sim.clientId where sim.ClientId IS NULL
IF object_id('tempdb.dbo.#tmpClientProxyPairs') IS NOT NULL drop table #tmpClientProxyPairs
create table #tmpClientProxyPairs(ClientId  integer,
                        instanceId          integer,
                        proxyClientId       integer,
                        ClientAppType       integer,
                        isIndexServer       integer DEFAULT 0,
                        iscloudindexServer  integer DEFAULT 0,
                        cloudindexServer    integer DEFAULT 0,
                        isproxyclientGroup  integer DEFAULT 0 ,
                        clientGroup         integer DEFAULT 0,
                        subclientId         integer DEFAULT 0
                        )
IF exists (select * from #tmpClient)
    EXEC APPGetProxyClientInfo '#tmpClient','#tmpClientProxyPairs',1
INSERT INTO @ProxyFeatures(clientid,proxyClientId)
select DISTINCT PP.ClientId, PP.proxyClientId FROM #tmpClientProxyPairs PP
UPDATE PF
SET PF.ClientName = CC.displayName FROM
@ProxyFeatures PF INNER JOIN app_client CC with (NOLOCK)
ON PF.ClientId = CC.id
UPDATE PF
SET PF.proxyClientName = CC.displayName FROM
@ProxyFeatures PF INNER JOIN app_client CC with (NOLOCK)
ON PF.proxyClientId = CC.id
--Delete when there is no proxy anymore
DELETE FROM @ProxyFeatures WHERE proxyClientName IS NULL
SET @tProxyClientsAssociationResp = (select
					(SELECT DISTINCT PF.clientid AS 'clientId',
								PF.ClientName AS 'clientName'
								FOR XML PATH('clientInfo'), TYPE),
                    (select distinct PF.proxyClientId AS 'clientId',
						PF.proxyClientName AS 'clientName'
					FOR XML PATH('proxyClientInfo'), TYPE)
                    FROM @ProxyFeatures PF
FOR XML PATH('proxyClientsAssociations'))
SET @response =(SELECT @tProxyClientsAssociationResp for xml path( 'WebReport_GetProxyClientsAssociationResp')  )
SELECT @response as 'response'
DROP TABLE #ClientList
DROP TABLE #tmpClient
DROP TABLE #tmpClientProxyPairs
GO

IF EXISTS (select * from GxQscripts where name = 'wr_GetProxyClientsAssociation')
	delete from GxQscripts where name = 'wr_GetProxyClientsAssociation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_GetProxyClientsAssociation')
	delete from GXDBVersions where aliasname = 'wr_GetProxyClientsAssociation'
GO

insert into GXDBVersions values(2, 'wr_GetProxyClientsAssociation',  '00010001000200010000', 'wr_GetProxyClientsAssociation', '00010001000200010000')
GO

