

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_GetProfileTaskToday.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_GetProfileTaskToday <<<'

IF EXISTS (select * from sysobjects where name='wr_GetProfileTaskToday')
	drop procedure wr_GetProfileTaskToday
IF EXISTS (select * from GxQscripts where name='wr_GetProfileTaskToday')
	delete from GxQscripts where name = 'wr_GetProfileTaskToday'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_GetProfileTaskToday')
	delete from GXDBVersions where aliasname = 'wr_GetProfileTaskToday'
GO
print '... Creating Procedure: wr_GetProfileTaskToday'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_GetProfileTaskToday
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_UserId INT = 0,
  @i_ccGroupId INT = 0,
  @i_taskId INT = 0,
  @i_companyId INT = 0
AS
  DECLARE @o_taskId INT
CREATE TABLE #propCusNotificationInfo
	(
		customerId				INT,
		notifyType				INT,
		repeatNdays				INT,
		nDaysPriorDueDate		INT,
		weekdays				nvarchar(256)
	)
CREATE TABLE #propTaskNotificationInfo
	(
		taskId					INT,
		customerId				INT,
		notifyType				INT,
		repeatNdays				INT,
		nDaysPriorDueDate		INT,
		weekdays				nvarchar(256),
		DueDate					DATETIME,
		LastNotified			DATETIME
	)
INSERT INTO #propCusNotificationInfo (customerId)
SELECT DISTINCT prop.customerId FROM ProfileCustomerProp  AS prop WITH (NOLOCK)
	 INNER JOIN ProfileCustomerInfo AS CInfo WITH (NOLOCK)
		ON prop.customerId = CInfo.customerId
		AND ((CInfo.ccGroupId  in(select id from APP_ClientGroup WITH (NOLOCK) where id = @i_ccGroupId  OR @i_ccGroupId <> 0))
		OR  (CInfo. reserve1  = @i_companyId AND @i_companyId <> 0)  OR (@i_ccGroupId = 0 AND @i_companyId = 0))
		AND CInfo.customerId>0	AND CInfo.status = 0
AND prop.status =0
UPDATE outprop
SET notifyType = CASE WHEN CAST(prop.attrVal AS INT)>0 THEN CAST(prop.attrVal AS INT) END
FROM #propCusNotificationInfo AS outprop
 INNER JOIN ProfileCustomerProp AS prop WITH (NOLOCK)
 ON prop.customerId = outprop.customerId
 AND prop.attrName = 'notifyType'
AND prop.status =0
UPDATE outprop
SET repeatNdays = CASE WHEN CAST(prop.attrVal AS INT)>0 THEN CAST(prop.attrVal AS INT) END
FROM #propCusNotificationInfo AS outprop
 INNER JOIN ProfileCustomerProp AS prop WITH (NOLOCK)
 ON prop.customerId = outprop.customerId
 AND prop.attrName = 'repeatNdays'
AND prop.status =0
 UPDATE outprop
SET nDaysPriorDueDate = CASE WHEN CAST(prop.attrVal AS INT)>0 THEN CAST(prop.attrVal AS INT) END
FROM #propCusNotificationInfo AS outprop
 INNER JOIN ProfileCustomerProp AS prop WITH (NOLOCK)
 ON prop.customerId = outprop.customerId
 AND prop.attrName = 'nDaysPriorDueDate'
AND prop.status =0
  UPDATE outprop
SET weekdays = prop.attrVal
FROM #propCusNotificationInfo AS outprop
 INNER JOIN ProfileCustomerProp AS prop WITH (NOLOCK)
 ON prop.customerId = outprop.customerId
 AND prop.attrName = 'weekdays'
AND prop.status =0
 INSERT INTO #propTaskNotificationInfo (taskId,dueDate)
SELECT T.taskId,T.dueDate FROM ProfileTaskInfo  AS T WITH (NOLOCK)
		WHERE (T.taskId  = @i_taskId OR   @i_taskId = 0)
		AND T.taskId>0
AND T.status in( 1,2)
AND T.taskType !=2
UPDATE outprop
SET notifyType = CASE WHEN CAST(prop.attrVal AS INT)>0 THEN CAST(prop.attrVal AS INT) END
FROM #propTaskNotificationInfo AS outprop
 INNER JOIN ProfileTaskProp AS prop WITH (NOLOCK)
 ON prop.taskId = outprop.taskId
 AND prop.attrName = 'notifyType'
AND prop.status =0
UPDATE outprop
SET repeatNdays = CASE WHEN CAST(prop.attrVal AS INT)>0 THEN CAST(prop.attrVal AS INT) END
FROM #propTaskNotificationInfo AS outprop
 INNER JOIN ProfileTaskProp AS prop WITH (NOLOCK)
 ON prop.taskId = outprop.taskId
 AND prop.attrName = 'repeatNdays'
AND prop.status =0
 UPDATE outprop
 SET nDaysPriorDueDate = CASE WHEN CAST(prop.attrVal AS INT)>0 THEN CAST(prop.attrVal AS INT) END
FROM #propTaskNotificationInfo AS outprop
 INNER JOIN ProfileTaskProp AS prop WITH (NOLOCK)
 ON prop.taskId = outprop.taskId
 AND prop.attrName = 'nDaysPriorDueDate'
AND prop.status =0
  UPDATE outprop
SET weekdays = prop.attrVal
FROM #propTaskNotificationInfo AS outprop
 INNER JOIN ProfileTaskProp AS prop WITH (NOLOCK)
 ON prop.taskId = outprop.taskId
 AND prop.attrName = 'weekdays'
AND prop.status =0
 UPDATE outprop
SET LastNotified = CAST(prop.attrVal AS datetime)
FROM #propTaskNotificationInfo AS outprop
 INNER JOIN ProfileTaskProp AS prop WITH (NOLOCK)
 ON prop.taskId = outprop.taskId
 AND prop.attrName = 'LastNotified'
  UPDATE outprop
  set customerId = CInfo.customerId
  FROM #propTaskNotificationInfo AS outprop
 INNER JOIN ProfileTaskAssociation AS assoc WITH (NOLOCK) ON
		assoc.taskId = outprop.taskId
and assoc.assocType =  1
 INNER JOIN ProfileCustomerInfo AS CInfo WITH (NOLOCK)
 ON assoc.ccGroupId = CInfo.ccGroupId OR (assoc.customerId  = cInfo.customerId)
 CREATE TABLE #OUTTaskNotificationInfo
	(
		taskId					INT,
		customerId				INT,
		repeatNdays				INT,
		nDaysPriorDueDate		INT,
		weekdays				nvarchar(256),
		DueDate					DATETIME,
		LastNotified			DATETIME,
		NextNotification		DATETIME
	)
INSERT INTO #OUTTaskNotificationInfo
SELECT T.taskId,T.customerId,CASE WHEN T.notifyType =1 THEN T.repeatNdays   END ,T.nDaysPriorDueDate,CASE WHEN T.notifyType  =2 THEN T.weekdays ELSE NULL END ,T.DueDate,T.LastNotified,NULL
FROM #propTaskNotificationInfo T
INNER JOIN #propCusNotificationInfo C
ON
C.customerId = T.customerId
AND (T.notifyType IS NOT NULL  OR T.nDaysPriorDueDate IS NOT NULL )
INSERT INTO #OUTTaskNotificationInfo
SELECT T.taskId,T.customerId,CASE WHEN C.notifyType =1 THEN C.repeatNdays END ,C.nDaysPriorDueDate,CASE WHEN C.notifyType  =2 THEN C.weekdays ELSE NULL END,T.DueDate,T.LastNotified,NULL
FROM #propTaskNotificationInfo T
INNER JOIN #propCusNotificationInfo C
ON
C.customerId = T.customerId
AND (T.notifyType IS NULL AND T.nDaysPriorDueDate IS  NULL)
DECLARE @TODAY DATETIME= GETDATE()
DECLARE @weekStartDay DATE = NULL
DECLARE @weekDayNo INT =0
SELECT @weekStartDay =  DBO.GetWeekStart( @today,0)
SELECT @weekDayNo = DATEDIFF(DAY,@weekStartDay,@today) +1
UPDATE #OUTTaskNotificationInfo
SET NextNotification = CASE WHEN LastNotified<DATEADD(DAY,-nDaysPriorDueDate,DueDate) THEN DATEADD(DAY,-nDaysPriorDueDate,DueDate) ELSE DATEADD(DAY,1,LastNotified) END
WHERE DATEDIFF(DAY,LastNotified,@TODAY)>0
UPDATE #OUTTaskNotificationInfo
SET NextNotification = CASE WHEN NextNotification IS NULL
							THEN DATEADD(DAY,repeatNdays,ISNULL(LastNotified,GETUTCDATE()))
							WHEN NextNotification>(DATEADD(DAY,repeatNdays,ISNULL(LastNotified,GETUTCDATE())))
							THEN DATEADD(DAY,repeatNdays,ISNULL(LastNotified,GETUTCDATE()))
						ELSE NextNotification
						END
WHERE repeatNdays IS NOT NULL AND  DATEDIFF(DAY,LastNotified,@TODAY)>0
 UPDATE #OUTTaskNotificationInfo
SET NextNotification = CASE WHEN CHARINDEX( cast(@weekDayNo as nvarchar(max)),weekdays)>0
							THEN  @TODAY
						ELSE NextNotification
						END
WHERE weekdays IS NOT NULL AND  DATEDIFF(DAY,LastNotified,@TODAY)>0
SELECT taskId FROM #OUTTaskNotificationInfo WHERE  DATEDIFF(DAY,NextNotification,@TODAY)>=0 AND  DATEDIFF(DAY,LastNotified,@TODAY)>0
 drop table #propTaskNotificationInfo
 drop table #propCusNotificationInfo
 drop table #OUTTaskNotificationInfo
GO

IF EXISTS (select * from GxQscripts where name = 'wr_GetProfileTaskToday')
	delete from GxQscripts where name = 'wr_GetProfileTaskToday'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_GetProfileTaskToday')
	delete from GXDBVersions where aliasname = 'wr_GetProfileTaskToday'
GO

insert into GXDBVersions values(2, 'wr_GetProfileTaskToday',  '00010002000200070000', 'wr_GetProfileTaskToday', '00010002000200070000')
GO

