

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_GetProfileTaskInfoHistory.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_GetProfileTaskInfoHistory <<<'

IF EXISTS (select * from sysobjects where name='wr_GetProfileTaskInfoHistory')
	drop procedure wr_GetProfileTaskInfoHistory
IF EXISTS (select * from GxQscripts where name='wr_GetProfileTaskInfoHistory')
	delete from GxQscripts where name = 'wr_GetProfileTaskInfoHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_GetProfileTaskInfoHistory')
	delete from GXDBVersions where aliasname = 'wr_GetProfileTaskInfoHistory'
GO
print '... Creating Procedure: wr_GetProfileTaskInfoHistory'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_GetProfileTaskInfoHistory
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_UserId INT = 0,
  @i_taskId INT = 0,
  @i_lastmodified INT = 0
AS
IF (@i_taskId IS NULL OR @i_taskId = 0) --Customer Satisfaction Information
RETURN
DECLARE @csTimeZone VARCHAR(255)
SET @csTimeZone = dbo.GetClientTimeZone(2)
DECLARE @opid INT = 0
IF(@i_lastmodified=1)
 SET @opid =(select max(opid) from ProfileTaskInfoHistory(NOLOCK) h WHERE h.taskId =@i_taskId)
IF object_id('tempdb.dbo.#taskMod') IS NOT null	DROP TABLE #taskMod
CREATE TABLE #taskMod
(
	taskId			INT,
	OrderNum		INT,
	created			INT,
	userName		NVARCHAR(MAX),
	Field			NVARCHAR(MAX),
	NewVal			NVARCHAR(MAX),
	OldVal			NVARCHAR(MAX)
)
INSERT INTO #taskMod(taskId,OrderNum,created,userName,Field,NewVal,OldVal)
select h.taskId,h.opid,dbo.GetUnixTimeBig(dbo.UTCToLocalTime(h.created , @csTimeZone)) OrderNum,
	 (select isnull(name,login) from umusers(NOLOCK) where id =
		(select attrval from ProfileTaskInfoHistory(NOLOCK) where attrname='lastModifiedBy' and taskid=h.taskid and h.opId =opId )) AS userName ,
	h.attrName Field,h.attrval AS NewVal,''
from ProfileTaskInfoHistory(NOLOCK) h
WHERE h.taskId =@i_taskId and (h.opid =@opid OR @opid=0)
and attrname<>'lastModifiedBy'
order by OrderNum desc
update t
set OldVal = ISNULL(hprev.attrVal,'')
from #taskMod t
outer apply
     (select top 1 h2.attrval
      from ProfileTaskInfoHistory (NOLOCK) h2
      where h2.attrName = t.Field
			and h2.taskid = t.taskid
			and h2.opId < t.OrderNum
      order by opid desc
	  ) hprev;
update t
set OldVal = ISNULL((select isnull(name,login) from umusers(NOLOCK) where id =OldVal),''),
    NewVal = ISNULL((select isnull(name,login) from umusers(NOLOCK) where id =NewVal),'')
from #taskMod t
where Field = 'assignedTo'
update t
set OldVal = CASE WHEN OldVal =1 THEN 'Open' WHEN OldVal =2 THEN 'Fixed/Monitoring'  WHEN OldVal =3 THEN 'Closed' WHEN OldVal =4 THEN 'Killed' WHEN OldVal = 5 THEN 'OnHold' ELSE '' END ,
    NewVal = CASE WHEN NewVal =1 THEN 'Open' WHEN NewVal =2 THEN 'Fixed/Monitoring'  WHEN NewVal =3 THEN 'Closed' WHEN NewVal =4 THEN 'Killed' WHEN NewVal = 5 THEN 'OnHold'ELSE '' END + ', Reason: '+ISNULL((select ISNULL(attrVal,'') from ProfileTaskInfoHistory (NOLOCK) where attrName = 'statusChangedReason' AND opid = t.OrderNum AND taskId = t.taskId),'')
from #taskMod t
where Field = 'status'
update t
set OldVal = CASE WHEN OldVal = 3 THEN 'Commvault Project' WHEN OldVal = 4 THEN 'Customer Project' ELSE 'Task' END,
	NewVal = CASE WHEN NewVal = 3 THEN 'Commvault Project' WHEN NewVal = 4 THEN 'Customer Project' ELSE 'Task' END
from #taskMod t
where Field = 'taskType'
delete from  #taskMod  where Field = 'statusChangedReason'
update t
set OldVal =  convert(varchar(12) ,OldVal,108),
    NewVal = convert(varchar(12) ,newval,108) + ', Reason: '+ISNULL((select ISNULL(attrVal,'') from ProfileTaskInfoHistory (NOLOCK)   where attrName = 'dueDateChangedReason' AND opId = t.OrderNum AND  taskId = t.taskId),'')
from #taskMod t
where Field = 'dueDate'
delete from  #taskMod  where Field = 'dueDateChangedReason'
update t
set OldVal = CASE WHEN OldVal = 1 THEN 'Yes' ELSE 'No' END,
	NewVal = CASE WHEN NewVal = 1 THEN 'Yes' ELSE 'No' END
from #taskMod t
where Field = 'internalTask'
update t
set OldVal =  convert(varchar(12) ,OldVal,108),
    NewVal = convert(varchar(12) ,newval,108)
from #taskMod t
where Field = 'startDate'
select * from #taskMod ORDER BY OrderNum DESC
DROP TABLE #taskMod
GO

IF EXISTS (select * from GxQscripts where name = 'wr_GetProfileTaskInfoHistory')
	delete from GxQscripts where name = 'wr_GetProfileTaskInfoHistory'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_GetProfileTaskInfoHistory')
	delete from GXDBVersions where aliasname = 'wr_GetProfileTaskInfoHistory'
GO

insert into GXDBVersions values(2, 'wr_GetProfileTaskInfoHistory',  '00010001000200050000', 'wr_GetProfileTaskInfoHistory', '00010001000200050000')
GO

