

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_GetProfileTaskInfo.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_GetProfileTaskInfo <<<'

IF EXISTS (select * from sysobjects where name='wr_GetProfileTaskInfo')
	drop procedure wr_GetProfileTaskInfo
IF EXISTS (select * from GxQscripts where name='wr_GetProfileTaskInfo')
	delete from GxQscripts where name = 'wr_GetProfileTaskInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_GetProfileTaskInfo')
	delete from GXDBVersions where aliasname = 'wr_GetProfileTaskInfo'
GO
print '... Creating Procedure: wr_GetProfileTaskInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_GetProfileTaskInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/*
i_subEntity =
0 -- to Get all
1 -- to get contact information about the customer
2 -- this is to get latest contract date for customer
 3 -- this is to get all or with date range given input
 4 -- this is to get customer status
*/
  @i_UserId INT = 0,
  @i_ccGroupId INT = 0,
  @i_TouchId INT = 0,
  @i_taskId INT = 0,
  @i_commcellId INT = 0,
  @i_TOP INT = 5,
  @i_bneedCount INT = 0,
  @i_companyId INT = 0
AS
  DECLARE @response xml
/*
ProfileTaskAssociation
assocType for
1		TASK association with customer ,ccgroup,touch, etc.
2		Touch association customerId,ccGroupId,
3		Customer association with ccgroup
*/
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @CloudCapabilities int = 0
SET @CloudCapabilities = ISNULL((SELECT attrVal FROM UMUsersProp WITH (NOLOCK) WHERE componentNameId = @i_UserId and modified = 0 and attrName='Cloud Capabilities' and attrval & 8 > 0),0)
    SET @CloudCapabilities = (@CloudCapabilities|ISNULL((select TOP 1 attrval FROM UMUserGroup UG WITH (NOLOCK)
    INNER JOIN [UMGroupsProp] UGP WITH (NOLOCK) ON UG.groupId=UGP.componentNameId AND modified = 0  AND attrName='Cloud Capabilities' and UGP.attrval & 8 > 0
    WHERE UG.userId=@i_UserId),0))
DECLARE @isInternalUser INT =0
IF ((@CloudCapabilities  <> 0 ) OR (@i_UserId=-1))
SET @isInternalUser=1
	IF object_id('tempdb.dbo.#CustomerInfo') IS NOT NULL DROP TABLE #CustomerInfo
CREATE TABLE  #CustomerInfo (ccGroupId INT ,customerId INT, customer NVARCHAR(255))
	INSERT INTO #CustomerInfo (ccGroupId,customerId, customer)
	SELECT   assoc.ccGroupId , CInfo.customerId
		,CInfo.name
	FROM ProfileCustomerInfo AS CInfo WITH (NOLOCK)
	INNER JOIN
	ProfileTaskAssociation AS assoc WITH (NOLOCK) ON
assoc.ccGroupId  = CInfo.ccGroupId and assoc.assocType =  3
	INNER JOIN
	APP_ClientGroup ap WITH (NOLOCK) ON
	assoc.ccGroupId  =ap.id
where ( (ap.id=@i_ccGroupId and @i_ccGroupId>0) OR  (@i_companyId= 0 AND @i_ccGroupId= 0)) and assoc.assocType =  3
AND CInfo.customerId>0 AND CInfo.status = 0
UNION
	SELECT   assoc.ccGroupId , CInfo.customerId
		,CInfo.name
	FROM ProfileCustomerInfo AS CInfo WITH (NOLOCK)
	INNER JOIN
	ProfileTaskAssociation AS assoc WITH (NOLOCK) ON
assoc.customerId = CInfo.customerId and assoc.assocType =  3
	INNER JOIN
	UMGroups ap WITH (NOLOCK) ON
	CInfo. reserve1  =ap.id
where  ((ap.id=@i_companyId and @i_companyId>0) OR (@i_companyId= 0 AND @i_ccGroupId= 0)) and assoc.assocType =   3
AND CInfo.customerId>0 AND CInfo.status = 0
	IF( @i_bneedCount  = 0 ) -- Need all Task Information
	BEGIN
		IF object_id('tempdb.dbo.#OUTTASKINFO') IS NOT NULL DROP TABLE #OUTTASKINFO
		CREATE TABLE  #OUTTASKINFO (
ccGroupId INT , customer NVARCHAR(255) ,
taskId    INT , taskSummary NVARCHAR(2048) , taskDescription	NVARCHAR(MAX),
				status	  INT , createdBy	INT , assignedTo	INT ,
dueDate	BIGINT, taskUrl	NVARCHAR(2048) ,  tasknotes	NVARCHAR(MAX),
lastModifiedBy INT, emailTo NVARCHAR(255) ,
commcellId NVARCHAR(MAX) , TouchId INT , docShareFolderId BIGINT,  docCustPath  NVARCHAR(1024),taskCreated BIGINT,
				folderpath NVARCHAR(MAX) ,
				binternalTask INT,startDate DATETIME,tasktype INT,lastModified BIGINT
		  )
		IF (@i_TOP  = 0 ) -- Need all Task Information
		BEGIN
			INSERT INTO #OUTTASKINFO(ccGroupId , customer ,
											taskId    , taskSummary , taskDescription ,
											status	 , createdBy , assignedTo ,
											dueDate , taskUrl ,  tasknotes ,
											lastModifiedBy ,  emailTo,  commcellId,  TouchId  ,docShareFolderId ,  docCustPath , taskCreated, folderpath,binternalTask,taskType,lastModified,startDate )
			SELECT    assoc.ccGroupId ,  ISNULL(CInfo.customer,'')
					,task.taskId , taskSummary  , taskDescription
					,task.status, task.createdBy , task.assignedTo
					,dbo.getUnixtime(dueDate) , taskUrl , task.tasknotes
					,task.lastModifiedBy , emailTo
					, Case WHEN assoc.commcellId IS NULL  OR assoc.commcellId <1  THEN 'N/A'
						ELSE CAST((select number from app_commcell WITH (NOLOCK) where id = assoc.commcellId) AS nvarchar(MAX))
						END  AS  'commcellId<DONOTSHOW>'
					,ISNULL(assoc.TouchId,0)
					,task.docShareFolderId
					,task.docCustPath
					,dbo.GetUnixTimeBig(task.created)
					,ISNULL(folderPath.folderpath,'')
					,ISNULL(prop.attrVal ,0),ISNULL(task.taskType,0),dbo.getUnixtime(task.lastModified) ,task.created
			FROM ProfileTaskInfo AS task WITH (NOLOCK)
			INNER JOIN ProfileTaskAssociation AS assoc WITH (NOLOCK) ON
			assoc.taskId = task.taskId
AND task.taskType  IN (0,3,4)
AND assoc.assocType = 1
			INNER JOIN ProfileCustomerInfo CInfo1 ON CInfo1.customerId = assoc.customerId
			AND (assoc.commcellId = (select id from app_commcell WITH (NOLOCK) where number = @i_commcellId ) OR @i_commcellId = 0)
			AND (assoc.TouchId    = @i_TouchId OR   @i_TouchId = 0)
			AND (task.taskId = @i_taskId  OR   @i_taskId  = 0)
			INNER JOIN #CustomerInfo AS cInfo  WITH (NOLOCK) ON
			((assoc.ccGroupId  = cInfo.ccGroupId and cInfo.ccGroupId>0)
			OR (assoc. customerId  = cInfo.customerId and cInfo.customerId>0))
			LEFT OUTER JOIN ProfileFolderPath AS folderPath  WITH (NOLOCK) ON
			folderPath.taskId = task.taskId
			LEFT OUTER JOIN
			ProfileTaskProp prop WITH (NOLOCK) ON task.taskId = prop.taskId and prop.attrName ='internalTask' AND prop.attrVal =1
			WHERE  prop.taskId is  null OR (@isInternalUser = 1)
			ORDER BY task.status DESC,dueDate DESC
			UPDATE #OUTTASKINFO
				SET startDate = attrVal
				FROM #OUTTASKINFO t INNER JOIN ProfileTaskProp prop ON t.taskId = prop.taskId and prop.attrName ='startDate' and attrVal > startDate
		END
		ELSE IF( @i_TOP  >0)  -- Need all OPEN Task Information
		BEGIN
			INSERT INTO #OUTTASKINFO(ccGroupId , customer ,
											taskId    , taskSummary , taskDescription ,
											status	 , createdBy , assignedTo ,
											dueDate , taskUrl ,  tasknotes ,
											lastModifiedBy ,  emailTo,  commcellId,  TouchId  ,docShareFolderId ,  docCustPath , taskCreated, folderpath,binternalTask,taskType,lastModified,startDate )
			SELECT  TOP(@i_TOP)
					assoc.ccGroupId	 ,  ISNULL(CInfo.customer,'')
					,task.taskId , taskSummary  , taskDescription
					,task.status, task.createdBy , task.assignedTo
					,dbo.getUnixtime(dueDate) , taskUrl , task.tasknotes
					,task.lastModifiedBy , emailTo
     				, Case WHEN assoc.commcellId IS NULL  OR assoc.commcellId <1  THEN 'N/A'
						ELSE CAST((select number from app_commcell WITH (NOLOCK) where id = assoc.commcellId) AS nvarchar(MAX))
						END  AS  'commcellId<DONOTSHOW>'
					,ISNULL(assoc.TouchId,0)
					,task.docShareFolderId
					,task.docCustPath
					,dbo.GetUnixTimeBig(task.created)
					,ISNULL(folderPath.folderpath,'')
					,ISNULL(prop.attrVal ,0),ISNULL(task.taskType,0),dbo.getUnixtime(task.lastModified) ,task.created
			FROM ProfileTaskInfo AS task WITH (NOLOCK)
			INNER JOIN
			ProfileTaskAssociation AS assoc WITH (NOLOCK) ON
			assoc.taskId = task.taskId
			AND task.status = 1
AND task.taskType  IN (0,3,4)
			AND (assoc.commcellId = (select id from app_commcell WITH (NOLOCK) where number = @i_commcellId ) OR @i_commcellId = 0)
			INNER JOIN ProfileCustomerInfo CInfo1 ON CInfo1.customerId = assoc.customerId
AND assoc.assocType =   1
			AND (assoc.TouchId    = @i_TouchId OR   @i_TouchId = 0)
			AND (task.taskId = @i_taskId  OR   @i_taskId  = 0)
			INNER JOIN #CustomerInfo AS cInfo  WITH (NOLOCK) ON
			((assoc.ccGroupId  = cInfo.ccGroupId and cInfo.ccGroupId>0)
			OR (assoc. customerId  = cInfo.customerId and cInfo.customerId>0))
			LEFT OUTER JOIN ProfileFolderPath AS folderPath  WITH (NOLOCK) ON
			folderPath.taskId = task.taskId
			LEFT OUTER JOIN
			ProfileTaskProp prop WITH (NOLOCK) ON task.taskId = prop.taskId and prop.attrName ='internalTask' AND prop.attrVal =1
			WHERE  prop.taskId is  null OR (@isInternalUser = 1)
			ORDER BY task.status DESC,dueDate DESC
			UPDATE #OUTTASKINFO
				SET startDate = attrVal
				FROM #OUTTASKINFO t INNER JOIN ProfileTaskProp prop ON t.taskId = prop.taskId and prop.attrName ='startDate'  and attrVal > startDate
		END
		--PREPARE DYNAMIC OUTPUT STATEMENT TO AVOID MULTIPLE SELECT STATEMENT
		DECLARE @OUTSTATEMENT NVARCHAR(MAX) =NULL
		SET @OUTSTATEMENT = ' SELECT   out.ccGroupId			AS  ''ccGroupId<DONOTSHOW>'' '
		IF (@i_ccGroupId = 0 and @i_companyId = 0)
		BEGIN
			SET @OUTSTATEMENT = @OUTSTATEMENT + ',out.customer			AS  ''Customer Name<ProfileCustName>'' '
		END
		SET @OUTSTATEMENT = @OUTSTATEMENT +
			   ',out.taskId				AS ''Task Id''
				,out.taskSummary		AS  ''Name<Task>''
				,out.taskType			AS  ''Type<TaskType>''
				,out.taskDescription	AS  ''Description''
				,out.status             AS  ''Status<TaskStatus>''
				,out.createdBy          AS  ''CreatedId<DONOTSHOW>''
				,ISNULL((SELECT CASE WHEN users.name IS NULL OR len(users.name)<1 THEN users.login ELSE users.name END  from UMUsers users WITH (NOLOCK) WHERE out.createdBy = users.id),''N/A'')                  AS  ''Created By''
				,out.assignedTo			AS  ''AssignedId<DONOTSHOW>''
				,ISNULL((SELECT CASE WHEN users.name IS NULL OR len(users.name)<1 THEN users.login ELSE users.name END  from UMUsers users WITH (NOLOCK) WHERE out.assignedTo = users.id),''N/A'')                  AS  ''Assigned To''
				,out.dueDate    AS  ''Target Date<MMMDDYYYY>''
				,dbo.getUnixTimeBig(out.startDate)			AS	''Start Date<MMMDDYYYY>''
				,out.taskUrl			AS  ''URL<URL><HIDDEN>''
				,out.tasknotes          AS  ''Notes<HIDDEN>''
				,out.lastModifiedBy		AS  ''ModifiedId<DONOTSHOW>''
				,ISNULL((SELECT CASE WHEN users.name IS NULL OR len(users.name)<1 THEN users.login ELSE users.name END  from UMUsers users WITH (NOLOCK) WHERE out.lastModifiedBy = users.id),''N/A'')           AS  ''Last Modified By<HIDDEN>''
				,out.emailTo			AS  ''EmailTo<DONOTSHOW>''
   				,out.commcellId			AS  ''commcellId<DONOTSHOW>''
				,out.TouchId			AS  ''TouchId<DONOTSHOW>''
				,out.docShareFolderId	AS  ''ShareFolderId<DONOTSHOW>''
				,out.docCustPath		AS  ''Document Path<DONOTSHOW>''
				,out.taskCreated		AS  ''Creation Date<MMMDDYYYY><HIDDEN>''
				,out.folderpath			AS  ''Folder Path<DONOTSHOW>''
				,out.lastModified		AS  ''Last Modified Date<MMMDDYYYY><HIDDEN>'''
		IF (@isInternalUser = 1)
		BEGIN
			SET @OUTSTATEMENT = @OUTSTATEMENT + ', CASE WHEN out.binternalTask=1 THEN ''Yes'' ELSE ''No'' END			AS	''Internal<booleanRenderer>'' '
		END
		SET @OUTSTATEMENT = @OUTSTATEMENT +
			'FROM #OUTTASKINFO out ORDER BY out.status ASC,dueDate DESC'
		EXECUTE( @OUTSTATEMENT)
		 DROP TABLE  #OUTTASKINFO
	END
	ELSE
	BEGIN
		SELECT
		assoc.ccGroupId				AS  'ccGroupId'
		,task.status 	AS  'status'
		,count(*) AS 'Total Tasks'
		FROM ProfileTaskInfo AS task WITH (NOLOCK)
		INNER JOIN
		ProfileTaskAssociation AS assoc WITH (NOLOCK) ON
		assoc.taskId = task.taskId
	--	AND task.status in( 1,2)
AND task.taskType  IN (0,3,4)
and assoc.assocType =  1
		INNER JOIN ProfileCustomerInfo CInfo ON CInfo.customerId = assoc.customerId
		INNER JOIN #CustomerInfo AS cInfo1  WITH (NOLOCK) ON
		((assoc.ccGroupId  = cInfo1.ccGroupId and cInfo1.ccGroupId>0)
			OR (assoc. customerId  = cInfo1.customerId and cInfo1.customerId>0))
		AND (task.taskId = @i_taskId  OR   @i_taskId  = 0)
		LEFT OUTER JOIN
		ProfileTaskProp prop WITH (NOLOCK) ON task.taskId = prop.taskId and prop.attrName ='internalTask' AND prop.attrVal =1
		WHERE  prop.taskId is  null OR (@isInternalUser = 1)
		group by assoc.ccGroupId,task.status
		order by assoc.ccGroupId,task.status
	END
   DROP TABLE #CustomerInfo
GO

IF EXISTS (select * from GxQscripts where name = 'wr_GetProfileTaskInfo')
	delete from GxQscripts where name = 'wr_GetProfileTaskInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_GetProfileTaskInfo')
	delete from GXDBVersions where aliasname = 'wr_GetProfileTaskInfo'
GO

insert into GXDBVersions values(2, 'wr_GetProfileTaskInfo',  '00010001000200140000', 'wr_GetProfileTaskInfo', '00010001000200140000')
GO

