

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_GetProfileSatisfactionInfo.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_GetProfileSatisfactionInfo <<<'

IF EXISTS (select * from sysobjects where name='wr_GetProfileSatisfactionInfo')
	drop procedure wr_GetProfileSatisfactionInfo
IF EXISTS (select * from GxQscripts where name='wr_GetProfileSatisfactionInfo')
	delete from GxQscripts where name = 'wr_GetProfileSatisfactionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_GetProfileSatisfactionInfo')
	delete from GXDBVersions where aliasname = 'wr_GetProfileSatisfactionInfo'
GO
print '... Creating Procedure: wr_GetProfileSatisfactionInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_GetProfileSatisfactionInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_UserId INT = 0,
  @i_ccGroupId INT = 0,
  @i_SfactionType INT = 0,
  @i_companyId INT = 0,
  @i_bLatest INT = 0
AS
IF (@i_SfactionType IS NULL OR @i_SfactionType = 0) --Customer Satisfaction Information
BEGIN
IF (@i_bLatest = 0)
BEGIN
	SELECT   assoc.ccGroupId									AS  'ccGroupId<DONOTSHOW>'
			,CInfo.name											AS  'Customer Name<ProfileCustName><HIDDEN>'
			,Ctouchfo.touchId									AS  'CustomerTouchId<DONOTSHOW>'
			,dbo.getUnixtime(Ctouchfo.touchDate)				AS  'Submitted Date<MMMDDYYYY>'
			,Ctouchfo.submittedBy							    AS  'SubmittedId<DONOTSHOW>'
			,ISNULL((SELECT users.name FROM UMUsers users
						WITH (NOLOCK)
					 WHERE Ctouchfo.submittedBy = users.id),
						'N/A')									AS  'Submitted By'
			,Ctouchfo.custSatisfaction							AS  'Customer Satisfaction'
			,Ctouchfo.notes					AS  'Notes<FeedbackNotes>'
	FROM ProfileCustomerTouch AS Ctouchfo WITH (NOLOCK)
INNER JOIN ProfileTaskAssociation AS assoc WITH (NOLOCK) ON	assoc.touchId = Ctouchfo .touchId and assoc.customerId = Ctouchfo.customerId and assoc.assocType =  2
INNER JOIN ProfileCustomerInfo  AS CInfo WITH (NOLOCK) ON	assoc.customerId = CInfo.customerId AND CInfo.status = 0
			AND ((assoc.ccGroupId  = @i_ccGroupId AND   @i_ccGroupId <> 0)
		OR (CInfo. reserve1  = @i_companyId AND @i_companyId <> 0) )
	AND Ctouchfo.customerId>0 AND Ctouchfo.custSatisfaction>0
	ORDER BY CInfo.name	 ASC,Ctouchfo.created DESC
END
ELSE
BEGIN
	SELECT  TOP (1) assoc.ccGroupId									AS  'ccGroupId<DONOTSHOW>'
			,CInfo.name											AS  'Customer Name<ProfileCustName><HIDDEN>'
			,Ctouchfo.touchId									AS  'CustomerTouchId<DONOTSHOW>'
			,dbo.getUnixtime(Ctouchfo.touchDate)				AS  'Submitted Date<MMMDDYYYY>'
			,Ctouchfo.submittedBy							    AS  'SubmittedId<DONOTSHOW>'
			,ISNULL((SELECT users.name FROM UMUsers users
						WITH (NOLOCK)
					 WHERE Ctouchfo.submittedBy = users.id),
						'N/A')									AS  'Submitted By'
			,Ctouchfo.custSatisfaction							AS  'Customer Satisfaction'
			,Ctouchfo.notes					AS  'Notes<FeedbackNotes>'
	FROM ProfileCustomerTouch AS Ctouchfo WITH (NOLOCK)
INNER JOIN ProfileTaskAssociation AS assoc WITH (NOLOCK) ON	assoc.touchId = Ctouchfo .touchId and assoc.customerId = Ctouchfo.customerId and assoc.assocType = 2
INNER JOIN ProfileCustomerInfo  AS CInfo WITH (NOLOCK) ON	assoc.customerId = CInfo.customerId AND CInfo.status =  0
			AND ((assoc.ccGroupId  = @i_ccGroupId AND   @i_ccGroupId <> 0)
		OR (CInfo. reserve1  = @i_companyId AND @i_companyId <> 0) )
	AND Ctouchfo.customerId>0 AND Ctouchfo.custSatisfaction>0
	ORDER BY Ctouchfo.created DESC
END
END
ELSE IF (@i_SfactionType = 1) --commvault employee Satisfaction Information
BEGIN
	SELECT   assoc.ccGroupId									AS  'ccGroupId<DONOTSHOW>'
			,CInfo.name											AS  'Customer Name<ProfileCustName><HIDDEN>'
			,Ctouchfo.touchId									AS  'CustomerTouchId<DONOTSHOW>'
			,dbo.getUnixtime(Ctouchfo.touchDate)				AS  'Submitted Date<MMMDDYYYY>'
			,Ctouchfo.submittedBy							    AS  'SubmittedId<DONOTSHOW>'
			,ISNULL((SELECT users.name
						FROM UMUsers users WITH (NOLOCK)
					 WHERE Ctouchfo.submittedBy = users.id)
					,'N/A')										AS  'Submitted By'
			,Ctouchfo.cvInfluence								AS  'Commvault Influence'
			,Ctouchfo.notes										AS  'Notes<FeedbackNotes>'
			,Ctouchfo.tamLocation								AS  'TAM Location<TAMLocation>'
			,Ctouchfo.daysSpent									AS  'Days Spent'
			,dbo.getUnixtime(ISNULL((SELECT attrVal FROM ProfileCustomerTouchProp  (NOLOCK) WHERE touchId = Ctouchfo.touchId and attrName ='customertouchStartdate'),Ctouchfo.touchDate)) AS  'Time Period Start<MMMDDYYYY>'
			,dbo.getUnixtime(ISNULL((SELECT attrVal FROM ProfileCustomerTouchProp  (NOLOCK) WHERE touchId = Ctouchfo.touchId and attrName ='customertouchEnddate'),Ctouchfo.touchDate)) AS  'Time Period End<MMMDDYYYY>'
	FROM ProfileCustomerTouch AS Ctouchfo WITH (NOLOCK)
INNER JOIN ProfileTaskAssociation AS assoc WITH (NOLOCK) ON	assoc.touchId = Ctouchfo .touchId and assoc.customerId = Ctouchfo.customerId and assoc.assocType =  2
INNER JOIN ProfileCustomerInfo  AS CInfo WITH (NOLOCK) ON	assoc.customerId = CInfo.customerId AND CInfo.status = 0
			AND ((assoc.ccGroupId  = @i_ccGroupId AND   @i_ccGroupId <> 0)
		OR (CInfo. reserve1  = @i_companyId AND @i_companyId <> 0) )
	AND Ctouchfo.customerId>0 AND Ctouchfo.cvInfluence>0
	ORDER BY CInfo.name	 ASC,Ctouchfo.created DESC
END
GO

IF EXISTS (select * from GxQscripts where name = 'wr_GetProfileSatisfactionInfo')
	delete from GxQscripts where name = 'wr_GetProfileSatisfactionInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_GetProfileSatisfactionInfo')
	delete from GXDBVersions where aliasname = 'wr_GetProfileSatisfactionInfo'
GO

insert into GXDBVersions values(2, 'wr_GetProfileSatisfactionInfo',  '00010001000200100000', 'wr_GetProfileSatisfactionInfo', '00010001000200100000')
GO

