

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_GetProfileFeedbackMailInfo.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_GetProfileFeedbackMailInfo <<<'

IF EXISTS (select * from sysobjects where name='wr_GetProfileFeedbackMailInfo')
	drop procedure wr_GetProfileFeedbackMailInfo
IF EXISTS (select * from GxQscripts where name='wr_GetProfileFeedbackMailInfo')
	delete from GxQscripts where name = 'wr_GetProfileFeedbackMailInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_GetProfileFeedbackMailInfo')
	delete from GXDBVersions where aliasname = 'wr_GetProfileFeedbackMailInfo'
GO
print '... Creating Procedure: wr_GetProfileFeedbackMailInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_GetProfileFeedbackMailInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_UserId INT = 0,
  @i_ccGroupId INT = 0,
  @i_TaskId INT = 0,
  @i_bAllContact INT = 0,
  @i_ncontactList NVARCHAR(MAX),
  @i_companyId INT = 0
AS
  DECLARE @o_Mailbody NVARCHAR(MAX)
  DECLARE @o_MailTo NVARCHAR(MAX)
  DECLARE @o_Subject NVARCHAR(MAX)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF( (@i_ccGroupId IS NULL ) AND (@i_TaskId IS NULL OR @i_TaskId < 1 ) AND (@i_companyId IS NULL) AND (@i_ccGroupId < 1 and @i_companyId < 1)) --no CC Group
	RETURN
DECLARE @mailBody NVARCHAR(MAX) ='<html>
    <head>
    <meta http-equiv="content-type" content="text/html; charset=windows-1252">
        <style type="text/css">
            body {
                font-family: Helvetica, Arial, sans-serif;
                font-size: 14px;
                text-align: center;
                width:800px;
                word-spacing: 1;
            }
            a {
                color: #1B6DAD;
                text-decoration: none;
            }
            h2{
            	text-align: center;
            	border: 1px solid #eee;
    			background-color: #eee;
            }
            h3{
                color: #666;
                text-align: center;
            }
            .info-table {
                width: 800px;
                text-align: left;
                background-color: white;
            }
            .info-label{
                width: 100px;
                font-family: Helvetica, Arial, sans-serif;
                font-size: 12px;
                line-height: 1.5;
                width:800px;
                padding:25px 50px;
            }
            .info-label-header{
                padding-top: 20px;
                border-top: 1px solid #EEE;
            }
        </style>
     </head>
    <body style="font-family: Helvetica, Arial, sans-serif;font-size: 14px;text-align: center;width: 800px;word-spacing: 1;">
        <h2 class="task-header" style="text-align: center;border: 1px solid #eee;background-color: #eee;">Commvault Enterprise Support Program</h2>
        <table align="center" class="info-table" style="width: 800px;text-align: left;background-color: white;">
            <tbody>
                 <tr class="info-row">
                     <td>
                         <h3 class="task-header" style="color: #666;text-align: center;">&lt;CustomerName&gt; - Request For Feedback</h3>
                     </td>
                 </tr>
                <tr class="info-row">
                    <td colspan="4" class="info-label info-label-header" style="width: 800px;font-family: Helvetica, Arial, sans-serif;font-size: 12px;line-height: 1.5;padding: 25px 50px;padding-top: 20px;border-top: 1px solid #EEE;">
                        <p>Hello &lt;CustomerName&gt;,</p>
                        <p>As part of Commvault''s continuing effort to deliver high value to our customers, we ask that you provide overall
                        feedback on the different facets you interact with (the product itself and the Enterprise Support team) on a regular basis.
                        Please take a moment to rate Commvault on the VALUE we are providing to your organization and comment on the reasons for this rating.</p>
                        <p>Please follow these instructions:</p>
                        <p>1.<a href="&lt;WebConsoleName&gt;/webconsole/survey/profile/profilecustdashboard.jsp?feedback=true&ccGroupId=&lt;CCGroupId&gt;" style="color: #1B6DAD;text-decoration: none;">
                            Click here to submit feedback.
                            </a>
                        </p>
                        <p>2. Fill the information in Customer Satisfaction dialog and click submit.</p>
                        <p>If you have any questions or need additional assistance, please contact your Technical Account Manager.</p>
                        <br>
                        <p>Regards,</p>
                        <p>Commvault Cloud Services</p>
                        <br>
                    </td>
                </tr>
            </tbody>
        </table>
    </body>
</html>
'
  IF EXISTS(SELECT NAME FROM GXGlobalParam(nolock) WHERE NAME = 'ProfileFeedbackMailBody' AND modified =0)
BEGIN
	SELECT @mailBody = value FROM GXGlobalParam(nolock)  WHERE NAME ='ProfileFeedbackMailBody' AND modified =0
END
DECLARE @ccGroupId  INT
DECLARE @companyId INT
DECLARE @val NVARCHAR(255) = NULL
DECLARE @webconsole NVARCHAR(255) = NULL
SELECT @val = value FROM GXGlobalParam(nolock)  WHERE NAME ='ProfileWebConsole' AND modified =0
IF (@val IS NOT NULL AND LEN(@val)>0)
BEGIN
	select @webconsole = @val
END
IF (@webconsole IS NULL OR LEN(@webconsole)<=0)
	SET @webconsole = 'https://cloud.commvault.com'
DECLARE @MailTo NVARCHAR(MAX) = ''
DECLARE @Subject NVARCHAR(MAX) = ''
IF(@i_TaskId>0)
BEGIN
	IF(@i_ccGroupId <> 0)
	SELECT @ccGroupId = ISNULL((SELECT ccGroupId FROM ProfileTaskAssociation (NOLOCK) WHERE taskId = @i_taskId),0)
	ELSE
	SELECT @companyId = ISNULL((SELECT CInfo.reserve1 FROM ProfileTaskAssociation (NOLOCK) assoc INNER JOIN ProfileCustomerInfo CInfo ON CInfo.customerId = assoc.customerId WHERE assoc.taskId = @i_taskId),0)
END
ELSE
BEGIN
	SET @ccGroupId =@i_ccGroupId
	SET @companyId = @i_companyId
END
DECLARE @customerName NVARCHAR(MAX) =NULL
SELECT @customerName = ISNULL((SELECT name FROM ProfileCustomerInfo(nolock) WHERE (ccGroupId = @ccGroupId and @ccGroupId <> 0) OR (reserve1 = @companyId and @companyId <> 0)),'')
IF (@customerName = '' OR @customerName = 'DUMMY' )
BEGIN
	SELECT @mailBody = REPLACE(@mailBody,'&lt;CustomerName&gt; - '	,'')
	SELECT @mailBody = REPLACE(@mailBody,'&lt;ContactName&gt;,'	,'')
END
ELSE
BEGIN
	SELECT @mailBody = REPLACE(@mailBody,'&lt;CustomerName&gt;'		,@customerName)
	SELECT @mailBody = REPLACE(@mailBody,'&lt;ContactName&gt;'	,@customerName)
END
SELECT @mailBody = REPLACE(@mailBody,'&lt;WebConsoleName&gt;',	@webconsole)
IF(@ccGroupId <> 0)
SELECT @mailBody = REPLACE(@mailBody,'&lt;CCGroupId&gt;'		,@ccGroupId)
ELSE
SELECT @mailBody = REPLACE(@mailBody,'ccGroupId=&lt;CCGroupId&gt;'		,'companyId='+ CAST(@companyId AS VARCHAR(16)))
IF object_id('tempdb.dbo.#customerContactEmail') IS NOT null	DROP TABLE #customerContactEmail
	CREATE TABLE #customerContactEmail (contactId INT,  UserId INT, email nvarchar (255) )
IF object_id('tempdb.dbo.#customerContactInfo1') IS NOT null	DROP TABLE #customerContactInfo1
	CREATE TABLE #customerContactInfo1 (CustomerInfoId INT, ContactId INT,  UserId INT, contactName nvarchar(max), contactTitle nvarchar(max), email nvarchar (255),contactPhone nvarchar (255),contactgroup  INT,isPrimaryContact INT,status INT  )
IF(@i_taskId>0)
BEGIN
-- this need to update with external customer users.
select @i_bAllContact = ISNULL(attrVal,0) from ProfileTaskProp AS prop WITH (NOLOCK)	 where prop.attrName = 'feedbackNotifyAllContacts' and prop.status =0 AND taskId = @i_taskId
IF (@i_bAllContact IS NOT NULL AND @i_bAllContact>0)
	BEGIN
		EXEC wr_GetProfileContactInfo 1,@i_ccGroupId,1,'#customerContactInfo1',@i_companyId
		set @MailTo = (select COALESCE(email + ';','')   from  #customerContactInfo1 for xml path(''))
	END
else
	BEGIN
select @MailTo = ISNULL(attrVal,'') from ProfileTaskProp AS prop WITH (NOLOCK)	 where prop.attrName = 'feedbackNotifyContacts' and prop.status =0 AND taskId = @i_taskId
		IF( CHARINDEX('.com', @MailTo, 0)<0) -- this is to check if attr is having new structure format
		BEGIN
			DECLARE @request XML =  ISNULL(CAST(@MailTo AS XML),'')
			INSERT INTO #customerContactEmail(contactId,  UserId)
			SELECT
				ISNULL(contacts.value('(@contactId)[1]','[int]'), 0),
				ISNULL(contacts.value('(name/@userId)[1]','[int]'), 0)
			From @request.nodes('WebReport_FeedbackQuerterlyContactList/contacts') contacts(contacts)
			UPDATE cEmails
			SET email = CASE WHEN LEN(contacts.contactEmail)>2 THEN contacts.contactEmail
							 WHEN  contacts.contactUserId>0    THEN ISNULL((SELECT users.email FROM UMUsers users WITH (NOLOCK) WHERE  contacts.contactUserId= users.id),'')
							  END
			FROM #customerContactEmail cEmails INNER JOIN
			ProfileCustomerContact  (NOLOCK) contacts
on contacts.contactId =cEmails.contactId AND contacts.status =0
			UPDATE cEmails
			SET email = CASE WHEN  cEmails.UserId>0    THEN ISNULL((SELECT users.email FROM UMUsers users WITH (NOLOCK) WHERE  cEmails.UserId= users.id),'')
							  END
			FROM #customerContactEmail cEmails
			WHERE cEmails.contactId =0
			set @MailTo = (select COALESCE(email + ';','')   from  #customerContactEmail for xml path(''))
		END
	END
END
ELSE
BEGIN
   IF (@i_bAllContact IS NOT NULL AND @i_bAllContact>0)
   BEGIN
		EXEC wr_GetProfileContactInfo 1,@i_ccGroupId,1,'#customerContactInfo1',@i_companyId
		set @MailTo = (select COALESCE(email + ';','')   from  #customerContactInfo1 for xml path(''))
	END
	ELSE
	BEGIN
		DECLARE @request1 XML =  ISNULL(CAST(@i_ncontactList AS XML),'')
		INSERT INTO #customerContactEmail(contactId,  UserId)
		SELECT
			ISNULL(contacts.value('(@contactId)[1]','[int]'), 0),
			ISNULL(contacts.value('(name/@userId)[1]','[int]'), 0)
		From @request1.nodes('WebReport_ProfileFeedbackResp/ImmediateFeedback/contacts') contacts(contacts)
		UPDATE cEmails
		SET email = CASE WHEN LEN(contacts.contactEmail)>2 THEN contacts.contactEmail
						 WHEN  contacts.contactUserId>0    THEN ISNULL((SELECT users.email FROM UMUsers users WITH (NOLOCK) WHERE  contacts.contactUserId= users.id),'')
						  END
		FROM #customerContactEmail cEmails INNER JOIN
		ProfileCustomerContact  (NOLOCK) contacts
on contacts.contactId =cEmails.contactId AND contacts.status =0
		UPDATE cEmails
		SET email = CASE WHEN  cEmails.UserId>0    THEN ISNULL((SELECT users.email FROM UMUsers users WITH (NOLOCK) WHERE  cEmails.UserId= users.id),'')
						  END
		FROM #customerContactEmail cEmails
		WHERE cEmails.contactId =0
		set @MailTo = (select COALESCE(email + ';','')   from  #customerContactEmail for xml path(''))
	END
END
DROP TABLE #customerContactEmail
DROP TABLE #customerContactInfo1
set @Subject = @customerName
if (LEN(@Subject)>0)
	set @Subject =@Subject + '- Request For Feedback'
else
	set @Subject = '- Request For Feedback'
SELECT  @mailBody,@MailTo,@Subject
GO

IF EXISTS (select * from GxQscripts where name = 'wr_GetProfileFeedbackMailInfo')
	delete from GxQscripts where name = 'wr_GetProfileFeedbackMailInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_GetProfileFeedbackMailInfo')
	delete from GXDBVersions where aliasname = 'wr_GetProfileFeedbackMailInfo'
GO

insert into GXDBVersions values(2, 'wr_GetProfileFeedbackMailInfo',  '00010003000200060000', 'wr_GetProfileFeedbackMailInfo', '00010003000200060000')
GO

