

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_GetProfileData.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_GetProfileData <<<'

IF EXISTS (select * from sysobjects where name='wr_GetProfileData')
	drop procedure wr_GetProfileData
IF EXISTS (select * from GxQscripts where name='wr_GetProfileData')
	delete from GxQscripts where name = 'wr_GetProfileData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_GetProfileData')
	delete from GXDBVersions where aliasname = 'wr_GetProfileData'
GO
print '... Creating Procedure: wr_GetProfileData'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_GetProfileData
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/*
i_EntityReq =
enum ProfileEntity
{
     Task=1,
     CustomerInfo=2,
     CustomerTouch=3,
     Documents=4,
     StatusNote=5,--for Weekly Status
     StatusMail=6,
	 UpdateEntity=7,  --this is to update the status of any entity
	 Notification=8
}
i_subEntity =
0 -- to Get all
1 -- to get contact information about the customer
2 -- this is to get latest contract date for customer
 3 -- this is to get all or with date range given input
 4 -- this is to get customer status
*/
  @i_UserId INT = 0,
  @i_EntityReq INT = NULL,
  @i_ccGroupId INT = 0,
  @i_TouchId INT = 0,
  @i_taskId INT = 0,
  @i_commcellId INT = 0,
  @i_subEntity INT = 0,
  @i_TOP INT = 5,
  @b_latest INT = 1,
  @i_bneedCount INT = 0,
  @i_dateRange INT = 0,
  @i_startdate INT = null,
  @i_enddate INT = null,
  @i_companyId INT = 0
AS
  DECLARE @response xml
/*
Message MetricsTaskCommcellInfo
{
	INT	targetCommCellID,
	INT	targetCommCellgroupID
}
ProfileTaskAssociation
assocType for
1		TASK association with customer ,ccgroup,touch, etc.
2		Touch association customerId,ccGroupId,
3		Customer association with ccgroup
*/
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @profileEntity INT = 0,@taskOperation INT =0
DECLARE @errorString NVARCHAR(MAX) =''
IF (@i_TOP IS NULL OR @i_TOP<0)
 SET @i_TOP = 5
IF (@i_EntityReq IS NULL OR @i_EntityReq = 1) --TASK
BEGIN
       Exec wr_GetProfileTaskInfo @i_UserId,@i_ccGroupId,@i_TouchId,@i_taskId,@i_commcellId,@i_TOP,@i_bneedCount,@i_companyId
	   return
END
ELSE IF (@i_EntityReq = 2) --CustomerInfo
BEGIN
	IF( @i_subEntity = 0)
	BEGIN
		SELECT  CInfo.ccGroupId				AS  'ccGroupId<DONOTSHOW>'
				,ISNULL(CInfo.reserve1,0) AS  'companyId<DONOTSHOW>'
				,CInfo.name			AS  'Customer Name<ProfileCustName>'
				,CInfo.address		AS  'Address'
				,CInfo.overview						AS  'Overview'
				,CInfo.environmentInfo				AS  'Environment'
				,CInfo.paidAccount					AS  'Paid Account<AccountType>'
				,CInfo.createdBy             AS  'CreatedId<DONOTSHOW>'
				,ISNULL((SELECT CASE WHEN users.name IS NULL OR len(users.name)<1 THEN users.login ELSE users.name END  from UMUsers users WITH (NOLOCK) WHERE CInfo.createdBy = users.id),'N/A')                  AS  'Created By'
   				,CInfo.lastModifiedBy			 AS  'ModifiedId<DONOTSHOW>'
				,ISNULL((SELECT users.name  FROM UMUsers users WITH (NOLOCK) WHERE CInfo.lastModifiedBy = users.id),'N/A')           AS  'Last Modified By<HIDDEN>'
 			    ,CInfo.docShareFolderId		AS  'ShareFolderId<DONOTSHOW>'
			    ,CInfo.docCustPath			AS  'Document Path<DONOTSHOW>'
				,ISNULL(folderPath.folderpath,'')		AS  'Folder Path<DONOTSHOW>'
		FROM ProfileCustomerInfo AS CInfo WITH (NOLOCK)
		INNER JOIN
		ProfileTaskAssociation AS assoc WITH (NOLOCK) ON
		((assoc.ccGroupId = CInfo.ccGroupId AND assoc.ccGroupId  = @i_ccGroupId AND   @i_ccGroupId <> 0)
		OR (assoc.customerId = CInfo.customerId AND CInfo.reserve1  = @i_companyId AND   @i_companyId <> 0)
OR (@i_companyId = 0 AND @i_ccGroupId = 0 )) AND assoc.assocType =  3
AND CInfo.customerId>0 AND CInfo.status = 0
		LEFT OUTER JOIN ProfileFolderPath AS folderPath  WITH (NOLOCK) ON
		folderPath.customerId = CInfo.customerId
		ORDER BY CInfo.name	 ASC
		return
	END
	ELSE IF( @i_subEntity = 1)
	BEGIN
           Exec wr_GetProfileContactInfo 1,@i_ccGroupId,0,NULL,@i_companyId
		   return
	END
	ELSE IF( @i_subEntity = 2) -- this is to get latest contract date for customer
	BEGIN
		SELECT  cDates.ccGroupId				AS  'ccGroupId<DONOTSHOW>'
				,cDates.reserve1				AS 'companyId<DONOTSHOW>'
				,cDates.customerId         AS  'customerId<DONOTSHOW>'
				,cDates.contractId         AS  'contractId'
				,cDates.contractType         AS  'contractType<ContractType>'
				,dbo.getUnixtime(cDates.startDate) 	AS  'Start Date<MMMDDYYYY>'
				,dbo.getUnixtime(cDates.endDate) 	AS  'End Date<MMMDDYYYY>' from 	ProfileContractDates	cDates
		INNER JOIN (select contracttype, max(contractId) ContractId from ProfileContractDates WITH (NOLOCK) where (ccgroupid = @i_ccGroupId and @i_ccGroupId <> 0) OR (reserve1 = @i_companyId AND @i_companyId <> 0) group by contracttype ) latest ON
		latest.ContractId  =  cDates.contractId and latest.contracttype  =  cDates.contracttype
INNER JOIN ProfileCustomerInfo AS CInfo WITH (NOLOCK) ON CInfo.customerId  =  cDates.customerId AND CInfo.status = 0
		AND cDates.customerId>0
		ORDER BY cDates.customerId	 ASC
		return
	END
	ELSE IF( @i_subEntity = 3) -- this is to get all or with date range given input
	BEGIN
		SELECT  cDates.ccGroupId				AS  'ccGroupId<DONOTSHOW>'
				,cDates.reserve1				AS 'companyId<DONOTSHOW>'
				,cDates.customerId         AS  'customerId<DONOTSHOW>'
				,cDates.contractId         AS  'contractId'
				,cDates.contractType         AS  'contractType<ContractType>'
				,dbo.getUnixtime(cDates.startDate) 	AS  'Start Date<MMMDDYYYY>'
				,dbo.getUnixtime(cDates.endDate) 	AS  'End Date<MMMDDYYYY>'
		FROM ProfileContractDates AS cDates WITH (NOLOCK)
INNER JOIN ProfileCustomerInfo AS CInfo WITH (NOLOCK) ON CInfo.customerId  =  cDates.customerId AND CInfo.status = 0
		AND ((cDates.ccGroupId  = @i_ccGroupId AND cDates.reserve1 = @i_companyId )OR  (@i_ccGroupId = 0 AND @i_companyId = 0))
		AND cDates.customerId>0
		AND (@i_dateRange = 0 OR (@i_dateRange =1 AND dbo.getUnixtime(cDates.endDate) between @i_startdate and @i_enddate))
		ORDER BY cDates.customerId	 ASC
		return
	END
	ELSE IF( @i_subEntity = 4) -- this is to get customer status
	BEGIN
		SELECT  CInfo.ccGroupId				AS  'ccGroupId'
		,cInfo.reserve1				AS 'companyId<DONOTSHOW>'
,CASE WHEN CInfo.status = 0 THEN 1 ELSE 0 END          AS  'status'
		FROM ProfileCustomerInfo AS CInfo WITH (NOLOCK)
		WHERE ((CInfo.ccGroupId  = @i_ccGroupId AND CInfo.reserve1 = @i_companyId )OR  (@i_ccGroupId = 0 AND @i_companyId = 0))
		AND CInfo.customerId>0
		ORDER BY CInfo.ccGroupId	 ASC
		return
	END
END
ELSE IF (@i_EntityReq = 3) --CustomerTouchInfo
BEGIN
	IF ( @b_latest = 0) --NEED ALL TouchInfo for last 12 month
	BEGIN
			SELECT   ISNULL(assoc.ccGroupId,0)				AS  'ccGroupId<DONOTSHOW>',
				ISNULL(CInfo.reserve1 ,0)		AS 'companyId <DONOTSHOW>'
				,Ctouchfo.touchId								AS  'CustomerTouchId<DONOTSHOW>'
				,dbo.getUnixtime(Ctouchfo.touchDate)			AS  'Touch Date<MMMDDYYYY>'
				,Ctouchfo.submittedBy             AS  'SubmittedId<DONOTSHOW>'
				,ISNULL((SELECT CASE WHEN users.name IS NULL OR len(users.name)<1 THEN users.login ELSE users.name END  from UMUsers users WITH (NOLOCK) WHERE Ctouchfo.submittedBy = users.id),'N/A')			AS  'Submitted By'
				,Ctouchfo.custSatisfaction		AS  'Customer Satisfaction'
				,Ctouchfo.cvInfluence			AS  'Commvault Influence'
				,Ctouchfo.notes					AS  'Notes'
				,Ctouchfo.tamLocation			AS  'TAM Location<TAMLocation>'
				,Ctouchfo.daysSpent				AS  'Days Spent'
				,dbo.getUnixtime(Ctouchfo.created) AS  'Created Date<MMMDDYYYY>'
			    ,Ctouchfo.createdBy             AS  'CreatedId<DONOTSHOW>'
				,ISNULL((SELECT CASE WHEN users.name IS NULL OR len(users.name)<1 THEN users.login ELSE users.name END  from UMUsers users WITH (NOLOCK) WHERE Ctouchfo.createdBy = users.id),'N/A')                  AS  'Created By'
 			    ,CInfo.docShareFolderId		AS  'ShareFolderId<DONOTSHOW>'
			    ,CInfo.docCustPath			AS  'Document Path<DONOTSHOW>'
				,ISNULL(folderPath.folderpath,'')		AS  'Folder Path<DONOTSHOW>'
				,dbo.getUnixtime(ISNULL((SELECT attrVal FROM ProfileCustomerTouchProp  (NOLOCK) WHERE touchId = Ctouchfo.touchId and attrName ='customertouchStartdate'),Ctouchfo.touchDate)) AS  'Time Period Start<MMMDDYYYY>'
				,dbo.getUnixtime(ISNULL((SELECT attrVal FROM ProfileCustomerTouchProp  (NOLOCK) WHERE touchId = Ctouchfo.touchId and attrName ='customertouchEnddate'),Ctouchfo.touchDate)) AS  'Time Period End<MMMDDYYYY>'
		FROM ProfileCustomerTouch AS Ctouchfo WITH (NOLOCK)
INNER JOIN ProfileTaskAssociation AS assoc WITH (NOLOCK) ON	assoc.touchId = Ctouchfo .touchId and assoc.customerId = Ctouchfo.customerId and assoc.assocType =  2
INNER JOIN ProfileCustomerInfo  AS CInfo WITH (NOLOCK) ON	assoc.customerId = CInfo.customerId AND CInfo.status = 0
		AND (Ctouchfo.touchId = @i_TouchId  OR   @i_TouchId = 0)
		AND (( assoc.ccGroupId  = @i_ccGroupId AND   @i_ccGroupId <> 0)
		OR ( CInfo.reserve1  = @i_companyId AND   @i_companyId <> 0)
		OR (@i_companyId = 0 AND @i_ccGroupId = 0 ))
		AND (@i_dateRange = 0 OR (@i_dateRange =1 AND  dbo.getUnixtime(Ctouchfo.touchdate) between @i_startdate and @i_enddate))
		AND Ctouchfo.customerId>0
		LEFT OUTER JOIN ProfileFolderPath AS folderPath  WITH (NOLOCK) ON
		folderPath.touchId = Ctouchfo.touchId
		ORDER BY Ctouchfo.created ASC,CInfo.name	 ASC
		return
	END
	ELSE
	BEGIN
		SELECT
				  ISNULL(assoc.ccGroupId,0)				AS  'ccGroupId<DONOTSHOW>',
				ISNULL(CInfo.reserve1 ,0)		AS 'companyId <DONOTSHOW>'
				,CInfo.name			AS  'Customer Name<ProfileCustName>'
				,Ctouchfo.touchId								AS  'CustomerTouchId<DONOTSHOW>'
				,dbo.getUnixtime(Ctouchfo.touchDate)			AS  'Touch Date<MMMDDYYYY>'
				,Ctouchfo.submittedBy             AS  'SubmittedId<DONOTSHOW>'
				,ISNULL((SELECT CASE WHEN users.name IS NULL OR len(users.name)<1 THEN users.login ELSE users.name END  from UMUsers users WITH (NOLOCK) WHERE Ctouchfo.submittedBy = users.id),'N/A')			AS  'Submitted By'
				,Ctouchfo.custSatisfaction		AS  'Customer Satisfaction'
				,Ctouchfo.cvInfluence			AS  'Commvault Influence'
				,Ctouchfo.notes					AS  'Notes'
				,Ctouchfo.tamLocation			AS  'TAM Location<TAMLocation>'
				,Ctouchfo.daysSpent				AS  'Days Spent'
 			    ,CInfo.docShareFolderId		AS  'ShareFolderId<DONOTSHOW>'
			    ,CInfo.docCustPath			AS  'Document Path<DONOTSHOW>'
				,ISNULL(folderPath.folderpath,'')		AS  'Folder Path<DONOTSHOW>'
				,dbo.getUnixtime(ISNULL((SELECT attrVal FROM ProfileCustomerTouchProp  (NOLOCK) WHERE touchId = Ctouchfo.touchId and attrName ='customertouchStartdate'),Ctouchfo.touchDate)) AS  'Time Period Start<MMMDDYYYY>'
				,dbo.getUnixtime(ISNULL((SELECT attrVal FROM ProfileCustomerTouchProp  (NOLOCK) WHERE touchId = Ctouchfo.touchId and attrName ='customertouchEnddate'),Ctouchfo.touchDate)) AS  'Time Period End<MMMDDYYYY>'
		FROM ProfileCustomerTouch AS Ctouchfo WITH (NOLOCK)
INNER JOIN ProfileTaskAssociation AS assoc WITH (NOLOCK) ON	assoc.touchId = Ctouchfo .touchId and assoc.customerId = Ctouchfo.customerId and assoc.assocType =  2
INNER JOIN ProfileCustomerInfo  AS CInfo WITH (NOLOCK) ON	assoc.customerId = CInfo.customerId  AND CInfo.status = 0
		INNER JOIN (select customerId,max(touchId) AS touchId FROM ProfileCustomerTouch WITH (NOLOCK) GROUP BY customerId ) latesttouch
		ON latesttouch.touchId = Ctouchfo.touchId AND  latesttouch.customerId = Ctouchfo.customerId
		AND (Ctouchfo.touchId = @i_TouchId  OR   @i_TouchId = 0)
		AND (( assoc.ccGroupId  = @i_ccGroupId AND   @i_ccGroupId <> 0)
		OR ( CInfo.reserve1  = @i_companyId AND   @i_companyId <> 0)
		OR (@i_companyId = 0 AND @i_ccGroupId = 0 ))
		AND Ctouchfo.customerId>0
		LEFT OUTER JOIN ProfileFolderPath AS folderPath  WITH (NOLOCK) ON
		folderPath.touchId = Ctouchfo .touchId
		ORDER BY CInfo.name	 ASC
		return
	END
END
ELSE IF (@i_EntityReq = 5) --weekly notes
BEGIN
SELECT  Notes.ccGroupId			AS  'ccGroupId<DONOTSHOW>',
		Notes.reserve1			AS  'companyId<DONOTSHOW>'
		,Notes.statusId			AS  'statusId<DONOTSHOW>'
		,Notes.customerId       AS  'customerId<DONOTSHOW>'
		,Notes.currentState     AS  'currentState'
		,Notes.currentStatus    AS  'currentStatus'
		,Notes.nextStatus		AS  'nextStatus'
		,dbo.getUnixtime(Notes.CREATED)			AS  'Created Date<MMMDDYYYY>'
		FROM ProfileStatusNote AS Notes WITH (NOLOCK)
INNER JOIN ProfileCustomerInfo AS CInfo WITH (NOLOCK) ON CInfo.customerId  =  Notes.customerId AND CInfo.status = 0
		AND (( Notes.ccGroupId  = @i_ccGroupId AND   @i_ccGroupId <> 0)
		OR ( CInfo.reserve1  = @i_companyId AND   @i_companyId <> 0)
		OR (@i_companyId = 0 AND @i_ccGroupId = 0 ))
		AND (@i_dateRange = 0 OR (@i_dateRange =1 AND dbo.getUnixtime(Notes.CREATED) between @i_startdate and @i_enddate))
		AND Notes.customerId>0
		order by Notes.CREATED DESC
		return
END
GO

IF EXISTS (select * from GxQscripts where name = 'wr_GetProfileData')
	delete from GxQscripts where name = 'wr_GetProfileData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_GetProfileData')
	delete from GXDBVersions where aliasname = 'wr_GetProfileData'
GO

insert into GXDBVersions values(2, 'wr_GetProfileData',  '00010005000200070000', 'wr_GetProfileData', '00010005000200070000')
GO

