

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_GetProfileContactInfo.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_GetProfileContactInfo <<<'

IF EXISTS (select * from sysobjects where name='wr_GetProfileContactInfo')
	drop procedure wr_GetProfileContactInfo
IF EXISTS (select * from GxQscripts where name='wr_GetProfileContactInfo')
	delete from GxQscripts where name = 'wr_GetProfileContactInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_GetProfileContactInfo')
	delete from GXDBVersions where aliasname = 'wr_GetProfileContactInfo'
GO
print '... Creating Procedure: wr_GetProfileContactInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_GetProfileContactInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @i_UserId INT = 0,
  @i_ccGroupId INT = 0,
  @i_AllUsers INT = 0,
  @i_tableOutput NVARCHAR(MAX) = NULL,
  @i_companyId INT = 0
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	IF (@i_AllUsers IS NULL OR @i_AllUsers = 0) --Get Both User external as well as CV
	BEGIN
	SET @i_AllUsers = 3
	END
	DECLARE @CustomerId INT  = 0
	IF (@i_companyId > 0)
		SELECT  @CustomerId = customerId FROM ProfileCustomerInfo t WHERE reserve1  = @i_companyId
	ELSE
	IF (@i_CCGroupId > 0)
		SELECT @CustomerId =  customerId FROM ProfileCustomerInfo t WHERE ccGroupId = @i_CCGroupId
	ELSE
		RETURN
	-- OUTPUT TABLE
	IF object_id('tempdb.dbo.#customerContactInfo') IS NOT null	DROP TABLE #customerContactInfo
	CREATE TABLE #customerContactInfo (CustomerInfoId INT, ContactId INT,  UserId INT, contactName nvarchar(max), contactTitle nvarchar(max), email nvarchar (255),contactPhone nvarchar (255),contactgroup  INT,isPrimaryContact INT,status INT  )
	IF((@i_AllUsers&1) = 1) -- GET CUSTOMER USERS
	BEGIN
		-- GET DEFAULT CUSTOMER USERS
		IF object_id('tempdb.dbo.#customerUserTable') IS NOT null	DROP TABLE #customerUserTable
		CREATE TABLE #customerUserTable (userId INT, UserName nvarchar(max), email nvarchar (255) )
		INSERT INTO #customerUserTable  (userId , UserName , email)
		EXEC wr_GetProfileCustomerContact 1,@i_ccGroupId,@i_companyId
		-- CUSTOMER USERS HAS TO BE REGISTER FIRST WITH UMUSERS
		-- INSERT DEFAULT CUSTOMER USERS AS MANAGEMENT TEAM
		INSERT INTO #customerContactInfo  (CustomerInfoId ,ContactId ,UserId , contactName , contactTitle , email , contactPhone , contactgroup , isPrimaryContact, status)
		select  @CustomerId ,
				ISNULL(Ccontact.contactId,0) ,
				U.userId ,
				U.UserName ,
				ISNULL(Ccontact.contactTitle,'') ,
				U.email,
				ISNULL(Ccontact.contactPhone,'') ,
				ISNULL(Ccontact.contactgroup,0) ,
				ISNULL(Ccontact.isPrimaryContact,0) ,
				0
		FROM #customerUserTable U
		LEFT OUTER JOIN
		ProfileCustomerContact AS Ccontact WITH (NOLOCK)
		ON Ccontact.CustomerInfoId = @CustomerId
		AND Ccontact.contactUserId =U.userId
		AND Ccontact.contactgroup!=4
AND Ccontact.status =0
        WHERE Ccontact.contactUserId  IS NULL
		DROP TABLE #customerUserTable
	INSERT INTO #customerContactInfo  (CustomerInfoId ,ContactId ,UserId , contactName , contactTitle , email , contactPhone , contactgroup , isPrimaryContact, status)
		select  @CustomerId ,
				Ccontact.contactId ,
				Ccontact.contactUserId ,
				CASE WHEN Ccontact.contactUserId  > 0
					  THEN ISNULL((SELECT CASE WHEN users.name IS NULL OR len(users.name)<1 THEN users.login ELSE users.name END  from UMUsers users WITH (NOLOCK) WHERE Ccontact.contactUserId = users.id),'')
					  ELSE Ccontact.contactName
				 END,
				Ccontact.contactTitle ,
				CASE WHEN Ccontact.contactUserId  > 0
					  THEN ISNULL((SELECT users.email FROM UMUsers users WITH (NOLOCK) WHERE Ccontact.contactUserId = users.id),'')
					  ELSE Ccontact.contactEmail
				END,
				Ccontact.contactPhone ,
				Ccontact.contactgroup ,
				Ccontact.isPrimaryContact,
				Ccontact.status
		FROM ProfileCustomerContact AS Ccontact WITH (NOLOCK)
		WHERE Ccontact.CustomerInfoId = @CustomerId
			AND Ccontact.contactgroup!=4
AND Ccontact.status =0
	END
	IF((@i_AllUsers&2) = 2) -- GET COMMVAULT USERS
	BEGIN
		-- INSERT CV USERS INFORMATION
		INSERT INTO #customerContactInfo  (CustomerInfoId ,ContactId ,UserId , contactName , contactTitle , email , contactPhone , contactgroup , isPrimaryContact, status)
		SELECT  Ccontact.CustomerInfoId
				,Ccontact.contactId
				,Ccontact.contactUserId
				,CASE WHEN Ccontact.contactUserId  > 0
					  THEN ISNULL((SELECT CASE WHEN users.name IS NULL OR len(users.name)<1 THEN users.login ELSE users.name END  from UMUsers users WITH (NOLOCK) WHERE Ccontact.contactUserId = users.id),'')
					  ELSE Ccontact.contactName
				END
				,Ccontact.contactTitle
				,CASE WHEN Ccontact.contactUserId  > 0
					  THEN ISNULL((SELECT users.email FROM UMUsers users WITH (NOLOCK) WHERE Ccontact.contactUserId = users.id),'')
					  ELSE Ccontact.contactEmail
				END
				,Ccontact.contactPhone
				,Ccontact.contactgroup
				,Ccontact.isPrimaryContact
				,Ccontact.status
		FROM ProfileCustomerContact AS Ccontact WITH (NOLOCK)
INNER JOIN ProfileCustomerInfo AS CInfo WITH (NOLOCK) ON CInfo.customerId  =  Ccontact.CustomerInfoId AND CInfo.status = 0
		INNER JOIN ProfileTaskAssociation AS assoc WITH (NOLOCK) ON
		((assoc.ccGroupId = CInfo.ccGroupId AND assoc.ccGroupId  = @i_ccGroupId and @i_ccGroupId <> 0)
OR	(assoc.customerId  = cInfo.customerId AND (CInfo. reserve1  = @i_companyId and @i_companyId <> 0)))   and assoc.assocType = 3
		AND Ccontact.CustomerInfoId>0
		AND Ccontact.contactgroup=4
AND Ccontact.status =0
	END
IF (LEN(@i_tableOutput) >0)
BEGIN
DECLARE @outputSQLStatement NVARCHAR(MAX) = NULL
SET @outputSQLStatement = 'INSERT INTO ' + @i_tableOutput + '
	SELECT
	 Ccontact.CustomerInfoId
	,Ccontact.ContactId
	,Ccontact.UserId
	,Ccontact.contactName
	,Ccontact.contactTitle
	,Ccontact.email
	,Ccontact.contactPhone
	,Ccontact.contactgroup
	,Ccontact.isPrimaryContact
	,Ccontact.status
	FROM #customerContactInfo AS Ccontact WITH (NOLOCK)
	ORDER BY Ccontact.contactgroup	ASC ,  Ccontact.contactName	 ASC '
EXEC (@outputSQLStatement)
END
ELSE
BEGIN
	SELECT
	 Ccontact.CustomerInfoId			AS  'CustomerInfoId<DONOTSHOW>'
	,Ccontact.ContactId				AS  'ContactId<DONOTSHOW>'
	,Ccontact.UserId					AS  'ContactUserId<DONOTSHOW>'
	,Ccontact.contactName				AS  'Contact Name'
	,Ccontact.contactTitle				AS  'Contact Title'
	,Ccontact.email						AS  'Email'
	,Ccontact.contactPhone				AS  'Phone'
	,Ccontact.contactgroup				AS  'Group'
	,Ccontact.isPrimaryContact			AS  'Primary Contact'
	,Ccontact.status
	FROM #customerContactInfo AS Ccontact WITH (NOLOCK)
	ORDER BY Ccontact.contactgroup	ASC ,  Ccontact.contactName	 ASC
END
	DROP TABLE #customerContactInfo
GO

IF EXISTS (select * from GxQscripts where name = 'wr_GetProfileContactInfo')
	delete from GxQscripts where name = 'wr_GetProfileContactInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_GetProfileContactInfo')
	delete from GXDBVersions where aliasname = 'wr_GetProfileContactInfo'
GO

insert into GXDBVersions values(2, 'wr_GetProfileContactInfo',  '00010001000200050000', 'wr_GetProfileContactInfo', '00010001000200050000')
GO

