

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_GetCommCellProfileData.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_GetCommCellProfileData <<<'

IF EXISTS (select * from sysobjects where name='wr_GetCommCellProfileData')
	drop procedure wr_GetCommCellProfileData
IF EXISTS (select * from GxQscripts where name='wr_GetCommCellProfileData')
	delete from GxQscripts where name = 'wr_GetCommCellProfileData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_GetCommCellProfileData')
	delete from GXDBVersions where aliasname = 'wr_GetCommCellProfileData'
GO
print '... Creating Procedure: wr_GetCommCellProfileData'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_GetCommCellProfileData
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @request XML
AS
  DECLARE @response xml
/*
--Profile messages start
Message CommcellProfileTask
{
     ProfileTaskInfo taskInfo
	 list<ProfileTaskProp>		taskProps
}
Message ProfileTaskInfo
{
    int         taskId
    wstring  summary
    wstring  url     --any url
    wstring  description
    UserEntity user
    UserEntity assignedTo
    ProfileTaskStatus        status --1-open, 2-Fixed/Monitoring, 3-Closed, 4-Killed
    long       dueDate
    long       startDate
	wstring    statusChangeReason
	wstring    dueDateChangeReason
    list<int>  touchIds
    int      reportId
    list<TaskCommCells> commcells
    int         customerInfoId
    ProfileTaskType   taskType
    wstring  emails
    wstring     notes
    int		repeatNdays
    boolean          internalTask
}
Message ProfileTaskProp
{
     int		   taskId = 0
	 wstring       attrName
	 int           attrType
	 wstring       attrVal
	 int		   status = 0   --0 Add, 1 Deleted
}
Message GetCommcellProfileReq
{
     ProfileTaskProp prop
}
Message CommcellProfileResp
{
     GenericResp msg
    list<CommcellProfileTask> tasks
}
--Profile messages end
ProfileTaskAssociation
*/
DECLARE @EDISCOVERY_TASK_VIEW INT = 223 --CAT_EDISCOVERY_TASK_VIEW
DECLARE @EDISCOVERY_TASK_ENTITY INT = 9515
DECLARE @profileEntity INT = 0,@taskOperation INT =0
DECLARE @errorString NVARCHAR(MAX) =''
DECLARE @errorCode INT  =0
DECLARE @taskresp XML = NULL
DECLARE @ProcessTran INT
DECLARE @userId INT = 0
DECLARE @action INT = 0
SET @ProcessTran = 0
BEGIN TRY
	IF (@@TRANCOUNT = 0)
	BEGIN
		BEGIN TRANSACTION ProcessTran
		SET @ProcessTran = 1
	END
	SELECT
	-- Added by Anh to check permission
	@userId = ISNULL(@request.value('(/WebReport_GetCommcellProfileReq/@userId)[1]', 'integer'), 0)
	IF (@userId <= 0)
	BEGIN
		SELECT @errorCode = 10551, @errorString = 'Invalid User Id: ' + CONVERT(vARCHAR(10), @userId)
		GOTO CX_ERROR_EXIT;
	END
	IF OBJECT_ID('tempdb.dbo.#sec_GetTaskList') IS NOT NULL
		DROP TABLE #sec_GetTaskList
	CREATE  TABLE #sec_GetTaskList ( taskId INT);
	CREATE INDEX sec_GetTaskList_taskId_idx on #sec_GetTaskList(taskId);
	IF OBJECT_ID('tempdb.dbo.#permissionIdTable') IS NOT NULL
		DROP TABLE #permissionIdTable
	CREATE TABLE #permissionIdTable (permissionId INT)
	--Contains objects tables to be used by SP.
	IF OBJECT_ID('tempdb.dbo.#getObjectsTable') IS NOT NULL
		DROP TABLE #getObjectsTable
	CREATE TABLE #getObjectsTable (entityId INT, permissionId INT)
	INSERT INTO #permissionIdTable
	SELECT @EDISCOVERY_TASK_VIEW /*CAT_EDISCOVERY_TASK_VIEW*/
	EXEC sec_getObjectsWithPermissionsV2 @userId, 9515 ,0
	-- we will clean up taskIds that are not valid
	--
	BEGIN
		;WITH ValidDSIds AS (
			SELECT DISTINCT entityId FROM #getObjectsTable WHERE permissionId = @EDISCOVERY_TASK_VIEW
		)
		DELETE t
		FROM #getObjectsTable as T LEFT JOIN ValidDSIds
			ON 	T.entityId = ValidDSIds.entityId
		WHERE ValidDSIds.entityId IS NULL
	END
	INSERT INTO #sec_GetTaskList
	SELECT G.entityId FROM #getObjectsTable AS G WHERE G.permissionId = @EDISCOVERY_TASK_VIEW
	-- End Added by Anh to check permission
	IF object_id('tempdb.dbo.#CSProfileTasProp') is not null DROP TABLE #CSProfileTasProp
	CREATE TABLE #CSProfileTasProp
	(
		 taskPropName				NVARCHAR(MAX),
		 taskPropVal				NVARCHAR(MAX),
		 taskPropValType			INT
	)
		INSERT INTO #CSProfileTasProp (taskPropName , taskPropVal, taskPropValType)
		SELECT DISTINCT
		ISNULL(taskProps.n.value('(@attrName)', 'nvarchar(max)'), ''),
		ISNULL(taskProps.n.value('(@attrVal)', 'nvarchar(max)'), ''),
		ISNULL(taskProps.n.value('(@attrType)', 'integer'), 0)
	FROM
		@request .nodes('WebReport_GetCommcellProfileReq/prop') AS taskProps(n)
	/* Code added by Anh to return task by taskId */
	IF object_id('tempdb.dbo.#CSProfileTaskInfo') is not null DROP TABLE #CSProfileTaskInfo
	CREATE TABLE #CSProfileTaskInfo
	(
		 taskId			INT
	)
		INSERT INTO #CSProfileTaskInfo (taskId)
		SELECT DISTINCT
		ISNULL(taskInfo.n.value('(@taskId)', 'integer'), 0)
	FROM
		@request .nodes('WebReport_GetCommcellProfileReq/taskBasicprop/taskInfo') AS taskInfo(n)
	/* End: Code added by Anh to return task by taskId */
	IF object_id('tempdb.dbo.#IdentityTable') is not null DROP TABLE #IdentityTable
	CREATE TABLE #IdentityTable
	(
		taskId					 INT
	)
	/* Code added by Anh to return task by taskId */
	IF ((SELECT COUNT(*) FROM #CSProfileTaskInfo WHERE taskId>0) > 0)
	BEGIN
		INSERT INTO #IdentityTable(taskId)
		SELECT taskId FROM #CSProfileTaskInfo WHERE taskId IN (SELECT * FROM #sec_GetTaskList)
	END
	ELSE
	/* End : Code added by Anh to return task by taskId */
	IF ((SELECT COUNT(*) FROM #CSProfileTasProp )>0)
	BEGIN
		INSERT INTO #IdentityTable(taskId)
		SELECT DISTINCT PROP.taskId FROM ProfileTaskProp PROP
		INNER JOIN #CSProfileTasProp I ON PROP.attrName = I.taskPropName AND PROP.attrVal LIKE I.taskPropVal
		WHERE PROP.taskId IN (SELECT * FROM #sec_GetTaskList)
	END
	ELSE
	BEGIN
		INSERT INTO #IdentityTable(taskId)
		SELECT DISTINCT T.taskId FROM ProfileTaskInfo T WHERE T.taskId IN (SELECT * FROM #sec_GetTaskList)
	END
	DECLARE @CommcellProfileResp xml
	SET @CommcellProfileResp = (
	SELECT
		taskInfo.taskId			AS 'taskInfo/@taskId',
		taskSummary		AS 'taskInfo/@summary',
		taskUrl			AS 'taskInfo/@url',
		taskDescription	AS 'taskInfo/@description',
		status			AS 'taskInfo/@status',
		DBO.GETUNIXTIMEBIG(dueDate)			AS 'taskInfo/@dueDate',
		DBO.GETUNIXTIMEBIG(created)			AS 'taskInfo/@startDate',
		taskType		AS 'taskInfo/@taskType',
		emailTo			AS 'taskInfo/@emailTo',
		tasknotes		AS 'taskInfo/@tasknotes',
		taskOwnerId		AS 'user/@userId',
		assignedTo		AS 'assignedTo/@userId',
		(SELECT
			taskProp.attrname			AS '@attrName',
			taskProp.attrType			AS '@attrType',
			taskProp.attrVal			AS '@attrVal',
			taskProp.status			AS '@status'
		FROM ProfileTaskProp taskProp
		WHERE T.taskId =taskProp.taskId
		FOR XML PATH('taskProps'),TYPE
		)
	FROM ProfileTaskInfo taskInfo
	INNER JOIN #IdentityTable T ON T.taskId =taskInfo.taskId
	WHERE taskInfo.status NOT IN (3,4) /* 3: closed, 4: killed. This is used to filter out deleted task in the response */
	ORDER BY created DESC
	FOR XML PATH('tasks')
	)
	SET @taskresp = (
	SELECT
		@CommcellProfileResp
	FOR XML PATH('WebReport_CommcellProfileResp')
	)
	IF (@ProcessTran = 1)
	BEGIN
		COMMIT TRANSACTION ProcessTran
		SET @ProcessTran = 0
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
IF (XACT_STATE() <> 0 AND @ProcessTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessTran
	SET @ProcessTran = 0
	SELECT @errorCode = 1
	SELECT @errorString = 'Exception  - failed with error :: ' + ERROR_MESSAGE()
END
END CATCH
CX_ERROR_EXIT:
	SET @response = (SELECT @errorCode as '@errorCode' , @errorString as '@errorMessage' FOR XML PATH('msg')    )
	SET @response = (select @response,@taskresp FOR XML PATH('WebReport_ProfileResp')    )
IF (XACT_STATE() <> 0 AND @ProcessTran = 1)
BEGIN
	ROLLBACK TRANSACTION ProcessTran
	SET @ProcessTran = 0
END
	SELECT @response
GO

IF EXISTS (select * from GxQscripts where name = 'wr_GetCommCellProfileData')
	delete from GxQscripts where name = 'wr_GetCommCellProfileData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_GetCommCellProfileData')
	delete from GXDBVersions where aliasname = 'wr_GetCommCellProfileData'
GO

insert into GXDBVersions values(2, 'wr_GetCommCellProfileData',  '00010001000400050000', 'wr_GetCommCellProfileData', '00010001000400050000')
GO

