

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_ForecastMovAvg.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/wr_ForecastMovAvg.sp,v $ $Id: wr_ForecastMovAvg.sp,v 1.2 2010/09/27 14:08:51 evolohov Exp $";
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Eugene Volohov
-- Create date: 08/11/2010
-- Description: Forecasts data values based on existsing data using simple moving average method
--
--              Given a series of numbers and a fixed subset size, the moving average can be obtained by first
--              taking the average of the first subset. The fixed subset size is then shifted forward, creating
--              a new subset of numbers, which is averaged. This process is repeated over the entire data series.
--              The plot line connecting all the (fixed) averages is the moving average. Thus, a moving average
--              is not a single number, but it is a set of numbers, each of which is the average of the
--              corresponding subset of a larger set of data points. A moving average may also use unequal weights
--              for each data value in the subset to emphasize particular values in the subset.
--              A simple moving average (SMA) is the unweighted mean of the previous n data points.
--              For example, a 10-day simple moving average of data size is the mean of the previous 10 days'
--              data sizes. If those sizes are : P{m}, P{m-1}...P{m-} then the formula is :
--
--                    P{m} + P{m-1} + ... + P{m-9}
--              SMA = ----------------------------
--                                 10
--
--              When calculating successive values, a new value comes into the sum and an old value drops out,
--              meaning a full summation each time is unnecessary:
--
--                                              P{m-n}      P{m}
--              SMA {today} = SMA {yesterday} - -------- +  ----
--                                                n           n
--
--
-- Parameters :
--
-- -----------------------------------------------------------------------------------------------------------
-- ----------------------------------------------------------
-- $Log:  $
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_ForecastMovAvg <<<'

IF EXISTS (select * from sysobjects where name='wr_ForecastMovAvg')
	drop procedure wr_ForecastMovAvg
IF EXISTS (select * from GxQscripts where name='wr_ForecastMovAvg')
	delete from GxQscripts where name = 'wr_ForecastMovAvg'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_ForecastMovAvg')
	delete from GXDBVersions where aliasname = 'wr_ForecastMovAvg'
GO
print '... Creating Procedure: wr_ForecastMovAvg'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure wr_ForecastMovAvg
  @debug INT,
  @inputTableArg VARCHAR(64),
  @numIntervals INT,
  @numTotal INT,
  @id VARCHAR(64),
  @id2 VARCHAR(64),
  @y VARCHAR(64),
  @cumY VARCHAR(64),
  @y2 VARCHAR(64),
  @cumY2 VARCHAR(64)
AS
-- ---------------------------------------------------------------------------------
-- DECLARE variables
--
DECLARE	@I	    INT
DECLARE @median	INT
DECLARE @first	INT
DECLARE @last	INT
-- ---------------------------------------------------------------------------------
-- Initialize variables
--
SET @I			= 0
SET @median		= ROUND(@numIntervals * 1.0 / 2, 0)
SET @first		= 0
SET @last		= 0
-- ---------------------------------------------------------------------------------
-- Temporary tables
--
IF OBJECT_ID('tempdb.dbo.#Fcast_MovAvg')        IS NOT NULL DROP TABLE #Fcast_MovAvg
if OBJECT_ID('tempdb.dbo.#Fcast_MovAvg_linear') IS NOT NULL DROP TABLE #Fcast_MovAvg_linear
CREATE TABLE #Fcast_MovAvg
(
    ID          INT,
    ID2         INT,
    Predicted   INT,
    X           INT,
    Y           BIGINT,
    CumY        BIGINT,
    MovAvg      FLOAT,
    Idx         FLOAT,
    AvgIdx      FLOAT,
    Y2          BIGINT,
    CumY2       BIGINT,
    MovAvg2     FLOAT,
    Idx2        FLOAT,
    AvgIdx2     FLOAT
)
CREATE TABLE #Fcast_MovAvg_linear
(
    ID          INT,
    ID2         INT,
    FormulaNum  INT,
    Ex          FLOAT,
    Ey          FLOAT,
    Exy         FLOAT,
    Ex2         FLOAT,
    m           FLOAT,
    b           FLOAT,
    formula     VARCHAR(128)
)
-- ---------------------------------------------------------------------------------
-- Populate Moving Average Temporary Table
--
EXEC( 'INSERT INTO #Fcast_MovAvg ' +
	        'SELECT ' + @id + ', ' + @id2 + ', Predicted, ' +
		    'X, ' + @y + ', 0, 0, 0, 0, ' + @y2 + ', 0, 0, 0, 0 ' +
	        'FROM ' + @inputTableArg )
-- ---------------------------------------------------------------------------------
-- Get the size of the table
--
--
-- Set the First and Last
--
SET	@first	= @median
SET	@last	= @numTotal - @median
-- Special case of when @median = 1
-- That case happens usually when the NumIntervals is 2, giving a Median of 1.
-- In the special case of NumIntervals=2, the Median must be 2 and not 1, otherwise
-- the logic below will not take into consideration the right Xs while calculating
-- the moving average.
IF @median = 1 AND @numIntervals = 2 BEGIN
	SET	@first	= 2
	SET	@last	= @numTotal - 1
	SET	@median	= 2
END
-- Another special case
-- The case of having Median = 1 and NumIntervals = 1 as well
-- In this case, we are talking about a linear prediction, so we should just
-- consider every single day on the moving average, from First (1) to Last (Total)
--
IF @median = 1 AND @numIntervals = 1 BEGIN
	SET	@first  = 1
	SET	@last	= @numTotal
	SET	@median = 1
END
IF @debug > 0 SELECT NumTotal = @numTotal, Median = @median, First = @first, Last = @last
-- ---------------------------------------------------------------------------------
-- Calculate the Medium Averages and Store it in #Fcast_MovAvg
--
-- 	For I=G/2 to N-G/2
--		(A) Compute the average of: A(I-G/2+1) - A(G-G/2+I)
--		(B) Compute the average of: A(I-G/2+1+1) - A(G-G/2+I+1)
--		(C) Compute the Average of (A) and (B)
--
-- If the number of intervals is 1, I should just behave like a linear prediction
-- and therefore, just get the average of my days without going on extra days
IF @numIntervals = 1 BEGIN
	UPDATE 	#Fcast_MovAvg
	SET 	MovAvg = (  SELECT  AVG(Y*1.0)
	                    FROM    #Fcast_MovAvg M2
					    WHERE       M2.ID = #Fcast_MovAvg.ID
					            AND M2.ID2 = #Fcast_MovAvg.ID2
					            AND M2.X >= (#Fcast_MovAvg.X - @median + 1)
					            AND M2.X <= (@numIntervals - @median + #Fcast_MovAvg.X)
					            AND M2.Predicted = 0),
		    MovAvg2 = ( SELECT  AVG(Y2*1.0) FROM #Fcast_MovAvg M2
					    WHERE       M2.ID = #Fcast_MovAvg.ID
					            AND M2.ID2 = #Fcast_MovAvg.ID2
					            AND M2.X >= (#Fcast_MovAvg.X - @median + 1)
					            AND M2.X <= (@numIntervals - @median + #Fcast_MovAvg.X)
					            AND M2.Predicted = 0)
	WHERE	    X >= @first
	        AND X <= @last
END
ELSE BEGIN
	UPDATE 	#Fcast_MovAvg
	SET 	MovAvg = (SELECT dbo.GetAvg(( SELECT AVG(Y*1.0)
				                          FROM   #Fcast_MovAvg M2
					                      WHERE  M2.ID = #Fcast_MovAvg.ID
					                             AND M2.ID2 = #Fcast_MovAvg.ID2
					                             AND M2.X >= (#Fcast_MovAvg.X - @median + 1)
					                             AND M2.X <= (@numIntervals - @median + #Fcast_MovAvg.X)
					                             AND M2.Predicted = 0 ),
				                        ( SELECT AVG(Y*1.0)
				                          FROM   #Fcast_MovAvg M2
					                      WHERE     M2.ID = #Fcast_MovAvg.ID
					                            AND M2.ID2 = #Fcast_MovAvg.ID2
					                            AND M2.X >= (#Fcast_MovAvg.X - @median + 1 + 1)
					                            AND M2.X <= (@numIntervals - @median + #Fcast_MovAvg.X + 1)
					                            AND M2.Predicted = 0))),
		    MovAvg2 = (SELECT dbo.GetAvg(( SELECT AVG(Y2*1.0) FROM #Fcast_MovAvg M2
					                       WHERE      M2.ID = #Fcast_MovAvg.ID
					                              AND M2.ID2 = #Fcast_MovAvg.ID2
 					                              AND M2.X >= (#Fcast_MovAvg.X - @median + 1)
					                              AND M2.X <= (@numIntervals - @median + #Fcast_MovAvg.X)
					                              AND M2.Predicted = 0 ),
				                         ( SELECT AVG(Y2*1.0)
				                           FROM   #Fcast_MovAvg M2
					                       WHERE      M2.ID = #Fcast_MovAvg.ID
					                              AND M2.ID2 = #Fcast_MovAvg.ID2
					                              AND M2.X >= (#Fcast_MovAvg.X - @median + 1 + 1)
					                              AND M2.X <= (@numIntervals - @median + #Fcast_MovAvg.X + 1)
					                              AND M2.Predicted = 0)))
	WHERE	X >= @first AND X <= @last
END
-- ---------------------------------------------------------------------------------
-- Calculate the Index for the Medium Moving Averages values
--
--	For I=G/2 to N-G/2
--		(A) Compute A(I) / MovAvg(I)
--		(B) Store as Idx(I)
UPDATE 	#Fcast_MovAvg
SET	    Idx =  Y  / CASE MovAvg  WHEN 0 THEN 1 ELSE MovAvg  END,
	    Idx2 = Y2 / CASE MovAvg2 WHEN 0 THEN 1 ELSE MovAvg2 END
WHERE	    X >= @first AND X <= @last
	    AND Y > 0
-- ---------------------------------------------------------------------------------
-- Calculate the AVERAGE index for the adjusted values
--
--	For I=1 to G
-- 		(A) Sum = 0, CountIdx = 0
--		(B) For J=G/2 to N-G/2
--			(A) IF I=J THEN
--				(1) Sum += Idx(J)
--				(2) CountIdx++
--		(C) Sum /= CountIdx
--		(D) Store in AvgIdx(I)
--
UPDATE 	#Fcast_MovAvg
SET 	AvgIdx = AvgIdx + ISNULL(( SELECT    SUM(Idx)
			                       FROM      #Fcast_MovAvg M2
			                       WHERE     M2.ID = #Fcast_MovAvg.ID
				                         AND M2.ID2 = #Fcast_MovAvg.ID2
				                         AND M2.X % @numIntervals = #Fcast_MovAvg.X % @numIntervals
				                         AND M2.X >= @first
				                         AND M2.X <= @last ), 0),
	    AvgIdx2 = AvgIdx2 + ISNULL(( SELECT    SUM(Idx2)
			                         FROM      #Fcast_MovAvg M2
			                         WHERE     M2.ID = #Fcast_MovAvg.ID
				                           AND M2.ID2 = #Fcast_MovAvg.ID2
				                           AND M2.X % @numIntervals = #Fcast_MovAvg.X % @numIntervals
				                           AND M2.X >= @first
				                           AND M2.X <= @last ), 0)
WHERE	    X >= 1
        AND X <= @numIntervals
UPDATE 	#Fcast_MovAvg
SET 	AvgIdx = AvgIdx / dbo.GetMaxInt(1, ( SELECT    COUNT(*)
			                                 FROM      #Fcast_MovAvg M2
			                                 WHERE     M2.ID = #Fcast_MovAvg.ID
				                                   AND M2.ID2 = #Fcast_MovAvg.ID2
				                                   AND M2.X % @numIntervals = #Fcast_MovAvg.X % @numIntervals
				                                   AND M2.X >= @first
				                                   AND M2.X <= @last )),
	    AvgIdx2 = AvgIdx2 / dbo.GetMaxInt(1, ( SELECT    COUNT(*)
			                                   FROM      #Fcast_MovAvg M2
			                                   WHERE     M2.ID = #Fcast_MovAvg.ID
				                                     AND M2.ID2 = #Fcast_MovAvg.ID2
				                                     AND M2.X % @numIntervals = #Fcast_MovAvg.X % @numIntervals
				                                     AND M2.X >= @first
				                                     AND M2.X <= @last ))
WHERE	    X >= 1
        AND X <= @numIntervals
-- ---------------------------------------------------------------------------------
-- Show the result before interpolation
--
IF @debug > 0 SELECT TableName='MovAvg', * FROM #Fcast_MovAvg
-- ---------------------------------------------------------------------------------
-- Perform Linear Interpolation on the Moving Average Values
-- to find out the Linear Formula. This information will be
-- used to compute the Forecast Moving Average
--
EXEC wr_ForecastLinear @debug, '#Fcast_MovAvg', @first, @last, 'ID', 'ID2', 'MovAvg', 'MovAvg2', '#Fcast_MovAvg_linear'
IF @debug > 0 SELECT TableName='Forecast', * FROM #Fcast_MovAvg_linear
-- ---------------------------------------------------------------------------------
-- Calculate the Forecast Points based on the formula
--
UPDATE 	#Fcast_MovAvg
SET	    MovAvg =  X * (SELECT m FROM #Fcast_MovAvg_linear F WHERE F.ID = #Fcast_MovAvg.ID and F.ID2 = #Fcast_MovAvg.ID2 and FormulaNum = 1)
		            + (SELECT b FROM #Fcast_MovAvg_linear F WHERE F.ID = #Fcast_MovAvg.ID and F.ID2 = #Fcast_MovAvg.ID2 and FormulaNum = 1),
	    MovAvg2 = X * (SELECT m FROM #Fcast_MovAvg_linear F WHERE F.ID = #Fcast_MovAvg.ID and F.ID2 = #Fcast_MovAvg.ID2 and FormulaNum = 2)
		            + (SELECT b FROM #Fcast_MovAvg_linear F WHERE F.ID = #Fcast_MovAvg.ID and F.ID2 = #Fcast_MovAvg.ID2 and FormulaNum = 2)
WHERE	X > @numTotal
UPDATE 	#Fcast_MovAvg
SET	Y	= CEILING(MovAvg * (SELECT    AvgIdx
				            FROM      #Fcast_MovAvg M2
				            WHERE     M2.ID = #Fcast_MovAvg.ID
				                  AND M2.ID2 = #Fcast_MovAvg.ID2
					              AND X <= @numIntervals
					              AND X % @numIntervals = #Fcast_MovAvg.X % @numIntervals)),
	Y2	= CEILING(MovAvg2 * (SELECT    AvgIdx2
				             FROM      #Fcast_MovAvg M2
				             WHERE     M2.ID = #Fcast_MovAvg.ID
				                   AND M2.ID2 = #Fcast_MovAvg.ID2
					               AND X <= @numIntervals
					               AND X % @numIntervals = #Fcast_MovAvg.X % @numIntervals))
WHERE   X > @numTotal
-- ---------------------------------------------------------------------------------
-- Calculate the Cumulative values for Y
--
UPDATE 	#Fcast_MovAvg
SET	CumY	= ( SELECT    SUM(Y)
		        FROM      #Fcast_MovAvg M2
		        WHERE     M2.ID = #Fcast_MovAvg.ID
		              AND M2.ID2 = #Fcast_MovAvg.ID2
			          AND M2.X > @numTotal
			          AND M2.X <= #Fcast_MovAvg.X),
	CumY2	= ( SELECT    SUM(Y2)
		        FROM      #Fcast_MovAvg M2
		        WHERE     M2.ID = #Fcast_MovAvg.ID
		              AND M2.ID2 = #Fcast_MovAvg.ID2
			          AND M2.X > @numTotal
			          AND M2.X <= #Fcast_MovAvg.X)
WHERE	X > @numTotal
IF @debug > 0 SELECT TableName='MovAvg Fcast', * FROM #Fcast_MovAvg
-- ---------------------------------------------------------------------------------
-- Populate The Input Table
--
IF @cumY IS NULL BEGIN
	EXEC( 	'UPDATE ' + @inputTableArg + '
		     SET 	' + @y  + ' = #Fcast_MovAvg.Y, ' +
			            @y2 + ' = #Fcast_MovAvg.Y2 ' + '
		     FROM 	#Fcast_MovAvg
		     WHERE 	    ' + @inputTableArg + '.X > ' + @numTotal + '
		            AND #Fcast_MovAvg.ID  = ' + @inputTableArg + '.' + @id +  '
		            AND #Fcast_MovAvg.ID2 = ' + @inputTableArg + '.' + @id2 + '
		            AND	#Fcast_MovAvg.X   = ' + @inputTableArg + '.X' )
END
ELSE BEGIN
	EXEC( 	'UPDATE ' + @inputTableArg + '
		     SET 	' + @y +     ' = #Fcast_MovAvg.Y, ' +
			            @cumY +  ' = #Fcast_MovAvg.CumY, ' +
			            @y2 +    ' = #Fcast_MovAvg.Y2, ' +
			            @cumY2 + ' = #Fcast_MovAvg.CumY2
		     FROM   #Fcast_MovAvg
		     WHERE 	 ' + @inputTableArg + '.X > ' + @numTotal + '
		           AND 	#Fcast_MovAvg.ID  = ' + @inputTableArg + '.' + @id + '
		           AND 	#Fcast_MovAvg.ID2 = ' + @inputTableArg + '.' + @id2 + '
		           AND	#Fcast_MovAvg.X   = ' + @inputTableArg + '.X' )
END
-- ---------------------------------------------------------------------------------
-- Show Results
--
IF @debug > 0 EXEC( 'SELECT TableName=''InputTable'', * FROM ' + @inputTableArg )
-- ---------------------------------------------------------------------------------
-- Clean Up
--
IF OBJECT_ID('tempdb.dbo.#Fcast_MovAvg')        IS NOT NULL DROP TABLE #Fcast_MovAvg
if OBJECT_ID('tempdb.dbo.#Fcast_MovAvg_linear') IS NOT NULL DROP TABLE #Fcast_MovAvg_linear
--+-+-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-+
--
--  END
--
--+-+-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-+
GO

IF EXISTS (select * from GxQscripts where name = 'wr_ForecastMovAvg')
	delete from GxQscripts where name = 'wr_ForecastMovAvg'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_ForecastMovAvg')
	delete from GXDBVersions where aliasname = 'wr_ForecastMovAvg'
GO

insert into GXDBVersions values(2, 'wr_ForecastMovAvg',  '00010002000000000000', 'wr_ForecastMovAvg', '00010002000000000000')
GO

