

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_ForecastLinear.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/wr_ForecastLinear.sp,v $ $Id: wr_ForecastLinear.sp,v 1.2 2010/09/27 14:08:23 evolohov Exp $";
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Eugene Volohov
-- Create date: 08/11/2010
-- Description:	Caclulates linear forecast
--
-- Parameters :
--              debug                      [input]  [flag]       : output debugging information
--              inputTableArg              [input]  [varchar]    : name of the table that contains data to be forecasted
-- -----------------------------------------------------------------------------------------------------------
-- ----------------------------------------------------------
-- $Log:  $
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_ForecastLinear <<<'

IF EXISTS (select * from sysobjects where name='wr_ForecastLinear')
	drop procedure wr_ForecastLinear
IF EXISTS (select * from GxQscripts where name='wr_ForecastLinear')
	delete from GxQscripts where name = 'wr_ForecastLinear'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_ForecastLinear')
	delete from GXDBVersions where aliasname = 'wr_ForecastLinear'
GO
print '... Creating Procedure: wr_ForecastLinear'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_ForecastLinear
  @debug integer,
  @inputTableArg varchar(64),
  @first integer,
  @last integer,
  @id varchar(64),
  @id2 varchar(64),
  @interpolVar varchar(64),
  @interpolVar2 varchar(64),
  @outputTableArg varchar(64)
AS
DECLARE @NE	int
-- Create temporary table
IF OBJECT_ID('tempdb.dbo.#LI_Sums') IS NOT NULL DROP TABLE #LI_Sums
CREATE TABLE #LI_Sums
(
    ID          INT,
    ID2         INT,
    FormulaNum  INT,
    Ex          FLOAT,
    Ey          FLOAT,
    Exy         FLOAT,
    Ex2         FLOAT,
    m           FLOAT,
    b           FLOAT,
    formula     VARCHAR(128)
)
-- Number of Elements is (end - start)
SET @NE = @last - @first + 1
IF @debug > 0 SELECT NE = @NE
-- (Ex),(Ey),(Exy), (Ex^2) Calculate the sum of X's, Y's, (X*Y)'s, squared X's
EXEC( ' INSERT INTO #LI_Sums
	        SELECT 	' + @id + ', ' + @id2 + ', 1, SUM(X), SUM(' + @interpolVar + '), SUM(X * ' + @interpolVar + '), SUM(POWER(X,2)), 0, 0, ''''
	        FROM 	' + @inputTableArg + '
	        WHERE 	X >= ' + @first + ' AND X <= ' + @last + '
	        GROUP   BY ' + @id + ', ' + @id2 )
EXEC( ' INSERT INTO #LI_Sums
	        SELECT 	' + @id + ', ' + @id2 + ', 2, SUM(X), SUM(' + @interpolVar2 + '), SUM(X * ' + @interpolVar2 + '), SUM(POWER(X,2)), 0, 0, ''''
	        FROM 	' + @inputTableArg +'
	        WHERE 	X >= ' + @first + 'AND X <= ' + @last + '
	        GROUP   BY ' + @id + ', ' + @id2 )
IF @debug > 0 SELECT TableName='After Initial Insert', * FROM #LI_Sums
-- Find Slope (m)
--
--          NE*(Exy) - (Ex)*(Ey)
--      m = --------------------
--           NE*(Ex^2) - (Ex)^2
--
-- Find the Y-intercept (b)
--
--          (Ey)*(Ex^2) - (Ex)*(Exy)
--      b = ------------------------
--             NE*(Ex^2) - (Ex)^2
--
UPDATE	#LI_Sums
SET	    m = (@NE * Exy - Ex * Ey) / CASE (@NE * Ex2 - POWER(Ex, 2)) WHEN 0 THEN 1 ELSE (@NE * Ex2 - POWER(Ex, 2)) END,
	    b = (Ey * Ex2 - Ex * Exy) / CASE (@NE * Ex2 - POWER(Ex, 2)) WHEN 0 THEN 1 ELSE (@NE * Ex2 - POWER(Ex, 2)) END
-- In case we both the slope and the y-intercept are 0, we should predict a constant line
UPDATE	#LI_Sums
SET	    m = 0, b = Ey
WHERE	m = 0 and b = 0
UPDATE	#LI_Sums
SET 	formula = 'y = ' + CAST(m as varchar(20)) + 'x ' + CASE WHEN b < 0 THEN '- ' ELSE '+ ' END + CAST(b as varchar(20))
IF @debug > 0 SELECT * FROM #LI_Sums
EXEC ( 'INSERT INTO ' + @outputTableArg + ' SELECT * FROM #LI_Sums' )
DROP TABLE #LI_Sums
IF @debug > 1 BEGIN
	DROP TABLE #FL_Jobs
	DROP TABLE #FL_Out
END
GO

IF EXISTS (select * from GxQscripts where name = 'wr_ForecastLinear')
	delete from GxQscripts where name = 'wr_ForecastLinear'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_ForecastLinear')
	delete from GXDBVersions where aliasname = 'wr_ForecastLinear'
GO

insert into GXDBVersions values(2, 'wr_ForecastLinear',  '00010002000000000000', 'wr_ForecastLinear', '00010002000000000000')
GO

