

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_FileArchiverClientsubclients.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/wr_FileArchiverClientsubclients.sp,v $ $Id: wr_FileArchiverClientsubclients.sp,v 1.5.60.1 2017/02/10 20:42:01 sjohnson Exp $";
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Dinesh Kriplani
-- Create date: 09/11/2010
-- Description:	generates the filtered required client / subclient list
-- Parameters :
-- -----------------------------------------------------------------------------------------------------------
-- ----------------------------------------------------------
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_FileArchiverClientsubclients <<<'

IF EXISTS (select * from sysobjects where name='wr_FileArchiverClientsubclients')
	drop procedure wr_FileArchiverClientsubclients
IF EXISTS (select * from GxQscripts where name='wr_FileArchiverClientsubclients')
	delete from GxQscripts where name = 'wr_FileArchiverClientsubclients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_FileArchiverClientsubclients')
	delete from GXDBVersions where aliasname = 'wr_FileArchiverClientsubclients'
GO
print '... Creating Procedure: wr_FileArchiverClientsubclients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_FileArchiverClientsubclients
  @userId INT,
  @includeAllEntities INT = 0,
  @includeLogDeletedClients INT = 1,
  @includeLogDeletedSubclients INT = 1,
  @opType INT = 1,
  @reportFilter NVARCHAR(MAX),
  @filterXML NTEXT
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @o_clientId int
  DECLARE @o_appTypeId int
  DECLARE @o_backupsetId int
  DECLARE @o_subclientId int
  DECLARE @o_instanceId int
BEGIN
-- SET NOCOUNT ON added to prevent extra result sets from
SET NOCOUNT ON
DECLARE @debug			INT = 0
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__EntityNameToId')          IS NOT null DROP TABLE #JobSummary_tmp__EntityNameToId
CREATE TABLE #JobSummary_tmp__EntityNameToId (EntityNameToIdXml XML)
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__EntityId')                IS NOT null DROP TABLE #JobSummary_tmp__EntityId
CREATE TABLE #JobSummary_tmp__EntityId
(
    commCellId          INT,
    groupId             INT,
    clientId            INT,
    appTypeId           INT,
    instanceId          INT,
    backupsetId         INT,
    subclientId         INT,
    logDeletedClient    INT,
    logDeletedSubclient INT
)
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__FilterList')              IS NOT null DROP TABLE #JobSummary_tmp__FilterList
CREATE TABLE #JobSummary_tmp__FilterList
(
    filterOrder             INT,
    filterType              INT,
    filterValue             INT,
    filterName              NVARCHAR(255)
)
DECLARE @backupentityselected INTEGER=0
BEGIN TRY
IF @includeAllEntities = 0
BEGIN
	DECLARE	@subclientFilterListXml	XML
	SET @subclientFilterListXml = CAST(@filterXML AS XML)
	INSERT INTO #JobSummary_tmp__EntityNameToId
	EXEC EntityNameToIdConverter @subclientFilterListXml OUTPUT
DECLARE @backupsetname NVARCHAR(max)=null
SELECT
	@backupsetname = ISNULL(@subclientFilterListXml.value('(/reportEntities/subclientFilterList/@backupsetName)[1]', 'NVARCHAR(max)'), '')
	IF (@backupsetname<>'')
	BEGIN
		SET @backupentityselected = 1
	END
	SET @filterXML = CAST(@subclientFilterListXml AS NVARCHAR(MAX))
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
END CATCH
EXEC wr_UserCellSelection @userId, N'#JobSummary_tmp__EntityId', @includeAllEntities, @includeLogDeletedClients, @includeLogDeletedSubclients, N'reportEntities', @filterXML
IF @debug <> 0 SELECT 'entities', * FROM #JobSummary_tmp__EntityId
--SELECT DISTINCT clientId,appTypeId FROM #JobSummary_tmp__EntityId
--SELECT DISTINCT clientId,subclientId FROM #JobSummary_tmp__EntityId
IF @reportFilter IS NOT NULL AND LEN(@reportFilter)> 0 BEGIN
    DECLARE @filterHandle INT
    EXEC sp_xml_preparedocument @filterHandle OUTPUT, @reportFilter
    DECLARE @filterType  INT = NULL
    DECLARE @filterValue INT = NULL
    INSERT INTO #JobSummary_tmp__FilterList
        SELECT filterOrder, filterType, filterValue, filterName
        FROM OPENXML (@filterHandle, 'reportFilter/filters', 1)
        WITH ( filterOrder  INT             '@order',
               filterType   INT             '@entityType',
               filterValue  INT             '@entityId',
               filterName   NVARCHAR(255)   '@entityName' )
    IF @debug <> 0 SELECT 'filter', * FROM #JobSummary_tmp__FilterList
    DECLARE @filterOrder INT = (SELECT MIN(filterOrder) FROM #JobSummary_tmp__FilterList)
    WHILE @filterOrder IS NOT NULL AND @filterOrder <> -1 BEGIN
        SELECT  @filterType = filterType, @filterValue = filterValue
        FROM    #JobSummary_tmp__FilterList
        WHERE   filterOrder = @filterOrder
        IF @filterValue <> - 1 BEGIN
               IF @filterType = 1 BEGIN -- Client
                DELETE  FROM #JobSummary_tmp__EntityId
                WHERE   clientId <> @filterValue
            END
            ELSE IF @filterType = 2 BEGIN -- Agent
                DELETE  FROM #JobSummary_tmp__EntityId
                WHERE   appTypeId <> @filterValue
			END
             ELSE IF @filterType = 4 BEGIN -- ClientGroup
				DELETE  FROM #JobSummary_tmp__EntityId
                WHERE   clientId NOT IN (   SELECT  clientId
                                            FROM    APP_ClientGroupAssoc
                                            WHERE   clientGroupId = @filterValue )
            END
          END
        -- next filter
        SELECT @filterOrder = MIN(filterOrder) FROM #JobSummary_tmp__FilterList WHERE filterOrder > @filterOrder
    END
    EXEC sp_xml_removedocument @filterHandle
END
IF @opType=1
SELECT DISTINCT clientId,appTypeId,backupsetId,subclientId,instanceId FROM #JobSummary_tmp__EntityId AS entity
INNER JOIN APP_BackupSetName bkset ON
bkset.id= entity.backupsetId
AND (((bkset.status&8)=8) OR (@backupentityselected =1))
AND appTypeId in ( 600,603, 13,29,17,19,21,11,33,34,42,44,43)
ELSE
SELECT DISTINCT clientId,appTypeId,backupsetId,-1,instanceId FROM #JobSummary_tmp__EntityId AS entity
INNER JOIN APP_BackupSetName bkset ON
bkset.id= entity.backupsetId
AND (((bkset.status&8)=8) OR (@backupentityselected =1))
AND appTypeId in ( 600,603, 13,29,17,19,21,11,33,34,42,44,43)
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__EntityId')                IS NOT null DROP TABLE #JobSummary_tmp__EntityId
IF OBJECT_ID('tempdb.dbo.#JobSummary_tmp__EntityNameToId')          IS NOT null DROP TABLE #JobSummary_tmp__EntityNameToId
END
GO

IF EXISTS (select * from GxQscripts where name = 'wr_FileArchiverClientsubclients')
	delete from GxQscripts where name = 'wr_FileArchiverClientsubclients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_FileArchiverClientsubclients')
	delete from GXDBVersions where aliasname = 'wr_FileArchiverClientsubclients'
GO

insert into GXDBVersions values(2, 'wr_FileArchiverClientsubclients',  '00010005006000010000', 'wr_FileArchiverClientsubclients', '00010005006000010000')
GO

