

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_DeleteEDiscoveryTask.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--		  This SP is used to delete all records related to a specific eDiscovery task including itself.
--        It will delete records from ProfileTaskInfoHistory, ProfileTaskAssociation, ProfileTaskProp, ProfileTaskInfo
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_DeleteEDiscoveryTask <<<'

IF EXISTS (select * from sysobjects where name='wr_DeleteEDiscoveryTask')
	drop procedure wr_DeleteEDiscoveryTask
IF EXISTS (select * from GxQscripts where name='wr_DeleteEDiscoveryTask')
	delete from GxQscripts where name = 'wr_DeleteEDiscoveryTask'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_DeleteEDiscoveryTask')
	delete from GXDBVersions where aliasname = 'wr_DeleteEDiscoveryTask'
GO
print '... Creating Procedure: wr_DeleteEDiscoveryTask'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_DeleteEDiscoveryTask
-----------------------------------------------------------
---    PARAMETERS
  @inUserId INT,
  @inTaskId INT
-----------------------------------------------------------
AS
  DECLARE @outXml XML
BEGIN
	DECLARE @errorCode										INT = 0
	DECLARE @errorString									NVARCHAR(MAX) = ''
	DECLARE @nowTime										INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @indexingFieldName								NVARCHAR(MAX)= ''
	DECLARE @eDiscoveryTaskId								INT = 0
DECLARE	@EDISCOVERY_TASK_DELETE_PERMISSION				INT = 224
DECLARE	@EDISCOVERY_TASK_ENTITY							INT = 9515
	BEGIN TRY
		-- Read parameters
		IF @inUserId <= 0 OR @inTaskId <= 0
		BEGIN
			SET @errorCode = 1001
			SET @errorString = 'ERROR: Invalid userId ' + CONVERT(VARCHAR(10), @inUserId)  + ' or taskId ' + CONVERT(VARCHAR(10), @inTaskId)
			GOTO ERROR_EXIT
		END
		-- CHECK IF USER HAS AN ABILITY / PERMISSION TO DELETE THIS EDISCOVERY TASK
		DECLARE @userHasCapability INT = 0
EXEC sec_checkPermissionOnEntity @inUserId, 224, @userHasCapability OUTPUT, 9515, @inTaskId
		-- CHECK IF USER IS THE TASK OWNER OR HAS DELETE CAPABILITY. ONLY APPLY DELETE TO EDISCOVERY TASK
		IF NOT EXISTS ( SELECT  taskId
						FROM    ProfileTaskInfo
						WHERE   taskId = @inTaskId
AND	taskType = 9515
								AND ((taskOwnerId = @inUserId) OR (@userHasCapability = 1)))
		BEGIN
			SET @errorCode = 1006
			SET @errorString = 'User does not have permission to delete this task'
			GOTO ERROR_EXIT
		END
		BEGIN TRAN
			-- REMOVE SECURITY ASSOCIATION
EXEC sec_deleteSecurityAssociationsForEntity 9515, @inTaskId
			-- REMOVE TASK HISTORY
			DELETE FROM ProfileTaskInfoHistory
			WHERE taskId = @inTaskId
			SELECT @errorCode = @@ERROR
			IF @errorCode <> 0 GOTO ERROR_EXIT
			-- REMOVE TASK ASSOCIATION
			DELETE FROM ProfileTaskAssociation
			WHERE taskId = @inTaskId
			SELECT @errorCode = @@ERROR
			IF @errorCode <> 0 GOTO ERROR_EXIT
			-- REMOVE TASK PROPERTIES
			DELETE FROM ProfileTaskProp
			WHERE taskId = @inTaskId
			SELECT @errorCode = @@ERROR
			IF @errorCode <> 0 GOTO ERROR_EXIT
			-- REMOVE TASK INFO
			DELETE FROM ProfileTaskInfo
			WHERE taskId = @inTaskId
			SELECT @errorCode = @@ERROR
			IF @errorCode <> 0 GOTO ERROR_EXIT
		COMMIT TRAN
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		-- Call procedure to print error information.
		-- Call procedure to get error information.
		EXECUTE dbo.GetError @errorString OUTPUT , @errorCode OUTPUT
		-- Rollback any active or uncommittable transactions before
		-- inserting information in the ErrorLog
		IF XACT_STATE() <> 0
		BEGIN
			ROLLBACK TRANSACTION;
		END
	END CATCH;
	ERROR_EXIT:
		-- Rollback any active or uncommittable transactions before
		-- inserting information in the ErrorLog
		IF XACT_STATE() <> 0 OR @errorCode <> 0
			BEGIN
				ROLLBACK TRANSACTION;
			END
		ELSE
		BEGIN
			SET @errorString = ''
		END
	SET @outXml = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
							FOR XML PATH('App_GenericResp'), TYPE)
	SELECT @outXml
END
GO

IF EXISTS (select * from GxQscripts where name = 'wr_DeleteEDiscoveryTask')
	delete from GxQscripts where name = 'wr_DeleteEDiscoveryTask'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_DeleteEDiscoveryTask')
	delete from GXDBVersions where aliasname = 'wr_DeleteEDiscoveryTask'
GO

insert into GXDBVersions values(2, 'wr_DeleteEDiscoveryTask',  '00000000000000000000', 'wr_DeleteEDiscoveryTask', '00000000000000000000')
GO

