

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_DataGrowthRpt.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/wr_DataGrowthRpt.sp,v $ $Id: wr_DataGrowthRpt.sp,v 1.2 2010/11/15 21:10:09 evolohov Exp $";
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Eugene Volohov
-- Create date: 09/11/2010
-- Description:	Calculates, aggregates and groups backup sizes data.
-- Parameters :
--              outTempTable               [input] [varchar]: name of the table output data will be copied into
--                                                            see definition of #BDS__tmp_Aggregates to get information
--                                                            about this table structure
--              requestGroupBy             [input] [int]    : determines how aggregated data will be grouped:
--                                                            1:client, 2:agent, 3:storage, 4:group
--              requestType                [input] [int]    : determines type of the time range 0: time range, 1 - relatively
--              requestFrequency           [input] [int]    : frequency - 1:day, 2:week, 3:month, 4:hour, 6:year
--              requestNumOfSteps          [input] [int]    : number of steps
--              requestStartTime           [input] [int]    : if requestType = 0 then start time (unix format), ignored otherwise
--              requestEndTime             [input] [int]    : if requestType = 0 then end time( unix format), ignored otherwise
--              requestTreatWeekend        [input] [flag]   : determines the way weekend is treated. 0 - read data from
--                                                            APP_CommCellReportProp table
--              doNotIncludeCurrentStep    [input] [int]    : determines if current period (current day, week...) should be
--                                                            included into calculations while calculating days if requestType = 1
--              incLogDelClients           [input] [flag]   : determines if data for soft deleted clients should be
--                                                            included in the list of clients
--              predictionSteps            [input] [int]    : number of steps (frequency units) to be predicted
--              patternNumber              [input] [int]    : prediction pattern
--              clientsXML                 [input] [ntext]  : list of the clients to be included in report
-- -----------------------------------------------------------------------------------------------------------
-- ----------------------------------------------------------
-- $Log: wr_DataGrowthRpt.sp,v $
-- Revision 1.1  2010/09/27 18:43:53  evolohov
-- Stored procedure that generates Data Growth report.
-- Initial commit
--
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_DataGrowthRpt <<<'

IF EXISTS (select * from sysobjects where name='wr_DataGrowthRpt')
	drop procedure wr_DataGrowthRpt
IF EXISTS (select * from GxQscripts where name='wr_DataGrowthRpt')
	delete from GxQscripts where name = 'wr_DataGrowthRpt'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_DataGrowthRpt')
	delete from GXDBVersions where aliasname = 'wr_DataGrowthRpt'
GO
print '... Creating Procedure: wr_DataGrowthRpt'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_DataGrowthRpt
  @requestGroupBy INT,
  @requestType INT,
  @requestFrequency INT,
  @requestNumOfSteps INT,
  @requestStartTime INT,
  @requestEndTime INT,
  @requestTreatWeekend INT,
  @requestDoNotIncludeCurrentStep INT,
  @requestIncLogDelClients INT,
  @requestPredictionSteps INT,
  @requestPatternNumber INT,
  @requestDataSizeType INT,
  @requestIncremental INT,
  @requestFull INT,
  @requestPlatWhat NVARCHAR(128),
  @requestShowGridLines INT,
  @requestUserId INT, 
  @requestLocaleId INT, 
  @requiestClientsXML NTEXT
AS
--DECLARE @requestGroupBy                 INT = 1 -- 1:client, 2:agent, 3:storage, 4:group
--DECLARE @requestType                    INT = 1 -- 0: time range, 1 - relatively
--DECLARE @requestFrequency               INT = 2 -- 1:day, 2:week, 3:month, 4:hour, 6:year
--DECLARE @requestNumOfSteps              INT = 6
--DECLARE @requestStartTime               INT = dbo.GetUnixTime(DateAdd(d, -3, GETDATE()))
--DECLARE @requestEndTime                 INT = dbo.GetUnixTime(DateAdd(d, 3, GETDATE()))
--DECLARE @requestTreatWeekend            INT = 0
--DECLARE @requestDoNotIncludeCurrentStep INT = 0
--DECLARE @requestIncLogDelClients        INT = 0
--DECLARE @requestPredictionSteps         INT = 3
--DECLARE @requestPatternNumber           INT = 2
--DECLARE @requestDataSizeType            INT = 3 -- bitfield 0x1 - application, 0x2 - media
--DECLARE @requestIncremental             INT = 1
--DECLARE @requestFull                    INT = 1
--DECLARE @requestPlatWhat                NVARCHAR(128) = N''
--DECLARE @requestShowGridLines           INT = 1
--DECLARE @requiestClientsXML	            NVARCHAR(MAX) = N'<DataGrowthReport_Request>
--									    		            <tree>
--									    			            <entity selectionType="1" commCellId="2" clientGroupId="0" clientId="0" />
--									    		            </tree>
--									    	             </DataGrowthReport_Request>'
DECLARE @debug                      INT = 1
DECLARE @stats                      INT = 1
DECLARE @statsTempTime		        DATETIME
IF OBJECT_ID('tempdb.dbo.#DataGrowth__tmp_Stats') IS NOT NULL DROP TABLE #DataGrowth__tmp_Stats
IF OBJECT_ID('tempdb.dbo.#DataGrowth__tmp_Aggregates')  IS NOT null DROP TABLE #DataGrowth__tmp_Aggregates
IF OBJECT_ID('tempdb.dbo.#DataGrowth__tmp_Periods')     IS NOT null DROP TABLE #DataGrowth__tmp_Periods
IF OBJECT_ID('tempdb.dbo.#DataGrowth__tmp_CommCells')  IS NOT null DROP TABLE #DataGrowth__tmp_CommCells
CREATE TABLE #DataGrowth__tmp_Aggregates
(
    DayNo               INT,
    PeriodStart         INT,
    PeriodEnd           INT,
    CommCellId          INT,
    CommCellName        NVARCHAR(255),
    AppTypeId           INT,
    AppTypeName         NVARCHAR(255),
    DataSizeFullA       BIGINT,
    DataSizeOtherA      BIGINT,
    DataSizeFullM       BIGINT,
    DataSizeOtherM      BIGINT,
    DataSizeTotalA      BIGINT NULL DEFAULT(0),
    DataSizeTotalM      BIGINT NULL DEFAULT(0),
    Predicted           INT
)
CREATE TABLE #DataGrowth__tmp_CommCells
(
    CommCellId          INT,
    CommCellName        NVARCHAR(255)
)
CREATE TABLE #DataGrowth__tmp_Periods
(
    CommCellId          INT,
    DayNo               INT,
    PeriodStart         INT,
    PeriodEnd           INT
)
IF @stats <> 0 BEGIN
	CREATE TABLE #DataGrowth__tmp_Stats (type VARCHAR(50), timeSpentMili INT)
	SET NOCOUNT ON
	SET STATISTICS IO ON
	SET STATISTICS TIME ON
END
IF @stats <> 0 SET @statsTempTime = GetDate()
-- get backups aggregated data
EXEC wr_BackupDataSizes '#DataGrowth__tmp_Aggregates',   -- name of the table output data will be copied into
                        @requestGroupBy,                 -- determines how aggregated data will be grouped
                        @requestType,                    -- type of the time range
                        @requestFrequency,               -- frequency
                        @requestNumOfSteps,              -- number of steps
                        @requestStartTime,
                        @requestEndTime,
                        @requestTreatWeekend,            -- the way weekend is treated
                        @requestDoNotIncludeCurrentStep, -- include current period
                        @requestIncLogDelClients,        -- include soft deleted clients
                        @requestPredictionSteps,         -- number of periods to be predicted
                        @requestPatternNumber,           -- prediction pattern
                        @requiestClientsXML              -- list of clients
IF @stats > 0 INSERT INTO #DataGrowth__tmp_Stats VALUES ('aggregation', datediff(millisecond, @statsTempTime, GetDate()))
IF @debug > 0 SELECT 'aggregation', * FROM  #DataGrowth__tmp_Aggregates ORDER BY PeriodStart ASC, CommCellName ASC, AppTypeName ASC
IF @stats <> 0 SET @statsTempTime = GetDate()
INSERT INTO #DataGrowth__tmp_CommCells
    SELECT  DISTINCT CommCellId, CommCellName
    FROM    #DataGrowth__tmp_Aggregates
IF @stats > 0 INSERT INTO #DataGrowth__tmp_Stats VALUES ('commcells', datediff(millisecond, @statsTempTime, GetDate()))
IF @debug > 0 SELECT 'commcells', * FROM  #DataGrowth__tmp_CommCells
IF @stats <> 0 SET @statsTempTime = GetDate()
INSERT INTO #DataGrowth__tmp_Periods
    SELECT  DISTINCT CommCellId, DayNo, PeriodStart, PeriodEnd
    FROM    #DataGrowth__tmp_Aggregates
    ORDER   BY CommCellId, DayNo, PeriodStart, PeriodEnd
IF @stats > 0 INSERT INTO #DataGrowth__tmp_Stats VALUES ('periods', datediff(millisecond, @statsTempTime, GetDate()))
IF @debug > 0 SELECT 'periods', * FROM  #DataGrowth__tmp_CommCells
/*---------------------------------------------------------------------------------------------------------*/
-- Generate XML
IF @stats <> 0 SET @statsTempTime = GetDate()
SELECT
       (SELECT  @requestGroupBy              AS '@GroupByEntity',
                @requestType                    AS '@RequestType',
                @requestFrequency               AS '@Frequency',
                @requestNumOfSteps              AS '@NumOfSteps',
                @requestStartTime               AS '@StartTime',
                @requestEndTime                 AS '@EndTime',
                @requestTreatWeekend            AS '@TreatWeekend',
                @requestDoNotIncludeCurrentStep AS '@DoNotIncludeCurrentStep',
                @requestIncLogDelClients        AS '@IncLogDelClients',
                @requestPredictionSteps         AS '@PredictionSteps',
                @requestPatternNumber           AS '@PatternNumber',
                @requestDataSizeType            AS '@DataSizeType',
                @requestIncremental             AS '@IncludeIncremental',
                @requestFull                    AS '@IncludeFull',
                @requestPlatWhat                AS '@PlatWhat',
                @requestShowGridLines           AS '@ShowGridLines'
     FOR XML PATH('request'),TYPE),
    (SELECT
            (SELECT CC.CommCellId      AS '@commCellId',
                    C.aliasName         AS '@commCellName',
                    C.csGUID            AS '@commCellGUID',
                    C.[type]            AS '@type',
                    CL.releaseId        AS '@releaseId',
                    C.timeZone          AS '@timeZone',
                    C.flags             AS '@flags'
             FROM   APP_CommCell C INNER JOIN APP_Client CL ON CL.id = C.clientId
             WHERE  C.id = CC.CommCellId
             FOR XML PATH('commcell'), TYPE),
            (SELECT P.DayNo             AS '@weekDay',
                    P.PeriodStart       AS '@startDate',
                    P.PeriodEnd         AS '@endDate',
                    (SELECT AF.AppTypeId        AS '@agentId',
                            AF.AppTypeName      AS '@agentName',
                            'application'       AS '@dataSizeType',
                            AF.DataSizeOtherA   AS '@dataSize'
                     FROM #DataGrowth__tmp_Aggregates AF
                     WHERE     AF.CommCellId  = P.CommCellId
                           AND AF.PeriodStart = P.PeriodStart
                           AND AF.PeriodEnd   = P.PeriodEnd
                           AND @requestDataSizeType & 0x1 = 0x1
                     FOR XML PATH('detail'), TYPE),
                    (SELECT AF.AppTypeId        AS '@agentId',
                            AF.AppTypeName      AS '@agentName',
                            'media'             AS '@dataSizeType',
                            AF.DataSizeOtherM  AS '@dataSize'
                     FROM #DataGrowth__tmp_Aggregates AF
                     WHERE     AF.CommCellId  = P.CommCellId
                           AND AF.PeriodStart = P.PeriodStart
                           AND AF.PeriodEnd   = P.PeriodEnd
                           AND @requestDataSizeType & 0x2 = 0x2
                     FOR XML PATH('detail'), TYPE)
             FROM    #DataGrowth__tmp_Periods P
             WHERE      P.CommCellId = CC.CommCellId
                    AND @requestIncremental = 1
             ORDER BY P.PeriodStart ASC
             FOR XML PATH('incremental'), TYPE),
            (SELECT P.DayNo             AS '@weekDay',
                    P.PeriodStart       AS '@startDate',
                    P.PeriodEnd         AS '@endDate',
                    (SELECT AF.AppTypeId        AS '@agentId',
                            AF.AppTypeName      AS '@agentName',
                            'application'       AS '@dataSizeType',
                            AF.DataSizeFullA    AS '@dataSize'
                     FROM #DataGrowth__tmp_Aggregates AF
                     WHERE     AF.CommCellId  = P.CommCellId
                           AND AF.PeriodStart = P.PeriodStart
                           AND AF.PeriodEnd   = P.PeriodEnd
                           AND @requestDataSizeType & 0x1 = 0x1
                     FOR XML PATH('detail'), TYPE),
                    (SELECT AF.AppTypeId        AS '@agentId',
                            AF.AppTypeName      AS '@agentName',
                            'media'             AS '@dataSizeType',
                            AF.DataSizeFullM    AS '@dataSize'
                     FROM #DataGrowth__tmp_Aggregates AF
                     WHERE     AF.CommCellId  = P.CommCellId
                           AND AF.PeriodStart = P.PeriodStart
                           AND AF.PeriodEnd   = P.PeriodEnd
                           AND @requestDataSizeType & 0x2 = 0x2
                     FOR XML PATH('detail'), TYPE)
             FROM    #DataGrowth__tmp_Periods P
             WHERE      P.CommCellId = CC.CommCellId
                    AND @requestFull = 1
             ORDER BY P.PeriodStart ASC
             FOR XML PATH('full'), TYPE)
     FROM #DataGrowth__tmp_CommCells CC
     FOR XML PATH('response'),TYPE)
FOR XML PATH ('DataGrowthResp')
IF @stats > 0 INSERT INTO #DataGrowth__tmp_Stats VALUES ('xml generation', datediff(millisecond, @statsTempTime, GetDate()))
IF @stats <> 0 AND @debug <> 0 SELECT * FROM #DataGrowth__tmp_Stats
IF OBJECT_ID('tempdb.dbo.#DataGrowth__tmp_Aggregates')  IS NOT NULL DROP TABLE #DataGrowth__tmp_Aggregates
IF OBJECT_ID('tempdb.dbo.#DataGrowth__tmp_CommCells')   IS NOT null DROP TABLE #DataGrowth__tmp_CommCells
IF OBJECT_ID('tempdb.dbo.#DataGrowth__tmp_Periods')     IS NOT null DROP TABLE #DataGrowth__tmp_Periods
IF OBJECT_ID('tempdb.dbo.#DataGrowth__tmp_Stats')       IS NOT NULL DROP TABLE #DataGrowth__tmp_Stats
GO

IF EXISTS (select * from GxQscripts where name = 'wr_DataGrowthRpt')
	delete from GxQscripts where name = 'wr_DataGrowthRpt'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_DataGrowthRpt')
	delete from GXDBVersions where aliasname = 'wr_DataGrowthRpt'
GO

insert into GXDBVersions values(2, 'wr_DataGrowthRpt',  '00010002000000000000', 'wr_DataGrowthRpt', '00010002000000000000')
GO

