

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_DPCoverageRpt.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/wr_DPCoverageRpt.sp,v $ $Id: wr_DPCoverageRpt.sp,v 1.4 2010/11/22 19:29:31 evolohov Exp $";
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Eugene Volohov
-- Create date: 10/12/2010
-- Description:	Generates data protection coverage report
-- Parameters :
--              requestGroupBy                  [input] [int]    : 1 - group by client.  xml structure : commserv/client/ida/[subclient]
--                                                                 2 - group by apptype. xml structure : commserv/ida/client/[subclient]
--                                                                 4 - group by client group. xml structure : commserv/group/client/ida/[subclient]
--                                                                                                       or : commserv/group/ida/client/[subclient]
--                                                                                                       see requestByGroupDirection
--              requestType                     [input] [int]    : determines type of the time range 0: time range, 1 - relatively
--              requestFrequency                [input] [int]    : frequency - 1:day, 2:week, 3:month, 4:hour, 6:year
--              requestNumOfSteps               [input] [int]    : number of steps
--              requestStartTime                [input] [int]    : if requestType = 0 then start time (unix format), ignored otherwise
--              requestEndTime                  [input] [int]    : if requestType = 0 then end time( unix format), ignored otherwise
--              requestTreatWeekend             [input] [int]    : determines the way weekend is treated. 0 - read data from
--                                                                 APP_CommCellReportProp table
--              requestDoNotIncludeCurrentStep  [input] [int]    : determines if current period (current day, week...) should be
--                                                                 included into calculations while calculating days if requestType = 1
--              requestIncLogDelClients         [input] [int]    : determines if data for soft deleted clients should be
--                                                                 included in the list of clients
--              requestIncLogDeletedSubclients  [input] [int]    : determines if data for soft deleted subclients should be
--                                                                 included in the list of clients
--              requestIncludeSubclientInfo     [input] [int]    : determines if subclient information will be included in report
--              requestByGroupDirection         [input] [int]    : in use when requestGroupBy = 4. determines the way data wll be groupped
--                                                                 under group node. 0 : commserv/group/client/ida/[subclient]
--                                                                                or 1 : commserv/group/ida/client/[subclient]
--              userId                          [input] [int]    : id of the user who intiated report generation
--              localeId                        [input] [int]    : report locale id
--              requiestClientsXML              [input] [varchar]: list of the clients to be included in report
-- -----------------------------------------------------------------------------------------------------------
-- ----------------------------------------------------------
-- $Log: wr_DPCoverageRpt.sp,v $
-- Revision 1.3  2010/11/15 21:48:11  evolohov
-- typo fixed
--
-- Revision 1.2  2010/11/15 21:10:09  evolohov
-- added userId and localeId
--
-- Revision 1.1  2010/10/18 22:05:35  evolohov
-- Stored procedurte that generates Coverage report.
-- Initial commit.
--
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_DPCoverageRpt <<<'

IF EXISTS (select * from sysobjects where name='wr_DPCoverageRpt')
	drop procedure wr_DPCoverageRpt
IF EXISTS (select * from GxQscripts where name='wr_DPCoverageRpt')
	delete from GxQscripts where name = 'wr_DPCoverageRpt'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_DPCoverageRpt')
	delete from GXDBVersions where aliasname = 'wr_DPCoverageRpt'
GO
print '... Creating Procedure: wr_DPCoverageRpt'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_DPCoverageRpt
  @requestGroupBy INT,
  @requestType INT,
  @requestFrequency INT,
  @requestNumOfSteps INT,
  @requestStartTime INT,
  @requestEndTime INT,
  @requestTreatWeekend INT,
  @requestDoNotIncludeCurrentStep INT,
  @requestIncLogDelClients INT,
  @requestIncLogDeletedSubclients INT,
  @requestIncludeSubclientInfo INT,
  @requestByGroupDirection INT,
  @requestUserId INT,
  @requestLocaleId INT,
  @requiestClientsXML NTEXT
AS
-- DECLARE @requestGroupBy                 INT = 1 -- 1:client, 2:agent, 4:group
-- DECLARE @requestType                    INT = 1 -- 0: time range, 1 - relatively
-- DECLARE @requestFrequency               INT = 1 -- 1:day, 2:week, 3:month, 4:hour, 6:year
-- DECLARE @requestNumOfSteps              INT = 3
-- DECLARE @requestStartTime               INT = dbo.GetUnixTime(DATEADD(d, -3, GETDATE()))
-- DECLARE @requestEndTime                 INT = dbo.GetUnixTime(GETDATE())
-- DECLARE @requestTreatWeekend            INT = 1
-- DECLARE @requestDoNotIncludeCurrentStep INT = 0
-- DECLARE @requestIncLogDelClients        INT = 1
-- DECLARE @requestIncLogDeletedSubclients INT = 0
-- DECLARE @requestIncludeSubclientInfo    INT = 1
-- DECLARE @requestByGroupDirection        INT = 1
-- DECLARE @requestUserId                  INT = 0
-- DECLARE @requestLocaleId                INT = 0
/*
DECLARE @requiestClientsXML	            NVARCHAR(MAX) = N'<DataGrowthReport_Request>
									    		            <tree>
									    			            <entity selectionType="1" commCellId="3" clientGroupId="0" clientId="0" />
									    		            </tree>
									    	             </DataGrowthReport_Request>'
*/
DECLARE @debug INT = 0
DECLARE @stats INT = 0
DECLARE @statsTempTime DATETIME -- variable used only when @stats > 0
IF OBJECT_ID('tempdb.dbo.#DPCoverage__tmp_ClientsSelection')  IS NOT NULL DROP TABLE #DPCoverage__tmp_ClientsSelection
IF OBJECT_ID('tempdb.dbo.#DPCoverage__tmp_PeriodsRaw')        IS NOT NULL DROP TABLE #DPCoverage__tmp_PeriodsRaw
IF OBJECT_ID('tempdb.dbo.#DPCoverage__tmp_Periods')           IS NOT NULL DROP TABLE #DPCoverage__tmp_Periods
IF OBJECT_ID('tempdb.dbo.#DPCoverage__tmp_FirstLast')         IS NOT NULL DROP TABLE #DPCoverage__tmp_FirstLast
IF OBJECT_ID('tempdb.dbo.#DPCoverage__tmp_Jobs')              IS NOT NULL DROP TABLE #DPCoverage__tmp_Jobs
IF OBJECT_ID('tempdb.dbo.#DPCoverage__tmp_Aggregates')        IS NOT NULL DROP TABLE #DPCoverage__tmp_Aggregates
IF OBJECT_ID('tempdb.dbo.#DPCoverage__tmp_SubclientInfo')     IS NOT NULL DROP TABLE #DPCoverage__tmp_SubclientInfo
IF OBJECT_ID('tempdb.dbo.#DPCoverage__tmp_ClientInfo')        IS NOT NULL DROP TABLE #DPCoverage__tmp_ClientInfo
IF OBJECT_ID('tempdb.dbo.#DPCoverage__tmp_AppTypeInfo')       IS NOT NULL DROP TABLE #DPCoverage__tmp_AppTypeInfo
IF OBJECT_ID('tempdb.dbo.#DPCoverage__tmp_GroupInfo')         IS NOT NULL DROP TABLE #DPCoverage__tmp_GroupInfo
IF OBJECT_ID('tempdb.dbo.#DPCoverage__tmp_CommCellInfo')      IS NOT NULL DROP TABLE #DPCoverage__tmp_CommCellInfo
IF @stats <> 0 BEGIN
	IF OBJECT_ID('tempdb.dbo.#DPCoverage__tmp_Stats') IS NOT NULL DROP TABLE #DPCoverage__tmp_Stats
	CREATE TABLE #DPCoverage__tmp_Stats (type VARCHAR(50), timeSpentMili INT)
	SET NOCOUNT ON
	SET STATISTICS IO OFF
	SET STATISTICS TIME OFF
END
CREATE TABLE #DPCoverage__tmp_ClientsSelection
(
    CommCellId          INT             NULL,
    CommCellName        NVARCHAR(1024)  NULL,
    ClientGroupId       INT             NULL,
    ClientGroupName     NVARCHAR(1024)  NULL,
    ClientID            INT             NULL,
    ClientName          NVARCHAR(1024)  NULL,
    AppTypeID           INT             NULL,
    Uninstalled         INT             null
)
CREATE TABLE #DPCoverage__tmp_PeriodsRaw
(
	CommCellId		    INT,
	DayNum		        INT,
	DayRefStart	        DATETIME,
	DayRefEnd	        DATETIME,
	DayStart	        DATETIME,
	DayEnd		        DATETIME,
	Predicted	        INT,
	DayRefStartLocal	DATETIME,
	DayRefEndLocal		DATETIME,
)
CREATE TABLE #DPCoverage__tmp_Periods
(
	CommCellId		    INT,
	DayNum		        INT,
	DayRefStart	        DATETIME,
	DayRefEnd	        DATETIME,
	DayStart	        DATETIME,
	DayEnd		        DATETIME,
	Predicted	        INT,
	DayRefStartLocal	DATETIME,
	DayRefEndLocal		DATETIME,
    DayRefStartUnix     INT,
    DayRefEndUnix       INT,
    DayStartUnix        INT,
    DayEndUnix          INT
)
CREATE TABLE #DPCoverage__tmp_FirstLast
(
    CommCellId          INT,
    [first]             INT,
    [last]              INT
)
CREATE TABLE #DPCoverage__tmp_Jobs
(
	CommCellID		INT,
	JobID		    INT,
	AppTypeID	    INT,
	ClientID	    INT,
	ClientName	    NVARCHAR(255),
	SubclientId     INT,
	[Status]		INT,
	TimeStart	    INT,
	TimeEnd		    INT,
	DayStart	    INT
)
CREATE TABLE #DPCoverage__tmp_Aggregates
(
    CommCellId      INT,
    GroupId         INT,
    ClientId        INT,
    AgentType       INT,
    SubClientId     INT,
    SubClientName   NVARCHAR(1024),
    Deleted         INT,
    DayNo           INT,
    PeriodStart     INT,
    PeriodEnd       INT,
    Total           INT,
    Failed          INT,
    Completed       INT,
    NoActivity      INT,
    [Status]        INT
)
CREATE TABLE #DPCoverage__tmp_SubclientInfo
(
    CommCellId      INT,
    GroupId         INT,
    ClientId        INT,
    AppTypeId       INT,
    SubClientId     INT,
    SubClientName   NVARCHAR(256),
    LogDeleted      INT
)
CREATE TABLE #DPCoverage__tmp_ClientInfo
(
    CommCellId      INT,
    ClientId        INT,
    ClientName      NVARCHAR(255),
    OSId            INT,
    OSName          NVARCHAR(255),
    ReleaseId       INT,
    LogDeleted      INT,
    clientGuid      NVARCHAR(36),
    specialFlag     INT
)
CREATE TABLE #DPCoverage__tmp_AppTypeInfo
(
    CommCellId      INT,
    ClientId        INT,
    AppTypeId       INT,
    AppTypeName     NVARCHAR(255)
)
CREATE TABLE #DPCoverage__tmp_GroupInfo
(
    CommCellId      INT,
	GroupId         INT,
	GroupName       NVARCHAR(255),
	GroupGuid       NVARCHAR(36),
	groupFlag       INT
)
CREATE TABLE #DPCoverage__tmp_CommCellInfo
(
    CommCellId      INT,
    CommCellName    NVARCHAR(256),
    CommCellGUID    NVARCHAR(36),
    [Type]          INT,
    releaseId       INT,
    timeZone        NVARCHAR(256),
    flags           INT
)
IF @stats <> 0 SET @statsTempTime = GetDate()
-- get list of the clients
EXEC dbo.wr_CellSelection @requiestClientsXML, N'#DPCoverage__tmp_ClientsSelection', 1, N'tree', 0, 0
-- stats
IF @stats <> 0 INSERT INTO #DPCoverage__tmp_Stats VALUES ('clients list', datediff(millisecond, @statsTempTime, GetDate()))
IF @requestIncLogDeletedSubclients = 0 BEGIN
    IF @stats <> 0 SET @statsTempTime = GetDate()
    -- delete uninstalled clients from the list of clients as requested
    DELETE  FROM #DPCoverage__tmp_ClientsSelection WHERE   Uninstalled <> 0
    IF @stats <> 0 INSERT INTO #DPCoverage__tmp_Stats VALUES ('clients list adjustment', datediff(millisecond, @statsTempTime, GetDate()))
END
-- if requeste3d groupping bby Client Group we will show only those clients which are included in a group
-- we are not going to include in response those clients which are not included in any groups
IF @requestGroupBy = 4
    DELETE
    FROM    #DPCoverage__tmp_ClientsSelection
    WHERE      ClientGroupId = 0
            OR ClientGroupId IS NULL
-- debug
IF @debug <> 0 SELECT 'clients', * FROM #DPCoverage__tmp_ClientsSelection
-- create list of time periods for each commcell.
-- each commcell can have its own day-start/day-end definition. So we have to create periods list for
-- each commcell separately
-- we can use cursor here without any problem because table we are going to iterate through is already
-- temporary, in-memory table
IF @stats <> 0 SET @statsTempTime = GetDate()
DECLARE @selectedCC INT
DECLARE existingCCs CURSOR FOR SELECT DISTINCT CommCellId FROM #DPCoverage__tmp_ClientsSelection
OPEN existingCCs
FETCH NEXT FROM existingCCs INTO @selectedCC
WHILE @@FETCH_STATUS = 0 BEGIN
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------activity or coverage---+
    --                                                                                                                                                                                     |
    EXEC dbo.wr_BuildDaysRange  @selectedCC, '#DPCoverage__tmp_PeriodsRaw', @requestType, @requestNumOfSteps, @requestFrequency, @requestStartTime, @requestEndTime, @requestTreatWeekend, 0, 1, 10, 0, @requestDoNotIncludeCurrentStep
    FETCH NEXT FROM existingCCs INTO @selectedCC
END
CLOSE existingCCs
DEALLOCATE existingCCs
-- next lets move data to working table, we also need unix time representation of DayRefStart and DayRefEnd
INSERT INTO #DPCoverage__tmp_Periods
    SELECT  P.CommCellId, P.DayNum, P.DayRefStart, P.DayRefEnd, P.DayStart, P.DayEnd, P.Predicted, P.DayRefStartLocal, P.DayRefEndLocal,
            dbo.GetUnixTime(P.dayRefStart), dbo.GetUnixTime(P.DayRefEnd),
            dbo.GetUnixTime(P.DayStart), dbo.GetUnixTime(P.DayEnd)
    FROM    #DPCoverage__tmp_PeriodsRaw P
    ORDER   BY P.DayStart ASC
-- debug and stats
IF @stats <> 0 INSERT INTO #DPCoverage__tmp_Stats VALUES ('periods', datediff(millisecond, @statsTempTime, GetDate()))
IF @debug <> 0 SELECT 'periods', * FROM #DPCoverage__tmp_Periods
-- next we have to calculate overall periods boundaries for each commcell
IF @stats <> 0 SET @statsTempTime = GetDate()
INSERT INTO #DPCoverage__tmp_FirstLast
    SELECT  P.CommCellId, MIN(P.DayStartUnix), MAX(P.DayEndUnix)
    FROM    #DPCoverage__tmp_Periods P
    WHERE   P.Predicted = 0
    GROUP   BY P.CommCellId
IF @stats <> 0 INSERT INTO #DPCoverage__tmp_Stats VALUES ('first/last days', datediff(millisecond, @statsTempTime, GetDate()))
IF @debug <> 0 SELECT 'first/last daysdays', *, dbo.GetDateTime([first]), dbo.GetDateTime([last]) FROM #DPCoverage__tmp_FirstLast
-- select all jobs which were ran for selected commcells/apptypes in specific periods
IF @stats <> 0 SET @statsTempTime = GetDate()
INSERT INTO #DPCoverage__tmp_Jobs
    SELECT	J.commCellId, J.jobId, J.appType, APP.clientId, C.name, J.appId, J.[status], J.servStartDate, J.servEndDate, 0
	FROM 	JMBkpStats J INNER JOIN #DPCoverage__tmp_FirstLast R ON R.CommCellId = J.commCellId
	                     INNER JOIN APP_Application APP ON APP.id = J.appId AND APP.origCCId = J.commCellId
	                     INNER JOIN APP_Client C ON C.id = APP.clientId AND C.origCCId = APP.origCCId
	WHERE 	    J.servStartDate BETWEEN R.[first] AND R.[last]
            AND EXISTS (SELECT * FROM #DPCoverage__tmp_ClientsSelection CL WHERE CL.AppTypeID = J.appType AND CL.ClientID = APP.clientId AND CL.CommCellId = J.commCellId)
-- set day start value for each job
UPDATE	#DPCoverage__tmp_Jobs
SET	    DayStart = (SELECT    DISTINCT DayStartUnix
                    FROM      #DPCoverage__tmp_Periods P
                    WHERE         J.TimeStart BETWEEN P.DayStartUnix AND P.DayEndUnix
                              AND J.CommCellID = P.CommCellId)
FROM 	#DPCoverage__tmp_Jobs J
IF @stats <> 0 INSERT INTO #DPCoverage__tmp_Stats VALUES ('jobs', datediff(millisecond, @statsTempTime, GetDate()))
IF @debug <> 0 SELECT 'jobs', * FROM #DPCoverage__tmp_Jobs
IF @debug <> 0 SELECT 'total jobs', COUNT(*) FROM #DPCoverage__tmp_Jobs
-- Delete FAILED jobs that might have a COMPLETED job on the same day for the same subclient
IF @stats <> 0 SET @statsTempTime = GetDate()
DELETE	#DPCoverage__tmp_Jobs
WHERE	    [Status] IN (1, 2, 3, 4, 9, 14) --
	    AND EXISTS (SELECT    *
	                FROM      #DPCoverage__tmp_Jobs J2
	                WHERE 	  #DPCoverage__tmp_Jobs.CommCellID = J2.CommCellID
		                  AND #DPCoverage__tmp_Jobs.ClientID = J2.ClientID
		                  AND #DPCoverage__tmp_Jobs.SubclientId = J2.SubclientId
		                  AND #DPCoverage__tmp_Jobs.DayStart = J2.DayStart
		                  AND J2.[Status] IN (1, 3, 4)
		                  AND(   (#DPCoverage__tmp_Jobs.[Status] IN (1, 3, 14) AND #DPCoverage__tmp_Jobs.JobID < J2.JobID and #DPCoverage__tmp_Jobs.CommCellID = J2.CommCellID)
			                   OR #DPCoverage__tmp_Jobs.[Status] IN (2, 4, 9)))
IF @stats <> 0 INSERT INTO #DPCoverage__tmp_Stats VALUES ('jobs cleanup', datediff(millisecond, @statsTempTime, GetDate()))
IF @debug <> 0 SELECT 'jobs after cleanup', * FROM #DPCoverage__tmp_Jobs
IF @debug <> 0 SELECT 'total jobs after cleanup', COUNT(*) FROM #DPCoverage__tmp_Jobs
-- populate #DPCoverage__tmp_Aggregates table with all subclients and all data periods
IF @stats <> 0 SET @statsTempTime = GetDate()
INSERT INTO #DPCoverage__tmp_Aggregates
    SELECT  DISTINCT CS.CommCellId,
            (CASE WHEN @requestGroupBy = 4 THEN CS.ClientGroupId ELSE 0 END),
            -- CS.ClientGroupId,
            CS.ClientID, CS.AppTypeID, APP.id,
            dbo.BuildSubclientNameIndirect(APP.appTypeId, APP.instance, APP.backupSet, APP.id, APP.subclientStatus, @requestLocaleId),
            CS.Uninstalled, P.DayNum, P.DayStartUnix, P.DayEndUnix, 0, 0, 0, 0, 0
    FROM    #DPCoverage__tmp_ClientsSelection CS INNER JOIN APP_Application APP ON APP.origCCId  = CS.CommCellId AND
                                                                                   APP.clientId  = CS.ClientID   AND
                                                                                   APP.appTypeId = CS.AppTypeID
                                                 INNER JOIN #DPCoverage__tmp_Periods P ON P.CommCellId = CS.CommCellId
IF @stats <> 0 INSERT INTO #DPCoverage__tmp_Stats VALUES ('subclient info', datediff(millisecond, @statsTempTime, GetDate()))
IF @debug <> 0 SELECT 'subclients agg', * FROM #DPCoverage__tmp_Aggregates
-- update Total/Failed/Completed values for each entry
IF @stats <> 0 SET @statsTempTime = GetDate()
UPDATE #DPCoverage__tmp_Aggregates SET
    Total       = (SELECT COUNT(*)
                   FROM   #DPCoverage__tmp_Jobs J
                   WHERE     J.SubclientId = #DPCoverage__tmp_Aggregates.SubClientId
                         AND J.TimeStart BETWEEN  #DPCoverage__tmp_Aggregates.PeriodStart AND #DPCoverage__tmp_Aggregates.PeriodEnd),
    Failed      = (SELECT COUNT(*)
                   FROM   #DPCoverage__tmp_Jobs J
                   WHERE     J.SubclientId = #DPCoverage__tmp_Aggregates.SubClientId
                         AND J.TimeStart BETWEEN  #DPCoverage__tmp_Aggregates.PeriodStart AND #DPCoverage__tmp_Aggregates.PeriodEnd
                         AND J.[Status] IN (2, 4, 9)),
    Completed   = (SELECT COUNT(*)
                   FROM   #DPCoverage__tmp_Jobs J
                   WHERE     J.SubclientId = #DPCoverage__tmp_Aggregates.SubClientId
                         AND J.TimeStart BETWEEN  #DPCoverage__tmp_Aggregates.PeriodStart AND #DPCoverage__tmp_Aggregates.PeriodEnd
                         AND J.[Status] IN (1, 3, 14))
IF @stats <> 0 INSERT INTO #DPCoverage__tmp_Stats VALUES ('aggregates:subclient', datediff(millisecond, @statsTempTime, GetDate()))
IF @debug <> 0 SELECT 'aggregates:subclient', * FROM #DPCoverage__tmp_Aggregates
-- populate aggregates tables with aggreagate names and time periods
-- and calculate aggregates status for each period
IF @stats <> 0 SET @statsTempTime = GetDate()
-- lowest level is common for all options
-- -- 3rd level
INSERT INTO #DPCoverage__tmp_Aggregates
SELECT DISTINCT A.CommCellId, A.GroupId, A.ClientId, A.AgentType, NULL, NULL, A.Deleted, A.DayNo, A.PeriodStart, A.PeriodEnd,
       (SELECT SUM(Total) FROM #DPCoverage__tmp_Aggregates S     WHERE     A.PeriodStart = S.PeriodStart
                                                                       AND A.CommCellId  = S.CommCellId
                                                                       AND A.GroupId     = S.GroupId
                                                                       AND A.ClientId    = S.ClientId
                                                                       AND A.AgentType   = S.AgentType),
       (SELECT SUM(Failed) FROM #DPCoverage__tmp_Aggregates S    WHERE     A.PeriodStart = S.PeriodStart
                                                                       AND A.CommCellId  = S.CommCellId
                                                                       AND A.GroupId     = S.GroupId
                                                                       AND A.ClientId    = S.ClientId
                                                                       AND A.AgentType   = S.AgentType),
       (SELECT SUM(Completed) FROM #DPCoverage__tmp_Aggregates S WHERE     A.PeriodStart = S.PeriodStart
                                                                       AND A.CommCellId  = S.CommCellId
                                                                       AND A.GroupId     = S.GroupId
                                                                       AND A.ClientId    = S.ClientId
                                                                       AND A.AgentType   = S.AgentType),
        0, 0
FROM #DPCoverage__tmp_Aggregates A
IF @requestGroupBy = 1  BEGIN
    -- group by client. hierarchy will look like:
    -- + CommCell 1
    -- |    +---- Client 1
    -- |    |         +---- IDA 1
    -- |    |         +---- IDA 2
    -- |    |         +---- IDA 3
    -- |    +---- Client 2
    -- |              +---- IDA 1
    -- |              +---- IDA 2
    -- + CommCell 2
    --      +---- Client 3
    --      |         +---- IDA 1
    --      |         +---- IDA 2
    --      |         +---- IDA 3
    --      +---- Client 4
    --                +---- IDA 1
    --                +---- IDA 2
    ----------------------------------------------
    -- -- second level
    INSERT INTO #DPCoverage__tmp_Aggregates
    SELECT DISTINCT A.CommCellId, A.GroupId, A.ClientId, NULL, NULL, NULL, A.Deleted, A.DayNo, A.PeriodStart, A.PeriodEnd,
           (SELECT SUM(Total) FROM #DPCoverage__tmp_Aggregates S    WHERE      S.PeriodStart = A.PeriodStart
                                                                           AND S.CommCellId  = A.CommCellId
                                                                           AND S.GroupId     = A.GroupId
                                                                           AND S.ClientId    = A.ClientId
                                                                           AND S.SubClientId IS NULL),
           (SELECT SUM(Failed) FROM #DPCoverage__tmp_Aggregates S    WHERE     S.PeriodStart = A.PeriodStart
                                                                           AND S.CommCellId  = A.CommCellId
                                                                           AND S.GroupId     = A.GroupId
                                                                           AND S.ClientId    = A.ClientId
                                                                           AND S.SubClientId IS NULL),
           (SELECT SUM(Completed) FROM #DPCoverage__tmp_Aggregates S WHERE     S.PeriodStart = A.PeriodStart
                                                                           AND S.CommCellId  = A.CommCellId
                                                                           AND S.GroupId     = A.GroupId
                                                                           AND S.ClientId    = A.ClientId
                                                                           AND S.SubClientId IS NULL),
            0, 0
    FROM #DPCoverage__tmp_Aggregates A
    WHERE A.SubClientId IS NULL
    -- commcell level
    INSERT INTO #DPCoverage__tmp_Aggregates
    SELECT DISTINCT A.CommCellId, NULL, NULL, NULL, NULL, NULL, A.Deleted, A.DayNo, A.PeriodStart, A.PeriodEnd,
           (SELECT SUM(Total) FROM #DPCoverage__tmp_Aggregates S    WHERE      S.PeriodStart = A.PeriodStart
                                                                           AND S.CommCellId  = A.CommCellId
                                                                           AND S.AgentType   IS NULL
                                                                           AND S.SubClientId IS NULL),
           (SELECT SUM(Failed) FROM #DPCoverage__tmp_Aggregates S    WHERE     S.PeriodStart = A.PeriodStart
                                                                           AND S.CommCellId  = A.CommCellId
                                                                           AND S.AgentType   IS NULL
                                                                           AND S.SubClientId IS NULL),
           (SELECT SUM(Completed) FROM #DPCoverage__tmp_Aggregates S WHERE     S.PeriodStart = A.PeriodStart
                                                                           AND S.CommCellId  = A.CommCellId
                                                                           AND S.AgentType   IS NULL
                                                                           AND S.SubClientId IS NULL),
            0, 0
    FROM #DPCoverage__tmp_Aggregates A
    WHERE      A.AgentType IS NULL
           AND A.SubClientId IS NULL
END
IF @requestGroupBy = 2 BEGIN
    --
    -- group by agent. hierarchy will look like:
    -- + CommCell 1
    -- |    +---- IDA 1
    -- |    |         +---- Client 1
    -- |    |         +---- Client 2
    -- |    |         +---- Client 3
    -- |    +---- IDA 2
    -- |              +---- Client 1
    -- |              +---- Client 2
    -- + CommCell 2
    --      +---- IDA 1
    --      |         +---- Client 11
    --      |         +---- Client 12
    --      |         +---- Client 13
    --      +---- IDA 2
    --                +---- Client 11
    --                +---- Client 12
    ----------------------------------------------
    -- -- second level
    INSERT INTO #DPCoverage__tmp_Aggregates
    SELECT DISTINCT A.CommCellId, A.GroupId, NULL, A.AgentType, NULL, NULL, A.Deleted, A.DayNo, A.PeriodStart, A.PeriodEnd,
           (SELECT SUM(Total) FROM #DPCoverage__tmp_Aggregates S    WHERE      S.PeriodStart = A.PeriodStart
                                                                           AND S.CommCellId  = A.CommCellId
                                                                           AND S.GroupId     = A.GroupId
                                                                           AND S.AgentType   = A.AgentType
                                                                           AND S.SubClientId IS NULL),
           (SELECT SUM(Failed) FROM #DPCoverage__tmp_Aggregates S    WHERE     S.PeriodStart = A.PeriodStart
                                                                           AND S.CommCellId  = A.CommCellId
                                                                           AND S.GroupId     = A.GroupId
                                                                           AND S.AgentType   = A.AgentType
                                                                           AND S.SubClientId IS NULL),
           (SELECT SUM(Completed) FROM #DPCoverage__tmp_Aggregates S WHERE     S.PeriodStart = A.PeriodStart
                                                                           AND S.CommCellId  = A.CommCellId
                                                                           AND S.GroupId     = A.GroupId
                                                                           AND S.AgentType   = A.AgentType
                                                                           AND S.SubClientId IS NULL),
            0, 0
    FROM #DPCoverage__tmp_Aggregates A
    WHERE A.SubClientId IS NULL
    -- commcell level
    INSERT INTO #DPCoverage__tmp_Aggregates
    SELECT DISTINCT A.CommCellId, NULL, NULL, NULL, NULL, NULL, A.Deleted, A.DayNo, A.PeriodStart, A.PeriodEnd,
           (SELECT SUM(Total) FROM #DPCoverage__tmp_Aggregates S    WHERE      S.PeriodStart = A.PeriodStart
                                                                           AND S.CommCellId  = A.CommCellId
                                                                           AND S.ClientId    IS NULL
                                                                           AND S.SubClientId IS NULL),
           (SELECT SUM(Failed) FROM #DPCoverage__tmp_Aggregates S    WHERE     S.PeriodStart = A.PeriodStart
                                                                           AND S.CommCellId  = A.CommCellId
                                                                           AND S.ClientId    IS NULL
                                                                           AND S.SubClientId IS NULL),
           (SELECT SUM(Completed) FROM #DPCoverage__tmp_Aggregates S WHERE     S.PeriodStart = A.PeriodStart
                                                                           AND S.CommCellId  = A.CommCellId
                                                                           AND S.ClientId    IS NULL
                                                                           AND S.SubClientId IS NULL),
            0, 0
    FROM #DPCoverage__tmp_Aggregates A
    WHERE      A.ClientId IS NULL
           AND A.SubClientId IS NULL
END
IF @requestGroupBy = 4 BEGIN
    IF @requestByGroupDirection = 0 BEGIN
        -- -- third level
        INSERT INTO #DPCoverage__tmp_Aggregates
        SELECT DISTINCT A.CommCellId, A.GroupId, A.ClientId, NULL, NULL, NULL, A.Deleted, A.DayNo, A.PeriodStart, A.PeriodEnd,
               (SELECT SUM(Total) FROM #DPCoverage__tmp_Aggregates S    WHERE      S.PeriodStart = A.PeriodStart
                                                                               AND S.CommCellId  = A.CommCellId
                                                                               AND S.GroupId     = A.GroupId
                                                                               AND S.ClientId    = A.ClientId
                                                                               AND S.SubClientId IS NULL),
               (SELECT SUM(Failed) FROM #DPCoverage__tmp_Aggregates S    WHERE     S.PeriodStart = A.PeriodStart
                                                                               AND S.CommCellId  = A.CommCellId
                                                                               AND S.GroupId     = A.GroupId
                                                                               AND S.ClientId    = A.ClientId
                                                                               AND S.SubClientId IS NULL),
               (SELECT SUM(Completed) FROM #DPCoverage__tmp_Aggregates S WHERE     S.PeriodStart = A.PeriodStart
                                                                               AND S.CommCellId  = A.CommCellId
                                                                               AND S.GroupId     = A.GroupId
                                                                               AND S.ClientId    = A.ClientId
                                                                               AND S.SubClientId IS NULL),
                0, 0
        FROM #DPCoverage__tmp_Aggregates A
        WHERE A.SubClientId IS NULL
        -- second level
        INSERT INTO #DPCoverage__tmp_Aggregates
        SELECT DISTINCT A.CommCellId, A.GroupId, NULL, NULL, NULL, NULL, A.Deleted, A.DayNo, A.PeriodStart, A.PeriodEnd,
               (SELECT SUM(Total) FROM #DPCoverage__tmp_Aggregates S    WHERE      S.PeriodStart = A.PeriodStart
                                                                               AND S.CommCellId  = A.CommCellId
                                                                               AND S.GroupId     = A.GroupId
                                                                               AND S.ClientId    IS NOT NULL
                                                                               AND S.AgentType   IS NULL
                                                                               AND S.SubClientId IS NULL),
               (SELECT SUM(Failed) FROM #DPCoverage__tmp_Aggregates S   WHERE      S.PeriodStart = A.PeriodStart
                                                                               AND S.CommCellId  = A.CommCellId
                                                                               AND S.GroupId     = A.GroupId
                                                                               AND S.ClientId    IS NOT NULL
                                                                               AND S.AgentType   IS NULL
                                                                               AND S.SubClientId IS NULL),
               (SELECT SUM(Completed) FROM #DPCoverage__tmp_Aggregates S WHERE     S.PeriodStart = A.PeriodStart
                                                                               AND S.CommCellId  = A.CommCellId
                                                                               AND S.GroupId     = A.GroupId
                                                                               AND S.ClientId    IS NOT NULL
                                                                               AND S.AgentType   IS NULL
                                                                               AND S.SubClientId IS NULL),
            0, 0
        FROM #DPCoverage__tmp_Aggregates A
        WHERE     A.AgentType IS NULL
              AND A.SubClientId IS NULL
              AND A.ClientId IS NOT NULL
              AND A.CommCellId IS NOT NULL
    END
    ELSE BEGIN
        -- -- third level
        INSERT INTO #DPCoverage__tmp_Aggregates
        SELECT DISTINCT A.CommCellId, A.GroupId, NULL, A.AgentType, NULL, NULL, A.Deleted, A.DayNo, A.PeriodStart, A.PeriodEnd,
               (SELECT SUM(Total) FROM #DPCoverage__tmp_Aggregates S    WHERE      S.PeriodStart = A.PeriodStart
                                                                               AND S.CommCellId  = A.CommCellId
                                                                               AND S.GroupId     = A.GroupId
                                                                               AND S.AgentType   = A.AgentType
                                                                               AND S.SubClientId IS NULL),
               (SELECT SUM(Failed) FROM #DPCoverage__tmp_Aggregates S    WHERE     S.PeriodStart = A.PeriodStart
                                                                               AND S.CommCellId  = A.CommCellId
                                                                               AND S.GroupId     = A.GroupId
                                                                               AND S.AgentType   = A.AgentType
                                                                               AND S.SubClientId IS NULL),
               (SELECT SUM(Completed) FROM #DPCoverage__tmp_Aggregates S WHERE     S.PeriodStart = A.PeriodStart
                                                                               AND S.CommCellId  = A.CommCellId
                                                                               AND S.GroupId     = A.GroupId
                                                                               AND S.AgentType   = A.AgentType
                                                                               AND S.SubClientId IS NULL),
                0, 0
        FROM #DPCoverage__tmp_Aggregates A
        WHERE A.SubClientId IS NULL
        -- second level
        INSERT INTO #DPCoverage__tmp_Aggregates
        SELECT DISTINCT A.CommCellId, A.GroupId, NULL, NULL, NULL, NULL, A.Deleted, A.DayNo, A.PeriodStart, A.PeriodEnd,
               (SELECT SUM(Total) FROM #DPCoverage__tmp_Aggregates S WHERE     S.PeriodStart = A.PeriodStart
                                                                           AND S.CommCellId  = A.CommCellId
                                                                           AND S.GroupId     = A.GroupId
                                                                           AND S.AgentType   IS NOT NULL
                                                                           AND S.ClientId    IS NULL
                                                                           AND S.SubClientId IS NULL),
           (SELECT SUM(Failed) FROM #DPCoverage__tmp_Aggregates S    WHERE     S.PeriodStart = A.PeriodStart
                                                                           AND S.CommCellId  = A.CommCellId
                                                                           AND S.GroupId     = A.GroupId
                                                                           AND S.AgentType   IS NOT NULL
                                                                           AND S.ClientId    IS NULL
                                                                           AND S.SubClientId IS NULL),
           (SELECT SUM(Completed) FROM #DPCoverage__tmp_Aggregates S WHERE     S.PeriodStart = A.PeriodStart
                                                                           AND S.CommCellId  = A.CommCellId
                                                                           AND S.GroupId     = A.GroupId
                                                                           AND S.AgentType   IS NOT NULL
                                                                           AND S.ClientId    IS NULL
                                                                           AND S.SubClientId IS NULL),
            0, 0
        FROM #DPCoverage__tmp_Aggregates A
        WHERE     A.AgentType IS NOT NULL
              AND A.SubClientId IS NULL
              AND A.ClientId IS NULL
              AND A.CommCellId IS NOT NULL
    END
    -- commcell level
    INSERT INTO #DPCoverage__tmp_Aggregates
    SELECT DISTINCT A.CommCellId, NULL, NULL, NULL, NULL, NULL, A.Deleted, A.DayNo, A.PeriodStart, A.PeriodEnd,
           (SELECT SUM(Total) FROM #DPCoverage__tmp_Aggregates S    WHERE      S.PeriodStart = A.PeriodStart
                                                                           AND S.CommCellId  = A.CommCellId
                                                                           AND S.ClientId    IS NULL
                                                                           AND S.AgentType   IS NULL
                                                                           AND S.SubClientId IS NULL),
           (SELECT SUM(Failed) FROM #DPCoverage__tmp_Aggregates S    WHERE     S.PeriodStart = A.PeriodStart
                                                                           AND S.CommCellId  = A.CommCellId
                                                                           AND S.ClientId    IS NULL
                                                                           AND S.AgentType   IS NULL
                                                                           AND S.SubClientId IS NULL),
           (SELECT SUM(Completed) FROM #DPCoverage__tmp_Aggregates S WHERE     S.PeriodStart = A.PeriodStart
                                                                           AND S.CommCellId  = A.CommCellId
                                                                           AND S.ClientId    IS NULL
                                                                           AND S.AgentType   IS NULL
                                                                           AND S.SubClientId IS NULL),
            0, 0
    FROM #DPCoverage__tmp_Aggregates A
    WHERE      A.ClientId IS NULL
           AND A.SubClientId IS NULL
           AND A.AgentType IS NULL
END
-- calculate NoActivity value and status value for each entity
UPDATE 	#DPCoverage__tmp_Aggregates
SET	    NoActivity = Total - Completed - Failed,
		[Status]   = (CASE WHEN Total = 0                           THEN 4
				           WHEN Completed = Total AND Completed > 0 THEN 2
				           WHEN Completed >= 1                      THEN 3
  				           WHEN Failed = 0                          THEN 0
  				           ELSE                                          1
  				      END)
IF @stats <> 0 INSERT INTO #DPCoverage__tmp_Stats VALUES ('aggregates:all', datediff(millisecond, @statsTempTime, GetDate()))
IF @debug <> 0 SELECT 'aggregates:all', * FROM #DPCoverage__tmp_Aggregates
IF @stats <> 0 SET @statsTempTime = GetDate()
-- populate information about entities that will be involved in report generation
-- stats
IF @stats <> 0 INSERT INTO #DPCoverage__tmp_Stats VALUES ('clients list', datediff(millisecond, @statsTempTime, GetDate()))
-- -- client
INSERT INTO #DPCoverage__tmp_ClientInfo
    SELECT CL.origCCId, CL.id, CL.name, CL.simOperatingSystemId, OS.Name, CL.releaseId,
           (CASE CL.[status] & 0x2 WHEN 0x2 THEN 1 ELSE 0 END), CL.[GUID], CL.specialClientFlags
    FROM APP_Client CL INNER JOIN (SELECT DISTINCT ClientID FROM #DPCoverage__tmp_Aggregates) SL ON SL.ClientID = CL.id
                       INNER JOIN simOperatingSystem OS ON OS.id = CL.simOperatingSystemId
IF @requestIncLogDelClients = 0
    DELETE FROM #DPCoverage__tmp_ClientInfo
    WHERE LogDeleted <> 0
-- -- ida
INSERT INTO #DPCoverage__tmp_AppTypeInfo
    SELECT  ST.CommCellId, ST.ClientId, ST.AgentType, AT.[name]
    FROM    APP_iDAType AT INNER JOIN (SELECT DISTINCT CommCellId, ClientId, AgentType FROM #DPCoverage__tmp_Aggregates) ST ON ST.AgentType = AT.[type]
    WHERE   ST.ClientId IS NOT NULL
-- -- group
INSERT INTO #DPCoverage__tmp_GroupInfo
    SELECT AG.origCCId, SG.GroupId, AG.[name], AG.[GUID], AG.flag
    FROM APP_ClientGroup AG INNER JOIN (SELECT DISTINCT GroupId FROM #DPCoverage__tmp_Aggregates WHERE GroupId > 0) SG ON SG.GroupId = AG.id
-- -- commcell
INSERT INTO #DPCoverage__tmp_CommCellInfo
    SELECT CC.id, CC.[aliasName], CC.[csGUID], CC.[type], CL.releaseId, CC.timeZone, CC.flags
    FROM APP_CommCell CC INNER JOIN APP_Client CL ON CL.id = CC.clientId
    WHERE CC.id IN (SELECT DISTINCT CommCellId FROM #DPCoverage__tmp_Aggregates)
-- -- subclient
INSERT INTO #DPCoverage__tmp_SubclientInfo
    SELECT  DISTINCT A.CommCellId, A.GroupId, A.ClientId, A.AgentType, A.SubClientId, A.SubClientName, A.Deleted
    FROM    #DPCoverage__tmp_Aggregates A
    WHERE   A.SubClientId IS NOT NULL
IF @requestIncLogDeletedSubclients = 0
    DELETE FROM #DPCoverage__tmp_SubclientInfo
    WHERE LogDeleted <> 0
IF @stats <> 0 INSERT INTO #DPCoverage__tmp_Stats VALUES ('entityes info', datediff(millisecond, @statsTempTime, GetDate()))
IF @debug <> 0 SELECT 'commcell info', * FROM #DPCoverage__tmp_CommCellInfo
IF @debug <> 0 SELECT 'client info',   * FROM #DPCoverage__tmp_ClientInfo
IF @debug <> 0 SELECT 'apptype info',  * FROM #DPCoverage__tmp_AppTypeInfo
IF @debug <> 0 SELECT 'group info',    * FROM #DPCoverage__tmp_GroupInfo
IF @debug <> 0 SELECT 'subclient info',* FROM #DPCoverage__tmp_SubclientInfo
SELECT
    (SELECT  @requestGroupBy                    AS '@groupBy',
             @requestType                       AS '@timeFrameType',
             @requestFrequency                  AS '@frequency',
             @requestNumOfSteps                 AS '@numOfSteps',
             @requestStartTime                  AS '@startTime',
             @requestEndTime                    AS '@endTime',
             @requestTreatWeekend               AS '@treatWeekend',
             @requestDoNotIncludeCurrentStep    AS '@doNotIncludeCurrentStep',
             @requestIncLogDelClients           AS '@includeLogDelClients',
             @requestIncLogDeletedSubclients    AS '@incLogDeletedSubclients',
             @requestIncludeSubclientInfo       AS '@includeSubclientInfo',
             @requestByGroupDirection           AS '@requestByGroupDirection',
             @requestUserId                     AS '@userId',
             @requestLocaleId                   AS '@localeId'
     FOR XML PATH('request'),TYPE),
    (SELECT
            (SELECT CCI.CommCellId          AS '@commCellId',
                    CCI.CommCellName        AS '@commCellName',
                    CCI.CommCellGUID        AS '@commCellGUID',
                    CCI.[Type]              AS '@type',
                    CCI.releaseId           AS '@releaseId',
                    CCI.timeZone            AS '@timeZone',
                    CCI.flags               AS '@flags'
            FOR XML PATH('ccInfo'),TYPE),
           (SELECT  CCA.DayNo               AS '@dayNo',
                    CCA.PeriodStart         AS '@periodStart',
                    CCA.PeriodEnd           AS '@periodEnd',
                    CCA.[Status]            AS '@status',
                    CCA.Total				AS '@numTotal',
                    CCA.Completed			AS '@numCompleted',
                    CCA.Failed				AS '@numFailed',
                    CCA.NoActivity			AS '@numNoActivity'
            FROM    #DPCoverage__tmp_Aggregates CCA
            WHERE       CCA.CommCellId = CCI.CommCellId
                    AND (CCA.GroupId IS null OR CCA.GroupId = 0)
                    AND CCA.ClientId IS null
                    AND CCA.AgentType IS null
                    AND CCA.SubClientId IS null
            FOR XML PATH('status'),TYPE),
            -- list<CoverageClientInfo> client
           (SELECT
                  -- CCClient clientInfo
                  (SELECT CL.CommCellId     AS '@commCellId',
                          CL.ClientId       AS '@clientId',
                          CL.ClientName     AS '@clientName',
                          CL.OSId           AS '@clientOSId',
                          CL.OSName         AS '@clientOSName',
                          CL.ReleaseId      AS '@releaseId',
                          CL.LogDeleted     AS '@logDeleted',
                          CL.clientGuid     AS '@clientGuid',
                          CL.specialFlag    AS '@specialFlag'
                   FOR XML PATH('clientInfo'),TYPE),
                   -- list<CoverageStatus> status
                  (SELECT  CLA.DayNo               AS '@dayNo',
                           CLA.PeriodStart         AS '@periodStart',
                           CLA.PeriodEnd           AS '@periodEnd',
                           CLA.[Status]            AS '@status',
						   CLA.Total			   AS '@numTotal',
						   CLA.Completed		   AS '@numCompleted',
                           CLA.Failed			   AS '@numFailed',
						   CLA.NoActivity		   AS '@numNoActivity'
                   FROM    #DPCoverage__tmp_Aggregates CLA
                   WHERE       CLA.CommCellId = CL.CommCellId
                           AND (CLA.GroupId    IS null OR CLA.GroupId = 0)
                           AND CLA.ClientId     =  CL.ClientId
                           AND CLA.AgentType   IS null
                           AND CLA.SubClientId IS null
                   FOR XML PATH('status'),TYPE),
                   -- list<CoverageIDAForClientInfo>  appType
                  (SELECT  ATI.AppTypeId          AS '@appTypeId',
                           ATI.AppTypeName        AS '@appTypeName',
                           (SELECT    ATA.DayNo               AS '@dayNo',
                                      ATA.PeriodStart         AS '@periodStart',
                                      ATA.PeriodEnd           AS '@periodEnd',
                                      ATA.[Status]            AS '@status',
									  ATA.Total			      AS '@numTotal',
									  ATA.Completed		      AS '@numCompleted',
									  ATA.Failed			  AS '@numFailed',
									  ATA.NoActivity		  AS '@numNoActivity'
                            FROM      #DPCoverage__tmp_Aggregates ATA
                            WHERE     ATA.CommCellId = CCI.CommCellId
                                  AND (ATA.GroupId  IS null OR ATA.GroupId = 0)
                                  AND ATA.ClientId     =  CL.ClientId
                                  AND ATA.AgentType = ATI.AppTypeId
                                  AND ATA.SubClientId IS null
                            FOR XML PATH('status'),TYPE),
                           (SELECT    SI.SubClientId    AS '@subclientId',
                                      SI.SubClientName  AS '@subclientName',
                                      SI.LogDeleted     AS '@logDeleted',
                                      (SELECT    SA.DayNo               AS '@dayNo',
                                                 SA.PeriodStart         AS '@periodStart',
                                                 SA.PeriodEnd           AS '@periodEnd',
                                                 SA.[Status]            AS '@status',
                                                 SA.Total			    AS '@numTotal',
												 SA.Completed		    AS '@numCompleted',
												 SA.Failed			    AS '@numFailed',
												 SA.NoActivity		    AS '@numNoActivity'
                                       FROM      #DPCoverage__tmp_Aggregates SA
                                       WHERE     SA.SubClientId = SI.SubClientId
                                       FOR XML PATH('status'),TYPE)
                            FROM      #DPCoverage__tmp_SubclientInfo SI
                            WHERE     @requestIncludeSubclientInfo = 1
                                  AND SI.CommCellId = CCI.CommCellId
                                  AND (SI.GroupId  IS null OR SI.GroupId = 0)
                                  AND SI.ClientId = CL.ClientId
                                  AND SI.AppTypeId = ATI.AppTypeId
                            FOR XML PATH('subclient'),TYPE)
                   FROM    #DPCoverage__tmp_AppTypeInfo ATI
                   WHERE   ATI.ClientId = CL.ClientId
                   FOR XML PATH('appType'),TYPE)
            FROM #DPCoverage__tmp_ClientInfo CL
            WHERE @requestGroupBy = 1 AND CL.CommCellId = CCI.CommCellId
            FOR XML PATH('client'),TYPE),
            -- list<CoverageIDAInfo> appType
           (SELECT  ATI.AppTypeId AS '@appTypeId',
                    ATI.AppTypeName AS '@appTypeName',
                    -- status
                  (SELECT  ATA.DayNo               AS '@dayNo',
                           ATA.PeriodStart         AS '@periodStart',
                           ATA.PeriodEnd           AS '@periodEnd',
                           ATA.[Status]            AS '@status',
						   ATA.Total			   AS '@numTotal',
						   ATA.Completed		   AS '@numCompleted',
						   ATA.Failed			   AS '@numFailed',
						   ATA.NoActivity		   AS '@numNoActivity'
                   FROM    #DPCoverage__tmp_Aggregates ATA
                   WHERE       ATA.CommCellId  = ATI.CommCellId
                           AND (ATA.GroupId    IS null OR ATA.GroupId = 0)
                           AND ATA.AgentType   = ATI.AppTypeId
                           AND ATA.ClientId    IS null
                           AND ATA.SubClientId IS null
                   FOR XML PATH('status'),TYPE),
                   -- client
                  (SELECT   CLI.ClientId            AS '@clientId',
                            CLI.ClientName          AS '@clientName',
                           (SELECT      CLAA.DayNo               AS '@dayNo',
                                        CLAA.PeriodStart         AS '@periodStart',
                                        CLAA.PeriodEnd           AS '@periodEnd',
                                        CLAA.[Status]            AS '@status',
 									    CLAA.Total			     AS '@numTotal',
									    CLAA.Completed		     AS '@numCompleted',
									    CLAA.Failed			     AS '@numFailed',
									    CLAA.NoActivity		     AS '@numNoActivity'
                            FROM     #DPCoverage__tmp_Aggregates CLAA
                            WHERE       CLAA.CommCellId  = ATI.CommCellId
                                   AND (CLAA.GroupId    IS null OR CLAA.GroupId = 0)
                                   AND  CLAA.AgentType   = ATI.AppTypeId
                                   AND  CLAA.ClientId    = CLI.ClientId
                                   AND  CLAA.SubClientId IS null
                           FOR XML PATH('status'),TYPE),
                          (SELECT    CLSI.SubClientId    AS '@subclientId',
                                     CLSI.SubClientName  AS '@subclientName',
                                     CLSI.LogDeleted     AS '@logDeleted',
                                     -- status
                                     (SELECT    CLSA.DayNo               AS '@dayNo',
                                                CLSA.PeriodStart         AS '@periodStart',
                                                CLSA.PeriodEnd           AS '@periodEnd',
                                                CLSA.[Status]            AS '@status',
 												CLSA.Total			     AS '@numTotal',
												CLSA.Completed		     AS '@numCompleted',
												CLSA.Failed			     AS '@numFailed',
												CLSA.NoActivity		     AS '@numNoActivity'
                                      FROM      #DPCoverage__tmp_Aggregates CLSA
                                      WHERE     CLSA.CommCellId = CCI.CommCellId
                                            AND (CLSA.GroupId  IS null OR CLSA.GroupId = 0)
                                            AND CLSA.AgentType = ATI.AppTypeId
                                            AND CLSA.ClientId  = CLI.ClientId
                                            AND CLSA.SubClientId = CLSI.SubClientId
                                      FOR XML PATH('status'),TYPE)
                           FROM      #DPCoverage__tmp_SubclientInfo CLSI
                           WHERE     @requestIncludeSubclientInfo = 1
                                 AND CLSI.CommCellId = CCI.CommCellId
                                 AND (CLSI.GroupId  IS null OR CLSI.GroupId = 0)
                                 AND CLSI.AppTypeId = ATI.AppTypeId
                                 AND CLSI.ClientId = CLI.ClientId
                           FOR XML PATH('status'),TYPE)
                   FROM     #DPCoverage__tmp_ClientInfo CLI
                   WHERE    CLI.ClientId IN (SELECT ClientId FROM #DPCoverage__tmp_AppTypeInfo ATC WHERE ATC.AppTypeId = ATI.AppTypeId AND ATC.CommCellId = ATI.CommCellId)
                   FOR XML PATH('client'),TYPE)
            FROM    (SELECT DISTINCT CommCellId, AppTypeId, AppTypeName FROM #DPCoverage__tmp_AppTypeInfo WHERE CommCellId = CCI.CommCellId) ATI
            WHERE   @requestGroupBy = 2
            FOR XML PATH('appType'),TYPE),
            -- list<CoverageGroupInfo> group
           (SELECT
                    (SELECT GI.GroupId          AS '@groupId',
                            GI.GroupName        AS '@groupName',
	                        GI.GroupGuid        AS '@groupGuid',
	                        GI.groupFlag        AS '@groupFlag',
	                       (SELECT  GA.DayNo               AS '@dayNo',
	                                GA.PeriodStart         AS '@periodStart',
	                                GA.PeriodEnd           AS '@periodEnd',
	                                GA.[Status]            AS '@status',
								    GA.Total			   AS '@numTotal',
									GA.Completed		   AS '@numCompleted',
									GA.Failed			   AS '@numFailed',
									GA.NoActivity		   AS '@numNoActivity'
	                        FROM    #DPCoverage__tmp_Aggregates GA
	                        WHERE       GA.CommCellId = GI.CommCellId
	                                AND GA.GroupId = GI.GroupId
	                                AND GA.ClientId IS null
	                                AND GA.AgentType IS null
	                                AND GA.SubClientId IS null
                            FOR XML PATH('status'),TYPE),
                           (SELECT
                                    -- client info : CCClient clientInfo
                                    (SELECT CLIG.CommCellId      AS '@commCellId',
                                            CLIG.ClientId        AS '@clientId',
                                            CLIG.ClientName      AS '@clientName',
                                            CLIG.OSId            AS '@clientOSId',
                                            CLIG.OSName          AS '@clientOSName',
                                            CLIG.ReleaseId       AS '@releaseId',
                                            CLIG.LogDeleted      AS '@logDeleted',
                                            CLIG.clientGuid      AS '@clientGuid',
                                            CLIG.specialFlag     AS '@specialFlag'
                                     FOR XML PATH('clientInfo'),TYPE),
                                     -- client level status : list<CoverageStatus> status
                                    (SELECT  CLAG.DayNo               AS '@dayNo',
	                                         CLAG.PeriodStart         AS '@periodStart',
	                                         CLAG.PeriodEnd           AS '@periodEnd',
	                                         CLAG.[Status]            AS '@status',
									 	     CLAG.Total			      AS '@numTotal',
									         CLAG.Completed		      AS '@numCompleted',
									         CLAG.Failed			  AS '@numFailed',
									         CLAG.NoActivity		  AS '@numNoActivity'
	                                 FROM    #DPCoverage__tmp_Aggregates CLAG
	                                 WHERE       CLAG.CommCellId = CLIG.CommCellId
	                                         AND CLAG.GroupId = GI.GroupId
	                                         AND CLAG.ClientId = CLIG.ClientId
	                                         AND CLAG.AgentType IS null
	                                         AND CLAG.SubClientId IS null
                                     FOR XML PATH('status'),TYPE),
                                     -- ida's for client - list<CoverageIDAForClientInfo> appType
                                    (SELECT ATCG.AppTypeId          AS '@appTypeId',
                                            ATCG.AppTypeName        AS '@appTypeName',
                                            --list<CoverageStatus>        status
                                           (SELECT  ATAG.DayNo               AS '@dayNo',
                                                    ATAG.PeriodStart         AS '@periodStart',
                                                    ATAG.PeriodEnd           AS '@periodEnd',
                                                    ATAG.[Status]            AS '@status',
									 				ATAG.Total			     AS '@numTotal',
													ATAG.Completed		     AS '@numCompleted',
													ATAG.Failed			     AS '@numFailed',
													ATAG.NoActivity		     AS '@numNoActivity'
                                            FROM    #DPCoverage__tmp_Aggregates ATAG
                                            WHERE       ATAG.CommCellId = ATCG.CommCellId
                                                    AND ATAG.ClientId   = ATCG.ClientId
                                                    AND ATAG.AgentType  = ATCG.AppTypeId
                                                    AND ATAG.GroupId    = GI.GroupId
                                                    AND ATAG.SubClientId IS null
                                            FOR XML PATH('status'),TYPE),
                                            --list<CoverageSubclientInfo> subclient
                                           (SELECT  ATASG.SubClientId    AS '@subclientId',
                                                    ATASG.SubClientName  AS '@subclientName',
                                                    ATASG.LogDeleted        AS '@logDeleted',
                                                    -- status
                                                   (SELECT  ATASGA.DayNo               AS '@dayNo',
                                                            ATASGA.PeriodStart         AS '@periodStart',
                                                            ATASGA.PeriodEnd           AS '@periodEnd',
                                                            ATASGA.[Status]            AS '@status',
									 						ATASGA.Total			   AS '@numTotal',
															ATASGA.Completed		   AS '@numCompleted',
															ATASGA.Failed			   AS '@numFailed',
															ATASGA.NoActivity		   AS '@numNoActivity'
                                                    FROM    #DPCoverage__tmp_Aggregates ATASGA
                                                    WHERE   ATASGA.CommCellId = ATCG.CommCellId
                                                            AND ATASGA.ClientId   = ATCG.ClientId
                                                            AND ATASGA.AgentType  = ATCG.AppTypeId
                                                            AND ATASGA.GroupId    = GI.GroupId
                                                            AND ATASGA.SubClientId = ATASG.SubClientId
                                                    FOR XML PATH('status'),TYPE)
                                            FROM    #DPCoverage__tmp_SubclientInfo ATASG
                                            WHERE       @requestIncludeSubclientInfo = 1
                                                    AND ATASG.CommCellId = ATCG.CommCellId
                                                    AND ATASG.ClientId   = ATCG.ClientId
                                                    AND ATASG.AppTypeId  = ATCG.AppTypeId
                                                    AND ATASG.GroupId    = GI.GroupId
                                                    AND ATASG.SubClientId IS NOT null
                                            FOR XML PATH('subclient'),TYPE)
                                     FROM #DPCoverage__tmp_AppTypeInfo ATCG
                                     WHERE ATCG.CommCellId = GI.CommCellId AND ATCG.ClientId = CLIG.ClientId
                                     FOR XML PATH('appType'),TYPE)
                            FROM      #DPCoverage__tmp_ClientInfo CLIG
                            WHERE     @requestByGroupDirection = 0
                                  AND CLIG.ClientId IN (SELECT DISTINCT ClientId FROM #DPCoverage__tmp_Aggregates CLIA WHERE CLIA.CommCellId = GI.CommCellId AND CLIA.GroupId = GI.GroupId)
                            FOR XML PATH('client'),TYPE),
                           (SELECT  APIG.AppTypeId AS '@appTypeId',
                                    APIG.AppTypeName AS '@appTypeName',
                                    -- list<CoverageStatus> status
                                   (SELECT  APAG.DayNo               AS '@dayNo',
                                            APAG.PeriodStart         AS '@periodStart',
	                                        APAG.PeriodEnd           AS '@periodEnd',
	                                        APAG.[Status]            AS '@status',
									 	    APAG.Total			     AS '@numTotal',
									        APAG.Completed		     AS '@numCompleted',
									        APAG.Failed			     AS '@numFailed',
									        APAG.NoActivity		     AS '@numNoActivity'
	                                 FROM   #DPCoverage__tmp_Aggregates APAG
	                                 WHERE       APAG.CommCellId = GI.CommCellId
	                                         AND APAG.GroupId = GI.GroupId
	                                         AND APAG.ClientId IS null
	                                         AND APAG.AgentType = APIG.AppTypeId
	                                         AND APAG.SubClientId IS null
                                     FOR XML PATH('status'),TYPE),
                                     -- list<CoverageClientForIDAInfo> client
                                    (SELECT   CLAI.ClientId     AS '@clientId',
                                              CLAI.ClientName   AS '@clientName',
                                              --list<CoverageStatus>        status
                                             (SELECT    CLAG.DayNo               AS '@dayNo',
                                                        CLAG.PeriodStart         AS '@periodStart',
                                                        CLAG.PeriodEnd           AS '@periodEnd',
                                                        CLAG.[Status]            AS '@status',
									 	                CLAG.Total			     AS '@numTotal',
									                    CLAG.Completed		     AS '@numCompleted',
									                    CLAG.Failed			     AS '@numFailed',
									                    CLAG.NoActivity		     AS '@numNoActivity'
                                              FROM      #DPCoverage__tmp_Aggregates CLAG
                                              WHERE     CLAG.CommCellId = CCI.CommCellId
                                                    AND CLAG.ClientId   = CLAI.ClientId
                                                    AND CLAG.AgentType  = APIG.AppTypeId
                                                    AND CLAG.GroupId    = GI.GroupId
                                                    AND CLAG.SubClientId IS null
                                              FOR XML PATH('status'),TYPE),
                                              -- list<CoverageSubclientInfo> subclient
                                             (SELECT    CTIG.SubClientId    AS '@subclientId',
                                                        CTIG.SubClientName  AS '@subclientName',
                                                        CTIG.LogDeleted     AS '@logDeleted',
                                                       (SELECT    STAG.DayNo               AS '@dayNo',
                                                                  STAG.PeriodStart         AS '@periodStart',
                                                                  STAG.PeriodEnd           AS '@periodEnd',
                                                                  STAG.[Status]            AS '@status',
									 						      STAG.Total			   AS '@numTotal',
																  STAG.Completed		   AS '@numCompleted',
																  STAG.Failed			   AS '@numFailed',
															      STAG.NoActivity		   AS '@numNoActivity'
                                                        FROM      #DPCoverage__tmp_Aggregates STAG
                                                        WHERE     STAG.CommCellId = CTIG.CommCellId
                                                              AND STAG.GroupId = CTIG.GroupId
                                                              AND STAG.AgentType = CTIG.AppTypeId
                                                              AND STAG.ClientId  = CTIG.ClientId
                                                              AND STAG.SubClientId = CTIG.SubClientId
                                                        FOR XML PATH('status'),TYPE)
                                              FROM      #DPCoverage__tmp_SubclientInfo CTIG
                                              WHERE     @requestIncludeSubclientInfo = 1
                                                    AND CTIG.CommCellId = CLAI.CommCellId
                                                    AND CTIG.GroupId = GI.GroupId
                                                    AND CTIG.AppTypeId = APIG.AppTypeId
                                                    AND CTIG.ClientId = CLAI.ClientId
                                                    AND CTIG.SubClientId IS NOT null
                                              FOR XML PATH('subclient'),TYPE)
                                     FROM     #DPCoverage__tmp_ClientInfo CLAI
                                     WHERE    CLAI.ClientId IN (SELECT ClientId FROM #DPCoverage__tmp_AppTypeInfo ATC WHERE ATC.AppTypeId = APIG.AppTypeId AND ATC.CommCellId = GI.CommCellId)
                                     FOR XML PATH('client'),TYPE)
                            FROM    (SELECT DISTINCT AppTypeId, AppTypeName FROM #DPCoverage__tmp_AppTypeInfo WHERE CommCellId = CCI.CommCellId) APIG
                            WHERE       @requestByGroupDirection = 1
                                    AND APIG.AppTypeId IN (SELECT DISTINCT APIA.AgentType FROM #DPCoverage__tmp_Aggregates APIA WHERE APIA.CommCellId = GI.CommCellId AND APIA.GroupId = GI.GroupId)
                            FOR XML PATH('appType'),TYPE)
                     FOR XML PATH('groupInfo'),TYPE)
            FROM    #DPCoverage__tmp_GroupInfo GI
            WHERE   @requestGroupBy = 4
                    AND GI.CommCellId = CCI.CommCellId
            FOR XML PATH('group'),TYPE)
     FROM #DPCoverage__tmp_CommCellInfo CCI
     FOR XML PATH('commcell'),TYPE)
FOR XML PATH ('CoverageResp')
IF @stats <> 0 INSERT INTO #DPCoverage__tmp_Stats VALUES ('XML generation', datediff(millisecond, @statsTempTime, GetDate()))
-- cleanup
IF @stats <> 0 BEGIN
    IF @debug <> 0 SELECT * FROM #DPCoverage__tmp_Stats
    IF OBJECT_ID('tempdb.dbo.#DPCoverage__tmp_Stats') IS NOT NULL DROP TABLE #DPCoverage__tmp_Stats
END
IF OBJECT_ID('tempdb.dbo.#DPCoverage__tmp_ClientsSelection')  IS NOT NULL DROP TABLE #DPCoverage__tmp_ClientsSelection
IF OBJECT_ID('tempdb.dbo.#DPCoverage__tmp_PeriodsRaw')        IS NOT NULL DROP TABLE #DPCoverage__tmp_PeriodsRaw
IF OBJECT_ID('tempdb.dbo.#DPCoverage__tmp_Periods')           IS NOT NULL DROP TABLE #DPCoverage__tmp_Periods
IF OBJECT_ID('tempdb.dbo.#DPCoverage__tmp_FirstLast')         IS NOT NULL DROP TABLE #DPCoverage__tmp_FirstLast
IF OBJECT_ID('tempdb.dbo.#DPCoverage__tmp_Jobs')              IS NOT NULL DROP TABLE #DPCoverage__tmp_Jobs
IF OBJECT_ID('tempdb.dbo.#DPCoverage__tmp_Aggregates')        IS NOT NULL DROP TABLE #DPCoverage__tmp_Aggregates
IF OBJECT_ID('tempdb.dbo.#DPCoverage__tmp_SubclientInfo')     IS NOT NULL DROP TABLE #DPCoverage__tmp_SubclientInfo
IF OBJECT_ID('tempdb.dbo.#DPCoverage__tmp_ClientInfo')        IS NOT NULL DROP TABLE #DPCoverage__tmp_ClientInfo
IF OBJECT_ID('tempdb.dbo.#DPCoverage__tmp_AppTypeInfo')       IS NOT NULL DROP TABLE #DPCoverage__tmp_AppTypeInfo
IF OBJECT_ID('tempdb.dbo.#DPCoverage__tmp_GroupInfo')         IS NOT NULL DROP TABLE #DPCoverage__tmp_GroupInfo
IF OBJECT_ID('tempdb.dbo.#DPCoverage__tmp_CommCellInfo')      IS NOT NULL DROP TABLE #DPCoverage__tmp_CommCellInfo
GO

IF EXISTS (select * from GxQscripts where name = 'wr_DPCoverageRpt')
	delete from GxQscripts where name = 'wr_DPCoverageRpt'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_DPCoverageRpt')
	delete from GXDBVersions where aliasname = 'wr_DPCoverageRpt'
GO

insert into GXDBVersions values(2, 'wr_DPCoverageRpt',  '00010004000000000000', 'wr_DPCoverageRpt', '00010004000000000000')
GO

