

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_CommServTree.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/wr_CommServTree.sp,v $ $Id: wr_CommServTree.sp,v 1.21.2.9 2019/09/26 06:25:53 junlu Exp $";
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Eugene Volohov
-- Create date: 09/09/2010
-- Description:	generates list of commcells registered with commserv
-- Parameters :
--              reqCommCellType            [input]  [int]    : 0 - all commcells, value - commcells with
--                                                             seciifed type only
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='wr_CommServTree')
BEGIN
	print '>>> Drop Stored Procedure: wr_CommServTree <<<'
	drop procedure wr_CommServTree
END
IF EXISTS (select * from GxQscripts where name='wr_CommServTree')
	delete from GxQscripts where name = 'wr_CommServTree'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_CommServTree')
	delete from GXDBVersions where aliasname = 'wr_CommServTree'
GO
print '... Creating Procedure: wr_CommServTree'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_CommServTree
  @reqXml XML,
  @reqUserId INT
AS
  DECLARE @o_CommServTree nvarchar(MAX);
SET NOCOUNT ON
DECLARE @reqType        integer = 1
DECLARE @reqLocaleId	integer = 0
SET		@reqType		= @reqXml.value('/WebReport_CommServTreeReq[1]/@type', 'int')
SET		@reqLocaleId	= @reqXml.value('/WebReport_CommServTreeReq[1]/localeId[1]/@localeId', 'int')
IF OBJECT_ID('tempdb.dbo.#CommCellTree__temp_ClientGroups')  IS NOT NULL DROP TABLE #CommCellTree__temp_ClientGroups
IF OBJECT_ID('tempdb.dbo.#CommCellTree__temp_Clients')       IS NOT NULL DROP TABLE #CommCellTree__temp_Clients
IF OBJECT_ID('tempdb.dbo.#CommCellTree__temp_Subclients')    IS NOT NULL DROP TABLE #CommCellTree__temp_Subclients
IF OBJECT_ID('tempdb.dbo.#CommCellTree__temp_AppTypes')      IS NOT NULL DROP TABLE #CommCellTree__temp_AppTypes
IF OBJECT_ID('tempdb.dbo.#CommCellTree__temp_MediaAgents')   IS NOT NULL DROP TABLE #CommCellTree__temp_MediaAgents
IF OBJECT_ID('tempdb.dbo.#CommCellTree__temp_StoragePolicy') IS NOT NULL DROP TABLE #CommCellTree__temp_StoragePolicy
IF OBJECT_ID('tempdb.dbo.#CommCellTree__temp_UserGroups')    IS NOT NULL DROP TABLE #CommCellTree__temp_UserGroups
IF OBJECT_ID('tempdb.dbo.#CommCellTree__temp_UserObjects')   IS NOT NULL DROP TABLE #CommCellTree__temp_UserObjects
IF OBJECT_ID('tempdb.dbo.#CommCellTree__temp_UserMAs')       IS NOT NULL DROP TABLE #CommCellTree__temp_UserMAs
IF OBJECT_ID('tempdb.dbo.#CommCellTree__temp_UserSPs')       IS NOT NULL DROP TABLE #CommCellTree__temp_UserSPs
create table  #CommCellTree__temp_UserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
create table  #CommCellTree__temp_UserGroups ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
create table  #CommCellTree__temp_UserMAs ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
create table  #CommCellTree__temp_UserSPs ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
CREATE TABLE #CommCellTree__temp_ClientGroups (id INT, name NVARCHAR(1024))
CREATE TABLE #CommCellTree__temp_Clients (id INT, name NVARCHAR(510))
CREATE NONCLUSTERED INDEX #CommCellTree__temp_Clients_idx ON [#CommCellTree__temp_Clients] (id)
CREATE TABLE #CommCellTree__temp_Subclients (clientId INT, appTypeId INT, appId INT)
CREATE NONCLUSTERED INDEX #CommCellTree__temp_Subclients_idx ON [#CommCellTree__temp_Subclients] (clientId)
CREATE TABLE #CommCellTree__temp_AppTypes (id INT, name NVARCHAR(255))
CREATE TABLE #CommCellTree__temp_MediaAgents (id INT, name NVARCHAR(512))
CREATE TABLE #CommCellTree__temp_StoragePolicy (id INT, name NVARCHAR(144))
IF @reqType&16 > 0
	INSERT INTO #CommCellTree__temp_StoragePolicy
	SELECT  id, name
	FROM    archGroup AG WITH (NOLOCK)
	WHERE   id > 1 AND type IN (1,2,5,8) AND flags&64=0
-- get list of items which use allowed to see
IF @reqUserId > 0
BEGIN
EXEC sec_getUserObjects @reqUserId, 2009, 0, '#CommCellTree__temp_UserObjects'
    INSERT INTO #CommCellTree__temp_UserGroups
        SELECT  * FROM #CommCellTree__temp_UserObjects
	DELETE  #CommCellTree__temp_UserObjects
	WHERE   clientGroupId <> 0 OR mediaAgentId <> 0 OR libraryID <> 0  OR archGroupID <> 0 OR vtContainerId <> 0 OR vtPolicyId <> 0 OR
	        vtShelfId <> 0 OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR ermId <> 0  OR legalHoldId <> 0 OR tagId <> 0 OR
	        cdPolicyId <> 0 OR complianceReportId <> 0 OR taskId <> 0 OR commcellID <> 2
    DELETE #CommCellTree__temp_UserGroups
	WHERE   clientId <> 0 OR appTypeId <> 0 OR InstanceId <> 0 OR backupsetId <> 0 OR subClientId <> 0 OR mediaAgentId <> 0 OR
	        libraryID <> 0  OR archGroupID <> 0 OR vtContainerId <> 0 OR vtPolicyId <> 0 OR vtShelfId <> 0 OR reviewSetId <> 0 OR
	        querySetId <> 0 OR downloadSetId <> 0 OR ermId <> 0  OR legalHoldId <> 0  OR tagId <> 0 OR cdPolicyId <> 0 OR
	        complianceReportId <> 0 OR taskId <> 0 OR commcellID <> 2
	CREATE INDEX temp_UserObjects_idx ON #CommCellTree__temp_UserObjects (clientId, appTypeId, instanceId, backupsetId, subClientId)
	-- get list of client groups
	IF @reqType&1 > 0
		INSERT INTO #CommCellTree__temp_ClientGroups
		SELECT  DISTINCT CG.id, dbo.NormalizeForXML(CG.name)
		FROM    APP_ClientGroup CG  WITH (NOLOCK)
				INNER JOIN #CommCellTree__temp_UserGroups UG ON UG.clientGroupId IN (0, CG.id)
	IF @reqType&(2|4|8) > 0
	BEGIN
		INSERT INTO #CommCellTree__temp_Subclients
		SELECT  APP.clientId, APP.appTypeId, APP.id
		FROM    APP_Application APP     WITH (NOLOCK)
			INNER JOIN #CommCellTree__temp_UserObjects UO
				ON  UO.clientId    IN (0, APP.clientId)
                AND UO.appTypeId   IN (0, APP.appTypeId)
                AND UO.instanceId  IN (0, APP.instance)
                AND UO.backupsetId IN (0, APP.backupSet)
                AND UO.subClientId IN (0, APP.id)
		WHERE   APP.subclientStatus & (2|4) = 0
AND APP.appTypeId <> 64
AND APP.subclientStatus&(16|32) = 0 AND APP.appTypeId < 600 AND APP.appTypeId NOT IN (72, 84, 85, 107, 121, 122, 127) AND (APP.appTypeId NOT IN (24, 25, 40, 47, 48, 50, 65, 66, 67, 68, 73, 75, 76) OR APP.subclientStatus&8 = 0)
		UNION ALL
		SELECT  APP.clientId, APP.appTypeId, APP.id
		FROM    #CommCellTree__temp_ClientGroups CG
				INNER JOIN #CommCellTree__temp_UserGroups UG ON UG.clientGroupId IN (0, CG.id)
				INNER JOIN APP_ClientGroupAssoc GA  WITH (NOLOCK) ON GA.clientGroupId = CG.id
				INNER JOIN APP_Application APP  WITH (NOLOCK) ON APP.clientId = GA.clientId
		WHERE   APP.subclientStatus & (2|4) = 0
AND APP.appTypeId <> 64
AND APP.subclientStatus&(16|32) = 0 AND APP.appTypeId < 600 AND APP.appTypeId NOT IN (72, 84, 85, 107, 121, 122, 127) AND (APP.appTypeId NOT IN (24, 25, 40, 47, 48, 50, 65, 66, 67, 68, 73, 75, 76) OR APP.subclientStatus&8 = 0)
		INSERT INTO #CommCellTree__temp_Clients
		SELECT  DISTINCT SC.clientId, dbo.NormalizeForXML(CL.name)
		FROM    #CommCellTree__temp_Subclients SC
				INNER JOIN APP_Client CL  WITH (NOLOCK) ON CL.id = SC.clientId
				LEFT OUTER JOIN APP_ClientProp CP WITH (NOLOCK) ON CL.id = CP.componentNameId AND CP.attrName = 'PlatformDeleted 4' AND CP.attrVal = '1' AND CP.modified = 0
		WHERE	CL.status & (2|4) = 0 AND CL.specialClientFlags&1 = 0 AND CP.componentNameId IS NULL
		-- get VMs with jobs in VSA subclients
IF EXISTS (SELECT * FROM #CommCellTree__temp_Subclients WHERE appTypeId = 106)
			INSERT	INTO #CommCellTree__temp_Clients
			SELECT	V.VMclientId, dbo.NormalizeForXML(CL.name)
			FROM	(
					SELECT	DISTINCT VM.VMclientId
					FROM	#CommCellTree__temp_Subclients E
INNER JOIN JMBkpStats B WITH (NOLOCK) ON B.appId = E.appId AND E.appTypeId = 106
						INNER JOIN APP_VMProp VM WITH (NOLOCK) ON VM.jobId = B.jobId AND VM.commCellId = B.commCellId AND VM.attrName = 'vmStatus'
					) V
					INNER JOIN APP_Client CL WITH (NOLOCK) ON V.VMclientId = CL.id
					LEFT OUTER JOIN #CommCellTree__temp_Clients C ON V.VMclientId = C.id
			WHERE	C.id IS NULL
	END
	-- get list of agent types
	IF @reqType&4 > 0
		INSERT INTO #CommCellTree__temp_AppTypes
		SELECT  type, name
		FROM    APP_iDAType IDA  WITH (NOLOCK)
		WHERE   type IN (SELECT DISTINCT appTypeId FROM #CommCellTree__temp_Subclients WHERE appTypeId < 1000)
	-- get list of media agents
	IF @reqType&8 > 0
	BEGIN
EXEC sec_getUserObjects @reqUserId, 2048, 0, '#CommCellTree__temp_UserMAs'
		DELETE FROM #CommCellTree__temp_UserMAs
		WHERE clientGroupId <> 0 OR clientId <> 0 OR libraryID <> 0 OR archGroupID <> 0
			OR reviewSetId <> 0 OR querySetId <> 0 OR downloadSetId <> 0 OR tagId <> 0 OR legalHoldId <> 0
			OR ermId <> 0 OR cdPolicyId <> 0 OR complianceReportId <> 0	OR taskId <> 0
		IF EXISTS (SELECT MediaAgentId FROM #CommCellTree__temp_UserMAs WHERE MediaAgentId = 0)
			INSERT INTO #CommCellTree__temp_MediaAgents
			SELECT  CL.id, dbo.NormalizeForXML(CL.displayName)
			FROM    APP_Client CL WITH (NOLOCK)
					INNER JOIN MMHost MA WITH (NOLOCK) ON CL.id = MA.ClientId
			WHERE	CL.id > 1 AND CL.specialClientFlags&1 = 0
		ELSE
		INSERT INTO #CommCellTree__temp_MediaAgents
		SELECT  CL.id, dbo.NormalizeForXML(CL.displayName)
		FROM    APP_Client CL  WITH (NOLOCK)
				INNER JOIN (
					SELECT MediaAgentId AS clientId FROM #CommCellTree__temp_UserMAs WHERE MediaAgentId > 0
					UNION
					SELECT DISTINCT A.clientId FROM #CommCellTree__temp_UserObjects A, MMHost B WITH (NOLOCK) WHERE A.clientId = B.clientId and A.clientId > 0
				) MA ON CL.id = MA.clientId
		WHERE	CL.specialClientFlags&1 = 0
	END
	-- get list of Storage Policies
	IF @reqType&16 > 0
	BEGIN
EXEC sec_getUserObjects @reqUserId, 2231, 0, '#CommCellTree__temp_UserSPs'
		IF NOT EXISTS(
			SELECT 1 FROM #CommCellTree__temp_UserSPs SP
WHERE (SP.commCellId=2 AND SP.clientGroupId=0 AND SP.clientId=0 AND SP.appTypeId=0 AND SP.instanceId=0 AND SP.backupsetId=0 AND SP.subClientId=0 AND SP.mediaAgentId=0 AND SP.libraryId=0 AND SP.archGroupId=0 AND SP.vtContainerId=0 AND SP.vtPolicyId=0 AND SP.vtShelfId=0 AND SP.reviewSetId=0 AND SP.querySetId=0 AND SP.downloadSetId=0 AND SP.ermId=0 AND SP.legalHoldId=0 AND SP.tagId=0 AND SP.cdPolicyId=0 AND SP.complianceReportId=0 AND SP.taskId=0 AND SP.workflowId=0 AND SP.logMonitoringPolicyId=0 AND SP.arrayId=0 AND SP.cloudId=0 AND SP.userGroupId=0 AND SP.providerId=0 AND SP.entityId1=0 AND SP.entityId2=0 AND SP.entityId3=0 AND SP.entityId4=0 AND SP.entityId5=0									AND SP.entityId6=0 AND SP.entityId7=0 AND SP.entityId8=0 AND SP.entityId9=0)
		)
		BEGIN
			DELETE	S FROM #CommCellTree__temp_StoragePolicy S LEFT OUTER JOIN #CommCellTree__temp_UserSPs U ON S.id = U.archGroupId
			WHERE	U.archGroupId IS NULL
		END
	END
END
ELSE
BEGIN
	-- get list of client groups
	IF @reqType&1 > 0
		INSERT INTO #CommCellTree__temp_ClientGroups
		SELECT  DISTINCT CG.id, dbo.NormalizeForXML(CG.name)
		FROM    APP_ClientGroup CG  WITH (NOLOCK)
				INNER JOIN APP_ClientGroupAssoc GA  WITH (NOLOCK) ON GA.clientGroupId = CG.id
	-- get list of clients
	IF @reqType&(2|4|8) > 0
		INSERT INTO #CommCellTree__temp_Clients
		SELECT  CL.id, dbo.NormalizeForXML(CL.name)
		FROM    APP_Client CL  WITH (NOLOCK)
				LEFT OUTER JOIN APP_ClientProp CP WITH (NOLOCK) ON CL.id = CP.componentNameId AND CP.attrName = 'PlatformDeleted 4' AND CP.attrVal = '1' AND CP.modified = 0
				LEFT OUTER JOIN (
					SELECT DISTINCT VMclientId FROM APP_VMProp WITH (NOLOCK) WHERE attrName = 'vmStatus'
				) VM ON CL.id = VM.vmClientId
		WHERE	CL.status & (2|4) = 0 AND CP.componentNameId IS NULL OR VM.vmClientId IS NOT NULL
	-- get list of agent types
	IF @reqType&4 > 0
		INSERT INTO #CommCellTree__temp_AppTypes
		SELECT  IDA.type, IDA.name
		FROM    APP_iDAType IDA  WITH (NOLOCK)
				INNER JOIN (
SELECT DISTINCT appTypeId FROM APP_iDAName WITH (NOLOCK) WHERE status&(2|4) = 0 AND appTypeId <> 64
				) T ON IDA.type = T.appTypeId
		WHERE   IDA.[type] < 1000
	-- get list of media agents
	IF @reqType&8 > 0
		INSERT INTO #CommCellTree__temp_MediaAgents
		SELECT  CL.id, dbo.NormalizeForXML(CL.displayName)
		FROM    APP_Client CL  WITH (NOLOCK)
				INNER JOIN MMHost H WITH (NOLOCK) ON CL.id = H.clientId
		WHERE	CL.status & (2|4) = 0
END
SELECT
    (SELECT @reqType            AS '@type',
            @reqUserId	        AS '@userId',
            @reqLocaleId	    AS '@localeId'
     FOR    XML PATH('request'),TYPE),
	(SELECT id   AS '@id',
            name AS '@name'
     FROM   #CommCellTree__temp_ClientGroups
     WHERE  @reqType&1 = 1
	 ORDER BY name
     FOR    XML PATH('ClientGroups'),TYPE),
	(SELECT id   AS '@id',
            name AS '@name'
     FROM   #CommCellTree__temp_Clients
     WHERE  @reqType&2 = 2
	 ORDER BY name
     FOR    XML PATH('Clients'),TYPE),
	(SELECT id   AS '@id',
            name AS '@name'
     FROM   #CommCellTree__temp_AppTypes
     WHERE  @reqType&4 = 4
	 ORDER BY name
     FOR    XML PATH('AgentTypes'),TYPE),
	(SELECT id   AS '@id',
            name AS '@name'
     FROM   #CommCellTree__temp_MediaAgents
     WHERE  @reqType&8 = 8
	 ORDER BY name
     FOR    XML PATH('MediaAgents'),TYPE),
	(SELECT id   AS '@id',
            name AS '@name'
     FROM   #CommCellTree__temp_StoragePolicy
     WHERE  @reqType&16 = 16
	 ORDER BY name
     FOR    XML PATH('StoragePolicies'),TYPE)
FOR XML PATH ('WebReport_CommServTreeResp')
IF OBJECT_ID('tempdb.dbo.#CommCellTree__temp_ClientGroups')  IS NOT NULL DROP TABLE #CommCellTree__temp_ClientGroups
IF OBJECT_ID('tempdb.dbo.#CommCellTree__temp_AppTypes')      IS NOT NULL DROP TABLE #CommCellTree__temp_AppTypes
IF OBJECT_ID('tempdb.dbo.#CommCellTree__temp_Clients')       IS NOT NULL DROP TABLE #CommCellTree__temp_Clients
IF OBJECT_ID('tempdb.dbo.#CommCellTree__temp_Subclients')    IS NOT NULL DROP TABLE #CommCellTree__temp_Subclients
IF OBJECT_ID('tempdb.dbo.#CommCellTree__temp_MediaAgents')   IS NOT NULL DROP TABLE #CommCellTree__temp_MediaAgents
IF OBJECT_ID('tempdb.dbo.#CommCellTree__temp_StoragePolicy') IS NOT NULL DROP TABLE #CommCellTree__temp_StoragePolicy
IF OBJECT_ID('tempdb.dbo.#CommCellTree__temp_UserGroups')    IS NOT NULL DROP TABLE #CommCellTree__temp_UserGroups
IF OBJECT_ID('tempdb.dbo.#CommCellTree__temp_UserObjects')   IS NOT NULL DROP TABLE #CommCellTree__temp_UserObjects
IF OBJECT_ID('tempdb.dbo.#CommCellTree__temp_UserMAs')       IS NOT NULL DROP TABLE #CommCellTree__temp_UserMAs
IF OBJECT_ID('tempdb.dbo.#CommCellTree__temp_UserSPs')       IS NOT NULL DROP TABLE #CommCellTree__temp_UserSPs
GO

IF EXISTS (select * from GxQscripts where name = 'wr_CommServTree')
	delete from GxQscripts where name = 'wr_CommServTree'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_CommServTree')
	delete from GXDBVersions where aliasname = 'wr_CommServTree'
GO

insert into GXDBVersions values(2, 'wr_CommServTree',  '00010021000200090000', 'wr_CommServTree', '00010021000200090000')
GO

