

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_CommCellTree.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/wr_CommCellTree.sp,v $ $Id: wr_CommCellTree.sp,v 1.2 2010/11/15 21:10:09 evolohov Exp $";
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Eugene Volohov
-- Create date: 09/09/2010
-- Description:	generates  commcell tree for commcell with specified id
-- Parameters :
--              reqCommCellId            [input]  [int]     : id of the comcell
--              reqCommCellName          [input]  [nvarchar]: name of the comcell
-- -----------------------------------------------------------------------------------------------------------
-- ----------------------------------------------------------
-- $Log: wr_CommCellTree.sp,v $
-- Revision 1.1  2010/09/09 19:45:20  evolohov
-- Generates  commcell tree for commcell with specified id,
-- Initial commit
--
--
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_CommCellTree <<<'

IF EXISTS (select * from sysobjects where name='wr_CommCellTree')
	drop procedure wr_CommCellTree
IF EXISTS (select * from GxQscripts where name='wr_CommCellTree')
	delete from GxQscripts where name = 'wr_CommCellTree'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_CommCellTree')
	delete from GXDBVersions where aliasname = 'wr_CommCellTree'
GO
print '... Creating Procedure: wr_CommCellTree'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_CommCellTree
  @reqCommCellId INT,
  @reqCommCellName NVARCHAR(512),
  @reqUserId integer = 0, 
  @reqLocaleId integer = 0
AS
SET NOCOUNT ON
--DECLARE @reqCommCellId      INT
--DECLARE @reqCommCellName    NVARCHAR(512)
DECLARE @debug          INT = 0
DECLARE @stats          INT = 0
DECLARE @statsTempTime  DATETIME
IF OBJECT_ID('tempdb.dbo.#CommCellTree__temp_Clients') IS NOT NULL DROP TABLE #CommCellTree__temp_Clients
IF OBJECT_ID('tempdb.dbo.#CommCellTree_Stats') IS NOT NULL DROP TABLE #CommCellTree_Stats
IF @stats <> 0 BEGIN
	CREATE TABLE #CommCellTree_Stats(type VARCHAR(50), timeSpentMili INT)
END
CREATE TABLE #CommCellTree__temp_Clients
(
    commCellId      INT,
    clientId        INT,
    clientName      NVARCHAR(510),
    clientOSId      INT,
    clientOSName    VARCHAR(64),
    releaseId       INT,
    logDeleted      INT,
    clientGuid      UNIQUEIDENTIFIER,
    specialFlag     INT,
    groupId         INT
)
IF @stats <> 0 SET @statsTempTime = GetDate()
INSERT  INTO #CommCellTree__temp_Clients
SELECT  DISTINCT
        APP.origCCId, APP.clientId, CL.name, CL.simOperatingSystemId, OS.Name, CL.releaseId,
        CASE WHEN CL.[status] & 0x2 = 0x2 THEN 1 ELSE 0 END,
        CL.[GUID], CL.specialClientFlags, 0
FROM    APP_Application APP INNER JOIN APP_Client CL ON CL.id = APP.clientId AND CL.origCCId = APP.origCCId
                            INNER JOIN simOperatingSystem OS ON OS.id = CL.simOperatingSystemId
WHERE       APP.origCCId = @reqCommCellId
       AND (dbo.IsSubClientValid( APP.appTypeId, APP.subclientStatus, 0) = 1)
UNION
SELECT  DISTINCT
        APP.origCCId, APP.clientId, CL.name, CL.simOperatingSystemId, OS.Name, CL.releaseId,
        CASE WHEN CL.[status] & 0x2 = 0x2 THEN 1 ELSE 0 END,
        CL.[GUID], CL.specialClientFlags, CG.id
FROM    APP_ClientGroup CG INNER JOIN APP_ClientGroupAssoc CGA ON CGA.clientGroupId = CG.id
                           INNER JOIN APP_Application APP ON APP.clientId =  CGA.clientId
                           INNER JOIN APP_Client CL ON CL.id = APP.clientId
                           INNER JOIN simOperatingSystem OS ON OS.id = CL.simOperatingSystemId
WHERE      CG.origCCId = @reqCommCellId
       AND (dbo.IsSubClientValid( APP.appTypeId, APP.subclientStatus, 0) = 1)
IF  @stats <> 0 INSERT INTO #CommCell_Stats VALUES ('clients list', datediff(millisecond, @statsTempTime, GetDate()))
IF  @debug <> 0 SELECT 'client', * FROM #CommCellTree__temp_Clients
IF @stats <> 0 SET @statsTempTime = GetDate()
SELECT
    (SELECT CC.id               AS  '@commCellId',
            CC.aliasName        AS  '@commCellName',
            CC.csGUID           AS  '@commCellGUID',
            CC.[type]           AS  '@type',
            CL.releaseId        AS  '@releaseId',
            CC.timeZone         AS  '@timeZone',
            CC.flags            AS  '@flags'
    FROM    APP_CommCell CC INNER JOIN APP_Client CL ON CL.id = CC.clientId
    WHERE   CC.id = @reqCommCellId
    FOR     XML PATH('commcell'),TYPE ),
    (SELECT commCellId          AS  '@commCellId',
            clientId            AS  '@clientId',
            clientName          AS  '@clientName',
            clientOSId          AS  '@clientOSId',
            clientOSName        AS  '@clientOSName',
            releaseId           AS  '@releaseId',
            logDeleted          AS  '@logDeleted',
            clientGuid          AS  '@clientGuid',
            specialFlag         AS  '@specialFlag'
    FROM    #CommCellTree__temp_Clients
    WHERE   groupId = 0
    FOR XML PATH('client'),TYPE ),
    (SELECT origCCId            AS  '@commCellId',
            id                  AS  '@groupId',
            [name]              AS  '@groupName',
            [GUID]              AS  '@groupGuid',
            flag                AS  '@groupFlag',
            ( SELECT commCellId          AS  '@commCellId',
                     clientId            AS  '@clientId',
                     clientName          AS  '@clientName',
                     clientOSId          AS  '@clientOSId',
                     clientOSName        AS  '@clientOSName',
                     releaseId           AS  '@releaseId',
                     logDeleted          AS  '@logDeleted',
                     clientGuid          AS  '@clientGuid',
                     specialFlag         AS  '@specialFlag'
              FROM    #CommCellTree__temp_Clients
              WHERE   groupId = id
              FOR XML PATH('client'),TYPE )
     FROM    APP_ClientGroup
     WHERE   origCCId = @reqCommCellId
     FOR XML PATH('group'),TYPE )
FOR     XML PATH ('CommCellTreeResp')
IF @stats <> 0 INSERT INTO #CommCellTree_Stats VALUES ('xml generation', datediff(millisecond, @statsTempTime, GetDate()))
IF @stats <> 0 AND @debug <> 0 SELECT * FROM #CommCellTree_Stats
IF OBJECT_ID('tempdb.dbo.#CommCellTree__temp_Clients') IS NOT NULL DROP TABLE #CommCellTree__temp_Clients
IF OBJECT_ID('tempdb.dbo.#CommCellTree_Stats') IS NOT NULL DROP TABLE #CommCellTree_Stats
GO

IF EXISTS (select * from GxQscripts where name = 'wr_CommCellTree')
	delete from GxQscripts where name = 'wr_CommCellTree'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_CommCellTree')
	delete from GXDBVersions where aliasname = 'wr_CommCellTree'
GO

insert into GXDBVersions values(2, 'wr_CommCellTree',  '00010002000000000000', 'wr_CommCellTree', '00010002000000000000')
GO

