

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_CommCellGrowth.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/wr_CommCellGrowth.sp,v $ $Id: wr_CommCellGrowth.sp,v 1.22 2014/01/26 04:51:00 chandru Exp $";
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Eugene Volohov
-- Create date: 08/11/2010
-- Description:	generates commcell growth report
-- -----------------------------------------------------------------------------------------------------------
-- ----------------------------------------------------------
-- $Log: wr_CommCellGrowth.sp,v $
-- Revision 1.21  2013/07/24 15:42:36  rkumarasamy
-- CommCell Growth web report failing with data type conversion error
-- Update form: 4288
-- Original branch changes by: rkumarasamy (Ravi Kumarasamy)
--
-- Revision 1.20  2013/01/23 03:42:11  junlu
-- Update Form:1531
-- Update Form: 1531
-- Date As Of shown in CommCell Growth web report should be the CommServer time
-- Original branch changes by: junlu (Jun Lu)
--
-- Revision 1.19  2012/12/18 20:28:08  junlu
-- Update Form:819
-- Update Form: 819
-- Dummy change
-- Original branch changes by: junlu (Jun Lu)
--
-- Revision 1.18  2012/12/15 00:00:12  rpolimera
-- Update Form:1106
-- commcell growth fixes on behalf of jun lu
-- Original branch changes by: rpolimera (Rajesh Polimera)
--
-- Revision 1.17  2012/11/20 17:48:03  junlu
-- Update Form:653
-- Update Form: 653
-- CommCell Growth Web Report shows the latest capacity usage
-- Original branch changes by: junlu (Jun Lu)
--
-- Revision 1.16  2012/11/13 20:08:54  junlu
-- Update Form:261
-- Update Form: 261
-- Changes for feedback about CommCell Growth web report
-- Original branch changes by: junlu (Jun Lu)
--
-- Revision 1.15  2012/10/01 16:21:56  junlu
-- Update Form:112539
-- Update Form: 112539
-- MR 85550: Integration changes
-- Original branch changes by: junlu (Jun Lu)
--
-- Revision 1.14  2012/09/27 04:40:25  junlu
-- Update Form:112378
-- Update Form: 112378
-- MR 85550: Integration fixes for web reports
-- Original branch changes by: junlu (Jun Lu)
--
-- Revision 1.13  2012/09/18 02:56:14  junlu
-- Update Form:110255
-- Update Form: 110255
-- MR 85550: Integration changes for web reports.
-- Original branch changes by: junlu (Jun Lu)
--
-- Revision 1.12  2012/09/12 18:56:15  junlu
-- Update Form:110119
-- Update Form: 110119
-- MR 35550: integration fixes for web reports.
-- Original branch changes by: junlu (Jun Lu)
--
-- Revision 1.11  2012/05/23 22:13:41  junlu
-- Update Form: 92808
-- Integration fixes
-- Original branch changes by: junlu (Jun Lu)
--
-- Revision 1.10  2012/04/10 17:47:05  junlu
-- Add Data Growth to CommCell Growth Web Report.
--
-- Revision 1.9  2012/03/13 17:51:52  junlu
-- Update Form:84116
-- Update Form: 84116
-- Itegration Fix
-- Original branch changes by: junlu (Jun Lu)
--
-- Revision 1.8  2012/03/02 23:33:49  junlu
-- Update Form:82145
-- Update Form: 82145
-- Integration chages for web reports using Json.
-- Original branch changes by: junlu (Jun Lu)
--
-- Revision 1.7  2012/02/15 22:21:27  junlu
-- Use 64 bit integer for GrowthValues and entityValue in Message GrowthSummaryValue.
--
-- Revision 1.6  2012/02/14 16:03:30  junlu
-- Use float for GrowthRate.
--
-- Revision 1.5  2011/10/21 14:44:34  evolohov
-- Debug statement removed
--
-- Revision 1.4  2011/10/17 16:41:11  evolohov
-- CommCell growth report implementation
--
-- Revision 1.3  2011/09/26 18:30:57  evolohov
-- Stored procedure renamed
--
-- Revision 1.2  2011/09/26 17:40:30  evolohov
-- Stored procedure renamed
-- Original branch changes by: evolohov (Eugene Volohov)
--
-- Revision 1.7  2010/11/15 21:10:09  evolohov
-- added userId and localeId
--
-- Revision 1.6  2010/10/19 13:37:21  evolohov
-- Configuration Info items gathering error fix
--
-- Revision 1.5  2010/10/18 22:06:26  evolohov
-- Configuration Info items added
--
-- Revision 1.4  2010/09/09 15:49:16  evolohov
-- INT value that represents unix datetime treated as DATETIME. Fixed
--
-- Revision 1.3  2010/09/03 14:15:50  evolohov
-- rcid has been added.
--
-- Revision 1.2  2010/09/02 18:50:23  evolohov
-- Comment typo fixed
--
-- Revision 1.1  2010/08/11 20:34:44  evolohov
-- Implementation of base functionality. Initial commit.
--
-- -----------------------------------------------------------------------------------------------------------
-- Dummy change for form 819
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_CommCellGrowth <<<'

IF EXISTS (select * from sysobjects where name='wr_CommCellGrowth')
	drop procedure wr_CommCellGrowth
IF EXISTS (select * from GxQscripts where name='wr_CommCellGrowth')
	delete from GxQscripts where name = 'wr_CommCellGrowth'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_CommCellGrowth')
	delete from GXDBVersions where aliasname = 'wr_CommCellGrowth'
GO
print '... Creating Procedure: wr_CommCellGrowth'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_CommCellGrowth
  @reqXml XML,
  @userId INT
AS
  DECLARE @o_ReportData NVARCHAR(MAX);
DECLARE @timeFrameType              INT
DECLARE @frequency                  INT
DECLARE @numberOfPeriods            INT
DECLARE @reqStartTime               INT
DECLARE @reqEndTime                 INT
DECLARE @includeCurrentPeriod       INT
DECLARE @treatWeekend               INT
DECLARE @predictionSteps            INT
DECLARE @reportDataType             INT
DECLARE @detailsOnlyRequest         INT
DECLARE @pageSize                   INT
DECLARE @pageNo                     INT
DECLARE @detailsSortColumnNo        INT
DECLARE @sortOrder                  INT
DECLARE @localeId                   INT
DECLARE @reportEntities             NVARCHAR(MAX)
SET @timeFrameType          = ISNULL(@reqXml.value('/WebReport_CommCellGrowthRequest[1]/@timeFrameType', 'int'), 0)
SET @frequency              = ISNULL(@reqXml.value('/WebReport_CommCellGrowthRequest[1]/@frequency', 'int'), 0)
SET @numberOfPeriods        = ISNULL(@reqXml.value('/WebReport_CommCellGrowthRequest[1]/@numberOfPeriods', 'int'), 0)
SET @reqStartTime           = ISNULL(@reqXml.value('/WebReport_CommCellGrowthRequest[1]/@startTime', 'int'), 0)
SET @reqEndTime             = ISNULL(@reqXml.value('/WebReport_CommCellGrowthRequest[1]/@endTime', 'int'), 0)
SET @includeCurrentPeriod   = ISNULL(@reqXml.value('/WebReport_CommCellGrowthRequest[1]/@includeCurrentPeriod', 'int'), 0)
SET @treatWeekend           = ISNULL(@reqXml.value('/WebReport_CommCellGrowthRequest[1]/@treatWeekend', 'int'), 0)
SET @predictionSteps        = ISNULL(@reqXml.value('/WebReport_CommCellGrowthRequest[1]/@numberOfPredictionSteps', 'int'), 0)
SET @reportDataType         = ISNULL(@reqXml.value('/WebReport_CommCellGrowthRequest[1]/@reportDataType', 'int'), 0)
SET @detailsOnlyRequest     = ISNULL(@reqXml.value('/WebReport_CommCellGrowthRequest[1]/@detailsOnlyRequest', 'int'), 0)
SET @pageSize               = ISNULL(@reqXml.value('/WebReport_CommCellGrowthRequest[1]/@pageSize', 'int'), 0)
SET @pageNo                 = ISNULL(@reqXml.value('/WebReport_CommCellGrowthRequest[1]/@pageNo', 'int'), 0)
SET @detailsSortColumnNo    = ISNULL(@reqXml.value('/WebReport_CommCellGrowthRequest[1]/@detailsSortColumnNo', 'int'), 0)
SET @sortOrder              = ISNULL(@reqXml.value('/WebReport_CommCellGrowthRequest[1]/@jobsSortOrder', 'int'), 0)
SET @localeId               = ISNULL(@reqXml.value('/WebReport_CommCellGrowthRequest[1]/localeId[1]/@localeId', 'int'), 0)
SET @reportEntities			= CAST(@reqXml.query('/WebReport_CommCellGrowthRequest[1]/reportEntities') as NVARCHAR(MAX))
DECLARE @userPreferences xml = (SELECT value FROM UMUserWebPrefs WITH (NOLOCK) WHERE userId = @userId)
DECLARE @dateFormat		INT = 0
DECLARE @bias			INT = 0
SET @bias = dbo.getUnixTime(GetDate()) - dbo.getUnixTime(GetUTCDate())
IF	@userPreferences IS NOT NULL
BEGIN
	IF	@pageSize IS NULL
		SET @pageSize = ISNULL(@userPreferences.value('/userPreferences[1]/general[1]/@rowsPerPage', 'int'), 20)
	SET @dateFormat = ISNULL(@userPreferences.value('/userPreferences[1]/general[1]/@dateFormat', 'int'), 1)
END
IF	@pageSize IS NULL
	SET @pageSize = 20
-- DECLARE @timeFrameType              INT     = 1 -- enum TimeFrameType {Range = 0, Relative = 1}
-- DECLARE @frequency                  INT     = 2 -- enum RelTimeFreq {Day = 1, Week = 2, Month = 3, Hour = 4, Year = 6}
-- DECLARE @numberOfPeriods            INT     = 6
-- DECLARE @reqStartTime               INT     = 0 -- dbo.GetUnixTime(DATEADD(w, -10, GETDATE()))
-- DECLARE @reqEndTime                 INT     = 0 --dbo.GetUnixTime(DATEADD(w, -5, GETDATE()))
-- DECLARE @includeCurrentPeriod       INT     = 1
-- DECLARE @treatWeekend               INT     = 0
-- DECLARE @predictionSteps            INT     = 2
-- DECLARE @reportDataType             INT     = 0X0FFFFFFF
-- DECLARE @detailsOnlyRequest         INT     = 0
--------------------------------------------------------
-- DECLARE @pageSize                   INT     = 100
-- DECLARE @pageNo                     INT     = 0
-- DECLARE @detailsSortColumnNo        INT     = 0
-- DECLARE @sortOrder                  INT     = 0
-- DECLARE @userId                     INT     = 1
-- DECLARE @localeId                   INT     = 0
-- DECLARE @reportEntities             NVARCHAR(MAX) = N''
DECLARE @debug                      INT = 0
DECLARE @stats                      INT = 0
DECLARE @statsTempTime		        DATETIME
DECLARE @totalNumberOfJobs			INT = 0
DECLARE @jobsPageSizeLocal			INT = @pageSize
DECLARE @jobsPageStart				INT = 0
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__Stats')            IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__Stats
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__PeriodsRaw')       IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__PeriodsRaw
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__Periods')          IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__Periods
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__Jobs')             IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__Jobs
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__HistoryData')      IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__HistoryData
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__PredictedData')    IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__PredictedData
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__JobsAggDetails')   IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__JobsAggDetails
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__JobsList')			IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__JobsList
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__ConfigAggDetails')	IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__ConfigAggDetails
DECLARE @const_AGG_JOBS_SUCCESS     INT = 0x0000001
DECLARE @const_AGG_JOBS_SUCCESS_ERR INT = 0x0000002
DECLARE @const_AGG_JOBS_SUCCESS_WRN INT = 0x0000004
DECLARE @const_AGG_JOBS_FAILED      INT = 0x0000008
DECLARE @const_AGG_JOBS_KILLED      INT = 0x0000010
DECLARE @const_AGG_JOBS_NORUN       INT = 0x0000020
DECLARE @const_AGG_JOBS_TOTAL       INT = 0x0000040
DECLARE @const_AGG_CLIENT_TOTAL     INT = 0x0000200
DECLARE @const_AGG_CLIENT_NEW       INT = 0x0000400
DECLARE @const_AGG_CLIENT_DELETED   INT = 0x0000800
DECLARE @const_AGG_AGENT_TOTAL      INT = 0x0001000
DECLARE @const_AGG_AGENT_NEW        INT = 0x0002000
DECLARE @const_AGG_AGENT_DELETED    INT = 0x0004000
DECLARE @const_AGG_CAL              INT = 0x0008000
DECLARE @const_AGG_VM               INT = 0x0010000
DECLARE @const_AGG_VM_NEW           INT = 0x0020000
DECLARE @const_AGG_VM_DELETED       INT = 0x0040000
DECLARE @const_AGG_PROTECTEDDATA    INT = 0x0080000
DECLARE @const_AGG_PRIMARYSTORAGE	INT = 0x0100000
DECLARE @const_AGG_LICS_ENT_BKP		INT = 0x0200000
DECLARE @const_AGG_LICS_CORE_BKP	INT = 0x0400000
DECLARE @const_AGG_LICS_ENT_ARC		INT = 0x0800000
DECLARE @const_AGG_LICS_CORE_ARC	INT = 0x1000000
DECLARE @const_AGG_JOBS_FULL		INT = 0x2000000
DECLARE @const_AGG_JOBS_INCR		INT = 0x4000000
DECLARE @const_AGG_JOBS_AUX			INT = 0x8000000
DECLARE @const_AGG_LICS				INT = (@const_AGG_LICS_ENT_BKP|@const_AGG_LICS_CORE_BKP|@const_AGG_LICS_ENT_ARC|@const_AGG_LICS_CORE_ARC)
DECLARE @const_AGG_CONFIGURATION	INT = (@const_AGG_CLIENT_TOTAL|@const_AGG_CLIENT_NEW|@const_AGG_CLIENT_DELETED|@const_AGG_AGENT_TOTAL|@const_AGG_AGENT_NEW|@const_AGG_AGENT_DELETED|@const_AGG_CAL|@const_AGG_VM|@const_AGG_VM_NEW|@const_AGG_VM_DELETED)
DECLARE @const_AGG_JOBS				INT = (@const_AGG_JOBS_FULL|@const_AGG_JOBS_INCR|@const_AGG_JOBS_AUX)
DECLARE @const_AGG_DATA				INT = (@const_AGG_PROTECTEDDATA|@const_AGG_PRIMARYSTORAGE)
DECLARE @CapacityAsOfTime			INT = dbo.GetUnixTime(GETUTCDATE())
DECLARE @CapacityAsOf				VARCHAR(64)
DECLARE @licVal						VARCHAR(512)
DECLARE @licStr						VARCHAR(512)
DECLARE @LicCoreBackupGB			BIGINT = 0
DECLARE @LicEntBackupGB				BIGINT = 0
DECLARE @LicCoreArchiveGB			BIGINT = 0
DECLARE @LicEntArchiveGB			BIGINT = 0
CREATE TABLE #GrowthAndTranding_tmp__PeriodsRaw
(
    predicted		INT,
	stepBeginUnix	INT,
	stepEndUnix		INT,
    stepBegin		DATETIME,
    stepEnd			DATETIME,
    stepBeginLocal	DATETIME,
    stepEndLocal	DATETIME
)
CREATE TABLE #GrowthAndTranding_tmp__Periods
(
    periodId            INT     IDENTITY(1,1)   NOT NULL,
    predicted           BIT                     NOT NULL,
    periodStart         INT                     NOT NULL,
    periodEnd           INT                     NOT NULL,
    periodStartDT       DATETIME                NOT NULL,
    periodEndDT         DATETIME                NOT NULL
)
-- for now having this index does not help
/*
CREATE INDEX tmp__Periods_periodId_idx ON #GrowthAndTranding_tmp__Periods
(
    periodId    ASC
)
*/
CREATE TABLE #GrowthAndTranding_tmp__Jobs
(
	periodId			INT,
    commcellId          INT,
    clientId            INT,
    apptypeId           INT,
    instanceId          INT,
    backupsetId         INT,
    subclientId         INT,
    jobId               INT,
    opType              INT,
    backupLevel         INT,
    status              INT,
    jobType				INT,
    startDate           INT,
    endDate             INT,
    failedAtempts       INT,
    appSize				BIGINT,
    dataWritten			BIGINT,
    protectedObjects	BIGINT,
    failedObjects		BIGINT,
    failedFolders		BIGINT,
    dataArchGroupId		INT,
    logArchGroupId		INT,
	failureReason		NVARCHAR(256)
)
CREATE INDEX tmp__Jobs_startEndDate_idx ON #GrowthAndTranding_tmp__Jobs
(
    startDate   ASC,
    endDate     ASC
)
-- populate #GrowthAndTranding_tmp__Jobs table and calculate aggregates support index.
-- without index : (870:796), (826:553), (1060:546), (886:550), (983:543), (740:440), (723:540), (736:566), (860:550), (750:590), (680:440)
-- less min (680:440) and max (870+796), average (756:478) = 1243
-- with index while populating #GrowthAndTranding_tmp__Jobs table: (1323:493), (1073:560), (1253:566), (1260:630), (1216:503), (1233:520), (1233:530),
--               : (936:443), (1243:500), (1196:516), (1013:520), (903,426)
-- less min (903,426) and max (1260:630), average (1171:515) = 1686
-- with index after populating #GrowthAndTranding_tmp__Jobs table
--               : (796:560), (770:473), (1096:496), (1163:513), (1036:570), (886:513), (890:516), (766:630), (746:406), (946:410), (853:526), (836:523)
-- less min (746:406) and max (1163:513), average (887:521) = 1408
-- do not use index at all.
/*
CREATE INDEX tmp__Jobs_Status_idx ON #GrowthAndTranding_tmp__Jobs
(
    [Status] ASC
)*/
CREATE TABLE #GrowthAndTranding_tmp__JobsList
(
    id                      INT IDENTITY(1,1),
	jobCategory			    INT,
    jobId                   INT,
    commCellId              INT,
    commCellName            NVARCHAR(1024),
    clientId                INT,
    clientName              NVARCHAR(1024),
    appTypeId               INT,
    appTypeName             NVARCHAR(1024),
    instanceId              INT,
    instanceName            NVARCHAR(1024),
    backupsetId             INT,
    backupsetName           NVARCHAR(1024),
    subclientId             INT,
    subclientName           NVARCHAR(1024),
    opType                  INT,
    startTime               INT,
    endTime                 INT,
    logicalSize             BIGINT,
    physicalSize            BIGINT,
    nwTransBytes            BIGINT,
    protectedObjects        BIGINT,
    failedObjects           BIGINT,
    failedFolders           BIGINT,
    userName                NVARCHAR(512),
    [status]                INT,
    failureReason           NTEXT,
)
-- PeriodId id is from #GrowthAndTranding_tmp__Periods
-- Entity type : one of @const_aggtype_*
CREATE TABLE #GrowthAndTranding_tmp__HistoryData
(
    periodId            INT,
    entityType          INT,
	doNotPlot			INT,
    value               BIGINT
)
CREATE TABLE #GrowthAndTranding_tmp__PredictedData
(
    entityType          INT,
    growthRate          FLOAT,
    maxEntityValue      BIGINT
)
CREATE TABLE #GrowthAndTranding_tmp__JobsAggDetails
(
	jobTypeId				INT,
	predicted				INT,
	periodId				INT,
	entityId				INT,
	entityName				NVARCHAR(200),
	totalJobs				INT,
	totalAppSize			BIGINT,
	totalDataWritten		BIGINT,
	totalProtectedObjects	BIGINT,
	totalFailedObjects		BIGINT,
	totalFailedFolders		BIGINT
)
CREATE TABLE #GrowthAndTranding_tmp__ConfigAggDetails
(
    periodId            INT,
    entityType          INT,
	total				BIGINT,
	added				BIGINT,
	deleted				BIGINT
)
IF @stats <> 0 BEGIN
    CREATE TABLE #GrowthAndTranding_tmp__Stats (type VARCHAR(50), timeSpentMili INT)
    SET NOCOUNT ON
    SET STATISTICS IO ON
    SET STATISTICS TIME ON
END
-- first step - lets build periods range
-- all calculations will be perfomed based on local commcell time frame definitions, so commcellId parameter is always 2
IF @stats <> 0 SET @statsTempTime = GETDATE()
EXEC dbo.wr_BuildDaysRangeForTimeZone '#GrowthAndTranding_tmp__PeriodsRaw', '', @reqEndTime, @frequency, @numberOfPeriods, @predictionSteps
-- -- get only the values we are going to work with
INSERT INTO #GrowthAndTranding_tmp__Periods (predicted, periodStart, periodEnd, periodStartDT, periodEndDT)
    SELECT  predicted, stepBeginUnix, stepEndUnix, stepBegin, stepEnd
    FROM    #GrowthAndTranding_tmp__PeriodsRaw
    ORDER   BY stepBeginUnix ASC
-- -- no need for #GrowthAndTranding_tmp__PeriodsRaw table any more. kill it
DROP TABLE #GrowthAndTranding_tmp__PeriodsRaw
DECLARE @periodMin      AS INT
DECLARE @periodMax      AS INT
DECLARE @periodMinDT    AS DATETIME
DECLARE @periodMaxDT    AS DATETIME
SELECT  @periodMin   = MIN(periodStart),   @periodMax   = MAX(periodEnd),
        @periodMinDT = MIN(periodStartDT), @periodMaxDT = MAX(periodEndDT)
FROM    #GrowthAndTranding_tmp__Periods
IF @stats <> 0 INSERT INTO #GrowthAndTranding_tmp__Stats VALUES('working periods', datediff(millisecond, @statsTempTime, GetDate()))
IF @debug > 0 SELECT 'periods: min', @periodMin, @periodMinDT, 'periods: max', @periodMax, @periodMaxDT
IF @debug > 0 SELECT 'periods', * FROM #GrowthAndTranding_tmp__Periods ORDER BY periodId ASC
IF (@reportDataType & @const_AGG_LICS) <> 0 BEGIN
	IF @stats <> 0 SET @statsTempTime = GETDATE()
	INSERT INTO #GrowthAndTranding_tmp__HistoryData
				  -- enterprise backup
		SELECT  P.periodId, @const_AGG_LICS_ENT_BKP, 0,
				ISNULL((SELECT MAX(EnterpriseBackupSize) FROM LicUsageDetailsHistory WITH (NOLOCK) WHERE [date] BETWEEN P.periodStart AND P.periodEnd), 0)
		FROM    #GrowthAndTranding_tmp__Periods P
		WHERE	P.periodEnd < @periodMax
		UNION ALL -- core backup
		SELECT  P.periodId, @const_AGG_LICS_CORE_BKP, 0,
				ISNULL((SELECT MAX(CoreBackupSize) FROM LicUsageDetailsHistory WITH (NOLOCK) WHERE [date] BETWEEN P.periodStart AND P.periodEnd), 0)
		FROM    #GrowthAndTranding_tmp__Periods P
		WHERE	P.periodEnd < @periodMax
		UNION ALL -- enterprise archive
		SELECT  P.periodId, @const_AGG_LICS_ENT_ARC, 0,
				ISNULL((SELECT MAX(EnterpriseArchiveSize) FROM LicUsageDetailsHistory WITH (NOLOCK) WHERE [date] BETWEEN P.periodStart AND P.periodEnd), 0)
		FROM    #GrowthAndTranding_tmp__Periods P
		WHERE	P.periodEnd < @periodMax
		UNION ALL -- core archive
		SELECT  P.periodId, @const_AGG_LICS_CORE_ARC, 0,
				ISNULL((SELECT MAX(CoreArchiveSize) FROM LicUsageDetailsHistory WITH (NOLOCK) WHERE [date] BETWEEN P.periodStart AND P.periodEnd), 0)
		FROM    #GrowthAndTranding_tmp__Periods P
		WHERE	P.periodEnd < @periodMax
	INSERT INTO #GrowthAndTranding_tmp__HistoryData
				  -- enterprise backup
		SELECT  P.periodId, @const_AGG_LICS_ENT_BKP, 0,
				ISNULL((SELECT TOP 1 EnterpriseBackupSize FROM LicUsageDetailsHistory WITH (NOLOCK)
						WHERE [date] BETWEEN P.periodStart AND P.periodEnd
						ORDER BY [date] DESC), 0)
		FROM    #GrowthAndTranding_tmp__Periods P
		WHERE	P.periodEnd = @periodMax
		UNION ALL -- core backup
		SELECT  P.periodId, @const_AGG_LICS_CORE_BKP, 0,
				ISNULL((SELECT TOP 1 CoreBackupSize FROM LicUsageDetailsHistory WITH (NOLOCK)
						WHERE [date] BETWEEN P.periodStart AND P.periodEnd
						ORDER BY [date] DESC), 0)
		FROM    #GrowthAndTranding_tmp__Periods P
		WHERE	P.periodEnd = @periodMax
		UNION ALL -- enterprise archive
		SELECT  P.periodId, @const_AGG_LICS_ENT_ARC, 0,
				ISNULL((SELECT TOP 1 EnterpriseArchiveSize FROM LicUsageDetailsHistory WITH (NOLOCK)
						WHERE [date] BETWEEN P.periodStart AND P.periodEnd
						ORDER BY [date] DESC), 0)
		FROM    #GrowthAndTranding_tmp__Periods P
		WHERE	P.periodEnd = @periodMax
		UNION ALL -- core archive
		SELECT  P.periodId, @const_AGG_LICS_CORE_ARC, 0,
				ISNULL((SELECT TOP 1 CoreArchiveSize FROM LicUsageDetailsHistory WITH (NOLOCK)
						WHERE [date] BETWEEN P.periodStart AND P.periodEnd
						ORDER BY [date] DESC), 0)
		FROM    #GrowthAndTranding_tmp__Periods P
		WHERE	P.periodEnd = @periodMax
	IF @stats <> 0 INSERT INTO #GrowthAndTranding_tmp__Stats VALUES('lic aggs', datediff(millisecond, @statsTempTime, GetDate()))
	IF @debug <> 0 SELECT 'lic aggs', * FROM #GrowthAndTranding_tmp__HistoryData
	-- Get maximum values of capacity licenses
	SELECT @licVal = attrVal FROM LicUsageBasedConfig WITH (NOLOCK) WHERE attrName = '100001 issued'
	EXEC miscProc2 @licVal, @licStr OUTPUT
	SET @licVal = SUBSTRING(@licStr, CHARINDEX(':-', @licStr) + 2, LEN(@licStr))
	SET @LicCoreBackupGB = CAST(@licVal AS BIGINT)
	SELECT @licVal = attrVal FROM LicUsageBasedConfig WITH (NOLOCK) WHERE attrName = '100002 issued'
	EXEC miscProc2 @licVal, @licStr OUTPUT
	SET @licVal = SUBSTRING(@licStr, CHARINDEX(':-', @licStr) + 2, LEN(@licStr))
	SET @LicEntBackupGB = CAST(@licVal AS BIGINT)
	SELECT @licVal = attrVal FROM LicUsageBasedConfig WITH (NOLOCK) WHERE attrName = '100003 issued'
	EXEC miscProc2 @licVal, @licStr OUTPUT
	SET @licVal = SUBSTRING(@licStr, CHARINDEX(':-', @licStr) + 2, LEN(@licStr))
	SET @LicCoreArchiveGB = CAST(@licVal AS BIGINT)
	SELECT @licVal = attrVal FROM LicUsageBasedConfig WITH (NOLOCK) WHERE attrName = '100004 issued'
	EXEC miscProc2 @licVal, @licStr OUTPUT
	SET @licVal = SUBSTRING(@licStr, CHARINDEX(':-', @licStr) + 2, LEN(@licStr))
	SET @LicEntArchiveGB = CAST(@licVal AS BIGINT)
	IF	@LicCoreBackupGB = 0 AND @LicEntBackupGB > 0
	BEGIN
		UPDATE	#GrowthAndTranding_tmp__HistoryData
		SET		value = T.value + CORE.value
		FROM	#GrowthAndTranding_tmp__HistoryData T,
				(SELECT	periodId, value
				FROM	#GrowthAndTranding_tmp__HistoryData
				WHERE	entityType = @const_AGG_LICS_CORE_BKP) AS CORE
		WHERE	T.entityType = @const_AGG_LICS_ENT_BKP AND T.periodId = CORE.periodId
		UPDATE	#GrowthAndTranding_tmp__HistoryData
		SET		value = 0
		WHERE	entityType = @const_AGG_LICS_CORE_BKP
	END
	IF	@LicCoreArchiveGB = 0 AND @LicEntArchiveGB > 0
	BEGIN
		UPDATE	#GrowthAndTranding_tmp__HistoryData
		SET		value = T.value + CORE.value
		FROM	#GrowthAndTranding_tmp__HistoryData T,
				(SELECT	periodId, value
				FROM	#GrowthAndTranding_tmp__HistoryData
				WHERE	entityType = @const_AGG_LICS_CORE_ARC) AS CORE
		WHERE	T.entityType = @const_AGG_LICS_ENT_ARC AND T.periodId = CORE.periodId
		UPDATE	#GrowthAndTranding_tmp__HistoryData
		SET		value = 0
		WHERE	entityType = @const_AGG_LICS_CORE_ARC
	END
	SELECT	@CapacityAsOfTime = MAX(date) FROM LicUsageDetailsHistory WITH (NOLOCK)
	SET		@CapacityAsOf = convert(datetime, dbo.GetDateTime(@CapacityAsOfTime + @bias), 100)
	SET		@CapacityAsOf = LEFT(@CapacityAsOf, 11)
	SET		@CapacityAsOf = LEFT(@CapacityAsOf, 6) + ', ' + RIGHT(@CapacityAsOf, 4)
END
IF (@reportDataType & @const_AGG_CONFIGURATION) <> 0 BEGIN
	IF @stats <> 0 SET @statsTempTime = GETDATE()
	INSERT INTO #GrowthAndTranding_tmp__HistoryData
				  -- total clients
		SELECT  P.periodId, @const_AGG_CLIENT_TOTAL, 0,
				(SELECT COUNT(*) FROM APP_ClientInstallHistory WITH (NOLOCK) WHERE installTime < P.periodEnd AND uninstallTime = 0)
		FROM    #GrowthAndTranding_tmp__Periods P
		UNION ALL -- new clients
		SELECT  P.periodId, @const_AGG_CLIENT_NEW, 0,
				(SELECT COUNT(*) FROM APP_ClientInstallHistory WITH (NOLOCK) WHERE installTime BETWEEN P.periodStart AND P.periodEnd)
		FROM    #GrowthAndTranding_tmp__Periods P
		UNION ALL -- deleted clients
		SELECT  P.periodId, @const_AGG_CLIENT_DELETED, 0,
				(SELECT COUNT(*) FROM APP_ClientInstallHistory WITH (NOLOCK) WHERE uninstallTime BETWEEN P.periodStart AND P.periodEnd)
		FROM    #GrowthAndTranding_tmp__Periods P
		UNION ALL -- total agents
		SELECT  P.periodId, @const_AGG_AGENT_TOTAL, 0,
				(SELECT COUNT(*) FROM APP_IDAName WITH (NOLOCK) WHERE modified > 0 AND modified < P.periodEnd AND (status & (0x2|0x4)) = 0)
		FROM    #GrowthAndTranding_tmp__Periods P
		UNION ALL -- new agents
		SELECT  P.periodId, @const_AGG_AGENT_NEW, 0,
				(SELECT COUNT(*) FROM APP_IDAName WITH (NOLOCK) WHERE modified BETWEEN P.periodStart AND P.periodEnd AND (status & (0x2|0x4)) = 0)
		FROM    #GrowthAndTranding_tmp__Periods P
		UNION ALL -- deleted agents
		SELECT  P.periodId, @const_AGG_AGENT_DELETED, 0,
				(SELECT COUNT(*) FROM APP_IDAName WITH (NOLOCK) WHERE modified BETWEEN P.periodStart AND P.periodEnd AND (status & (0x2|0x4)) <> 0)
		FROM    #GrowthAndTranding_tmp__Periods P
		UNION ALL  -- total VM's
		SELECT  P.periodId, @const_AGG_VM, 0,
				(SELECT COUNT(*) FROM APP_ClientInstallHistory WITH (NOLOCK) WHERE installTime < P.periodEnd AND uninstallTime = 0
				 AND clientId IN (SELECT componentNameId FROM APP_ClientProp WITH (NOLOCK) WHERE attrName = 'Virtual Server Discovered Clients' AND attrVal = '1'))
		FROM    #GrowthAndTranding_tmp__Periods P
		UNION ALL -- new vms
		SELECT  P.periodId, @const_AGG_VM_NEW, 0,
				(SELECT COUNT(*) FROM APP_ClientInstallHistory WITH (NOLOCK) WHERE installTime BETWEEN P.periodStart AND P.periodEnd
				 AND clientId IN (SELECT componentNameId FROM APP_ClientProp WITH (NOLOCK) WHERE attrName = 'Virtual Server Discovered Clients' AND attrVal = '1'))
		FROM    #GrowthAndTranding_tmp__Periods P
		UNION ALL -- deleted vms
		SELECT  P.periodId, @const_AGG_VM_DELETED, 0,
				(SELECT COUNT(*) FROM APP_ClientInstallHistory WITH (NOLOCK) WHERE uninstallTime BETWEEN P.periodStart AND P.periodEnd
				 AND clientId IN (SELECT componentNameId FROM APP_ClientProp WITH (NOLOCK) WHERE attrName = 'Virtual Server Discovered Clients' AND attrVal = '1'))
		FROM    #GrowthAndTranding_tmp__Periods P
	IF @stats <> 0 INSERT INTO #GrowthAndTranding_tmp__Stats VALUES('config agg', datediff(millisecond, @statsTempTime, GetDate()))
	IF @debug <> 0 SELECT 'config agg ', * FROM #GrowthAndTranding_tmp__HistoryData WHERE entityType IN( @const_AGG_CLIENT_TOTAL,
									 															         @const_AGG_CLIENT_NEW,
																										 @const_AGG_CLIENT_DELETED,
																										 @const_AGG_AGENT_TOTAL,
																										 @const_AGG_AGENT_NEW,
																										 @const_AGG_AGENT_DELETED,
																										 @const_AGG_CAL,
																										 @const_AGG_VM,
																										 @const_AGG_VM_NEW,
																										 @const_AGG_VM_DELETED )
	IF @stats <> 0 SET @statsTempTime = GETDATE()
	INSERT INTO #GrowthAndTranding_tmp__ConfigAggDetails
		SELECT	HD.periodId, HD.entityType, HD.value,
				(CASE HD.entityType WHEN @const_AGG_CLIENT_TOTAL THEN (SELECT value FROM #GrowthAndTranding_tmp__HistoryData WHERE periodId = HD.periodId AND entityType = @const_AGG_CLIENT_NEW)
									WHEN @const_AGG_AGENT_TOTAL  THEN (SELECT value FROM #GrowthAndTranding_tmp__HistoryData WHERE periodId = HD.periodId AND entityType = @const_AGG_AGENT_NEW)
									WHEN @const_AGG_VM			 THEN (SELECT value FROM #GrowthAndTranding_tmp__HistoryData WHERE periodId = HD.periodId AND entityType = @const_AGG_VM_NEW)
				 END),
				(CASE HD.entityType WHEN @const_AGG_CLIENT_TOTAL THEN (SELECT value FROM #GrowthAndTranding_tmp__HistoryData WHERE periodId = HD.periodId AND entityType = @const_AGG_CLIENT_DELETED)
									WHEN @const_AGG_AGENT_TOTAL  THEN (SELECT value FROM #GrowthAndTranding_tmp__HistoryData WHERE periodId = HD.periodId AND entityType = @const_AGG_AGENT_DELETED)
									WHEN @const_AGG_VM			 THEN (SELECT value FROM #GrowthAndTranding_tmp__HistoryData WHERE periodId = HD.periodId AND entityType = @const_AGG_VM_DELETED)
				 END)
		FROM	#GrowthAndTranding_tmp__HistoryData HD
		WHERE	HD.entityType IN(@const_AGG_CLIENT_TOTAL, @const_AGG_AGENT_TOTAL, @const_AGG_VM)
	IF @stats <> 0 INSERT INTO #GrowthAndTranding_tmp__Stats VALUES('config details', datediff(millisecond, @statsTempTime, GetDate()))
	IF @debug <> 0 SELECT 'config details', * FROM #GrowthAndTranding_tmp__ConfigAggDetails
END
IF (@reportDataType & (@const_AGG_JOBS | @const_AGG_PROTECTEDDATA)) <> 0 BEGIN
	IF @stats <> 0 SET @statsTempTime = GETDATE()
	INSERT INTO #GrowthAndTranding_tmp__Jobs
		SELECT	P.periodId,	ISNULL(A.origCCId, 0), ISNULL(A.clientId, 0), ISNULL(A.appTypeId, 0), ISNULL(A.instance, 0), ISNULL(A.backupSet,0), ISNULL(A.id, 0),
				ISNULL(B.jobId, 0), ISNULL(B.opType,  0), ISNULL(B.bkpLevel,0),
				ISNULL(dbo.GetJobStatusForReport((CASE B.displayStatus WHEN 0 THEN B.[status] ELSE B.displayStatus END), 1), 0),
				-- job type
				(CASE WHEN (dbo.IsBackupLevelFull(B.bkpLevel) = 1 OR dbo.IsBackupLevelSynthFull(B.bkpLevel) = 1) THEN @const_AGG_JOBS_FULL
																												 ELSE @const_AGG_JOBS_INCR
				 END),
				ISNULL(B.servStartDate, 0), ISNULL(B.servEndDate, 0),
				ISNULL((SELECT COUNT(*) FROM JMBkpAtmptStats BA WITH (NOLOCK) WHERE BA.commCellId = B.commCellId AND BA.jobId = B.jobId AND BA.[status] IN (2, 4, 5, 6)), 0),
														 -- CVJobStatus::FAILED, CVJobStatus::KILLED, CVJobStatus::STSTOPPED, CVJobStatus::STINTERRUPTED
				ISNULL(B.totalUncompBytes, 0), 0, ISNULL(B.totalNumOfFiles, 0), ISNULL(B.backupFileFailures, 0), ISNULL(B.backupFolderFailures, 0),
				ISNULL(B.dataArchGrpId, 0), ISNULL(B.logArchGrpId, 0), ISNULL(B.failureReason, '')
		FROM    #GrowthAndTranding_tmp__Periods P
				LEFT OUTER JOIN JMBkpStats B WITH (NOLOCK) ON B.servStartDate BETWEEN P.periodStart AND P.periodEnd
				LEFT OUTER JOIN APP_Application A WITH (NOLOCK) ON A.id = B.appId
		WHERE       B.servStartDate BETWEEN @periodMin AND @periodMax
				AND ((@userId = 0) OR (dbo.isBkpJobVisible(@userId, A.origCCId, A.clientId, A.apptypeId, A.instance, A.backupSet, A.id) = 1))
	IF @stats <> 0 INSERT INTO #GrowthAndTranding_tmp__Stats VALUES('jobs', datediff(millisecond, @statsTempTime, GetDate()))
	IF @debug <> 0 SELECT 'jobs', * FROM #GrowthAndTranding_tmp__Jobs
END
	-- aggregations
IF (@reportDataType & @const_AGG_JOBS) <> 0 BEGIN
	IF @stats <> 0 SET @statsTempTime = GETDATE()
	INSERT INTO #GrowthAndTranding_tmp__HistoryData
		-- run a query that calculates distribution for @const_aggtype_jobs_total
		SELECT  P.periodId, @const_AGG_JOBS_FULL, 0,
				(SELECT COUNT(*) FROM #GrowthAndTranding_tmp__Jobs J WHERE      (J.startDate BETWEEN P.periodStart AND P.periodEnd)
																			AND (J.jobType = @const_AGG_JOBS_FULL)
																			AND (J.opType NOT IN (13, 104))) -- exclude aux jobs
		FROM    #GrowthAndTranding_tmp__Periods P
		UNION ALL
		SELECT  P.periodId, @const_AGG_JOBS_INCR, 0,
				(SELECT COUNT(*) FROM #GrowthAndTranding_tmp__Jobs J WHERE      (J.startDate BETWEEN P.periodStart AND P.periodEnd)
																			AND (J.jobType = @const_AGG_JOBS_INCR)
																			AND (J.opType NOT IN (13, 104))) -- exclude aux jobs
		FROM    #GrowthAndTranding_tmp__Periods P
		UNION ALL
		SELECT  P.periodId, @const_AGG_JOBS_AUX, 0,
				(SELECT COUNT(*) FROM #GrowthAndTranding_tmp__Jobs J WHERE      (J.startDate BETWEEN P.periodStart AND P.periodEnd)
																			AND (J.opType IN (13, 104))) -- include aux jobs only
		FROM    #GrowthAndTranding_tmp__Periods P
	IF @stats <> 0 INSERT INTO #GrowthAndTranding_tmp__Stats VALUES('jobs aggs', datediff(millisecond, @statsTempTime, GetDate()))
	IF @debug <> 0 SELECT 'jobs aggs', * FROM #GrowthAndTranding_tmp__HistoryData WHERE entityType IN ( @const_AGG_JOBS_FULL,
																										@const_AGG_JOBS_INCR,
																										@const_AGG_JOBS_AUX )
	-- job aggregation details
	DECLARE @statusToProcess INT = 1
	WHILE  @statusToProcess < 9 BEGIN
		IF @statusToProcess = 6 OR @statusToProcess = 7 BEGIN
			SET @statusToProcess = @statusToProcess + 1
			CONTINUE
		END
		INSERT INTO #GrowthAndTranding_tmp__JobsAggDetails
			SELECT	HD.entityType, P.predicted, HD.periodId,
					@statusToProcess, '',
					(SELECT COUNT(*) FROM #GrowthAndTranding_tmp__Jobs J WHERE J.periodId = HD.periodId AND J.status = @statusToProcess AND J.jobType = @const_AGG_JOBS_FULL),
					ISNULL((SELECT SUM(ISNULL(J.appSize, 0))			FROM #GrowthAndTranding_tmp__Jobs J WHERE J.periodId = HD.periodId AND J.status = @statusToProcess AND J.jobType = @const_AGG_JOBS_FULL), 0),
					ISNULL((SELECT SUM(ISNULL(J.dataWritten, 0))		FROM #GrowthAndTranding_tmp__Jobs J WHERE J.periodId = HD.periodId AND J.status = @statusToProcess AND J.jobType = @const_AGG_JOBS_FULL), 0),
					ISNULL((SELECT SUM(ISNULL(J.protectedObjects, 0))	FROM #GrowthAndTranding_tmp__Jobs J WHERE J.periodId = HD.periodId AND J.status = @statusToProcess AND J.jobType = @const_AGG_JOBS_FULL), 0),
					ISNULL((SELECT SUM(ISNULL(J.failedObjects, 0))		FROM #GrowthAndTranding_tmp__Jobs J WHERE J.periodId = HD.periodId AND J.status = @statusToProcess AND J.jobType = @const_AGG_JOBS_FULL), 0),
					ISNULL((SELECT SUM(ISNULL(J.failedFolders, 0))		FROM #GrowthAndTranding_tmp__Jobs J WHERE J.periodId = HD.periodId AND J.status = @statusToProcess AND J.jobType = @const_AGG_JOBS_FULL), 0)
			FROM	#GrowthAndTranding_tmp__Periods P INNER JOIN #GrowthAndTranding_tmp__HistoryData HD ON HD.periodId = P.periodId
			WHERE	HD.entityType = @const_AGG_JOBS_FULL
			UNION ALL
			SELECT	HD.entityType, P.predicted, HD.periodId,
					@statusToProcess, '',
					(SELECT COUNT(*) FROM #GrowthAndTranding_tmp__Jobs J WHERE J.periodId = HD.periodId AND J.status = @statusToProcess AND J.jobType = @const_AGG_JOBS_INCR),
					ISNULL((SELECT SUM(ISNULL(J.appSize, 0))			FROM #GrowthAndTranding_tmp__Jobs J WHERE J.periodId = HD.periodId AND J.status = @statusToProcess AND J.jobType = @const_AGG_JOBS_INCR), 0),
					ISNULL((SELECT SUM(ISNULL(J.dataWritten, 0))		FROM #GrowthAndTranding_tmp__Jobs J WHERE J.periodId = HD.periodId AND J.status = @statusToProcess AND J.jobType = @const_AGG_JOBS_INCR), 0),
					ISNULL((SELECT SUM(ISNULL(J.protectedObjects, 0))	FROM #GrowthAndTranding_tmp__Jobs J WHERE J.periodId = HD.periodId AND J.status = @statusToProcess AND J.jobType = @const_AGG_JOBS_INCR), 0),
					ISNULL((SELECT SUM(ISNULL(J.failedObjects, 0))		FROM #GrowthAndTranding_tmp__Jobs J WHERE J.periodId = HD.periodId AND J.status = @statusToProcess AND J.jobType = @const_AGG_JOBS_INCR), 0),
					ISNULL((SELECT SUM(ISNULL(J.failedFolders, 0))		FROM #GrowthAndTranding_tmp__Jobs J WHERE J.periodId = HD.periodId AND J.status = @statusToProcess AND J.jobType = @const_AGG_JOBS_INCR), 0)
			FROM	#GrowthAndTranding_tmp__Periods P INNER JOIN #GrowthAndTranding_tmp__HistoryData HD ON HD.periodId = P.periodId
			WHERE	HD.entityType = @const_AGG_JOBS_INCR
			UNION ALL
			SELECT	HD.entityType, P.predicted, HD.periodId,
					@statusToProcess, '',
					(SELECT COUNT(*) FROM #GrowthAndTranding_tmp__Jobs J WHERE J.periodId = HD.periodId AND J.status = @statusToProcess AND J.jobType = @const_AGG_JOBS_AUX),
					ISNULL((SELECT SUM(ISNULL(J.appSize, 0))			FROM #GrowthAndTranding_tmp__Jobs J WHERE J.periodId = HD.periodId AND J.status = @statusToProcess AND J.jobType = @const_AGG_JOBS_AUX), 0),
					ISNULL((SELECT SUM(ISNULL(J.dataWritten, 0))		FROM #GrowthAndTranding_tmp__Jobs J WHERE J.periodId = HD.periodId AND J.status = @statusToProcess AND J.jobType = @const_AGG_JOBS_AUX), 0),
					ISNULL((SELECT SUM(ISNULL(J.protectedObjects, 0))	FROM #GrowthAndTranding_tmp__Jobs J WHERE J.periodId = HD.periodId AND J.status = @statusToProcess AND J.jobType = @const_AGG_JOBS_AUX), 0),
					ISNULL((SELECT SUM(ISNULL(J.failedObjects, 0))		FROM #GrowthAndTranding_tmp__Jobs J WHERE J.periodId = HD.periodId AND J.status = @statusToProcess AND J.jobType = @const_AGG_JOBS_AUX), 0),
					ISNULL((SELECT SUM(ISNULL(J.failedFolders, 0))		FROM #GrowthAndTranding_tmp__Jobs J WHERE J.periodId = HD.periodId AND J.status = @statusToProcess AND J.jobType = @const_AGG_JOBS_AUX), 0)
			FROM	#GrowthAndTranding_tmp__Periods P INNER JOIN #GrowthAndTranding_tmp__HistoryData HD ON HD.periodId = P.periodId
			WHERE	HD.entityType = @const_AGG_JOBS_AUX
		SET @statusToProcess = @statusToProcess + 1
	END
    UPDATE #GrowthAndTranding_tmp__JobsAggDetails
    SET    entityName = CASE WHEN entityId = 1 THEN ISNULL((SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK) WHERE MessageID = 1023410748 AND LocaleID = @localeId), 'Completed') --
                             WHEN entityId = 2 THEN ISNULL((SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK) WHERE MessageID = 1023410749 AND LocaleID = @localeId), 'Completed with errors')
                             WHEN entityId = 3 THEN ISNULL((SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK) WHERE MessageID = 1023410752 AND LocaleID = @localeId), 'Completed Partial')
                             WHEN entityId = 4 THEN ISNULL((SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK) WHERE MessageID = 1023410755 AND LocaleID = @localeId), 'Failed')
                             WHEN entityId = 5 THEN ISNULL((SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK) WHERE MessageID = 1023410754 AND LocaleID = @localeId), 'Killed')
                             WHEN entityId = 8 THEN ISNULL((SELECT [Message] FROM EvLocaleMsgs WITH (NOLOCK) WHERE MessageID = 1023411223 AND LocaleID = @localeId), 'No Run')
                        END
	IF @stats <> 0 INSERT INTO #GrowthAndTranding_tmp__Stats VALUES('job agg details', datediff(millisecond, @statsTempTime, GetDate()))
	IF @debug <> 0 SELECT 'job agg details', * FROM #GrowthAndTranding_tmp__JobsAggDetails
END
IF (@reportDataType & @const_AGG_DATA) <> 0
BEGIN
	IF @stats <> 0 SET @statsTempTime = GETDATE()
	IF (@reportDataType & @const_AGG_PROTECTEDDATA) <> 0
	BEGIN
		INSERT INTO #GrowthAndTranding_tmp__JobsAggDetails
		SELECT	@const_AGG_PROTECTEDDATA, P.predicted, J.periodId, J.appTypeId, I.displayName,
				COUNT(*),
				SUM(ISNULL(J.appSize, 0)),
				SUM(ISNULL(J.dataWritten, 0)),
				SUM(ISNULL(J.protectedObjects, 0)),
				SUM(ISNULL(J.failedObjects, 0)),
				SUM(ISNULL(J.failedFolders, 0))
		FROM	#GrowthAndTranding_tmp__Periods P
				INNER JOIN #GrowthAndTranding_tmp__Jobs J ON J.periodId = P.periodId
				INNER JOIN APP_IDAType I WITH (NOLOCK) ON J.appTypeId = I.type
		WHERE	J.status IN (1, 3, 14)
		GROUP BY P.predicted, J.periodId, J.appTypeId, I.displayName
	END
	IF (@reportDataType & @const_AGG_PRIMARYSTORAGE) <> 0 AND DB_ID('SRM') IS NOT NULL
	BEGIN
		INSERT INTO #GrowthAndTranding_tmp__JobsAggDetails
		SELECT	@const_AGG_PRIMARYSTORAGE, P.predicted, P.periodId, A.appTypeId, I.name,
				COUNT(*), SUM(C.usedSpace)/COUNT(*), 0, 0, 0, 0
		FROM	#GrowthAndTranding_tmp__Periods P
				INNER JOIN SRM..SRMJobs J WITH (NOLOCK) ON J.timeStamp BETWEEN P.periodStartDT AND P.periodEndDT
				INNER JOIN SRM..SRMServerCapacityHistory C WITH (NOLOCK) ON C.jmJobStatId = J.jmJobStatId
				INNER JOIN APP_Application A WITH (NOLOCK) ON A.id = J.csStubSubClientId
				INNER JOIN APP_iDAType I WITH (NOLOCK) ON I.type = A.appTypeId
		GROUP BY P.predicted, P.periodId, A.appTypeId, I.name
	END
	INSERT INTO #GrowthAndTranding_tmp__JobsAggDetails
	SELECT	J.jobTypeId, P.predicted, P.periodId, J.entityId, J.entityName,
			0, 0, 0, 0, 0, 0
	FROM	#GrowthAndTranding_tmp__Periods P
			CROSS JOIN		(SELECT	DISTINCT jobTypeId, entityId, entityName
							FROM	#GrowthAndTranding_tmp__JobsAggDetails
							WHERE	jobTypeId IN (@const_AGG_PROTECTEDDATA, @const_AGG_PRIMARYSTORAGE)) J
			LEFT OUTER JOIN (SELECT jobTypeId, periodId, entityId, entityName
							FROM	#GrowthAndTranding_tmp__JobsAggDetails
							WHERE	jobTypeId IN (@const_AGG_PROTECTEDDATA, @const_AGG_PRIMARYSTORAGE)) A
				ON A.periodId = P.periodId AND A.jobTypeId = J.jobTypeId AND A.entityId = J.entityId
	WHERE	A.periodId IS NULL
	INSERT INTO #GrowthAndTranding_tmp__HistoryData
	SELECT	periodId, jobTypeId, 0, SUM(totalAppSize)
	FROM	#GrowthAndTranding_tmp__JobsAggDetails
	WHERE	jobTypeId IN (@const_AGG_PROTECTEDDATA, @const_AGG_PRIMARYSTORAGE)
	GROUP BY periodId, jobTypeId
	IF @stats <> 0 INSERT INTO #GrowthAndTranding_tmp__Stats VALUES('data aggs', datediff(millisecond, @statsTempTime, GetDate()))
	IF @debug <> 0
	BEGIN
		SELECT 'data aggs', * FROM #GrowthAndTranding_tmp__HistoryData WHERE entityType IN ( @const_AGG_PROTECTEDDATA, @const_AGG_PRIMARYSTORAGE )
		SELECT 'data agg details', * FROM #GrowthAndTranding_tmp__JobsAggDetails WHERE jobTypeId IN ( @const_AGG_PROTECTEDDATA, @const_AGG_PRIMARYSTORAGE )
	END
END
-- lets calculate daily growth rate
-- -- first level entities
IF @stats <> 0 SET @statsTempTime = GETDATE()
DECLARE @maxRealPeriodId INT = (SELECT MAX(periodId) FROM #GrowthAndTranding_tmp__Periods WHERE predicted = 0)
DECLARE @currentPeriodId INT = 2
DECLARE @currentEntityType INT = (SELECT MIN(entityType) FROM #GrowthAndTranding_tmp__HistoryData)
WHILE @currentEntityType IS NOT NULL BEGIN
    DECLARE @growthRate			FLOAT = 0
    DECLARE @numberOfDays		INT
	DECLARE @firstPeriodValue	BIGINT
	DECLARE @firstPeriodEnd		DATETIME
	DECLARE @lastPeriodValue	BIGINT
	DECLARE @lastPeriodEnd		DATETIME
	SELECT TOP 1 @firstPeriodValue = HD.value, @firstPeriodEnd = P.periodEndDT
	FROM	#GrowthAndTranding_tmp__HistoryData HD, #GrowthAndTranding_tmp__Periods P
	WHERE	HD.entityType = @currentEntityType AND HD.periodId = P.periodId AND P.predicted = 0
	ORDER BY P.periodId ASC
	SELECT TOP 1 @lastPeriodValue = HD.value, @lastPeriodEnd = P.periodEndDT
	FROM	#GrowthAndTranding_tmp__HistoryData HD, #GrowthAndTranding_tmp__Periods P
	WHERE	HD.entityType = @currentEntityType AND HD.periodId = P.periodId AND P.predicted = 0
	ORDER BY P.periodId DESC
	SET @numberOfDays	= DATEDIFF(DAY, @firstPeriodEnd, @lastPeriodEnd)
	IF	@numberOfDays > 0
		SET	@growthRate = CAST((@lastPeriodValue - @firstPeriodValue)/@numberOfDays AS FLOAT)
	ELSE
	BEGIN
		SELECT @numberOfDays = DATEDIFF(DAY, periodStartDT, periodEndDT) FROM #GrowthAndTranding_tmp__Periods WHERE periodEndDT = @lastPeriodEnd
  		SET	@growthRate = CAST(@lastPeriodValue/@numberOfDays AS FLOAT)
	END
    INSERT INTO #GrowthAndTranding_tmp__PredictedData
    SELECT	@currentEntityType, @growthRate,
			CASE @currentEntityType
			WHEN @const_AGG_LICS_CORE_BKP THEN @LicCoreBackupGB*1024*1024*1024
			WHEN @const_AGG_LICS_ENT_BKP  THEN @LicEntBackupGB*1024*1024*1024
			WHEN @const_AGG_LICS_CORE_ARC THEN @LicCoreArchiveGB*1024*1024*1024
			WHEN @const_AGG_LICS_ENT_ARC  THEN @LicEntArchiveGB*1024*1024*1024
			ELSE 0 END
    UPDATE  #GrowthAndTranding_tmp__HistoryData
    SET     value = @lastPeriodValue + DATEDIFF(DAY, @lastPeriodEnd, periodEndDT) * @growthRate
    FROM    #GrowthAndTranding_tmp__HistoryData HD INNER JOIN #GrowthAndTranding_tmp__Periods P ON P.periodId = HD.periodId
    WHERE   HD.entityType = @currentEntityType AND P.predicted = 1
    -- next entity type
    SELECT  @currentEntityType = MIN(entityType)
    FROM    #GrowthAndTranding_tmp__HistoryData
    WHERE   entityType > @currentEntityType
END
-- -- second level entities
-- -- -- configuration
DECLARE @currentConfigEntityType INT = (SELECT MIN(entityType) FROM #GrowthAndTranding_tmp__ConfigAggDetails)
WHILE @currentConfigEntityType IS NOT NULL BEGIN
    DECLARE @totalGrowthRate   FLOAT = 0
    DECLARE @addedGrowthRate   FLOAT = 0
    DECLARE @deletedGrowthRate FLOAT = 0
    IF @maxRealPeriodId > 1 BEGIN
        -- calculate running average
        DECLARE @currentConfigPeriodId  INT = 2
        DECLARE @previousTotal	 BIGINT = ISNULL((SELECT total FROM #GrowthAndTranding_tmp__ConfigAggDetails WHERE entityType = @currentConfigEntityType AND periodId = @currentConfigPeriodId - 1), 0)
        DECLARE @currentTotal	 BIGINT = ISNULL((SELECT total FROM #GrowthAndTranding_tmp__ConfigAggDetails WHERE entityType = @currentConfigEntityType AND periodId = @currentConfigPeriodId), 0)
        DECLARE @previousAdded	 BIGINT = ISNULL((SELECT added FROM #GrowthAndTranding_tmp__ConfigAggDetails WHERE entityType = @currentConfigEntityType AND periodId = @currentConfigPeriodId - 1), 0)
        DECLARE @currentAdded	 BIGINT = ISNULL((SELECT added FROM #GrowthAndTranding_tmp__ConfigAggDetails WHERE entityType = @currentConfigEntityType AND periodId = @currentConfigPeriodId), 0)
        DECLARE @previousDeleted BIGINT = ISNULL((SELECT deleted FROM #GrowthAndTranding_tmp__ConfigAggDetails WHERE entityType = @currentConfigEntityType AND periodId = @currentConfigPeriodId - 1), 0)
        DECLARE @currentDeleted  BIGINT = ISNULL((SELECT deleted FROM #GrowthAndTranding_tmp__ConfigAggDetails WHERE entityType = @currentConfigEntityType AND periodId = @currentConfigPeriodId), 0)
		WHILE (@currentTotal IS NOT NULL) AND (@currentAdded IS NOT NULL) AND (@currentDeleted IS NOT NULL) BEGIN
			SET @totalGrowthRate   = @totalGrowthRate   + CAST((@currentTotal   - @previousTotal) AS FLOAT)
			SET @addedGrowthRate   = @addedGrowthRate   + CAST((@currentAdded   - @previousAdded) AS FLOAT)
			SET @deletedGrowthRate = @deletedGrowthRate + CAST((@currentDeleted - @previousDeleted) AS FLOAT)
			SET @currentConfigPeriodId = @currentConfigPeriodId + 1
			SET @previousTotal   = @currentTotal
			SET @previousAdded   = @currentAdded
			SET @previousDeleted = @currentDeleted
			SET @currentTotal   = NULL
			SET @currentAdded   = NULL
			SET @currentDeleted = NULL
			SELECT	@currentTotal   = total,
					@currentAdded   = added,
					@currentDeleted = deleted
			FROM	#GrowthAndTranding_tmp__ConfigAggDetails CAG INNER JOIN #GrowthAndTranding_tmp__Periods P ON P.periodId = CAG.periodId
			WHERE		entityType = @currentConfigEntityType
					AND CAG.periodId = @currentConfigPeriodId
					AND P.predicted = 0
		END
		SET @totalGrowthRate   = @totalGrowthRate   / (@maxRealPeriodId - 1)
		SET @addedGrowthRate   = @addedGrowthRate   / (@maxRealPeriodId - 1)
		SET @deletedGrowthRate = @deletedGrowthRate / (@maxRealPeriodId - 1)
    END ELSE BEGIN
		SELECT	@totalGrowthRate   = CAST(total AS FLOAT),
				@addedGrowthRate   = CAST(added AS FLOAT),
				@deletedGrowthRate = CAST(deleted AS FLOAT)
		FROM	#GrowthAndTranding_tmp__ConfigAggDetails
		WHERE	entityType = @currentConfigEntityType AND periodId = 1
    END
    UPDATE  #GrowthAndTranding_tmp__ConfigAggDetails
    SET     total   =  ( SELECT (total   + (P.periodId - @maxRealPeriodId) * @totalGrowthRate)   FROM #GrowthAndTranding_tmp__ConfigAggDetails WHERE entityType = @currentConfigEntityType AND periodId = (@maxRealPeriodId)),
			added   =  ( SELECT (added   + (P.periodId - @maxRealPeriodId) * @addedGrowthRate)   FROM #GrowthAndTranding_tmp__ConfigAggDetails WHERE entityType = @currentConfigEntityType AND periodId = (@maxRealPeriodId)),
			deleted =  ( SELECT (deleted + (P.periodId - @maxRealPeriodId) * @deletedGrowthRate) FROM #GrowthAndTranding_tmp__ConfigAggDetails WHERE entityType = @currentConfigEntityType AND periodId = (@maxRealPeriodId))
    FROM    #GrowthAndTranding_tmp__ConfigAggDetails CAG INNER JOIN #GrowthAndTranding_tmp__Periods P ON P.periodId = CAG.periodId
    WHERE   CAG.entityType = @currentConfigEntityType AND P.predicted = 1
    -- next entity type
    SELECT  @currentConfigEntityType = MIN(entityType)
    FROM    #GrowthAndTranding_tmp__ConfigAggDetails
    WHERE   entityType > @currentConfigEntityType
END
-- -- -- jobs
DECLARE @currentJobTypeId INT = (SELECT MIN(jobTypeId) FROM #GrowthAndTranding_tmp__JobsAggDetails)
WHILE @currentJobTypeId IS NOT NULL BEGIN
	DECLARE @currentEntityId INT = (SELECT MIN(entityId) FROM #GrowthAndTranding_tmp__JobsAggDetails WHERE jobTypeId = @currentJobTypeId)
	WHILE @currentEntityId IS NOT NULL BEGIN
		DECLARE @growthRate1 FLOAT = 0
		DECLARE @growthRate2 FLOAT = 0
		DECLARE @growthRate3 FLOAT = 0
		DECLARE @growthRate4 FLOAT = 0
		DECLARE @growthRate5 FLOAT = 0
		DECLARE @growthRate6 FLOAT = 0
		IF @maxRealPeriodId > 1 BEGIN
			SET @currentPeriodId = 2
			DECLARE @previous1 BIGINT = 0
			DECLARE @current1  BIGINT = 0
			DECLARE @previous2 BIGINT = 0
			DECLARE @current2  BIGINT = 0
			DECLARE @previous3 BIGINT = 0
			DECLARE @current3  BIGINT = 0
			DECLARE @previous4 BIGINT = 0
			DECLARE @current4  BIGINT = 0
			DECLARE @previous5 BIGINT = 0
			DECLARE @current5  BIGINT = 0
			DECLARE @previous6 BIGINT = 0
			DECLARE @current6  BIGINT = 0
			SELECT	@previous1 = totalJobs,
					@previous2 = totalAppSize,
					@previous3 = totalDataWritten,
					@previous4 = totalProtectedObjects,
					@previous5 = totalFailedObjects,
					@previous6 = totalFailedFolders
			FROM	#GrowthAndTranding_tmp__JobsAggDetails WHERE jobTypeId = @currentJobTypeId AND entityId = @currentEntityId AND periodId = (@currentPeriodId - 1)
			SELECT	@current1 = totalJobs,
					@current2 = totalAppSize,
					@current3 = totalDataWritten,
					@current4 = totalProtectedObjects,
					@current5 = totalFailedObjects,
					@current6 = totalFailedFolders
			FROM	#GrowthAndTranding_tmp__JobsAggDetails WHERE jobTypeId = @currentJobTypeId AND entityId = @currentEntityId AND periodId = (@currentPeriodId)
			WHILE (@current1 IS NOT NULL) AND (@current2 IS NOT NULL) AND (@current3 IS NOT NULL) AND (@current4 IS NOT NULL) AND (@current5 IS NOT NULL) AND (@current6 IS NOT NULL) BEGIN
				SET @growthRate1 =  @growthRate1 + CAST((@current1 - @previous1) AS FLOAT)
				SET @growthRate2 =  @growthRate2 + CAST((@current2 - @previous2) AS FLOAT)
				SET @growthRate3 =  @growthRate3 + CAST((@current3 - @previous3) AS FLOAT)
				SET @growthRate4 =  @growthRate4 + CAST((@current4 - @previous4) AS FLOAT)
				SET @growthRate5 =  @growthRate5 + CAST((@current5 - @previous5) AS FLOAT)
				SET @growthRate6 =  @growthRate6 + CAST((@current6 - @previous6) AS FLOAT)
				SET @currentPeriodId = @currentPeriodId + 1
				SET @previous1 = @current1
				SET @previous2 = @current2
				SET @previous3 = @current3
				SET @previous4 = @current4
				SET @previous5 = @current5
				SET @previous6 = @current6
				SET @current1 = NULL
				SET @current2 = NULL
				SET @current3 = NULL
				SET @current4 = NULL
				SET @current5 = NULL
				SET @current6 = NULL
				SELECT	@current1 = totalJobs,
						@current2 = totalAppSize,
						@current3 = totalDataWritten,
						@current4 = totalProtectedObjects,
						@current5 = totalFailedObjects,
						@current6 = totalFailedFolders
				FROM	#GrowthAndTranding_tmp__JobsAggDetails WHERE jobTypeId = @currentJobTypeId AND entityId = @currentEntityId AND periodId = (@currentPeriodId)
			END
			SET @growthRate1   = @growthRate1   / (@maxRealPeriodId - 1)
			SET @growthRate2   = @growthRate2   / (@maxRealPeriodId - 1)
			SET @growthRate3   = @growthRate3   / (@maxRealPeriodId - 1)
			SET @growthRate4   = @growthRate4   / (@maxRealPeriodId - 1)
			SET @growthRate5   = @growthRate5   / (@maxRealPeriodId - 1)
			SET @growthRate6   = @growthRate6   / (@maxRealPeriodId - 1)
		END
		ELSE BEGIN
			SELECT	@growthRate1 = totalJobs,
					@growthRate1 = totalAppSize,
					@growthRate1 = totalDataWritten,
					@growthRate1 = totalProtectedObjects,
					@growthRate1 = totalFailedObjects,
					@growthRate1 = totalFailedFolders
			FROM	#GrowthAndTranding_tmp__JobsAggDetails WHERE jobTypeId = @currentJobTypeId AND entityId = @currentEntityId AND periodId = 1
		END
		UPDATE #GrowthAndTranding_tmp__JobsAggDetails
		SET		totalJobs			  = (SELECT (totalJobs + (P.periodId - @maxRealPeriodId) * @growthRate1)
									     FROM #GrowthAndTranding_tmp__JobsAggDetails
										 WHERE entityId = @currentEntityId AND jobTypeId = @currentJobTypeId AND periodId = (@maxRealPeriodId)),
				totalAppSize          =	(SELECT (totalAppSize + (P.periodId - @maxRealPeriodId) * @growthRate2)
									     FROM #GrowthAndTranding_tmp__JobsAggDetails
										 WHERE entityId = @currentEntityId AND jobTypeId = @currentJobTypeId AND periodId = (@maxRealPeriodId)),
				totalDataWritten	  = (SELECT (totalDataWritten + (P.periodId - @maxRealPeriodId) * @growthRate3)
									     FROM #GrowthAndTranding_tmp__JobsAggDetails
										 WHERE entityId = @currentEntityId AND jobTypeId = @currentJobTypeId AND periodId = (@maxRealPeriodId)),
				totalProtectedObjects = (SELECT (totalProtectedObjects + (P.periodId - @maxRealPeriodId) * @growthRate4)
									     FROM #GrowthAndTranding_tmp__JobsAggDetails
										 WHERE entityId = @currentEntityId AND jobTypeId = @currentJobTypeId AND periodId = (@maxRealPeriodId)),
				totalFailedObjects    = (SELECT (totalFailedObjects + (P.periodId - @maxRealPeriodId) * @growthRate5)
									     FROM #GrowthAndTranding_tmp__JobsAggDetails
										 WHERE entityId = @currentEntityId AND jobTypeId = @currentJobTypeId AND periodId = (@maxRealPeriodId)),
				totalFailedFolders    = (SELECT (totalFailedFolders + (P.periodId - @maxRealPeriodId) * @growthRate6)
									     FROM #GrowthAndTranding_tmp__JobsAggDetails
										 WHERE entityId = @currentEntityId AND jobTypeId = @currentJobTypeId AND periodId = (@maxRealPeriodId))
		FROM    #GrowthAndTranding_tmp__JobsAggDetails JAG INNER JOIN #GrowthAndTranding_tmp__Periods P ON P.periodId = JAG.periodId
		WHERE		P.predicted = 1
				AND	jobTypeId = @currentJobTypeId
				AND entityId  = @currentEntityId
		SELECT @currentEntityId = MIN(entityId) FROM #GrowthAndTranding_tmp__JobsAggDetails WHERE jobTypeId = @currentJobTypeId AND entityId > @currentEntityId
	END
	SELECT @currentJobTypeId = MIN(jobTypeId) FROM #GrowthAndTranding_tmp__JobsAggDetails WHERE jobTypeId > @currentJobTypeId
END
IF @stats <> 0 INSERT INTO #GrowthAndTranding_tmp__Stats VALUES('prediction', datediff(millisecond, @statsTempTime, GetDate()))
IF @debug <> 0 SELECT 'prediction', * FROM #GrowthAndTranding_tmp__PredictedData
-- get MiniBrandId for CommCell brand name
DECLARE	@l_MiniBrandId	INT
SELECT	@l_MiniBrandId = CAST(value AS INT) FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'MiniBrandId' AND modified = 0
IF @l_MiniBrandId IS NULL
	SET @l_MiniBrandId = (SELECT TOP 1 OemId FROM LicCsl WITH (NOLOCK) ORDER BY id DESC)
-- generate XML message
SELECT
	@CapacityAsOf						AS '@capacityAsOf',
    (SELECT @timeFrameType              AS '@timeFrameType',
            @frequency                  AS '@frequency',
            @numberOfPeriods            AS '@numberOfPeriods',
            @reqStartTime               AS '@startTime',
            @reqEndTime                 AS '@endTime',
            @includeCurrentPeriod       AS '@includeCurrentPeriod',
            @treatWeekend               AS '@treatWeekend',
            @predictionSteps            AS '@numberOfPredictionSteps',
            @reportDataType             AS '@reportDataType',
            @detailsOnlyRequest         AS '@detailsOnlyRequest',
            @pageSize                   AS '@pageSize',
            @pageNo                     AS '@pageNo',
            @detailsSortColumnNo        AS '@detailsSortColumnNo',
            @sortOrder                  AS '@jobsSortOrder',
            @userId                     AS '@userId',
            @localeId                   AS '@localeId'
     FOR    XML PATH('request'),TYPE),
    (SELECT aliasName					AS '@commCellName',
            REPLACE(LTRIM(REPLACE(SUBSTRING(master.sys.fn_varbintohexstr(CONVERT(VARBINARY(8), number)), 3, 8), '0', ' ')), ' ', '0')
										AS '@commCellID',
            ipAddress                   AS '@commServeIP',
            (SELECT name FROM SimMiniBrand WITH (NOLOCK) WHERE MiniBrandId = @l_MiniBrandId)
							            AS '@edition',
            CASE ccOpMode WHEN 1000 THEN 'Evaluation' WHEN 1002 THEN 'Production' WHEN 1004 THEN 'DR Production' ELSE 'Unknown' END
							            AS '@licenseMode'
	 FROM	APP_CommCell WITH (NOLOCK)
	 WHERE	id = 2
     FOR    XML PATH('ccInfo'),TYPE),
    (SELECT PD.entityType               AS '@entityType',
			PD.maxEntityValue			AS '@maxEntityValue',
            PD.growthRate               AS '@growthRate',
            (SELECT P.periodId          AS '@periodId',
                    P.periodStart       AS '@dateStart',
                    P.periodEnd         AS '@dateEnd',
                    P.predicted         AS '@isPredicted',
                    CASE WHEN HD.value > 0 THEN HD.value ELSE 0 END
										AS '@entityValue',
                    HD.doNotPlot		AS '@doNotPlot',
                    (SELECT	CASE WHEN CAG.total > 0	THEN CAG.total ELSE 0 END		AS '@total',
							CASE WHEN CAG.added	> 0 THEN CAG.added ELSE 0 END		AS '@added',
							CASE WHEN CAG.deleted > 0 THEN CAG.deleted ELSE 0 END	AS '@deleted'
                     FROM	#GrowthAndTranding_tmp__ConfigAggDetails CAG
                     WHERE		CAG.periodId = P.periodId
							AND CAG.entityType = PD.entityType
                     FOR    XML PATH('detailsOther'),TYPE),
					 (SELECT
						(SELECT
							(SELECT	JAD.entityId	AS '@entityId',
									JAD.entityName	AS '@entityName',
									CASE WHEN JAD.totalJobs > 0 THEN JAD.totalJobs
										ELSE 0 END	AS '@totalJobs',
									CASE WHEN JAD.totalAppSize > 0 THEN JAD.totalAppSize
										ELSE 0 END	AS '@totalAppSize',
									CASE WHEN JAD.totalDataWritten > 0 THEN JAD.totalDataWritten
										ELSE 0 END	AS '@totalDataWritten',
									CASE WHEN JAD.totalProtectedObjects > 0 THEN JAD.totalProtectedObjects
										ELSE 0 END	AS '@totalProtectedObjects',
									CASE WHEN JAD.totalFailedObjects > 0 THEN JAD.totalFailedObjects
										ELSE 0 END	AS '@totalFailedObjects',
									CASE WHEN JAD.totalFailedFolders > 0 THEN JAD.totalFailedFolders
										ELSE 0 END	AS '@totalFailedFolders'
							 FROM	#GrowthAndTranding_tmp__JobsAggDetails JAD
							 WHERE	JAD.periodId = P.periodId AND JAD.jobTypeId = HD.entityType
							 FOR    XML PATH('entities'),TYPE)
						 FOR    XML PATH('aggregate'),TYPE)
					 FOR    XML PATH('detailsStatus'),TYPE)
             FROM   #GrowthAndTranding_tmp__HistoryData HD INNER JOIN     #GrowthAndTranding_tmp__Periods P ON P.periodId = HD.periodId
                                                                      AND HD.entityType = PD.entityType
             FOR    XML PATH('details'),TYPE)
     FROM   #GrowthAndTranding_tmp__PredictedData PD
     WHERE	PD.entityType NOT IN ( @const_AGG_JOBS_SUCCESS,
								   @const_AGG_JOBS_SUCCESS_ERR,
								   @const_AGG_JOBS_SUCCESS_WRN,
								   @const_AGG_JOBS_FAILED,
								   @const_AGG_JOBS_KILLED,
								   @const_AGG_JOBS_NORUN,
								   @const_AGG_JOBS_TOTAL,
								   @const_AGG_CLIENT_NEW,
								   @const_AGG_CLIENT_DELETED,
								   @const_AGG_AGENT_NEW,
								   @const_AGG_AGENT_DELETED,
								   @const_AGG_VM_NEW,
								   @const_AGG_VM_DELETED)
     FOR    XML PATH('details'),TYPE)
FOR XML PATH ('WebReport_CommCellGrowthResp')
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__Stats')            IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__Stats
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__PeriodsRaw')       IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__PeriodsRaw
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__Periods')          IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__Periods
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__Jobs')             IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__Jobs
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__HistoryData')      IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__HistoryData
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__PredictedData')    IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__PredictedData
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__JobsAggDetails')   IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__JobsAggDetails
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__JobsList')			IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__JobsList
IF OBJECT_ID('tempdb.dbo.#GrowthAndTranding_tmp__ConfigAggDetails')	IS NOT NULL DROP TABLE #GrowthAndTranding_tmp__ConfigAggDetails
GO

IF EXISTS (select * from GxQscripts where name = 'wr_CommCellGrowth')
	delete from GxQscripts where name = 'wr_CommCellGrowth'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_CommCellGrowth')
	delete from GXDBVersions where aliasname = 'wr_CommCellGrowth'
GO

insert into GXDBVersions values(2, 'wr_CommCellGrowth',  '00010022000000000000', 'wr_CommCellGrowth', '00010022000000000000')
GO

