

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_CheckCloudUserCapability.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_CheckCloudUserCapability <<<'

IF EXISTS (select * from sysobjects where name='wr_CheckCloudUserCapability')
	drop procedure wr_CheckCloudUserCapability
IF EXISTS (select * from GxQscripts where name='wr_CheckCloudUserCapability')
	delete from GxQscripts where name = 'wr_CheckCloudUserCapability'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_CheckCloudUserCapability')
	delete from GXDBVersions where aliasname = 'wr_CheckCloudUserCapability'
GO
print '... Creating Procedure: wr_CheckCloudUserCapability'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_CheckCloudUserCapability
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @request XML
AS
  DECLARE @response xml
BEGIN
SET NOCOUNT ON
DECLARE @errorString NVARCHAR(MAX) =''
DECLARE @errorCode INT  =0
DECLARE @User INT = 0, @isAdmin INT = 0
BEGIN TRY
	SELECT
		@User=ReqInfo.value('(user/@userId)[1]', 'integer')
	From @request.nodes('WebReport_CheckCloudUserCapabilityReq ') ReqInfo(ReqInfo)
declare @USER_MANAGMENT_USER_MANAGEMENT INT =101
	IF OBJECT_ID('tempdb.dbo.#getUserGroupsForThisUserTable1') IS NOT NULL
		DROP TABLE #getUserGroupsForThisUserTable1
	CREATE TABLE #getUserGroupsForThisUserTable1
		(
			userGroupId INT
		)
EXEC sec_getNonIdaObjectsForThisUser @User, 15, @USER_MANAGMENT_USER_MANAGEMENT, '#getUserGroupsForThisUserTable1'
	--Table to store user groups having 'user management association on entity' capability at any user group
declare @USER_MANAGMENT_ASSOC_ON_ENTITY INT =107
	IF OBJECT_ID('tempdb.dbo.#getUserGroupsForThisUserTable2') IS NOT NULL
		DROP TABLE #getUserGroupsForThisUserTable2
	CREATE TABLE #getUserGroupsForThisUserTable2
		(
			userGroupId INT
		)
EXEC sec_getNonIdaObjectsForThisUser @User, 15, @USER_MANAGMENT_ASSOC_ON_ENTITY, '#getUserGroupsForThisUserTable2'
	IF EXISTS (SELECT * FROM #getUserGroupsForThisUserTable1 t1 INNER JOIN #getUserGroupsForThisUserTable2 t2 ON	t1.userGroupId =t2.userGroupId
	INNER JOIN UMGroups (NOLOCK) ug	ON
((ug.description LIKE '%CREATEd by CommCell Registration Workflow%') OR exists(select * from UMGroupsProp where attrName =  'Customer User Group'
			AND  componentNameId =  ug.id and modified =0)))
		SET @isAdmin = 1
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorString = 'Expection while processing xml request for  ' + cast( @User as varchar(max)) + ' user !'
	SET @errorCode =1
	GOTO ErrorMsg
END CATCH
ErrorMsg:
IF object_id('tempdb.dbo.#getUserGroupsForThisUserTable1') is not null
DROP TABLE #getUserGroupsForThisUserTable1
IF object_id('tempdb.dbo.#getUserGroupsForThisUserTable2') is not null
DROP TABLE #getUserGroupsForThisUserTable2
SET NOCOUNT OFF
CX_ERROR_EXIT:
SET @response = (SELECT @errorCode as '@errorCode' , @errorString as '@errorMessage' FOR XML PATH('msg')    )
SET @response = (select @isAdmin as '@isCloudAdmin',@response FOR XML PATH('WebReport_CheckCloudUserCapabilityResp')    )
SELECT @response
END
GO

IF EXISTS (select * from GxQscripts where name = 'wr_CheckCloudUserCapability')
	delete from GxQscripts where name = 'wr_CheckCloudUserCapability'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_CheckCloudUserCapability')
	delete from GXDBVersions where aliasname = 'wr_CheckCloudUserCapability'
GO

insert into GXDBVersions values(2, 'wr_CheckCloudUserCapability',  '00010001000200050000', 'wr_CheckCloudUserCapability', '00010001000200050000')
GO

