

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_CellSelection.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/wr_CellSelection.sp,v $ $Id: wr_CellSelection.sp,v 1.5 2014/05/12 06:29:44 dkraplanee Exp $";
-- -----------------------------------------------------------------------------------------------------------
-- Author:      Eugene Volohov
-- Create date: 08/11/2010
-- Description: returns list of entities (down to iDA level) which are falling in conditions specified by
--              xmlSelection
-- Parameters : xmlSelection            [input]  [ntext]    : set of rules that will defined which entities
--                                                            will be returned
--              outputTableName         [input]  [sysname]  : name of already existing table that will hold
--                                                            selected entities
--              includeLogDeletedClients[input]  [int]      : flag that dictates inclusion of deleted entities
-- -----------------------------------------------------------------------------------------------------------
-- ----------------------------------------------------------
-- $Log: wr_CellSelection.sp,v $
-- Revision 1.3  2010/09/03 14:15:50  evolohov
-- rcid has been added.
--
-- Revision 1.2  2010/09/03 14:06:36  evolohov
-- Build break fixed.
-- SYSNAME is unknown SQL type for code generator. Changed to VARCHAR(128)
--
-- Revision 1.1  2010/09/02 18:15:08  evolohov
-- WEB Reporting support.
-- returns list of entities (down to iDA level) which are falling in conditions specified by a parameter.
-- Initial commit.
--
--
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_CellSelection <<<'

IF EXISTS (select * from sysobjects where name='wr_CellSelection')
	drop procedure wr_CellSelection
IF EXISTS (select * from GxQscripts where name='wr_CellSelection')
	delete from GxQscripts where name = 'wr_CellSelection'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_CellSelection')
	delete from GXDBVersions where aliasname = 'wr_CellSelection'
GO
print '... Creating Procedure: wr_CellSelection'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure wr_CellSelection
  @xmlSelection NTEXT,
  @outputTableName VARCHAR(128),
  @includeLogDeletedClients INT             = 1,
  @rootTag NVARCHAR(64)    = N'tree',
  @debug INT             = 0,
  @stats INT             = 0
AS
    SET NOCOUNT ON
-- DECLARE @xmlSelection               NVARCHAR(MAX)
-- DECLARE @outputTableName            SYSNAME
-- DECLARE @includeLogDeletedClients   INT             = 1
-- DECLARE @rootTag                    NVARCHAR(64)    = N'tree'
-- DECLARE @debug                      INT             = 0
-- DECLARE @stats                      INT             = 0
DECLARE @statsTime      DATETIME
DECLARE @statsTimeTotal DATETIME
DECLARE @idoc           INT
IF OBJECT_ID('tempdb.dbo.#SEL_Client') IS NOT null DROP TABLE #SEL_Client
IF OBJECT_ID('tempdb.dbo.#CC_Selection') IS NOT null DROP TABLE #CC_Selection
CREATE TABLE #CC_Selection
(
    SelectionType       int         NULL, -- Type of selection
                                          --  -- 1 - All commcells. All data from APP_Application table
                                          --  -- 2 - Individual commcell. Filter by origCCId on APP_Application table
                                          --  -- 3 - all client groups - All clients from all client groups for specified commcell.
                                          --  -- 4 - all clients for specified client group
                                          --  -- 5 - CC Client
    CommCellID          int         NULL, -- must be set for SelectionType in (2,3,4,5)
    ClientGroupID       int         NULL, -- must be set for SelectionType in (4)
    ClientID            int         NULL  -- must be set for SelectionType in (5)
)
CREATE TABLE #SEL_Client
(
    CommCellId          INT                 NULL,
    CommCellName        NVARCHAR(1024)      NULL,
    ClientGroupId       INT                 NULL,
    ClientGroupName     NVARCHAR(1024)      NULL,
    ClientID            INT                 NULL,
    ClientName          NVARCHAR(1024)      NULL,
    AppTypeID           INT                 NULL,
    Uninstalled         INT                 NULL
)
IF @stats <> 0 BEGIN
    SET NOCOUNT         OFF
    SET STATISTICS IO   ON
    SET STATISTICS TIME ON
    CREATE TABLE #SEL_Stats
    (
        [type]              VARCHAR(50),
        operationTime       INT,
        totalTime           INT
    )
    SET @statsTimeTotal = GETDATE()
END
IF @debug <> 0 BEGIN
    CREATE TABLE #SEL_ClientOut
    (
        CommCellId          INT                 NULL,
        CommCellName        NVARCHAR(1024)      NULL,
        ClientGroupId       INT                 NULL,
        ClientGroupName     NVARCHAR(1024)      NULL,
        ClientID            INT                 NULL,
        ClientName          NVARCHAR(1024)      NULL,
        AppTypeID           INT                 NULL,
        Uninstalled         INT                 NULL
    )
    SET @outputTableName = '#SEL_ClientOut'
END
-- prepare document
IF @stats <> 0 SET @statsTime = GetDate()
EXEC sp_xml_preparedocument @idoc OUTPUT, @xmlSelection
IF @stats <> 0  INSERT INTO #SEL_Stats VALUES ('XML Prepare', datediff(millisecond, @statsTime, GetDate()), datediff(millisecond, @statsTimeTotal, GetDate()) )
DECLARE @rowPattern NVARCHAR(64) = '//' + @rootTag + '/entity'
-- query information from xml into temporary table
-- -- statistics : start
IF @stats <> 0 SET @statsTime = GetDate()
INSERT INTO #CC_Selection
    SELECT  SelectionType, CommCellID, ClientGroupID, ClientID
    FROM    OPENXML(@idoc, @rowPattern, 0)
            WITH(
                    SelectionType   INT     '@selectionType',
                    CommCellID      INT     '@commCellId',
                    ClientGroupID   INT     '@clientGroupId',
                    ClientID        INT     '@clientId'
                ) AS C
-- -- statistics : end
IF @stats <> 0 INSERT INTO #SEL_Stats VALUES ('XML query', datediff(millisecond, @statsTime, GetDate()), datediff(millisecond, @statsTimeTotal, GetDate()) )
-- -- debug
IF @debug <> 0 SELECT TableName='#CC_Selection', * FROM #CC_Selection
EXEC sp_xml_removedocument @idoc
-- select clients according to data from #CC_Selection
-- According to Anand Vibhor, the only flag that we have to check to determine if client was deleted/uninstalled is [status]
-- if 2nd bit is set that means client was unistalled. When clients gets uninstalled, corresponded subclients are getting
-- marked as unistalled too by setting 2nd bit in subclientStatus column in APP_Application table
-- -- statistics : start
IF @stats <> 0 SET @statsTime = GetDate()
IF EXISTS (SELECT * FROM #CC_Selection S WHERE S.SelectionType = 1) BEGIN
    INSERT INTO #SEL_Client
        SELECT  DISTINCT A.origCCId, NULL, 0, N'', A.clientId, NULL, A.appTypeId,
                CASE WHEN A.subclientStatus & 0x2 = 0 AND A.subclientStatus & 0x4 = 0 THEN 0 ELSE 1 END
        FROM    APP_Application A
END ELSE BEGIN
    INSERT INTO #SEL_Client
        -- Select all clients for those comcells which have 'include_all' set.
        SELECT  DISTINCT A.origCCId, NULL, 0, N'', A.clientId, NULL, A.appTypeId,
                CASE WHEN A.subclientStatus & 0x2 = 0 AND A.subclientStatus & 0x4 = 0 THEN 0 ELSE 1 END
        FROM    APP_Application A INNER JOIN #CC_Selection S ON A.origCCId = S.CommCellID
        WHERE   S.SelectionType = 2
        UNION -- select all clients from all client groups which have 'include_all' flag set at commcell level
              -- if client group that belongs to a commcell includes client from another commcell then that client
              -- will be included also
        SELECT  DISTINCT A.origCCId, NULL, CGA.clientGroupId, NULL, A.clientId, NULL, A.appTypeId,
                CASE WHEN A.subclientStatus & 0x2 = 0 AND A.subclientStatus & 0x4 = 0 THEN 0 ELSE 1 END
        FROM	APP_Application A INNER JOIN APP_ClientGroupAssoc CGA ON A.clientId = CGA.clientId
        WHERE	CGA.clientGroupId IN ( SELECT DISTINCT clientGroupId
							           FROM   APP_ClientGroupAssoc CGA2 INNER JOIN APP_Client C ON CGA2.clientId = C.id
							           WHERE  C.origCCId IN (SELECT  DISTINCT CommCellId
                                                             FROM    #CC_Selection
                                                             WHERE   SelectionType = 3) )
        UNION -- select all clients for selected groups
        SELECT  DISTINCT A.origCCId, NULL, CGA.clientGroupId, NULL, A.clientId, NULL, A.appTypeId,
                CASE WHEN A.subclientStatus & 0x2 = 0 AND A.subclientStatus & 0x4 = 0 THEN 0 ELSE 1 END
        FROM	APP_Application A INNER JOIN APP_ClientGroupAssoc CGA ON A.clientId = CGA.clientId
        WHERE	CGA.clientGroupId IN ( SELECT  DISTINCT ClientGroupId
                                       FROM    #CC_Selection
                                       WHERE   SelectionType = 4 )
        UNION -- select specified clients
        SELECT  DISTINCT A.origCCId, NULL, 0, N'', A.clientId, NULL, A.appTypeId,
                CASE WHEN A.subclientStatus & 0x2 = 0 AND A.subclientStatus & 0x4 = 0 THEN 0 ELSE 1 END
        FROM    APP_Application A INNER JOIN #CC_Selection S ON A.origCCId = S.CommCellID
        WHERE       S.SelectionType = 5
                AND A.clientId = S.clientId
END
-- -- statistics : end
IF @stats <> 0 INSERT INTO #SEL_Stats VALUES ('Client selection', datediff(millisecond, @statsTime, GetDate()), datediff(millisecond, @statsTimeTotal, GetDate()) )
-- -- debug
IF @debug <> 0 SELECT TableName='#SEL_Client', * FROM #SEL_Client
-- if deleted clients were not requested then delete them from the list of clients before returning data to caller
-- -- statistics : start
IF @stats <> 0 SET @statsTime = GetDate()
IF  @includeLogDeletedClients = 0
    DELETE FROM #SEL_Client WHERE Uninstalled <> 0
-- -- statistics : end
IF @stats <> 0 INSERT INTO #SEL_Stats VALUES ('Log deleted clients', datediff(millisecond, @statsTime, GetDate()), datediff(millisecond, @statsTimeTotal, GetDate()) )
-- -- debug
IF (@debug <> 0) AND (@includeLogDeletedClients = 0) SELECT TableName='#SEL_Client log deleted', * FROM #SEL_Client
-- if subclient for the app type is not report-worthy then delete id
-- -- statistics : start
IF @stats <> 0 SET @statsTime = GetDate()
DELETE  FROM #SEL_Client
WHERE       (AppTypeID <> 0)
        AND (dbo.IsSubClientValid(AppTypeID, 0, 1) = 0)
-- -- statistics : end
IF @stats <> 0 INSERT INTO #SEL_Stats VALUES ('Invalid subclients', datediff(millisecond, @statsTime, GetDate()), datediff(millisecond, @statsTimeTotal, GetDate()) )
-- -- debug
IF @debug <> 0 SELECT TableName='#SEL_Client invalid subclients', * FROM #SEL_Client
-- update selected copmmcells/client names and guids
-- -- statistics : start
IF @stats <> 0 SET @statsTime = GetDate()
UPDATE  #SEL_Client SET CommCellName = CC.aliasName, ClientName = CL.name
FROM    APP_Client CL INNER JOIN APP_CommCell CC ON CL.origCCId = CC.id
WHERE       #SEL_Client.CommCellId = CL.origCCId
        AND #SEL_Client.ClientID = CL.id
UPDATE  #SEL_Client SET ClientGroupName  = CG.name
FROM	APP_ClientGroup CG
WHERE	CG.id = ClientGroupId
-- -- statistics : end
IF @stats <> 0 INSERT INTO #SEL_Stats VALUES ('Client update', datediff(millisecond, @statsTime, GetDate()), datediff(millisecond, @statsTimeTotal, GetDate()) )
IF @debug <> 0 SELECT TableName='#SEL_Client updated', * FROM #SEL_Client
-- move data into output table
-- -- statistics : start
IF @stats <> 0 SET @statsTime = GetDate()
EXEC( 'DELETE FROM ' + @outputTableName )
EXEC( 'INSERT INTO ' + @outputTableName + ' SELECT * FROM #SEL_Client' )
-- -- statistics : end
IF @stats <> 0 INSERT INTO #SEL_Stats VALUES ('Output', datediff(millisecond, @statsTime, GetDate()), datediff(millisecond, @statsTimeTotal, GetDate()) )
-- delete temporary tables
IF OBJECT_ID('tempdb.dbo.#SEL_Client') IS NOT null DROP TABLE #SEL_Client
IF OBJECT_ID('tempdb.dbo.#CC_Selection') IS NOT null DROP TABLE #CC_Selection
IF @stats <> 0 BEGIN
    SELECT * FROM #SEL_Stats
    DROP TABLE #SEL_Stats
END
IF @debug <> 0 BEGIN
    EXEC( 'DROP TABLE ' + @outputTableName )
END
GO

IF EXISTS (select * from GxQscripts where name = 'wr_CellSelection')
	delete from GxQscripts where name = 'wr_CellSelection'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_CellSelection')
	delete from GXDBVersions where aliasname = 'wr_CellSelection'
GO

insert into GXDBVersions values(2, 'wr_CellSelection',  '00010005000000000000', 'wr_CellSelection', '00010005000000000000')
GO

