

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_BuildDaysRangeForTimeZone.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/wr_BuildDaysRangeForTimeZone.sp,v $ $Id: wr_BuildDaysRangeForTimeZone.sp,v 1.7 2012/11/13 20:07:58 junlu Exp $";
-- +-----------------------------------------------------------------------+
-- | PROCEDURE: cn_BuildDaysRangeForTimeZone
-- +-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_BuildDaysRangeForTimeZone <<<'

IF EXISTS (select * from sysobjects where name='wr_BuildDaysRangeForTimeZone')
	drop procedure wr_BuildDaysRangeForTimeZone
IF EXISTS (select * from GxQscripts where name='wr_BuildDaysRangeForTimeZone')
	delete from GxQscripts where name = 'wr_BuildDaysRangeForTimeZone'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_BuildDaysRangeForTimeZone')
	delete from GXDBVersions where aliasname = 'wr_BuildDaysRangeForTimeZone'
GO
print '... Creating Procedure: wr_BuildDaysRangeForTimeZone'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure wr_BuildDaysRangeForTimeZone
  @OutTempTable varchar(64),
  @RequestTimeZone varchar(255),
  @RequestEndTime integer,
  @RequestFrequency integer,
  @RequestNumOfSteps integer,
  @PredictionSteps integer
AS
--+-+-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-+
--
--  BEGIN
--
--+-+-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-+
DECLARE @currStepBegin	DATETIME
DECLARE @currStepEnd	DATETIME
DECLARE @stepBegin		DATETIME
DECLARE @stepEnd		DATETIME
DECLARE @tempBeginDT	DATETIME
DECLARE @tempEndDT		DATETIME
DECLARE @tempBeginUT	INT
DECLARE @tempEndUT		INT
DECLARE @stepCounter	INT
IF OBJECT_ID('tempdb.dbo.#BDR_Steps') IS NOT null DROP TABLE #BDR_Steps
CREATE TABLE #BDR_Steps
(
    predicted		INT,
	stepBeginUnix	INT,
	stepEndUnix		INT,
    stepBegin		DATETIME,
    stepEnd			DATETIME,
    stepBeginLocal	DATETIME,
    stepEndLocal	DATETIME
)
-- Adjust @RequestEndTime
IF	@RequestTimeZone = ''
BEGIN
	SELECT	@RequestTimeZone = timezone FROM APP_CommCell WHERE id = 2
	SELECT	@RequestTimeZone = TimeZoneStdName FROM SchedTimeZone
	WHERE	TimeZoneName = SUBSTRING(@RequestTimeZone, CHARINDEX(':', @RequestTimeZone, CHARINDEX(':', @RequestTimeZone, 0) + 1) + 1, 255)
END
IF	@RequestEndTime > 0
	SET @currStepEnd = dbo.UTCToLocalTime(dbo.GetDateTime(@RequestEndTime), @RequestTimeZone)
ELSE
	SET @currStepEnd = GetDate()
IF @RequestFrequency = 1
	SET @currStepBegin = DATEADD(DD, DATEDIFF(DD, 0, @currStepEnd), 0)
ELSE IF @RequestFrequency = 2
	SET @currStepBegin = DATEADD(WK, DATEDIFF(WK, 0, @currStepEnd), 0)
ELSE IF @RequestFrequency = 3
	SET @currStepBegin = DATEADD(MM, DATEDIFF(MM, 0, @currStepEnd), 0)
ELSE IF @RequestFrequency = 4
	SET @currStepBegin = DATEADD(HH, DATEDIFF(HH, 0, @currStepEnd), 0)
ELSE IF @RequestFrequency = 6
	SET @currStepBegin = DATEADD(YY, DATEDIFF(YY, 0, @currStepEnd), 0)
-- Insert steps
SET @stepBegin	= @currStepBegin
SET @stepEnd	= @currStepEnd
SET @tempEndDT	= dbo.LocalToUTCTime(@stepEnd, @RequestTimeZone)
SET @tempEndUT	= dbo.GetUnixTime(@tempEndDT)
SET @stepCounter= @RequestNumOfSteps
WHILE (@stepCounter > 0)
BEGIN
	SET @tempBeginDT= dbo.LocalToUTCTime(@stepBegin, @RequestTimeZone)
	SET @tempBeginUT= dbo.GetUnixTime(@tempBeginDT)
	INSERT	INTO #BDR_Steps
	SELECT	0, @tempBeginUT, @tempEndUT-1, @tempBeginDT, DATEADD(SS, -1, @tempEndDT), @stepBegin, DATEADD(SS, -1, @stepEnd)
	SET @tempEndUT	= @tempBeginUT
	SET @tempEndDT	= @tempBeginDT
	SET @stepEnd	= @stepBegin
	SET	@stepCounter = (@stepCounter - 1)
	IF @RequestFrequency = 1
		SET @stepBegin = DATEADD(DD, -1, @stepBegin)
	ELSE IF @RequestFrequency = 2
		SET @stepBegin = DATEADD(WK, -1, @stepBegin)
	ELSE IF @RequestFrequency = 3
		SET @stepBegin = DATEADD(MM, -1, @stepBegin)
	ELSE IF @RequestFrequency = 4
		SET @stepBegin = DATEADD(HH, -1, @stepBegin)
	ELSE IF @RequestFrequency = 6
		SET @stepBegin = DATEADD(YY, -1, @stepBegin)
END
-- Insert prediction steps
SET @stepEnd	= @currStepBegin
SET @stepBegin	= DATEADD(SS, 1, @currStepEnd)
SET @tempBeginDT= dbo.LocalToUTCTime(@stepBegin, @RequestTimeZone)
SET @tempBeginUT= dbo.GetUnixTime(@tempBeginDT)
SET @stepCounter= @PredictionSteps
WHILE (@stepCounter > 0)
BEGIN
	IF @RequestFrequency = 1
		SET @stepEnd = DATEADD(DD, 1, @stepEnd)
	ELSE IF @RequestFrequency = 2
		SET @stepEnd = DATEADD(WK, 1, @stepEnd)
	ELSE IF @RequestFrequency = 3
		SET @stepEnd = DATEADD(MM, 1, @stepEnd)
	ELSE IF @RequestFrequency = 4
		SET @stepEnd = DATEADD(HH, 1, @stepEnd)
	ELSE IF @RequestFrequency = 6
		SET @stepEnd = DATEADD(YY, 1, @stepEnd)
	SET @tempEndDT = dbo.LocalToUTCTime(@stepEnd, @RequestTimeZone)
	SET @tempEndUT = dbo.GetUnixTime(@tempEndDT)
	INSERT	INTO #BDR_Steps
	SELECT	1, @tempBeginUT, @tempEndUT-1, @tempBeginDT, DATEADD(SS, -1, @tempEndDT), @stepBegin, DATEADD(SS, -1, @stepEnd)
	SET @tempBeginUT = @tempEndUT
	SET @tempBeginDT = @tempEndDT
	SET @stepBegin	 = @stepEnd
	SET	@stepCounter = (@stepCounter - 1)
END
IF	@OutTempTable = ''
	SELECT * FROM #BDR_Steps ORDER BY stepEndUnix
ELSE
	EXEC (  'INSERT INTO ' + @OutTempTable + ' SELECT * FROM #BDR_Steps' )
--+-+-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-+
--
--  END
--
--+-+-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-+
GO

IF EXISTS (select * from GxQscripts where name = 'wr_BuildDaysRangeForTimeZone')
	delete from GxQscripts where name = 'wr_BuildDaysRangeForTimeZone'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_BuildDaysRangeForTimeZone')
	delete from GXDBVersions where aliasname = 'wr_BuildDaysRangeForTimeZone'
GO

insert into GXDBVersions values(2, 'wr_BuildDaysRangeForTimeZone',  '00010007000000000000', 'wr_BuildDaysRangeForTimeZone', '00010007000000000000')
GO

