

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_BuildDaysRange.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/wr_BuildDaysRange.sp,v $ $Id: wr_BuildDaysRange.sp,v 1.13 2012/09/27 04:40:25 junlu Exp $";
-- +-----------------------------------------------------------------------+
-- | PROCEDURE: wr_BuildDaysRange
-- +-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_BuildDaysRange <<<'

IF EXISTS (select * from sysobjects where name='wr_BuildDaysRange')
	drop procedure wr_BuildDaysRange
IF EXISTS (select * from GxQscripts where name='wr_BuildDaysRange')
	delete from GxQscripts where name = 'wr_BuildDaysRange'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_BuildDaysRange')
	delete from GXDBVersions where aliasname = 'wr_BuildDaysRange'
GO
print '... Creating Procedure: wr_BuildDaysRange'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure wr_BuildDaysRange
  @CommCellId integer,
  @OutTempTable varchar(64),
  @RequestType integer,
  @RequestNumOfSteps integer,
  @RequestFrequency integer,
  @RequestStartTime integer,
  @RequestEndTime integer,
  @RequestTreatWeekend integer,
  @ActivityOrCoverage integer,
  @StartFromPreviousEnd integer,
  @HourFrequencyInMin integer,
  @PredictionSteps integer,
  @IncludeCurrentStep integer  = 0,
  @BackupFrom varchar(32)  = '18:00'
AS
--+-+-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-+
--
--  BEGIN
--
--+-+-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-+
-- DECLARE @CommCellId		        integer
-- DECLARE @OutTempTable		    varchar(64)
-- DECLARE @RequestType		        integer
-- DECLARE @RequestNumOfSteps	    integer
-- DECLARE @RequestFrequency	    integer
-- DECLARE @RequestStartTime	    integer
-- DECLARE @RequestEndTime		    integer
-- DECLARE @RequestTreatWeekend	    integer
-- DECLARE @ActivityOrCoverage	    integer
-- DECLARE @StartFromPreviousEnd	integer
-- DECLARE @HourFrequencyInMin	    integer
-- DECLARE @PredictionSteps	        integer
-- DECLARE @IncludeCurrentStep      integer
DECLARE @CurrentStart		datetime
DECLARE @CurrentEnd		    datetime
DECLARE @CurrentStep		datetime
DECLARE @CurrentStepBefPred	datetime
DECLARE @Predicted		    int
DECLARE @StatsTime		    datetime
DECLARE @DayNumber		    int
DECLARE @DayStart		    datetime
DECLARE @DayEnd			    datetime
DECLARE @DayRefStart		datetime
DECLARE @DayRefEnd		    datetime
DECLARE @DayNumberStr		varchar(16)
DECLARE @DayStartStr		varchar(32)
DECLARE @DayEndStr		    varchar(32)
DECLARE @DayRefStartStr		varchar(32)
DECLARE @DayRefEndStr		varchar(32)
DECLARE @WkDayEndTimeOffSet	int
DECLARE @WkEndEndTimeOffSet	int
DECLARE @DayRefStartLocal	datetime
DECLARE @DayRefEndLocal		datetime
DECLARE @Debug			    int
DECLARE @StatsTempTime		datetime
DECLARE @Stats		        int
DECLARE @DayStartLoop		datetime
DECLARE @DayNumLoop		    int
-- SET @CommCellId		        = 1
-- SET @OutTempTable		    = '#BDR_DaysTableTemp'
-- SET @RequestType		        = 1
-- SET @RequestNumOfSteps	    = 7
-- SET @RequestFrequency	    = 6 -- 1 - Daily, 2 - Weekly, 3 - Monthly, 4 - Hourly, 6 - Yearly
-- SET @RequestStartTime	    = dbo.GetUnixTime('2003-03-24 05:00:00.000')
-- SET @RequestEndTime		    = dbo.GetUnixTime('2003-04-07 04:00:00.000')
-- SET @RequestTreatWeekend	    = 1
-- SET @ActivityOrCoverage	    = 1
-- SET @StartFromPreviousEnd	= 1
-- SET @HourFrequencyInMin	    = 10
-- SET @PredictionSteps	        = 5
-- SET @IncludeCurrentStep	    = 1
DECLARE @currentStepAdj     INT = (CASE WHEN @IncludeCurrentStep > 0 THEN 0 ELSE 1 END)
SET @Debug	= 0
SET @Stats = 0
SET @DayNumber 	= 0
SET @CurrentStep 	= 0
SET @CurrentStepBefPred	= 0
-- ----------------------------------------------------------------------------
--   TEMPORARY TABLES
-- ----------------------------------------------------------------------------
IF OBJECT_ID('tempdb.dbo.#BDR_DaysTableTemp') IS NOT null DROP TABLE #BDR_DaysTableTemp
CREATE TABLE #BDR_DaysTableTemp
(
	commCellId		        INT,
	dayNum		            INT,
	dayRefStart	            DATETIME,
	dayRefEnd	            DATETIME,
	dayStart	            DATETIME,
	dayEnd		            DATETIME,
	predicted	            INT,
	dayRefStartLocal	    DATETIME,
	dayRefEndLocal		    DATETIME,
	dayRefStartUnix	        INT,
	dayRefEndUnix	        INT,
	dayStartUnix	        INT,
	dayEndUnix              INT,
	dayRefStartLocalUnix	INT,
	dayRefEndLocalUnix      INT
)
-- ----------------------------------------------------------------------------
--   STATS
-- ----------------------------------------------------------------------------
IF @Stats <> 0
BEGIN
	IF OBJECT_ID('tempdb.dbo.#DaysRange_Stats') IS NOT null DROP TABLE #DaysRange_Stats
	CREATE TABLE #DaysRange_Stats (type VARCHAR(50), timeSpentMili INT)
END
IF @Stats <> 0 SET @StatsTempTime = GetDate()
-- ----------------------------------------------------------------------------
--   PREPARATION
-- ----------------------------------------------------------------------------
-- Find out the WkEnd Relative EndTimeOffSet and the WeekDay EndTimeOFfSet
-- for weekly and monthly calculations
IF @ActivityOrCoverage = 1 BEGIN
	SELECT	@WkEndEndTimeOffSet = DATEDIFF(SECOND, '00:00:00', @BackupFrom),
		    @WkDayEndTimeOffSet = DATEDIFF(SECOND, '00:00:00', @BackupFrom)
END
ELSE BEGIN
	SELECT	@WkEndEndTimeOffSet = DATEDIFF(SECOND, '00:00:00', @BackupFrom) ,
		    @WkDayEndTimeOffSet = DATEDIFF(SECOND, '00:00:00', @BackupFrom)
END
--
-- Prepare START TIME and END TIME depending on:
--      the TYPE        (last N days, absolute values)
-- and
--	    the FREQUENCY   (daily, weekly, monthly)
--
-- LAST N DAYS
IF @RequestType = 1
BEGIN
	IF @RequestFrequency = 1 BEGIN
		SET	@RequestEndTime		= dbo.GetUnixTime(DATEADD(day, -(@currentStepAdj), GetUTCDate()))
		SET @RequestStartTime 	= dbo.GetUnixTime(DATEADD(day, -(@RequestNumOfSteps),     dbo.GetDateTime(@RequestEndTime)))
	END
	ELSE IF @RequestFrequency = 2 BEGIN
		SET	@RequestEndTime		= dbo.GetUnixTime(DATEADD(week, -(@currentStepAdj-1), GetUTCDate()))
		SET @RequestStartTime 	= dbo.GetUnixTime(DATEADD(week, -(@RequestNumOfSteps), dbo.GetDateTime(@RequestEndTime)))
	END
	ELSE IF @RequestFrequency = 3 BEGIN
		SET	@RequestEndTime		= dbo.GetUnixTime(DATEADD(month, -(@currentStepAdj-1), GetUTCDate()))
		SET @RequestStartTime 	= dbo.GetUnixTime(DATEADD(month, -(@RequestNumOfSteps), dbo.GetDateTime(@RequestEndTime)))
	END
	ELSE IF @RequestFrequency = 4 BEGIN
		SET	@RequestEndTime		= dbo.GetUnixTime(DATEADD(hour, -(@currentStepAdj), GetUTCDate()))
		SET @RequestStartTime 	= dbo.GetUnixTime(DATEADD(hour, -@RequestNumOfSteps, dbo.GetDateTime(@RequestEndTime)))
	END
	ELSE IF @RequestFrequency = 6 BEGIN
		SET	@RequestEndTime		= dbo.GetUnixTime(DATEADD(year, -(@currentStepAdj-1), GetUTCDate()))
		SET @RequestStartTime 	= dbo.GetUnixTime(DATEADD(year, -(@RequestNumOfSteps),     dbo.GetDateTime(@RequestEndTime)))
	END
END
IF @Debug <> 0  SELECT CalculatedNumOfSteps = @RequestNumOfSteps,
		       CalculatedRequestStartTime   = dbo.GetDateTime(@RequestStartTime), CalculatedRequestEndTime = dbo.GetDateTime(@RequestEndTime)
--
-- Calculate CurrentStart and CurrentEnd to local time and according
-- to the BackupWindow (either Activity or Coverage)
--
SET @CurrentStart 	= dbo.UTCToCellLocalTime(dbo.GetDateTime(@RequestStartTime), @commCellId)
SET @CurrentEnd		= dbo.UTCToCellLocalTime(dbo.GetDateTime(@RequestEndTime),   @commCellId)
IF @RequestFrequency = 1 BEGIN
	SET @CurrentStart	= dbo.GetDayStart(@CurrentStart, 0)
	SET @CurrentEnd		= dbo.GetDayStart(@CurrentEnd, 0)
END
ELSE IF @RequestFrequency = 4 BEGIN
	SET @CurrentStart	= dbo.GetHourStart(@CurrentStart)
	SET @CurrentEnd		= dbo.GetHourStart(@CurrentEnd)
END
ELSE BEGIN
	-- Current Start time
	-- The offset MUST be sensitive to the day we fall in
	SET @CurrentStart = (CASE   WHEN @RequestFrequency = 2 THEN dbo.GetWeekStart (@CurrentStart, @WkEndEndTimeOffSet)
			                    WHEN @RequestFrequency = 3 THEN dbo.GetMonthStart(@CurrentStart, 0)
			                    WHEN @RequestFrequency = 6 THEN dbo.GetYearStart (@CurrentStart, 0)
		                 END)
	SET @CurrentStart = (CASE WHEN @RequestFrequency = 3 THEN
				                                                CASE WHEN DATEPART(dw, @CurrentStart) IN (3, 4, 5, 6) THEN dbo.GetMonthStart(@CurrentStart, @WkDayEndTimeOffSet)
					                                                 WHEN DATEPART(dw, @CurrentStart) IN (7, 1, 2)    THEN dbo.GetMonthStart(@CurrentStart, @WkEndEndTimeOffSet)
				                                                END
			                  WHEN @RequestFrequency = 6 THEN
				                                                CASE WHEN DATEPART(dw, @CurrentStart) IN (3, 4, 5, 6) THEN dbo.GetYearStart(@CurrentStart, @WkDayEndTimeOffSet)
					                                                 WHEN DATEPART(dw, @CurrentStart) IN (7, 1, 2)    THEN dbo.GetYearStart(@CurrentStart, @WkEndEndTimeOffSet)
				                                                END
			                  ELSE @CurrentStart
		                 END)
	-- Current END time where we'll start the loop
	-- The offset MUST be sensitive to the day we fall in
	SET @CurrentEnd	= (CASE WHEN @RequestFrequency = 2 THEN dbo.GetWeekStart(@CurrentEnd, @WkEndEndTimeOffSet)
			                WHEN @RequestFrequency = 3 THEN dbo.GetMonthStart(@CurrentEnd, 0)
			                WHEN @RequestFrequency = 6 THEN dbo.GetYearStart(@CurrentEnd, 0)
		               END)
	SET @CurrentEnd = (CASE WHEN @RequestFrequency = 3 THEN
				                                            CASE WHEN DATEPART(dw, @CurrentEnd) IN (3, 4, 5, 6) THEN dbo.GetMonthStart(@CurrentEnd, @WkDayEndTimeOffSet)
					                                             WHEN DATEPART(dw, @CurrentEnd) IN (7, 1, 2)    THEN dbo.GetMonthStart(@CurrentEnd, @WkEndEndTimeOffSet)
				                                            END
			                WHEN @RequestFrequency = 6 THEN
				                                            CASE WHEN DATEPART(dw, @CurrentEnd) IN (3, 4, 5, 6) THEN dbo.GetYearStart(@CurrentEnd, @WkDayEndTimeOffSet)
					                                             WHEN datepart(dw, @CurrentEnd) IN (7, 1, 2)    THEN dbo.GetYearStart(@CurrentEnd, @WkEndEndTimeOffSet)
				                                            END
			                ELSE @CurrentEnd
		               END)
END
IF @Debug <> 0 SELECT CurrentStart = @CurrentStart, CurrentEnd = @CurrentEnd
-- Initialize CurrentStep
IF @RequestFrequency = 1
	SET @CurrentStepBefPred = dbo.GetDayStart(@CurrentEnd, 0)
ELSE
	SET @CurrentStepBefPred = @CurrentEnd
IF @Stats <> 0 INSERT INTO #DaysRange_Stats VALUES ('Before Loop', datediff(millisecond, @StatsTempTime, GetDate()))
IF @Stats <> 0 SET @StatsTempTime = GetDate()
-- ----------------------------------------------------------------------------
--   PREDICTION
-- ----------------------------------------------------------------------------
	IF @RequestFrequency = 1
		SET @CurrentStep 	= DATEADD(day,    @PredictionSteps - 1, @CurrentStepBefPred)
	ELSE IF @RequestFrequency = 2
		SET @CurrentStep 	= DATEADD(week,   @PredictionSteps - 1, @CurrentStepBefPred)
	ELSE IF @RequestFrequency = 3
		SET @CurrentStep 	= DATEADD(month,  @PredictionSteps - 1, @CurrentStepBefPred)
	ELSE IF @RequestFrequency = 4
		SET @CurrentStep 	= DATEADD(minute, (@PredictionSteps - 1) * @HourFrequencyInMin, @CurrentStepBefPred)
	ELSE IF @RequestFrequency = 6
		SET @CurrentStep 	= DATEADD(year,   (@PredictionSteps - 1), @CurrentStepBefPred)
-- ----------------------------------------------------------------------------
--   START LOOPING AND CONSTRUCTING THE RANGE
-- ----------------------------------------------------------------------------
WHILE @CurrentStart <= @CurrentStep BEGIN
	-- Switch on the Frequency
	IF (@RequestFrequency = 1) BEGIN
		SET @DayStartLoop	= dbo.GetDayStart(@CurrentStep, 0)
		SET @DayNumLoop		= DATEPART(dw, @DayStartLoop)
		-- Get the actual DayStart and DayEnd as written on the APP_CommCellDays table
		IF @ActivityOrCoverage = 1 BEGIN
			SELECT 	@DayNumber = CASE  WHEN @RequestTreatWeekend = 1 AND @DayNumLoop IN (1, 6, 7) THEN 8
					                   ELSE @DayNumLoop
				                 END,
				    @DayStart  = CASE  WHEN @RequestTreatWeekend = 1 THEN DATEADD(SECOND, @WkDayEndTimeOffSet , @DayStartLoop)
									   ELSE                               DATEADD(SECOND,@WkDayEndTimeOffSet, @DayStartLoop)
								 END,
				    @DayEnd    = CASE  WHEN @RequestTreatWeekend = 1 THEN DATEADD(SECOND, 86400 + @WkDayEndTimeOffSet, @DayStartLoop)
									   ELSE									DATEADD(SECOND,86400 +  @WkDayEndTimeOffSet, @DayStartLoop)
							     END
		END
		ELSE BEGIN
			SELECT 	@DayNumber = CASE WHEN @RequestTreatWeekend = 1 AND @DayNumLoop IN (1, 6, 7) THEN 8
					                  ELSE                                                            @DayNumLoop
				                 END,
				    @DayStart  = CASE  WHEN @RequestTreatWeekend = 1 THEN DATEADD(SECOND, @WkDayEndTimeOffSet , @DayStartLoop)
									   ELSE                               DATEADD(SECOND,@WkDayEndTimeOffSet, @DayStartLoop)
							     END,
				    @DayEnd    = CASE  WHEN @RequestTreatWeekend = 1 THEN DATEADD(SECOND, 86400 + @WkDayEndTimeOffSet, @DayStartLoop)
									   ELSE									DATEADD(SECOND,86400 +  @WkDayEndTimeOffSet, @DayStartLoop)
						         END
		END
		SET @DayRefStart = @DayStart
		SET @DayRefEnd   = @DayEnd
		IF @StartFromPreviousEnd = 1 AND @ActivityOrCoverage = 1
            SET @DayStart = DATEADD(minute, 0, @DayStartLoop)
	END
	ELSE IF @RequestFrequency = 2 BEGIN
		SET @DayStart 	 = @CurrentStep
		SET @DayEnd 	 = DATEADD(week, 1, @DayStart)
		SET @DayNumber 	 = 0
		SET @DayRefStart = @DayStart
		SET @DayRefEnd   = @DayEnd
	END
	ELSE IF @RequestFrequency = 3 BEGIN
		SET @DayStart 	 = @CurrentStep
		SET @DayEnd 	 = DATEADD(month, 1, @DayStart)
		SET @DayStart    = (CASE WHEN DATEPART(dw, @DayStart) IN (3, 4, 5, 6) THEN dbo.GetMonthStart(@DayStart, @WkDayEndTimeOffSet)
					             WHEN DATEPART(dw, @DayStart) IN (7, 1, 2)    THEN dbo.GetMonthStart(@DayStart, @WkEndEndTimeOffSet)
				            END)
		SET @DayEnd      = (CASE WHEN DATEPART(dw, @DayEnd) IN (3, 4, 5, 6) THEN dbo.GetMonthStart(@DayEnd, @WkDayEndTimeOffSet)
					             WHEN DATEPART(dw, @DayEnd) IN (7, 1, 2)    THEN dbo.GetMonthStart(@DayEnd, @WkEndEndTimeOffSet)
				            END)
		SET @DayNumber 	 = 0
		SET @DayRefStart = @DayStart
		SET @DayRefEnd   = @DayEnd
	END
	ELSE IF @RequestFrequency = 6 BEGIN
		SET @DayStart 	 = @CurrentStep
		SET @DayEnd 	 = DATEADD(year, 1, @DayStart)
		SET @DayStart    = (CASE WHEN DATEPART(dw, @DayStart) IN (3, 4, 5, 6) THEN dbo.GetYearStart(@DayStart, @WkDayEndTimeOffSet)
					             WHEN DATEPART(dw, @DayStart) IN (7, 1, 2)    THEN dbo.GetYearStart(@DayStart, @WkEndEndTimeOffSet)
				            END)
		SET @DayEnd      = (CASE WHEN DATEPART(dw, @DayEnd) IN (3, 4, 5, 6) THEN dbo.GetYearStart(@DayEnd, @WkDayEndTimeOffSet)
					             WHEN DATEPART(dw, @DayEnd) IN (7, 1, 2)    THEN dbo.GetYearStart(@DayEnd, @WkEndEndTimeOffSet)
				            END)
		SET @DayNumber 	 = 0
		SET @DayRefStart = @DayStart
		SET @DayRefEnd   = @DayEnd
	END
	ELSE IF @RequestFrequency = 4 BEGIN
		-- The hourly interval is actually presented in 10 minute interval
		SET @DayStart 	 = @CurrentStep
		SET @DayEnd 	 = DATEADD(minute, @HourFrequencyInMin, @DayStart)
		SET @DayNumber 	 = DATEPART(dw, @DayStart)
		SET @DayRefStart = @DayStart
		SET @DayRefEnd   = @DayEnd
	END
	-- Remove 1 second from the DayEnd time
	SET @DayEnd = DATEADD(second, -1, @DayEnd)
	-- DayStart/End will be changed to UTC time to be able to correctly query the database
	SET @Predicted	      = CASE WHEN @DayRefStart >= @CurrentStepBefPred AND @PredictionSteps > 0 THEN 1 ELSE 0 END
	SET @DayStart	      = dbo.CellLocalToUTCTime(@DayStart, @commCellId)
	SET @DayEnd	          = dbo.CellLocalToUTCTime(@DayEnd,   @commCellId)
	SET @DayRefStartLocal = @DayRefStart
	SET @DayRefEndLocal	  = @DayRefEnd
	SET @DayRefStart      = dbo.CellLocalToUTCTime(@DayRefStart, @commCellId)
	SET @DayRefEnd	      = dbo.CellLocalToUTCTime(@DayRefEnd, @commCellId)
	-- Insert Days I need to work with
	INSERT INTO #BDR_DaysTableTemp
	SELECT  @commCellId, @DayNumber, @DayRefStart, @DayRefEnd, @DayStart, @DayEnd, @Predicted, @DayRefStartLocal, @DayRefEndLocal,
            dbo.GetUnixTime(@DayRefStart), dbo.GetUnixTime(@DayRefEnd), dbo.GetUnixTime(@DayStart), dbo.GetUnixTime(@DayEnd),
            dbo.GetUnixTime(@DayRefStartLocal),dbo.GetUnixTime(@DayRefEndLocal)
	-- DECREMENT the CurrentStep
	IF @RequestFrequency = 1	  SET @CurrentStep = DATEADD(day,    -1,                   @CurrentStep)
	ELSE IF @RequestFrequency = 2 SET @CurrentStep = DATEADD(week,   -1,                   @CurrentStep)
	ELSE IF @RequestFrequency = 3 SET @CurrentStep = DATEADD(month,  -1,                   @CurrentStep)
	ELSE IF @RequestFrequency = 4 SET @CurrentStep = DATEADD(minute, -@HourFrequencyInMin, @CurrentStep)
	ELSE IF @RequestFrequency = 6 SET @CurrentStep = DATEADD(year,   -1,                   @CurrentStep)
END
IF @Debug = 1 SELECT * FROM #BDR_DaysTableTemp ORDER BY dayrefstart DESC
IF @Stats = 1 INSERT INTO #DaysRange_Stats VALUES ('Loop', DATEDIFF(millisecond, @StatsTempTime, GetDate()))
IF @Stats = 1 SET @StatsTempTime = GetDate()
EXEC (	'INSERT INTO ' + @OutTempTable + ' SELECT DISTINCT * FROM #BDR_DaysTableTemp' )
-- Stats
IF @Stats = 1 BEGIN
    INSERT INTO #DaysRange_Stats VALUES ('Insert', DATEDIFF(millisecond, @StatsTempTime, GetDate()))
	SELECT * FROM #DaysRange_Stats
	DROP TABLE #DaysRange_Stats
END
--+-+-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-+
--
--  END
--
--+-+-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-++-+
GO

IF EXISTS (select * from GxQscripts where name = 'wr_BuildDaysRange')
	delete from GxQscripts where name = 'wr_BuildDaysRange'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_BuildDaysRange')
	delete from GXDBVersions where aliasname = 'wr_BuildDaysRange'
GO

insert into GXDBVersions values(2, 'wr_BuildDaysRange',  '00010013000000000000', 'wr_BuildDaysRange', '00010013000000000000')
GO

