

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_BackupJobSummary.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/wr_BackupJobSummary.sp,v $ $Id: wr_BackupJobSummary.sp,v 1.4 2010/12/13 21:15:01 evolohov Exp $";
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Eugene Volohov
-- Create date: 09/11/2010
-- Description:	generates backup job summary report
-- Parameters :
--              requestType                [input] [int]    : determines type of the time range 0: time range, 1 - relatively
--              requestFrequency           [input] [int]    : frequency - 1:day, 2:week, 3:month, 4:hour, 6:year
--              requestNumOfSteps          [input] [int]    : number of steps
--              startTimeUnix              [input] [int]    : if requestType = 0 then start time, ignored otherwise
--              endTimeUnix                [input] [int]    : if requestType = 0 then end time, ignored otherwise
--              includeCurrentPeriod       [input] [int]    : determines if current period (current day, week...) should be
--                                                            included into calculations while calculating days if requestType = 1
--              excludeCmdLineSubClients   [input] [flag]   : determines if clients with only command line subclients will be
--                                                            included in the list of clients
--              treatWeekend               [input] [flag]   : determines the way weekend is treated. 0 - read data from
--                                                            APP_CommCellReportProp table
--              aggregateType	           [input] [int]    : determines aggregation type 1:client, 2:agent, 3:storage, 4:group
--              clientsXML                 [input] [ntext]  : list of the clients to be included in report
-- -----------------------------------------------------------------------------------------------------------
-- ----------------------------------------------------------
-- $Log: wr_BackupJobSummary.sp,v $
-- Revision 1.3  2010/11/15 21:10:09  evolohov
-- added userId and localeId
--
-- Revision 1.2  2010/11/12 20:17:54  evolohov
-- send periodStartTime and periodEndTime values as unix time(uint) instead of string representation
--
-- Revision 1.1  2010/09/13 13:29:07  evolohov
-- Generates backup job summary report.
-- Initial commit.
--
--
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_BackupJobSummary <<<'

IF EXISTS (select * from sysobjects where name='wr_BackupJobSummary')
	drop procedure wr_BackupJobSummary
IF EXISTS (select * from GxQscripts where name='wr_BackupJobSummary')
	delete from GxQscripts where name = 'wr_BackupJobSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_BackupJobSummary')
	delete from GXDBVersions where aliasname = 'wr_BackupJobSummary'
GO
print '... Creating Procedure: wr_BackupJobSummary'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_BackupJobSummary
  @requestType INT, 
  @requestFrequency INT,
  @requestNumOfSteps INT, 
  @startTimeUnix INT, 
  @endTimeUnix INT, 
  @includeCurrentPeriod INT, 
  @excludeCmdLineSubClients INT, 
  @treatWeekend INT, 
  @groupByType INT, 
  @userId INT, 
  @localeId INT, 
  @jobStatus INT, 
  @clientsXML NTEXT
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
	SET NOCOUNT ON;
--DECLARE @requestType                INT = 1 -- 0: time range, 1 - relatively
--DECLARE @requestFrequency           INT = 1 -- 1:day, 2:week, 3:month, 4:hour, 6:year
--DECLARE @requestNumOfSteps          INT = 20
--DECLARE @startTimeUnix              INT = 0
--DECLARE @endTimeUnix                INT = 0
--DECLARE @includeCurrentPeriod       INT = 1
--DECLARE @excludeCmdLineSubClients   INT = 0
--DECLARE @treatWeekend               INT = 0
--DECLARE @groupByType                INT = 1 -- 1:client, 2:agent, 3:storage, 4:group, 5:job?
--DECLARE @userId	                  INT = 0
--DECLARE @localeId	                  INT = 0
--DECLARE @jobStatus                  INT = 0
--DECLARE @clientsXML		NVARCHAR(MAX) = N'<DPSummary_Request>
--											<tree>
--												<entity selectionType="2" commCellId="2" clientGroupId="0" clientId="0" />
--											</tree>
--										 </DPSummary_Request>'
DECLARE @debug			INT = 0
DECLARE @stats			INT = 0
DECLARE @statsTempTime  DATETIME
IF @stats <> 0 BEGIN
	SET NOCOUNT ON
	SET STATISTICS IO ON
	SET STATISTICS TIME ON
END
-- delete stale temporary tables from memory
IF OBJECT_ID('tempdb.dbo.#tmp_Clients')         IS NOT null DROP TABLE #tmp_Clients
IF OBJECT_ID('tempdb.dbo.#tmp_Periods')         IS NOT null DROP TABLE #tmp_Periods
IF OBJECT_ID('tempdb.dbo.#tmp_Jobs')            IS NOT null DROP TABLE #tmp_Jobs
IF OBJECT_ID('tempdb.dbo.#tmp_JobsAggregate')   IS NOT null DROP TABLE #tmp_JobsAggregate
CREATE TABLE #tmp_Periods
(
	commCellId		    int,
	dayNum		        int,
	dayRefStart	        datetime,
	dayRefEnd	        datetime,
	dayStart	        datetime,
	dayEnd		        datetime,
	predicted	        int,
	dayRefStartLocal	datetime,
	dayRefEndLocal		datetime
)
CREATE TABLE #tmp_Clients
(
    CommCellId          INT             NULL,
    CommCellName        NVARCHAR(1024)  NULL,
    ClientGroupId       INT             NULL,
    ClientGroupName     NVARCHAR(1024)  NULL,
    ClientID            INT             NULL,
    ClientName          NVARCHAR(1024)  NULL,
    AppTypeID           INT             NULL,
    Uninstalled         INT             null
)
CREATE TABLE #tmp_Jobs
(
	jobCategory			INT             NOT NULL,
    commCellId          INT             NOT NULL,
    jobId               INT             NOT NULL,
    appTypeId           INT             NOT NULL,
    opType              INT             NOT NULL,
    clientId			INT             NOT NULL,
    dataStorageId		INT	            NULL,
    logStorageId		INT	            NULL,
    subclientId			INT	            NULL,
    startTime           INT             NOT NULL,
    endTime             INT             NOT NULL,
    [status]            INT             NOT NULL,
    dataPhysicalSize    BIGINT          NULL,
    dataLogicalSize     BIGINT          NULL,
    logPhysicalSize     BIGINT          NULL,
    logLogicalSize      BIGINT          NULL,
    protectedObjects    INT             NOT NULL,
    failedObjects       INT             NOT NULL,
    failedFolders       INT             NOT null
)
CREATE INDEX #tmp_Jobs_idx1 ON #tmp_Jobs (commCellId ASC, startTime ASC, endTime ASC)
CREATE TABLE #tmp_JobsAggregate
(
    PeriodNo            INT             NOT NULL,
    PeriodStartTime     DATETIME        NOT NULL,
    PeriodEndTime       DATETIME        NOT NULL,
    OrigCCId            INT             NOT NULL,
    CommCellName        NVARCHAR(255)	NULL,
    AggregEntityId		INT				NULL,
    AggregEntityName    NVARCHAR(255)   NULL,
    TotalJobs           INT             NULL,
    Completted          INT             NULL,
    ComplettedErrors    INT             NULL,
    ComplettedWarnings  INT             NULL,
    Killed              INT             NULL,
    Delayed             INT             NULL,
    Running             INT             NULL,
    Unsuccessfull       INT             NULL,
    AppSize             BIGINT          NULL,
    DataWritten         BIGINT          NULL,
    ProtectedObjects    BIGINT          NULL,
    FailedObjects       BIGINT          NULL,
    FailedFolders       BIGINT          null
)
CREATE INDEX tmp_JobsAggregate_aggregate ON #tmp_JobsAggregate (OrigCCId ASC, AggregEntityId ASC)
-- get list of the clients
EXEC dbo.wr_CellSelection @clientsXML, N'#tmp_Clients', 1, N'tree', 0, 0
IF @debug <> 0 SELECT 'clients', * FROM #tmp_Clients
-- create list of time periods for each commcell.
-- each commcell can have its own day-start/day-end definition. So we have to create periods list for
-- each commcell separately
-- we can use cursor here without any problem because table we are going to iterate through is already
-- temporary, in-memory table
IF @stats <> 0 SET @statsTempTime = GetDate()
DECLARE @selectedCC INT
DECLARE existingCCs CURSOR FOR SELECT DISTINCT CommCellId FROM #tmp_Clients
OPEN existingCCs
FETCH NEXT FROM existingCCs INTO @selectedCC
WHILE @@FETCH_STATUS = 0 BEGIN
    ----------------------------------------------------------------------------------------------------------------------------------------------------------------activity or coverage---+
    --                                                                                                                                                                                     |
    EXEC dbo.wr_BuildDaysRange  @selectedCC, '#tmp_Periods', @requestType, @requestNumOfSteps, @requestFrequency, @startTimeUnix, @endTimeUnix, @treatWeekend, 0, 1, 10, 0, @includeCurrentPeriod
    FETCH NEXT FROM existingCCs INTO @selectedCC
END
CLOSE existingCCs
DEALLOCATE existingCCs
-- In order to improve aggregates calculation performance I've tryed to do the following:
-- 1. assign unique id to each row in the #tmp_Periods table
-- -- ALTER TABLE #tmp_Periods ADD periodId INT IDENTITY(1,1)
-- 2. while creating aggregation table
-- -- for each row add unique period id to which that row belongs
-- 3. while getting list of jobs into temporary table calculate to which period it belongs
-- -- (SELECT periodId FROM #tmp_Periods WHERE dbo.GetDateTime(JI.jobStartTime) >= #tmp_Periods.dayRefStart AND dbo.GetDateTime(JI.jobStartTime) < #tmp_Periods.dayRefEnd),
-- 4. while doing aggregation use statement
-- --
-- -- (SELECT COUNT(*) FROM #tmp_Jobs J WHERE     J.periodId = P.periodId
-- --                                         AND (clientId = #tmp_JobsAggregate.AggregEntityId) AND (commCellId = #tmp_JobsAggregate.OrigCCId OR #tmp_JobsAggregate.OrigCCId = -1)),
-- -- and WHERE #tmp_JobsAggregate.PeriodId = P.periodId on table update level
-- --
-- instead of
-- --
-- -- (SELECT COUNT(*) FROM #tmp_Jobs J WHERE   (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
-- --                                         AND (clientId = #tmp_JobsAggregate.AggregEntityId) AND (commCellId = #tmp_JobsAggregate.OrigCCId OR #tmp_JobsAggregate.OrigCCId = -1)),
-- -- and WHERE #tmp_JobsAggregate.PeriodStartTime = P.dayRefStart AND #tmp_JobsAggregate.PeriodEndTime = P.dayRefEnd on table update level
--
-- Suprisingly enough stats are :
-- -- with period id
-- -- --  SQL Server Execution Times:
-- -- --     CPU time = 16 ms,  elapsed time = 19 ms.
-- -- --  Table '#tmp_JobsAggregate_000000012A55'. Scan count 1, logical reads 29, physical reads 0, read-ahead reads 0, lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- -- --  Table '#tmp_Jobs_000000012A54'. Scan count 364, logical reads 1456, physical reads 0, read-ahead reads 0, lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- -- --  Table '#tmp_Periods_000000012A52'. Scan count 1, logical reads 28, physical reads 0, read-ahead reads 0, lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- -- without period id
-- -- --  SQL Server Execution Times:
-- -- --    CPU time = 16 ms,  elapsed time = 9 ms.
-- -- -- Table '#tmp_JobsAggregate_000000012A55'. Scan count 1, logical reads 29, physical reads 0, read-ahead reads 0, lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- -- -- Table 'Worktable'. Scan count 1, logical reads 59, physical reads 0, read-ahead reads 0, lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- -- -- Table '#tmp_Jobs_000000012A54'. Scan count 364, logical reads 1456, physical reads 0, read-ahead reads 0, lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- -- -- Table '#tmp_Periods_000000012A52'. Scan count 1, logical reads 28, physical reads 0, read-ahead reads 0, lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- after adding the following indexes :
-- -- CREATE CLUSTERED INDEX tmp_Periods_idx1 ON #tmp_Periods (dayRefStart ASC, dayRefEnd ASC)
-- -- CREATE UNIQUE    INDEX tmp_Periods_idx2 ON #tmp_Periods (periodId ASC)
-- -- CREATE INDEX #tmp_Jobs_idx1 ON #tmp_Jobs (commCellId ASC, startTime ASC, endTime ASC)
-- -- CREATE CLUSTERED INDEX #tmp_Jobs_idx2 ON #tmp_Jobs (commCellId ASC, periodId ASC)
-- -- CREATE CLUSTERED INDEX tmp_JobsAggregate_idx1 ON #tmp_JobsAggregate (OrigCCId ASC, PeriodId ASC)
-- stats are:
-- -- with period id
-- -- --  SQL Server Execution Times:
-- -- --    CPU time = 16 ms,  elapsed time = 15 ms.
-- -- -- Table '#tmp_JobsAggregate_000000012A97'. Scan count 1, logical reads 58, physical reads 0, read-ahead reads 0, lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- -- -- Table '#tmp_Jobs_000000012A96'. Scan count 364, logical reads 728, physical reads 0, read-ahead reads 0, lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- -- -- Table '#tmp_Periods_000000012A94'. Scan count 0, logical reads 56, physical reads 0, read-ahead reads 0, lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- -- without period id
-- -- -- SQL Server Execution Times:
-- -- --    CPU time = 0 ms,  elapsed time = 17 ms.
-- -- -- Table '#tmp_JobsAggregate_000000012A97'. Scan count 1, logical reads 59, physical reads 0, read-ahead reads 0, lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- -- -- Table 'Worktable'. Scan count 1, logical reads 59, physical reads 0, read-ahead reads 0, lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- -- -- Table '#tmp_Jobs_000000012A96'. Scan count 364, logical reads 728, physical reads 0, read-ahead reads 0, lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- -- -- Table '#tmp_Periods_000000012A94'. Scan count 28, logical reads 56, physical reads 0, read-ahead reads 0, lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- BOTTOM LINE: it does not worth it to have additional columns. Index tmp_Jobs_idx1 does make sence though
IF @debug <> 0 SELECT 'periods', * FROM #tmp_Periods ORDER BY dayRefStart
DECLARE @refStart   INT = ISNULL(dbo.GetUnixTime((SELECT MIN(dayRefStart) FROM #tmp_Periods)),0)
DECLARE @refEnd     INT = ISNULL(dbo.GetUnixTime((SELECT MAX(dayRefEnd) FROM #tmp_Periods)),0)
-- select all jobs for selected commcell
INSERT INTO #tmp_Jobs
    -- Get the data from the running tables first. Data in those tables is more accurate and gets updated more frequent.
    -- To differentiate between <state>:[running job] and <status>:[finished job] we will adjust <state> to be <state> + 100
    -- <status> will remain the same
	SELECT  1, BI.commCellId, BI.jobId, A.appTypeId, JI.opType, A.clientId,  BI.dataPolicy, BI.logPolicy, A.id, JI.jobStartTime, 0, 100 + JI.[state],
	        0, 0, 0, 0, ISNULL(BI.filesXfered, 0),
	        ISNULL(BI.backupFileFailures, 0), ISNULL(BI.backupFolderFailures, 0)
	FROM	JMJobInfo JI INNER JOIN JMBkpJobInfo BI ON JI.commCellId = BI.commCellId AND JI.jobId = BI.jobId
						 INNER JOIN APP_Application A ON A.origCCId = BI.commcellId AND A.id = BI.applicationId
	WHERE		JI.jobStartTime >= @refStart
			AND JI.jobStartTime <= @refEnd
    UNION
    SELECT  1, B.commCellId, B.jobId, B.appType, B.opType, A.clientId, B.dataArchGrpId, B.logArchGrpId, A.id, B.servStartDate, B.servEndDate,
            (CASE B.displayStatus WHEN 0 THEN B.[status] ELSE B.displayStatus END),
            0, 0, 0, 0, ISNULL(totalNumOfFolders, 0) + ISNULL(totalNumOfFiles, 0),
            ISNULL(backupFileFailures, 0), ISNULL(backupFolderFailures, 0)
    FROM    JMBkpStats B INNER JOIN APP_Application A ON B.commCellId = A.origCCId AND B.appId = A.id
    WHERE		(B.servStartDate BETWEEN @refStart AND @refEnd)
            OR  (B.servEndDate  BETWEEN @refStart AND @refEnd)
            OR  (B.servStartDate < @refStart AND B.servEndDate > @refEnd)
-- it happens that it is faster to select all entries from JMBkpStats and JMBkpJonbInfo and delete unwanted ones as a second step
-- than use just one query with JOIN or subqueries to filter out unwanted jobs
DELETE  FROM #tmp_Jobs
WHERE   subclientId NOT IN (SELECT id FROM APP_Application S INNER JOIN #tmp_Clients C ON     S.origCCId = C.CommCellId
                                                                                          AND S.clientId = C.ClientId )
-- update sizes in the table
UPDATE  #tmp_Jobs
SET     dataPhysicalSize = ISNULL( (SELECT  SUM(physicalSize)
                                    FROM    archChunkMapping WITH (READUNCOMMITTED)
                                    WHERE   archFileId IN (SELECT id FROM archFile WITH (READUNCOMMITTED) WHERE jobId = #tmp_Jobs.jobId and archGroupId = #tmp_Jobs.dataStorageId)), 0),
        logPhysicalSize  = ISNULL( (SELECT  SUM(physicalSize)
                                    FROM    archChunkMapping WITH (READUNCOMMITTED)
                                    WHERE   archFileId IN (SELECT id FROM archFile WITH (READUNCOMMITTED) WHERE jobId = #tmp_Jobs.jobId and archGroupId = #tmp_Jobs.logStorageId)), 0),
        dataLogicalSize  = ISNULL( (SELECT  SUM(logicalSize)
                                    FROM    archChunkMapping WITH (READUNCOMMITTED)
                                    WHERE   archFileId IN (SELECT id FROM archFile WITH (READUNCOMMITTED) WHERE jobId = #tmp_Jobs.jobId and archGroupId = #tmp_Jobs.dataStorageId)), 0),
        logLogicalSize   = ISNULL( (SELECT  SUM(logicalSize)
                                    FROM    archChunkMapping WITH (READUNCOMMITTED)
                                    WHERE   archFileId IN (SELECT id FROM archFile WITH (READUNCOMMITTED) WHERE jobId = #tmp_Jobs.jobId and archGroupId = #tmp_Jobs.logStorageId)), 0)
IF @debug <> 0 SELECT 'bkp jobs', * FROM #tmp_Jobs
-- --------------------------------------------------------------------------------------------------------------------
-- generate aggregates
-- --------------------------------------------------------------------------------------------------------------------
-- first generate high level - overall - bird view aggregate
-- --------------------------------------------------------------------------------------------------------------------
IF @groupByType = 0 BEGIN -- aggregation by commcell
    -- by day
    INSERT INTO #tmp_JobsAggregate
		SELECT DISTINCT P.dayNum, P.dayRefStart, P.dayRefEnd,
		                P.commCellId,  (SELECT aliasName FROM APP_CommCell WHERE id = P.CommCellId),
						P.commCellId,  (SELECT aliasName FROM APP_CommCell WHERE id = P.CommCellId),
						-- total jobs
						(SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                AND (J.commCellId = P.CommCellId)),
                        -- completted : CVJobStatus::JMSUCCESS , CVJobState::COMPLETED, CVJobState::COMPLETEDSUCCESS
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (J.commCellId = P.CommCellId)
                                                                 AND ([status] IN (1, 104, 109))),
                        -- completted with errors : CVJobStatus::PARTIALSUCCESS, CVJobState::COMPLETEDPARTIAL
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (J.commCellId = P.CommCellId)
                                                                 AND ([status] IN (3, 112))),
		                -- completted with warnings : CVJobStatus::JMSUCCESSWITHWARNINGS, CVJobState::COMPLETEDWITHWARNING
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (J.commCellId = P.CommCellId)
                                                                 AND ([status] IN (14, 119))),
                        -- killed : CVJobStatus::KILLED, CVJobStatus::SYSTEMFAILED, CVJobState::KILLPENDING, CVJobState::STATEKILLED, CVJobState::SYSTEMKILLPENDING
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (J.commCellId = P.CommCellId)
                                                                 AND ([status] IN (4, 15, 106, 111, 113))),
                        -- delayed : CVJobStatus::STSTOPPED,	CVJobStatus::STINTERRUPTED, CVJobState::PENDING, CVJobState::WAITING, CVJobState::STOPPED, CVJobState::STOPPENDING, CVJobState::INTERRUPTPENDING
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (J.commCellId = P.CommCellId)
                                                                 AND ([status] IN (5, 6, 102, 103, 105, 107, 108))),
	                    -- running : CVJobStatus::CVJOBSTATUS_STARTED, CVJobState::RUNNING, CVJobState::RUNNING_UNVERIFIABLE
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (J.commCellId = P.CommCellId)
                                                                 AND ([status] IN (13, 101, 117))),
                        -- unsucessfull : CVJobStatus::FAIL, CVJobStatus::STSKIPPED, CVJobStatus::DROPPED, CVJobState::COMPLETEDFAIL
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (J.commCellId = P.CommCellId)
                                                                 AND ([status] IN (2, 8, 9, 110))),
                        -- application size
                        (SELECT ISNULL(SUM(ISNULL(dataLogicalSize, 0) + ISNULL(logLogicalSize, 0)), 0) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                                                                   AND (J.commCellId = P.CommCellId)),
                        -- data written
                        (SELECT ISNULL(SUM(ISNULL(dataPhysicalSize, 0) + ISNULL(logPhysicalSize,0)), 0) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                                                                   AND (J.commCellId = P.CommCellId)),
                        -- protected objects
                        (SELECT ISNULL(SUM(ISNULL(protectedObjects, 0)), 0) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                                                                   AND (J.commCellId = P.CommCellId)),
                        -- failed objects
                        (SELECT ISNULL(SUM(ISNULL(failedObjects, 0)), 0) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                                                                   AND (J.commCellId = P.CommCellId)),
                        -- failed folders
                        (SELECT ISNULL(SUM(ISNULL(FailedFolders, 0)), 0) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                                                                   AND (J.commCellId = P.CommCellId))
        FROM    #tmp_Periods P
END
IF @groupByType = 1 BEGIN -- aggregation by client
    -- by day
    INSERT INTO #tmp_JobsAggregate
        SELECT DISTINCT P.dayNum, P.dayRefStart, P.dayRefEnd,
                        C.CommCellId, C.CommCellName,
                        C.ClientID, C.ClientName,
						-- total jobs
						(SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                AND (J.clientId = C.ClientID)),
                        -- completted : CVJobStatus::JMSUCCESS , CVJobState::COMPLETED, CVJobState::COMPLETEDSUCCESS
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (J.clientId = C.ClientID)
                                                                 AND ([status] IN (1, 104, 109))),
                        -- completted with errors : CVJobStatus::PARTIALSUCCESS, CVJobState::COMPLETEDPARTIAL
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (J.clientId = C.ClientID)
                                                                 AND ([status] IN (3, 112))),
		                -- completted with warnings : CVJobStatus::JMSUCCESSWITHWARNINGS, CVJobState::COMPLETEDWITHWARNING
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (J.clientId = C.ClientID)
                                                                 AND ([status] IN (14, 119))),
                        -- killed : CVJobStatus::KILLED, CVJobStatus::SYSTEMFAILED, CVJobState::KILLPENDING, CVJobState::STATEKILLED, CVJobState::SYSTEMKILLPENDING
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (J.clientId = C.ClientID)
                                                                 AND ([status] IN (4, 15, 106, 111, 113))),
                        -- delayed : CVJobStatus::STSTOPPED,	CVJobStatus::STINTERRUPTED, CVJobState::PENDING, CVJobState::WAITING, CVJobState::STOPPED, CVJobState::STOPPENDING, CVJobState::INTERRUPTPENDING
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (J.clientId = C.ClientID)
                                                                 AND ([status] IN (5, 6, 102, 103, 105, 107, 108))),
	                    -- running : CVJobStatus::CVJOBSTATUS_STARTED, CVJobState::RUNNING, CVJobState::RUNNING_UNVERIFIABLE
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (J.clientId = C.ClientID)
                                                                 AND ([status] IN (13, 101, 117))),
                        -- unsucessfull : CVJobStatus::FAIL, CVJobStatus::STSKIPPED, CVJobStatus::DROPPED, CVJobState::COMPLETEDFAIL
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (J.clientId = C.ClientID)
                                                                 AND ([status] IN (2, 8, 9, 110))),
                        -- application size
                        (SELECT ISNULL(SUM(ISNULL(dataLogicalSize, 0) + ISNULL(logLogicalSize, 0)), 0) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                                                                   AND (J.clientId = C.ClientID)),
                        -- data written
                        (SELECT ISNULL(SUM(ISNULL(dataPhysicalSize, 0) + ISNULL(logPhysicalSize,0)), 0) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                                                                   AND (J.clientId = C.ClientID)),
                        -- protected objects
                        (SELECT ISNULL(SUM(ISNULL(protectedObjects, 0)), 0) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                                                                   AND (J.clientId = C.ClientID)),
                        -- failed objects
                        (SELECT ISNULL(SUM(ISNULL(failedObjects, 0)), 0) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                                                                   AND (J.clientId = C.ClientID)),
                        -- failed folders
                        (SELECT ISNULL(SUM(ISNULL(FailedFolders, 0)), 0) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                                                                   AND (J.clientId = C.ClientID))
        FROM    #tmp_Clients C INNER JOIN #tmp_Periods P ON C.CommCellId = P.commCellId
END
IF @groupByType = 2 BEGIN -- aggregation by agent
    INSERT INTO #tmp_JobsAggregate
        SELECT DISTINCT P.dayNum, P.dayRefStart, P.dayRefEnd,
                        -1, '',
                        C.AppTypeID, (SELECT name FROM APP_iDAType WHERE [type] = C.AppTypeID),
						-- total jobs
						(SELECT COUNT(*) FROM #tmp_Jobs J WHERE ( dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                  AND (J.appTypeId = C.AppTypeID) ),
                        -- completted : CVJobStatus::JMSUCCESS , CVJobState::COMPLETED, CVJobState::COMPLETEDSUCCESS
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (J.appTypeId = C.AppTypeID)
                                                                 AND ([status] IN (1, 104, 109))),
                        -- completted with errors : CVJobStatus::PARTIALSUCCESS, CVJobState::COMPLETEDPARTIAL
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (J.appTypeId = C.AppTypeID)
                                                                 AND ([status] IN (3, 112))),
		                -- completted with warnings : CVJobStatus::JMSUCCESSWITHWARNINGS, CVJobState::COMPLETEDWITHWARNING
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (J.appTypeId = C.AppTypeID)
                                                                 AND ([status] IN (14, 119))),
                        -- killed : CVJobStatus::KILLED, CVJobStatus::SYSTEMFAILED, CVJobState::KILLPENDING, CVJobState::STATEKILLED, CVJobState::SYSTEMKILLPENDING
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (J.appTypeId = C.AppTypeID)
                                                                 AND ([status] IN (4, 15, 106, 111, 113))),
                        -- delayed : CVJobStatus::STSTOPPED,	CVJobStatus::STINTERRUPTED, CVJobState::PENDING, CVJobState::WAITING, CVJobState::STOPPED, CVJobState::STOPPENDING, CVJobState::INTERRUPTPENDING
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (J.appTypeId = C.AppTypeID)
                                                                 AND ([status] IN (5, 6, 102, 103, 105, 107, 108))),
	                    -- running : CVJobStatus::CVJOBSTATUS_STARTED, CVJobState::RUNNING, CVJobState::RUNNING_UNVERIFIABLE
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (J.appTypeId = C.AppTypeID)
                                                                 AND ([status] IN (13, 101, 117))),
                        -- unsucessfull : CVJobStatus::FAIL, CVJobStatus::STSKIPPED, CVJobStatus::DROPPED, CVJobState::COMPLETEDFAIL
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (J.appTypeId = C.AppTypeID)
                                                                 AND ([status] IN (2, 8, 9, 110))),
                        -- application size
                        (SELECT ISNULL(SUM(ISNULL(dataLogicalSize, 0) + ISNULL(logLogicalSize, 0)), 0) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                                                                   AND (J.appTypeId = C.AppTypeID)),
                        -- data written
                        (SELECT ISNULL(SUM(ISNULL(dataPhysicalSize, 0) + ISNULL(logPhysicalSize,0)), 0) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                                                                   AND (J.appTypeId = C.AppTypeID)),
                        -- protected objects
                        (SELECT ISNULL(SUM(ISNULL(protectedObjects, 0)), 0) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                                                                   AND (J.appTypeId = C.AppTypeID)),
                        -- failed objects
                        (SELECT ISNULL(SUM(ISNULL(failedObjects, 0)), 0) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                                                                   AND (J.appTypeId = C.AppTypeID)),
                        -- failed folders
                        (SELECT ISNULL(SUM(ISNULL(FailedFolders, 0)), 0) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                                                                   AND (J.appTypeId = C.AppTypeID))
        FROM  (SELECT DISTINCT CommCellId, AppTypeID FROM #tmp_Clients) C INNER JOIN #tmp_Periods P ON C.CommCellId = P.commCellId
END
IF @groupByType = 3 BEGIN -- aggregation by storage
	INSERT INTO #tmp_JobsAggregate
		SELECT DISTINCT P.dayNum, P.dayRefStart, P.dayRefEnd,
		                P.CommCellId, (SELECT aliasName FROM APP_CommCell WHERE APP_CommCell.id = P.CommCellId),
	                    A.id, A.name,
	                    (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
	                                                             AND A.id IN (J.dataStorageId, J.logStorageId)),
                        -- completted : CVJobStatus::JMSUCCESS , CVJobState::COMPLETED, CVJobState::COMPLETEDSUCCESS
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (A.id IN (J.dataStorageId, J.logStorageId))
                                                                 AND ([status] IN (1, 104, 109))),
                        -- completted with errors : CVJobStatus::PARTIALSUCCESS, CVJobState::COMPLETEDPARTIAL
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (A.id IN (J.dataStorageId, J.logStorageId))
                                                                 AND ([status] IN (3, 112))),
		                -- completted with warnings : CVJobStatus::JMSUCCESSWITHWARNINGS, CVJobState::COMPLETEDWITHWARNING
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (A.id IN (J.dataStorageId, J.logStorageId))
                                                                 AND ([status] IN (14, 119))),
                        -- killed : CVJobStatus::KILLED, CVJobStatus::SYSTEMFAILED, CVJobState::KILLPENDING, CVJobState::STATEKILLED, CVJobState::SYSTEMKILLPENDING
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (A.id IN (J.dataStorageId, J.logStorageId))
                                                                 AND ([status] IN (4, 15, 106, 111, 113))),
                        -- delayed : CVJobStatus::STSTOPPED,	CVJobStatus::STINTERRUPTED, CVJobState::PENDING, CVJobState::WAITING, CVJobState::STOPPED, CVJobState::STOPPENDING, CVJobState::INTERRUPTPENDING
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (A.id IN (J.dataStorageId, J.logStorageId))
                                                                 AND ([status] IN (5, 6, 102, 103, 105, 107, 108))),
	                    -- running : CVJobStatus::CVJOBSTATUS_STARTED, CVJobState::RUNNING, CVJobState::RUNNING_UNVERIFIABLE
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (A.id IN (J.dataStorageId, J.logStorageId))
                                                                 AND ([status] IN (13, 101, 117))),
                        -- unsucessfull : CVJobStatus::FAIL, CVJobStatus::STSKIPPED, CVJobStatus::DROPPED, CVJobState::COMPLETEDFAIL
		                (SELECT COUNT(*) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                 AND (A.id IN (J.dataStorageId, J.logStorageId))
                                                                 AND ([status] IN (2, 8, 9, 110))),
                        -- application size
                        (
                        (SELECT ISNULL(SUM(ISNULL(dataLogicalSize, 0) ), 0)
                                         FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                AND (A.id = J.dataStorageId)) +
                        (SELECT ISNULL(SUM(ISNULL(logLogicalSize, 0) ), 0)
                                         FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                AND (A.id = J.logStorageId))
                        ),
                        -- data written
                        (
                        (SELECT ISNULL(SUM(ISNULL(dataPhysicalSize, 0) ), 0)
                                         FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                AND (A.id = J.dataStorageId)) +
                        (SELECT ISNULL(SUM(ISNULL(logPhysicalSize, 0) ), 0)
                                         FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                AND (A.id = J.logStorageId))
                        ),
                        -- protected objects
                        (SELECT ISNULL(SUM(ISNULL(protectedObjects, 0)), 0) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                                                                   AND (A.id IN (J.dataStorageId, J.logStorageId))),
                        -- failed objects
                        (SELECT ISNULL(SUM(ISNULL(failedObjects, 0)), 0) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                                                                   AND (A.id IN (J.dataStorageId, J.logStorageId))),
                        -- failed folders
                        (SELECT ISNULL(SUM(ISNULL(FailedFolders, 0)), 0) FROM #tmp_Jobs J WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                                                                   AND (A.id IN (J.dataStorageId, J.logStorageId)))
        FROM    ArchGroup A INNER JOIN #tmp_Periods P ON (CASE WHEN A.origCCcommCellID = 0 THEN 2 ELSE A.origCCcommCellID END) = P.commCellId
        WHERE   A.id <> 1
END
IF @groupByType = 4 BEGIN -- aggregation by client groups
	INSERT INTO #tmp_JobsAggregate
	    SELECT  P.dayNum, P.dayRefStart, P.dayRefEnd,
	            CO.CommCellId, CO.commCellName,  CO.ClientGroupId, CO.ClientGroupName,
                (SELECT COUNT(*) FROM #tmp_Jobs J INNER JOIN #tmp_Clients C ON J.clientId = C.ClientID WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
	                                                                                                         AND  C.ClientGroupId = CO.ClientGroupId),
                -- completted : CVJobStatus::JMSUCCESS , CVJobState::COMPLETED, CVJobState::COMPLETEDSUCCESS
                (SELECT COUNT(*) FROM #tmp_Jobs J INNER JOIN #tmp_Clients C ON J.clientId = C.ClientID WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                         AND (C.ClientGroupId = CO.ClientGroupId)
                                                         AND ([status] IN (1, 104, 109))),
                -- completted with errors : CVJobStatus::PARTIALSUCCESS, CVJobState::COMPLETEDPARTIAL
                (SELECT COUNT(*) FROM #tmp_Jobs J INNER JOIN #tmp_Clients C ON J.clientId = C.ClientID WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                         AND (C.ClientGroupId = CO.ClientGroupId)
                                                         AND ([status] IN (3, 112))),
                -- completted with warnings : CVJobStatus::JMSUCCESSWITHWARNINGS, CVJobState::COMPLETEDWITHWARNING
                (SELECT COUNT(*) FROM #tmp_Jobs J INNER JOIN #tmp_Clients C ON J.clientId = C.ClientID WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                         AND (C.ClientGroupId = CO.ClientGroupId)
                                                         AND ([status] IN (14, 119))),
                -- killed : CVJobStatus::KILLED, CVJobStatus::SYSTEMFAILED, CVJobState::KILLPENDING, CVJobState::STATEKILLED, CVJobState::SYSTEMKILLPENDING
                (SELECT COUNT(*) FROM #tmp_Jobs J INNER JOIN #tmp_Clients C ON J.clientId = C.ClientID WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                         AND (C.ClientGroupId = CO.ClientGroupId)
                                                         AND ([status] IN (4, 15, 106, 111, 113))),
                -- delayed : CVJobStatus::STSTOPPED,	CVJobStatus::STINTERRUPTED, CVJobState::PENDING, CVJobState::WAITING, CVJobState::STOPPED, CVJobState::STOPPENDING, CVJobState::INTERRUPTPENDING
                (SELECT COUNT(*) FROM #tmp_Jobs J INNER JOIN #tmp_Clients C ON J.clientId = C.ClientID WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                         AND (C.ClientGroupId = CO.ClientGroupId)
                                                         AND ([status] IN (5, 6, 102, 103, 105, 107, 108))),
                -- running : CVJobStatus::CVJOBSTATUS_STARTED, CVJobState::RUNNING, CVJobState::RUNNING_UNVERIFIABLE
                (SELECT COUNT(*) FROM #tmp_Jobs J INNER JOIN #tmp_Clients C ON J.clientId = C.ClientID WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                         AND (C.ClientGroupId = CO.ClientGroupId)
                                                         AND ([status] IN (13, 101, 117))),
                -- unsucessfull : CVJobStatus::FAIL, CVJobStatus::STSKIPPED, CVJobStatus::DROPPED, CVJobState::COMPLETEDFAIL
                (SELECT COUNT(*) FROM #tmp_Jobs J INNER JOIN #tmp_Clients C ON J.clientId = C.ClientID WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                         AND (C.ClientGroupId = CO.ClientGroupId)
                                                         AND ([status] IN (2, 8, 9, 110))),
                -- application size
                (SELECT ISNULL(SUM(ISNULL(dataLogicalSize, 0) + ISNULL(logLogicalSize, 0)), 0) FROM #tmp_Jobs J INNER JOIN #tmp_Clients C ON J.clientId = C.ClientID WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                                                                                                                           AND (C.ClientGroupId = CO.ClientGroupId)),
                 -- data written
                (SELECT ISNULL(SUM(ISNULL(dataPhysicalSize, 0) + ISNULL(dataPhysicalSize, 0)), 0) FROM #tmp_Jobs J INNER JOIN #tmp_Clients C ON J.clientId = C.ClientID WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                                                                                                                           AND (C.ClientGroupId = CO.ClientGroupId)),
                -- protected objects
                (SELECT ISNULL(SUM(ISNULL(protectedObjects, 0)), 0) FROM #tmp_Jobs J INNER JOIN #tmp_Clients C ON J.clientId = C.ClientID WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                                                           AND (C.ClientGroupId = CO.ClientGroupId)),
                -- failed objects
                (SELECT ISNULL(SUM(ISNULL(failedObjects, 0)), 0) FROM #tmp_Jobs J INNER JOIN #tmp_Clients C ON J.clientId = C.ClientID WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                                                           AND (C.ClientGroupId = CO.ClientGroupId)),
                -- failed folders
                (SELECT ISNULL(SUM(ISNULL(FailedFolders, 0)), 0) FROM #tmp_Jobs J INNER JOIN #tmp_Clients C ON J.clientId = C.ClientID WHERE (dbo.GetDateTime(J.startTime) BETWEEN P.dayRefStart AND P.dayRefEnd)
                                                                                                           AND (C.ClientGroupId = CO.ClientGroupId))
	    FROM    (SELECT DISTINCT  CommCellId, commCellName,  ClientGroupId, ClientGroupName
	             FROM   #tmp_Clients
	             WHERE  ClientGroupId <> 0 ) CO INNER JOIN #tmp_Periods P ON CO.CommCellId  = P.commCellId
END
-- by entity aggregations
INSERT INTO #tmp_JobsAggregate
    SELECT DISTINCT -2,  dbo.GetDateTime(@refStart), dbo.GetDateTime(@refEnd),
                    OrigCCId, CommCellName, AggregEntityId, AggregEntityName,
                    SUM(TotalJobs), SUM(Completted), SUM(ComplettedErrors), SUM(ComplettedWarnings), SUM(Killed), SUM(Delayed), SUM(Running), SUM(Unsuccessfull),
                    SUM(AppSize), SUM(DataWritten), SUM(ProtectedObjects), SUM(FailedObjects), SUM(FailedFolders)
    FROM        #tmp_JobsAggregate
    GROUP BY    OrigCCId, CommCellName, AggregEntityId, AggregEntityName
-- overall aggregation
INSERT INTO #tmp_JobsAggregate
    SELECT  -1,  dbo.GetDateTime(@refStart), dbo.GetDateTime(@refEnd),
            -1, 'All', -- commcell id and commcell name
            -1, 'All', -- entity id and entity name
            SUM(TotalJobs), SUM(Completted), SUM(ComplettedErrors), SUM(ComplettedWarnings), SUM(Killed), SUM(Delayed), SUM(Running), SUM(Unsuccessfull),
            SUM(AppSize), SUM(DataWritten), SUM(ProtectedObjects), SUM(FailedObjects), SUM(FailedFolders)
    FROM    #tmp_JobsAggregate
    WHERE   PeriodNo = -2
IF @debug <> 0 SELECT 'global aggs', * FROM #tmp_JobsAggregate
-- Generate XML
SELECT
    -- request
    (SELECT
         @requestType               AS '@requestType',
         @requestFrequency          AS '@requestFrequency',
         @requestNumOfSteps         AS '@requestNumOfSteps',
         @startTimeUnix             AS '@startTimeUnix',
         @endTimeUnix               AS '@endTimeUnix',
         @includeCurrentPeriod      AS '@includeCurrentPeriod',
         @excludeCmdLineSubClients  AS '@excludeCmdLineSubClients',
         @treatWeekend              AS '@treatWeekend',
         @groupByType               AS '@groupByType',
         @userId                    AS '@userId',
         @localeId                  AS '@localeId',
         @jobStatus                 AS '@jobStatus'
     FOR XML PATH('request'),TYPE),
     -- bird view aggregate
    (SELECT PeriodNo                            AS '@dayNo',
            dbo.GetUnixTime(PeriodStartTime)    AS '@periodStartTime',
            dbo.GetUnixTime(PeriodEndTime)      AS '@periodEndTime',
            OrigCCId                            AS '@commCellID',
            CommCellName                        AS '@commCellName',
            AggregEntityId                      AS '@entityId',
            AggregEntityName                    AS '@entityName',
            TotalJobs                           AS '@total',
            Completted                          AS '@completted',
            ComplettedErrors                    AS '@complettedErrors',
            ComplettedWarnings                  AS '@complettedWarnings',
            Killed                              AS '@killed',
            Delayed                             AS '@delayed',
            Running                             AS '@running',
            Unsuccessfull                       AS '@unsuccessfull',
            AppSize                             AS '@appSize',
            DataWritten                         AS '@dataWritten',
            ProtectedObjects                    AS '@protectedObjects',
            FailedObjects                       AS '@failedObjects',
            FailedFolders                       AS '@failedFolders'
     FROM #tmp_JobsAggregate
     WHERE PeriodNo = -1
     FOR XML PATH('aggregate'),TYPE),
     -- per commcell aggregate
     (SELECT
        (SELECT PeriodNo                            AS '@dayNo',
                dbo.GetUnixTime(PeriodStartTime)    AS '@periodStartTime',
                dbo.GetUnixTime(PeriodEndTime)      AS '@periodEndTime',
                OrigCCId                            AS '@commCellID',
                CommCellName                        AS '@commCellName',
                AggregEntityId                      AS '@entityId',
                AggregEntityName                    AS '@entityName',
                TotalJobs                           AS '@total',
                Completted                          AS '@completted',
                ComplettedErrors                    AS '@complettedErrors',
                ComplettedWarnings                  AS '@complettedWarnings',
                Killed                              AS '@killed',
                Delayed                             AS '@delayed',
                Running                             AS '@running',
                Unsuccessfull                       AS '@unsuccessfull',
                AppSize                             AS '@appSize',
                DataWritten                         AS '@dataWritten',
                ProtectedObjects                    AS '@protectedObjects',
                FailedObjects                       AS '@failedObjects',
                FailedFolders                       AS '@failedFolders'
          FROM  #tmp_JobsAggregate A
          WHERE PeriodNo = -2 AND A.AggregEntityId = E.AggregEntityId
          FOR XML PATH('aggregate'),TYPE),
        (SELECT PeriodNo                            AS '@dayNo',
                dbo.GetUnixTime(PeriodStartTime)    AS '@periodStartTime',
                dbo.GetUnixTime(PeriodEndTime)      AS '@periodEndTime',
                OrigCCId                            AS '@commCellID',
                CommCellName                        AS '@commCellName',
                AggregEntityId                      AS '@entityId',
                AggregEntityName                    AS '@entityName',
                TotalJobs                           AS '@total',
                Completted                          AS '@completted',
                ComplettedErrors                    AS '@complettedErrors',
                ComplettedWarnings                  AS '@complettedWarnings',
                Killed                              AS '@killed',
                Delayed                             AS '@delayed',
                Running                             AS '@running',
                Unsuccessfull                       AS '@unsuccessfull',
                AppSize                             AS '@appSize',
                DataWritten                         AS '@dataWritten',
                ProtectedObjects                    AS '@protectedObjects',
                FailedObjects                       AS '@failedObjects',
                FailedFolders                       AS '@failedFolders'
         FROM   #tmp_JobsAggregate D
         WHERE  D.PeriodNo <> -2 AND D.PeriodNo <> -1 AND D.AggregEntityId = E.AggregEntityId
         FOR XML PATH('details'),TYPE)
      FROM  #tmp_JobsAggregate E
      WHERE PeriodNo = -2
      FOR XML PATH('entities'),TYPE)
FOR XML PATH ('BackupJobSummaryResp')
-- delete temporary tables from memory
IF OBJECT_ID('tempdb.dbo.#tmp_Clients')         IS NOT null DROP TABLE #tmp_Clients
IF OBJECT_ID('tempdb.dbo.#tmp_Jobs')            IS NOT null DROP TABLE #tmp_Jobs
IF OBJECT_ID('tempdb.dbo.#tmp_JobsAggregate')   IS NOT null DROP TABLE #tmp_JobsAggregate
GO

IF EXISTS (select * from GxQscripts where name = 'wr_BackupJobSummary')
	delete from GxQscripts where name = 'wr_BackupJobSummary'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_BackupJobSummary')
	delete from GXDBVersions where aliasname = 'wr_BackupJobSummary'
GO

insert into GXDBVersions values(2, 'wr_BackupJobSummary',  '00010004000000000000', 'wr_BackupJobSummary', '00010004000000000000')
GO

