

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_BackupDataSizes.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/wr_BackupDataSizes.sp,v $ $Id: wr_BackupDataSizes.sp,v 1.5 2015/02/02 14:56:01 gharidas Exp $";
-- -----------------------------------------------------------------------------------------------------------
-- Author:		Eugene Volohov
-- Create date: 09/11/2010
-- Description:	Calculates, aggregates and groups backup sizes data.
-- Parameters :
--              outTempTable               [input] [varchar]: name of the table output data will be copied into
--                                                            see definition of #BDS__tmp_Aggregates to get information
--                                                            about this table structure
--              requestGroupBy             [input] [int]    : determines how aggregated data will be grouped:
--                                                            1:client, 2:agent, 3:storage, 4:group
--              requestType                [input] [int]    : determines type of the time range 0: time range, 1 - relatively
--              requestFrequency           [input] [int]    : frequency - 1:day, 2:week, 3:month, 4:hour, 6:year
--              requestNumOfSteps          [input] [int]    : number of steps
--              requestStartTime           [input] [int]    : if requestType = 0 then start time (unix format), ignored otherwise
--              requestEndTime             [input] [int]    : if requestType = 0 then end time( unix format), ignored otherwise
--              requestTreatWeekend        [input] [flag]   : determines the way weekend is treated. 0 - read data from
--                                                            APP_CommCellReportProp table
--              doNotIncludeCurrentStep    [input] [int]    : determines if current period (current day, week...) should be
--                                                            included into calculations while calculating days if requestType = 1
--              incLogDelClients           [input] [flag]   : determines if data for soft deleted clients should be
--                                                            included in the list of clients
--              predictionSteps            [input] [int]    : number of steps (frequency units) to be predicted
--              patternNumber              [input] [int]    : prediction pattern
--              clientsXML                 [input] [ntext]  : list of the clients to be included in report
-- -----------------------------------------------------------------------------------------------------------
-- ----------------------------------------------------------
-- $Log: wr_BackupDataSizes.sp,v $
-- Revision 1.2  2010/09/27 14:12:10  evolohov
-- Forecasts data values based on existsing data using simple moving average method
-- Initial commit
-- Original branch changes by: evolohov (Eugene Volohov)
--
--
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: wr_BackupDataSizes <<<'

IF EXISTS (select * from sysobjects where name='wr_BackupDataSizes')
	drop procedure wr_BackupDataSizes
IF EXISTS (select * from GxQscripts where name='wr_BackupDataSizes')
	delete from GxQscripts where name = 'wr_BackupDataSizes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_BackupDataSizes')
	delete from GXDBVersions where aliasname = 'wr_BackupDataSizes'
GO
print '... Creating Procedure: wr_BackupDataSizes'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_BackupDataSizes
  @outTempTable VARCHAR(128),
  @requestGroupBy INT,
  @requestType INT,
  @requestFrequency INT,
  @requestNumOfSteps INT,
  @requestStartTime INT,
  @requestEndTime INT,
  @requestTreatWeekend INT,
  @doNotIncludeCurrentStep INT,
  @incLogDelClients INT,
  @predictionSteps INT,
  @patternNumber INT,
  @clientsXML NTEXT
AS
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
	SET NOCOUNT ON;
--DECLARE @outTempTable	            VARCHAR(128)    = ''
--DECLARE @requestGroupBy		    INT             = 2 -- 1:client, 2:agent, 3:storage, 4:group
--DECLARE @requestType		        INT             = 1 -- 0: time range, 1 - relatively
--DECLARE @requestFrequency	        INT             = 1 -- 1:day, 2:week, 3:month, 4:hour, 6:year
--DECLARE @requestNumOfSteps	    INT             = 2
--DECLARE @requestStartTime	        INT             = 0
--DECLARE @requestEndTime		    INT             = 0
--DECLARE @requestTreatWeekend	    INT             = 1
--DECLARE @incLogDelClients	        INT             = 0
--DECLARE @predictionSteps		    INT             = 2
--DECLARE @patternNumber		    INT             = 1
--DECLARE @doNotIncludeCurrentStep	INT             = 0
--DECLARE @clientsXML		        NVARCHAR(MAX)   = N'<BackupDataSizes_Request>
--											            <tree>
--												            <entity selectionType="1" commCellId="2" clientGroupId="0" clientId="0" />
--											            </tree>
--										             </BackupDataSizes_Request>'
DECLARE @debug INT = 0  -- print debug information
DECLARE @stats INT = 0  -- collect and print statistics
DECLARE @statsTempTime DATETIME -- variable used only when @stats > 0
IF OBJECT_ID('tempdb.dbo.#BDS__tmp_Stats')          IS NOT NULL DROP TABLE #BDS__tmp_Stats
IF OBJECT_ID('tempdb.dbo.#BDS__tmp_Clients')        IS NOT NULL DROP TABLE #BDS__tmp_Clients
IF OBJECT_ID('tempdb.dbo.#BDS__tmp_PeriodsRaw')     IS NOT NULL DROP TABLE #BDS__tmp_PeriodsRaw
IF OBJECT_ID('tempdb.dbo.#BDS__tmp_Periods')        IS NOT NULL DROP TABLE #BDS__tmp_Periods
IF OBJECT_ID('tempdb.dbo.#BDS__tmp_FirstLast')      IS NOT NULL DROP TABLE #BDS__tmp_FirstLast
IF OBJECT_ID('tempdb.dbo.#BDS__tmp_Jobs')           IS NOT NULL DROP TABLE #BDS__tmp_Jobs
IF OBJECT_ID('tempdb.dbo.#BDS__tmp_Aggregates')     IS NOT NULL DROP TABLE #BDS__tmp_Aggregates
IF OBJECT_ID('tempdb.dbo.#BDS__tmp_AggregatesPred') IS NOT NULL DROP TABLE #BDS__tmp_AggregatesPred
CREATE TABLE #BDS__tmp_Clients
(
    CommCellId          INT             NULL,
    CommCellName        NVARCHAR(1024)  NULL,
    ClientGroupId       INT             NULL,
    ClientGroupName     NVARCHAR(1024)  NULL,
    ClientID            INT             NULL,
    ClientName          NVARCHAR(1024)  NULL,
    AppTypeID           INT             NULL,
    Uninstalled         INT             null
)
CREATE TABLE #BDS__tmp_PeriodsRaw
(
	CommCellId		    INT,
	DayNum		        INT,
	DayRefStart	        DATETIME,
	DayRefEnd	        DATETIME,
	DayStart	        DATETIME,
	DayEnd		        DATETIME,
	Predicted	        INT,
	DayRefStartLocal	DATETIME,
	DayRefEndLocal		DATETIME,
)
CREATE TABLE #BDS__tmp_Periods
(
	CommCellId		    INT,
	DayNum		        INT,
	DayRefStart	        DATETIME,
	DayRefEnd	        DATETIME,
	DayStart	        DATETIME,
	DayEnd		        DATETIME,
	Predicted	        INT,
	DayRefStartLocal	DATETIME,
	DayRefEndLocal		DATETIME,
    DayRefStartUnix     INT,
    DayRefEndUnix       INT
)
CREATE TABLE #BDS__tmp_FirstLast
(
    CommCellId          INT,
    [first]             INT,
    [last]              INT
)
CREATE TABLE #BDS__tmp_Jobs
(
    CommCellId          INT,
    JobId               INT,
    ClientId            INT,
    AppTypeId           INT,
    BkpLevel            INT,
    StartTime           INT,
    FinishTime          INT,
    DataArchGrpId       INT,
    LogArchGrpId        INT,
    ApplicationSize     BIGINT,
    MediaSize           BIGINT,
    DataArchSize        BIGINT,
    LogArchSize         BIGINT
)
CREATE TABLE #BDS__tmp_Aggregates
(
    DayNo               INT,
    PeriodStart         INT,
    PeriodEnd           INT,
    CommCellId          INT,
    CommCellName        NVARCHAR(255),
    EntityId            INT,
    EntityName          NVARCHAR(255),
    AppFullDataSize     BIGINT,
    AppOtherDataSize    BIGINT,
    MediaFullDataSize   BIGINT,
    MediaOtherDataSize  BIGINT,
    AppTotalDataSize    BIGINT,
    MediaTotalDataSize  BIGINT,
    Predicted           INT
)
-- this table will be used for prediction, It will contain data based on which prediction will be made
-- and also rows for which values should be predicted.
-- this table will be re-populated for each commcell. In order to MovingForecast stored proc work properly
-- X must be a consecutive number starting from 1 assigned for earliest date
-- In order to maintain this reqirement(reseting seed every time data for new commcell comming in) on a next iteration
-- data from table !!! MUST NOT BE DELETED !!! -- i.e DO NOT USE : DELETE FROM #BDS__tmp_AggregatesPred
-- !!! ALWAYS TRUNCATE TABLE !!! i.e USE : TRUNCATE TABLE #BDS__tmp_AggregatesPred
CREATE TABLE #BDS__tmp_AggregatesPred
(
    X                   INT IDENTITY(1,1),
    DayNo               INT,
    PeriodStart         INT,
    PeriodEnd           INT,
    CommCellId          INT,
    CommCellName        NVARCHAR(255),
    EntityId            INT,
    EntityName          NVARCHAR(255),
    AppFullDataSize     BIGINT,
    AppOtherDataSize    BIGINT,
    MediaFullDataSize   BIGINT,
    MediaOtherDataSize  BIGINT,
    AppTotalDataSize    BIGINT,
    MediaTotalDataSize  BIGINT,
    Predicted           INT
)
--create stats table if necessary
IF @stats <> 0 BEGIN
	-- create table for statistics
	CREATE TABLE #BDS__tmp_Stats([Action] VARCHAR(50), timeSpentMili INT)
    -- enable statistics
	SET NOCOUNT ON
	SET STATISTICS IO ON
	SET STATISTICS TIME ON
END
-- first lets get list of the clients jobs for which needs to be processed
IF @stats <> 0 SET @statsTempTime = GetDate()
-- get list of the clients
EXEC dbo.wr_CellSelection @clientsXML, N'#BDS__tmp_Clients', 1, N'tree', 0, 0
-- stats
IF @stats <> 0 INSERT INTO #BDS__tmp_Stats VALUES ('clients list', datediff(millisecond, @statsTempTime, GetDate()))
IF @incLogDelClients = 0 BEGIN
    IF @stats <> 0 SET @statsTempTime = GetDate()
    -- delete uninstalled clients from the list of clients as requested
    DELETE  FROM #BDS__tmp_Clients WHERE   Uninstalled <> 0
    IF @stats <> 0 INSERT INTO #BDS__tmp_Stats VALUES ('clients list adjustment', datediff(millisecond, @statsTempTime, GetDate()))
END
-- debug
IF @debug <> 0 SELECT 'clients', * FROM #BDS__tmp_Clients
-- create list of time periods for each commcell.
-- each commcell can have its own day-start/day-end definition. So we have to create periods list for
-- each commcell separately
-- we can use cursor here without any problem because table we are going to iterate through is already
-- temporary, in-memory table
IF @stats <> 0 SET @statsTempTime = GetDate()
DECLARE @selectedCC INT
DECLARE existingCCs CURSOR FOR SELECT DISTINCT CommCellId FROM #BDS__tmp_Clients
OPEN existingCCs
FETCH NEXT FROM existingCCs INTO @selectedCC
WHILE @@FETCH_STATUS = 0 BEGIN
    EXEC dbo.wr_BuildDaysRange @selectedCC, '#BDS__tmp_PeriodsRaw', @requestType, @requestNumOfSteps, @requestFrequency, @requestStartTime, @requestEndTime, @requestTreatWeekend, 1, 1, 10, @predictionSteps, @doNotIncludeCurrentStep
    FETCH NEXT FROM existingCCs INTO @selectedCC
END
CLOSE existingCCs
DEALLOCATE existingCCs
-- next lets move data to working table, we also need unix time representation of DayRefStart and DayRefEnd
INSERT INTO #BDS__tmp_Periods
    SELECT  P.CommCellId, P.DayNum, P.DayRefStart, P.DayRefEnd, P.DayStart, P.DayEnd, P.Predicted, P.DayRefStartLocal, P.DayRefEndLocal,
            dbo.GetUnixTime(P.dayRefStart), dbo.GetUnixTime(P.DayRefEnd)
    FROM    #BDS__tmp_PeriodsRaw P
    ORDER   BY P.DayStart ASC
-- debug and stats
IF @stats <> 0 INSERT INTO #BDS__tmp_Stats VALUES ('periods', datediff(millisecond, @statsTempTime, GetDate()))
IF @debug <> 0 SELECT 'periods', * FROM #BDS__tmp_Periods
-- next we have to calculate overall periods boundaries for each commcell
IF @stats <> 0 SET @statsTempTime = GetDate()
INSERT INTO #BDS__tmp_FirstLast
    SELECT  P.CommCellId,
            MIN(P.DayRefStartUnix),
            MAX(P.DayRefEndUnix)
    FROM    #BDS__tmp_Periods P
    WHERE   (@doNotIncludeCurrentStep = 0) OR (P.Predicted = 0)
    GROUP   BY P.CommCellId
IF @stats <> 0 INSERT INTO #BDS__tmp_Stats VALUES ('first/last days', datediff(millisecond, @statsTempTime, GetDate()))
IF @debug <> 0 SELECT 'first/last daysdays', * FROM #BDS__tmp_FirstLast
-- Here we are ready to get list of the jobs which were performed on each commcell and which were started in specified
-- time period
-- there are two ways to get list of the jobs and size on media for each job. In some cases 2 steps (1. Get list of the jobs + 2. Update size on media for each job)
-- is faster then do everything in one step.
-- to test 2steps approach the following queries were examined
-- --
-- --     SELECT  J.commCellId, J.jobId, J.servStartDate, J.servEndDate, J.appType, J.bkpLevel, J.totalUncompBytes, 0
-- --     FROM    JMBkpStats J INNER JOIN #DataGrowth__tmp_MinMaxDays D ON J.CommCellId = D.CommCellId
-- --                          INNER JOIN APP_Application APP ON APP.id = J.appId
-- --                          INNER JOIN #DataGrowth__tmp_Clients CL ON CL.CommCellId = APP.origCCId AND CL.ClientID = APP.clientId AND CL.AppTypeID = APP.appTypeId
-- --     WHERE   J.servStartDate BETWEEN D.MinDateUTC AND D.MaxDateUTC
-- --
-- --     UPDATE  #DataGrowth__tmp_Jobs
-- --     SET     MediaSize = ISNULL((SELECT SUM(physicalSize) FROM archChunkMapping WHERE archFileId = F.id), 0)
-- --     FROM    archFile F
-- --     WHERE   F.commCellId = #DataGrowth__tmp_Jobs.CommCellId AND F.jobId = #DataGrowth__tmp_Jobs.jobId
-- --
-- to test 1step approach the following query was examined
-- --
----      SELECT  J.commCellId, J.jobId, J.servStartDate, J.servEndDate, J.appType, J.bkpLevel, J.totalUncompBytes,
----              ISNULL((SELECT SUM(ISNULL(physicalSize, 0)) FROM archChunkMapping WHERE archFileId = F.id), 0)
----      FROM    JMBkpStats J INNER JOIN #DataGrowth__tmp_MinMaxDays D ON J.CommCellId = D.CommCellId
----                           INNER JOIN APP_Application APP ON APP.id = J.appId
----                           INNER JOIN #DataGrowth__tmp_Clients CL ON CL.CommCellId = APP.origCCId AND CL.ClientID = APP.clientId AND CL.AppTypeID = APP.appTypeId
----                           LEFT  JOIN archFile F ON F.CommCellId = J.CommCellId AND F.jobId = J.jobId
----      WHERE   J.servStartDate BETWEEN D.MinDateUTC AND D.MaxDateUTC
-- --
-- results are:
-- -- for 1st approach
-- -- -- Table 'Worktable'. 			      Scan count 0,  logical reads 0,    physical reads 0,  read-ahead reads 0,    lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- -- -- Table 'JMBkpStats'. 			      Scan count 1,  logical reads 6980, physical reads 19, read-ahead reads 6958, lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- -- -- Table 'APP_Application'. 		      Scan count 1,  logical reads 47,   physical reads 0,  read-ahead reads 0,    lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- -- -- Table '#DataGrowth__tmp_Clients'. 	  Scan count 1,  logical reads 13,   physical reads 0,  read-ahead reads 0,    lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- -- -- Table '#DataGrowth__tmp_MinMaxDays'. Scan count 1,  logical reads 1,    physical reads 0,  read-ahead reads 0,    lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- -- -- Table 'archFile'. 		              Scan count 1,  logical reads 6,    physical reads 2,  read-ahead reads 24,   lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- -- -- Table 'archChunkMapping'. 		      Scan count 27, logical reads 108,  physical reads 4,  read-ahead reads 0,    lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- -- -- Table '#DataGrowth__tmp_Jobs'. 	  Scan count 1,  logical reads 757,  physical reads 0,  read-ahead reads 0,    lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- -- --
-- -- -- Server Execution Times:
-- -- --    CPU time = 3531 + 78 ms,  elapsed time = 7244 + 175 ms.
-- -- --
-- -- -- client list			    706
-- -- -- time period for commcells	1040
-- -- -- min/max days			    6
-- -- -- jobs				        7796
-- --
-- -- for 2nd approach
-- -- -- Table 'Worktable'. 			      Scan count 0, logical reads 0,    physical reads 0,  read-ahead reads 0,    lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- -- -- Table 'JMBkpStats'. 			      Scan count 1, logical reads 6980, physical reads 19, read-ahead reads 6958, lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- -- -- Table 'APP_Application'. 		      Scan count 1, logical reads 47,   physical reads 0,  read-ahead reads 0,    lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- -- -- Table '#DataGrowth__tmp_Clients'. 	  Scan count 1, logical reads 13,   physical reads 0,  read-ahead reads 0,    lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- -- -- Table '#DataGrowth__tmp_MinMaxDays'. Scan count 1, logical reads 1,    physical reads 0,  read-ahead reads 0,    lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- -- -- Table 'archFile'.                    Scan count 1, logical reads 6,    physical reads 2,  read-ahead reads 24,   lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- -- -- Table 'archChunkMapping'.            Scan count 1, logical reads 32,   physical reads 2,  read-ahead reads 33,   lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
-- -- --
-- -- -- Server Execution Times:
-- -- --    CPU time = 3359 ms,  elapsed time = 5880 ms.
-- -- --
-- -- -- client list			    670
-- -- -- time period for commcells	1163
-- -- -- min/max days			    6
-- -- -- jobs				        6040
-- Looks like in this case it is faster to get everything in one query
IF @stats <> 0 SET @statsTempTime = GetDate()
INSERT INTO #BDS__tmp_Jobs
    SELECT  J.commCellId, J.jobId, App.clientId, J.appType, J.bkpLevel, J.servStartDate, J.servEndDate, APP.dataArchGrpID, APP.logArchGrpID, J.totalUncompBytes,
            -- MediaSize
            ISNULL((
                SELECT  SUM(ACM.physicalSize)
                FROM    archChunkMapping ACM INNER JOIN archFile AF ON AF.commCellId = ACM.commCellId AND AF.id = ACM.archFileId
                WHERE       AF.commCellId = J.commCellId
                        AND AF.jobId = J.jobId
            ), 0),
            -- LogDataSize
            ISNULL((
                SELECT  SUM(AFC.physicalSize)
                FROM    archFileCopy AFC INNER JOIN archFile AF ON AF.commCellId = AFC.commCellId AND AF.id = AFC.archFileId
                WHERE       AF.commCellId = J.commCellId
                        AND AF.jobId = J.jobId
                        AND AF.fileType <> 4 -- CVA_DATATYPE_DATA, CVA_DATATYPE_INDEX, CVA_DATATYPE_INDEXFCS, CVA_DATATYPE_FILTER, CVA_DATATYPE_SNAPMETADATA, CVA_DATATYPE_COMPONENT_INDEX, CVA_DATATYPE_DB_INDEX, CVA_DATATYPE_INDEX_REPLACING, CVA_DATATYPE_INDEX_REPLACED, CVA_DATATYPE_DMSQLLITE, CVA_DATATYPE_SNAP_COMPONENT_INDEX
                        AND AF.archGroupId = APP.dataArchGrpID
            ), 0),
            -- LogArchSize
            ISNULL((
                SELECT  SUM(AFC.physicalSize)
                FROM    archFileCopy AFC INNER JOIN archFile AF ON AF.commCellId = AFC.commCellId AND AF.id = AFC.archFileId
                WHERE       AF.commCellId = J.commCellId
                        AND AF.jobId = J.jobId
                        AND AF.fileType = 4 -- CVA_DATATYPE_LOGS
                        AND AF.archGroupId = APP.logArchGrpID
            ), 0)
    FROM    JMBkpStats J INNER JOIN #BDS__tmp_FirstLast D ON J.CommCellId = D.CommCellId
                         INNER JOIN APP_Application APP ON APP.id = J.appId
    WHERE       J.servStartDate BETWEEN D.[first] AND D.[last]
            AND EXISTS (SELECT * FROM #BDS__tmp_Clients CL WHERE CL.AppTypeID = J.appType AND CL.ClientID = APP.clientId AND CL.CommCellId = J.commCellId)
IF @stats <> 0 INSERT INTO #BDS__tmp_Stats VALUES ('jobs', datediff(millisecond, @statsTempTime, GetDate()))
IF @debug <> 0 SELECT 'job', * FROM #BDS__tmp_Jobs
-- lets calculate aggregates with groupping defined by @requestGroupBy
IF @stats <> 0 SET @statsTempTime = GetDate()
IF @requestGroupBy = 1 BEGIN -- client
    INSERT INTO #BDS__tmp_Aggregates
    SELECT DISTINCT
            P.DayNum, dbo.GetUnixTime(P.DayStart), dbo.GetUnixTime(P.DayEnd), P.CommCellId, C.CommCellName, C.ClientID, C.ClientName,
            ISNULL((    SELECT  CAST(ROUND((SUM(ISNULL(JAF.ApplicationSize, 0)) * 1.0 / 1024.0) / 1024.0, 0) AS BIGINT)
                        FROM    #BDS__tmp_Jobs JAF
                        WHERE       JAF.CommCellId = P.CommCellId
                                AND JAF.ClientId   = C.ClientID
                                AND dbo.IsBackupLevelFull(JAF.BkpLevel) = 1
                                AND JAF.StartTime BETWEEN P.DayRefStartUnix AND P.DayRefEndUnix), 0),
            ISNULL((    SELECT  CAST(ROUND((SUM(ISNULL(JAF.ApplicationSize, 0)) * 1.0 / 1024.0) / 1024.0, 0) AS BIGINT)
                        FROM    #BDS__tmp_Jobs JAF
                        WHERE       JAF.CommCellId = P.CommCellId
                                AND JAF.ClientId   = C.ClientID
                                AND dbo.IsBackupLevelFull(JAF.BkpLevel) = 0
                                AND JAF.StartTime BETWEEN P.DayRefStartUnix AND P.DayRefEndUnix), 0),
            ISNULL((    SELECT  CAST(ROUND((SUM(ISNULL(JAF.MediaSize, 0)) * 1.0 / 1024.0) / 1024.0, 0) AS BIGINT)
                        FROM    #BDS__tmp_Jobs JAF
                        WHERE       JAF.CommCellId = P.CommCellId
                                AND JAF.ClientId   = C.ClientID
                                AND dbo.IsBackupLevelFull(JAF.BkpLevel) = 1
                                AND JAF.StartTime BETWEEN P.DayRefStartUnix AND P.DayRefEndUnix), 0),
            ISNULL((    SELECT  CAST(ROUND((SUM(ISNULL(JAF.MediaSize, 0)) * 1.0 / 1024.0) / 1024.0, 0) AS BIGINT)
                        FROM    #BDS__tmp_Jobs JAF
                        WHERE       JAF.CommCellId = P.CommCellId
                                AND JAF.ClientId   = C.ClientID
                                AND dbo.IsBackupLevelFull(JAF.BkpLevel) = 0
                                AND JAF.StartTime BETWEEN P.DayRefStartUnix AND P.DayRefEndUnix), 0),
            0, 0, P.Predicted
    FROM    #BDS__tmp_Periods P INNER JOIN #BDS__tmp_Clients C ON C.CommCellId = P.CommCellId
END
IF @requestGroupBy = 2 BEGIN -- agent
    INSERT INTO #BDS__tmp_Aggregates
    SELECT DISTINCT
            P.DayNum, dbo.GetUnixTime(P.DayStart), dbo.GetUnixTime(P.DayEnd), P.CommCellId, C.CommCellName, C.AppTypeID, '',
            ISNULL((    SELECT  CAST(ROUND((SUM(ISNULL(JAF.ApplicationSize, 0)) * 1.0 / 1024.0) / 1024.0, 0) AS BIGINT)
                        FROM    #BDS__tmp_Jobs JAF
                        WHERE       JAF.CommCellId = P.CommCellId
                                AND JAF.AppTypeId   = C.AppTypeID
                                AND dbo.IsBackupLevelFull(JAF.BkpLevel) = 1
                                AND JAF.StartTime BETWEEN P.DayRefStartUnix AND P.DayRefEndUnix), 0),
            ISNULL((    SELECT  CAST(ROUND((SUM(ISNULL(JAF.ApplicationSize, 0)) * 1.0 / 1024.0) / 1024.0, 0) AS BIGINT)
                        FROM    #BDS__tmp_Jobs JAF
                        WHERE       JAF.CommCellId = P.CommCellId
                                AND JAF.AppTypeId   = C.AppTypeID
                                AND dbo.IsBackupLevelFull(JAF.BkpLevel) = 0
                                AND JAF.StartTime BETWEEN P.DayRefStartUnix AND P.DayRefEndUnix), 0),
            ISNULL((    SELECT  CAST(ROUND((SUM(ISNULL(JAF.MediaSize, 0)) * 1.0 / 1024.0) / 1024.0, 0) AS BIGINT)
                        FROM    #BDS__tmp_Jobs JAF
                        WHERE       JAF.CommCellId = P.CommCellId
                                AND JAF.AppTypeId   = C.AppTypeID
                                AND dbo.IsBackupLevelFull(JAF.BkpLevel) = 1
                                AND JAF.StartTime BETWEEN P.DayRefStartUnix AND P.DayRefEndUnix), 0),
            ISNULL((    SELECT  CAST(ROUND((SUM(ISNULL(JAF.MediaSize, 0)) * 1.0 / 1024.0) / 1024.0, 0) AS BIGINT)
                        FROM    #BDS__tmp_Jobs JAF
                        WHERE       JAF.CommCellId = P.CommCellId
                                AND JAF.AppTypeId   = C.AppTypeID
                                AND dbo.IsBackupLevelFull(JAF.BkpLevel) = 0
                                AND JAF.StartTime BETWEEN P.DayRefStartUnix AND P.DayRefEndUnix), 0),
            0, 0, P.Predicted
    FROM    #BDS__tmp_Periods P INNER JOIN #BDS__tmp_Clients C ON C.CommCellId = P.CommCellId
    -- lets provide names for data agents
    UPDATE #BDS__tmp_Aggregates
    SET EntityName = (SELECT [name] FROM APP_iDAType WHERE type = #BDS__tmp_Aggregates.EntityId)
END
IF @requestGroupBy = 3 BEGIN -- storage
    INSERT INTO #BDS__tmp_Aggregates
    SELECT DISTINCT
            P.DayNum, dbo.GetUnixTime(P.DayStart), dbo.GetUnixTime(P.DayEnd), P.CommCellId, C.CommCellName, AG.id, AG.name,
            ISNULL((    SELECT  CAST(ROUND((SUM(ISNULL(JAF.ApplicationSize, 0)) * 1.0 / 1024.0) / 1024.0, 0) AS BIGINT)
                        FROM    #BDS__tmp_Jobs JAF
                        WHERE       JAF.CommCellId = P.CommCellId
                                AND JAF.DataArchGrpId = AG.id OR JAF.LogArchGrpId = AG.id
                                AND dbo.IsBackupLevelFull(JAF.BkpLevel) = 1
                                AND JAF.StartTime BETWEEN P.DayRefStartUnix AND P.DayRefEndUnix), 0),
            ISNULL((    SELECT  CAST(ROUND((SUM(ISNULL(JAF.ApplicationSize, 0)) * 1.0 / 1024.0) / 1024.0, 0) AS BIGINT)
                        FROM    #BDS__tmp_Jobs JAF
                        WHERE       JAF.CommCellId = P.CommCellId
                                AND JAF.DataArchGrpId = AG.id OR JAF.LogArchGrpId = AG.id
                                AND dbo.IsBackupLevelFull(JAF.BkpLevel) = 0
                                AND JAF.StartTime BETWEEN P.DayRefStartUnix AND P.DayRefEndUnix), 0),
            ISNULL((    SELECT  CAST(ROUND((SUM(ISNULL( JAF.DataArchSize, 0)) * 1.0 / 1024.0) / 1024.0, 0) AS BIGINT)
                        FROM    #BDS__tmp_Jobs JAF
                        WHERE       JAF.CommCellId = P.CommCellId
                                AND JAF.DataArchGrpId = AG.id
                                AND dbo.IsBackupLevelFull(JAF.BkpLevel) = 1
                                AND JAF.StartTime BETWEEN P.DayRefStartUnix AND P.DayRefEndUnix), 0)
            +
            ISNULL((    SELECT  CAST(ROUND((SUM(ISNULL( JAF.LogArchSize, 0)) * 1.0 / 1024.0) / 1024.0, 0) AS BIGINT)
                        FROM    #BDS__tmp_Jobs JAF
                        WHERE       JAF.CommCellId = P.CommCellId
                                AND JAF.LogArchGrpId = AG.id
                                AND dbo.IsBackupLevelFull(JAF.BkpLevel) = 1
                                AND JAF.StartTime BETWEEN P.DayRefStartUnix AND P.DayRefEndUnix), 0),
            ISNULL((    SELECT  CAST(ROUND((SUM(ISNULL( JAF.DataArchSize, 0)) * 1.0 / 1024.0) / 1024.0, 0) AS BIGINT)
                        FROM    #BDS__tmp_Jobs JAF
                        WHERE       JAF.CommCellId = P.CommCellId
                                AND JAF.DataArchGrpId = AG.id
                                AND dbo.IsBackupLevelFull(JAF.BkpLevel) = 0
                                AND JAF.StartTime BETWEEN P.DayRefStartUnix AND P.DayRefEndUnix), 0)
            +
            ISNULL((    SELECT  CAST(ROUND((SUM(ISNULL( JAF.LogArchSize, 0)) * 1.0 / 1024.0) / 1024.0, 0) AS BIGINT)
                        FROM    #BDS__tmp_Jobs JAF
                        WHERE       JAF.CommCellId = P.CommCellId
                                AND JAF.LogArchGrpId = AG.id
                                AND dbo.IsBackupLevelFull(JAF.BkpLevel) = 0
                                AND JAF.StartTime BETWEEN P.DayRefStartUnix AND P.DayRefEndUnix), 0),
            0, 0, P.Predicted
    FROM    #BDS__tmp_Periods P INNER JOIN #BDS__tmp_Clients C ON C.CommCellId = P.CommCellId
                                INNER JOIN archGroup AG ON (CASE AG.origCCcommCellID WHEN 0 THEN 2 ELSE AG.origCCcommCellID END) = P.CommCellId
    WHERE   AG.SIBlockSizeKB <> 0
END
IF @requestGroupBy = 4 BEGIN -- group
    -- there are two ways to get list of groups which are containing clients for which jobs were performed
    -- -- first way
    -- --
    -- --    SELECT  DISTINCT id AS ClientGroupId, [name] AS ClientGroupName, origCCId
    -- --    FROM    APP_ClientGroup CG INNER JOIN APP_ClientGroupAssoc CGA ON CGA.clientGroupId = CG.id
    -- --    WHERE   CGA.clientId IN (SELECT DISTINCT clientId FROM #BDS__tmp_Clients)
    -- --
    -- -- second way
    -- --
    -- --   SELECT  id AS ClientGroupId, [name] AS ClientGroupName, origCCId
    -- --   FROM    APP_ClientGroup CG INNER JOIN APP_ClientGroupAssoc CGA ON CGA.clientGroupId = CG.id
    -- --                              INNER JOIN #BDS__tmp_Clients T on T.clientId = CGA.clientId
    -- --
    -- statistics for those methods are
    -- -- first way
    -- --   Table 'Worktable'.            Scan count 1, logical reads 7, physical reads 0, read-ahead reads 0, lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
    -- --   Table 'APP_ClientGroupAssoc'. Scan count 1, logical reads 3, physical reads 0, read-ahead reads 0, lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
    -- --   Table '#BDS__tmp_Clients'.    Scan count 1, logical reads 1, physical reads 0, read-ahead reads 0, lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
    -- --   Table 'APP_ClientGroup'.      Scan count 1, logical reads 3, physical reads 0, read-ahead reads 0, lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
    -- --
    -- --    SQL Server Execution Times:
    -- --      CPU time = 0 ms,  elapsed time = 2 ms.
    -- --
    -- --   second way
    -- --
    -- --   Table 'Worktable'.            Scan count 0, logical reads 0, physical reads 0, read-ahead reads 0, lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
    -- --   Table 'APP_ClientGroupAssoc'. Scan count 1, logical reads 3, physical reads 0, read-ahead reads 0, lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
    -- --   Table '#BDS__tmp_Clients'.    Scan count 1, logical reads 1, physical reads 0, read-ahead reads 0, lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
    -- --   Table 'APP_ClientGroup'.      Scan count 0, logical reads 4, physical reads 0, read-ahead reads 0, lob logical reads 0, lob physical reads 0, lob read-ahead reads 0.
    -- --
    -- --    SQL Server Execution Times:
    -- --      CPU time = 0 ms,  elapsed time = 0 ms.
    -- -- ----------------------------
    -- -- Use second method
    -- --
    INSERT INTO #BDS__tmp_Aggregates
    SELECT DISTINCT
            P.DayNum, dbo.GetUnixTime(P.DayStart), dbo.GetUnixTime(P.DayEnd), P.CommCellId, '', GR.ClientGroupId, GR.ClientGroupName,
            ISNULL((    SELECT  CAST(ROUND((SUM(ISNULL(JAF.ApplicationSize, 0)) * 1.0 / 1024.0) / 1024.0, 0) AS BIGINT)
                        FROM    #BDS__tmp_Jobs JAF
                        WHERE       JAF.CommCellId = P.CommCellId
                                AND JAF.ClientId IN (SELECT ClientID FROM APP_ClientGroupAssoc WHERE clientGroupId = GR.ClientGroupId)
                                AND dbo.IsBackupLevelFull(JAF.BkpLevel) = 1
                                AND JAF.StartTime BETWEEN P.DayRefStartUnix AND P.DayRefEndUnix), 0),
            ISNULL((    SELECT  CAST(ROUND((SUM(ISNULL(JAF.MediaSize, 0)) * 1.0 / 1024.0) / 1024.0, 0) AS BIGINT)
                        FROM    #BDS__tmp_Jobs JAF
                        WHERE       JAF.CommCellId = P.CommCellId
                                AND JAF.ClientId IN (SELECT ClientID FROM APP_ClientGroupAssoc WHERE clientGroupId = GR.ClientGroupId)
                                AND dbo.IsBackupLevelFull(JAF.BkpLevel) = 1
                                AND JAF.StartTime BETWEEN P.DayRefStartUnix AND P.DayRefEndUnix), 0),
            ISNULL((    SELECT  CAST(ROUND((SUM(ISNULL(JAF.ApplicationSize, 0)) * 1.0 / 1024.0) / 1024.0, 0) AS BIGINT)
                        FROM    #BDS__tmp_Jobs JAF
                        WHERE       JAF.CommCellId = P.CommCellId
                                AND JAF.ClientId IN (SELECT ClientID FROM APP_ClientGroupAssoc WHERE clientGroupId = GR.ClientGroupId)
                                AND dbo.IsBackupLevelFull(JAF.BkpLevel) = 0
                                AND JAF.StartTime BETWEEN P.DayRefStartUnix AND P.DayRefEndUnix), 0),
            ISNULL((    SELECT  CAST(ROUND((SUM(ISNULL(JAF.MediaSize, 0)) * 1.0 / 1024.0) / 1024.0, 0) AS BIGINT)
                        FROM    #BDS__tmp_Jobs JAF
                        WHERE       JAF.CommCellId = P.CommCellId
                                AND JAF.ClientId IN (SELECT ClientID FROM APP_ClientGroupAssoc WHERE clientGroupId = GR.ClientGroupId)
                                AND dbo.IsBackupLevelFull(JAF.BkpLevel) = 0
                                AND JAF.StartTime BETWEEN P.DayRefStartUnix AND P.DayRefEndUnix), 0),
            0, 0, P.Predicted
    FROM    #BDS__tmp_Periods P INNER JOIN (SELECT  DISTINCT id AS ClientGroupId, [name] AS ClientGroupName, origCCId AS CommCellId
                                            FROM    APP_ClientGroup CG INNER JOIN APP_ClientGroupAssoc CGA ON CGA.clientGroupId = CG.id
                                                                       INNER JOIN #BDS__tmp_Clients CL ON CL.ClientID = CGA.clientId
                                            UNION
                                            SELECT  DISTINCT CL.ClientGroupId, CL.ClientGroupName, CL.CommCellId
                                            FROM    #BDS__tmp_Clients CL
                                            WHERE   CL.ClientGroupId <> 0 ) GR ON GR.CommCellId = P.CommCellId
END
UPDATE  #BDS__tmp_Aggregates
SET     AppTotalDataSize    = #BDS__tmp_Aggregates.AppFullDataSize + #BDS__tmp_Aggregates.AppOtherDataSize,
        MediaTotalDataSize  = #BDS__tmp_Aggregates.MediaFullDataSize + #BDS__tmp_Aggregates.MediaOtherDataSize
IF @stats <> 0 INSERT INTO #BDS__tmp_Stats VALUES ('aggregates', datediff(millisecond, @statsTempTime, GetDate()))
IF @debug <> 0 SELECT 'aggregates', * FROM #BDS__tmp_Aggregates
/*
*/
IF @predictionSteps > 0 BEGIN
    DECLARE existingCCs CURSOR FOR SELECT DISTINCT CommCellId FROM #BDS__tmp_Clients
    OPEN existingCCs
    FETCH NEXT FROM existingCCs INTO @selectedCC
    WHILE @@FETCH_STATUS = 0 BEGIN
        IF @stats <> 0 SET @statsTempTime = GetDate()
        -- !!! TRUCATE TABLE : see comment at the beginnig of the script before #BDS__tmp_AggregatesPred table definition
        TRUNCATE TABLE #BDS__tmp_AggregatesPred
        -- get information for this commcell only
        INSERT INTO #BDS__tmp_AggregatesPred (DayNo, PeriodStart, PeriodEnd, CommCellId, CommCellName, EntityId,
                                              EntityName, AppFullDataSize, AppOtherDataSize, MediaFullDataSize,
                                              MediaOtherDataSize, AppTotalDataSize, MediaTotalDataSize, Predicted)
            SELECT  *
            FROM    #BDS__tmp_Aggregates
            WHERE   CommCellId = @selectedCC
            ORDER   BY PeriodStart ASC
        -- number of items which are containig actual data
        DECLARE @numPredictionTotal INT = (SELECT TOP 1 X FROM #BDS__tmp_AggregatesPred WHERE Predicted = 0 ORDER BY PeriodStart DESC)
        IF @numPredictionTotal IS NOT NULL AND @numPredictionTotal > 0 AND @patternNumber > 0 BEGIN
            -- application data
            EXEC wr_ForecastMovAvg 0/*@debug*/, '#BDS__tmp_AggregatesPred', @patternNumber, @numPredictionTotal,
	                'EntityId', 'EntityId', 'AppFullDataSize', NULL, 'AppOtherDataSize', NULL
            -- media data
            EXEC wr_ForecastMovAvg 0/*@debug*/, '#BDS__tmp_AggregatesPred', @patternNumber, @numPredictionTotal,
	                'EntityId', 'EntityId', 'MediaFullDataSize', NULL, 'MediaOtherDataSize', NULL
            -- take care of negative prediction
		    UPDATE	#BDS__tmp_AggregatesPred
		    SET	AppFullDataSize = ISNULL(
					CASE WHEN AppFullDataSize > 0 THEN AppFullDataSize
					ELSE 	(SELECT MIN(AppFullDataSize) FROM #BDS__tmp_AggregatesPred T
						 WHERE 	#BDS__tmp_AggregatesPred.EntityID = T.EntityID
						 	AND T.AppFullDataSize > 0 AND #BDS__tmp_AggregatesPred.X % @patternNumber = T.X % @patternNumber)
					END, 0),
			    AppOtherDataSize = ISNULL(
					CASE WHEN AppOtherDataSize > 0 THEN AppOtherDataSize
					ELSE 	(SELECT MIN(AppOtherDataSize) FROM #BDS__tmp_AggregatesPred T
						 WHERE 	#BDS__tmp_AggregatesPred.EntityID = T.EntityID
						 	AND T.AppFullDataSize > 0 AND #BDS__tmp_AggregatesPred.X % @patternNumber = T.X % @patternNumber)
					END, 0),
			    MediaFullDataSize = ISNULL(
					CASE WHEN MediaFullDataSize > 0 THEN MediaFullDataSize
					ELSE 	(SELECT MIN(MediaFullDataSize) FROM #BDS__tmp_AggregatesPred T
						 WHERE 	#BDS__tmp_AggregatesPred.EntityID = T.EntityID
						 	AND T.AppFullDataSize > 0 AND #BDS__tmp_AggregatesPred.X % @patternNumber = T.X % @patternNumber)
					END, 0),
			    MediaOtherDataSize = ISNULL(
					CASE WHEN MediaOtherDataSize > 0 THEN MediaOtherDataSize
					ELSE 	(SELECT MIN(MediaOtherDataSize) FROM #BDS__tmp_AggregatesPred T
						 WHERE 	#BDS__tmp_AggregatesPred.EntityID = T.EntityID
						 	AND T.AppFullDataSize > 0 AND #BDS__tmp_AggregatesPred.X % @patternNumber = T.X % @patternNumber)
					END, 0)
		    WHERE	X > @numPredictionTotal AND (AppFullDataSize <= 0 OR AppOtherDataSize <= 0 OR MediaFullDataSize <= 0 OR MediaOtherDataSize <= 0)
            -- move predicted data back to #DataGrowth__tmp_Aggregates table
            UPDATE #BDS__tmp_Aggregates
            SET    AppFullDataSize  = ISNULL(S.AppFullDataSize, 0),
                   AppOtherDataSize = ISNULL(S.AppOtherDataSize, 0),
                   MediaFullDataSize  = ISNULL(S.MediaFullDataSize, 0),
                   MediaOtherDataSize = ISNULL(S.MediaOtherDataSize, 0)
            FROM   #BDS__tmp_AggregatesPred S
            WHERE      #BDS__tmp_Aggregates.DayNo = S.DayNo
                   AND #BDS__tmp_Aggregates.PeriodStart = S.PeriodStart
                   AND #BDS__tmp_Aggregates.PeriodEnd = S.PeriodEnd
                   AND #BDS__tmp_Aggregates.CommCellId = S.CommCellId
                   AND #BDS__tmp_Aggregates.EntityId = S.EntityId
                   AND #BDS__tmp_Aggregates.Predicted = 1
        END
        -- statistics
        IF @stats <> 0 INSERT INTO #BDS__tmp_Stats VALUES ('predictions for ' + CAST(@selectedCC AS NVARCHAR(24)), datediff(millisecond, @statsTempTime, GetDate()))
        -- get next one
        FETCH NEXT FROM existingCCs INTO @selectedCC
    END
    CLOSE existingCCs
    DEALLOCATE existingCCs
    IF @debug <> 0 SELECT 'predictions', * FROM #BDS__tmp_Aggregates WHERE Predicted = 1
END
IF @stats <> 0 BEGIN
    IF @debug <> 0 SELECT * FROM #BDS__tmp_Stats
    IF OBJECT_ID('tempdb.dbo.#BDS__tmp_Stats') IS NOT NULL DROP TABLE #BDS__tmp_Stats
END
-- finally move data from temporary to output table
IF @outTempTable IS NOT NULL AND LEN(@outTempTable) > 0 BEGIN
    EXEC ( 'INSERT INTO ' + @outTempTable + ' SELECT * FROM #BDS__tmp_Aggregates' )
END
-- yah-o-o-oo!..
IF OBJECT_ID('tempdb.dbo.#BDS__tmp_Stats')          IS NOT NULL DROP TABLE #BDS__tmp_Stats
IF OBJECT_ID('tempdb.dbo.#BDS__tmp_Clients')        IS NOT NULL DROP TABLE #BDS__tmp_Clients
IF OBJECT_ID('tempdb.dbo.#BDS__tmp_PeriodsRaw')     IS NOT NULL DROP TABLE #BDS__tmp_PeriodsRaw
IF OBJECT_ID('tempdb.dbo.#BDS__tmp_Periods')        IS NOT NULL DROP TABLE #BDS__tmp_Periods
IF OBJECT_ID('tempdb.dbo.#BDS__tmp_FirstLast')      IS NOT NULL DROP TABLE #BDS__tmp_FirstLast
IF OBJECT_ID('tempdb.dbo.#BDS__tmp_Jobs')           IS NOT NULL DROP TABLE #BDS__tmp_Jobs
IF OBJECT_ID('tempdb.dbo.#BDS__tmp_Aggregates')     IS NOT NULL DROP TABLE #BDS__tmp_Aggregates
IF OBJECT_ID('tempdb.dbo.#BDS__tmp_AggregatesPred') IS NOT NULL DROP TABLE #BDS__tmp_AggregatesPred
GO

IF EXISTS (select * from GxQscripts where name = 'wr_BackupDataSizes')
	delete from GxQscripts where name = 'wr_BackupDataSizes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_BackupDataSizes')
	delete from GXDBVersions where aliasname = 'wr_BackupDataSizes'
GO

insert into GXDBVersions values(2, 'wr_BackupDataSizes',  '00010005000000000000', 'wr_BackupDataSizes', '00010005000000000000')
GO

