

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/wr_AuditReport.sp] ---------- 

-- -----------------------------------------------------------------------------------------------------------
-- Copyright (c) 1998  CommVault Systems, Inc.                                            All rights reserved.
--                                                                                        --------------------
--
-- This is unpublished proprietary source code of CommVault Systems, Inc. The copyright notice above does not
-- evidence any actual or intended publication of such source code.
-- -----------------------------------------------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/wr_AuditReport.sp,v $ $Id: wr_AuditReport.sp,v 1.5.2.3 2020/06/30 10:46:21 vmishra Exp $";
-- -----------------------------------------------------------------------------------------------------------
-- Author:		David Scott
-- Create date: 09/11/2012
-- Description:	returns information for the audit report
-- Parameters :
-- -----------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='wr_AuditReport')
BEGIN
	print '>>> Drop Stored Procedure: wr_AuditReport <<<'
	drop procedure wr_AuditReport
END
IF EXISTS (select * from GxQscripts where name='wr_AuditReport')
	delete from GxQscripts where name = 'wr_AuditReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_AuditReport')
	delete from GXDBVersions where aliasname = 'wr_AuditReport'
GO
print '... Creating Procedure: wr_AuditReport'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure wr_AuditReport
  @input XML,
  @userId INT 
AS
  DECLARE @o_ReportData NVARCHAR(MAX);
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE  @timeFrameType    INT
DECLARE  @frequency        INT
DECLARE  @numberOfPeriods  INT
DECLARE  @reqStartTime     BIGINT
DECLARE  @reqEndTime       BIGINT
-- same as @svrInfo
DECLARE  @lowLevel	   INT
-- same as @svrMinor
DECLARE  @mediumLevel	   INT
-- same as @svrMajor
DECLARE  @highLevel	   INT
-- same as @svrCritical
DECLARE  @criticalLevel	   INT
DECLARE  @includeAllEntities	   INT
DECLARE  @groupBy	   INT
DECLARE  @distribution	   INT
DECLARE  @searchString     NVARCHAR(MAX)
DECLARE  @reportFilter                NVARCHAR(MAX)
DECLARE  @language                NVARCHAR(MAX)
DECLARE  @country                NVARCHAR(MAX)
--DECLARE @input XML='<WebReport_AuditTrailReportReq timeFrameType="2"><users val="14" /><users val="18" /><galaxyUserGroups val="12" /><galaxyUserGroups val="16" /></WebReport_AuditTrailReportReq>'
DECLARE @userOutput XML
DECLARE @userGroupsOutput XML
DECLARE @externalUserGroupOutput XML
DECLARE @feedIntoEvGuiAuditGetMsg_i_userIdList XML
DECLARE  @includeAudit	   INT
DECLARE  @includeEvent	   INT
-- event declarations
DECLARE @locId			integer
DECLARE @jobId			integer
DECLARE @svrInfo		integer
DECLARE @svrMinor		integer
DECLARE @svrMajor		integer
DECLARE @svrCritical		integer
DECLARE @tblSeverity		TABLE (t_severity int)
DECLARE @tblClients		TABLE (t_clId int)
DECLARE @tblEventMsgs		TABLE (	Id		int,
					jobId		int,
					severity	int,
					time		int,
					subsystem	varchar(128),
					client		varchar(128),
					messageId   int,
					msgText		nvarchar(4000))
DECLARE @tblMsgText		TABLE (	t_Id		int,
					t_msgText	nvarchar(4000))
SET @timeFrameType = @input.value('/WebReport_AuditTrailReportReq[1]/@timeFrameType', 'int')
SET @jobId = @input.value('/WebReport_AuditTrailReportReq[1]/@jobID', 'int')
SET @frequency = @input.value('/WebReport_AuditTrailReportReq[1]/@frequency', 'int')
SET @numberOfPeriods = @input.value('/WebReport_AuditTrailReportReq[1]/@numberOfPeriods', 'int')
SET @reqStartTime = @input.value('/WebReport_AuditTrailReportReq[1]/@startTime', 'int')
SET @reqEndTime = @input.value('/WebReport_AuditTrailReportReq[1]/@endTime', 'int')
SET @lowLevel = @input.value('/WebReport_AuditTrailReportReq[1]/@lowLevel', 'int')
SET @mediumLevel = @input.value('/WebReport_AuditTrailReportReq[1]/@mediumLevel', 'int')
SET @highLevel = @input.value('/WebReport_AuditTrailReportReq[1]/@highLevel', 'int')
SET @criticalLevel = @input.value('/WebReport_AuditTrailReportReq[1]/@criticalLevel', 'int')
SET @includeAllEntities = @input.value('/WebReport_AuditTrailReportReq[1]/@includeAllEntities', 'int')
SET @groupBy = @input.value('/WebReport_AuditTrailReportReq[1]/@groupBy', 'int')
SET @distribution = @input.value('/WebReport_AuditTrailReportReq[1]/@distribution', 'int')
SET @searchString = @input.value('/WebReport_AuditTrailReportReq[1]/@searchString', 'NVARCHAR(MAX)')
SET @reportFilter = CAST(@input.query('/WebReport_AuditTrailReportReq[1]/reportFilter') as NVARCHAR(MAX))
SET @language = @input.value('/WebReport_AuditTrailReportReq[1]/localeId[1]/@language', 'NVARCHAR(MAX)')
SET @country = @input.value('/WebReport_AuditTrailReportReq[1]/localeId[1]/@country', 'NVARCHAR(MAX)')
SET @includeAudit = @input.value('/WebReport_AuditTrailReportReq[1]/@includeAudit', 'int')
SET @includeEvent = @input.value('/WebReport_AuditTrailReportReq[1]/@includeEvent', 'int')
SET @locId	=  @input.value('/WebReport_AuditTrailReportReq[1]/localeId[1]/@localeId', 'int')
SET @svrInfo	= @lowLevel
SET @svrMinor	= @mediumLevel
SET @svrMajor	= @highLevel
SET @svrCritical= @criticalLevel
IF @svrInfo > 0
	INSERT INTO @tblSeverity VALUES(0)
IF @svrMinor > 0
	INSERT INTO @tblSeverity VALUES(1)
IF @svrMajor > 0
	INSERT INTO @tblSeverity VALUES(2)
IF @svrCritical > 0
	INSERT INTO @tblSeverity VALUES(3)
if ((select COUNT(WRUsersCount.value('@val', 'nvarchar(MAX)')) as val from @input.nodes('/WebReport_AuditTrailReportReq[1]/users') users (WRUsersCount))>0)
BEGIN
	SET @userOutput=
			  (SELECT id AS '@userId'
				 FROM (select UMUsers.id id from UMUsers,@input.nodes('/WebReport_AuditTrailReportReq[1]/users') users (WRUsers) where WRUsers.value('@val', 'nvarchar(MAX)') like UMUsers.name) blah2
				 FOR XML PATH('usersList'),TYPE)
END
ELSE
BEGIN
	SET @userOutput=
			  (select
				  (SELECT 1 AS '@include'
					 FOR XML PATH('flags'),TYPE)
				 FOR XML PATH('usersList'),TYPE)
END
if ((select COUNT(WRUserGroupsCount.value('@val', 'nvarchar(MAX)')) as val from @input.nodes('/WebReport_AuditTrailReportReq[1]/galaxyUserGroups') userGroups (WRUserGroupsCount))>0)
BEGIN
	SET @userGroupsOutput=
			  (SELECT id AS '@userGroupId'
				 FROM (select UMGroups.id id from UMGroups,@input.nodes('/WebReport_AuditTrailReportReq[1]/galaxyUserGroups') userGroups (WRUserGroups) where WRUserGroups.value('@val', 'nvarchar(MAX)') like UMGroups.name) blah2
				 FOR XML PATH('galaxyUserGroups'),TYPE)
END
ELSE
BEGIN
	SET @userGroupsOutput=
			  (select
				  (SELECT 1 AS '@include'
					 FOR XML PATH('flags'),TYPE)
				 FOR XML PATH('galaxyUserGroups'),TYPE)
END
if ((select COUNT(WRExternalUserGroupsCount.value('@val', 'nvarchar(MAX)')) as val from @input.nodes('/WebReport_AuditTrailReportReq[1]/externalUserGroups') externalUserGroups (WRExternalUserGroupsCount))>0)
BEGIN
	SET @externalUserGroupOutput=
			  (SELECT id AS '@userGroupId'
				 FROM (select UMDSgroups.id id from UMDSgroups,@input.nodes('/WebReport_AuditTrailReportReq[1]/externalUserGroups') externalUserGroups (WRExternalUserGroups) where WRExternalUserGroups.value('@val', 'nvarchar(MAX)') like UMDSgroups.name) blah3
				 FOR XML PATH('externalUserGroups'),TYPE)
END
ELSE
BEGIN
	SET @externalUserGroupOutput=
			  (select
				  (SELECT 1 AS '@include'
					 FOR XML PATH('flags'),TYPE)
				 FOR XML PATH('externalUserGroups'),TYPE)
END
SET @feedIntoEvGuiAuditGetMsg_i_userIdList=(select (
	select (
		select @userOutput, @userGroupsOutput, @externalUserGroupOutput
		FOR XML PATH('reportOption'),TYPE)
	FOR XML PATH('adminOpts'),TYPE)
FOR XML PATH('TMMsg_JobOption'),TYPE)
-- SET NOCOUNT ON added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
--DECLARE @i_userIdList XML='<TMMsg_JobOption><adminOpts><reportOption><usersList userId="2"></usersList><usersList userId="4"></usersList></reportOption></adminOpts></TMMsg_JobOption>'
--DECLARE @userIdHandle int
--EXEC sp_xml_preparedocument @userIdHandle OUTPUT, @i_userIdList
--SELECT	userId FROM OPENXML (@userIdHandle, '/TMMsg_JobOption/adminOpts/reportOption/usersList', 1)
--		WITH (userId integer)
if object_id('tempdb.dbo.#tempOpCount') is not null DROP TABLE #tempOpCount
if object_id('tempdb.dbo.#EvGuiAuditGetMsgTable') is not null DROP TABLE #EvGuiAuditGetMsgTable
create table #tempOpCount ( opId int, msgSpanNum int)
CREATE TABLE #EvGuiAuditGetMsgTable (
  o_evMsgId			int,
  o_locId			int,
  o_commcellId		int,
  o_userId			int,
  o_time			int,
  o_messageId		int,
  o_opId			int,
  o_paramId			int,
  o_auditLevel		int,
  o_entityType		int,
  o_entityId		int,
  o_oldMsgId		int,
  o_newMsgId		int,
  o_msgSpanNum		int,
  o_isList			int,
  o_listOptype		int,
  o_hierarchyLevel	integer,
  o_msgText			nvarchar(MAX),
  o_oldValue		nvarchar(MAX),
  o_newValue		nvarchar(MAX))
DECLARE @intermediateConversionVar nvarchar(MAX)=CAST(@feedIntoEvGuiAuditGetMsg_i_userIdList AS nvarchar(MAX))
INSERT INTO #EvGuiAuditGetMsgTable EXEC EvGuiAuditGetMsg 0,5,@searchString,@intermediateConversionVar,0
-- timeFrameType can be 0 (startTime and endTime set) or 1 (relative)
IF @timeFrameType = 1
BEGIN
    -- frequency can be     Daily= 1,Weekly= 2,Monthly= 3,Hourly= 4,Yearly= 6
   IF @frequency = 6 BEGIN
        SET @reqStartTime  = dbo.GetUnixTime(DATEADD(year, -(@numberOfPeriods), GetUTCDate()))
        SET @reqEndTime    = dbo.GetUnixTime(GetUTCDate())
    END
    ELSE IF @frequency = 4 BEGIN
        SET @reqStartTime  = dbo.GetUnixTime(DATEADD(hour, -(@numberOfPeriods), GetUTCDate()))
        SET @reqEndTime    = dbo.GetUnixTime(GetUTCDate())
    END
    ELSE IF @frequency = 3 BEGIN
        SET @reqStartTime  = dbo.GetUnixTime(DATEADD(month, -(@numberOfPeriods), GetUTCDate()))
        SET @reqEndTime    = dbo.GetUnixTime(GetUTCDate())
    END
    ELSE IF @frequency = 2 BEGIN
        SET @reqStartTime  = dbo.GetUnixTime(DATEADD(week, -(@numberOfPeriods), GetUTCDate()))
        SET @reqEndTime    = dbo.GetUnixTime(GetUTCDate())
    END
    ELSE IF @frequency = 1 BEGIN
        SET @reqStartTime  = dbo.GetUnixTime(DATEADD(day, -(@numberOfPeriods), GetUTCDate()))
        SET @reqEndTime    = dbo.GetUnixTime(GetUTCDate())
    END
END
if (@searchString='')
	BEGIN
	IF	@jobId IS NULL or @jobId=0
		INSERT INTO @tblEventMsgs
		SELECT	id, jobId_l, severity, timeSource, subsystem, client, messageId, ISNULL(Message, DBO.fn_EvFormatEventMsgText(id, @locId, MessageId, 1,2))
		FROM	EvMsg	LEFT OUTER JOIN EvMsgCache ON EvMsgId = id AND LocaleId = @locId
				JOIN @tblSeverity ON severity = t_severity
		WHERE	timeSource >= @reqStartTime AND timeSource <= @reqEndTime AND type <> 2
	--		AND dbo.isVisible(@userId, jobId_l, EvMsg.CommcellId, clientId, userID, libraryId, maClientId, mediaId, driveId) > 0
	ELSE
		INSERT INTO @tblEventMsgs
		SELECT	id, jobId_l, severity, timeSource, subsystem, client, messageId, ISNULL(Message, DBO.fn_EvFormatEventMsgText(id, @locId, MessageId, 1,2))
		FROM	EvMsg	LEFT OUTER JOIN EvMsgCache ON EvMsgId = id AND LocaleId = @locId
				JOIN @tblSeverity ON severity = t_severity
		WHERE	jobId_l = @jobId
			AND timeSource >= @reqStartTime AND timeSource <= @reqEndTime AND type <> 2
			AND	dbo.isClientVisibleEvents(@userId, jobId_l, EvMsg.CommcellId, clientId, userID, libraryId, maClientId, mediaId, driveId) > 0
	END
else
	BEGIN
	IF	@jobId IS NULL or @jobId=0
		INSERT INTO @tblEventMsgs
		SELECT	id, jobId_l, severity, timeSource, subsystem, client, messageId, ISNULL(Message, DBO.fn_EvFormatEventMsgText(id, @locId, MessageId, 1,2))
		FROM	EvMsg	LEFT OUTER JOIN EvMsgCache ON EvMsgId = id AND LocaleId = @locId
				JOIN @tblSeverity ON severity = t_severity
		WHERE	timeSource >= @reqStartTime AND timeSource <= @reqEndTime AND type <> 2 AND (Message like '%'+@searchString+'%' OR DBO.fn_EvFormatEventMsgText(id, @locId, MessageId, 1,2) like '%'+@searchString+'%')
	--		AND dbo.isVisible(@userId, jobId_l, EvMsg.CommcellId, clientId, userID, libraryId, maClientId, mediaId, driveId) > 0
	ELSE
		INSERT INTO @tblEventMsgs
		SELECT	id, jobId_l, severity, timeSource, subsystem, client, messageId, ISNULL(Message, DBO.fn_EvFormatEventMsgText(id, @locId, MessageId, 1,2))
		FROM	EvMsg	LEFT OUTER JOIN EvMsgCache ON EvMsgId = id AND LocaleId = @locId
				JOIN @tblSeverity ON severity = t_severity
		WHERE	jobId_l = @jobId
			AND timeSource >= @reqStartTime AND timeSource <= @reqEndTime AND type <> 2  AND (Message like '%'+@searchString+'%' OR DBO.fn_EvFormatEventMsgText(id, @locId, MessageId, 1,2) like '%'+@searchString+'%')
			AND	dbo.isClientVisibleEvents(@userId, jobId_l, EvMsg.CommcellId, clientId, userID, libraryId, maClientId, mediaId, driveId) > 0
	END
--select @reqStartTime,@reqEndTime
--select * from UMUsers
--select * from #EvGuiAuditGetMsgTable order by o_messageId
--select * from EvMsg order by messageId
update @tblEventMsgs set severity=4-severity
DECLARE @auditTrailReport XML
DECLARE @auditTrailReportTopN XML
IF @includeAudit = 1
BEGIN
SET @auditTrailReport =
(SELECT o_opId as '@ID',o_auditLevel as '@severityLevel',o_time as '@time',
REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
       o_msgText
,NCHAR(1),N'?'),NCHAR(2),N'?'),NCHAR(3),N'?'),NCHAR(4),N'?'),NCHAR(5),N'?'),NCHAR(6),N'?'),NCHAR(7),N'?'),NCHAR(8),N'?'),NCHAR(11),N'?'),NCHAR(12),N'?'),NCHAR(14),N'?'),NCHAR(15),N'?'),NCHAR(16),N'?'),NCHAR(17),N'?'),NCHAR(18),N'?'),NCHAR(19),N'?'),NCHAR(20),N'?'),NCHAR(21),N'?'),NCHAR(22),N'?'),NCHAR(23),N'?'),NCHAR(24),N'?'),NCHAR(25),N'?'),NCHAR(26),N'?'),NCHAR(27),N'?'),NCHAR(28),N'?'),NCHAR(29),N'?'),NCHAR(30),N'?'),NCHAR(31),N'?') as '@operation',
				(SELECT o_userId as '@userId',
                    name AS '@userName'
				from UMUsers where id=o_userId
				FOR XML PATH('user'), TYPE),
     (SELECT
REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
       o_msgText
,NCHAR(1),N'?'),NCHAR(2),N'?'),NCHAR(3),N'?'),NCHAR(4),N'?'),NCHAR(5),N'?'),NCHAR(6),N'?'),NCHAR(7),N'?'),NCHAR(8),N'?'),NCHAR(11),N'?'),NCHAR(12),N'?'),NCHAR(14),N'?'),NCHAR(15),N'?'),NCHAR(16),N'?'),NCHAR(17),N'?'),NCHAR(18),N'?'),NCHAR(19),N'?'),NCHAR(20),N'?'),NCHAR(21),N'?'),NCHAR(22),N'?'),NCHAR(23),N'?'),NCHAR(24),N'?'),NCHAR(25),N'?'),NCHAR(26),N'?'),NCHAR(27),N'?'),NCHAR(28),N'?'),NCHAR(29),N'?'),NCHAR(30),N'?'),NCHAR(31),N'?') as '@val'
     from #EvGuiAuditGetMsgTable innerTable where innerTable.o_opId=outerTable.o_opId and innerTable.o_paramId!=0
      FOR XML PATH('detail'),TYPE)
     from #EvGuiAuditGetMsgTable outerTable where o_paramId=0 AND (@reqStartTime=0 OR o_time>@reqStartTime) AND (@reqEndTime=0 OR o_time<@reqEndTime) AND
			((o_auditLevel=4 AND @lowLevel=1) OR (o_auditLevel=3 AND @mediumLevel=1) OR (o_auditLevel=2 AND @highLevel=1) OR (o_auditLevel=1 AND @criticalLevel=1))
			order by o_time desc
	FOR XML PATH('auditTrailEntries'),TYPE)
SET @auditTrailReportTopN =
(SELECT COUNT(o_auditLevel) as '@count', o_messageId as '@type',o_auditLevel as '@severityLevel'
     from #EvGuiAuditGetMsgTable outerTable
     where o_paramId=0 AND (@reqStartTime=0 OR o_time>@reqStartTime) AND (@reqEndTime=0 OR o_time<@reqEndTime) AND
		((o_auditLevel=4 AND @lowLevel=1) OR
		 (o_auditLevel=3 AND @mediumLevel=1) OR
		 (o_auditLevel=2 AND @highLevel=1) OR
		 (o_auditLevel=1 AND @criticalLevel=1))
     group by o_auditLevel,o_messageId
	FOR XML PATH('auditTrailTopNEntries'),TYPE)
END
DECLARE @eventReport XML
DECLARE @eventReportTopN XML
IF @includeEvent = 1
BEGIN
SET @eventReport=
			(SELECT tm.Id as '@ID',tm.messageId as '@type',tm.jobId as '@jobID',tm.severity as '@severityLevel',tm.time as '@time',
		    tm.subsystem as '@program',tm.client as '@computer',tm.msgText as '@description'
			from @tblEventMsgs tm order by tm.time desc
				FOR XML PATH('eventEntries'),TYPE)
SET @eventReportTopN =
			(SELECT COUNT(tm.messageId) as '@count', tm.messageId as '@type',tm.severity as '@severityLevel' from @tblEventMsgs tm
			 group by tm.messageId,tm.severity
				FOR XML PATH('eventTopNEntries'),TYPE)
END
SELECT
(SELECT @timeFrameType        AS '@timeFrameType',
            @frequency        AS '@frequency',
            @numberOfPeriods  AS '@numberOfPeriods',
            @reqStartTime     AS '@startTime',
            @reqEndTime       AS '@endTime',
            @lowLevel         AS '@lowLevel',
            @mediumLevel      AS '@mediumLevel',
            @highLevel        AS '@highLevel',
            @criticalLevel    AS '@criticalLevel',
            @includeAllEntities    AS '@includeAllEntities',
            @groupBy		  AS '@groupBy',
            @distribution     AS '@distribution',
            @searchString     AS '@searchString',
            (SELECT @language as '@language',
                    @country AS '@country'
            FOR XML PATH('localeId'), TYPE),
            (SELECT null
            FOR XML PATH('reportFilter'), TYPE)
			FOR XML PATH('req'),TYPE),
			@auditTrailReport,
			@auditTrailReportTopN,
			@eventReport,
			@eventReportTopN
FOR XML PATH('WebReport_AuditTrailReportResp')
if object_id('tempdb.dbo.#tempOpCount') is not null DROP TABLE #tempOpCount
if object_id('tempdb.dbo.#EvGuiAuditGetMsgTable') is not null DROP TABLE #EvGuiAuditGetMsgTable
GO

IF EXISTS (select * from GxQscripts where name = 'wr_AuditReport')
	delete from GxQscripts where name = 'wr_AuditReport'
GO

IF EXISTS (select * from GXDBVersions where aliasname='wr_AuditReport')
	delete from GXDBVersions where aliasname = 'wr_AuditReport'
GO

insert into GXDBVersions values(2, 'wr_AuditReport',  '00010005000200030000', 'wr_AuditReport', '00010005000200030000')
GO

