

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/updateEXMB_DM_61.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/updateEXMB_DM_61.sp,v $ $Id: updateEXMB_DM_61.sp,v 1.8.278.1 2018/03/27 08:15:44 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: updateEXMB_DM_61 <<<'

IF EXISTS (select * from sysobjects where name='updateEXMB_DM_61')
	drop procedure updateEXMB_DM_61
IF EXISTS (select * from GxQscripts where name='updateEXMB_DM_61')
	delete from GxQscripts where name = 'updateEXMB_DM_61'
GO

IF EXISTS (select * from GXDBVersions where aliasname='updateEXMB_DM_61')
	delete from GXDBVersions where aliasname = 'updateEXMB_DM_61'
GO
print '... Creating Procedure: updateEXMB_DM_61'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure updateEXMB_DM_61
  @commcellId int
AS
  DECLARE @retVal INTEGER;
  DECLARE @errString varchar(256);
--This will turn off message: 'xxx rows affected'.
SET NOCOUNT ON
IF object_id('tempdb.dbo.#EXSC_AFFIN') IS NOT Null
    DROP TABLE #EXSC_AFFIN
-- LOCAL VARIABLES AND ASSIGNMENTS-----
DECLARE @nowTime integer
DECLARE @ASSOC_WILDCARD			   nvarchar(512)
DECLARE @ASSOC_STORES			   nvarchar(512)
DECLARE @STORGRP_AFFIN             nvarchar(512)
DECLARE @ACTIVDIR_AFFIN            nvarchar(512)
DECLARE @REGEX_AFFIN               nvarchar(512)
DECLARE @CV_EXCH_ENABLE_DISCOVERY  nvarchar(512)
SET @ASSOC_WILDCARD = 'Associated Wildcard Expression'
SET @ASSOC_STORES   = 'Associated Stores'
SET @CV_EXCH_ENABLE_DISCOVERY = 'Enable Dicovery'
SET @STORGRP_AFFIN	      = 'Storage Group Auto Discover'
SET @ACTIVDIR_AFFIN	      = 'Active Directory Group Auto Discover'
SET @REGEX_AFFIN  	      = 'Active Directory WildCard Auto Discover'
SET @nowTime 		      = dbo.GetUnixTime (GetUTCdate())
CREATE TABLE #EXSC_AFFIN
(backupSetId     integer,
 subClientId     integer,
 subClientStatus integer,
 appType         integer,
 affinType       integer,
)
---------------------------------------------------------------
-- CREATE A LIST OF SUCLIENTS WITH AUTO DISCOVERY ATTRIBUTES --
---------------------------------------------------------------
 INSERT INTO #EXSC_AFFIN
  SELECT  DISTINCT
	  0,
          componentNameId,
          0,
          0,
          0
  FROM    APP_SubClientProp
 where attrName = @ASSOC_WILDCARD or attrName = @ASSOC_STORES
update #EXSC_AFFIN
set BackupSetId = backupset,
    appType     =AP.appTypeId,
    subClientStatus = AP.subClientStatus
from  APP_Application AS AP
WHERE subClientId = AP.id
---------------------------------------------------------------------------
-- Don't care about any subClients that have been uninstalled or deleted --
---------------------------------------------------------------------------
DELETE #EXSC_AFFIN
where (subClientStatus & 6) <> 0              -- UNINSTALLED(2)/DELETED(4)
--Find out IF any affinities have been set for these subClients --
UPDATE #EXSC_AFFIN
SET affinType = 1
WHERE EXISTS (select * from APP_SubClientProp where componentNameId=subClientId AND attrName=@ASSOC_STORES AND modified = 0 AND LEN(attrVal) > 0)
-- For some reason, an empty wildcard attribute has a single quote {') character, so need to check for length > 1 in case affinity type had changed
UPDATE #EXSC_AFFIN
SET affinType = 2
WHERE EXISTS (select * from APP_SubClientProp where componentNameId=subClientId AND attrName=@ASSOC_WILDCARD AND modified = 0 AND LEN(attrVal) > 1)
DELETE #EXSC_AFFIN WHERE affinType = 0
----------------------------------------------------
-- NOW WE HAVE TO LOOP THROUGH ALL THE BACKUPSETS --
----------------------------------------------------
DECLARE backupsets_cursor CURSOR
FOR
   SELECT distinct backupSetId from #EXSC_AFFIN
OPEN backupsets_cursor
DECLARE @thisBackupsetId integer
DECLARE @thisAffinity integer
FETCH NEXT FROM backupsets_cursor INTO @thisBackupsetId
WHILE (@@FETCH_STATUS = 0)
BEGIN
	--------------------------------------------------------------
	--  ASSUMING THAT DEFAULT SUBCLIENT WILL BE PICKED 1ST FROM --
	--  ANY AFFINITIES SET FOR SUBCLIENTS IN THIS BACKUPSET,    --
	--  CHOOSE A DEFAULT AFFINITY, IF ANY FOR THE BACKUPSET     --
	--------------------------------------------------------------
   Set @thisAffinity = (select top 1 affinType
                          From #EXSC_AFFIN
                          Where backupsetid = @thisbackupsetId
			  ORDER BY subClientId
		)
/*  Following for default backupset, but don't need to be this complicated
    (check for default subClient 1st, then all others next)
    Set @thisAffinity = (select top 1 affinType
                          From #EXSC_AFFIN
                          Where backupsetid = @thisbackupsetId
                           AND ((subClientStatus & 8) <> 0)
		)
*/
	-- IN 6.1, We need All the Affinity types represented in BackupSetProps for ea. backupSet --
    INSERT APP_BackupSetProp VALUES (@thisBackupsetId, @STORGRP_AFFIN,  2, 0, @nowTime, 0, 0)
    INSERT APP_BackupSetProp VALUES (@thisBackupsetId, @ACTIVDIR_AFFIN, 2, 0, @nowTime, 0, 0)
    INSERT APP_BackupSetProp VALUES (@thisBackupsetId, @REGEX_AFFIN,    2, 0, @nowTime, 0, 0)
	-- Only Enable One of the (3) above Affin types. Note only (2) types were avail. in 5.9 --
    IF @thisAffinity = 1
    	UPDATE APP_BackupSetProp Set attrVal='1' WHERE componentNameID=@thisBackupsetId AND attrName = @STORGRP_AFFIN
	ELSE IF @thisAffinity = 2
    	UPDATE APP_BackupSetProp Set attrVal='1' WHERE componentNameID=@thisBackupsetId AND attrName = @REGEX_AFFIN
	-- IF ANY AFFINITY WAS SET, NEED TO SET 'ENABLE DISCOVERY' OPTION TOO --
	IF @thisAffinity > 0
	BEGIN
		IF EXISTS (Select * from APP_BackupSetProp WHERE componentNameID=@thisBackupsetId AND attrName = @CV_EXCH_ENABLE_DISCOVERY)
			UPDATE APP_BackupSetProp Set modified = @nowTime
			      WHERE componentNameID=@thisBackupsetId AND attrName = @CV_EXCH_ENABLE_DISCOVERY
	    INSERT APP_BackupSetProp VALUES (@thisBackupsetId, @CV_EXCH_ENABLE_DISCOVERY,   2, 1, @nowTime, 0, 0)
	END
    FETCH NEXT FROM backupsets_cursor INTO @thisBackupsetId
END
CLOSE backupsets_cursor
DEALLOCATE backupsets_cursor
--  DEBUG   select * from #EXSC_AFFIN  order by subClientid
DROP table #EXSC_AFFIN
set @retVal = 0
set @errString = ''
SELECT   @retVal, @errString
RETURN   @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'updateEXMB_DM_61')
	delete from GxQscripts where name = 'updateEXMB_DM_61'
GO

IF EXISTS (select * from GXDBVersions where aliasname='updateEXMB_DM_61')
	delete from GXDBVersions where aliasname = 'updateEXMB_DM_61'
GO

insert into GXDBVersions values(2, 'updateEXMB_DM_61',  '00010008027800010000', 'updateEXMB_DM_61', '00010008027800010000')
GO

