

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/sybIsBackedUp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |      Cursor:  sybIsBackedUp()
--  |
--  |Description:   Finds the latest FULL backup of the given databased id based
--  |				on the given restore time.
--  |
--  |       Input:  instanceid, commcellid, subclientid, databaseId, databasename,
--  |				jobId, bkupLevel
--	|
--  |      Output:  Returns the following columns:
--  |                archFileId archGroupdId, stream, maxStream, archFile.ctime
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        param      Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: sybIsBackedUp <<<'

IF EXISTS (select * from sysobjects where name='sybIsBackedUp')
	drop procedure sybIsBackedUp
IF EXISTS (select * from GxQscripts where name='sybIsBackedUp')
	delete from GxQscripts where name = 'sybIsBackedUp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sybIsBackedUp')
	delete from GXDBVersions where aliasname = 'sybIsBackedUp'
GO
print '... Creating Procedure: sybIsBackedUp'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure sybIsBackedUp
  @i_instanceId integer,
  @i_commCellId integer,
  @i_subclientId integer,
  @i_databaseId integer,
  @i_databaseName char(64),
  @i_jobId integer,
  @i_backupLevel integer
AS
-- Following are the "columns" returned, in the order in which they are returned
  DECLARE @archFileId integer;
  DECLARE @archGroupId integer;
  DECLARE @stream integer;
  DECLARE @maxStream integer;
  DECLARE @archFileCTime integer
-- These lines represent the actual SQL code that will get executed.
BEGIN
	 SET NOCOUNT ON
DECLARE @i_backupCopy integer
SET @i_backupCopy = 0
IF 	 @i_backupLevel = 2048
BEGIN
SET @i_backupLevel = 1
SET @i_backupCopy = 1
END
select archFile.id, archGroupId, stream, maxStream, archFile.ctime from sybArchFileInfo, archFile
				where sybInstanceId = @i_instanceId
				and sybArchFileInfo.commCellID	= @i_commCellID
				and sybSubClientId = @i_subclientId
				and appId = sybSubClientId
				and sybdatabaseId = @i_databaseId
				and sybdatabaseName = @i_databaseName
				and archFile.backupLevel = @i_backupLevel
				and sybArchFileInfo.commCellID	= @i_commCellID
				and sybArchFileInfo.sybBackupJobId_l = @i_jobId
				and archFile.id = sybArchFileInfo.archFileId
				and archFile.commCellID	= sybArchFileInfo.commCellID
				and (@i_backupCopy = 0 OR (archFile.flags) & 4 = 4)
				ORDER BY archFile.ctime desc
-- Tell the AWK processor that there are no more input lines to scan
END
GO

IF EXISTS (select * from GxQscripts where name = 'sybIsBackedUp')
	delete from GxQscripts where name = 'sybIsBackedUp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='sybIsBackedUp')
	delete from GXDBVersions where aliasname = 'sybIsBackedUp'
GO

insert into GXDBVersions values(2, 'sybIsBackedUp',  '00000000000000000000', 'sybIsBackedUp', '00000000000000000000')
GO

